/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.core;

import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.openspcoop2.core.diagnostica.utils.XMLUtilsException;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XPathException;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.transazioni.bean.ArchivioZipFileUploadBean;
import org.openspcoop2.web.monitor.transazioni.bean.ContenutiTransazioneArchivioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerArchivioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneArchivioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.core.DeserializerTransazioni;
import org.openspcoop2.web.monitor.transazioni.core.exception.ArchivioZipException;
import org.openspcoop2.web.monitor.transazioni.mbean.TracciaBean;
import org.richfaces.model.UploadItem;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class ArchivioZipManager {
    private static final String MANIFEST_KEY_CONTENT_TYPE = "ContentType";
    private static final String MANIFEST_KEY_CONTENT_LENGTH = "ContentLength";
    private static final String MANIFEST_KEY_MESSAGE_TYPE = "MessageType";
    private static final String MANIFEST_KEY_TRANSACTION_ID = "TransactionId";
    private static final String MANIFEST_KEY_PROTOCOL = "Protocol";
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static final String NOME_FILE_SEARCH_FILTER_XML = "SearchFilter.xml";
    private static final String NOME_FILE_MANIFEST_XML = "manifest.xml";
    private static final String NOME_FILE_MSG_DIAGNOSTICI_XML = "diagnostici.xml";
    private static final String NOME_FILE_TRACCE_XML = "tracce.xml";
    private static final String NOME_FILE_FAULT_COOPERAZIONE = "faultCooperazione";
    private static final String NOME_FILE_FAULT_INTEGRAZIONE = "faultIntegrazione";
    private static final String NOME_FILE_FAULT = "fault";
    private static final String NOME_FILE_FAULT_ULTIMO_ERRORE = "faultUltimoErrore";
    private static final String ROOT_FOLDER_TRANSAZIONI = "Transazioni";
    private static final String FOLDER_CONTENUTI = "contenuti";
    private static final String FOLDER_CONSEGNE = "consegne";
    private static final String FOLDER_STORICO = "storico";
    private static final String NOME_FILE_HEADERS_TXT = "headers";
    private static final String NOME_FILE_MANIFEST_TXT = "manifest";
    private static final String NOME_FILE_MESSAGE = "message";
    private static final String NOME_FILE_CONTENTS = "contents";
    private static final String NOME_FILE_MESSAGE_MULTIPART_HEADERS = "message_multipart_headers";
    private static final String NOME_FILE_ALLEGATO_MULTIPART_HEADERS = "allegato_multipart_headers";
    private static final String NOME_FILE_ALLEGATO = "allegato";
    private static final String NOME_FILE_ALLEGATI = "allegati";
    private Map<String, TransazioneArchivioBean> mapTransazioni = new HashMap<String, TransazioneArchivioBean>();
    private boolean headersAsProperties = true;
    private boolean contenutiAsProperties = false;
    private boolean exportTracceUseProtocolSerialization = false;
    private boolean exportDiagnosticiUseProtocolSerialization = false;
    private boolean inizializzaInformazioniSupplementari = false;
    private static final long MAX_ZIP_SIZE = 5000000000000L;
    private static final long MAX_NUMBER_ENTRY = 10000L;
    private static final long UNCOMPRESS_COMPRESS_RATIO = 10L;

    public ArchivioZipManager() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.headersAsProperties = govwayMonitorProperties.isAttivoTransazioniExportHeaderAsProperties();
            this.contenutiAsProperties = govwayMonitorProperties.isAttivoTransazioniExportContenutiAsProperties();
        }
        catch (Exception e) {
            log.error("Inizializzazione ArchivioZipManager fallita, setto enableHeaderInfo=false", (Throwable)e);
        }
    }

    public void clear() {
        this.mapTransazioni.clear();
        this.setInizializzaInformazioniSupplementari(false);
    }

    public void leggiArchivio(ArchivioZipFileUploadBean archivioZip) throws ArchivioZipException {
        this.setInizializzaInformazioniSupplementari(false);
        if (archivioZip.getMapElementiRicevuti().isEmpty()) {
            throw new ArchivioZipException(MessageManager.getInstance().getMessage("transazioni.search.esaminaArchivioZip.messaggioErrore.fileNonIndicato"));
        }
        for (Map.Entry fileCaricatoEntry : archivioZip.getMapElementiRicevuti().entrySet()) {
            boolean checkAcceptedType;
            UploadItem fileCaricato = (UploadItem)fileCaricatoEntry.getValue();
            String fileName = fileCaricato.getFileName();
            if (fileCaricato.getContentType() != null && !(checkAcceptedType = archivioZip.checkAcceptedType(fileCaricato.getContentType()))) {
                throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.fileNonValido", new Object[]{fileName}));
            }
            this.leggiArchivio(fileCaricato);
            this.elaboraDiagnosticiETracce();
            this.elaboraConsegne();
        }
    }

    public void leggiArchivio(UploadItem uploadItem) throws ArchivioZipException {
        String fileName = uploadItem.getFileName();
        long entryRead = 0L;
        long totalSize = 0L;
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(uploadItem.getData()));){
            ZipEntry entry;
            String chiave = null;
            String chiaveConsegna = null;
            while ((entry = zis.getNextEntry()) != null) {
                int bytesRead;
                if (++entryRead > 10000L) {
                    throw new ArchivioZipException("numero di entry dell'archivio zip troppo grande >= 10000");
                }
                log.debug("Analisi file: {}", (Object)entry.getName());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int entrySize = 0;
                while ((bytesRead = zis.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    if (!((double)(entrySize += bytesRead) / (double)entry.getCompressedSize() >= 10.0)) continue;
                    throw new IOException("Compress ratio to high (Zip bomb?) >= 10");
                }
                byte[] fileContent = outputStream.toByteArray();
                if ((totalSize += (long)fileContent.length) > 5000000000000L) {
                    throw new ArchivioZipException("archivio zip troppo grande (Zip bomb?) >= 5000000000000");
                }
                if (entry.getName().endsWith(File.separatorChar + NOME_FILE_SEARCH_FILTER_XML)) {
                    log.debug("File filtro: {}", (Object)entry.getName());
                }
                chiave = ArchivioZipManager.extractKeyFromPath(entry.getName());
                log.debug("Estratto ID transazione: {}", (Object)chiave);
                if (chiave != null) {
                    chiaveConsegna = this.estraiChiaveConsegna(entry, chiave);
                    this.estraiFileManifest(entry, chiave, chiaveConsegna, fileContent);
                    this.estraiDiagnostici(entry, chiave, chiaveConsegna, fileContent);
                    this.estraiFaultCooperazione(entry, chiave, chiaveConsegna, fileContent);
                    this.estraiFaultIntegrazione(entry, chiave, chiaveConsegna, fileContent);
                    this.estraiFaultUltimoErrore(entry, chiave, chiaveConsegna, fileContent);
                    this.estraiFault(entry, chiave, chiaveConsegna, fileContent);
                    this.estraiTracce(entry, chiave, chiaveConsegna, fileContent);
                    this.estraiContenuti(entry, chiave, chiaveConsegna, fileContent);
                }
                zis.closeEntry();
            }
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.fileContenutoNonValido", new Object[]{fileName}));
        }
    }

    private void elaboraDiagnosticiETracce() throws ArchivioZipException {
        for (Map.Entry<String, TransazioneArchivioBean> transazioneEntry : this.mapTransazioni.entrySet()) {
            TransazioneArchivioBean transazioneArchivioBean = transazioneEntry.getValue();
            TransazioneBean transazioneBean = transazioneArchivioBean.getTransazioneBean();
            String idTransazione = transazioneEntry.getKey();
            this.elaboraTracce(transazioneArchivioBean, transazioneBean, idTransazione);
            this.elaboraDiagnostici(transazioneArchivioBean, transazioneBean, idTransazione);
        }
    }

    private void elaboraDiagnostici(TransazioneArchivioBean transazioneArchivioBean, TransazioneBean transazioneBean, String idTransazione) throws ArchivioZipException {
        if (transazioneArchivioBean.getDiagnosticiRaw() != null) {
            try {
                log.debug("Estraggo informazioni diagnostici per la transazione {}:", (Object)idTransazione);
                List<MsgDiagnostico> diagnostici = DeserializerTransazioni.readMsgDiagnostici(transazioneArchivioBean.getDiagnosticiRaw(), transazioneBean, null, this.exportDiagnosticiUseProtocolSerialization, log);
                log.debug("Lettura diagnostici completata.");
                if (!diagnostici.isEmpty()) {
                    transazioneArchivioBean.getDiagnostici().addAll(diagnostici);
                }
            }
            catch (JAXBException | IOException | ParserConfigurationException | TransformerException | XMLUtilsException | ProtocolException | XMLException | XPathException | XPathNotValidException | SAXException e) {
                this.logError((Exception)e);
                throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneDiagnosticiNonValido", new Object[]{idTransazione}));
            }
        }
    }

    private void elaboraTracce(TransazioneArchivioBean transazioneArchivioBean, TransazioneBean transazioneBean, String idTransazione) throws ArchivioZipException {
        if (transazioneArchivioBean.getTracceRaw() != null) {
            try {
                log.debug("Decodifica tracce per la transazione {}:", (Object)idTransazione);
                List<TracciaBean> tracce = DeserializerTransazioni.readTracce(transazioneArchivioBean.getTracceRaw(), transazioneBean, this.exportTracceUseProtocolSerialization, log);
                log.debug("Lettura tracce completata.");
                if (!tracce.isEmpty()) {
                    transazioneArchivioBean.getTracce().addAll(tracce);
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | org.openspcoop2.core.tracciamento.utils.XMLUtilsException | ProtocolException | XMLException | XPathException | XPathNotValidException | SAXException e) {
                this.logError((Exception)e);
                throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneTracceNonValido", new Object[]{idTransazione}));
            }
        }
    }

    private void elaboraConsegne() throws ArchivioZipException {
        for (Map.Entry<String, TransazioneArchivioBean> transazioneEntry : this.mapTransazioni.entrySet()) {
            String idTransazione = transazioneEntry.getKey();
            TransazioneArchivioBean transazioneArchivioBean = transazioneEntry.getValue();
            TransazioneBean transazioneBean = transazioneArchivioBean.getTransazioneBean();
            if (transazioneArchivioBean.getConsegne().isEmpty()) continue;
            HashMap<String, TransazioneApplicativoServerArchivioBean> mapConChiaviCorrette = new HashMap<String, TransazioneApplicativoServerArchivioBean>();
            for (Map.Entry<String, TransazioneApplicativoServerArchivioBean> consegnaEntry : transazioneArchivioBean.getConsegne().entrySet()) {
                TransazioneApplicativoServerArchivioBean transazioneApplicativoServerArchivioBean = consegnaEntry.getValue();
                TransazioneApplicativoServerBean transazioneApplicativoServerBean = transazioneApplicativoServerArchivioBean.getTransazioneApplicativoServerBean();
                String nomeSA = transazioneApplicativoServerBean.getNomeServizioApplicativoErogatore();
                if (transazioneApplicativoServerBean.getProtocollo() == null) {
                    transazioneApplicativoServerBean.setProtocollo(transazioneBean.getProtocollo());
                }
                this.elaboraDiagnosticiConsegna(idTransazione, transazioneBean, transazioneApplicativoServerArchivioBean, transazioneApplicativoServerBean, nomeSA);
                mapConChiaviCorrette.put(transazioneApplicativoServerBean.getNomeServizioApplicativoErogatore(), transazioneApplicativoServerArchivioBean);
            }
            transazioneArchivioBean.getConsegne().clear();
            transazioneArchivioBean.getConsegne().putAll(mapConChiaviCorrette);
        }
    }

    private void elaboraDiagnosticiConsegna(String idTransazione, TransazioneBean transazioneBean, TransazioneApplicativoServerArchivioBean transazioneApplicativoServerArchivioBean, TransazioneApplicativoServerBean transazioneApplicativoServerBean, String nomeSA) throws ArchivioZipException {
        if (transazioneApplicativoServerArchivioBean.getDiagnosticiRaw() != null) {
            try {
                log.debug("Estraggo informazioni diagnostici per la consegna {} della transazione {}:", (Object)nomeSA, (Object)idTransazione);
                List<MsgDiagnostico> diagnostici = DeserializerTransazioni.readMsgDiagnostici(transazioneApplicativoServerArchivioBean.getDiagnosticiRaw(), transazioneBean, transazioneApplicativoServerBean, this.exportDiagnosticiUseProtocolSerialization, log);
                log.debug("Lettura diagnostici completata.");
                if (!diagnostici.isEmpty()) {
                    transazioneApplicativoServerArchivioBean.getDiagnostici().addAll(diagnostici);
                }
            }
            catch (JAXBException | IOException | ParserConfigurationException | TransformerException | XMLUtilsException | ProtocolException | XMLException | XPathException | XPathNotValidException | SAXException e) {
                this.logError((Exception)e);
                throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneDiagnosticiConsegnaNonValido", new Object[]{nomeSA, idTransazione}));
            }
        }
    }

    private void estraiContenuti(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) throws ArchivioZipException {
        if (entry.getName().contains(File.separatorChar + FOLDER_CONTENUTI)) {
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            if (chiaveConsegna != null) {
                String nomeContenuto;
                String chiaveContenuto;
                String chiaveConsegnaStorico = null;
                if (ArchivioZipManager.isDataStoricoConnettore(entry.getName(), chiave, chiaveConsegna)) {
                    chiaveConsegnaStorico = ArchivioZipManager.extractDataStoricoConnettoreFromPath(entry.getName(), chiave, chiaveConsegna);
                }
                if (chiaveConsegnaStorico != null) {
                    chiaveContenuto = ArchivioZipManager.extractTipoContenutoDataStoricoConnettoreFromPath(entry.getName(), chiave, chiaveConsegna, chiaveConsegnaStorico);
                    nomeContenuto = ArchivioZipManager.extractNomeContenutoDataStoricoFromPath(entry.getName(), chiave, chiaveConsegna, chiaveConsegnaStorico, chiaveContenuto);
                    log.debug("Estraggo contenuto {} per il messaggio {} dello storico data {} della consegna {} della transazione {} dal file {}:", new Object[]{nomeContenuto, chiaveContenuto, chiaveConsegnaStorico, chiaveConsegna, chiave, entry.getName()});
                } else {
                    chiaveContenuto = ArchivioZipManager.extractTipoContenutoConnettoreFromPath(entry.getName(), chiave, chiaveConsegna);
                    nomeContenuto = ArchivioZipManager.extractNomeContenutoConsegnaFromPath(entry.getName(), chiave, chiaveConsegna, chiaveContenuto);
                    log.debug("Estraggo contenuto {} per il messaggio {} della consegna {} della transazione {} dal file {}:", new Object[]{nomeContenuto, chiaveContenuto, chiaveConsegna, chiave, entry.getName()});
                }
                TransazioneApplicativoServerArchivioBean consegnaArchivioBean = transazionearchivioBean.getConsegne().remove(chiaveConsegna);
                if (consegnaArchivioBean == null) {
                    consegnaArchivioBean = new TransazioneApplicativoServerArchivioBean(chiaveConsegna);
                }
                TipoMessaggio tipoMessaggio = ArchivioZipManager.getTipoMessaggioFromDirName(chiaveContenuto);
                Map<TipoMessaggio, ContenutiTransazioneArchivioBean> contenuti = consegnaArchivioBean.getContenuti();
                if (chiaveConsegnaStorico != null) {
                    contenuti = consegnaArchivioBean.getStorico().remove(chiaveConsegnaStorico);
                    if (contenuti == null) {
                        contenuti = new HashMap<TipoMessaggio, ContenutiTransazioneArchivioBean>();
                    }
                    consegnaArchivioBean.getStorico().put(chiaveConsegnaStorico, contenuti);
                }
                this.estraiContenuto(fileContent, chiave, chiaveConsegna, nomeContenuto, tipoMessaggio, contenuti);
                transazionearchivioBean.getConsegne().put(chiaveConsegna, consegnaArchivioBean);
            } else {
                String chiaveContenuto = ArchivioZipManager.extractTipoContenutoFromPath(entry.getName(), chiave);
                String nomeContenuto = ArchivioZipManager.extractNomeContenutoFromPath(entry.getName(), chiave, chiaveContenuto);
                log.debug("Estraggo contenuto {} per il messaggio {} per la transazione {} dal file {}:", new Object[]{nomeContenuto, chiaveContenuto, chiave, entry.getName()});
                TipoMessaggio tipoMessaggio = ArchivioZipManager.getTipoMessaggioFromDirName(chiaveContenuto);
                Map<TipoMessaggio, ContenutiTransazioneArchivioBean> contenuti = transazionearchivioBean.getContenuti();
                this.estraiContenuto(fileContent, chiave, chiaveConsegna, nomeContenuto, tipoMessaggio, contenuti);
            }
            this.mapTransazioni.put(chiave, transazionearchivioBean);
        }
    }

    private void estraiContenuto(byte[] fileContent, String chiave, String chiaveConsegna, String nomeContenuto, TipoMessaggio tipoMessaggio, Map<TipoMessaggio, ContenutiTransazioneArchivioBean> contenuti) throws ArchivioZipException {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean = contenuti.remove(tipoMessaggio);
        if (contenutiTransazioneArchivioBean == null) {
            contenutiTransazioneArchivioBean = new ContenutiTransazioneArchivioBean();
        }
        if (nomeContenuto != null) {
            try {
                this.estraiHeadersContenuto(fileContent, nomeContenuto, contenutiTransazioneArchivioBean);
                this.estraiHeadersMultipartContenuto(fileContent, nomeContenuto, contenutiTransazioneArchivioBean);
                this.estraiContenutiContenuto(fileContent, nomeContenuto, contenutiTransazioneArchivioBean);
                this.estraiManifestContenuto(fileContent, nomeContenuto, contenutiTransazioneArchivioBean);
                if (nomeContenuto.contains(NOME_FILE_MESSAGE)) {
                    contenutiTransazioneArchivioBean.setMessage(fileContent);
                }
                if (nomeContenuto.contains(NOME_FILE_ALLEGATI)) {
                    this.estratiAllegato(fileContent, chiave, chiaveConsegna, nomeContenuto, contenutiTransazioneArchivioBean);
                }
            }
            catch (JAXBException | IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logError((Exception)e);
                throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneContenutoNonValido", new Object[]{nomeContenuto, chiave}));
            }
        }
        contenuti.put(tipoMessaggio, contenutiTransazioneArchivioBean);
    }

    private void estraiManifestContenuto(byte[] fileContent, String nomeContenuto, ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean) throws IOException {
        if (nomeContenuto.contains(NOME_FILE_MANIFEST_TXT)) {
            Map<String, String> contenutiToMap = DeserializerTransazioni.readManifestContenutiToMap(fileContent);
            contenutiTransazioneArchivioBean.setContentType(ArchivioZipManager.readFromMap(contenutiToMap, MANIFEST_KEY_CONTENT_TYPE, String.class));
            contenutiTransazioneArchivioBean.setContentLength(ArchivioZipManager.readFromMap(contenutiToMap, MANIFEST_KEY_CONTENT_LENGTH, Long.class));
            contenutiTransazioneArchivioBean.setMessageType(ArchivioZipManager.readFromMap(contenutiToMap, MANIFEST_KEY_MESSAGE_TYPE, String.class));
            contenutiTransazioneArchivioBean.setTransactionId(ArchivioZipManager.readFromMap(contenutiToMap, MANIFEST_KEY_TRANSACTION_ID, String.class));
            contenutiTransazioneArchivioBean.setProtocol(ArchivioZipManager.readFromMap(contenutiToMap, MANIFEST_KEY_PROTOCOL, String.class));
        }
    }

    private void estraiContenutiContenuto(byte[] fileContent, String nomeContenuto, ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean) throws IOException, JAXBException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        List<DumpContenuto> contenutiXml;
        if (nomeContenuto.contains(NOME_FILE_CONTENTS) && !(contenutiXml = DeserializerTransazioni.readContenutiXml(fileContent, this.contenutiAsProperties)).isEmpty()) {
            contenutiTransazioneArchivioBean.getContenuti().addAll(contenutiXml);
        }
    }

    private void estraiHeadersMultipartContenuto(byte[] fileContent, String nomeContenuto, ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean) throws IOException, JAXBException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        List<DumpMultipartHeader> multipartHeaderXml;
        if (nomeContenuto.contains(NOME_FILE_MESSAGE_MULTIPART_HEADERS) && !(multipartHeaderXml = DeserializerTransazioni.readMultipartHeaderXml(fileContent, this.headersAsProperties)).isEmpty()) {
            contenutiTransazioneArchivioBean.getHeadersMultiPart().addAll(multipartHeaderXml);
        }
    }

    private void estraiHeadersContenuto(byte[] fileContent, String nomeContenuto, ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean) throws IOException, JAXBException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        List<DumpHeaderTrasporto> headersTrasportoXml;
        if (nomeContenuto.contains(NOME_FILE_HEADERS_TXT) && !(headersTrasportoXml = DeserializerTransazioni.readHeadersTrasportoXml(fileContent, this.headersAsProperties)).isEmpty()) {
            contenutiTransazioneArchivioBean.getHeaders().addAll(headersTrasportoXml);
        }
    }

    private void estratiAllegato(byte[] fileContent, String chiave, String chiaveConsegna, String nomeContenuto, ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean) throws ArchivioZipException {
        String idAllegato = null;
        idAllegato = chiaveConsegna != null ? ArchivioZipManager.extractIdAllegatoConsegnaFromPath(nomeContenuto, chiave, chiaveConsegna, nomeContenuto) : ArchivioZipManager.extractIdAllegatoFromPath(nomeContenuto, chiave, nomeContenuto);
        try {
            List<DumpHeaderAllegato> allegatoHeaderXml;
            DumpAllegato dumpAllegato = contenutiTransazioneArchivioBean.getAllegati().remove(idAllegato);
            if (dumpAllegato == null) {
                dumpAllegato = new DumpAllegato();
            }
            if (nomeContenuto.contains(NOME_FILE_ALLEGATO_MULTIPART_HEADERS) && (allegatoHeaderXml = DeserializerTransazioni.readAllegatoHeaderXml(fileContent, this.contenutiAsProperties)) != null && !allegatoHeaderXml.isEmpty()) {
                dumpAllegato.getHeader().addAll(allegatoHeaderXml);
            }
            if (nomeContenuto.contains("allegato.")) {
                dumpAllegato.setAllegato(fileContent);
            }
            contenutiTransazioneArchivioBean.getAllegati().put(idAllegato, dumpAllegato);
        }
        catch (JAXBException | IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logError((Exception)e);
            if (chiaveConsegna == null) {
                throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneAllegatoNonValido", new Object[]{idAllegato, chiave}));
            }
            throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneAllegatoConsegnaNonValido", new Object[]{idAllegato, chiaveConsegna, chiave}));
        }
    }

    private void estraiTracce(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) {
        if (entry.getName().endsWith(File.separatorChar + NOME_FILE_TRACCE_XML)) {
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            if (chiaveConsegna != null) {
                log.warn("non dovrebbe esistere un file tracce per la consegna {} della transazione {} dal file {}:", new Object[]{chiaveConsegna, chiave, entry.getName()});
            } else {
                log.debug("Estraggo informazioni tracce raw per la transazione {} dal file {}:", (Object)chiave, (Object)entry.getName());
                transazionearchivioBean.setTracceRaw(fileContent);
                log.debug("Lettura tracce raw completata.");
            }
            this.mapTransazioni.put(chiave, transazionearchivioBean);
        }
    }

    private void estraiFaultIntegrazione(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) {
        if (entry.getName().contains(File.separatorChar + NOME_FILE_FAULT_INTEGRAZIONE)) {
            String fault = new String(fileContent);
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            if (chiaveConsegna != null) {
                log.warn("non dovrebbe esistere un faultIntegrazione per la consegna {} della transazione {} dal file {}:", new Object[]{chiaveConsegna, chiave, entry.getName()});
            } else {
                log.debug("Estraggo informazioni faultIntegrazione per la transazione {} dal file {}:", (Object)chiave, (Object)entry.getName());
                TransazioneBean transazioneBean = transazionearchivioBean.getTransazioneBean();
                if (transazioneBean == null) {
                    transazioneBean = new TransazioneBean();
                    transazionearchivioBean.setTransazioneBean(transazioneBean);
                }
                transazioneBean.setFaultIntegrazione(fault);
            }
            this.mapTransazioni.put(chiave, transazionearchivioBean);
        }
    }

    private void estraiFaultCooperazione(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) {
        if (entry.getName().contains(File.separatorChar + NOME_FILE_FAULT_COOPERAZIONE)) {
            String fault = new String(fileContent);
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            if (chiaveConsegna != null) {
                log.warn("non dovrebbe esistere un faultCooperazione per la consegna {} della transazione {} dal file {}:", new Object[]{chiaveConsegna, chiave, entry.getName()});
            } else {
                log.debug("Estraggo informazioni faultCooperazione per la transazione {} dal file {}:", (Object)chiave, (Object)entry.getName());
                TransazioneBean transazioneBean = transazionearchivioBean.getTransazioneBean();
                if (transazioneBean == null) {
                    transazioneBean = new TransazioneBean();
                    transazionearchivioBean.setTransazioneBean(transazioneBean);
                }
                transazioneBean.setFaultCooperazione(fault);
            }
            this.mapTransazioni.put(chiave, transazionearchivioBean);
        }
    }

    private void estraiFaultUltimoErrore(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) {
        if (entry.getName().contains(File.separatorChar + NOME_FILE_FAULT_ULTIMO_ERRORE)) {
            String fault = new String(fileContent);
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            if (chiaveConsegna != null) {
                TransazioneApplicativoServerBean transazioneApplicativoServerBean;
                log.debug("Estraggo informazioni faultUltimoErrore per la consegna {} della transazione {} dal file {}:", new Object[]{chiaveConsegna, chiave, entry.getName()});
                TransazioneApplicativoServerArchivioBean consegnaArchivioBean = transazionearchivioBean.getConsegne().remove(chiaveConsegna);
                if (consegnaArchivioBean == null) {
                    consegnaArchivioBean = new TransazioneApplicativoServerArchivioBean(chiaveConsegna);
                }
                if ((transazioneApplicativoServerBean = consegnaArchivioBean.getTransazioneApplicativoServerBean()) == null) {
                    transazioneApplicativoServerBean = new TransazioneApplicativoServerBean();
                    consegnaArchivioBean.setTransazioneApplicativoServerBean(transazioneApplicativoServerBean);
                }
                transazioneApplicativoServerBean.setFaultUltimoErrore(fault);
                transazionearchivioBean.getConsegne().put(chiaveConsegna, consegnaArchivioBean);
            } else {
                log.warn("non dovrebbe esistere un faultUltimoErrore non associato a nessuna consegna per la transazione {} dal file {}:", (Object)chiave, (Object)entry.getName());
            }
            this.mapTransazioni.put(chiave, transazionearchivioBean);
        }
    }

    private void estraiFault(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) {
        if (entry.getName().contains(File.separatorChar + "fault.")) {
            String fault = new String(fileContent);
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            if (chiaveConsegna != null) {
                TransazioneApplicativoServerBean transazioneApplicativoServerBean;
                log.debug("Estraggo informazioni fault per la consegna {} della transazione {} dal file {}:", new Object[]{chiaveConsegna, chiave, entry.getName()});
                TransazioneApplicativoServerArchivioBean consegnaArchivioBean = transazionearchivioBean.getConsegne().remove(chiaveConsegna);
                if (consegnaArchivioBean == null) {
                    consegnaArchivioBean = new TransazioneApplicativoServerArchivioBean(chiaveConsegna);
                }
                if ((transazioneApplicativoServerBean = consegnaArchivioBean.getTransazioneApplicativoServerBean()) == null) {
                    transazioneApplicativoServerBean = new TransazioneApplicativoServerBean();
                    consegnaArchivioBean.setTransazioneApplicativoServerBean(transazioneApplicativoServerBean);
                }
                transazioneApplicativoServerBean.setFault(fault);
                transazionearchivioBean.getConsegne().put(chiaveConsegna, consegnaArchivioBean);
            } else {
                log.warn("non dovrebbe esistere un fault non associato a nessuna consegna per la transazione {} dal file {}:", (Object)chiave, (Object)entry.getName());
            }
            this.mapTransazioni.put(chiave, transazionearchivioBean);
        }
    }

    private void estraiDiagnostici(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) {
        if (entry.getName().endsWith(File.separatorChar + NOME_FILE_MSG_DIAGNOSTICI_XML)) {
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            if (chiaveConsegna != null) {
                log.debug("Estraggo informazioni diagnostici raw per la consegna {} della transazione {} dal file {}:", new Object[]{chiaveConsegna, chiave, entry.getName()});
                TransazioneApplicativoServerArchivioBean consegnaArchivioBean = transazionearchivioBean.getConsegne().remove(chiaveConsegna);
                if (consegnaArchivioBean == null) {
                    consegnaArchivioBean = new TransazioneApplicativoServerArchivioBean(chiaveConsegna);
                }
                consegnaArchivioBean.setDiagnosticiRaw(fileContent);
                log.debug("Lettura diagnostici raw completata.");
                transazionearchivioBean.getConsegne().put(chiaveConsegna, consegnaArchivioBean);
            } else {
                log.debug("Estraggo informazioni diagnostici raw per la transazione {} dal file {}:", (Object)chiave, (Object)entry.getName());
                transazionearchivioBean.setDiagnosticiRaw(fileContent);
                log.debug("Lettura diagnostici raw completata.");
            }
            this.mapTransazioni.put(chiave, transazionearchivioBean);
        }
    }

    private void estraiFileManifest(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent) throws ArchivioZipException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (entry.getName().endsWith(File.separatorChar + NOME_FILE_MANIFEST_XML)) {
            TransazioneArchivioBean transazionearchivioBean = this.mapTransazioni.remove(chiave);
            if (transazionearchivioBean == null) {
                transazionearchivioBean = new TransazioneArchivioBean(chiave);
            }
            try {
                if (chiaveConsegna != null) {
                    this.estraiManifestConsegna(entry, chiave, chiaveConsegna, fileContent, transazionearchivioBean);
                } else {
                    this.estraiManifestTransazione(entry, chiave, fileContent, transazionearchivioBean);
                }
                this.mapTransazioni.put(chiave, transazionearchivioBean);
            }
            catch (JAXBException | IOException | UtilsException e) {
                this.logError((Exception)e);
                if (chiaveConsegna == null) {
                    throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneManifestNonValido", new Object[]{chiave}));
                }
                throw new ArchivioZipException(MessageManager.getInstance().getMessageWithParamsFromResourceBundle("transazioni.search.esaminaArchivioZip.messaggioErrore.elementoTransazioneManifestConsegnaNonValido", new Object[]{chiaveConsegna, chiave}));
            }
        }
    }

    private void estraiManifestTransazione(ZipEntry entry, String chiave, byte[] fileContent, TransazioneArchivioBean transazionearchivioBean) throws UtilsException, JAXBException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        log.debug("Estraggo informazioni transazione {} dal file {}:", (Object)chiave, (Object)entry.getName());
        TransazioneBean transazioneBean = DeserializerTransazioni.readManifestTransazione(fileContent);
        log.debug("oggetto transazione bean creato.");
        if (transazionearchivioBean.getTransazioneBean() != null) {
            TransazioneBean transazioneBean2 = transazionearchivioBean.getTransazioneBean();
            transazioneBean.setFaultCooperazione(transazioneBean2.getFaultCooperazione());
            transazioneBean.setFaultIntegrazione(transazioneBean2.getFaultIntegrazione());
        }
        transazionearchivioBean.setTransazioneBean(transazioneBean);
    }

    private void estraiManifestConsegna(ZipEntry entry, String chiave, String chiaveConsegna, byte[] fileContent, TransazioneArchivioBean transazionearchivioBean) throws JAXBException, UtilsException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        log.debug("Estraggo informazioni consegna {} della transazione {} dal file {}:", new Object[]{chiaveConsegna, chiave, entry.getName()});
        TransazioneApplicativoServerBean transazioneApplicativoServerBean = DeserializerTransazioni.readManifestTransazioneApplicativoServer(fileContent);
        log.debug("oggetto transazione bean creato.");
        TransazioneApplicativoServerArchivioBean consegnaArchivioBean = transazionearchivioBean.getConsegne().remove(chiaveConsegna);
        if (consegnaArchivioBean == null) {
            consegnaArchivioBean = new TransazioneApplicativoServerArchivioBean(chiaveConsegna);
        }
        if (consegnaArchivioBean.getTransazioneApplicativoServerBean() != null) {
            TransazioneApplicativoServerBean transazioneApplicativoServerBean2 = consegnaArchivioBean.getTransazioneApplicativoServerBean();
            transazioneApplicativoServerBean.setFault(transazioneApplicativoServerBean2.getFault());
            transazioneApplicativoServerBean.setFaultUltimoErrore(transazioneApplicativoServerBean2.getFaultUltimoErrore());
        }
        transazioneApplicativoServerBean.setId((long)transazionearchivioBean.getConsegne().size() + 1L);
        consegnaArchivioBean.setTransazioneApplicativoServerBean(transazioneApplicativoServerBean);
        transazionearchivioBean.getConsegne().put(chiaveConsegna, consegnaArchivioBean);
    }

    private String estraiChiaveConsegna(ZipEntry entry, String chiave) {
        String chiaveConsegna = null;
        if (entry.getName().contains(File.separatorChar + FOLDER_CONSEGNE)) {
            chiaveConsegna = ArchivioZipManager.extractNomeConnettoreFromPath(entry.getName(), chiave);
            log.debug("Estratto ID Connettore: {}", (Object)chiaveConsegna);
        }
        return chiaveConsegna;
    }

    private static String extractKeyFromPath(String path) {
        int endIndex;
        int transazioniIndex = path.indexOf(ROOT_FOLDER_TRANSAZIONI + File.separatorChar);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + (ROOT_FOLDER_TRANSAZIONI + File.separatorChar).length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return null;
    }

    private static String extractTipoContenutoFromPath(String path, String chiave) {
        int endIndex;
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeContenuto.length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return null;
    }

    private static String extractNomeConnettoreFromPath(String path, String chiave) {
        int endIndex;
        String pathToNomeConnettore = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar;
        int transazioniIndex = path.indexOf(pathToNomeConnettore);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeConnettore.length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return null;
    }

    private static boolean isDataStoricoConnettore(String path, String chiave, String connettore) {
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar + connettore + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + FOLDER_STORICO + File.separatorChar;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        return transazioniIndex != -1;
    }

    private static String extractDataStoricoConnettoreFromPath(String path, String chiave, String connettore) {
        int endIndex;
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar + connettore + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + FOLDER_STORICO + File.separatorChar;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeContenuto.length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return null;
    }

    private static String extractTipoContenutoDataStoricoConnettoreFromPath(String path, String chiave, String connettore, String dataConsegna) {
        int endIndex;
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar + connettore + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + FOLDER_STORICO + File.separatorChar + dataConsegna + File.separator;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeContenuto.length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return null;
    }

    private static String extractNomeContenutoDataStoricoFromPath(String path, String chiave, String connettore, String dataConsegna, String contenuto) {
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar + connettore + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + FOLDER_STORICO + File.separatorChar + dataConsegna + File.separatorChar + contenuto + File.separator;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeContenuto.length());
        }
        return path;
    }

    private static String extractTipoContenutoConnettoreFromPath(String path, String chiave, String connettore) {
        int endIndex;
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar + connettore + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeContenuto.length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return null;
    }

    private static String extractNomeContenutoFromPath(String path, String chiave, String contenuto) {
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + contenuto + File.separator;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeContenuto.length());
        }
        return path;
    }

    private static String extractNomeContenutoConsegnaFromPath(String path, String chiave, String connettore, String contenuto) {
        String pathToNomeContenuto = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar + connettore + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + contenuto + File.separator;
        int transazioniIndex = path.indexOf(pathToNomeContenuto);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToNomeContenuto.length());
        }
        return path;
    }

    private static String extractIdAllegatoFromPath(String path, String chiave, String contenuto) {
        int endIndex;
        String pathToIdAllegato = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + contenuto + File.separator + NOME_FILE_ALLEGATI + File.separator + "allegato_";
        int transazioniIndex = path.indexOf(pathToIdAllegato);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToIdAllegato.length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return path;
    }

    private static String extractIdAllegatoConsegnaFromPath(String path, String chiave, String connettore, String contenuto) {
        int endIndex;
        String pathToIdAllegato = ROOT_FOLDER_TRANSAZIONI + File.separatorChar + chiave + File.separatorChar + FOLDER_CONSEGNE + File.separatorChar + connettore + File.separatorChar + FOLDER_CONTENUTI + File.separatorChar + contenuto + File.separator + NOME_FILE_ALLEGATI + File.separator + "allegato_";
        int transazioniIndex = path.indexOf(pathToIdAllegato);
        if (transazioniIndex != -1) {
            path = path.substring(transazioniIndex + pathToIdAllegato.length());
        }
        if ((endIndex = path.indexOf(File.separatorChar)) != -1) {
            return path.substring(0, endIndex);
        }
        return path;
    }

    public static TipoMessaggio getTipoMessaggioFromDirName(String contenuto) {
        switch (contenuto) {
            case "dati_richiesta_ingresso": {
                return TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO;
            }
            case "dati_richiesta_uscita": {
                return TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO;
            }
            case "dati_risposta_ingresso": {
                return TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO;
            }
            case "dati_risposta_uscita": {
                return TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO;
            }
            case "richiesta_ingresso": {
                return TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO;
            }
            case "richiesta_uscita": {
                return TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO;
            }
            case "risposta_ingresso": {
                return TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO;
            }
            case "risposta_uscita": {
                return TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO;
            }
            case "integration_manager": {
                return TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + contenuto);
    }

    public static <T> T readFromMap(Map<String, String> map, String chiave, Class<T> clazz) {
        T toReturn = null;
        String paramAsString = map.get(chiave);
        if (paramAsString != null) {
            try {
                Constructor<T> constructor = clazz.getConstructor(String.class);
                toReturn = constructor != null ? (T)constructor.newInstance(paramAsString) : (T)clazz.cast(paramAsString);
            }
            catch (Exception e) {
                return toReturn;
            }
        }
        return toReturn;
    }

    public Map<String, TransazioneArchivioBean> getMapTransazioni() {
        return this.mapTransazioni;
    }

    public void logError(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
    }

    public boolean isInizializzaInformazioniSupplementari() {
        return this.inizializzaInformazioniSupplementari;
    }

    public void setInizializzaInformazioniSupplementari(boolean inizializzaInformazioniSupplementari) {
        this.inizializzaInformazioniSupplementari = inizializzaInformazioniSupplementari;
    }
}

