/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.core;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.diagnostica.utils.XMLUtils;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.tracciamento.utils.XMLUtilsException;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.utils.TransactionContentUtils;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticSerializer;
import org.openspcoop2.protocol.basic.tracciamento.TracciaSerializer;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XPathException;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.core.UtilityTransazioni;
import org.openspcoop2.web.monitor.transazioni.core.contents.ContentType;
import org.openspcoop2.web.monitor.transazioni.core.contents.RisorsaType;
import org.openspcoop2.web.monitor.transazioni.core.header.HeaderType;
import org.openspcoop2.web.monitor.transazioni.core.header.ObjectFactory;
import org.openspcoop2.web.monitor.transazioni.core.manifest.ProtocolloType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.RuoloType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.SoggettoType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.TransazioneType;
import org.openspcoop2.web.monitor.transazioni.core.manifest_consegna.ConsegnaType;
import org.openspcoop2.web.monitor.transazioni.mbean.TracciaBean;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeserializerTransazioni {
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_DIAG_SEPARATOR = "###";
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_TYPE_SEPARATOR = " ";

    private DeserializerTransazioni() {
    }

    public static TransazioneBean readManifestTransazione(byte[] fileContent) throws UtilsException, JAXBException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance((Logger)LoggerManager.getPddMonitorCoreLogger());
        return DeserializerTransazioni.readManifestTransazione(fileContent, monitorProperties.isAttivoTransazioniDataAccettazione(), monitorProperties.isDataUscitaRispostaUseDateAfterResponseSent());
    }

    public static TransazioneBean readManifestTransazione(byte[] fileContent, boolean isAttivoTransazioniDataAccettazione, boolean dataUscitaRispostaValorizzataDopoSpedizioneRisposta) throws JAXBException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        JAXBContext jc = JAXBContext.newInstance((String)org.openspcoop2.web.monitor.transazioni.core.manifest.ObjectFactory.class.getPackage().getName());
        TransazioneType transazione = DeserializerTransazioni.estraiOggettoJAXB(fileContent, jc, TransazioneType.class);
        TransazioneBean transazioneBean = new TransazioneBean();
        if (StringUtils.isNotEmpty((CharSequence)transazione.getStato())) {
            transazioneBean.setStato(UtilityTransazioni.escapeXmlValue(transazione.getStato()));
        }
        DeserializerTransazioni.fillRuoloTransazione(transazione, transazioneBean);
        DeserializerTransazioni.fillProtocollo(transazioneBean, transazione);
        TransazioneType.Esito esito = transazione.getEsito();
        if (esito != null && esito.getCodice().intValue() >= 0) {
            transazioneBean.setEsito(esito.getCodice().intValue());
            if (esito.getConsegneMultiple() != null) {
                transazioneBean.setConsegneMultipleInCorso(esito.getConsegneMultiple().intValue());
            }
        }
        if (transazione.getContesto() != null) {
            TransazioneType.Contesto contesto = transazione.getContesto();
            String code = contesto.getCodice();
            transazioneBean.setEsitoContesto(code);
        }
        DeserializerTransazioni.estraiTempiAttraversamentoTransazione(isAttivoTransazioniDataAccettazione, dataUscitaRispostaValorizzataDopoSpedizioneRisposta, transazione, transazioneBean);
        DeserializerTransazioni.estraiDimensioneMessaggiTransazione(transazione, transazioneBean);
        DeserializerTransazioni.estraiDatiDominioTransazione(transazione, transazioneBean);
        DeserializerTransazioni.estraiDatiIntegrazioneCorrelazioneApplicativaTransazione(transazione, transazioneBean);
        if (transazione.getIntegrationManager() != null) {
            TransazioneType.IntegrationManager im = transazione.getIntegrationManager();
            transazioneBean.setOperazioneIm(UtilityTransazioni.escapeXmlValue(im.getOperazione()));
        }
        DeserializerTransazioni.estraiDatiIntegrazioneTransazione(transazione, transazioneBean);
        if (transazione.getServizioApplicativoToken() != null) {
            TransazioneType.ServizioApplicativoToken sa = transazione.getServizioApplicativoToken();
            IDServizioApplicativo tokenClient = new IDServizioApplicativo();
            tokenClient.setNome(sa.getNome());
            IDSoggetto idSoggettoProprietario = new IDSoggetto();
            idSoggettoProprietario.setTipo(sa.getTipoSoggetto());
            idSoggettoProprietario.setNome(sa.getNomeSoggetto());
            tokenClient.setIdSoggettoProprietario(idSoggettoProprietario);
            transazioneBean.setTokenClient(tokenClient);
        }
        if (StringUtils.isNotEmpty((CharSequence)transazione.getEventiGestione())) {
            transazioneBean.setEventiLabel(UtilityTransazioni.escapeXmlValue(transazione.getEventiGestione()));
        }
        transazioneBean.setIdTransazione(transazione.getUuid());
        return transazioneBean;
    }

    private static void estraiDatiIntegrazioneCorrelazioneApplicativaTransazione(TransazioneType transazione, TransazioneBean transazioneBean) {
        if (transazione.getCorrelazioneApplicativa() != null) {
            TransazioneType.CorrelazioneApplicativa correlazioneApplicativa = transazione.getCorrelazioneApplicativa();
            if (StringUtils.isNotEmpty((CharSequence)correlazioneApplicativa.getIdRichiesta())) {
                transazioneBean.setIdCorrelazioneApplicativa(UtilityTransazioni.escapeXmlValue(correlazioneApplicativa.getIdRichiesta()));
            }
            if (StringUtils.isNotEmpty((CharSequence)correlazioneApplicativa.getIdRisposta())) {
                transazioneBean.setIdCorrelazioneApplicativaRisposta(UtilityTransazioni.escapeXmlValue(correlazioneApplicativa.getIdRisposta()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)transazione.getServizioApplicativoFruitore())) {
            transazioneBean.setServizioApplicativoFruitore(UtilityTransazioni.escapeXmlValue(transazione.getServizioApplicativoFruitore()));
        }
        if (StringUtils.isNotEmpty((CharSequence)transazione.getServizioApplicativoErogatore())) {
            transazioneBean.setServizioApplicativoErogatore(UtilityTransazioni.escapeXmlValue(transazione.getServizioApplicativoErogatore()));
        }
    }

    private static void estraiDimensioneMessaggiTransazione(TransazioneType transazione, TransazioneBean transazioneBean) {
        if (transazione.getDimensioneMessaggi() != null) {
            TransazioneType.DimensioneMessaggi dm = transazione.getDimensioneMessaggi();
            if (dm.getRichiestaIngresso() != null) {
                transazioneBean.setRichiestaIngressoBytes(dm.getRichiestaIngresso());
            }
            if (dm.getRichiestaUscita() != null) {
                transazioneBean.setRichiestaUscitaBytes(dm.getRichiestaUscita());
            }
            if (dm.getRispostaIngresso() != null) {
                transazioneBean.setRispostaIngressoBytes(dm.getRispostaIngresso());
            }
            if (dm.getRispostaUscita() != null) {
                transazioneBean.setRispostaUscitaBytes(dm.getRispostaUscita());
            }
        }
    }

    private static void estraiDatiDominioTransazione(TransazioneType transazione, TransazioneBean transazioneBean) {
        if (transazione.getDominio() != null) {
            TransazioneType.Dominio dominio = transazione.getDominio();
            if (dominio.getSoggetto() != null) {
                SoggettoType soggetto = dominio.getSoggetto();
                if (StringUtils.isNotEmpty((CharSequence)soggetto.getTipo())) {
                    transazioneBean.setPddTipoSoggetto(UtilityTransazioni.escapeXmlValue(soggetto.getTipo()));
                }
                if (StringUtils.isNotEmpty((CharSequence)soggetto.getValue())) {
                    transazioneBean.setPddNomeSoggetto(UtilityTransazioni.escapeXmlValue(soggetto.getValue()));
                }
                if (StringUtils.isNotEmpty((CharSequence)soggetto.getIdentificativoPorta())) {
                    transazioneBean.setPddCodice(UtilityTransazioni.escapeXmlValue(soggetto.getIdentificativoPorta()));
                }
                dominio.setSoggetto(soggetto);
            }
            if (dominio.getRuolo() != null) {
                switch (dominio.getRuolo()) {
                    case DELEGATA: {
                        transazioneBean.setPddRuolo(PddRuolo.DELEGATA);
                        break;
                    }
                    case APPLICATIVA: {
                        transazioneBean.setPddRuolo(PddRuolo.APPLICATIVA);
                        break;
                    }
                    case INTEGRATION_MANAGER: {
                        transazioneBean.setPddRuolo(PddRuolo.INTEGRATION_MANAGER);
                        break;
                    }
                    case ROUTER: {
                        transazioneBean.setPddRuolo(PddRuolo.ROUTER);
                    }
                }
            }
            transazioneBean.setClusterId(dominio.getClusterId());
        }
    }

    private static void estraiDatiIntegrazioneTransazione(TransazioneType transazione, TransazioneBean transazioneBean) {
        if (transazione.getDatiIntegrazione() != null) {
            TransazioneType.DatiIntegrazione datiIntegrazione = transazione.getDatiIntegrazione();
            if (datiIntegrazione.getIndirizzoRichiesta() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getIndirizzoRichiesta())) {
                transazioneBean.setLocationRichiesta(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getIndirizzoRichiesta()));
            }
            if (datiIntegrazione.getIndirizzoRisposta() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getIndirizzoRisposta())) {
                transazioneBean.setLocationRisposta(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getIndirizzoRisposta()));
            }
            if (datiIntegrazione.getNomePorta() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getNomePorta())) {
                transazioneBean.setNomePorta(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getNomePorta()));
            }
            if (datiIntegrazione.getCredenziali() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getCredenziali())) {
                transazioneBean.setCredenziali(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getCredenziali()));
            }
            if (datiIntegrazione.getConnettore() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getConnettore())) {
                transazioneBean.setLocationConnettore(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getConnettore()));
            }
            if (datiIntegrazione.getUrlInvocazione() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getUrlInvocazione())) {
                transazioneBean.setUrlInvocazione(StringEscapeUtils.unescapeXml((String)datiIntegrazione.getUrlInvocazione()));
            }
            if (datiIntegrazione.getIndirizzoClient() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getIndirizzoClient())) {
                transazioneBean.setSocketClientAddress(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getIndirizzoClient()));
            }
            if (datiIntegrazione.getXForwardedFor() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getXForwardedFor())) {
                transazioneBean.setTransportClientAddress(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getXForwardedFor()));
            }
            if (datiIntegrazione.getTipoRichiesta() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getTipoRichiesta())) {
                transazioneBean.setTipoRichiesta(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getTipoRichiesta()));
            }
            if (datiIntegrazione.getCodiceRispostaIngresso() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getCodiceRispostaIngresso())) {
                transazioneBean.setCodiceRispostaIngresso(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getCodiceRispostaIngresso()));
            }
            if (datiIntegrazione.getCodiceRispostaUscita() != null && StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getCodiceRispostaUscita())) {
                transazioneBean.setCodiceRispostaUscita(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getCodiceRispostaUscita()));
            }
            if (StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getIdentificativoAutenticato())) {
                transazioneBean.setTrasportoMittenteLabel(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getIdentificativoAutenticato()));
            }
            if (StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getTokenIssuer())) {
                transazioneBean.setTokenIssuerLabel(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getTokenIssuer()));
            }
            if (StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getTokenClientId())) {
                transazioneBean.setTokenClientIdLabel(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getTokenClientId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getTokenSubject())) {
                transazioneBean.setTokenSubjectLabel(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getTokenSubject()));
            }
            if (StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getTokenUsername())) {
                transazioneBean.setTokenUsernameLabel(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getTokenUsername()));
            }
            if (StringUtils.isNotEmpty((CharSequence)datiIntegrazione.getTokenEMail())) {
                transazioneBean.setTokenMailLabel(UtilityTransazioni.escapeXmlValue(datiIntegrazione.getTokenEMail()));
            }
        }
    }

    private static void estraiTempiAttraversamentoTransazione(boolean isAttivoTransazioniDataAccettazione, boolean dataUscitaRispostaValorizzataDopoSpedizioneRisposta, TransazioneType transazione, TransazioneBean transazioneBean) throws JAXBException {
        if (transazione.getTempiAttraversamento() != null) {
            TransazioneType.TempiAttraversamento tempi = transazione.getTempiAttraversamento();
            try {
                if (isAttivoTransazioniDataAccettazione && tempi.getRichiestaAccettazione() != null) {
                    transazioneBean.setDataAccettazioneRichiesta(tempi.getRichiestaAccettazione().toGregorianCalendar().getTime());
                }
                if (tempi.getRichiestaIngresso() != null) {
                    transazioneBean.setDataIngressoRichiesta(tempi.getRichiestaIngresso().toGregorianCalendar().getTime());
                }
                if (tempi.getRichiestaIngressoAcquisita() != null) {
                    transazioneBean.setDataIngressoRichiestaStream(tempi.getRichiestaIngressoAcquisita().toGregorianCalendar().getTime());
                }
                if (tempi.getRichiestaUscita() != null) {
                    transazioneBean.setDataUscitaRichiesta(tempi.getRichiestaUscita().toGregorianCalendar().getTime());
                }
                if (tempi.getRichiestaUscitaConsegnata() != null) {
                    transazioneBean.setDataUscitaRichiestaStream(tempi.getRichiestaUscitaConsegnata().toGregorianCalendar().getTime());
                }
                if (isAttivoTransazioniDataAccettazione && tempi.getRispostaAccettazione() != null) {
                    transazioneBean.setDataAccettazioneRisposta(tempi.getRispostaAccettazione().toGregorianCalendar().getTime());
                }
                if (tempi.getRispostaIngresso() != null) {
                    transazioneBean.setDataIngressoRisposta(tempi.getRispostaIngresso().toGregorianCalendar().getTime());
                }
                if (tempi.getRispostaIngressoAcquisita() != null) {
                    transazioneBean.setDataIngressoRispostaStream(tempi.getRispostaIngressoAcquisita().toGregorianCalendar().getTime());
                }
                if (dataUscitaRispostaValorizzataDopoSpedizioneRisposta) {
                    if (tempi.getRispostaUscita() != null) {
                        transazioneBean.setDataUscitaRispostaStream(tempi.getRispostaUscita().toGregorianCalendar().getTime());
                    }
                    if (tempi.getRispostaUscitaConsegnata() != null) {
                        transazioneBean.setDataUscitaRisposta(tempi.getRispostaUscitaConsegnata().toGregorianCalendar().getTime());
                    }
                } else {
                    if (tempi.getRispostaUscita() != null) {
                        transazioneBean.setDataUscitaRisposta(tempi.getRispostaUscita().toGregorianCalendar().getTime());
                    }
                    if (tempi.getRispostaUscitaConsegnata() != null) {
                        transazioneBean.setDataUscitaRispostaStream(tempi.getRispostaUscitaConsegnata().toGregorianCalendar().getTime());
                    }
                }
                transazioneBean.setLatenzaTotale(tempi.getLatenzaTotale());
                transazioneBean.setLatenzaServizio(tempi.getLatenzaServizio());
                transazioneBean.setLatenzaPorta(tempi.getLatenzaPorta());
                if (transazioneBean.getDataAccettazioneRichiesta() == null) {
                    transazioneBean.setDataAccettazioneRichiesta(transazioneBean.getDataIngressoRichiesta());
                }
                if (transazioneBean.getDataAccettazioneRisposta() == null) {
                    transazioneBean.setDataAccettazioneRisposta(transazioneBean.getDataUscitaRisposta());
                }
            }
            catch (Exception e) {
                throw new JAXBException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void fillRuoloTransazione(TransazioneType transazione, TransazioneBean transazioneBean) {
        if (RuoloType.SCONOSCIUTO.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(-1);
        } else if (RuoloType.INVOCAZIONE_ONEWAY.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(1);
        } else if (RuoloType.INVOCAZIONE_SINCRONA.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(2);
        } else if (RuoloType.INVOCAZIONE_ASINCRONA_SIMMETRICA.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(3);
        } else if (RuoloType.RISPOSTA_ASINCRONA_SIMMETRICA.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(4);
        } else if (RuoloType.INVOCAZIONE_ASINCRONA_ASIMMETRICA.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(5);
        } else if (RuoloType.RICHIESTA_STATO_ASINCRONA_ASIMMETRICA.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(6);
        } else if (RuoloType.INTEGRATION_MANAGER.equals((Object)transazione.getRuolo())) {
            transazioneBean.setRuoloTransazione(7);
        }
    }

    private static void fillProtocollo(TransazioneBean transazioneDest, TransazioneType transazioneSrc) {
        ProtocolloType protocollo = transazioneSrc.getProtocollo();
        if (protocollo != null) {
            transazioneDest.setProtocollo(protocollo.getName());
            DeserializerTransazioni.estraiProtocolloSoggettoFruitore(transazioneDest, protocollo);
            DeserializerTransazioni.estraiProtocolloSoggettoErogatore(transazioneDest, protocollo);
            DeserializerTransazioni.estraiProtocolloServizio(transazioneDest, protocollo);
            DeserializerTransazioni.estraiProtocolloAPI(transazioneDest, protocollo);
            DeserializerTransazioni.estraiProtocolloOperazione(transazioneDest, protocollo);
            if (StringUtils.isNotEmpty((CharSequence)protocollo.getIdMessaggioRichiesta())) {
                transazioneDest.setIdMessaggioRichiesta(UtilityTransazioni.escapeXmlValue(protocollo.getIdMessaggioRichiesta()));
            }
            if (StringUtils.isNotEmpty((CharSequence)protocollo.getIdMessaggioRisposta())) {
                transazioneDest.setIdMessaggioRisposta(UtilityTransazioni.escapeXmlValue(protocollo.getIdMessaggioRisposta()));
            }
            if (protocollo.getDataIdMsgRichiesta() != null) {
                transazioneDest.setDataIdMsgRichiesta(protocollo.getDataIdMsgRichiesta().toGregorianCalendar().getTime());
            }
            if (protocollo.getDataIdMsgRisposta() != null) {
                transazioneDest.setDataIdMsgRisposta(protocollo.getDataIdMsgRisposta().toGregorianCalendar().getTime());
            }
            DeserializerTransazioni.estraiProtocolloProfilo(transazioneDest, protocollo);
            if (StringUtils.isNotEmpty((CharSequence)protocollo.getIdCollaborazione())) {
                transazioneDest.setIdCollaborazione(UtilityTransazioni.escapeXmlValue(protocollo.getIdCollaborazione()));
            }
            if (StringUtils.isNotEmpty((CharSequence)protocollo.getUriAccordoServizio())) {
                transazioneDest.setUriAccordoServizio(UtilityTransazioni.escapeXmlValue(protocollo.getUriAccordoServizio()));
            }
            DeserializerTransazioni.estraiProtocolloProfiloAsincrono(transazioneDest, protocollo);
            DeserializerTransazioni.estraiProtocolloDigest(transazioneDest, protocollo);
            DeserializerTransazioni.estratiProtocolloDuplicati(transazioneDest, protocollo);
        }
    }

    private static void estraiProtocolloProfilo(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getProfilo() != null) {
            ProtocolloType.Profilo profilo = protocollo.getProfilo();
            if (profilo.getValue() != null && StringUtils.isNotEmpty((CharSequence)profilo.getValue())) {
                transazioneDest.setProfiloCollaborazioneProt(UtilityTransazioni.escapeXmlValue(profilo.getValue()));
            }
            if (profilo.getCodice() != null && StringUtils.isNotEmpty((CharSequence)profilo.getCodice())) {
                transazioneDest.setProfiloCollaborazioneOp2(UtilityTransazioni.escapeXmlValue(profilo.getCodice()));
            }
        }
    }

    private static void estratiProtocolloDuplicati(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getDuplicati() != null) {
            ProtocolloType.Duplicati duplicati = protocollo.getDuplicati();
            if (duplicati.getRichiesta() != null) {
                transazioneDest.setDuplicatiRichiesta(duplicati.getRichiesta());
            }
            if (duplicati.getRisposta() != null) {
                transazioneDest.setDuplicatiRisposta(duplicati.getRisposta());
            }
        }
    }

    private static void estraiProtocolloDigest(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getDigest() != null) {
            ProtocolloType.Digest digest = protocollo.getDigest();
            if (digest.getRichiesta() != null && StringUtils.isNotEmpty((CharSequence)digest.getRichiesta())) {
                transazioneDest.setDigestRichiesta(digest.getRichiesta());
            }
            if (digest.getRisposta() != null && StringUtils.isNotEmpty((CharSequence)digest.getRisposta())) {
                transazioneDest.setDigestRisposta(digest.getRisposta());
            }
        }
    }

    private static void estraiProtocolloProfiloAsincrono(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getProfiloAsincrono() != null) {
            ProtocolloType.ProfiloAsincrono profiloAsincrono = protocollo.getProfiloAsincrono();
            if (profiloAsincrono.getIdCorrelazione() != null && StringUtils.isNotEmpty((CharSequence)profiloAsincrono.getIdCorrelazione())) {
                transazioneDest.setIdAsincrono(UtilityTransazioni.escapeXmlValue(profiloAsincrono.getIdCorrelazione()));
            }
            if (profiloAsincrono.getServizioCorrelato() != null) {
                ProtocolloType.ProfiloAsincrono.ServizioCorrelato servizioCorrelato = profiloAsincrono.getServizioCorrelato();
                if (servizioCorrelato.getTipo() != null && StringUtils.isNotEmpty((CharSequence)servizioCorrelato.getTipo())) {
                    transazioneDest.setTipoServizioCorrelato(UtilityTransazioni.escapeXmlValue(servizioCorrelato.getTipo()));
                }
                if (servizioCorrelato.getValue() != null && StringUtils.isNotEmpty((CharSequence)servizioCorrelato.getValue())) {
                    transazioneDest.setNomeServizioCorrelato(UtilityTransazioni.escapeXmlValue(servizioCorrelato.getValue()));
                }
            }
        }
    }

    private static void estraiProtocolloOperazione(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getAzione() != null && StringUtils.isNotEmpty((CharSequence)protocollo.getAzione())) {
            transazioneDest.setAzione(UtilityTransazioni.escapeXmlValue(protocollo.getAzione()));
            transazioneDest.setOperazioneLabel(transazioneDest.getAzione());
        }
    }

    private static void estraiProtocolloAPI(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getApi() != null) {
            ProtocolloType.Api api = protocollo.getApi();
            if (api.getTipo() != null) {
                if (TipoAPI.SOAP.name().equals(api.getTipo())) {
                    transazioneDest.setTipoApi(TipoAPI.SOAP.getValoreAsInt());
                } else {
                    transazioneDest.setTipoApi(TipoAPI.REST.getValoreAsInt());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)api.getNome())) {
                transazioneDest.setUriAccordoServizio(api.getNome());
            }
            if (api.getTags() != null && api.getTags().getTag() != null) {
                List<String> tags = api.getTags().getTag();
                StringBuilder sb = new StringBuilder();
                for (String tag : tags) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(tag);
                }
                transazioneDest.setGruppi(sb.toString());
                transazioneDest.setGruppiLabel(sb.toString());
            }
        }
    }

    private static void estraiProtocolloServizio(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getServizio() != null) {
            ProtocolloType.Servizio servizio = protocollo.getServizio();
            if (servizio.getTipo() != null && StringUtils.isNotEmpty((CharSequence)servizio.getTipo())) {
                transazioneDest.setTipoServizio(UtilityTransazioni.escapeXmlValue(servizio.getTipo()));
            }
            if (servizio.getValue() != null && StringUtils.isNotEmpty((CharSequence)servizio.getValue())) {
                transazioneDest.setNomeServizio(UtilityTransazioni.escapeXmlValue(servizio.getValue()));
            }
            if (servizio.getVersione() != null && StringUtils.isNotEmpty((CharSequence)servizio.getVersione())) {
                transazioneDest.setVersioneServizio(Integer.parseInt(servizio.getVersione()));
            }
        }
    }

    private static void estraiProtocolloSoggettoErogatore(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getErogatore() != null) {
            SoggettoType soggetto = protocollo.getErogatore();
            if (soggetto.getTipo() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getTipo())) {
                transazioneDest.setTipoSoggettoErogatore(UtilityTransazioni.escapeXmlValue(soggetto.getTipo()));
            }
            if (soggetto.getValue() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getValue())) {
                transazioneDest.setNomeSoggettoErogatore(UtilityTransazioni.escapeXmlValue(soggetto.getValue()));
            }
            if (soggetto.getIdentificativoPorta() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getIdentificativoPorta())) {
                transazioneDest.setIdportaSoggettoErogatore(UtilityTransazioni.escapeXmlValue(soggetto.getIdentificativoPorta()));
            }
            if (soggetto.getIndirizzo() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getIndirizzo())) {
                transazioneDest.setIndirizzoSoggettoErogatore(UtilityTransazioni.escapeXmlValue(soggetto.getIndirizzo()));
            }
        }
    }

    private static void estraiProtocolloSoggettoFruitore(TransazioneBean transazioneDest, ProtocolloType protocollo) {
        if (protocollo.getFruitore() != null) {
            SoggettoType soggetto = protocollo.getFruitore();
            if (soggetto.getTipo() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getTipo())) {
                transazioneDest.setTipoSoggettoFruitore(UtilityTransazioni.escapeXmlValue(soggetto.getTipo()));
            }
            if (soggetto.getValue() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getValue())) {
                transazioneDest.setNomeSoggettoFruitore(UtilityTransazioni.escapeXmlValue(soggetto.getValue()));
            }
            if (soggetto.getIdentificativoPorta() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getIdentificativoPorta())) {
                transazioneDest.setIdportaSoggettoFruitore(UtilityTransazioni.escapeXmlValue(soggetto.getIdentificativoPorta()));
            }
            if (soggetto.getIndirizzo() != null && StringUtils.isNotEmpty((CharSequence)soggetto.getIndirizzo())) {
                transazioneDest.setIndirizzoSoggettoFruitore(UtilityTransazioni.escapeXmlValue(soggetto.getIndirizzo()));
            }
        }
    }

    public static TransazioneApplicativoServerBean readManifestTransazioneApplicativoServer(byte[] fileContent) throws JAXBException, UtilsException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance((Logger)LoggerManager.getPddMonitorCoreLogger());
        return DeserializerTransazioni.readManifestTransazioneApplicativoServer(fileContent, monitorProperties.isAttivoTransazioniDataAccettazione());
    }

    public static TransazioneApplicativoServerBean readManifestTransazioneApplicativoServer(byte[] fileContent, boolean isAttivoTransazioniDataAccettazione) throws JAXBException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        JAXBContext jc = JAXBContext.newInstance((String)org.openspcoop2.web.monitor.transazioni.core.manifest_consegna.ObjectFactory.class.getPackage().getName());
        ConsegnaType consegna = DeserializerTransazioni.estraiOggettoJAXB(fileContent, jc, ConsegnaType.class);
        TransazioneApplicativoServerBean transazioneApplicativoServerBean = new TransazioneApplicativoServerBean();
        ConsegnaType.Esito esito = consegna.getEsito();
        if (esito != null) {
            ConsegnaType.Esito.DettaglioEsito dettaglioEsito;
            if (esito.getDettaglioEsito() != null && (dettaglioEsito = esito.getDettaglioEsito()).getCodice() != null) {
                transazioneApplicativoServerBean.setDettaglioEsito(dettaglioEsito.getCodice().intValue());
            }
            transazioneApplicativoServerBean.setConsegnaTerminata(esito.isConsegnaTerminata());
            if (esito.getDataMessaggioScaduto() != null) {
                transazioneApplicativoServerBean.setDataMessaggioScaduto(esito.getDataMessaggioScaduto().toGregorianCalendar().getTime());
            }
            transazioneApplicativoServerBean.setConsegnaTrasparente(esito.isConsegnaTrasparente());
            transazioneApplicativoServerBean.setConsegnaIntegrationManager(esito.isConsegnaIntegrationManager());
        }
        DeserializerTransazioni.estraiTempiAttraversamentoConsegna(isAttivoTransazioniDataAccettazione, consegna, transazioneApplicativoServerBean);
        if (consegna.getDimensioneMessaggi() != null) {
            ConsegnaType.DimensioneMessaggi dm = consegna.getDimensioneMessaggi();
            transazioneApplicativoServerBean.setRichiestaUscitaBytes(dm.getRichiestaUscita());
            transazioneApplicativoServerBean.setRispostaIngressoBytes(dm.getRispostaIngresso());
        }
        DeserializerTransazioni.estraiDatiConsegna(consegna, transazioneApplicativoServerBean);
        DeserializerTransazioni.estraiDatiIMConsegna(consegna, transazioneApplicativoServerBean);
        transazioneApplicativoServerBean.setIdTransazione(UtilityTransazioni.escapeXmlValue(consegna.getIdTransazione()));
        transazioneApplicativoServerBean.setServizioApplicativoErogatore(UtilityTransazioni.escapeXmlValue(consegna.getServizioApplicativoErogatore()));
        if (StringUtils.isNotEmpty((CharSequence)consegna.getNomeConnettore())) {
            transazioneApplicativoServerBean.setConnettoreNome(UtilityTransazioni.escapeXmlValue(consegna.getNomeConnettore()));
        }
        if (consegna.getDataRegistrazione() != null) {
            transazioneApplicativoServerBean.setDataRegistrazione(consegna.getDataRegistrazione().toGregorianCalendar().getTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)consegna.getIdentificativoMessaggio())) {
            transazioneApplicativoServerBean.setIdentificativoMessaggio(UtilityTransazioni.escapeXmlValue(consegna.getIdentificativoMessaggio()));
        }
        if (StringUtils.isNotEmpty((CharSequence)consegna.getClusterIdInCoda())) {
            transazioneApplicativoServerBean.setClusterIdPresaInCarico(UtilityTransazioni.escapeXmlValue(consegna.getClusterIdInCoda()));
        }
        return transazioneApplicativoServerBean;
    }

    private static void estraiTempiAttraversamentoConsegna(boolean isAttivoTransazioniDataAccettazione, ConsegnaType consegna, TransazioneApplicativoServerBean transazioneApplicativoServerBean) {
        if (consegna.getTempiAttraversamento() != null) {
            ConsegnaType.TempiAttraversamento tempi = consegna.getTempiAttraversamento();
            if (isAttivoTransazioniDataAccettazione && tempi.getRichiestaAccettazione() != null) {
                transazioneApplicativoServerBean.setDataAccettazioneRichiesta(tempi.getRichiestaAccettazione().toGregorianCalendar().getTime());
            }
            if (tempi.getRichiestaUscita() != null) {
                transazioneApplicativoServerBean.setDataUscitaRichiesta(tempi.getRichiestaUscita().toGregorianCalendar().getTime());
            }
            if (tempi.getRichiestaUscitaConsegnata() != null) {
                transazioneApplicativoServerBean.setDataUscitaRichiestaStream(tempi.getRichiestaUscitaConsegnata().toGregorianCalendar().getTime());
            }
            if (isAttivoTransazioniDataAccettazione && tempi.getRispostaAccettazione() != null) {
                transazioneApplicativoServerBean.setDataAccettazioneRisposta(tempi.getRispostaAccettazione().toGregorianCalendar().getTime());
            }
            if (tempi.getRispostaIngresso() != null) {
                transazioneApplicativoServerBean.setDataIngressoRisposta(tempi.getRispostaIngresso().toGregorianCalendar().getTime());
            }
            if (tempi.getRispostaIngressoAcquisita() != null) {
                transazioneApplicativoServerBean.setDataIngressoRispostaStream(tempi.getRispostaIngressoAcquisita().toGregorianCalendar().getTime());
            }
        }
    }

    private static void estraiDatiIMConsegna(ConsegnaType consegna, TransazioneApplicativoServerBean transazioneApplicativoServerBean) {
        if (consegna.getDatiIntegrationManager() != null) {
            ConsegnaType.DatiIntegrationManager datiIM = consegna.getDatiIntegrationManager();
            transazioneApplicativoServerBean.setConsegnaIntegrationManager(true);
            if (datiIM.getDataPrimoPrelievo() != null) {
                transazioneApplicativoServerBean.setDataPrimoPrelievoIm(datiIM.getDataPrimoPrelievo().toGregorianCalendar().getTime());
            }
            if (datiIM.getDataPrelievo() != null) {
                transazioneApplicativoServerBean.setDataPrelievoIm(datiIM.getDataPrelievo().toGregorianCalendar().getTime());
            }
            if (datiIM.getNumeroPrelievi() != null) {
                transazioneApplicativoServerBean.setNumeroPrelieviIm(datiIM.getNumeroPrelievi().intValue());
            }
            if (datiIM.getClusterIdPrelievo() != null && !"".equals(datiIM.getClusterIdPrelievo())) {
                transazioneApplicativoServerBean.setClusterIdPrelievoIm(UtilityTransazioni.escapeXmlValue(datiIM.getClusterIdPrelievo()));
            }
            if (datiIM.getDataEliminazione() != null) {
                transazioneApplicativoServerBean.setDataEliminazioneIm(datiIM.getDataEliminazione().toGregorianCalendar().getTime());
            }
            if (datiIM.getClusterIdEliminazione() != null && !"".equals(datiIM.getClusterIdEliminazione())) {
                transazioneApplicativoServerBean.setClusterIdEliminazioneIm(UtilityTransazioni.escapeXmlValue(datiIM.getClusterIdEliminazione()));
            }
        }
    }

    private static void estraiDatiConsegna(ConsegnaType consegna, TransazioneApplicativoServerBean transazioneApplicativoServerBean) {
        if (consegna.getDatiConsegna() != null) {
            ConsegnaType.DatiConsegna datiConsegna = consegna.getDatiConsegna();
            DeserializerTransazioni.estraiDatiUltimoErroreConsegna(transazioneApplicativoServerBean, datiConsegna);
            if (datiConsegna.getConnettore() != null && !"".equals(datiConsegna.getConnettore())) {
                transazioneApplicativoServerBean.setLocationConnettore(StringEscapeUtils.unescapeXml((String)datiConsegna.getConnettore()));
            }
            if (datiConsegna.getCodiceRisposta() != null && !"".equals(datiConsegna.getCodiceRisposta())) {
                transazioneApplicativoServerBean.setCodiceRisposta(UtilityTransazioni.escapeXmlValue(datiConsegna.getCodiceRisposta()));
            }
            if (datiConsegna.getDataPrimoTentativo() != null) {
                transazioneApplicativoServerBean.setDataPrimoTentativo(datiConsegna.getDataPrimoTentativo().toGregorianCalendar().getTime());
            }
            if (datiConsegna.getNumeroTentativi() != null) {
                transazioneApplicativoServerBean.setNumeroTentativi(datiConsegna.getNumeroTentativi().intValue());
            }
            if (datiConsegna.getClusterIdConsegna() != null && !"".equals(datiConsegna.getClusterIdConsegna())) {
                transazioneApplicativoServerBean.setClusterIdConsegna(UtilityTransazioni.escapeXmlValue(datiConsegna.getClusterIdConsegna()));
            }
        }
    }

    private static void estraiDatiUltimoErroreConsegna(TransazioneApplicativoServerBean transazioneApplicativoServerBean, ConsegnaType.DatiConsegna datiConsegna) {
        if (datiConsegna.getUltimoErrore() != null) {
            ConsegnaType.DatiConsegna.UltimoErrore.DettaglioEsito dettaglioEsito;
            ConsegnaType.DatiConsegna.UltimoErrore ultimoErrore = datiConsegna.getUltimoErrore();
            transazioneApplicativoServerBean.setUltimoErrore(StringEscapeUtils.unescapeXml((String)ultimoErrore.getDettaglio()));
            if (ultimoErrore.getDettaglioEsito() != null && (dettaglioEsito = ultimoErrore.getDettaglioEsito()).getCodice() != null) {
                transazioneApplicativoServerBean.setDettaglioEsitoUltimoErrore(dettaglioEsito.getCodice().intValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)ultimoErrore.getConnettore())) {
                transazioneApplicativoServerBean.setLocationUltimoErrore(StringEscapeUtils.unescapeXml((String)ultimoErrore.getConnettore()));
            }
            if (StringUtils.isNotEmpty((CharSequence)ultimoErrore.getCodiceRisposta())) {
                transazioneApplicativoServerBean.setCodiceRispostaUltimoErrore(UtilityTransazioni.escapeXmlValue(ultimoErrore.getCodiceRisposta()));
            }
            if (ultimoErrore.getData() != null) {
                transazioneApplicativoServerBean.setDataUltimoErrore(ultimoErrore.getData().toGregorianCalendar().getTime());
            }
            if (StringUtils.isNotEmpty((CharSequence)ultimoErrore.getClusterId())) {
                transazioneApplicativoServerBean.setClusterIdUltimoErrore(UtilityTransazioni.escapeXmlValue(ultimoErrore.getClusterId()));
            }
        }
    }

    public static List<DumpHeaderTrasporto> readHeadersTrasportoXml(byte[] fileContent, boolean asProperties) throws IOException, JAXBException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<Object> headers = null;
        if (asProperties) {
            headers = new ArrayList<DumpHeaderTrasporto>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileContent)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.trim().isEmpty() || (parts = line.split("=")).length != 2) continue;
                    String nome = parts[0].trim();
                    String valore = parts[1].trim();
                    DumpHeaderTrasporto dumpHeaderTrasporto = new DumpHeaderTrasporto();
                    dumpHeaderTrasporto.setNome(nome);
                    dumpHeaderTrasporto.setValore(valore);
                    headers.add(dumpHeaderTrasporto);
                }
            }
        } else {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType transazione = DeserializerTransazioni.estraiOggettoJAXB(fileContent, jc, org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType.class);
            List<HeaderType> headersTransazione = transazione.getHeader();
            if (headersTransazione != null) {
                headers = new ArrayList();
                for (HeaderType headerType : headersTransazione) {
                    DumpHeaderTrasporto header = new DumpHeaderTrasporto();
                    header.setNome(headerType.getNome());
                    header.setValore(headerType.getValore());
                    headers.add(header);
                }
            }
        }
        return headers;
    }

    public static List<DumpMultipartHeader> readMultipartHeaderXml(byte[] fileContent, boolean asProperties) throws IOException, JAXBException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<Object> headers = null;
        if (asProperties) {
            headers = new ArrayList<DumpMultipartHeader>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileContent)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.trim().isEmpty() || (parts = line.split("=")).length != 2) continue;
                    String nome = parts[0].trim();
                    String valore = parts[1].trim();
                    DumpMultipartHeader dumpHeaderTrasporto = new DumpMultipartHeader();
                    dumpHeaderTrasporto.setNome(nome);
                    dumpHeaderTrasporto.setValore(valore);
                    headers.add(dumpHeaderTrasporto);
                }
            }
        } else {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType transazione = DeserializerTransazioni.estraiOggettoJAXB(fileContent, jc, org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType.class);
            List<HeaderType> headersTransazione = transazione.getHeader();
            if (headersTransazione != null) {
                headers = new ArrayList();
                for (HeaderType headerType : headersTransazione) {
                    DumpMultipartHeader header = new DumpMultipartHeader();
                    header.setNome(headerType.getNome());
                    header.setValore(headerType.getValore());
                    headers.add(header);
                }
            }
        }
        return headers;
    }

    public static List<DumpHeaderAllegato> readAllegatoHeaderXml(byte[] fileContent, boolean asProperties) throws IOException, JAXBException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<Object> headers = null;
        if (asProperties) {
            headers = new ArrayList<DumpHeaderAllegato>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileContent)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.trim().isEmpty() || (parts = line.split("=")).length != 2) continue;
                    String nome = parts[0].trim();
                    String valore = parts[1].trim();
                    DumpHeaderAllegato dumpHeaderTrasporto = new DumpHeaderAllegato();
                    dumpHeaderTrasporto.setNome(nome);
                    dumpHeaderTrasporto.setValore(valore);
                    headers.add(dumpHeaderTrasporto);
                }
            }
        } else {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType transazione = DeserializerTransazioni.estraiOggettoJAXB(fileContent, jc, org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType.class);
            List<HeaderType> headersTransazione = transazione.getHeader();
            if (headersTransazione != null) {
                headers = new ArrayList();
                for (HeaderType headerType : headersTransazione) {
                    DumpHeaderAllegato header = new DumpHeaderAllegato();
                    header.setNome(headerType.getNome());
                    header.setValore(headerType.getValore());
                    headers.add(header);
                }
            }
        }
        return headers;
    }

    public static List<DumpContenuto> readContenutiXml(byte[] fileContent, boolean asProperties) throws IOException, JAXBException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<Object> headers = null;
        if (asProperties) {
            headers = new ArrayList<DumpContenuto>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileContent)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.trim().isEmpty() || (parts = line.split("=")).length != 2) continue;
                    String nome = parts[0].trim();
                    String valore = parts[1].trim();
                    DumpContenuto dumpHeaderTrasporto = new DumpContenuto();
                    dumpHeaderTrasporto.setNome(nome);
                    TransactionContentUtils.setDumpContenutoValue((DumpContenuto)dumpHeaderTrasporto, (String)valore);
                    headers.add(dumpHeaderTrasporto);
                }
            }
        } else {
            JAXBContext jc = JAXBContext.newInstance((String)org.openspcoop2.web.monitor.transazioni.core.contents.ObjectFactory.class.getPackage().getName());
            ContentType transazione = DeserializerTransazioni.estraiOggettoJAXB(fileContent, jc, ContentType.class);
            List<RisorsaType> headersTransazione = transazione.getRisorsa();
            if (headersTransazione != null) {
                headers = new ArrayList();
                for (RisorsaType headerType : headersTransazione) {
                    DumpContenuto header = new DumpContenuto();
                    header.setNome(headerType.getNome());
                    TransactionContentUtils.setDumpContenutoValue((DumpContenuto)header, (String)headerType.getValore());
                    headers.add(header);
                }
            }
        }
        return headers;
    }

    private static <T> T estraiOggettoJAXB(byte[] fileContent, JAXBContext jc, Class<T> clazz) throws JAXBException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (fileContent == null) {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object unmarshal = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(fileContent);){
            unmarshal = unmarshaller.unmarshal((InputStream)bais);
        }
        T transazione = null;
        transazione = unmarshal instanceof JAXBElement ? (T)clazz.cast(((JAXBElement)unmarshal).getValue()) : (T)clazz.cast(unmarshal);
        return transazione;
    }

    public static Map<String, String> readManifestContenutiToMap(byte[] fileContent) throws IOException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileContent)));){
            String line;
            while ((line = br.readLine()) != null) {
                int delimiterIndex;
                if (line.trim().isEmpty() || (delimiterIndex = line.indexOf("=")) == -1) continue;
                String key = line.substring(0, delimiterIndex).trim();
                String value = line.substring(delimiterIndex + 1).trim();
                dataMap.put(key, value);
            }
        }
        return dataMap;
    }

    public static List<MsgDiagnostico> readMsgDiagnostici(byte[] fileContent, TransazioneBean tr, TransazioneApplicativoServerBean tAS, boolean exportDiagnosticiUseProtocolSerialization, Logger log) throws IOException, JAXBException, ProtocolException, ParserConfigurationException, SAXException, org.openspcoop2.core.diagnostica.utils.XMLUtilsException, TransformerException, XMLException, XPathException, XPathNotValidException {
        ArrayList<MsgDiagnostico> msgs = new ArrayList<MsgDiagnostico>();
        Element element = org.openspcoop2.utils.xml.XMLUtils.getInstance().newElement(DeserializerTransazioni.eliminaIntestazioniXmlNonNecessarie(fileContent));
        XPathExpressionEngine xPathEngine = new XPathExpressionEngine();
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace((Node)element);
        try {
            String protocollo = tAS != null ? tAS.getProtocollo() : tr.getProtocollo();
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            Object diagnosticoBuilder = null;
            diagnosticoBuilder = exportDiagnosticiUseProtocolSerialization ? pf.createDiagnosticSerializer() : new DiagnosticSerializer(pf);
            XMLRootElement xmlRootElement = diagnosticoBuilder.getXMLRootElement();
            String rootExpression = "/" + xmlRootElement.getPrefix() + ":" + xmlRootElement.getLocalName();
            Node rootNode = (Node)xPathEngine.getMatchPattern(element, dnc, rootExpression, XPathReturnType.NODE);
            NodeList nodeList = rootNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!XMLUtils.isMessaggioDiagnostico((Node)node)) continue;
                byte[] byteArray = DeserializerTransazioni.nodeToByteArray(node);
                MsgDiagnostico msg = new MsgDiagnostico();
                msg.setMessaggioDiagnostico(XMLUtils.toMessaggioDiagnosticoFromXml((byte[])byteArray));
                msgs.add(msg);
            }
        }
        catch (XPathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return msgs;
    }

    public static List<TracciaBean> readTracce(byte[] fileContent, TransazioneBean tr, boolean exportTracceUseProtocolSerialization, Logger log) throws IOException, SAXException, ParserConfigurationException, XMLException, ProtocolException, XPathException, XPathNotValidException, TransformerException, XMLUtilsException {
        ArrayList<TracciaBean> msgs = new ArrayList<TracciaBean>();
        Element element = org.openspcoop2.utils.xml.XMLUtils.getInstance().newElement(DeserializerTransazioni.eliminaIntestazioniXmlNonNecessarie(fileContent));
        XPathExpressionEngine xPathEngine = new XPathExpressionEngine();
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace((Node)element);
        try {
            String protocollo = tr.getProtocollo();
            ServiceBinding tipoApi = null;
            if (TipoAPI.REST.getValoreAsInt() == tr.getTipoApi()) {
                tipoApi = ServiceBinding.REST;
            } else if (TipoAPI.SOAP.getValoreAsInt() == tr.getTipoApi()) {
                tipoApi = ServiceBinding.SOAP;
            }
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            Object tracciaBuilder = null;
            tracciaBuilder = exportTracceUseProtocolSerialization ? pf.createTracciaSerializer() : new TracciaSerializer(pf);
            XMLRootElement xmlRootElement = tracciaBuilder.getXMLRootElement();
            String rootExpression = "/" + xmlRootElement.getPrefix() + ":" + xmlRootElement.getLocalName();
            Node rootNode = (Node)xPathEngine.getMatchPattern(element, dnc, rootExpression, XPathReturnType.NODE);
            NodeList nodeList = rootNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!org.openspcoop2.core.tracciamento.utils.XMLUtils.isTraccia((Node)node)) continue;
                byte[] byteArray = DeserializerTransazioni.nodeToByteArray(node);
                Traccia t = new Traccia(org.openspcoop2.core.tracciamento.utils.XMLUtils.toTracciaFromXml((byte[])byteArray));
                msgs.add(new TracciaBean(t, tipoApi));
            }
        }
        catch (XPathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return msgs;
    }

    private static byte[] nodeToByteArray(Node node) throws TransformerException, XMLException {
        TransformerFactory transformerFactory = org.openspcoop2.utils.xml.XMLUtils.getInstance().getTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(byteArrayOutputStream);
        DOMSource source = new DOMSource(node);
        transformer.transform(source, result);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] eliminaIntestazioniXmlNonNecessarie(byte[] inputBytes) {
        int endHeader;
        String xmlContent = new String(inputBytes, StandardCharsets.UTF_8).trim();
        String header = "";
        if (xmlContent.startsWith("<?") && (endHeader = xmlContent.indexOf("?>")) != -1) {
            header = xmlContent.substring(0, endHeader + 2);
            xmlContent = xmlContent.substring(endHeader + 2);
        }
        xmlContent = xmlContent.replaceAll("<\\?xml[^>]+\\?>", "").trim();
        String cleanedXml = header + "\n" + xmlContent;
        return cleanedXml.getBytes(StandardCharsets.UTF_8);
    }
}

