/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.dao;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCDumpMessaggioStream;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.config.ricerche.ConfigurazioneRicerca;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneRisorsaContenuto;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneStato;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.datamodel.ResLive;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.ContenutiTransazioneArchivioBean;
import org.openspcoop2.web.monitor.transazioni.bean.DumpMessaggioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerArchivioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneArchivioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniApplicativoServerService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.slf4j.Logger;

public class ArchivioZipTransazioniService
implements ITransazioniService {
    private TransazioniSearchForm searchForm;
    private Logger log = LoggerManager.getPddMonitorSqlLogger();
    private IServiceManager utilsServiceManager;

    public void inizializzaInformazioniSupplementari() {
        if (!this.searchForm.getArchivioZipManager().isInizializzaInformazioniSupplementari()) {
            Map<String, TransazioneArchivioBean> mapTransazioni = this.searchForm.getArchivioZipManager().getMapTransazioni();
            for (Map.Entry<String, TransazioneArchivioBean> entry : mapTransazioni.entrySet()) {
                TransazioneArchivioBean transazioneArchivioBean = entry.getValue();
                TransazioneBean bean = transazioneArchivioBean.getTransazioneBean();
                bean.normalizeTipoApiInfo(this.getUtilsServiceManager(), this.log);
                bean.normalizeOperazioneInfo(this.getUtilsServiceManager(), this.log);
            }
            this.searchForm.getArchivioZipManager().setInizializzaInformazioniSupplementari(true);
        }
    }

    public void setSearch(TransazioniSearchForm search) {
        this.searchForm = search;
    }

    public TransazioniSearchForm getSearch() {
        return this.searchForm;
    }

    public List<TransazioneBean> findAll(int start, int limit) {
        this.inizializzaInformazioniSupplementari();
        Map<String, TransazioneArchivioBean> mapTransazioni = this.searchForm.getArchivioZipManager().getMapTransazioni();
        try {
            return this.applicaFiltri(mapTransazioni).stream().skip(start).limit(limit).collect(Collectors.toList());
        }
        catch (ServiceException | ProtocolException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<TransazioneBean>();
        }
    }

    public int totalCount() {
        this.inizializzaInformazioniSupplementari();
        Map<String, TransazioneArchivioBean> mapTransazioni = this.searchForm.getArchivioZipManager().getMapTransazioni();
        try {
            return this.applicaFiltri(mapTransazioni).size();
        }
        catch (ServiceException | ProtocolException e) {
            this.log.error(e.getMessage(), e);
            return 0;
        }
    }

    public void store(TransazioneBean obj) throws Exception {
    }

    public void deleteById(String key) {
    }

    public void delete(TransazioneBean obj) throws Exception {
    }

    public void deleteAll() throws Exception {
    }

    public TransazioneBean findById(String key) {
        this.log.debug("Find by id: {}", (Object)key);
        try {
            throw new NotImplementedException("Metodo Eliminato");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<TransazioneBean> findAll() {
        this.inizializzaInformazioniSupplementari();
        Map<String, TransazioneArchivioBean> mapTransazioni = this.searchForm.getArchivioZipManager().getMapTransazioni();
        try {
            return this.applicaFiltri(mapTransazioni);
        }
        catch (ServiceException | ProtocolException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<TransazioneBean>();
        }
    }

    @Override
    public List<TransazioneBean> findAllLive() {
        return new ArrayList<TransazioneBean>();
    }

    @Override
    public TransazioneBean findByIdTransazione(String id) throws Exception {
        this.inizializzaInformazioniSupplementari();
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(id);
        if (transazioneArchivioBean != null) {
            return transazioneArchivioBean.getTransazioneBean();
        }
        return null;
    }

    @Override
    public ResLive getEsiti(PermessiUtenteOperatore permessiUtente, Date min, Date max, String esitoContesto, String protocolloSelected, String protocolloDefault, TipologiaRicerca tipologiaRicerca) {
        return null;
    }

    @Override
    public ResLive getEsitiInfoLive(PermessiUtenteOperatore permessiUtente, Date lastDatePick, String protocolloSelected, String protocolloDefault) {
        return null;
    }

    @Override
    public boolean hasInfoDumpAvailable(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio) {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            return contenutiTransazioneArchivioBean.getMessage() != null || contenutiTransazioneArchivioBean.getAllegati().size() > 0 || contenutiTransazioneArchivioBean.getContenuti().size() > 0 || contenutiTransazioneArchivioBean.getContentLength() != null && contenutiTransazioneArchivioBean.getContentLength() > 0L;
        }
        return false;
    }

    @Override
    public boolean hasInfoHeaderTrasportoAvailable(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio) {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            return contenutiTransazioneArchivioBean.getHeaders().size() > 0;
        }
        return false;
    }

    private ContenutiTransazioneArchivioBean getContenuti(String saErogatore, TipoMessaggio tipoMessaggio, TransazioneArchivioBean transazioneArchivioBean) {
        Map<TipoMessaggio, ContenutiTransazioneArchivioBean> contenuti = null;
        if (saErogatore != null) {
            TransazioneApplicativoServerArchivioBean consegnaArchivioBean = transazioneArchivioBean.getConsegne().get(saErogatore);
            contenuti = consegnaArchivioBean.getContenuti();
        } else {
            contenuti = transazioneArchivioBean.getContenuti();
        }
        return contenuti.get(tipoMessaggio);
    }

    private TransazioneArchivioBean getTransazioneFromMap(String idTransazione) {
        this.inizializzaInformazioniSupplementari();
        Map<String, TransazioneArchivioBean> mapTransazioni = this.searchForm.getArchivioZipManager().getMapTransazioni();
        return mapTransazioni.get(idTransazione);
    }

    @Override
    public String getContentTypeMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio) {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            return contenutiTransazioneArchivioBean.getContentType();
        }
        return null;
    }

    @Override
    public Long getContentLengthMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio) {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            return contenutiTransazioneArchivioBean.getContentLength();
        }
        return null;
    }

    @Override
    public DumpMessaggio getDumpMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio) throws Exception {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            DumpMessaggio dump = new DumpMessaggio();
            dump.setBody(contenutiTransazioneArchivioBean.getMessage());
            dump.setContentLength(contenutiTransazioneArchivioBean.getContentLength());
            dump.setContentType(contenutiTransazioneArchivioBean.getContentType());
            dump.setFormatoMessaggio(contenutiTransazioneArchivioBean.getMessageType());
            dump.setIdTransazione(contenutiTransazioneArchivioBean.getTransactionId());
            dump.setProtocollo(contenutiTransazioneArchivioBean.getProtocol());
            dump.setTipoMessaggio(tipoMessaggio);
            dump.setServizioApplicativoErogatore(saErogatore);
            return dump;
        }
        return null;
    }

    @Override
    public JDBCDumpMessaggioStream getContentInputStream(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio) throws ServiceException {
        try {
            DumpMessaggio dumpMessaggio = this.getDumpMessaggio(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
            ByteArrayInputStream bais = new ByteArrayInputStream(dumpMessaggio.getBody());
            return new JDBCDumpMessaggioStream((InputStream)bais, null, null, null, null);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public int countDumpMessaggiGByDataConsegnaErogatore(String idTransazione, String saErogatore) {
        Map<String, Map<TipoMessaggio, ContenutiTransazioneArchivioBean>> storico;
        TransazioneApplicativoServerArchivioBean consegnaArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (consegnaArchivioBean = transazioneArchivioBean.getConsegne().get(saErogatore)) != null && (storico = consegnaArchivioBean.getStorico()) != null) {
            return storico.size();
        }
        return 0;
    }

    @Override
    public Date getDataConsegnaErogatore(String idTransazione, String saErogatore, Date dataAccettazione) {
        Map<String, Map<TipoMessaggio, ContenutiTransazioneArchivioBean>> storico;
        TransazioneApplicativoServerArchivioBean consegnaArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (consegnaArchivioBean = transazioneArchivioBean.getConsegne().get(saErogatore)) != null && (storico = consegnaArchivioBean.getStorico()) != null) {
            Date dataConsegnaErogatore = null;
            for (String key : storico.keySet()) {
                Date dataConsegnaTmp = null;
                try {
                    dataConsegnaTmp = DateUtils.getSimpleDateFormat((String)"yyyyMMdd_HHmmssSSS").parse(key);
                }
                catch (ParseException e) {
                    dataConsegnaTmp = new Date(Long.parseLong(key));
                }
                if (dataConsegnaErogatore != null && !dataConsegnaTmp.after(dataConsegnaErogatore)) continue;
                dataConsegnaErogatore = dataConsegnaTmp;
            }
            return dataConsegnaErogatore;
        }
        return null;
    }

    @Override
    public List<DumpMessaggioBean> listDumpMessaggiGByDataConsegnaErogatore(String idTransazione, String saErogatore, int start, int limit) {
        Map<String, Map<TipoMessaggio, ContenutiTransazioneArchivioBean>> storico;
        TransazioneApplicativoServerArchivioBean consegnaArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (consegnaArchivioBean = transazioneArchivioBean.getConsegne().get(saErogatore)) != null && (storico = consegnaArchivioBean.getStorico()) != null) {
            ArrayList<DumpMessaggioBean> dumpMessaggi = new ArrayList<DumpMessaggioBean>();
            for (Map.Entry<String, Map<TipoMessaggio, ContenutiTransazioneArchivioBean>> entry : storico.entrySet()) {
                String key = entry.getKey();
                Map<TipoMessaggio, ContenutiTransazioneArchivioBean> val = entry.getValue();
                DumpMessaggioBean dumpMessaggioBean = new DumpMessaggioBean();
                dumpMessaggioBean.setIdTransazione(idTransazione);
                dumpMessaggioBean.setServizioApplicativoErogatore(saErogatore);
                try {
                    dumpMessaggioBean.setDataConsegnaErogatore(DateUtils.getSimpleDateFormat((String)"yyyyMMdd_HHmmssSSS").parse(key));
                }
                catch (ParseException e) {
                    dumpMessaggioBean.setDataConsegnaErogatore(new Date(Long.parseLong(key)));
                }
                for (Map.Entry<TipoMessaggio, ContenutiTransazioneArchivioBean> entry2 : val.entrySet()) {
                    TipoMessaggio tipoMessaggio = entry2.getKey();
                    dumpMessaggioBean.getTipiMessaggio().add(tipoMessaggio);
                }
                dumpMessaggi.add(dumpMessaggioBean);
            }
            return dumpMessaggi.stream().sorted((a, b) -> b.getDataConsegnaErogatore().compareTo(a.getDataConsegnaErogatore())).skip(start).limit(limit).collect(Collectors.toList());
        }
        return new ArrayList<DumpMessaggioBean>();
    }

    @Override
    public List<DumpAllegato> getAllegatiMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio, Long idDump) {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            return contenutiTransazioneArchivioBean.getAllegati().values().stream().collect(Collectors.toList());
        }
        return new ArrayList<DumpAllegato>();
    }

    @Override
    public List<DumpContenuto> getContenutiSpecifici(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio, Long idDump) {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            return contenutiTransazioneArchivioBean.getContenuti();
        }
        return new ArrayList<DumpContenuto>();
    }

    @Override
    public List<DumpHeaderTrasporto> getHeaderTrasporto(String idTransazione, String saErogatore, Date dataConsegnaErogatore, TipoMessaggio tipoMessaggio, Long idDump) {
        ContenutiTransazioneArchivioBean contenutiTransazioneArchivioBean;
        TransazioneArchivioBean transazioneArchivioBean = this.getTransazioneFromMap(idTransazione);
        if (transazioneArchivioBean != null && (contenutiTransazioneArchivioBean = this.getContenuti(saErogatore, tipoMessaggio, transazioneArchivioBean)) != null) {
            return contenutiTransazioneArchivioBean.getHeaders();
        }
        return new ArrayList<DumpHeaderTrasporto>();
    }

    @Override
    public List<TransazioneBean> findAllDuplicati(String idTransazione, String idEgov, boolean isRisposta, int start, int limit) {
        return new ArrayList<TransazioneBean>();
    }

    @Override
    public int countAllDuplicati(String idTransazione, String idEgov, boolean isRisposta) {
        return 0;
    }

    @Override
    public TransazioneBean findTransazioneOriginale(String idTransazioneDuplicata, String idEgov, boolean isRisposta) {
        return null;
    }

    @Override
    public List<ConfigurazioneRicerca> getRicercheByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione) {
        return new ArrayList<ConfigurazioneRicerca>();
    }

    @Override
    public List<Parameter<?>> instanceParameters(ConfigurazioneRicerca configurazioneRicerca, Context context) throws SearchException {
        return new ArrayList();
    }

    @Override
    public List<ConfigurazioneTransazioneStato> getStatiByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione) {
        return new ArrayList<ConfigurazioneTransazioneStato>();
    }

    @Override
    public List<ConfigurazioneTransazioneRisorsaContenuto> getRisorseContenutoByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione, String nomeStato) {
        return new ArrayList<ConfigurazioneTransazioneRisorsaContenuto>();
    }

    @Override
    public List<TransazioneBean> findAll(int start, int limit, SortOrder sortOrder) {
        return this.findAll(start, limit, sortOrder, null);
    }

    @Override
    public int totalCount(SortOrder sortOrder, String sortField) {
        this.inizializzaInformazioniSupplementari();
        Map<String, TransazioneArchivioBean> mapTransazioni = this.searchForm.getArchivioZipManager().getMapTransazioni();
        try {
            return this.applicaFiltri(mapTransazioni).size();
        }
        catch (ServiceException | ProtocolException e) {
            this.log.error(e.getMessage(), e);
            return 0;
        }
    }

    @Override
    public List<TransazioneBean> findAll(int start, int limit, SortOrder sortOrder, String sortField) {
        this.inizializzaInformazioniSupplementari();
        Map<String, TransazioneArchivioBean> mapTransazioni = this.searchForm.getArchivioZipManager().getMapTransazioni();
        try {
            return this.applicaFiltri(mapTransazioni).stream().skip(start).limit(limit).collect(Collectors.toList());
        }
        catch (ServiceException | ProtocolException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<TransazioneBean>();
        }
    }

    @Override
    public void setLiveMaxResults(Integer limit) {
    }

    @Override
    public ITransazioniApplicativoServerService getTransazioniApplicativoServerService() {
        return null;
    }

    @Override
    public List<String> getHostnames(String gruppo, int refreshSecondsInterval) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getClusterIdDinamici(String gruppo, int refreshSecondsInterval) {
        return new ArrayList<String>();
    }

    @Override
    public boolean isTimeoutEvent() {
        return false;
    }

    @Override
    public boolean isProfiloDifferenteEvent() {
        return false;
    }

    @Override
    public boolean isSoggettoDifferenteEvent() {
        return false;
    }

    private List<TransazioneBean> applicaFiltri(Map<String, TransazioneArchivioBean> mapTransazioni) throws ProtocolException, ServiceException {
        boolean soloRichiesteScartate;
        List listaTransazioni = mapTransazioni.values().stream().map(a -> a.getTransazioneBean()).collect(Collectors.toList());
        ArrayList<TransazioneBean> toReturn = new ArrayList<TransazioneBean>();
        Integer esitoGruppo = this.searchForm.getEsitoGruppo();
        Integer esitoDettaglio = this.searchForm.getEsitoDettaglio();
        Integer[] esitoDettaglioPersonalizzato = this.searchForm.getEsitoDettaglioPersonalizzato();
        boolean escludiRichiesteScartate = this.searchForm.isEscludiRichiesteScartate();
        boolean senzaFiltro = esitoGruppo != null && EsitoUtils.ALL_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean soloOk = esitoGruppo != null && EsitoUtils.ALL_OK_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean faultApplicativo = esitoGruppo != null && EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE.intValue() == esitoGruppo.intValue();
        boolean soloErrori = esitoGruppo != null && EsitoUtils.ALL_ERROR_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean personalizzato = esitoGruppo != null && EsitoUtils.ALL_PERSONALIZZATO_VALUE.intValue() == esitoGruppo.intValue();
        boolean soloErroriPiuFaultApplicativi = esitoGruppo != null && EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean soloErroriConsegna = esitoGruppo != null && EsitoUtils.ALL_ERROR_CONSEGNA_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean bl = soloRichiesteScartate = esitoGruppo != null && EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() == esitoDettaglio.intValue();
        if (senzaFiltro && escludiRichiesteScartate) {
            senzaFiltro = false;
        }
        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)this.searchForm.getSafeProtocol());
        String evento = this.estraiValoreFiltroEvento();
        List<String> listaCodiciRispostaToCheck = this.estraiValoreCodicRisposta();
        for (TransazioneBean transazioneBean : listaTransazioni) {
            if (StringUtils.isNotBlank((CharSequence)this.searchForm.getEsitoContesto()) && !"-".equals(this.searchForm.getEsitoContesto()) && !transazioneBean.getEsitoContesto().equalsIgnoreCase(this.searchForm.getEsitoContesto())) continue;
            if (!senzaFiltro) {
                List esitiRichiesteMalformate;
                if (personalizzato) {
                    if (esitoDettaglioPersonalizzato == null || esitoDettaglioPersonalizzato.length <= 0) {
                        throw new ServiceException("Esito Personalizzato richiede la selezione di almeno un dettaglio");
                    }
                    boolean checkPersonalizzato = false;
                    for (int i = 0; i < esitoDettaglioPersonalizzato.length; ++i) {
                        if (!esitoDettaglioPersonalizzato[i].equals(transazioneBean.getEsito())) continue;
                        checkPersonalizzato = true;
                        break;
                    }
                    if (!checkPersonalizzato) {
                        continue;
                    }
                } else if (soloOk) {
                    List esitiOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                    if (!esitiOk.contains(transazioneBean.getEsito())) {
                        continue;
                    }
                } else if (faultApplicativo) {
                    int codeFaultApplicativo = esitiProperties.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
                    if (codeFaultApplicativo != transazioneBean.getEsito()) {
                        continue;
                    }
                } else if (soloErrori || soloErroriPiuFaultApplicativi) {
                    List esitiRichiesteMalformate2;
                    List esitiOk = null;
                    esitiOk = soloErrori ? esitiProperties.getEsitiCodeOk() : esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                    if (esitiOk.contains(transazioneBean.getEsito()) || escludiRichiesteScartate && (esitiRichiesteMalformate2 = esitiProperties.getEsitiCodeRichiestaScartate()).contains(transazioneBean.getEsito())) {
                        continue;
                    }
                } else if (soloErroriConsegna) {
                    List esitiErroriConsegna = esitiProperties.getEsitiCodeErroriConsegna();
                    if (!esitiErroriConsegna.contains(transazioneBean.getEsito())) {
                        continue;
                    }
                } else if (soloRichiesteScartate) {
                    List esitiRichiesteMalformate3 = esitiProperties.getEsitiCodeRichiestaScartate();
                    if (!esitiRichiesteMalformate3.contains(transazioneBean.getEsito())) {
                        continue;
                    }
                } else if (esitoDettaglio != null && esitoDettaglio.intValue() == EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE.intValue()) {
                    int codeFaultApplicativo = esitiProperties.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
                    if (codeFaultApplicativo != transazioneBean.getEsito()) {
                        continue;
                    }
                } else if (esitoDettaglio == null || esitoDettaglio < 0 ? escludiRichiesteScartate && (esitiRichiesteMalformate = esitiProperties.getEsitiCodeRichiestaScartate()).contains(transazioneBean.getEsito()) : esitoDettaglio.intValue() != transazioneBean.getEsito()) continue;
            }
            if (!listaCodiciRispostaToCheck.isEmpty()) {
                boolean codiceFound = false;
                block2: for (String codice : listaCodiciRispostaToCheck) {
                    for (int i = 0; i < 2; ++i) {
                        String prefix = i == 0 ? "Out=" : "In=";
                        String searchCodice = prefix + codice;
                        if (!StringUtils.isNotBlank((CharSequence)transazioneBean.getEventiLabel()) || !transazioneBean.getEventiLabel().contains(searchCodice)) continue;
                        codiceFound = true;
                        continue block2;
                    }
                }
                if (!codiceFound) continue;
            }
            if (evento != null) {
                evento = evento.trim();
                List<String> eventiGestioneAsList = transazioneBean.getEventiGestioneAsList();
                if (!eventiGestioneAsList.isEmpty()) {
                    boolean eventoFound = false;
                    for (String eventoGestione : eventiGestioneAsList) {
                        if (!eventoGestione.toLowerCase().contains(evento.toLowerCase())) continue;
                        eventoFound = true;
                        break;
                    }
                    if (!eventoFound) continue;
                }
            }
            toReturn.add(transazioneBean);
        }
        return toReturn.stream().sorted((a, b) -> b.getDataIngressoRichiesta().compareTo(a.getDataIngressoRichiesta())).collect(Collectors.toUnmodifiableList());
    }

    private List<String> estraiValoreCodicRisposta() {
        ArrayList<String> listaCodiciRispostaToCheck = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.searchForm.getCodiceRisposta())) {
            if (this.searchForm.getCodiceRisposta().contains(",")) {
                String[] tmp = this.searchForm.getCodiceRisposta().split(",");
                if (tmp != null && tmp.length > 0) {
                    for (String v : tmp) {
                        listaCodiciRispostaToCheck.add(v.trim());
                    }
                } else {
                    listaCodiciRispostaToCheck.add(this.searchForm.getCodiceRisposta());
                }
            } else {
                listaCodiciRispostaToCheck.add(this.searchForm.getCodiceRisposta());
            }
        }
        return listaCodiciRispostaToCheck;
    }

    private String estraiValoreFiltroEvento() {
        Object evento = this.searchForm.getEvento();
        if (StringUtils.isNotEmpty((CharSequence)evento) && ((String)(evento = ((String)evento).trim())).toLowerCase().startsWith("API=".toLowerCase()) && ((String)evento).length() > "API=".length()) {
            try {
                String sub = ((String)evento).substring("API=".length());
                if ("rest".equalsIgnoreCase(sub)) {
                    evento = "API=" + TipoAPI.REST.getValoreAsInt();
                } else if ("soap".equalsIgnoreCase(sub)) {
                    evento = "API=" + TipoAPI.SOAP.getValoreAsInt();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return evento;
    }

    public IServiceManager getUtilsServiceManager() {
        return this.utilsServiceManager;
    }

    public void setUtilsServiceManager(IServiceManager utilsServiceManager) {
        this.utilsServiceManager = utilsServiceManager;
    }
}

