/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.exporter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.TransazioneExport;
import org.openspcoop2.core.transazioni.constants.DeleteState;
import org.openspcoop2.core.transazioni.constants.ExportState;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCDumpMessaggioStream;
import org.openspcoop2.message.utils.DumpAttachment;
import org.openspcoop2.message.utils.DumpMessaggioMultipartInfo;
import org.openspcoop2.protocol.basic.archive.ZIPUtils;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticSerializer;
import org.openspcoop2.protocol.basic.tracciamento.TracciaSerializer;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.openspcoop2.web.monitor.transazioni.bean.DumpMessaggioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.core.UtilityTransazioni;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniApplicativoServerService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniExportService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.ExportException;
import org.openspcoop2.web.monitor.transazioni.exporter.ExporterProperties;
import org.openspcoop2.web.monitor.transazioni.exporter.IExporter;
import org.openspcoop2.web.monitor.transazioni.utils.DumpMessaggioUtils;
import org.slf4j.Logger;

public class SingleFileExporter
implements IExporter {
    private static final String ERRORE_EXPORT = "Si \u00e8 verificato un errore durante l'esportazione della transazione con id:";
    private static final String ERRORE_EXPORT_CONTENUTI = "Si \u00e8 verificato un errore durante l'esportazione dei contenuti della transazione con id:";
    private static final String ERRORE_EXPORT_FILE = "Errore durante esportazione su file";
    public static final String EXPORT_DATE_FORMAT_MS = "yyyyMMdd_HHmmssSSS";
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private boolean exportTracce = false;
    private boolean exportTracceUseProtocolSerialization = false;
    private boolean exportDiagnostici = false;
    private boolean exportDiagnosticiUseProtocolSerialization = false;
    private boolean exportContenuti = false;
    private boolean enableHeaderInfo = false;
    private boolean enableConsegneInfo = false;
    private boolean mimeThrowExceptionIfNotFound = false;
    private boolean abilitaMarcamentoTemporale = false;
    private boolean headersAsProperties = true;
    private boolean contenutiAsProperties = false;
    private boolean useCount = true;
    private ITransazioniService transazioniService;
    private ITransazioniApplicativoServerService transazioniApplicativoService;
    private ITracciaDriver tracciamentoService;
    private IDiagnosticDriver diagnosticiService;
    private ITransazioniExportService transazioniExporterService;
    private ZipOutputStream zip;
    private String fileName = null;

    private static void logDebug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    private static void logInfo(String msg) {
        if (log != null) {
            log.info(msg);
        }
    }

    private static void logError(String msg, Exception e) {
        if (log != null) {
            log.error(msg, (Throwable)e);
        }
    }

    private SingleFileExporter(ExporterProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) {
        this.enableHeaderInfo = properties.isEnableHeaderInfo();
        this.enableConsegneInfo = properties.isEnableConsegneInfo();
        this.exportTracce = properties.isExportTracce();
        this.exportTracceUseProtocolSerialization = properties.isExportTracceUseProtocolSerialization();
        this.exportDiagnostici = properties.isExportDiagnostici();
        this.exportDiagnosticiUseProtocolSerialization = properties.isExportDiagnosticiUseProtocolSerialization();
        this.exportContenuti = properties.isExportContenuti();
        this.mimeThrowExceptionIfNotFound = properties.isMimeThrowExceptionIfNotFound();
        this.abilitaMarcamentoTemporale = properties.isAbilitaMarcamentoTemporaleEsportazione();
        this.headersAsProperties = properties.isHeadersAsProperties();
        this.contenutiAsProperties = properties.isContenutiAsProperties();
        this.useCount = properties.isUseCount();
        this.tracciamentoService = tracciamentoService;
        this.transazioniService = transazioniService;
        this.transazioniApplicativoService = transazioniService.getTransazioniApplicativoServerService();
        this.diagnosticiService = diagnosticiService;
        this.transazioniExporterService = transazioniExport;
        SingleFileExporter.logInfo("Single File Exporter inizializzato:");
        SingleFileExporter.logInfo("\t -esportazione Consegne abilitata: " + this.enableConsegneInfo);
        SingleFileExporter.logInfo("\t -esportazione Tracce abilitata (useProtocolSerialization:" + this.exportTracceUseProtocolSerialization + "): " + this.exportTracce);
        SingleFileExporter.logInfo("\t -esportazione Diagnostici abilitata (exportDiagnosticiUseProtocolSerialization:" + this.exportDiagnosticiUseProtocolSerialization + "): " + this.exportDiagnostici);
        SingleFileExporter.logInfo("\t -esportazione Contenuti abilitata: " + this.exportContenuti);
        SingleFileExporter.logInfo("\t -usa count: " + this.useCount);
        if (!this.useCount) {
            SingleFileExporter.logInfo("\t -numero massimo elementi esportati: " + Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES);
        }
        SingleFileExporter.logInfo("\t -MimeType handling (mime.throwExceptionIfMappingNotFound):" + this.mimeThrowExceptionIfNotFound);
    }

    public SingleFileExporter(OutputStream outstream, ExporterProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) {
        this(properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport);
        this.zip = new ZipOutputStream(outstream);
    }

    public SingleFileExporter(File destFile, ExporterProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) throws FileNotFoundException {
        this(properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport);
        FileOutputStream fos = new FileOutputStream(destFile);
        this.zip = new ZipOutputStream(fos);
        this.fileName = destFile.getName();
        SingleFileExporter.logInfo("\n\t -Esportazione su file:" + destFile.getAbsolutePath());
    }

    public SingleFileExporter(String pathToFile, ExporterProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) throws FileNotFoundException {
        this(new File(pathToFile), properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport);
    }

    private void export(String rootDir, List<TransazioneBean> transazioni) throws ExportException {
        byte[] buf = new byte[1024];
        InputStream in = null;
        for (TransazioneBean t : transazioni) {
            String msg;
            String ext;
            boolean consegnaMultipla;
            String transazioneDir;
            block51: {
                String msg2;
                transazioneDir = rootDir + t.getIdTransazione() + File.separatorChar;
                consegnaMultipla = false;
                try {
                    EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)t.getProtocollo());
                    EsitoTransazioneName esitoTransactionName = esitiProperties.getEsitoTransazioneName(Integer.valueOf(t.getEsito()));
                    if (EsitoTransazioneName.isConsegnaMultipla((EsitoTransazioneName)esitoTransactionName)) {
                        consegnaMultipla = true;
                    }
                }
                catch (Exception e) {
                    msg2 = ERRORE_EXPORT + t.getIdTransazione();
                    msg2 = msg2 + " Non sono riuscito a comprendere l'esito della transazione (" + e.getMessage() + ")";
                    SingleFileExporter.logError(msg2, e);
                    throw new ExportException(msg2, e);
                }
                if (this.enableHeaderInfo) {
                    try {
                        this.zip.putNextEntry(new ZipEntry(transazioneDir + "manifest.xml"));
                        UtilityTransazioni.writeManifestTransazione(t, this.zip);
                        this.zip.flush();
                        this.zip.closeEntry();
                    }
                    catch (Exception e) {
                        msg2 = ERRORE_EXPORT + t.getIdTransazione();
                        msg2 = msg2 + " Non sono riuscito a creare il file manifest.xml (" + e.getMessage() + ")";
                        SingleFileExporter.logError(msg2, e);
                        throw new ExportException(msg2, e);
                    }
                }
                if (consegnaMultipla && this.enableConsegneInfo) {
                    try {
                        String dir = transazioneDir + "consegne" + File.separator;
                        this.transazioniApplicativoService.setIdTransazione(t.getIdTransazione());
                        this.transazioniApplicativoService.setProtocollo(t.getProtocollo());
                        List listConsegne = this.transazioniApplicativoService.findAll();
                        if (listConsegne == null || listConsegne.isEmpty()) break block51;
                        for (TransazioneApplicativoServerBean tAS : listConsegne) {
                            String faultErrore;
                            String connettoreNome = ZIPUtils.convertNameToSistemaOperativoCompatible((String)tAS.getNomeConnettoreDirectoryInArchivioZip());
                            String dirConsegna = dir + connettoreNome + File.separator;
                            this.zip.putNextEntry(new ZipEntry(dirConsegna + "manifest.xml"));
                            UtilityTransazioni.writeManifestTransazioneApplicativoServer(t, tAS, this.zip);
                            this.zip.flush();
                            this.zip.closeEntry();
                            if (this.exportDiagnostici) {
                                this.exportDiagnostici(t, dirConsegna, false, tAS.getServizioApplicativoErogatore());
                            }
                            if (!this.exportContenuti) continue;
                            String fault = tAS.getFault();
                            if (StringUtils.isNotBlank((CharSequence)fault)) {
                                try {
                                    String ext2 = UtilityTransazioni.getExtension(tAS.getFormatoFault());
                                    this.zip.putNextEntry(new ZipEntry(dirConsegna + "fault." + ext2));
                                    this.zip.write(fault != null ? fault.getBytes() : "".getBytes());
                                    this.zip.flush();
                                    this.zip.closeEntry();
                                }
                                catch (Exception ioe) {
                                    String msg3 = ERRORE_EXPORT_CONTENUTI + t.getIdTransazione();
                                    msg3 = msg3 + " Non sono riuscito a creare il file fault (" + ioe.getMessage() + ")";
                                    SingleFileExporter.logError(msg3, ioe);
                                    throw new ExportException(msg3, ioe);
                                }
                            }
                            if (StringUtils.isNotBlank((CharSequence)(faultErrore = tAS.getFaultUltimoErrore()))) {
                                try {
                                    String ext3 = UtilityTransazioni.getExtension(tAS.getFormatoFaultUltimoErrore());
                                    this.zip.putNextEntry(new ZipEntry(dirConsegna + "faultUltimoErrore." + ext3));
                                    this.zip.write(faultErrore != null ? faultErrore.getBytes() : "".getBytes());
                                    this.zip.flush();
                                    this.zip.closeEntry();
                                }
                                catch (Exception ioe) {
                                    String msg4 = ERRORE_EXPORT_CONTENUTI + t.getIdTransazione();
                                    msg4 = msg4 + " Non sono riuscito a creare il file faultUltimoErrore (" + ioe.getMessage() + ")";
                                    SingleFileExporter.logError(msg4, ioe);
                                    throw new ExportException(msg4, ioe);
                                }
                            }
                            TipoMessaggio[] listTipiDaEsportare = new TipoMessaggio[]{TipoMessaggio.RICHIESTA_USCITA, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, TipoMessaggio.RISPOSTA_INGRESSO, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO};
                            for (int i = 0; i < listTipiDaEsportare.length; ++i) {
                                SingleFileExporter.exportContenuti(log, tAS, null, this.zip, dirConsegna, true, this.transazioniService, listTipiDaEsportare[i], this.headersAsProperties, this.contenutiAsProperties);
                            }
                            if (tAS.getNumeroTentativi() <= 1) continue;
                            String dirStorico = dirConsegna + "contenuti" + File.separator + "storico" + File.separator;
                            int countDumpMessaggiGByDataConsegnaErogatore = this.transazioniService.countDumpMessaggiGByDataConsegnaErogatore(t.getIdTransazione(), tAS.getServizioApplicativoErogatore());
                            List<DumpMessaggioBean> lista = this.transazioniService.listDumpMessaggiGByDataConsegnaErogatore(t.getIdTransazione(), tAS.getServizioApplicativoErogatore(), 0, countDumpMessaggiGByDataConsegnaErogatore);
                            if (lista == null || lista.isEmpty()) continue;
                            for (int j = 0; j < lista.size(); ++j) {
                                DumpMessaggioBean tentativo = lista.get(j);
                                Date dataConsegnaErogatoreMillis = null;
                                dataConsegnaErogatoreMillis = tentativo.getDataConsegnaErogatore() != null ? tentativo.getDataConsegnaErogatore() : new Date(DateManager.getTimeMillis() + (long)j);
                                String dirTentativo = dirStorico + DateUtils.getSimpleDateFormat((String)EXPORT_DATE_FORMAT_MS).format(dataConsegnaErogatoreMillis) + File.separator;
                                for (int i = 0; i < listTipiDaEsportare.length; ++i) {
                                    SingleFileExporter.exportContenuti(log, tAS, tentativo.getDataConsegnaErogatore(), this.zip, dirTentativo, false, this.transazioniService, listTipiDaEsportare[i], this.headersAsProperties, this.contenutiAsProperties);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        msg2 = ERRORE_EXPORT + t.getIdTransazione();
                        msg2 = msg2 + " Non sono riuscito a recuperare le informazioni sulle consegne (" + e.getMessage() + ")";
                        SingleFileExporter.logError(msg2, e);
                        throw new ExportException(msg2, e);
                    }
                }
            }
            if (this.exportTracce) {
                String msg5;
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("id_transazione", t.getIdTransazione());
                Traccia tracciaRichiesta = null;
                Traccia tracciaRisposta = null;
                ArrayList<Traccia> tracce = new ArrayList<Traccia>();
                try {
                    tracciaRichiesta = this.tracciamentoService.getTraccia(RuoloMessaggio.RICHIESTA, properties);
                    tracce.add(tracciaRichiesta);
                }
                catch (DriverTracciamentoException e) {
                    msg5 = ERRORE_EXPORT + t.getIdTransazione();
                    msg5 = msg5 + " Non sono riuscito a recuperare la traccia di richiesta (" + e.getMessage() + ")";
                    throw new ExportException(msg5, e);
                }
                catch (DriverTracciamentoNotFoundException e) {
                    // empty catch block
                }
                try {
                    tracciaRisposta = this.tracciamentoService.getTraccia(RuoloMessaggio.RISPOSTA, properties);
                    tracce.add(tracciaRisposta);
                }
                catch (DriverTracciamentoException e) {
                    msg5 = ERRORE_EXPORT + t.getIdTransazione();
                    msg5 = msg5 + " Non sono riuscito a recuperare la traccia di risposta (" + e.getMessage() + ")";
                    throw new ExportException(msg5, e);
                }
                catch (DriverTracciamentoNotFoundException e) {
                    // empty catch block
                }
                ArrayList<String> errori = new ArrayList<String>(0);
                if (!tracce.isEmpty()) {
                    try {
                        String newLine;
                        this.zip.putNextEntry(new ZipEntry(transazioneDir + "tracce.xml"));
                        Object tail = null;
                        for (int j = 0; j < tracce.size(); ++j) {
                            Traccia tr = (Traccia)tracce.get(j);
                            newLine = j > 0 ? "\n\n" : "";
                            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tr.getProtocollo());
                            Object tracciaBuilder = null;
                            tracciaBuilder = this.exportTracceUseProtocolSerialization ? pf.createTracciaSerializer() : new TracciaSerializer(pf);
                            try {
                                int len;
                                Object head;
                                XMLRootElement xmlRootElement;
                                if (j == 0 && (xmlRootElement = tracciaBuilder.getXMLRootElement()) != null && (head = xmlRootElement.getAsStringStartTag()) != null && !"".equals(head)) {
                                    head = (String)head + "\n\n";
                                    this.zip.write(((String)head).getBytes(), 0, ((String)head).length());
                                    tail = xmlRootElement.getAsStringEndTag();
                                    if (tail != null && !"".equals(tail)) {
                                        tail = "\n\n" + (String)tail;
                                    }
                                }
                                tracciaBuilder.setOmitXmlDeclaration(true);
                                String traccia = tracciaBuilder.toString(tr, TipoSerializzazione.DEFAULT);
                                in = new ByteArrayInputStream((newLine + traccia).getBytes());
                                while ((len = in.read(buf)) > 0) {
                                    this.zip.write(buf, 0, len);
                                }
                                continue;
                            }
                            catch (ProtocolException e) {
                                String idTransazione = t.getIdTransazione();
                                String tipoTraccia = tr.getTipoMessaggio().getTipo();
                                String bustaAsString = tr.getBustaAsString();
                                String messaggioErrore = e.getMessage();
                                StringBuilder sb = new StringBuilder(0);
                                sb.append("ID Transazione: ").append(idTransazione).append("\n");
                                sb.append("Tipo Traccia: ").append(tipoTraccia).append("\n");
                                sb.append("Busta: \n").append(bustaAsString).append("\n\n");
                                sb.append("Errore: \n").append(messaggioErrore).append("\n");
                                errori.add(sb.toString());
                            }
                        }
                        if (tail != null && !"".equals(tail)) {
                            this.zip.write(((String)tail).getBytes(), 0, ((String)tail).length());
                        }
                        this.zip.flush();
                        this.zip.closeEntry();
                        if (in != null) {
                            in.close();
                        }
                        if (!errori.isEmpty()) {
                            this.zip.putNextEntry(new ZipEntry(transazioneDir + "tracce.xml.error"));
                            for (int i = 0; i < errori.size(); ++i) {
                                int len;
                                String errore = (String)errori.get(i);
                                newLine = i > 0 ? "\n\n" : "";
                                in = new ByteArrayInputStream((newLine + errore).getBytes());
                                while ((len = in.read(buf)) > 0) {
                                    this.zip.write(buf, 0, len);
                                }
                            }
                            this.zip.closeEntry();
                            this.zip.flush();
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        String msg6 = ERRORE_EXPORT + t.getIdTransazione();
                        msg6 = msg6 + " Non sono riuscito a creare il file tracce.xml (" + e.getMessage() + ")";
                        throw new ExportException(msg6, e);
                    }
                }
            }
            if (this.exportDiagnostici) {
                this.exportDiagnostici(t, transazioneDir, consegnaMultipla, null);
            }
            if (!this.exportContenuti) continue;
            String fault = t.getFaultIntegrazione();
            if (StringUtils.isNotBlank((CharSequence)fault)) {
                try {
                    ext = UtilityTransazioni.getExtension(t.getFormatoFaultIntegrazione());
                    this.zip.putNextEntry(new ZipEntry(transazioneDir + "faultIntegrazione." + ext));
                    this.zip.write(fault != null ? fault.getBytes() : "".getBytes());
                    this.zip.flush();
                    this.zip.closeEntry();
                }
                catch (Exception ioe) {
                    msg = ERRORE_EXPORT_CONTENUTI + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a creare il file faultIntegrazione (" + ioe.getMessage() + ")";
                    SingleFileExporter.logError(msg, ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(fault = t.getFaultCooperazione()))) {
                try {
                    ext = UtilityTransazioni.getExtension(t.getFormatoFaultCooperazione());
                    this.zip.putNextEntry(new ZipEntry(transazioneDir + "faultCooperazione." + ext));
                    this.zip.write(fault != null ? fault.getBytes() : "".getBytes());
                    this.zip.flush();
                    this.zip.closeEntry();
                }
                catch (Exception ioe) {
                    msg = ERRORE_EXPORT_CONTENUTI + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a creare il file faultCooperazione (" + ioe.getMessage() + ")";
                    SingleFileExporter.logError(msg, ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            TipoMessaggio[] listTipiDaEsportare = TipoMessaggio.values();
            for (int i = 0; i < listTipiDaEsportare.length; ++i) {
                SingleFileExporter.exportContenuti(log, t, this.zip, transazioneDir, true, this.transazioniService, listTipiDaEsportare[i], this.headersAsProperties, this.contenutiAsProperties);
            }
        }
    }

    private void exportDiagnostici(TransazioneBean t, String dir, boolean forceNullApplicativo, String servizioApplicativo) throws ExportException {
        InputStream in = null;
        byte[] buf = new byte[1024];
        try {
            FiltroRicercaDiagnosticiConPaginazione filter = new FiltroRicercaDiagnosticiConPaginazione();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("id_transazione", t.getIdTransazione());
            filter.setProperties(properties);
            if (forceNullApplicativo) {
                filter.setCheckApplicativoIsNull(Boolean.valueOf(true));
            } else if (servizioApplicativo != null) {
                filter.setApplicativo(servizioApplicativo);
            }
            List list = null;
            try {
                list = this.diagnosticiService.getMessaggiDiagnostici(filter);
            }
            catch (DriverMsgDiagnosticiNotFoundException notFound) {
                log.debug("[getMessaggiDiagnostici(" + t.getIdTransazione() + ")] non trovati: " + notFound.getMessage(), (Throwable)notFound);
            }
            if (list != null && !list.isEmpty()) {
                this.zip.putNextEntry(new ZipEntry(dir + "diagnostici.xml"));
                Object tail = null;
                for (int j = 0; j < list.size(); ++j) {
                    int len;
                    Object head;
                    XMLRootElement xmlRootElement;
                    MsgDiagnostico msg = (MsgDiagnostico)list.get(j);
                    String newLine = j > 0 ? "\n\n" : "";
                    IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(msg.getProtocollo());
                    Object diagnosticoBuilder = null;
                    diagnosticoBuilder = this.exportDiagnosticiUseProtocolSerialization ? pf.createDiagnosticSerializer() : new DiagnosticSerializer(pf);
                    if (j == 0 && (xmlRootElement = diagnosticoBuilder.getXMLRootElement()) != null && (head = xmlRootElement.getAsStringStartTag()) != null && !"".equals(head)) {
                        head = (String)head + "\n\n";
                        this.zip.write(((String)head).getBytes(), 0, ((String)head).length());
                        tail = xmlRootElement.getAsStringEndTag();
                        if (tail != null && !"".equals(tail)) {
                            tail = "\n\n" + (String)tail;
                        }
                    }
                    diagnosticoBuilder.setOmitXmlDeclaration(true);
                    String msgDiagnostico = diagnosticoBuilder.toString(msg, TipoSerializzazione.DEFAULT);
                    in = new ByteArrayInputStream((newLine + msgDiagnostico).getBytes());
                    while ((len = in.read(buf)) > 0) {
                        this.zip.write(buf, 0, len);
                    }
                }
                if (tail != null && !"".equals(tail)) {
                    this.zip.write(((String)tail).getBytes(), 0, ((String)tail).length());
                }
                this.zip.flush();
                this.zip.closeEntry();
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            String msg = ERRORE_EXPORT + t.getIdTransazione();
            msg = msg + " Non sono riuscito a creare il file diagnostici.xml (" + e.getMessage() + ")";
            throw new ExportException(msg, e);
        }
    }

    public void export(List<String> idtransazioni) throws ExportException {
        Date startTime = Calendar.getInstance().getTime();
        TransazioneExport te = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
            SingleFileExporter.logDebug("Avvio esportazione ...");
            SingleFileExporter.logDebug("Inizio esportazione alle:" + time.format(startTime));
            ArrayList<TransazioneBean> transazioni = new ArrayList<TransazioneBean>();
            for (String id : idtransazioni) {
                transazioni.add(this.transazioniService.findByIdTransazione(id));
            }
            String rootDir = "Transazioni" + File.separatorChar;
            try {
                this.zip.putNextEntry(new ZipEntry(rootDir + "SearchFilter.xml"));
                UtilityTransazioni.writeSearchFilterXml((TransazioniSearchForm)this.transazioniService.getSearch(), idtransazioni, this.transazioniService.totalCount(), this.zip);
                this.zip.flush();
                this.zip.closeEntry();
            }
            catch (Exception ioe) {
                Object msg = "Si e' verificato un errore durante l'esportazione delle transazioni";
                msg = (String)msg + " Non sono riuscito a creare il file SearchFilter.xml (" + ioe.getMessage() + ")";
                SingleFileExporter.logError((String)msg, ioe);
                throw new ExportException((String)msg, ioe);
            }
            if (this.abilitaMarcamentoTemporale) {
                te = this.transazioniExporterService.getByIntervallo(((TransazioniSearchForm)this.transazioniService.getSearch()).getDataInizio(), ((TransazioniSearchForm)this.transazioniService.getSearch()).getDataFine());
                te.setExportState(ExportState.EXECUTING);
                te.setExportTimeStart(startTime);
                te.setDeleteState(DeleteState.UNDEFINED);
                if (this.fileName != null) {
                    te.setNome(this.fileName);
                }
                this.transazioniExporterService.store(te);
            }
            this.export(rootDir, transazioni);
            Date dataFine = Calendar.getInstance().getTime();
            if (this.abilitaMarcamentoTemporale && te != null) {
                te.setExportState(ExportState.COMPLETED);
                te.setExportTimeEnd(dataFine);
                this.transazioniExporterService.store(te);
            }
            this.zip.flush();
            this.zip.close();
            SingleFileExporter.logDebug("Fine esportazione alle:" + formatter.format(Calendar.getInstance().getTime()));
            SingleFileExporter.logDebug("Esportazione completata.");
        }
        catch (ExportException e) {
            SingleFileExporter.logError(ERRORE_EXPORT_FILE, e);
            if (this.abilitaMarcamentoTemporale && te != null) {
                try {
                    te.setExportState(ExportState.ERROR);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    te.setExportError(sw.toString());
                    this.transazioniExporterService.store(te);
                }
                catch (Exception ex) {
                    SingleFileExporter.logError("Errore durante il marcamento temporale.", ex);
                }
            }
            throw e;
        }
        catch (Exception e) {
            SingleFileExporter.logError(ERRORE_EXPORT_FILE, e);
            throw new ExportException(ERRORE_EXPORT_FILE, e);
        }
    }

    public void export() throws ExportException {
        Date startTime = Calendar.getInstance().getTime();
        TransazioneExport te = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            int start = 0;
            int limit = 100;
            SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
            SingleFileExporter.logDebug("Avvio esportazione ...");
            SingleFileExporter.logDebug("Inizio esportazione alle:" + time.format(startTime));
            if (this.abilitaMarcamentoTemporale) {
                te = this.transazioniExporterService.getByIntervallo(((TransazioniSearchForm)this.transazioniService.getSearch()).getDataInizio(), ((TransazioniSearchForm)this.transazioniService.getSearch()).getDataFine());
                te.setExportState(ExportState.EXECUTING);
                te.setExportTimeStart(startTime);
                te.setDeleteState(DeleteState.UNDEFINED);
                if (this.fileName != null) {
                    te.setNome(this.fileName);
                }
                this.transazioniExporterService.store(te);
            }
            List transazioni = null;
            transazioni = this.transazioniService.findAll(start, limit);
            int totale = transazioni.size();
            boolean stopExport = false;
            String rootDir = "Transazioni" + File.separatorChar;
            try {
                this.zip.putNextEntry(new ZipEntry(rootDir + "SearchFilter.xml"));
                UtilityTransazioni.writeSearchFilterXml((TransazioniSearchForm)this.transazioniService.getSearch(), this.zip);
                this.zip.flush();
                this.zip.closeEntry();
                while (!transazioni.isEmpty() && !stopExport) {
                    int residui;
                    this.export(rootDir, transazioni);
                    start += limit;
                    if (!this.useCount && (residui = Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES - totale) > 0 && limit >= residui) {
                        limit = residui;
                    }
                    transazioni = this.transazioniService.findAll(start, limit);
                    if (this.useCount || (totale += transazioni.size()) < Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES) continue;
                    stopExport = true;
                    this.export(rootDir, transazioni);
                }
                this.zip.flush();
                this.zip.close();
            }
            catch (IOException ioe) {
                Object msg = "Si e' verificato un errore durante l'esportazione delle transazioni";
                msg = (String)msg + " Non sono riuscito a creare il file SearchFilter.xml (" + ioe.getMessage() + ")";
                SingleFileExporter.logError((String)msg, ioe);
                throw new ExportException((String)msg, ioe);
            }
            Date dataFine = Calendar.getInstance().getTime();
            if (this.abilitaMarcamentoTemporale) {
                te.setExportState(ExportState.COMPLETED);
                te.setExportTimeEnd(dataFine);
                this.transazioniExporterService.store(te);
            }
            SingleFileExporter.logDebug("Fine esportazione alle:" + formatter.format(dataFine));
            SingleFileExporter.logDebug("Esportazione completata.");
        }
        catch (ExportException e) {
            SingleFileExporter.logError(ERRORE_EXPORT_FILE, e);
            if (this.abilitaMarcamentoTemporale) {
                try {
                    te.setExportState(ExportState.ERROR);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    te.setExportError(sw.toString());
                    this.transazioniExporterService.store(te);
                }
                catch (Exception ex) {
                    SingleFileExporter.logError("Errore durante il marcamento temporale.", ex);
                }
            }
            throw e;
        }
        catch (Exception e) {
            SingleFileExporter.logError(ERRORE_EXPORT_FILE, e);
            throw new ExportException(ERRORE_EXPORT_FILE, e);
        }
    }

    public static String getDirName(TipoMessaggio tipo) {
        String fileName = tipo.name().toLowerCase();
        if (TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.equals((Object)tipo)) {
            fileName = "dati_richiesta_ingresso";
        } else if (TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.equals((Object)tipo)) {
            fileName = "dati_richiesta_uscita";
        } else if (TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO.equals((Object)tipo)) {
            fileName = "dati_risposta_ingresso";
        } else if (TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO.equals((Object)tipo)) {
            fileName = "dati_risposta_uscita";
        }
        return fileName;
    }

    public static void exportContenuti(Logger log, Transazione t, ZipOutputStream zip, String dirPath, boolean addContenutiDir, ITransazioniService service, TipoMessaggio tipo, boolean headersAsProperties, boolean contenutiAsProperties) throws ExportException {
        SingleFileExporter.internalExportContenuti(log, t.getIdTransazione(), null, null, zip, dirPath, addContenutiDir, service, tipo, headersAsProperties, contenutiAsProperties);
    }

    public static void exportContenuti(Logger log, TransazioneApplicativoServer transazioneApplicativoServer, Date dataConsegnaErogatore, ZipOutputStream zip, String dirPath, boolean addContenutiDir, ITransazioniService service, TipoMessaggio tipo, boolean headersAsProperties, boolean contenutiAsProperties) throws ExportException {
        SingleFileExporter.internalExportContenuti(log, transazioneApplicativoServer.getIdTransazione(), transazioneApplicativoServer.getServizioApplicativoErogatore(), dataConsegnaErogatore, zip, dirPath, addContenutiDir, service, tipo, headersAsProperties, contenutiAsProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalExportContenuti(Logger log, String idTransazione, String saErogatore, Date dataConsegnaErogatore, ZipOutputStream zip, String dirPath, boolean addContenutiDir, ITransazioniService service, TipoMessaggio tipo, boolean headersAsProperties, boolean contenutiAsProperties) throws ExportException {
        Object contenutiDir = null;
        contenutiDir = dirPath != null ? (addContenutiDir ? dirPath + "contenuti" + File.separator : dirPath) : "";
        DumpMessaggio dump = null;
        try {
            dump = service.getDumpMessaggio(idTransazione, saErogatore, dataConsegnaErogatore, tipo);
            if (dump != null && saErogatore != null && StringUtils.isNotEmpty((CharSequence)saErogatore) && dataConsegnaErogatore == null) {
                dataConsegnaErogatore = dump.getDataConsegnaErogatore();
            }
        }
        catch (Exception e) {
            String msg = "Si e' verificato un errore durante l'esportazione dei contenuti (" + tipo.toString() + ") della transazione con id:" + idTransazione;
            msg = msg + " Non sono riuscito a recuperare il messaggio di dump (" + e.getMessage() + ")";
            log.error(msg, (Throwable)e);
            throw new ExportException(msg, e);
        }
        if (dump != null) {
            List<DumpAllegato> allegati;
            List<DumpContenuto> contenuti;
            List<DumpHeaderTrasporto> headers;
            boolean dumpBinario;
            String fileNameTipo = SingleFileExporter.getDirName(tipo);
            String dir = (String)contenutiDir + fileNameTipo + File.separator;
            boolean bl = dumpBinario = TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.equals((Object)dump.getTipoMessaggio()) || TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.equals((Object)dump.getTipoMessaggio()) || TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO.equals((Object)dump.getTipoMessaggio()) || TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO.equals((Object)dump.getTipoMessaggio());
            if (dump.getBody() != null || dump.getContentLength() != null && dump.getContentLength() > 0L) {
                try {
                    String ext = "bin";
                    if (!dumpBinario || dump.getContentType() != null) {
                        String contentType = dump.getContentType();
                        ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType);
                    }
                    zip.putNextEntry(new ZipEntry(dir + "message." + ext));
                    if (dump.getBody() != null) {
                        zip.write(dump.getBody());
                    } else {
                        InputStream is = null;
                        JDBCDumpMessaggioStream dumpStream = null;
                        try {
                            dumpStream = service.getContentInputStream(idTransazione, saErogatore, dataConsegnaErogatore, tipo);
                            is = dumpStream.getIs();
                            CopyStream.copy((InputStream)is, (OutputStream)zip);
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (dumpStream != null) {
                                    dumpStream.closeJdbcResources();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione dei contenuti (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Non sono riuscito a creare il file envelope.xml (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            StringBuilder bf = new StringBuilder();
            if (dump.getContentType() != null) {
                bf.append("ContentType=").append(dump.getContentType()).append("\n");
            }
            if (dump.getContentLength() != null) {
                bf.append("ContentLength=").append(dump.getContentLength()).append("\n");
            }
            if (!dumpBinario || dump.getFormatoMessaggio() != null) {
                bf.append("MessageType=").append(dump.getFormatoMessaggio()).append("\n");
            }
            bf.append("TransactionId=").append(dump.getIdTransazione()).append("\n");
            bf.append("Protocol=").append(dump.getProtocollo());
            String nameManifest = "manifest.txt";
            try {
                zip.putNextEntry(new ZipEntry(dir + nameManifest));
                zip.write(bf.toString().getBytes());
                zip.flush();
                zip.closeEntry();
            }
            catch (Exception ioe) {
                String msg = "Si e' verificato un errore durante l'esportazione del manifest (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                msg = msg + " Non sono riuscito a creare il file manifest.txt (" + ioe.getMessage() + ")";
                log.error(msg, (Throwable)ioe);
                throw new ExportException(msg, ioe);
            }
            ArrayList<DumpMultipartHeader> headersMultiPart = dump.getMultipartHeaderList();
            if (!(headersMultiPart != null && !headersMultiPart.isEmpty() || dump.getMultipartContentId() == null && dump.getMultipartContentType() == null && dump.getMultipartContentLocation() == null)) {
                DumpMultipartHeader header;
                headersMultiPart = new ArrayList<DumpMultipartHeader>();
                if (dump.getMultipartContentId() != null) {
                    header = new DumpMultipartHeader();
                    header.setNome("Content-ID");
                    header.setValore(dump.getMultipartContentId());
                    headersMultiPart.add(header);
                }
                if (dump.getMultipartContentType() != null) {
                    header = new DumpMultipartHeader();
                    header.setNome("Content-Type");
                    header.setValore(dump.getMultipartContentType());
                    headersMultiPart.add(header);
                }
                if (dump.getMultipartContentLocation() != null) {
                    header = new DumpMultipartHeader();
                    header.setNome("Content-Location");
                    header.setValore(dump.getMultipartContentLocation());
                    headersMultiPart.add(header);
                }
            }
            if (headersMultiPart != null && !headersMultiPart.isEmpty()) {
                try {
                    Object name = "message_multipart_headers.";
                    name = headersAsProperties ? (String)name + "txt" : (String)name + "xml";
                    zip.putNextEntry(new ZipEntry(dir + (String)name));
                    UtilityTransazioni.writeMultipartHeaderXml(dump.getMultipartHeaderList(), zip, headersAsProperties);
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione degli header del messaggio multipart (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Non sono riuscito a creare il file message_multipart_headers.xml (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            if (!(headers = service.getHeaderTrasporto(dump.getIdTransazione(), dump.getServizioApplicativoErogatore(), dump.getDataConsegnaErogatore(), dump.getTipoMessaggio(), dump.getId())).isEmpty()) {
                try {
                    Object name = "headers.";
                    name = headersAsProperties ? (String)name + "txt" : (String)name + "xml";
                    zip.putNextEntry(new ZipEntry(dir + (String)name));
                    UtilityTransazioni.writeHeadersTrasportoXml(headers, zip, headersAsProperties);
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione degli header di trasporto (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Non sono riuscito a creare il file headers.xml (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            if (!(contenuti = service.getContenutiSpecifici(dump.getIdTransazione(), dump.getServizioApplicativoErogatore(), dump.getDataConsegnaErogatore(), dump.getTipoMessaggio(), dump.getId())).isEmpty()) {
                try {
                    Object name = "contents.";
                    name = contenutiAsProperties ? (String)name + "txt" : (String)name + "xml";
                    zip.putNextEntry(new ZipEntry(dir + (String)name));
                    UtilityTransazioni.writeContenutiXml(contenuti, zip, contenutiAsProperties);
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione dei contenuti (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Non sono riuscito a creare il file contents.xml (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            if (!(allegati = service.getAllegatiMessaggio(dump.getIdTransazione(), dump.getServizioApplicativoErogatore(), dump.getDataConsegnaErogatore(), dump.getTipoMessaggio(), dump.getId())).isEmpty()) {
                try {
                    for (int i = 0; i < allegati.size(); ++i) {
                        DumpAllegato allegato = allegati.get(i);
                        String iEsimoAllegato = dir + "allegati" + File.separator + "allegato_" + (i + 1) + File.separator;
                        Object fileName = "allegato";
                        String name = iEsimoAllegato + (String)fileName + "_multipart_headers.";
                        name = headersAsProperties ? name + "txt" : name + "xml";
                        zip.putNextEntry(new ZipEntry(name));
                        ArrayList<DumpHeaderAllegato> headersAllegato = allegato.getHeaderList();
                        if (headersAllegato == null || headersAllegato.isEmpty()) {
                            DumpHeaderAllegato header;
                            headersAllegato = new ArrayList<DumpHeaderAllegato>();
                            if (allegato.getContentId() != null) {
                                header = new DumpHeaderAllegato();
                                header.setNome("Content-ID");
                                header.setValore(allegato.getContentId());
                                headersAllegato.add(header);
                            }
                            if (allegato.getContentType() != null) {
                                header = new DumpHeaderAllegato();
                                header.setNome("Content-Type");
                                header.setValore(allegato.getContentType());
                                headersAllegato.add(header);
                            }
                            if (allegato.getContentLocation() != null) {
                                header = new DumpHeaderAllegato();
                                header.setNome("Content-Location");
                                header.setValore(allegato.getContentLocation());
                                headersAllegato.add(header);
                            }
                        }
                        UtilityTransazioni.writeAllegatoHeaderXml(headersAllegato, zip, headersAsProperties);
                        zip.flush();
                        zip.closeEntry();
                        String ct = allegato.getContentType();
                        if (ct != null) {
                            ct = ContentTypeUtilities.readBaseTypeFromContentType((String)ct);
                        }
                        String ext = MimeTypeUtils.fileExtensionForMIMEType((String)ct);
                        fileName = (String)fileName + "." + ext;
                        zip.putNextEntry(new ZipEntry(iEsimoAllegato + (String)fileName));
                        zip.write(allegato.getAllegato());
                        zip.flush();
                        zip.closeEntry();
                    }
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione dei contenuti (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Errore durante la gestione degli allegati (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
        }
    }

    public static void exportContenutiMultipart(Logger log, Transazione t, ZipOutputStream zip, String dirPath, ITransazioniService service, TipoMessaggio tipo, boolean headersAsProperties, boolean contenutiAsProperties) throws ExportException {
        SingleFileExporter.internalExportContenutiMultipart(log, t.getIdTransazione(), null, null, zip, dirPath, service, tipo, headersAsProperties, contenutiAsProperties);
    }

    public static void exportContenutiMultipart(Logger log, TransazioneApplicativoServer transazioneApplicativoServer, Date dataConsegnaErogatore, ZipOutputStream zip, String dirPath, ITransazioniService service, TipoMessaggio tipo, boolean headersAsProperties, boolean contenutiAsProperties) throws ExportException {
        SingleFileExporter.internalExportContenutiMultipart(log, transazioneApplicativoServer.getIdTransazione(), transazioneApplicativoServer.getServizioApplicativoErogatore(), dataConsegnaErogatore, zip, dirPath, service, tipo, headersAsProperties, contenutiAsProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalExportContenutiMultipart(Logger log, String idTransazione, String saErogatore, Date dataConsegnaErogatore, ZipOutputStream zip, String dirPath, ITransazioniService service, TipoMessaggio tipo, boolean headersAsProperties, boolean contenutiAsProperties) throws ExportException {
        if (contenutiAsProperties) {
            // empty if block
        }
        Object contenutiDir = null;
        contenutiDir = dirPath != null ? dirPath + "contenuti" + File.separator : "";
        DumpMessaggio dumpDB = null;
        try {
            dumpDB = service.getDumpMessaggio(idTransazione, saErogatore, dataConsegnaErogatore, tipo);
            if (dumpDB != null && saErogatore != null && StringUtils.isNotEmpty((CharSequence)saErogatore) && dataConsegnaErogatore == null) {
                dataConsegnaErogatore = dumpDB.getDataConsegnaErogatore();
            }
        }
        catch (Exception e) {
            String msg = "Si e' verificato un errore durante l'esportazione dei contenuti (" + tipo.toString() + ") della transazione con id:" + idTransazione;
            msg = msg + " Non sono riuscito a recuperare il messaggio di dump (" + e.getMessage() + ")";
            log.error(msg, (Throwable)e);
            throw new ExportException(msg, e);
        }
        if (dumpDB != null) {
            List attachments;
            List<DumpHeaderTrasporto> headers;
            DumpMessaggioMultipartInfo headersMultiPartInfoBody;
            String fileNameTipo = SingleFileExporter.getDirName(tipo);
            String dir = (String)contenutiDir + fileNameTipo + File.separator;
            boolean dumpBinario = TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.equals((Object)dumpDB.getTipoMessaggio()) || TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.equals((Object)dumpDB.getTipoMessaggio()) || TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO.equals((Object)dumpDB.getTipoMessaggio()) || TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO.equals((Object)dumpDB.getTipoMessaggio());
            org.openspcoop2.message.utils.DumpMessaggio dumpMessaggio = null;
            if (dumpDB.getBody() != null || dumpDB.getContentLength() != null && dumpDB.getContentLength() > 0L) {
                try {
                    String ext = "bin";
                    if (!dumpBinario || dumpDB.getContentType() != null) {
                        String contentType = dumpDB.getContentType();
                        ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType);
                    }
                    InputStream is = null;
                    JDBCDumpMessaggioStream dumpStream = null;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        if (dumpDB.getBody() != null) {
                            byte[] contenutoBody = dumpDB.getBody();
                            is = new ByteArrayInputStream(contenutoBody);
                        } else {
                            dumpStream = service.getContentInputStream(idTransazione, saErogatore, dataConsegnaErogatore, tipo);
                            is = dumpStream.getIs();
                        }
                        CopyStream.copy((InputStream)is, (OutputStream)baos);
                        baos.flush();
                        baos.close();
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception contenutoBody) {}
                        try {
                            if (dumpStream != null) {
                                dumpStream.closeJdbcResources();
                            }
                        }
                        catch (Exception contenutoBody) {}
                    }
                    byte[] content = baos.toByteArray();
                    String contentType = dumpDB.getContentType();
                    dumpMessaggio = DumpMessaggioUtils.getFromBytes(content, contentType, dumpDB.getFormatoMessaggio());
                    if (dumpMessaggio.getBody() != null) {
                        if (dumpMessaggio.getMultipartInfoBody() != null && dumpMessaggio.getMultipartInfoBody().getContentType() != null) {
                            ext = MimeTypeUtils.fileExtensionForMIMEType((String)dumpMessaggio.getMultipartInfoBody().getContentType());
                        }
                        zip.putNextEntry(new ZipEntry(dir + "message." + ext));
                        is = new ByteArrayInputStream(dumpMessaggio.getBody());
                        CopyStream.copy((InputStream)is, (OutputStream)zip);
                        zip.flush();
                        zip.closeEntry();
                    }
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione dei contenuti (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Non sono riuscito a creare il file envelope.xml (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            StringBuilder bf = new StringBuilder();
            if (dumpDB.getContentType() != null) {
                bf.append("ContentType=").append(dumpDB.getContentType()).append("\n");
            }
            if (dumpDB.getContentLength() != null) {
                bf.append("ContentLength=").append(dumpDB.getContentLength()).append("\n");
            }
            if (!dumpBinario || dumpDB.getFormatoMessaggio() != null) {
                bf.append("MessageType=").append(dumpDB.getFormatoMessaggio()).append("\n");
            }
            bf.append("TransactionId=").append(dumpDB.getIdTransazione()).append("\n");
            bf.append("Protocol=").append(dumpDB.getProtocollo());
            String nameManifest = "manifest.txt";
            try {
                zip.putNextEntry(new ZipEntry(dir + nameManifest));
                zip.write(bf.toString().getBytes());
                zip.flush();
                zip.closeEntry();
            }
            catch (Exception ioe) {
                String msg = "Si e' verificato un errore durante l'esportazione del manifest (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                msg = msg + " Non sono riuscito a creare il file manifest.txt (" + ioe.getMessage() + ")";
                log.error(msg, (Throwable)ioe);
                throw new ExportException(msg, ioe);
            }
            ArrayList<DumpMultipartHeader> headersMultiPart = null;
            DumpMessaggioMultipartInfo dumpMessaggioMultipartInfo = headersMultiPartInfoBody = dumpMessaggio != null ? dumpMessaggio.getMultipartInfoBody() : null;
            if (headersMultiPartInfoBody != null) {
                headersMultiPart = new ArrayList<DumpMultipartHeader>();
                if (headersMultiPartInfoBody.getHeadersValues() != null && headersMultiPartInfoBody.getHeadersValues().size() > 0) {
                    Map toMapSingleValue = TransportUtils.convertToMapSingleValue((Map)headersMultiPartInfoBody.getHeadersValues());
                    for (String key : toMapSingleValue.keySet()) {
                        String value = (String)toMapSingleValue.get(key);
                        DumpMultipartHeader header = new DumpMultipartHeader();
                        header.setNome(key);
                        header.setValore(value);
                        headersMultiPart.add(header);
                    }
                } else if (headersMultiPartInfoBody.getContentId() != null || headersMultiPartInfoBody.getContentType() != null || headersMultiPartInfoBody.getContentLocation() != null) {
                    DumpMultipartHeader header;
                    headersMultiPart = new ArrayList();
                    if (headersMultiPartInfoBody.getContentId() != null) {
                        header = new DumpMultipartHeader();
                        header.setNome("Content-ID");
                        header.setValore(headersMultiPartInfoBody.getContentId());
                        headersMultiPart.add(header);
                    }
                    if (headersMultiPartInfoBody.getContentType() != null) {
                        header = new DumpMultipartHeader();
                        header.setNome("Content-Type");
                        header.setValore(headersMultiPartInfoBody.getContentType());
                        headersMultiPart.add(header);
                    }
                    if (headersMultiPartInfoBody.getContentLocation() != null) {
                        header = new DumpMultipartHeader();
                        header.setNome("Content-Location");
                        header.setValore(headersMultiPartInfoBody.getContentLocation());
                        headersMultiPart.add(header);
                    }
                }
            }
            if (headersMultiPart != null && !headersMultiPart.isEmpty()) {
                try {
                    Object name = "message_multipart_headers.";
                    name = headersAsProperties ? (String)name + "txt" : (String)name + "xml";
                    zip.putNextEntry(new ZipEntry(dir + (String)name));
                    UtilityTransazioni.writeMultipartHeaderXml(headersMultiPart, zip, headersAsProperties);
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione degli header del messaggio multipart (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Non sono riuscito a creare il file message_multipart_headers.xml (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            if ((headers = service.getHeaderTrasporto(dumpDB.getIdTransazione(), dumpDB.getServizioApplicativoErogatore(), dumpDB.getDataConsegnaErogatore(), dumpDB.getTipoMessaggio(), dumpDB.getId())) != null && !headers.isEmpty()) {
                try {
                    Object name = "headers.";
                    name = headersAsProperties ? (String)name + "txt" : (String)name + "xml";
                    zip.putNextEntry(new ZipEntry(dir + (String)name));
                    UtilityTransazioni.writeHeadersTrasportoXml(headers, zip, headersAsProperties);
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione degli header di trasporto (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Non sono riuscito a creare il file headers.xml (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            List list = attachments = dumpMessaggio != null ? dumpMessaggio.getAttachments() : null;
            if (attachments != null && !attachments.isEmpty()) {
                try {
                    for (int i = 0; i < attachments.size(); ++i) {
                        DumpAttachment dumpAttachment = (DumpAttachment)attachments.get(i);
                        String iEsimoAllegato = dir + "allegati" + File.separator + "allegato_" + (i + 1) + File.separator;
                        Object fileName = "allegato";
                        String name = iEsimoAllegato + (String)fileName + "_multipart_headers.";
                        name = headersAsProperties ? name + "txt" : name + "xml";
                        zip.putNextEntry(new ZipEntry(name));
                        Map headersValues = dumpAttachment.getHeadersValues();
                        ArrayList<DumpHeaderAllegato> headersAllegato = null;
                        if (headersValues == null || headersValues.size() <= 0) {
                            DumpHeaderAllegato header;
                            headersAllegato = new ArrayList<DumpHeaderAllegato>();
                            if (dumpAttachment.getContentId() != null) {
                                header = new DumpHeaderAllegato();
                                header.setNome("Content-ID");
                                header.setValore(dumpAttachment.getContentId());
                                headersAllegato.add(header);
                            }
                            if (dumpAttachment.getContentType() != null) {
                                header = new DumpHeaderAllegato();
                                header.setNome("Content-Type");
                                header.setValore(dumpAttachment.getContentType());
                                headersAllegato.add(header);
                            }
                            if (dumpAttachment.getContentLocation() != null) {
                                header = new DumpHeaderAllegato();
                                header.setNome("Content-Location");
                                header.setValore(dumpAttachment.getContentLocation());
                                headersAllegato.add(header);
                            }
                        } else {
                            headersAllegato = new ArrayList();
                            Map toMapSingleValue = TransportUtils.convertToMapSingleValue((Map)headersValues);
                            for (String key : toMapSingleValue.keySet()) {
                                String value = (String)toMapSingleValue.get(key);
                                DumpHeaderAllegato header = new DumpHeaderAllegato();
                                header.setNome(key);
                                header.setValore(value);
                                headersAllegato.add(header);
                            }
                        }
                        UtilityTransazioni.writeAllegatoHeaderXml(headersAllegato, zip, headersAsProperties);
                        zip.flush();
                        zip.closeEntry();
                        String ct = dumpAttachment.getContentType();
                        if (ct != null) {
                            ct = ContentTypeUtilities.readBaseTypeFromContentType((String)ct);
                        }
                        String ext = MimeTypeUtils.fileExtensionForMIMEType((String)ct);
                        fileName = (String)fileName + "." + ext;
                        zip.putNextEntry(new ZipEntry(iEsimoAllegato + (String)fileName));
                        zip.write(dumpAttachment.getContent());
                        zip.flush();
                        zip.closeEntry();
                    }
                }
                catch (Exception ioe) {
                    String msg = "Si e' verificato un errore durante l'esportazione dei contenuti (" + tipo.toString() + ") della transazione con id:" + idTransazione;
                    msg = msg + " Errore durante la gestione degli allegati (" + ioe.getMessage() + ")";
                    log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isAbilitaMarcamentoTemporale() {
        return this.abilitaMarcamentoTemporale;
    }
}

