/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import java.util.ArrayList;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;

public class RiscontroBean
extends Riscontro {
    private static final long serialVersionUID = 1L;
    private transient IProtocolFactory<?> protocolFactory;
    private transient ITraduttore traduttore;

    public RiscontroBean(Riscontro riscontro, IProtocolFactory<?> protocolFactory) {
        this.protocolFactory = protocolFactory;
        try {
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setProtocolFactory", new Class[]{IProtocolFactory.class}));
        metodiEsclusi.add(new BlackListElement("setTipoOraRegistrazioneValue", new Class[]{String.class}));
        BeanUtils.copy((Object)((Object)this), (Object)riscontro, metodiEsclusi);
        try {
            this.setTipoOraRegistrazioneValue(riscontro.getTipoOraRegistrazioneValue(protocolFactory));
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }

    public String getTipoOraRegistrazioneValue() {
        try {
            return super.getTipoOraRegistrazioneValue(this.protocolFactory) == null ? this.traduttore.toString(this.getTipoOraRegistrazione()) : super.getTipoOraRegistrazioneValue(this.protocolFactory);
        }
        catch (Exception e) {
            if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
                this.protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
            } else {
                e.printStackTrace(System.err);
            }
            return null;
        }
    }

    public String getTipoOraRegistrazioneRicavato() {
        if (this.getTipoOraRegistrazioneValue() != null) {
            return this.getTipoOraRegistrazioneValue();
        }
        if (this.getTipoOraRegistrazione() != null) {
            return this.getTipoOraRegistrazione().getEngineValue();
        }
        return null;
    }

    public String getPrettyRicevuta() {
        String toRet = null;
        if (this.getRicevuta() != null) {
            toRet = Utils.prettifyXml((String)this.getRicevuta());
        }
        if (toRet == null) {
            toRet = this.getRicevuta() != null ? this.getRicevuta() : "";
        }
        return toRet;
    }
}

