/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.AbstractCoreSearchForm;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.ExporterCsvProperties;
import org.openspcoop2.web.monitor.transazioni.exporter.SingleCsvFileExporter;
import org.openspcoop2.web.monitor.transazioni.servlet.DiagnosticiExporter;
import org.openspcoop2.web.monitor.transazioni.servlet.TransazioniExporter;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TransazioniCsvExporter
extends HttpServlet {
    private static final long serialVersionUID = 1272767433184676700L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static Boolean enableHeaderInfo = false;
    private static Boolean mimeThrowExceptionIfNotFound = false;
    private static boolean headersAsProperties = true;
    private static boolean contenutiAsProperties = false;
    private static ITracciaDriver tracciamentoService = null;
    private static IDiagnosticDriver diagnosticiService = null;
    private static boolean exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti = false;

    public void init() throws ServletException {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            enableHeaderInfo = govwayMonitorProperties.isAttivoTransazioniExportHeader();
            mimeThrowExceptionIfNotFound = govwayMonitorProperties.isTransazioniDownloadThrowExceptionMimeTypeNotFound();
            headersAsProperties = govwayMonitorProperties.isAttivoTransazioniExportHeaderAsProperties();
            contenutiAsProperties = govwayMonitorProperties.isAttivoTransazioniExportContenutiAsProperties();
            tracciamentoService = govwayMonitorProperties.getDriverTracciamento();
            diagnosticiService = govwayMonitorProperties.getDriverMsgDiagnostici();
            exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti = govwayMonitorProperties.isExportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti();
        }
        catch (Exception e) {
            log.error("Inizializzazione servlet fallita, setto enableHeaderInfo=false", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            boolean exportConsentito;
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new Exception("Context is null");
            }
            ITransazioniService service = (ITransazioniService)context.getBean("transazioniService");
            TransazioniSearchForm sfInSession = (TransazioniSearchForm)context.getBean("searchFormTransazioni");
            TransazioniSearchForm searchForm = (TransazioniSearchForm)sfInSession.clone();
            User utente = null;
            String modalita = null;
            LoginBean lbInSession = (LoginBean)context.getBean("loginBean");
            if (lbInSession != null && lbInSession.isLoggedIn()) {
                utente = lbInSession.getUtente();
                modalita = lbInSession.getModalita();
            }
            searchForm.setUser(utente);
            searchForm.setModalita(modalita);
            searchForm.saveProtocollo();
            service.setSearch((AbstractCoreSearchForm)searchForm);
            HttpServletResponse response = resp;
            String isAllString = req.getParameter("isAll");
            Boolean isAll = Boolean.parseBoolean(isAllString);
            String idtransazioni = req.getParameter("ids");
            String[] ids = StringUtils.split((String)idtransazioni, (String)",");
            String exporter = req.getParameter("exporter");
            String[] ex = StringUtils.split((String)exporter, (String)",");
            String formato = req.getParameter("fEx");
            String idColonneSelezionate = req.getParameter("idSelez");
            boolean exportTracce = false;
            boolean exportDiagnostici = false;
            boolean exportContenuti = false;
            if (exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti && ex != null) {
                for (String val : ex) {
                    if ("tracce".equals(val)) {
                        exportTracce = true;
                    }
                    if ("diagnostici".equals(val)) {
                        exportDiagnostici = true;
                    }
                    if (!"contenuti".equals(val)) continue;
                    String msg_errore = "L'export dei contenuti non e' disponibile per la funzionalita' richiesta.";
                    String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msg_errore;
                    response.sendRedirect(redirectUrl);
                    return;
                }
            }
            HttpSession sessione = req.getSession();
            Boolean isAllFromSession = (Boolean)sessione.getAttribute("isAllOriginale");
            String idTransazioniFromSession = (String)sessione.getAttribute("idTransazioniOriginali");
            String exporterFromSession = (String)sessione.getAttribute("exporterOriginali");
            String formatoFromSession = (String)sessione.getAttribute("fExOriginali");
            String idColonneFromSession = (String)sessione.getAttribute("idSelezOriginali");
            List colonneSelezionateFromSession = (List)sessione.getAttribute("lstSelezOriginali");
            sessione.removeAttribute("isAllOriginale");
            sessione.removeAttribute("idTransazioniOriginali");
            sessione.removeAttribute("exporterOriginali");
            sessione.removeAttribute("fExOriginali");
            sessione.removeAttribute("idSelezOriginali");
            sessione.removeAttribute("lstSelezOriginali");
            String[] idsFromSession = StringUtils.split((String)idTransazioniFromSession, (String)",");
            String[] exFromSession = StringUtils.split((String)exporterFromSession, (String)",");
            boolean bl = exportConsentito = DiagnosticiExporter.checkParametri(isAll, ids, isAllFromSession, idsFromSession) && TransazioniExporter.checkTipiExport(ex, exFromSession) && TransazioniCsvExporter.checkFormatoExport(formato, formatoFromSession) && TransazioniCsvExporter.checkIdentificativoColonneSelezionate(idColonneSelezionate, idColonneFromSession);
            if (!exportConsentito) {
                String msg_errore = "L'utente non dispone dei permessi necessari per effettuare l'export delle transazioni.";
                String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msg_errore;
                response.sendRedirect(redirectUrl);
                return;
            }
            String mimeType = MimeTypes.getInstance().getMimeType(formato);
            String ext = MimeTypeUtils.fileExtensionForMIMEType((String)mimeType);
            String fileName = "Transazioni." + ext;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)mimeType);
            response.setStatus(200);
            response.flushBuffer();
            Utility.setLoginMBean((LoginBean)((LoginBean)context.getBean("loginBean")));
            ExporterCsvProperties prop = new ExporterCsvProperties();
            prop.setEnableHeaderInfo(enableHeaderInfo);
            prop.setExportContenuti(exportContenuti);
            prop.setExportDiagnostici(exportDiagnostici);
            prop.setExportTracce(exportTracce);
            prop.setMimeThrowExceptionIfNotFound(mimeThrowExceptionIfNotFound);
            prop.setFormato(formato);
            prop.setColonneSelezionate(colonneSelezionateFromSession);
            prop.setHeadersAsProperties(headersAsProperties);
            prop.setContenutiAsProperties(contenutiAsProperties);
            prop.setUseCount(searchForm.isUseCount());
            SingleCsvFileExporter sfe = new SingleCsvFileExporter((OutputStream)response.getOutputStream(), prop, service, tracciamentoService, diagnosticiService, null);
            if (isAll.booleanValue()) {
                sfe.export();
            } else {
                ArrayList<String> idTransazioni = new ArrayList<String>();
                for (int j = 0; j < ids.length; ++j) {
                    idTransazioni.add(ids[j]);
                }
                sfe.export(idTransazioni);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            Utility.setLoginMBean(null);
        }
    }

    public static boolean checkFormatoExport(String formato, String formatoFromSession) {
        if (formato == null || formatoFromSession == null) {
            return false;
        }
        return formato.equals(formatoFromSession);
    }

    public static boolean checkIdentificativoColonneSelezionate(String idColonne, String idColonneFromSession) {
        if (idColonne == null || idColonneFromSession == null) {
            return false;
        }
        return idColonne.equals(idColonneFromSession);
    }
}

