/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.utils;

import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.utils.DumpMessaggio;
import org.openspcoop2.message.utils.DumpMessaggioConfig;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.slf4j.Logger;

public class DumpMessaggioUtils {
    public static DumpMessaggio getFromBytes(byte[] content, String contentType, String formato) throws Exception {
        if (ContentTypeUtilities.isMultipartContentType((String)contentType)) {
            MessageType messageType = null;
            if (formato != null) {
                try {
                    messageType = MessageType.valueOf((String)formato.toUpperCase());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (messageType == null) {
                String contentTypeInternal;
                messageType = ContentTypeUtilities.isMultipartRelated((String)contentType) ? ("text/xml".equalsIgnoreCase(contentTypeInternal = ContentTypeUtilities.getInternalMultipartContentType((String)contentType)) || contentTypeInternal.toLowerCase().startsWith("text/xml") ? MessageType.SOAP_11 : ("application/soap+xml".equalsIgnoreCase(contentTypeInternal) || contentTypeInternal.toLowerCase().startsWith("application/soap+xml") ? MessageType.SOAP_12 : MessageType.SOAP_12)) : MessageType.MIME_MULTIPART;
            }
            OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            OpenSPCoop2MessageParseResult pr = factory.createMessage(messageType, MessageRole.NONE, contentType, content, null, null);
            OpenSPCoop2Message msg = pr.getMessage_throwParseException();
            Messaggio messaggio = new Messaggio();
            messaggio.setFormatoMessaggio(messageType);
            DumpMessaggioConfig dumpMessaggioConfig = new DumpMessaggioConfig();
            DumpMessaggio dumpMessaggio = Dump.fillMessaggio((OpenSPCoop2Message)msg, (DumpMessaggioConfig)dumpMessaggioConfig, (boolean)true, (boolean)true, (boolean)true, (Messaggio)messaggio);
            return dumpMessaggio;
        }
        return null;
    }

    public static byte[] decodeAllegatoBase64(byte[] contenuto, String contentType, String contentId, Logger log) {
        try {
            boolean checkBase64;
            PddMonitorProperties prop = PddMonitorProperties.getInstance((Logger)log);
            boolean isTransazioniAllegatiDecodeBase64 = prop.isTransazioniAllegatiDecodeBase64();
            List isTransazioniAllegatiDecodeBase64_noDecodeList = prop.getTransazioniAllegatiDecodeBase64_noDecodeList();
            String mimeTypeBase = MimeTypeUtils.getBaseType((String)contentType);
            boolean bl = checkBase64 = isTransazioniAllegatiDecodeBase64 && mimeTypeBase != null && !isTransazioniAllegatiDecodeBase64_noDecodeList.contains(mimeTypeBase);
            if (checkBase64 && MimeTypeUtils.isBase64((byte[])contenuto)) {
                log.debug("Decode Base64 Content [" + contentId + "] ...");
                return Base64.decodeBase64((byte[])contenuto);
            }
        }
        catch (Exception e) {
            log.error("IsBase64 error: " + e.getMessage(), (Throwable)e);
        }
        return contenuto;
    }

    public static boolean isAllegatoBase64(byte[] contenuto, String contentType, String contentId, Logger log) {
        try {
            boolean checkBase64;
            PddMonitorProperties prop = PddMonitorProperties.getInstance((Logger)log);
            boolean isTransazioniAllegatiDecodeBase64 = prop.isTransazioniAllegatiDecodeBase64();
            List isTransazioniAllegatiDecodeBase64_noDecodeList = prop.getTransazioniAllegatiDecodeBase64_noDecodeList();
            String mimeTypeBase = MimeTypeUtils.getBaseType((String)contentType);
            boolean bl = checkBase64 = isTransazioniAllegatiDecodeBase64 && mimeTypeBase != null && !isTransazioniAllegatiDecodeBase64_noDecodeList.contains(mimeTypeBase);
            if (checkBase64) {
                return MimeTypeUtils.isBase64((byte[])contenuto);
            }
        }
        catch (Exception e) {
            log.error("IsBase64 error: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

