/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPPart;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.SoapUtils;

public class SOAPInfo {
    private SOAPHeader header = null;
    private String rootElementNamespace = null;
    private String rootElementPrefix = null;
    private String envelopeNamespace = null;

    public SOAPHeader getHeader() {
        return this.header;
    }

    public String getRootElementNamespace() {
        return this.rootElementNamespace;
    }

    public String getRootElementPrefix() {
        return this.rootElementPrefix;
    }

    public String getEnvelopeNamespace() {
        return this.envelopeNamespace;
    }

    public void read(boolean useSoapReader, OpenSPCoop2SoapMessage soapMessage, boolean bufferMessage_readOnly, String idTransazione, boolean readEnvelopeNamespace, boolean readHeader, boolean readRootElementInfo) throws Exception {
        boolean read = false;
        if (useSoapReader && soapMessage instanceof AbstractOpenSPCoop2Message_soap_impl) {
            AbstractOpenSPCoop2Message_soap_impl soap = (AbstractOpenSPCoop2Message_soap_impl)soapMessage;
            if (readHeader) {
                if (soap.isSoapHeaderOptimizable()) {
                    this.header = soap.getSOAPHeader();
                    if (readRootElementInfo) {
                        this.rootElementNamespace = soap.getSoapReader().getRootElementNamespace();
                        this.rootElementPrefix = soap.getSoapReader().getRootElementPrefix();
                    }
                    if (readEnvelopeNamespace) {
                        this.envelopeNamespace = soap.getSoapReader().getNamespace();
                    }
                    read = true;
                }
            } else if (readRootElementInfo || readEnvelopeNamespace) {
                if (soap.getSoapReader() != null && soap.getSoapReader().isParsingComplete()) {
                    if (readRootElementInfo) {
                        this.rootElementNamespace = soap.getSoapReader().getRootElementNamespace();
                        this.rootElementPrefix = soap.getSoapReader().getRootElementPrefix();
                    }
                    if (readEnvelopeNamespace) {
                        this.envelopeNamespace = soap.getSoapReader().getNamespace();
                    }
                }
                read = true;
            }
        }
        if (!read) {
            SOAPPart soapPart = MessageUtils.getSOAPPart((OpenSPCoop2SoapMessage)soapMessage, (boolean)bufferMessage_readOnly, (String)idTransazione);
            SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
            SOAPBody body = null;
            if (soapEnvelope != null) {
                if (readHeader) {
                    this.header = soapEnvelope.getHeader();
                }
                if (readRootElementInfo) {
                    body = soapEnvelope.getBody();
                    if (readRootElementInfo) {
                        this.readSOAPChildBodyInfo(body);
                    }
                }
                if (readEnvelopeNamespace) {
                    this.envelopeNamespace = soapEnvelope.getNamespaceURI();
                }
            }
        }
    }

    private void readSOAPChildBodyInfo(SOAPBody soapBody) throws Exception {
        if (soapBody == null) {
            throw new Exception("Messaggio senza Body");
        }
        SOAPElement child = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)soapBody);
        if (child == null) {
            throw new Exception("Messaggio senza un contenuto nel Body");
        }
        this.rootElementNamespace = child.getNamespaceURI();
        this.rootElementPrefix = child.getPrefix();
    }
}

