/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.datamodel.Res;
import org.openspcoop2.web.monitor.core.datamodel.ResBase;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3D;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3DCustom;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.utils.StatsUtils;
import org.slf4j.Logger;

public class JsonStatsUtils {
    private JsonStatsUtils() {
    }

    public static ObjectNode getJsonPieChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, Integer slice) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode grafico = jsonUtils.newObjectNode();
        grafico.put("coloriAutomatici", true);
        grafico.put("xAxisGridLines", true);
        grafico.put("titolo", caption);
        grafico.put("sottotitolo", subCaption);
        grafico.put("clickItemLegenda", false);
        grafico.put("valoreRealeTorta", true);
        grafico.put("colonneLegenda", 16);
        grafico.put("limiteColonneLegenda", 16);
        grafico.put("valueOnLegend", true);
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
        if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
            occupazioneBanda = true;
        } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
            tempoMedio = true;
        }
        ArrayNode dati = jsonUtils.newArrayNode();
        int maxLenghtLabel = 0;
        if (list != null && !list.isEmpty()) {
            int i = 0;
            long altriSum = 0L;
            int altriSumNumeroItem = 0;
            for (ResDistribuzione entry : list) {
                String r = entry.getRisultato();
                Number sum = entry.getSomma();
                if (++i <= slice) {
                    if (r.length() > maxLenghtLabel) {
                        maxLenghtLabel = r.length();
                    }
                    String toolText = StatsUtils.getToolText(search, sum);
                    if (!entry.getParentMap().isEmpty()) {
                        toolText = StatsUtils.getToolTextConParent(search, r, entry.getParentMap(), sum);
                    }
                    ObjectNode spicchio = jsonUtils.newObjectNode();
                    spicchio.put("label", JsonStatsUtils.escapeJsonLabel(r));
                    spicchio.put("tooltip", toolText);
                    if (sum instanceof Long) {
                        Long v = (Long)sum;
                        spicchio.put("value", v);
                    } else if (sum instanceof Integer) {
                        Integer vi = (Integer)sum;
                        spicchio.put("value", vi);
                    } else if (sum instanceof Float) {
                        Float vf = (Float)sum;
                        spicchio.put("value", vf);
                    } else if (sum instanceof Double) {
                        Double vd = (Double)sum;
                        spicchio.put("value", vd);
                    }
                    dati.add((JsonNode)spicchio);
                    continue;
                }
                altriSum += sum.longValue();
                ++altriSumNumeroItem;
            }
            if (i > slice) {
                long v = altriSum;
                if (altriSumNumeroItem > 1 && (occupazioneBanda || tempoMedio) && altriSumNumeroItem > 0) {
                    v /= (long)altriSumNumeroItem;
                }
                String toolText = StatsUtils.getToolText(search, v);
                ObjectNode spicchio = jsonUtils.newObjectNode();
                spicchio.put("label", "Altri");
                spicchio.put("tooltip", toolText);
                spicchio.put("value", v);
                dati.add((JsonNode)spicchio);
            }
            grafico.set("dati", (JsonNode)dati);
            if (maxLenghtLabel > 50) {
                grafico.put("limitLegenda", 50);
            }
        } else {
            grafico.put("noData", "Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static ObjectNode getJsonBarChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer slice) throws UtilsException {
        ArrayList<ResBase> listI = new ArrayList<ResBase>();
        listI.addAll(list);
        return JsonStatsUtils.getJsonBarChartDistribuzioneEngine(listI, search, caption, subCaption, direzioneLabelParam, slice, null, null, new String[0]);
    }

    public static ObjectNode getJsonBarChartDistribuzione(List<Res> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer slice, Integer numeroLabel, StatisticType tempo) throws UtilsException {
        ArrayList<ResBase> listI = new ArrayList<ResBase>();
        listI.addAll(list);
        return JsonStatsUtils.getJsonBarChartDistribuzioneEngine(listI, search, caption, subCaption, direzioneLabelParam, slice, numeroLabel, tempo, new String[0]);
    }

    private static ObjectNode getJsonBarChartDistribuzioneEngine(List<ResBase> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer sliceParam, Integer numeroLabel, StatisticType tempo, String ... series) throws UtilsException {
        ObjectNode categoria;
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode grafico = jsonUtils.newObjectNode();
        grafico.put("coloriAutomatici", false);
        grafico.put("xAxisGridLines", true);
        grafico.put("titolo", caption);
        grafico.put("sottotitolo", subCaption);
        grafico.put("xAxisLabelDirezione", JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdfLast = null;
        if (tempo != null) {
            sdfLast = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
            sdf = StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
        }
        ArrayNode categorie = jsonUtils.newArrayNode();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        boolean distribuzionePerEsiti = false;
        if (search.isAndamentoTemporalePerEsiti()) {
            distribuzionePerEsiti = true;
        } else {
            TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
            if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
                occupazioneBanda = true;
            } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
                tempoMedio = true;
            }
        }
        int numeroCategorie = 1;
        boolean showSeries = false;
        if (list != null && !list.isEmpty()) {
            if (series != null && series.length > 0) {
                numeroCategorie = series.length;
                for (int i = 0; i < series.length; ++i) {
                    String string = series[i];
                    categoria = jsonUtils.newObjectNode();
                    categoria.put("key", string);
                    categoria.put("label", string);
                    categoria.put("colore", "#3B83B7");
                    categorie.add((JsonNode)categoria);
                }
                showSeries = true;
            } else if (distribuzionePerEsiti) {
                numeroCategorie = 3;
                showSeries = true;
                ObjectNode categoria2 = jsonUtils.newObjectNode();
                categoria2.put("key", "ok");
                categoria2.put("label", "Ok");
                categoria2.put("colore", "#95B964");
                categorie.add((JsonNode)categoria2);
                ObjectNode categoria22 = jsonUtils.newObjectNode();
                categoria22.put("key", "fault");
                categoria22.put("label", "Fault Applicativo");
                categoria22.put("colore", "#FF8F52");
                categorie.add((JsonNode)categoria22);
                ObjectNode categoria3 = jsonUtils.newObjectNode();
                categoria3.put("key", "errore");
                categoria3.put("label", "Fallite");
                categoria3.put("colore", "#CD4A50");
                categorie.add((JsonNode)categoria3);
            } else if (occupazioneBanda) {
                numeroCategorie = search.getTipiBandaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiBanda();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoBanda.COMPLESSIVA.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", TipoBanda.COMPLESSIVA.getValue());
                        categoria.put("colore", "#3B83B7");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoBanda.INTERNA.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", TipoBanda.INTERNA.getValue());
                        categoria.put("colore", "#FF8F52");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria = jsonUtils.newObjectNode();
                    categoria.put("key", TipoBanda.ESTERNA.getValue().toLowerCase().replace(" ", "_"));
                    categoria.put("label", TipoBanda.ESTERNA.getValue());
                    categoria.put("colore", "#95B964");
                    categorie.set(i, (JsonNode)categoria);
                }
            } else if (tempoMedio) {
                numeroCategorie = search.getTipiLatenzaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiLatenza();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null || !showSeries) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoLatenza.LATENZA_TOTALE.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", TipoLatenza.LATENZA_TOTALE.getValue());
                        categoria.put("colore", "#3B83B7");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoLatenza.LATENZA_SERVIZIO.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", "Tempo Risposta Servizio");
                        categoria.put("colore", "#FF8F52");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria = jsonUtils.newObjectNode();
                    categoria.put("key", TipoLatenza.LATENZA_PORTA.getValue().toLowerCase().replace(" ", "_"));
                    categoria.put("label", TipoLatenza.LATENZA_PORTA.getValue());
                    categoria.put("colore", "#95B964");
                    categorie.set(i, (JsonNode)categoria);
                }
            }
        }
        if (categorie.isEmpty()) {
            ObjectNode categoria3 = jsonUtils.newObjectNode();
            categoria3.put("key", "totale");
            categoria3.put("label", StatsUtils.getSubCaption(search, true));
            categoria3.put("colore", "#3B83B7");
            categorie.add((JsonNode)categoria3);
        }
        grafico.set("categorie", (JsonNode)categorie);
        grafico.put("mostraLegenda", showSeries);
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put("yAxisLabel", yAxisName);
        ArrayNode dati = jsonUtils.newArrayNode();
        if (list != null && !list.isEmpty()) {
            int iterazione = 0;
            long altriSumSerie1 = 0L;
            int altriSumSerie1NumeroItem = 0;
            long altriSumSerie2 = 0L;
            int altriSumSerie2NumeroItem = 0;
            long altriSumSerie3 = 0L;
            int altriSumSerie3NumeroItem = 0;
            int slice = sliceParam;
            if (slice != Integer.MAX_VALUE) {
                slice *= numeroCategorie;
            }
            int maxLenghtLabel = 0;
            List<Integer> posizioniDaVisualizzare = JsonStatsUtils.getListaIndiciLabelDaVisualizzare(list.size(), numeroLabel);
            boolean nascondiLabel = posizioniDaVisualizzare != null;
            for (int z = 0; z < list.size(); ++z) {
                ResBase entry = list.get(z);
                ObjectNode bar = jsonUtils.newObjectNode();
                for (int j = 0; j < numeroCategorie; ++j) {
                    JsonNode keyNode = categorie.get(j).get("key");
                    String key = keyNode.asText();
                    Number sum = null;
                    if (entry instanceof ResDistribuzione) {
                        sum = entry.getSomma();
                    } else if (entry instanceof Res) {
                        sum = (Number)entry.getSomme().get(j);
                    }
                    if (++iterazione <= slice) {
                        Object r = null;
                        if (entry instanceof ResDistribuzione) {
                            ResDistribuzione resDistribuzione = (ResDistribuzione)entry;
                            r = resDistribuzione.getRisultato();
                        } else if (entry instanceof Res) {
                            Res res = (Res)entry;
                            Date rDate = res.getRisultato();
                            Calendar c = Calendar.getInstance();
                            c.setTime(rDate);
                            StringBuilder sb = new StringBuilder();
                            if (StatisticType.ORARIA.equals((Object)tempo)) {
                                sdfLast.applyPattern("HH");
                                c.add(10, 1);
                                sb.append(sdf.format(rDate) + "-").append(sdfLast.format(c.getTime()));
                            } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                                sdf.applyPattern("dd/MM/yy");
                                sdfLast.applyPattern("dd/MM/yy");
                                c.add(4, 1);
                                c.add(7, -1);
                                sb.append(sdf.format(rDate) + "-").append(sdfLast.format(c.getTime()));
                            } else if (StatisticType.MENSILE.equals((Object)tempo)) {
                                sdf.applyPattern("MMM/yy");
                                sb.append(sdf.format(rDate));
                            } else {
                                sb.append(sdf.format(rDate));
                            }
                            r = sb.toString();
                        } else {
                            r = "ERROR: TIPO [" + entry.getClass().getName() + "] NON GESTITO";
                        }
                        if (j == 0) {
                            if (((String)r).length() > maxLenghtLabel) {
                                maxLenghtLabel = ((String)r).length();
                            }
                            bar.put("data", JsonStatsUtils.escapeJsonLabel((String)r));
                            if (!nascondiLabel) {
                                bar.put("dataLabel", JsonStatsUtils.escapeJsonLabel((String)r));
                            } else if (posizioniDaVisualizzare.contains(z)) {
                                bar.put("dataLabel", JsonStatsUtils.escapeJsonLabel((String)r));
                            } else {
                                bar.put("dataLabel", "");
                            }
                        }
                        String toolText = StatsUtils.getToolText(search, sum);
                        if (!entry.getParentMap().isEmpty()) {
                            toolText = StatsUtils.getToolTextConParent(search, (String)r, entry.getParentMap(), sum);
                        }
                        String value = StatsUtils.getValue(search, sum);
                        bar.put(key, value);
                        bar.put(key + "_tooltip", toolText);
                        if (j != numeroCategorie - 1) continue;
                        dati.add((JsonNode)bar);
                        continue;
                    }
                    if (j == 0) {
                        if (sum != null) {
                            altriSumSerie1 += sum.longValue();
                        }
                        ++altriSumSerie1NumeroItem;
                        continue;
                    }
                    if (j == 1) {
                        if (sum != null) {
                            altriSumSerie2 += sum.longValue();
                        }
                        ++altriSumSerie2NumeroItem;
                        continue;
                    }
                    if (j != 2) continue;
                    if (sum != null) {
                        altriSumSerie3 += sum.longValue();
                    }
                    ++altriSumSerie3NumeroItem;
                }
            }
            if (iterazione > slice) {
                ObjectNode bar = jsonUtils.newObjectNode();
                bar.put("data", "Altri");
                bar.put("dataLabel", "Altri");
                for (int j = 0; j < numeroCategorie; ++j) {
                    JsonNode keyNode = categorie.get(j).get("key");
                    String key = keyNode.asText();
                    long v = -1L;
                    if (j == 0) {
                        v = altriSumSerie1;
                        if (altriSumSerie1NumeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altriSumSerie1NumeroItem;
                        }
                    } else if (j == 1) {
                        v = altriSumSerie2;
                        if (altriSumSerie2NumeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altriSumSerie2NumeroItem;
                        }
                    } else if (j == 2) {
                        v = altriSumSerie3;
                        if (altriSumSerie3NumeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altriSumSerie3NumeroItem;
                        }
                    }
                    String toolText = StatsUtils.getToolText(search, v);
                    String value = StatsUtils.getValue(search, v);
                    bar.put(key, value);
                    bar.put(key + "_tooltip", toolText);
                }
                dati.add((JsonNode)bar);
            }
            if (maxLenghtLabel > 50) {
                grafico.put("limit", 50);
            }
            grafico.set("dati", (JsonNode)dati);
        } else {
            categorie.removeAll();
            categoria = jsonUtils.newObjectNode();
            categoria.put("key", "totale");
            categoria.put("label", StatsUtils.getSubCaption(search, true));
            categoria.put("colore", "#3B83B7");
            categorie.add((JsonNode)categoria);
            grafico.put("noData", "Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static ObjectNode getJsonHeatmapChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer slice, StatisticType tempo, boolean visualizzaTotaleNelleCelleGraficoHeatmap, Logger log) throws UtilsException {
        return JsonStatsUtils._getJsonHeatmapChartDistribuzione(list, search, caption, subCaption, direzioneLabelParam, slice, null, tempo, visualizzaTotaleNelleCelleGraficoHeatmap, log);
    }

    private static String buildKeyJsonHeatmapChartDistribuzione(ResDistribuzione res) {
        StringBuilder sb = new StringBuilder(res.getRisultato());
        if (res.getParentMap() != null && !res.getParentMap().isEmpty()) {
            int i = 0;
            for (Map.Entry entry : res.getParentMap().entrySet()) {
                sb.append("_");
                sb.append(i);
                sb.append(":");
                sb.append((String)entry.getValue());
                ++i;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static ObjectNode _getJsonHeatmapChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer sliceParam, Integer numeroLabel, StatisticType tempo, boolean visualizzaTotaleNelleCelleGraficoHeatmap, Logger log) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode grafico = jsonUtils.newObjectNode();
        grafico.put("coloriAutomatici", false);
        grafico.put("xAxisGridLines", true);
        grafico.put("titolo", caption);
        grafico.put("sottotitolo", subCaption);
        grafico.put("xAxisLabelDirezione", JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        grafico.put("visualizzaValoreNellaCella", visualizzaTotaleNelleCelleGraficoHeatmap);
        try {
            grafico.put("visualizzaValoreZero", PddMonitorProperties.getInstance((Logger)log).isStatisticheVisualizzaValoreZeroNelGraficoHeatmap());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf_last = null;
        if (tempo != null) {
            sdf_last = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
            sdf = StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
        }
        ArrayNode categorie = jsonUtils.newArrayNode();
        boolean showSeries = false;
        if (categorie.isEmpty()) {
            ObjectNode categoria = jsonUtils.newObjectNode();
            categoria.put("key", "totale");
            categoria.put("label", StatsUtils.getSubCaption(search, true));
            categoria.put("colore", "#3B83B7");
            categorie.add((JsonNode)categoria);
        }
        grafico.set("categorie", (JsonNode)categorie);
        grafico.put("mostraLegenda", showSeries);
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put("yAxisLabel", yAxisName);
        Integer valoreMinimo = 0;
        Number valoreMassimo = 0;
        ArrayNode dati = jsonUtils.newArrayNode();
        if (list != null && !list.isEmpty()) {
            int slice = sliceParam;
            int maxLenghtLabel = 0;
            list = JsonStatsUtils.generaElementiMancanti(list, log);
            HashMap<String, List<ResDistribuzione>> elementiPerCategoria = new HashMap<String, List<ResDistribuzione>>();
            HashMap<String, Number> totaliPerCategoria = new HashMap<String, Number>();
            for (ResDistribuzione res : list) {
                void var27_33;
                String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione(res);
                List list2 = (List)elementiPerCategoria.remove(key);
                if (list2 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var27_33.add(res);
                elementiPerCategoria.put(key, (List<ResDistribuzione>)var27_33);
                totaliPerCategoria.put(key, StatsUtils.sum(search, totaliPerCategoria.getOrDefault(key, 0), res.getSomma()));
            }
            for (List lista : elementiPerCategoria.values()) {
                JsonStatsUtils.ordinaElementiAsseYPerData(search, lista);
            }
            ArrayList<Map.Entry<String, Number>> totaliPerCategoriaEntryList = new ArrayList<Map.Entry<String, Number>>(totaliPerCategoria.entrySet());
            JsonStatsUtils.ordinaElementiAsseXPerSommaDecrescente(search, totaliPerCategoriaEntryList);
            list = JsonStatsUtils.valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescente(elementiPerCategoria, totaliPerCategoriaEntryList);
            if (totaliPerCategoriaEntryList.size() > slice) {
                ArrayList<String> sortedKeys = new ArrayList<String>();
                for (Map.Entry entry : totaliPerCategoriaEntryList) {
                    sortedKeys.add((String)entry.getKey());
                }
                List<String> categorieDaAccorpareComeAltri = sortedKeys.subList(slice, sortedKeys.size());
                list = JsonStatsUtils.valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescenteConElementoAltri(elementiPerCategoria, totaliPerCategoriaEntryList, categorieDaAccorpareComeAltri, search, log);
            }
            for (int z = 0; z < list.size(); ++z) {
                ResDistribuzione entry = list.get(z);
                ObjectNode objectNode = jsonUtils.newObjectNode();
                Number sum = entry.getSomma();
                String r = entry.getRisultato();
                String dateS = null;
                if (entry instanceof ResDistribuzione3D) {
                    Date rDate = ((ResDistribuzione3D)entry).getData();
                    Calendar c = Calendar.getInstance();
                    c.setTime(rDate);
                    StringBuilder sb = new StringBuilder();
                    if (StatisticType.ORARIA.equals((Object)tempo)) {
                        sdf_last.applyPattern("HH");
                        c.add(10, 1);
                        sb.append(sdf.format(rDate) + "-").append(sdf_last.format(c.getTime()));
                    } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                        sdf.applyPattern("dd/MM/yy");
                        sdf_last.applyPattern("dd/MM/yy");
                        c.add(4, 1);
                        c.add(7, -1);
                        sb.append(sdf.format(rDate) + "-").append(sdf_last.format(c.getTime()));
                    } else if (StatisticType.MENSILE.equals((Object)tempo)) {
                        sdf.applyPattern("MMM/yy");
                        sb.append(sdf.format(rDate));
                    } else {
                        sb.append(sdf.format(rDate));
                    }
                    dateS = sb.toString();
                } else if (entry instanceof ResDistribuzione3DCustom) {
                    dateS = ((ResDistribuzione3DCustom)entry).getDatoCustom();
                }
                if (r.length() > maxLenghtLabel) {
                    maxLenghtLabel = r.length();
                }
                String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione(entry);
                objectNode.put("x", JsonStatsUtils.escapeJsonLabel(key));
                objectNode.put("xLabel", JsonStatsUtils.escapeJsonLabel(r));
                objectNode.put("y", JsonStatsUtils.escapeJsonLabel(dateS));
                objectNode.put("yLabel", JsonStatsUtils.escapeJsonLabel(dateS));
                String toolText = StatsUtils.getToolText(search, sum);
                if (!entry.getParentMap().isEmpty()) {
                    toolText = StatsUtils.getToolTextConParent(search, r, entry.getParentMap(), sum);
                }
                if (r.equals("Altri")) {
                    toolText = StatsUtils.getToolTextCategoriaAltri(search, sum);
                }
                String value = StatsUtils.getValue(search, sum);
                objectNode.put("totale", value);
                objectNode.put("totale_tooltip", toolText);
                objectNode.put("totale_label", StatsUtils.getToolText(search, sum));
                dati.add((JsonNode)objectNode);
                valoreMassimo = StatsUtils.getMax(search, sum, valoreMassimo);
            }
            if (maxLenghtLabel > 50) {
                grafico.put("limit", 50);
            }
            grafico.set("dati", (JsonNode)dati);
        } else {
            categorie.removeAll();
            ObjectNode categoria = jsonUtils.newObjectNode();
            categoria.put("key", "totale");
            categoria.put("label", StatsUtils.getSubCaption(search, true));
            categoria.put("colore", "#3B83B7");
            categorie.add((JsonNode)categoria);
            grafico.put("noData", "Non esistono transazioni per il periodo selezionato");
        }
        ObjectNode scalaValori = jsonUtils.newObjectNode();
        ObjectNode min = jsonUtils.newObjectNode();
        min.put("colore", "#FFFFFF");
        min.put("valore", String.valueOf(valoreMinimo));
        scalaValori.set("min", (JsonNode)min);
        ObjectNode max = jsonUtils.newObjectNode();
        max.put("colore", "#3B83B7");
        max.put("valore", StatsUtils.getValue(search, valoreMassimo));
        scalaValori.set("max", (JsonNode)max);
        grafico.set("scalaValori", (JsonNode)scalaValori);
        ArrayNode labelsLegenda = jsonUtils.newArrayNode();
        ObjectNode minLabel = jsonUtils.newObjectNode();
        minLabel.put("valore", StatsUtils.getValue(search, valoreMinimo));
        minLabel.put("label", StatsUtils.getToolText(search, valoreMinimo));
        labelsLegenda.add((JsonNode)minLabel);
        Number unQuarto = StatsUtils.avg(search, valoreMassimo, 4);
        ObjectNode unQuartoLabel = jsonUtils.newObjectNode();
        unQuartoLabel.put("valore", StatsUtils.getValue(search, unQuarto));
        unQuartoLabel.put("label", StatsUtils.getToolText(search, unQuarto));
        labelsLegenda.add((JsonNode)unQuartoLabel);
        Number number = StatsUtils.avg(search, valoreMassimo, 2);
        ObjectNode unMezzoLabel = jsonUtils.newObjectNode();
        unMezzoLabel.put("valore", StatsUtils.getValue(search, number));
        unMezzoLabel.put("label", StatsUtils.getToolText(search, number));
        labelsLegenda.add((JsonNode)unMezzoLabel);
        Number treQuarti = StatsUtils.avg(search, StatsUtils.sum(search, valoreMassimo, number), 2);
        ObjectNode treQuartiLabel = jsonUtils.newObjectNode();
        treQuartiLabel.put("valore", StatsUtils.getValue(search, treQuarti));
        treQuartiLabel.put("label", StatsUtils.getToolText(search, treQuarti));
        labelsLegenda.add((JsonNode)treQuartiLabel);
        ObjectNode maxLabel = jsonUtils.newObjectNode();
        maxLabel.put("valore", StatsUtils.getValue(search, valoreMassimo));
        maxLabel.put("label", StatsUtils.getToolText(search, valoreMassimo));
        labelsLegenda.add((JsonNode)maxLabel);
        grafico.set("labelLegenda", (JsonNode)labelsLegenda);
        return grafico;
    }

    public static List<ResDistribuzione> generaElementiMancanti(List<ResDistribuzione> origList, Logger log) {
        List<ResDistribuzione> lNull = null;
        if (origList == null) {
            return lNull;
        }
        ArrayList<ResDistribuzione> destList = new ArrayList<ResDistribuzione>();
        HashSet<String> existingXValues = new HashSet<String>();
        HashMap<String, String> existingXValuesOriginalKey = new HashMap<String, String>();
        HashSet<Date> existingYDateValues = new HashSet<Date>();
        HashSet<String> existingYCustomValues = new HashSet<String>();
        boolean customValues = false;
        HashMap mapParentMaps = new HashMap();
        Iterator<ResDistribuzione> iterator = origList.iterator();
        while (iterator.hasNext()) {
            ResDistribuzione resDistribuzione;
            ResDistribuzione resDistribuzione2 = resDistribuzione = iterator.next();
            destList.add(resDistribuzione2);
            Iterator key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione(resDistribuzione2);
            existingXValues.add((String)((Object)key));
            existingXValuesOriginalKey.put((String)((Object)key), resDistribuzione2.getRisultato());
            mapParentMaps.put(key, resDistribuzione2.getParentMap());
            if (resDistribuzione2 instanceof ResDistribuzione3D) {
                existingYDateValues.add(((ResDistribuzione3D)resDistribuzione2).getData());
                continue;
            }
            if (!(resDistribuzione2 instanceof ResDistribuzione3DCustom)) continue;
            customValues = true;
            existingYCustomValues.add(((ResDistribuzione3DCustom)resDistribuzione2).getDatoCustom());
        }
        ArrayList<ResDistribuzione3DCustom> missingTriples = new ArrayList<ResDistribuzione3DCustom>();
        for (String x : existingXValues) {
            ResDistribuzione3DCustom resDistribuzione3D;
            String originalKey;
            if (customValues) {
                for (String string : existingYCustomValues) {
                    if (JsonStatsUtils.containsTriple(destList, x, string)) continue;
                    originalKey = (String)existingXValuesOriginalKey.get(x);
                    resDistribuzione3D = new ResDistribuzione3DCustom(originalKey, string, (Number)0);
                    resDistribuzione3D.getParentMap().putAll((Map)mapParentMaps.get(x));
                    missingTriples.add(resDistribuzione3D);
                }
                continue;
            }
            for (Date date : existingYDateValues) {
                if (JsonStatsUtils.containsTriple(destList, x, date)) continue;
                originalKey = (String)existingXValuesOriginalKey.get(x);
                resDistribuzione3D = new ResDistribuzione3D(originalKey, date, (Number)0);
                resDistribuzione3D.getParentMap().putAll((Map)mapParentMaps.get(x));
                missingTriples.add(resDistribuzione3D);
            }
        }
        destList.addAll(missingTriples);
        long l = 0L;
        l = customValues ? (long)existingYCustomValues.size() : (long)existingYDateValues.size();
        long xYsize = (long)existingXValues.size() * l;
        if ((long)destList.size() != xYsize) {
            String msg = "generaElementiMancanti destListSize:" + destList.size() + " xYsize:" + xYsize + " existingXValues:" + String.valueOf(existingXValues) + " existingYValues:" + l;
            log.error(msg);
        }
        return destList;
    }

    private static boolean containsTriple(List<ResDistribuzione> valuesList, String x, Date y) {
        for (ResDistribuzione res : valuesList) {
            ResDistribuzione3D resDistribuzione3D = (ResDistribuzione3D)res;
            String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione((ResDistribuzione)resDistribuzione3D);
            if (!key.equals(x) || !resDistribuzione3D.getData().equals(y)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTriple(List<ResDistribuzione> valuesList, String x, String y) {
        for (ResDistribuzione res : valuesList) {
            ResDistribuzione3DCustom resDistribuzione3D = (ResDistribuzione3DCustom)res;
            String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione((ResDistribuzione)resDistribuzione3D);
            if (!key.equals(x) || !resDistribuzione3D.getDatoCustom().equals(y)) continue;
            return true;
        }
        return false;
    }

    private static List<ResDistribuzione> valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescente(Map<String, List<ResDistribuzione>> elementiPerCategoria, List<Map.Entry<String, Number>> entryList) {
        ArrayList<ResDistribuzione> destList = new ArrayList<ResDistribuzione>();
        for (Map.Entry<String, Number> entry : entryList) {
            destList.addAll((Collection<ResDistribuzione>)elementiPerCategoria.get(entry.getKey()));
        }
        return destList;
    }

    private static List<ResDistribuzione> valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescenteConElementoAltri(Map<String, List<ResDistribuzione>> elementiPerCategoria, List<Map.Entry<String, Number>> entryList, List<String> categorieDaAccorpareComeAltri, StatsSearchForm search, Logger log) {
        ArrayList<ResDistribuzione> destList = new ArrayList<ResDistribuzione>();
        for (Map.Entry<String, Number> entry : entryList) {
            if (categorieDaAccorpareComeAltri.contains(entry.getKey())) continue;
            destList.addAll((Collection)elementiPerCategoria.get(entry.getKey()));
        }
        ArrayList<ResDistribuzione> colonnaAltri = new ArrayList<ResDistribuzione>();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
        if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
            occupazioneBanda = true;
        } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
            tempoMedio = true;
        }
        for (String categoria : categorieDaAccorpareComeAltri) {
            List<ResDistribuzione> categoriaDaAccorpare = elementiPerCategoria.get(categoria);
            if (!colonnaAltri.isEmpty() && categoriaDaAccorpare.size() != colonnaAltri.size()) {
                log.error("Categoria '" + categoria + "' possiede una dimensione '" + categoriaDaAccorpare.size() + "' diversa da quella attesa '" + colonnaAltri.size() + "'");
            }
            if (colonnaAltri.isEmpty()) {
                for (ResDistribuzione resDistribuzione : categoriaDaAccorpare) {
                    resDistribuzione.setRisultato("Altri");
                    if (resDistribuzione.getParentMap() != null) {
                        resDistribuzione.getParentMap().clear();
                    }
                    colonnaAltri.add(resDistribuzione);
                }
                continue;
            }
            for (int i = 0; i < colonnaAltri.size(); ++i) {
                ResDistribuzione resDistribuzioneColonnaAltri = (ResDistribuzione)colonnaAltri.get(i);
                ResDistribuzione resDistribuzioneDaAccorpare = categoriaDaAccorpare.get(i);
                resDistribuzioneColonnaAltri.setSomma(StatsUtils.sum(search, resDistribuzioneDaAccorpare.getSomma(), resDistribuzioneColonnaAltri.getSomma()));
            }
        }
        if (occupazioneBanda || tempoMedio) {
            for (int i = 0; i < colonnaAltri.size(); ++i) {
                ResDistribuzione resDistribuzioneColonnaAltri = (ResDistribuzione)colonnaAltri.get(i);
                resDistribuzioneColonnaAltri.setSomma(StatsUtils.avg(search, resDistribuzioneColonnaAltri.getSomma(), categorieDaAccorpareComeAltri.size()));
            }
        }
        destList.addAll(colonnaAltri);
        return destList;
    }

    private static void ordinaElementiAsseXPerSommaDecrescente(final StatsSearchForm search, List<Map.Entry<String, Number>> entryList) {
        Collections.sort(entryList, new Comparator<Map.Entry<String, Number>>(){

            @Override
            public int compare(Map.Entry<String, Number> entry1, Map.Entry<String, Number> entry2) {
                TipoVisualizzazione tipoVisualizzazione = null;
                if (search != null) {
                    tipoVisualizzazione = search.getTipoVisualizzazione();
                }
                if (tipoVisualizzazione != null) {
                    switch (tipoVisualizzazione) {
                        case NUMERO_TRANSAZIONI: 
                        case TEMPO_MEDIO_RISPOSTA: {
                            return Long.compare(entry2.getValue().longValue(), entry1.getValue().longValue());
                        }
                    }
                    return Double.compare(entry2.getValue().doubleValue(), entry1.getValue().doubleValue());
                }
                return Long.compare(entry2.getValue().longValue(), entry1.getValue().longValue());
            }
        });
    }

    private static void ordinaElementiAsseYPerData(StatsSearchForm search, List<ResDistribuzione> list) {
        Collections.sort(list, new Comparator<ResDistribuzione>(){

            @Override
            public int compare(ResDistribuzione entry1, ResDistribuzione entry2) {
                if (entry1 instanceof ResDistribuzione3D) {
                    Date date1 = ((ResDistribuzione3D)entry1).getData();
                    Date date2 = ((ResDistribuzione3D)entry2).getData();
                    return date1.compareTo(date2);
                }
                String date1 = ((ResDistribuzione3DCustom)entry1).getDatoCustom();
                String date2 = ((ResDistribuzione3DCustom)entry2).getDatoCustom();
                return date1.compareTo(date2);
            }
        });
    }

    public static ObjectNode getJsonAndamentoTemporale(List<Res> list, StatsSearchForm search, String caption, String subCaption, StatisticType tempo, String direzioneLabelParam, Integer numeroLabel) throws UtilsException {
        ObjectNode categoria;
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode grafico = jsonUtils.newObjectNode();
        SimpleDateFormat sdfLast = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
        SimpleDateFormat sdf = StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
        grafico.put("coloriAutomatici", false);
        grafico.put("xAxisGridLines", true);
        grafico.put("titolo", caption);
        grafico.put("sottotitolo", subCaption);
        grafico.put("xAxisLabelDirezione", JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        ArrayNode categorie = jsonUtils.newArrayNode();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        boolean distribuzionePerEsiti = false;
        if (search.isAndamentoTemporalePerEsiti()) {
            distribuzionePerEsiti = true;
        } else {
            TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
            if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
                occupazioneBanda = true;
            } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
                tempoMedio = true;
            }
        }
        int numeroCategorie = 1;
        boolean showSeries = false;
        if (list != null && !list.isEmpty()) {
            if (distribuzionePerEsiti) {
                numeroCategorie = 3;
                showSeries = true;
                categoria = jsonUtils.newObjectNode();
                categoria.put("key", "ok");
                categoria.put("label", "Ok");
                categoria.put("colore", "#95B964");
                categorie.add((JsonNode)categoria);
                ObjectNode categoria2 = jsonUtils.newObjectNode();
                categoria2.put("key", "fault");
                categoria2.put("label", "Fault Applicativo");
                categoria2.put("colore", "#FF8F52");
                categorie.add((JsonNode)categoria2);
                ObjectNode categoria3 = jsonUtils.newObjectNode();
                categoria3.put("key", "errore");
                categoria3.put("label", "Fallite");
                categoria3.put("colore", "#CD4A50");
                categorie.add((JsonNode)categoria3);
            } else if (occupazioneBanda) {
                numeroCategorie = search.getTipiBandaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiBanda();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null || !showSeries) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoBanda.COMPLESSIVA.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", TipoBanda.COMPLESSIVA.getValue());
                        categoria.put("colore", "#3B83B7");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoBanda.INTERNA.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", TipoBanda.INTERNA.getValue());
                        categoria.put("colore", "#FF8F52");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria = jsonUtils.newObjectNode();
                    categoria.put("key", TipoBanda.ESTERNA.getValue().toLowerCase().replace(" ", "_"));
                    categoria.put("label", TipoBanda.ESTERNA.getValue());
                    categoria.put("colore", "#95B964");
                    categorie.set(i, (JsonNode)categoria);
                }
            } else if (tempoMedio) {
                numeroCategorie = search.getTipiLatenzaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiLatenza();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null || !showSeries) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoLatenza.LATENZA_TOTALE.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", TipoLatenza.LATENZA_TOTALE.getValue());
                        categoria.put("colore", "#3B83B7");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria = jsonUtils.newObjectNode();
                        categoria.put("key", TipoLatenza.LATENZA_SERVIZIO.getValue().toLowerCase().replace(" ", "_"));
                        categoria.put("label", "Tempo Risposta Servizio");
                        categoria.put("colore", "#FF8F52");
                        categorie.set(i, (JsonNode)categoria);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria = jsonUtils.newObjectNode();
                    categoria.put("key", TipoLatenza.LATENZA_PORTA.getValue().toLowerCase().replace(" ", "_"));
                    categoria.put("label", TipoLatenza.LATENZA_PORTA.getValue());
                    categoria.put("colore", "#95B964");
                    categorie.set(i, (JsonNode)categoria);
                }
            }
        }
        if (categorie.isEmpty()) {
            categoria = jsonUtils.newObjectNode();
            categoria.put("key", "totale");
            categoria.put("label", StatsUtils.getSubCaption(search, true));
            categoria.put("colore", "#3B83B7");
            categorie.add((JsonNode)categoria);
        }
        grafico.set("categorie", (JsonNode)categorie);
        grafico.put("mostraLegenda", showSeries);
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put("yAxisLabel", yAxisName);
        ArrayNode dati = jsonUtils.newArrayNode();
        if (list != null && !list.isEmpty()) {
            List<Integer> posizioniDaVisualizzare = JsonStatsUtils.getListaIndiciLabelDaVisualizzare((list = StatsUtils.checkEstremi(list, search, tempo, sdf)).size(), numeroLabel);
            boolean nascondiLabel = posizioniDaVisualizzare != null;
            for (int z = 0; z < list.size(); ++z) {
                Res entry = list.get(z);
                ObjectNode point = jsonUtils.newObjectNode();
                Date r = entry.getRisultato();
                Calendar c = Calendar.getInstance();
                c.setTime(r);
                StringBuilder sb = new StringBuilder();
                if (StatisticType.ORARIA.equals((Object)tempo)) {
                    sdfLast.applyPattern("HH");
                    c.add(10, 1);
                    sb.append(sdf.format(r) + "-").append(sdfLast.format(c.getTime()));
                } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                    sdf.applyPattern("dd/MM/yy");
                    sdfLast.applyPattern("dd/MM/yy");
                    c.add(4, 1);
                    c.add(7, -1);
                    sb.append(sdf.format(r) + "-").append(sdfLast.format(c.getTime()));
                } else if (StatisticType.MENSILE.equals((Object)tempo)) {
                    sdf.applyPattern("MMM/yy");
                    sb.append(sdf.format(r));
                } else {
                    sb.append(sdf.format(r));
                }
                String label = sb.toString();
                point.put("data", JsonStatsUtils.escapeJsonLabel(label));
                if (!nascondiLabel) {
                    point.put("dataLabel", JsonStatsUtils.escapeJsonLabel(label));
                } else if (posizioniDaVisualizzare.contains(z)) {
                    point.put("dataLabel", JsonStatsUtils.escapeJsonLabel(label));
                } else {
                    point.put("dataLabel", "");
                }
                for (int j = 0; j < numeroCategorie; ++j) {
                    JsonNode keyNode = categorie.get(j).get("key");
                    String key = keyNode.asText();
                    Number sum = (Number)entry.getSomme().get(j);
                    String toolText = StatsUtils.getToolText(search, sum);
                    String value = StatsUtils.getValue(search, sum);
                    point.put(key, value);
                    point.put(key + "_tooltip", toolText);
                }
                dati.add((JsonNode)point);
            }
            grafico.set("dati", (JsonNode)dati);
        } else {
            categorie.removeAll();
            ObjectNode categoria2 = jsonUtils.newObjectNode();
            categoria2.put("key", "totale");
            categoria2.put("label", StatsUtils.getSubCaption(search, true));
            categoria2.put("colore", "#3B83B7");
            grafico.put("noData", "Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static ObjectNode getJsonAndamentoTemporaleStatPersonalizzate(SimpleDateFormat sdf, SimpleDateFormat sdfLastHour, StatisticType tempo, Map<String, List<Res>> results, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode grafico = jsonUtils.newObjectNode();
        grafico.put("titolo", caption);
        grafico.put("sottotitolo", subCaption);
        grafico.put("xAxisLabelDirezione", JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        grafico.put("coloriAutomatici", true);
        grafico.put("xAxisGridLines", true);
        grafico.put("colonneLegenda", 16);
        grafico.put("limiteColonneLegenda", 16);
        ArrayNode categorie = jsonUtils.newArrayNode();
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put("mostraLegenda", true);
        grafico.put("yAxisLabel", yAxisName);
        ArrayNode dati = jsonUtils.newArrayNode();
        if (results != null && results.size() > 0) {
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                ObjectNode point;
                String key = it.next();
                String catKey = "cat_" + i;
                List<Res> list = results.get(key);
                ObjectNode categoria = jsonUtils.newObjectNode();
                categoria.put("key", catKey);
                categoria.put("label", JsonStatsUtils.escapeJsonLabel(key));
                categorie.add((JsonNode)categoria);
                list = StatsUtils.checkEstremi(list, search, tempo, sdf);
                if (i < 1) {
                    for (Res entry : list) {
                        point = jsonUtils.newObjectNode();
                        Date r = entry.getRisultato();
                        StringBuilder sb = new StringBuilder();
                        if (StatisticType.ORARIA.equals((Object)tempo)) {
                            Calendar c = Calendar.getInstance();
                            c.setTime(r);
                            c.add(10, 1);
                            sb.append(sdf.format(r) + "-" + sdfLastHour.format(c.getTime()));
                        } else {
                            sb.append(sdf.format(r));
                        }
                        point.put("data", sb.toString());
                        point.put("dataLabel", sb.toString());
                        dati.add((JsonNode)point);
                    }
                }
                for (int j = 0; j < list.size(); ++j) {
                    Res entry;
                    entry = list.get(j);
                    point = (ObjectNode)dati.get(j);
                    Number sum = entry.getSomma();
                    String toolText = StatsUtils.getToolText(search, sum);
                    String value = StatsUtils.getValue(search, sum);
                    point.put(catKey, value);
                    point.put(catKey + "_tooltip", toolText);
                }
                ++i;
            }
            grafico.set("dati", (JsonNode)dati);
        } else {
            categorie.removeAll();
            ObjectNode categoria = jsonUtils.newObjectNode();
            categoria.put("key", "totale");
            categoria.put("label", StatsUtils.getSubCaption(search, true));
            categoria.put("colore", "#3B83B7");
            categorie.add((JsonNode)categoria);
            grafico.put("noData", "Non esistono transazioni per il periodo selezionato");
        }
        grafico.set("categorie", (JsonNode)categorie);
        return grafico;
    }

    public static ObjectNode getJsonPieChartStatistichePersonalizzate(List<ResDistribuzione> list, StatsSearchForm search, int slice, String caption, String subCaption) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode grafico = jsonUtils.newObjectNode();
        grafico.put("titolo", caption);
        grafico.put("sottotitolo", subCaption);
        grafico.put("coloriAutomatici", true);
        grafico.put("xAxisGridLines", true);
        grafico.put("clickItemLegenda", false);
        grafico.put("valoreRealeTorta", true);
        grafico.put("colonneLegenda", 16);
        grafico.put("limiteColonneLegenda", 16);
        grafico.put("valueOnLegend", true);
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
        if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
            occupazioneBanda = true;
        } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
            tempoMedio = true;
        }
        ArrayNode dati = jsonUtils.newArrayNode();
        int maxLenghtLabel = 0;
        if (list != null && !list.isEmpty()) {
            int i = 0;
            long altriSum = 0L;
            int altriSumNumeroItem = 0;
            for (ResDistribuzione entry : list) {
                String r = entry.getRisultato();
                Number sum = entry.getSomma();
                if (++i <= slice) {
                    if (r.length() > maxLenghtLabel) {
                        maxLenghtLabel = r.length();
                    }
                    String toolText = StatsUtils.getToolText(search, sum);
                    ObjectNode spicchio = jsonUtils.newObjectNode();
                    spicchio.put("label", JsonStatsUtils.escapeJsonLabel(r));
                    spicchio.put("tooltip", toolText);
                    if (sum instanceof Long) {
                        Long v = (Long)sum;
                        spicchio.put("value", v);
                    } else if (sum instanceof Integer) {
                        Integer vi = (Integer)sum;
                        spicchio.put("value", vi);
                    } else if (sum instanceof Float) {
                        Float vf = (Float)sum;
                        spicchio.put("value", vf);
                    } else if (sum instanceof Double) {
                        Double vd = (Double)sum;
                        spicchio.put("value", vd);
                    }
                    dati.add((JsonNode)spicchio);
                    continue;
                }
                altriSum += sum.longValue();
                ++altriSumNumeroItem;
            }
            if (i > slice) {
                long v = altriSum;
                if (altriSumNumeroItem > 1 && (occupazioneBanda || tempoMedio) && altriSumNumeroItem > 0) {
                    v /= (long)altriSumNumeroItem;
                }
                String toolText = StatsUtils.getToolText(search, v);
                ObjectNode spicchio = jsonUtils.newObjectNode();
                spicchio.put("label", "Altri");
                spicchio.put("tooltip", toolText);
                spicchio.put("value", v);
                dati.add((JsonNode)spicchio);
            }
            if (maxLenghtLabel > 50) {
                grafico.put("limitLegenda", 50);
            }
            grafico.set("dati", (JsonNode)dati);
        } else {
            grafico.put("noData", "Non esistono transazioni per il periodo selezionato");
        }
        grafico.set("dati", (JsonNode)dati);
        return grafico;
    }

    public static ObjectNode getJsonBarChartStatistichePersonalizzate(List<ResDistribuzione> list, StatsSearchForm search, String direzioneLabelParam, int slice, String caption, String subCaption) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode grafico = jsonUtils.newObjectNode();
        grafico.put("titolo", caption);
        grafico.put("sottotitolo", subCaption);
        grafico.put("xAxisLabelDirezione", JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        grafico.put("coloriAutomatici", false);
        grafico.put("xAxisGridLines", true);
        ArrayNode categorie = jsonUtils.newArrayNode();
        ObjectNode categoria = jsonUtils.newObjectNode();
        categoria.put("key", "totale");
        categoria.put("label", StatsUtils.getSubCaption(search, true));
        categoria.put("colore", "#3B83B7");
        categorie.add((JsonNode)categoria);
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        int numeroCategorie = 1;
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.set("categorie", (JsonNode)categorie);
        grafico.put("mostraLegenda", false);
        grafico.put("yAxisLabel", yAxisName);
        ArrayNode dati = jsonUtils.newArrayNode();
        int maxLenghtLabel = 0;
        if (list != null && !list.isEmpty()) {
            int iterazione = 0;
            long altriSumSerie1 = 0L;
            int altriSumSerie1NumeroItem = 0;
            if (slice != Integer.MAX_VALUE) {
                slice *= numeroCategorie;
            }
            for (int z = 0; z < list.size(); ++z) {
                ResDistribuzione entry = list.get(z);
                ObjectNode bar = jsonUtils.newObjectNode();
                for (int j = 0; j < numeroCategorie; ++j) {
                    JsonNode keyNode = categorie.get(j).get("key");
                    String key = keyNode.asText();
                    Number sum = entry.getSomma();
                    if (++iterazione <= slice) {
                        String r = entry.getRisultato();
                        if (j == 0) {
                            if (r.length() > maxLenghtLabel) {
                                maxLenghtLabel = r.length();
                            }
                            bar.put("data", JsonStatsUtils.escapeJsonLabel(r));
                            bar.put("dataLabel", JsonStatsUtils.escapeJsonLabel(r));
                        }
                        String value = StatsUtils.getValue(search, sum);
                        String toolText = StatsUtils.getToolText(search, sum);
                        bar.put(key, value);
                        bar.put(key + "_tooltip", toolText);
                        if (j != numeroCategorie - 1) continue;
                        dati.add((JsonNode)bar);
                        continue;
                    }
                    if (j != 0) continue;
                    altriSumSerie1 += sum.longValue();
                    ++altriSumSerie1NumeroItem;
                }
            }
            if (iterazione > slice) {
                ObjectNode bar = jsonUtils.newObjectNode();
                bar.put("data", "Altri");
                bar.put("dataLabel", "Altri");
                for (int j = 0; j < numeroCategorie; ++j) {
                    JsonNode keyNode = categorie.get(j).get("key");
                    String key = keyNode.asText();
                    long v = -1L;
                    if (j == 0) {
                        v = altriSumSerie1;
                        if (altriSumSerie1NumeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altriSumSerie1NumeroItem;
                        }
                    }
                    String toolText = StatsUtils.getToolText(search, v);
                    String value = StatsUtils.getValue(search, v);
                    bar.put(key, value);
                    bar.put(key + "_tooltip", toolText);
                }
                dati.add((JsonNode)bar);
            }
            if (maxLenghtLabel > 50) {
                grafico.put("limit", 50);
            }
            grafico.set("dati", (JsonNode)dati);
        } else {
            categorie.removeAll();
            categoria = jsonUtils.newObjectNode();
            categoria.put("key", "totale");
            categoria.put("label", StatsUtils.getSubCaption(search, true));
            categoria.put("colore", "#3B83B7");
            categorie.add((JsonNode)categoria);
            grafico.put("noData", "Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static int getDirezioneLabel(String direzione) {
        if (StringUtils.isNotEmpty((CharSequence)direzione)) {
            if ("Orizzontale".equals(direzione)) {
                return 0;
            }
            if ("Obliquo".equals(direzione)) {
                return -45;
            }
            if ("Verticale".equals(direzione)) {
                return -90;
            }
        }
        return 0;
    }

    public static String escapeJsonLabel(String label) {
        String escaped = StringEscapeUtils.escapeXml10((String)label);
        escaped = escaped.replace("\\", "\\\\");
        return escaped;
    }

    public static List<Integer> getListaIndiciLabelDaVisualizzare(int size, Integer numeroLabel) {
        ArrayList<Integer> posizioni = null;
        if (numeroLabel != null && size > numeroLabel) {
            if (numeroLabel < 2) {
                numeroLabel = 2;
            }
            posizioni = new ArrayList<Integer>();
            posizioni.add(0);
            int denom = numeroLabel - 1;
            int numeroPosizioni = numeroLabel - 2;
            for (int j = 1; j <= numeroPosizioni; ++j) {
                int pos = j * size / denom;
                posizioni.add(pos);
            }
            posizioni.add(size - 1);
        }
        return posizioni;
    }
}

