/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.batch;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import org.openspcoop2.pdd.core.batch.AbstractGestore;
import org.openspcoop2.pdd.core.batch.TipoRuntimeRepository;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class GestoreBuste
extends AbstractGestore {
    private boolean useDataRegistrazione;

    public GestoreBuste(boolean debug, boolean logQuery, Logger logCore, Logger logSql, int finestraSecondi, int refreshConnection, String tipoRepositoryBuste, boolean useDataRegistrazione) throws UtilsException {
        super(TipoRuntimeRepository.BUSTE, debug, logQuery, logCore, logSql, finestraSecondi, refreshConnection, tipoRepositoryBuste);
        this.useDataRegistrazione = useDataRegistrazione;
    }

    @Override
    public void process() throws UtilsException {
        try {
            this.processEngine(true);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        try {
            this.processEngine(false);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private void processEngine(boolean scaduti) throws UtilsException, SQLException {
        try {
            if (scaduti) {
                this.cleanBusteScadute();
            } else {
                Date minDate = null;
                Date maxDate = null;
                if (this.useDataRegistrazione) {
                    minDate = RepositoryBuste.getDataRegistrazioneBustaMinima((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql);
                    maxDate = RepositoryBuste.getDataRegistrazioneBustaMassima((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql);
                } else {
                    minDate = RepositoryBuste.getDataScadenzaBustaMinima((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql);
                    maxDate = RepositoryBuste.getDataScadenzaBustaMassima((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql);
                }
                if ((minDate == null || maxDate == null) && this.debug) {
                    this.logCoreDebug("Non esistono buste da eliminare");
                    return;
                }
                Date leftInterval = minDate;
                Date rightInterval = null;
                if (minDate != null) {
                    rightInterval = new Date(minDate.getTime() + (long)(this.finestraSecondi * 1000));
                    if (rightInterval.after(maxDate)) {
                        rightInterval = maxDate;
                    }
                } else {
                    rightInterval = maxDate;
                }
                while (rightInterval != null && rightInterval.before(maxDate)) {
                    this.cleanBusteInutili(leftInterval, rightInterval);
                    leftInterval = rightInterval;
                    if (!(rightInterval = new Date(leftInterval.getTime() + (long)(this.finestraSecondi * 1000))).after(maxDate)) continue;
                    rightInterval = maxDate;
                }
                this.cleanBusteInutili(leftInterval, rightInterval);
            }
        }
        catch (Throwable e) {
            String msgErrore = "Errore durante la gestione del repository '" + this.tipoRuntimeRepository.getValue() + "': " + e.getMessage();
            this.logCoreError(msgErrore, e);
            throw new UtilsException(msgErrore, e);
        }
        finally {
            this.closeConnection();
        }
    }

    private void cleanBusteInutili(Date leftInterval, Date rightInterval) throws ProtocolException, SQLException {
        SortedMap eliminati;
        Object periodo = null;
        if (this.debug) {
            periodo = rightInterval != null ? (leftInterval != null ? "[" + DateUtils.getSimpleDateFormatMs().format(leftInterval) + " - " + DateUtils.getSimpleDateFormatMs().format(rightInterval) + "] " : "[* - " + DateUtils.getSimpleDateFormatMs().format(rightInterval) + "] ") : (leftInterval != null ? "[" + DateUtils.getSimpleDateFormatMs().format(leftInterval) + " - *] " : "[* - *] ");
        }
        if (this.debug) {
            this.logCoreDebug((String)periodo + "Ricerca buste da eliminare in 'INBOX' ...");
        }
        int count = RepositoryBuste.countBusteInutiliIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository, (Date)leftInterval, (Date)rightInterval, (boolean)this.useDataRegistrazione);
        if (this.debug) {
            this.logCoreDebug((String)periodo + "Trovate " + count + " buste da eliminare in 'INBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug((String)periodo + "Eliminazione " + count + " buste in 'INBOX' ...");
            }
            eliminati = RepositoryBuste.deleteBusteInutiliIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository, (Date)leftInterval, (Date)rightInterval, (boolean)this.useDataRegistrazione);
            if (this.debug) {
                this.logCoreDebug((String)periodo + "Eliminazione " + count + " buste in 'INBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
        if (this.debug) {
            this.logCoreDebug((String)periodo + "Ricerca buste da eliminare in 'OUTBOX' ...");
        }
        count = RepositoryBuste.countBusteInutiliIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository, (Date)leftInterval, (Date)rightInterval, (boolean)this.useDataRegistrazione);
        if (this.debug) {
            this.logCoreDebug((String)periodo + "Trovate " + count + " buste da eliminare in 'OUTBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug((String)periodo + "Eliminazione " + count + " buste in 'OUTBOX' ...");
            }
            eliminati = RepositoryBuste.deleteBusteInutiliIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository, (Date)leftInterval, (Date)rightInterval, (boolean)this.useDataRegistrazione);
            if (this.debug) {
                this.logCoreDebug((String)periodo + "Eliminazione " + count + " buste in 'OUTBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
    }

    private void cleanBusteScadute() throws ProtocolException, SQLException {
        SortedMap eliminati;
        if (this.debug) {
            this.logCoreDebug("Ricerca buste scadute in 'INBOX' ...");
        }
        int count = RepositoryBuste.countBusteScaduteIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository);
        if (this.debug) {
            this.logCoreDebug("Trovate " + count + " buste scadute in 'INBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug("Eliminazione " + count + " buste scadute in 'INBOX' ...");
            }
            eliminati = RepositoryBuste.deleteBusteScaduteIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository);
            if (this.debug) {
                this.logCoreDebug("Eliminazione " + count + " buste scadute in 'INBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
        if (this.debug) {
            this.logCoreDebug("Ricerca buste scadute in 'OUTBOX' ...");
        }
        count = RepositoryBuste.countBusteScaduteIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository);
        if (this.debug) {
            this.logCoreDebug("Trovate " + count + " buste scadute in 'OUTBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug("Eliminazione " + count + " buste scadute in 'OUTBOX' ...");
            }
            eliminati = RepositoryBuste.deleteBusteScaduteIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (IGestoreRepository)this.repository);
            if (this.debug) {
                this.logCoreDebug("Eliminazione " + count + " buste scadute in 'OUTBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
    }
}

