/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.FunctionMapper;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ELContextImpl
extends ELContext {
    private static final FunctionMapper functionMapper = new NoopFunctionMapper();
    private VariableMapper variableMapper;
    private ELResolver resolver;

    public ELContextImpl(ELResolver resolver) {
        this.resolver = resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return functionMapper;
    }

    public VariableMapper getVariableMapper() {
        if (this.variableMapper == null) {
            this.variableMapper = new VariableMapperImpl();
        }
        return this.variableMapper;
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    private static class VariableMapperImpl
    extends VariableMapper {
        private Map<String, ValueExpression> variables = new HashMap<String, ValueExpression>();

        public ValueExpression resolveVariable(String s) {
            return this.variables.get(s);
        }

        public ValueExpression setVariable(String s, ValueExpression valueExpression) {
            return this.variables.put(s, valueExpression);
        }
    }

    private static class NoopFunctionMapper
    extends FunctionMapper {
        private NoopFunctionMapper() {
        }

        public Method resolveFunction(String s, String s1) {
            return null;
        }
    }
}

