/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.event;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;

public class MethodExpressionValueChangeListener
implements ValueChangeListener,
StateHolder {
    private MethodExpression methodExpression = null;
    private boolean isTransient;

    public MethodExpressionValueChangeListener() {
    }

    public MethodExpressionValueChangeListener(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    @Override
    public void processValueChange(ValueChangeEvent valueChangeEvent) throws AbortProcessingException {
        if (valueChangeEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            this.methodExpression.invoke(elContext, new Object[]{valueChangeEvent});
        }
        catch (ELException ee) {
            throw new AbortProcessingException(ee.getMessage(), ee.getCause());
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{this.methodExpression};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)((Object[])state)[0];
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }
}

