/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public final class FacesServlet
implements Servlet {
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private static final Logger LOGGER = Logger.getLogger("javax.faces.webapp", "javax.faces.LogStrings");
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;
    private ServletConfig servletConfig = null;

    public void destroy() {
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.servletConfig = null;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            ResourceBundle rb = LOGGER.getResourceBundle();
            String msg = rb.getString("severe.webapp.facesservlet.init_failed");
            Throwable rootCause = e.getCause() != null ? e.getCause() : e;
            LOGGER.log(Level.SEVERE, msg, rootCause);
            throw new UnavailableException(msg);
        }
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = servletConfig.getInitParameter(LIFECYCLE_ID_ATTR);
            if (null == lifecycleId) {
                lifecycleId = servletConfig.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
            }
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        if (pathInfo != null && ((pathInfo = pathInfo.toUpperCase()).startsWith("/WEB-INF/") || pathInfo.equals("/WEB-INF") || pathInfo.startsWith("/META-INF/") || pathInfo.equals("/META-INF"))) {
            ((HttpServletResponse)response).sendError(404);
            return;
        }
        FacesContext context = this.facesContextFactory.getFacesContext(this.servletConfig.getServletContext(), request, response, this.lifecycle);
        try {
            this.lifecycle.execute(context);
            this.lifecycle.render(context);
        }
        catch (FacesException e) {
            Throwable t = e.getCause();
            if (t == null) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new ServletException(t.getMessage(), t);
        }
        finally {
            context.release();
        }
    }
}

