/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.openspcoop2.core.config.rs.server.model.Applicativo;
import org.openspcoop2.core.config.rs.server.model.BaseCredenziali;
import org.openspcoop2.core.config.rs.server.model.ListaApplicativi;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

@Path(value="/")
public interface ApplicativiApi {
    @POST
    @Path(value="/applicativi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Creazione di un applicativo", tags={"applicativi"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void createApplicativo(@Valid Applicativo var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @DELETE
    @Path(value="/applicativi/{nome}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina un applicativo", tags={"applicativi"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Applicativo eliminato con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteApplicativo(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/applicativi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca applicativi", tags={"applicativi"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ricerca eseguita correttamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaApplicativi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaApplicativi findAllApplicativi(@QueryParam(value="profilo") ProfiloEnum var1, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @QueryParam(value="q") String var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="offset") @DefaultValue(value="0") Integer var5, @QueryParam(value="ruolo") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_credenziali") ModalitaAccessoEnum var7, @QueryParam(value="profilo_qualsiasi") @DefaultValue(value="false") Boolean var8, @QueryParam(value="soggetto_qualsiasi") @DefaultValue(value="false") Boolean var9);

    @GET
    @Path(value="/applicativi/{nome}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di un applicativo", tags={"applicativi"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati dell'applicativo restituiti con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=Applicativo.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public Applicativo getApplicativo(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @PUT
    @Path(value="/applicativi/{nome}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di un applicativo", tags={"applicativi"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Applicativo aggiornato con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateApplicativo(@Valid Applicativo var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4);

    @PUT
    @Path(value="/applicativi/{nome}/credenziali")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica le credenziali associate ad un applicativo", tags={"applicativi"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Resource updated"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateCredenzialiApplicativo(@Valid BaseCredenziali var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4);
}

