/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.rs.server.api.impl.ProtocolPropertiesHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.config.Startup;
import org.openspcoop2.core.config.rs.server.model.BaseFruizioneModIOAuth;
import org.openspcoop2.core.config.rs.server.model.BaseKeyStore;
import org.openspcoop2.core.config.rs.server.model.BaseKeyStoreArchive;
import org.openspcoop2.core.config.rs.server.model.BaseKeyStorePublicFile;
import org.openspcoop2.core.config.rs.server.model.BaseModIRichiestaInformazioniUtenteAudit;
import org.openspcoop2.core.config.rs.server.model.BaseTrustStore;
import org.openspcoop2.core.config.rs.server.model.Erogazione;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModI;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIInfoGenerali;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIRest;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIRestRichiesta;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIRestRichiestaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIRestRichiestaSicurezzaMessaggioContemporaneita;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIRestRisposta;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIRestRispostaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModIRestRispostaSicurezzaMessaggioContemporaneita;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModISignalHub;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModISoap;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModISoapRichiesta;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModISoapRichiestaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModISoapRisposta;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModISoapRispostaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.Fruizione;
import org.openspcoop2.core.config.rs.server.model.FruizioneModI;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIOAuth;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRest;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRestRichiesta;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRestRichiestaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRestRichiestaSicurezzaMessaggioContemporaneita;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRestRisposta;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRestRispostaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRestRispostaSicurezzaMessaggioContemporaneita;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRichiestaInformazioneUtente;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRichiestaInformazioneUtenteAudit;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRichiestaInformazioniUtenteAudit;
import org.openspcoop2.core.config.rs.server.model.FruizioneModISoap;
import org.openspcoop2.core.config.rs.server.model.FruizioneModISoapRichiesta;
import org.openspcoop2.core.config.rs.server.model.FruizioneModISoapRichiestaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.FruizioneModISoapRisposta;
import org.openspcoop2.core.config.rs.server.model.FruizioneModISoapRispostaSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreArchive;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreDefault;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreFile;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreHSM;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreRidefinito;
import org.openspcoop2.core.config.rs.server.model.ModIKeystoreEnum;
import org.openspcoop2.core.config.rs.server.model.ModIKeystoreFullEnum;
import org.openspcoop2.core.config.rs.server.model.ModIKeystoreTipologiaEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioRestAlgoritmoFirma;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioRestRiferimentoX509;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioRestRiferimentoX509Risposta;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioRestSameDifferentEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioRestTokenChoiseEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioSoapAlgoritmoFirma;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioSoapFormaCanonicaXml;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioSoapRiferimentoX509;
import org.openspcoop2.core.config.rs.server.model.ModITrustStore;
import org.openspcoop2.core.config.rs.server.model.ModITrustStoreDefault;
import org.openspcoop2.core.config.rs.server.model.ModITrustStoreRidefinito;
import org.openspcoop2.core.config.rs.server.model.ModITruststoreEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfErogazioneModIModi;
import org.openspcoop2.core.config.rs.server.model.OneOfErogazioneModIRestRichiestaSicurezzaMessaggioTruststore;
import org.openspcoop2.core.config.rs.server.model.OneOfErogazioneModIRestRichiestaSicurezzaMessaggioTruststoreSsl;
import org.openspcoop2.core.config.rs.server.model.OneOfErogazioneModIRestRispostaSicurezzaMessaggioKeystore;
import org.openspcoop2.core.config.rs.server.model.OneOfErogazioneModi;
import org.openspcoop2.core.config.rs.server.model.OneOfFruizioneModIModi;
import org.openspcoop2.core.config.rs.server.model.OneOfFruizioneModIRestRichiestaSicurezzaMessaggioKeystore;
import org.openspcoop2.core.config.rs.server.model.OneOfFruizioneModIRestRispostaSicurezzaMessaggioTruststore;
import org.openspcoop2.core.config.rs.server.model.OneOfFruizioneModIRestRispostaSicurezzaMessaggioTruststoreSsl;
import org.openspcoop2.core.config.rs.server.model.OneOfFruizioneModISoapRispostaSicurezzaMessaggioTruststore;
import org.openspcoop2.core.config.rs.server.model.OneOfFruizioneModi;
import org.openspcoop2.core.config.rs.server.model.StatoDefaultRidefinitoEnum;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.core.config.rs.server.model.TipoConfigurazioneFruizioneEnum;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.utils.ModISecurityUtils;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;

public class ModiErogazioniApiHelper {
    private static final String OPERAZIONE_UTILIZZABILE_SOLO_CON_MODI = "Operazione utilizzabile solamente con Profilo 'ModI'";
    private static final String SPECIFICARE_CONFIGURAZIONE_MODI = "Specificare la configurazione 'ModI'";
    private static final String IMPOSSIBILE_ABILITARE_SICUREZZA = "Impossibile abilitare la sicurezza messaggio, deve essere abilitata nella API implementata";
    private static final String SICUREZZA_MESSAGGIO_NON_PRESENTE = "Per la seguente configurazione risultano necessari inseriri gli elementi di richiesta e risposta per la sicurezza messaggio";
    private static final String SICUREZZA_MESSAGGIO_NON_NECESSARIA = "Per la seguente configurazione la sicurezza messaggio non risulta abilitata gli elementi di richiesta e risposta non devono essere presenti";
    private static final String TIPO_TRUSTSTORE_PKCS11_NON_INDICATO = "Tipo truststore pks11 non indicato";
    private static final String TIPO_TRUSTSTORE_PDND_NON_INDICATO = "Tipo truststore pdnd non indicato";
    private static final String TIPO_TRUSTSTORE_PDND_SCONOSCIUTO_PREFIX = "Tipo truststore pdnd sconosciuto: ";
    private static final String TIPO_TRUSTSTORE_SCONOSCIUTO_PREFIX = "Tipo truststore sconosciuto: ";
    private static final String TIPO_TRUSTSTORE_JWK_NON_SUPPORTATO_SSL = "Truststore JWK non supportato con configurazione ssl";
    private static final String TIPO_TRUSTSTORE_PDND_NON_SUPPORTATO_SSL = "Truststore PDND non supportato con configurazione ssl";

    public static FruizioneModI getFruizioneModI(AccordoServizioParteSpecifica asps, ErogazioniEnv env, ProfiloEnum profilo, Map<String, AbstractProperty<?>> p) throws CoreException, DriverRegistroServiziNotFound, DriverRegistroServiziException {
        if (profilo == null || !profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(OPERAZIONE_UTILIZZABILE_SOLO_CON_MODI);
        }
        AccordoServizioParteComune aspc = ModiErogazioniApiHelper.getAccordoServizioParteComune(asps, env);
        TipoApiEnum protocollo = ModiErogazioniApiHelper.getTipoApi(aspc);
        String schemaAudit = ModiErogazioniApiHelper.getSchemaAudit(aspc, protocollo);
        FruizioneModI fruizionemodi = new FruizioneModI();
        if (p != null) {
            FruizioneModIOAuth oauth = ModiErogazioniApiHelper.getFruizioneModIOAuth(p, protocollo);
            if (oauth != null) {
                fruizionemodi.setModi(oauth);
            } else if (protocollo.equals((Object)TipoApiEnum.SOAP)) {
                fruizionemodi.setModi(ModiErogazioniApiHelper.getFruizioneModISoap(p, schemaAudit));
            } else {
                fruizionemodi.setModi(ModiErogazioniApiHelper.getFruizioneModIRest(p, schemaAudit));
            }
        }
        return fruizionemodi;
    }

    public static ErogazioneModI getErogazioneModi(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, ErogazioniEnv env, ProfiloEnum profilo, Map<String, AbstractProperty<?>> p) throws CoreException, DriverRegistroServiziNotFound, DriverRegistroServiziException {
        if (profilo == null || !profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(OPERAZIONE_UTILIZZABILE_SOLO_CON_MODI);
        }
        TipoApiEnum protocollo = ModiErogazioniApiHelper.getTipoApi(asps, env);
        ErogazioneModI erogazionemodi = new ErogazioneModI();
        if (p != null) {
            if (protocollo.equals((Object)TipoApiEnum.SOAP)) {
                erogazionemodi.setModi(ModiErogazioniApiHelper.getSOAPProperties(aspc, asps, p));
            } else {
                erogazionemodi.setModi(ModiErogazioniApiHelper.getRestProperties(aspc, asps, p));
            }
        }
        return erogazionemodi;
    }

    private static boolean isSicurezzaMessaggioAbilitata(AccordoServizioParteComune aspc, String portType) {
        ArrayList<String> valueAbilitato = new ArrayList<String>();
        valueAbilitato.add("idam01");
        valueAbilitato.add("idam02");
        valueAbilitato.add("idam0301");
        valueAbilitato.add("idam0302");
        valueAbilitato.add("idam0401");
        valueAbilitato.add("idam0402");
        return ModiErogazioniApiHelper.isAbilitataEngine(aspc, portType, "modipaSecurityMessageProfile", valueAbilitato, null);
    }

    private static boolean isSicurezzaMessaggioHeaderDuplicati(AccordoServizioParteComune aspc, String portType) {
        if (!ServiceBinding.REST.equals((Object)aspc.getServiceBinding())) {
            return false;
        }
        ArrayList<String> valueAbilitato = new ArrayList<String>();
        valueAbilitato.add("authorization_modipa");
        valueAbilitato.add("autonlyreq_modipa");
        valueAbilitato.add("authorization_custom");
        valueAbilitato.add("autonlyreq_custom");
        return ModiErogazioniApiHelper.isAbilitataEngine(aspc, portType, "modipaSecurityMessageHeaderName", valueAbilitato, null);
    }

    private static boolean isInfoUtenteAbilitato(AccordoServizioParteComune aspc, String portType) {
        return ModiErogazioniApiHelper.isAbilitataEngine(aspc, portType, "modipaSecurityMessageCorniceSicurezza", null, true);
    }

    private static boolean isAbilitataEngine(AccordoServizioParteComune aspc, String portType, String pName, List<String> valueAbilitatoString, Boolean valueAbilitatoBoolean) {
        block10: {
            Boolean booleanValue;
            String stringValue;
            block9: {
                if (aspc.getProtocolPropertyList() == null) {
                    return false;
                }
                stringValue = null;
                booleanValue = null;
                for (ProtocolProperty p : aspc.getProtocolPropertyList()) {
                    if (!p.getName().equals(pName)) continue;
                    stringValue = p.getValue();
                    booleanValue = p.getBooleanValue();
                    break;
                }
                if (valueAbilitatoString != null && StringUtils.isNotEmpty(stringValue) && valueAbilitatoString.contains(stringValue) || valueAbilitatoBoolean != null && booleanValue != null && valueAbilitatoBoolean.booleanValue() == booleanValue.booleanValue()) {
                    return true;
                }
                if (!ServiceBinding.REST.equals((Object)aspc.getServiceBinding()) || aspc.sizeResourceList() <= 0) break block9;
                for (Resource resource : aspc.getResourceList()) {
                    stringValue = null;
                    booleanValue = null;
                    for (ProtocolProperty p : resource.getProtocolPropertyList()) {
                        if (!p.getName().equals(pName)) continue;
                        stringValue = p.getValue();
                        booleanValue = p.getBooleanValue();
                        break;
                    }
                    if ((valueAbilitatoString == null || !StringUtils.isNotEmpty((CharSequence)stringValue) || !valueAbilitatoString.contains(stringValue)) && (valueAbilitatoBoolean == null || booleanValue == null || valueAbilitatoBoolean.booleanValue() != booleanValue.booleanValue())) continue;
                    return true;
                }
                break block10;
            }
            if (portType == null || aspc.sizePortTypeList() <= 0) break block10;
            PortType pt = null;
            for (PortType ptCheck : aspc.getPortTypeList()) {
                if (!portType.equals(ptCheck.getNome())) continue;
                pt = ptCheck;
                break;
            }
            if (pt != null && pt.sizeAzioneList() > 0) {
                for (Operation op : pt.getAzioneList()) {
                    stringValue = null;
                    booleanValue = null;
                    for (ProtocolProperty p : op.getProtocolPropertyList()) {
                        if (!p.getName().equals(pName)) continue;
                        stringValue = p.getValue();
                        booleanValue = p.getBooleanValue();
                        break;
                    }
                    if ((valueAbilitatoString == null || !StringUtils.isNotEmpty((CharSequence)stringValue) || !valueAbilitatoString.contains(stringValue)) && (valueAbilitatoBoolean == null || booleanValue == null || valueAbilitatoBoolean.booleanValue() != booleanValue.booleanValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static ErogazioneConf getErogazioneConf(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        ErogazioneConf c = new ErogazioneConf(new ModiErogazioniApiHelper());
        AccordoServizioParteComune aspc = env.apcCore.getAccordoServizioFull(asps.getIdAccordo().longValue());
        c.sicurezzaMessaggioAPIAbilitata = ModiErogazioniApiHelper.isSicurezzaMessaggioAbilitata(aspc, asps.getPortType());
        c.sicurezzaMessaggioHeaderDuplicatiAbilitato = ModiErogazioniApiHelper.isSicurezzaMessaggioHeaderDuplicati(aspc, asps.getPortType());
        c.protocollo = ModiErogazioniApiHelper.getTipoApi(aspc);
        return c;
    }

    private static FruizioneConf getFruizioneConf(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        FruizioneConf c = new FruizioneConf(new ModiErogazioniApiHelper());
        AccordoServizioParteComune aspc = env.apcCore.getAccordoServizioFull(asps.getIdAccordo().longValue());
        c.sicurezzaMessaggioAPIAbilitata = ModiErogazioniApiHelper.isSicurezzaMessaggioAbilitata(aspc, asps.getPortType());
        c.sicurezzaMessaggioHeaderDuplicatiAbilitato = ModiErogazioniApiHelper.isSicurezzaMessaggioHeaderDuplicati(aspc, asps.getPortType());
        c.informazioniUtenteAbilitato = ModiErogazioniApiHelper.isInfoUtenteAbilitato(aspc, asps.getPortType());
        c.protocollo = ModiErogazioniApiHelper.getTipoApi(aspc);
        c.schemaAudit = ModiErogazioniApiHelper.getSchemaAudit(aspc, c.protocollo);
        return c;
    }

    private static TipoApiEnum getTipoApi(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        AccordoServizioParteComune aspc = env.apcCore.getAccordoServizioFull(asps.getIdAccordo().longValue());
        return ModiErogazioniApiHelper.getTipoApi(aspc);
    }

    private static TipoApiEnum getTipoApi(AccordoServizioParteComune aspc) {
        return aspc.getFormatoSpecifica().equals((Object)FormatoSpecifica.WSDL_11) ? TipoApiEnum.SOAP : TipoApiEnum.REST;
    }

    private static String getSchemaAudit(AccordoServizioParteComune aspc, TipoApiEnum tipoApi) {
        String s;
        if (aspc != null && aspc.sizeProtocolPropertyList() > 0 && (s = ModiErogazioniApiHelper.getSchemaAudit(aspc.getProtocolPropertyList())) != null) {
            return s;
        }
        if (TipoApiEnum.REST.equals((Object)tipoApi)) {
            return ModiErogazioniApiHelper.getSchemaAuditRest(aspc);
        }
        return ModiErogazioniApiHelper.getSchemaAuditSoap(aspc);
    }

    private static String getSchemaAuditRest(AccordoServizioParteComune aspc) {
        if (aspc != null && aspc.sizeResourceList() > 0) {
            for (Resource r : aspc.getResourceList()) {
                String s;
                if (r == null || r.sizeProtocolPropertyList() <= 0 || (s = ModiErogazioniApiHelper.getSchemaAudit(r.getProtocolPropertyList())) == null) continue;
                return s;
            }
        }
        return null;
    }

    private static String getSchemaAuditSoap(AccordoServizioParteComune aspc) {
        if (aspc != null && aspc.sizePortTypeList() > 0) {
            for (PortType pt : aspc.getPortTypeList()) {
                String s;
                if (pt == null || pt.sizeAzioneList() <= 0 || (s = ModiErogazioniApiHelper.getSchemaAuditSoap(pt.getAzioneList())) == null) continue;
                return s;
            }
        }
        return null;
    }

    private static String getSchemaAuditSoap(List<Operation> operation) {
        if (operation != null && !operation.isEmpty()) {
            for (Operation op : operation) {
                String s;
                if (op == null || op.sizeProtocolPropertyList() <= 0 || (s = ModiErogazioniApiHelper.getSchemaAudit(op.getProtocolPropertyList())) == null) continue;
                return s;
            }
        }
        return null;
    }

    private static String getSchemaAudit(List<ProtocolProperty> ppList) {
        if (ppList != null && !ppList.isEmpty()) {
            for (ProtocolProperty pp : ppList) {
                if (!"modipaSecurityMessageCorniceSicurezzaSchema".equals(pp.getName()) || pp.getValue() == null || !StringUtils.isNotEmpty((CharSequence)pp.getValue())) continue;
                return pp.getValue();
            }
        }
        return null;
    }

    private static AccordoServizioParteComune getAccordoServizioParteComune(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        return env.apcCore.getAccordoServizioFull(asps.getIdAccordo().longValue());
    }

    private static ErogazioneModISoapRichiesta getErogazioneSOAPRichiesta(Map<String, AbstractProperty<?>> p) throws CoreException {
        BaseModIRichiestaInformazioniUtenteAudit audit;
        String wsaTo;
        ErogazioneModISoapRichiesta richiesta = new ErogazioneModISoapRichiesta();
        ErogazioneModISoapRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = new ErogazioneModISoapRichiestaSicurezzaMessaggio();
        String truststoreMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreMode", true);
        if (truststoreMode.equals("default")) {
            truststore = new ModITrustStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
            sicurezzaMessaggioRichiesta.setTruststore(truststore);
        } else {
            truststore = new ModITrustStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
            ((BaseTrustStore)((Object)truststore)).setTruststoreCrl(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreCRLs", true));
            ((BaseTrustStore)((Object)truststore)).setTruststoreOcspPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreOCSP", false));
            ModITruststoreEnum tipo = null;
            String truststoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreType", true);
            if (HSMUtils.isKeystoreHSM((String)truststoreTipoString)) {
                tipo = ModITruststoreEnum.PKCS11;
                ((ModITrustStore)((Object)truststore)).setPcks11Tipo(truststoreTipoString);
            } else if (ModiErogazioniApiHelper.isModITrustStore(truststoreTipoString)) {
                tipo = ModITruststoreEnum.PDND;
                ((ModITrustStore)((Object)truststore)).setPdndTipo(truststoreTipoString);
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS)) {
                tipo = ModITruststoreEnum.JKS;
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK)) {
                tipo = ModITruststoreEnum.JWK;
            }
            ((ModITrustStore)((Object)truststore)).setTruststoreTipo(tipo);
            ((BaseTrustStore)((Object)truststore)).setTruststorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePath", true));
            ((BaseTrustStore)((Object)truststore)).setTruststorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePassword", true));
            sicurezzaMessaggioRichiesta.setTruststore(truststore);
        }
        String iatMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestIatMode", false);
        if (StringUtils.isNotEmpty((CharSequence)iatMode) && "ridefinisci".equals(iatMode)) {
            sicurezzaMessaggioRichiesta.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageRequestIatTtl", false));
        }
        if ((wsaTo = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestAud", false)) != null) {
            sicurezzaMessaggioRichiesta.setWsaTo(wsaTo);
        }
        if ((audit = ModiErogazioniApiHelper.getInformazioniUtenteAudit(p, false)) != null) {
            sicurezzaMessaggioRichiesta.setAudit(audit);
        }
        richiesta.setSicurezzaMessaggio(sicurezzaMessaggioRichiesta);
        return richiesta;
    }

    private static ErogazioneModISoapRisposta getErogazioneSOAPRisposta(Map<String, AbstractProperty<?>> p) throws CoreException {
        ErogazioneModISoapRisposta risposta = new ErogazioneModISoapRisposta();
        ErogazioneModISoapRispostaSicurezzaMessaggio sicurezzaMessaggio = new ErogazioneModISoapRispostaSicurezzaMessaggio();
        ModISicurezzaMessaggioSoapAlgoritmoFirma algo = null;
        String algoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapResponseAlg", true);
        if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_DSA_SHA_256)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.DSA_SHA_256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_256)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.ECDSA_SHA_256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_384)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.ECDSA_SHA_384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_512)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.ECDSA_SHA_512;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_256)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.RSA_SHA_256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_384)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.RSA_SHA_384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_512)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.RSA_SHA_512;
        }
        sicurezzaMessaggio.setAlgoritmo(algo);
        ModISicurezzaMessaggioSoapFormaCanonicaXml canonic = null;
        String canonicString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapResponseCanonicalizationAlg", true);
        if (canonicString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_10)) {
            canonic = ModISicurezzaMessaggioSoapFormaCanonicaXml.CANONICAL_XML_10;
        } else if (canonicString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_11)) {
            canonic = ModISicurezzaMessaggioSoapFormaCanonicaXml.CANONICAL_XML_11;
        } else if (canonicString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_EXCLUSIVE_C14N_10)) {
            canonic = ModISicurezzaMessaggioSoapFormaCanonicaXml.EXCLUSIVE_CANONICAL_XML_10;
        }
        sicurezzaMessaggio.setFormaCanonicaXml(canonic);
        String headersString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapHeaders", false);
        if (headersString != null) {
            ArrayList<String> headers = new ArrayList<String>();
            String[] headersplit = headersString.split("\n");
            if (headersplit != null && headersplit.length > 0) {
                headers.addAll(Arrays.asList(headersplit));
            }
            sicurezzaMessaggio.setHeaderSoapFirmare(headers);
        }
        ModISicurezzaMessaggioSoapRiferimentoX509 rif509 = null;
        String rif509String = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapResponseX509Cert", true);
        if (rif509String.equals("DirectReference")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.BINARY_SECURITY_TOKEN;
        } else if (rif509String.equals("IssuerSerial")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.ISSUER_SERIAL_SECURITY_TOKEN_REFERENCE;
        } else if (rif509String.equals("SKIKeyIdentifier")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.SKI_KEY_IDENTIFIER;
        } else if (rif509String.equals("Thumbprint")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.THUMBPRINT_KEY_IDENTIFIER;
        } else if (rif509String.equals("X509KeyIdentifier")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.X509_KEY_IDENTIFIER;
        }
        sicurezzaMessaggio.setRiferimentoX509(rif509);
        sicurezzaMessaggio.setCertificateChain(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageSoapResponseX509CertUseCertificateChain", true));
        sicurezzaMessaggio.setIncludiSignatureToken(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageSoapResponseX509CertIncludeSignatureToken", true));
        sicurezzaMessaggio.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageResponseExp", true));
        String keystoreTypeString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreCertMode", true);
        if (keystoreTypeString.equals("default")) {
            ModIKeyStoreDefault ks = new ModIKeyStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
            sicurezzaMessaggio.setKeystore(ks);
        } else {
            ModIKeyStoreRidefinito ks = ModiErogazioniApiHelper.readKeystoreRidefinito(p);
            sicurezzaMessaggio.setKeystore(ks);
        }
        risposta.setSicurezzaMessaggio(sicurezzaMessaggio);
        return risposta;
    }

    private static ErogazioneModISoap getSOAPProperties(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, Map<String, AbstractProperty<?>> p) throws CoreException {
        ErogazioneModISoap modi = new ErogazioneModISoap();
        modi.setProtocollo(TipoApiEnum.SOAP);
        if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)aspc, (String)asps.getPortType())) {
            modi.setRichiesta(ModiErogazioniApiHelper.getErogazioneSOAPRichiesta(p));
            modi.setRisposta(ModiErogazioniApiHelper.getErogazioneSOAPRisposta(p));
        }
        modi.setInformazioniGenerali(ModiErogazioniApiHelper.getErogazioneModIInfoGenerali(p));
        return modi;
    }

    private static ModIKeyStoreRidefinito readKeystoreRidefinito(Map<String, AbstractProperty<?>> p) throws CoreException {
        ModIKeyStoreRidefinito ks = new ModIKeyStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
        String keystoreModeString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreMode", true);
        if (keystoreModeString.equals("hsm")) {
            ModIKeyStoreHSM datiKeystore = new ModIKeyStoreHSM().tipologia(ModIKeystoreTipologiaEnum.HSM);
            String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
            datiKeystore.setPcks11Tipo(keystoreTipoString);
            datiKeystore.setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
            ks.setDatiKeystore(datiKeystore);
        } else if (keystoreModeString.equals("path")) {
            ModIKeyStoreFile datiKeystore = new ModIKeyStoreFile().tipologia(ModIKeystoreTipologiaEnum.FILESYSTEM);
            ModIKeystoreFullEnum keystoreTipo = null;
            String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
            if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                keystoreTipo = ModIKeystoreFullEnum.JKS;
            } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                keystoreTipo = ModIKeystoreFullEnum.PKCS12;
            } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK)) {
                keystoreTipo = ModIKeystoreFullEnum.JWK;
            } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR)) {
                keystoreTipo = ModIKeystoreFullEnum.KEYS;
            }
            datiKeystore.setKeystoreTipo(keystoreTipo);
            datiKeystore.setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
            datiKeystore.setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyPassword", true));
            datiKeystore.setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePassword", true));
            datiKeystore.setKeystorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePath", true));
            datiKeystore.setPublicKeyPath(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePathPublicKey", false));
            datiKeystore.setKeystoreByokPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreByokPolicy", false));
            ks.setDatiKeystore(datiKeystore);
        } else if (keystoreModeString.equals("archive")) {
            ModIKeyStoreArchive datiKeystore = new ModIKeyStoreArchive().tipologia(ModIKeystoreTipologiaEnum.ARCHIVIO);
            ModIKeystoreEnum keystoreTipo = null;
            String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
            if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                keystoreTipo = ModIKeystoreEnum.JKS;
            } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                keystoreTipo = ModIKeystoreEnum.PKCS12;
            }
            datiKeystore.setKeystoreTipo(keystoreTipo);
            datiKeystore.setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
            datiKeystore.setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyPassword", true));
            datiKeystore.setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePassword", true));
            datiKeystore.setKeystoreArchivio(ProtocolPropertiesHelper.getByteArrayProperty(p, "modipaKeystoreArchive", true));
            ks.setDatiKeystore(datiKeystore);
        }
        return ks;
    }

    private static ErogazioneModIRestRichiesta getErogazioneRestRichiesta(Map<String, AbstractProperty<?>> p) throws CoreException {
        BaseModIRichiestaInformazioniUtenteAudit audit;
        String iatMode;
        ErogazioneModIRestRichiesta richiesta = new ErogazioneModIRestRichiesta();
        ErogazioneModIRestRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = new ErogazioneModIRestRichiestaSicurezzaMessaggio();
        sicurezzaMessaggioRichiesta.setRiferimentoX509(ModiErogazioniApiHelper.getX509(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestRequestX509Cert", true)));
        String truststoreMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreMode", true);
        if (truststoreMode.equals("default")) {
            truststore = new ModITrustStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
            sicurezzaMessaggioRichiesta.setTruststore((OneOfErogazioneModIRestRichiestaSicurezzaMessaggioTruststore)((Object)truststore));
        } else {
            truststore = new ModITrustStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
            ((BaseTrustStore)((Object)truststore)).setTruststoreCrl(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreCRLs", true));
            ((BaseTrustStore)((Object)truststore)).setTruststoreOcspPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreOCSP", false));
            ModITruststoreEnum tipo = null;
            String truststoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreType", true);
            if (HSMUtils.isKeystoreHSM((String)truststoreTipoString)) {
                tipo = ModITruststoreEnum.PKCS11;
                ((ModITrustStore)((Object)truststore)).setPcks11Tipo(truststoreTipoString);
            } else if (ModiErogazioniApiHelper.isModITrustStore(truststoreTipoString)) {
                tipo = ModITruststoreEnum.PDND;
                ((ModITrustStore)((Object)truststore)).setPdndTipo(truststoreTipoString);
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS)) {
                tipo = ModITruststoreEnum.JKS;
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK)) {
                tipo = ModITruststoreEnum.JWK;
            }
            ((ModITrustStore)((Object)truststore)).setTruststoreTipo(tipo);
            ((BaseTrustStore)((Object)truststore)).setTruststorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePath", true));
            ((BaseTrustStore)((Object)truststore)).setTruststorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePassword", true));
            sicurezzaMessaggioRichiesta.setTruststore((OneOfErogazioneModIRestRichiestaSicurezzaMessaggioTruststore)((Object)truststore));
        }
        String truststoreSSLMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreMode", false);
        if (truststoreSSLMode != null) {
            if (truststoreSSLMode.equals("default")) {
                truststore = new ModITrustStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
                sicurezzaMessaggioRichiesta.setTruststoreSsl((OneOfErogazioneModIRestRichiestaSicurezzaMessaggioTruststoreSsl)((Object)truststore));
            } else {
                truststore = new ModITrustStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
                ((BaseTrustStore)((Object)truststore)).setTruststoreCrl(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreCRLs", true));
                ((BaseTrustStore)((Object)truststore)).setTruststoreOcspPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreOCSP", false));
                ModITruststoreEnum tipo = null;
                String truststoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreType", true);
                if (HSMUtils.isKeystoreHSM((String)truststoreTipoString)) {
                    tipo = ModITruststoreEnum.PKCS11;
                    ((ModITrustStore)((Object)truststore)).setPcks11Tipo(truststoreTipoString);
                } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SSL_TRUSTSTORE_TYPE_VALUE_JKS)) {
                    tipo = ModITruststoreEnum.JKS;
                }
                ((ModITrustStore)((Object)truststore)).setTruststoreTipo(tipo);
                ((BaseTrustStore)((Object)truststore)).setTruststorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststorePath", true));
                ((BaseTrustStore)((Object)truststore)).setTruststorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststorePassword", true));
                sicurezzaMessaggioRichiesta.setTruststoreSsl((OneOfErogazioneModIRestRichiestaSicurezzaMessaggioTruststoreSsl)((Object)truststore));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(iatMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestIatMode", false))) && "ridefinisci".equals(iatMode)) {
            sicurezzaMessaggioRichiesta.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageRequestIatTtl", false));
        }
        sicurezzaMessaggioRichiesta.setAudience(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestAud", false));
        String idJtiRichiesta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestDuplicateJti", false);
        String audienceRichiesta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestIntegrityAudMode", false);
        if (StringUtils.isNotEmpty((CharSequence)idJtiRichiesta) || StringUtils.isNotEmpty((CharSequence)audienceRichiesta)) {
            ErogazioneModIRestRichiestaSicurezzaMessaggioContemporaneita richiestaContemporaneita = new ErogazioneModIRestRichiestaSicurezzaMessaggioContemporaneita();
            if (StringUtils.isNotEmpty((CharSequence)idJtiRichiesta)) {
                if ("auth".equals(idJtiRichiesta)) {
                    richiestaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestTokenChoiseEnum.BEARER);
                } else if ("modi".equals(idJtiRichiesta)) {
                    richiestaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
                }
            }
            if (richiestaContemporaneita.getIdentificativo() == null) {
                richiestaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
            }
            if (StringUtils.isNotEmpty((CharSequence)audienceRichiesta)) {
                if ("same".equals(audienceRichiesta)) {
                    richiestaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
                } else if ("different".equals(audienceRichiesta)) {
                    richiestaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT);
                }
            }
            if (richiestaContemporaneita.getAudience() == null) {
                richiestaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
            }
            if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)richiestaContemporaneita.getAudience())) {
                String audienceAtteso = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestIntegrityAud", false);
                richiestaContemporaneita.setAudienceAtteso(audienceAtteso);
            }
            sicurezzaMessaggioRichiesta.setContemporaneita(richiestaContemporaneita);
        }
        if ((audit = ModiErogazioniApiHelper.getInformazioniUtenteAudit(p, false)) != null) {
            sicurezzaMessaggioRichiesta.setAudit(audit);
        }
        richiesta.setSicurezzaMessaggio(sicurezzaMessaggioRichiesta);
        return richiesta;
    }

    private static ErogazioneModIRestRisposta getErogazioneRestRisposta(Map<String, AbstractProperty<?>> p) throws CoreException {
        String keystoreTypeString;
        ErogazioneModIRestRisposta risposta = new ErogazioneModIRestRisposta();
        ErogazioneModIRestRispostaSicurezzaMessaggio sicurezzaMessaggio = new ErogazioneModIRestRispostaSicurezzaMessaggio();
        ModISicurezzaMessaggioRestAlgoritmoFirma algo = null;
        String algoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestResponseAlg", true);
        if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES256)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.ES256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES384)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.ES384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES512)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.ES512;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS256)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.RS256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS384)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.RS384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS512)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.RS512;
        }
        sicurezzaMessaggio.setAlgoritmo(algo);
        String headersString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageHttpHeaders", false);
        if (headersString != null) {
            ArrayList<String> headers = new ArrayList<String>();
            String[] headersplit = headersString.split(",");
            if (headersplit != null && headersplit.length > 0) {
                headers.addAll(Arrays.asList(headersplit));
            }
            sicurezzaMessaggio.setHeaderHttpFirmare(headers);
        }
        if (ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestResponseX509CertAsReq", true).equals("true")) {
            sicurezzaMessaggio.setRiferimentoX509(ModISicurezzaMessaggioRestRiferimentoX509Risposta.RICHIESTA);
        } else {
            sicurezzaMessaggio.setRiferimentoX509(ModISicurezzaMessaggioRestRiferimentoX509Risposta.RIDEFINITO);
            sicurezzaMessaggio.setRiferimentoX509Risposta(ModiErogazioniApiHelper.getX509(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestResponseX509Cert", true)));
        }
        sicurezzaMessaggio.setCertificateChain(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageRestResponseX509CertUseCertificateChain", true));
        sicurezzaMessaggio.setUrl(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestResponseX509Url", false));
        sicurezzaMessaggio.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageResponseExp", true));
        String pString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseClaims", false);
        if (pString != null) {
            ArrayList<String> proprieta = new ArrayList<String>();
            String[] psplit = pString.split("\n");
            if (psplit != null && psplit.length > 0) {
                proprieta.addAll(Arrays.asList(psplit));
            }
            sicurezzaMessaggio.setClaims(proprieta);
        }
        if ((keystoreTypeString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreCertMode", true)).equals("default")) {
            ks = new ModIKeyStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
            sicurezzaMessaggio.setKeystore((OneOfErogazioneModIRestRispostaSicurezzaMessaggioKeystore)((Object)ks));
        } else {
            ks = new ModIKeyStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
            String keystoreModeString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreMode", true);
            if (keystoreModeString.equals("hsm")) {
                datiKeystore = new ModIKeyStoreHSM().tipologia(ModIKeystoreTipologiaEnum.HSM);
                String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
                ((ModIKeyStoreHSM)datiKeystore).setPcks11Tipo(keystoreTipoString);
                ((ModIKeyStoreHSM)datiKeystore).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
                ((ModIKeyStoreRidefinito)ks).setDatiKeystore(datiKeystore);
            } else if (keystoreModeString.equals("path")) {
                datiKeystore = new ModIKeyStoreFile().tipologia(ModIKeystoreTipologiaEnum.FILESYSTEM);
                keystoreTipo = null;
                keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
                if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                    keystoreTipo = ModIKeystoreFullEnum.JKS;
                } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                    keystoreTipo = ModIKeystoreFullEnum.PKCS12;
                } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK)) {
                    keystoreTipo = ModIKeystoreFullEnum.JWK;
                } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR)) {
                    keystoreTipo = ModIKeystoreFullEnum.KEYS;
                }
                ((ModIKeyStoreFile)datiKeystore).setKeystoreTipo((ModIKeystoreFullEnum)keystoreTipo);
                ((BaseKeyStore)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
                ((BaseKeyStore)((Object)datiKeystore)).setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyPassword", true));
                ((BaseKeyStore)((Object)datiKeystore)).setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePassword", true));
                ((BaseKeyStorePublicFile)((Object)datiKeystore)).setKeystorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePath", true));
                ((BaseKeyStorePublicFile)((Object)datiKeystore)).setPublicKeyPath(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePathPublicKey", false));
                ((BaseKeyStore)((Object)datiKeystore)).setKeystoreByokPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreByokPolicy", false));
                ((ModIKeyStoreRidefinito)ks).setDatiKeystore(datiKeystore);
            } else if (keystoreModeString.equals("archive")) {
                datiKeystore = new ModIKeyStoreArchive().tipologia(ModIKeystoreTipologiaEnum.ARCHIVIO);
                keystoreTipo = null;
                keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
                if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                    keystoreTipo = ModIKeystoreEnum.JKS;
                } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                    keystoreTipo = ModIKeystoreEnum.PKCS12;
                }
                ((ModIKeyStoreArchive)datiKeystore).setKeystoreTipo((ModIKeystoreEnum)keystoreTipo);
                ((BaseKeyStore)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
                ((BaseKeyStore)((Object)datiKeystore)).setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyPassword", true));
                ((BaseKeyStore)((Object)datiKeystore)).setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePassword", true));
                ((BaseKeyStoreArchive)((Object)datiKeystore)).setKeystoreArchivio(ProtocolPropertiesHelper.getByteArrayProperty(p, "modipaKeystoreArchive", true));
                ((ModIKeyStoreRidefinito)ks).setDatiKeystore(datiKeystore);
            }
            sicurezzaMessaggio.setKeystore((OneOfErogazioneModIRestRispostaSicurezzaMessaggioKeystore)((Object)ks));
        }
        String idJtiRisposta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseJti", false);
        String claimsAuthRisposta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseClaimsAuth", false);
        String claimsModiRisposta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseClaimsModi", false);
        if (StringUtils.isNotEmpty((CharSequence)idJtiRisposta) || StringUtils.isNotEmpty((CharSequence)claimsAuthRisposta) || StringUtils.isNotEmpty((CharSequence)claimsModiRisposta)) {
            String[] psplit;
            ArrayList<String> proprieta;
            ErogazioneModIRestRispostaSicurezzaMessaggioContemporaneita rispostaContemporaneita = new ErogazioneModIRestRispostaSicurezzaMessaggioContemporaneita();
            if (StringUtils.isNotEmpty((CharSequence)idJtiRisposta)) {
                if ("same".equals(idJtiRisposta)) {
                    rispostaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
                } else if ("different".equals(idJtiRisposta)) {
                    rispostaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT);
                }
            }
            if (rispostaContemporaneita.getIdentificativo() == null) {
                rispostaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
            }
            if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)rispostaContemporaneita.getIdentificativo())) {
                String idJtiAsIdMessaggio = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseJtiIdMsg", false);
                if (StringUtils.isNotEmpty((CharSequence)idJtiAsIdMessaggio)) {
                    if ("auth".equals(idJtiAsIdMessaggio)) {
                        rispostaContemporaneita.setUsaComeIdMessaggio(ModISicurezzaMessaggioRestTokenChoiseEnum.BEARER);
                    } else if ("modi".equals(idJtiAsIdMessaggio)) {
                        rispostaContemporaneita.setUsaComeIdMessaggio(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
                    }
                }
                if (rispostaContemporaneita.getUsaComeIdMessaggio() == null) {
                    rispostaContemporaneita.setUsaComeIdMessaggio(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
                }
            }
            if (claimsAuthRisposta != null) {
                proprieta = new ArrayList<String>();
                psplit = claimsAuthRisposta.split("\n");
                if (psplit != null && psplit.length > 0) {
                    proprieta.addAll(Arrays.asList(psplit));
                }
                rispostaContemporaneita.setClaimsBearer(proprieta);
            }
            if (claimsModiRisposta != null) {
                proprieta = new ArrayList();
                psplit = claimsModiRisposta.split("\n");
                if (psplit != null && psplit.length > 0) {
                    proprieta.addAll(Arrays.asList(psplit));
                }
                rispostaContemporaneita.setClaimsAgid(proprieta);
            }
            sicurezzaMessaggio.setContemporaneita(rispostaContemporaneita);
        }
        risposta.setSicurezzaMessaggio(sicurezzaMessaggio);
        return risposta;
    }

    private static ErogazioneModIRest getRestProperties(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, Map<String, AbstractProperty<?>> p) throws CoreException {
        ErogazioneModIRest modi = new ErogazioneModIRest();
        modi.setProtocollo(TipoApiEnum.REST);
        if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)aspc, (String)asps.getPortType())) {
            modi.setRichiesta(ModiErogazioniApiHelper.getErogazioneRestRichiesta(p));
            modi.setRisposta(ModiErogazioniApiHelper.getErogazioneRestRisposta(p));
        }
        modi.setInformazioniGenerali(ModiErogazioniApiHelper.getErogazioneModIInfoGenerali(p));
        return modi;
    }

    private static FruizioneModIOAuth getFruizioneModIOAuth(Map<String, AbstractProperty<?>> p, TipoApiEnum protocollo) throws CoreException {
        String algoString;
        if (protocollo.equals((Object)TipoApiEnum.SOAP) ? (algoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapRequestAlg", false)) != null && StringUtils.isNotEmpty((CharSequence)algoString) : (algoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestRequestAlg", false)) != null && StringUtils.isNotEmpty((CharSequence)algoString)) {
            return null;
        }
        String id = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityOauthId", false);
        String kid = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityOauthKid", false);
        String modeKeystore = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreCertMode", false);
        if (id != null && StringUtils.isNotEmpty((CharSequence)id) || kid != null && StringUtils.isNotEmpty((CharSequence)kid) || modeKeystore != null && StringUtils.isNotEmpty((CharSequence)modeKeystore)) {
            FruizioneModIOAuth oauth = new FruizioneModIOAuth();
            oauth.setProtocollo(TipoConfigurazioneFruizioneEnum.OAUTH);
            oauth.setIdentificativo(id);
            oauth.setKid(kid);
            if (modeKeystore != null && StringUtils.isNotEmpty((CharSequence)modeKeystore) && modeKeystore.equals("ridefinisci")) {
                ModIKeyStoreRidefinito ks = ModiErogazioniApiHelper.readKeystoreRidefinito(p);
                oauth.setKeystore(ks);
            } else {
                ModIKeyStoreDefault ks = new ModIKeyStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
                oauth.setKeystore(ks);
            }
            return oauth;
        }
        return null;
    }

    private static FruizioneModISoap getFruizioneModISoap(Map<String, AbstractProperty<?>> p, String schemaAudit) throws CoreException {
        Boolean verificaWsaTo;
        String keystoreMode;
        FruizioneModISoap modi = new FruizioneModISoap();
        modi.setProtocollo(TipoConfigurazioneFruizioneEnum.SOAP);
        FruizioneModISoapRichiesta richiesta = new FruizioneModISoapRichiesta();
        FruizioneModISoapRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = new FruizioneModISoapRichiestaSicurezzaMessaggio();
        ModISicurezzaMessaggioSoapAlgoritmoFirma algo = null;
        String algoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapRequestAlg", true);
        if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_DSA_SHA_256)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.DSA_SHA_256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_256)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.ECDSA_SHA_256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_384)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.ECDSA_SHA_384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_512)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.ECDSA_SHA_512;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_256)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.RSA_SHA_256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_384)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.RSA_SHA_384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_512)) {
            algo = ModISicurezzaMessaggioSoapAlgoritmoFirma.RSA_SHA_512;
        }
        sicurezzaMessaggioRichiesta.setAlgoritmo(algo);
        ModISicurezzaMessaggioSoapFormaCanonicaXml canonic = null;
        String canonicString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapRequestCanonicalizationAlg", true);
        if (canonicString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_10)) {
            canonic = ModISicurezzaMessaggioSoapFormaCanonicaXml.CANONICAL_XML_10;
        } else if (canonicString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_11)) {
            canonic = ModISicurezzaMessaggioSoapFormaCanonicaXml.CANONICAL_XML_11;
        } else if (canonicString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_EXCLUSIVE_C14N_10)) {
            canonic = ModISicurezzaMessaggioSoapFormaCanonicaXml.EXCLUSIVE_CANONICAL_XML_10;
        }
        sicurezzaMessaggioRichiesta.setFormaCanonicaXml(canonic);
        String headersString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapHeaders", false);
        if (headersString != null) {
            ArrayList<String> headers = new ArrayList<String>();
            String[] headersplit = headersString.split("\n");
            if (headersplit != null && headersplit.length > 0) {
                headers.addAll(Arrays.asList(headersplit));
            }
            sicurezzaMessaggioRichiesta.setHeaderSoapFirmare(headers);
        }
        ModISicurezzaMessaggioSoapRiferimentoX509 rif509 = null;
        String rif509String = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSoapRequestX509Cert", true);
        if (rif509String.equals("DirectReference")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.BINARY_SECURITY_TOKEN;
        } else if (rif509String.equals("IssuerSerial")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.ISSUER_SERIAL_SECURITY_TOKEN_REFERENCE;
        } else if (rif509String.equals("SKIKeyIdentifier")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.SKI_KEY_IDENTIFIER;
        } else if (rif509String.equals("Thumbprint")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.THUMBPRINT_KEY_IDENTIFIER;
        } else if (rif509String.equals("X509KeyIdentifier")) {
            rif509 = ModISicurezzaMessaggioSoapRiferimentoX509.X509_KEY_IDENTIFIER;
        }
        sicurezzaMessaggioRichiesta.setRiferimentoX509(rif509);
        sicurezzaMessaggioRichiesta.setCertificateChain(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageSoapRequestX509CertUseCertificateChain", true));
        sicurezzaMessaggioRichiesta.setIncludiSignatureToken(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageSoapRequestX509CertIncludeSignatureToken", true));
        sicurezzaMessaggioRichiesta.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageRequestExp", true));
        String wsaTo = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestAud", false);
        if (wsaTo != null) {
            sicurezzaMessaggioRichiesta.setWsaTo(wsaTo);
        }
        if ("fruizione".equals(keystoreMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreFruizioneMode", false))) {
            String modeKeystore = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreCertMode", false);
            if (modeKeystore != null && StringUtils.isNotEmpty((CharSequence)modeKeystore) && modeKeystore.equals("default")) {
                ks = new ModIKeyStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
                sicurezzaMessaggioRichiesta.setKeystore(ks);
            } else {
                ks = ModiErogazioniApiHelper.readKeystoreRidefinito(p);
                sicurezzaMessaggioRichiesta.setKeystore(ks);
            }
        } else if ("token".equals(keystoreMode)) {
            sicurezzaMessaggioRichiesta.setKeystoreTokenPolicy(true);
        }
        sicurezzaMessaggioRichiesta.setInformazioniUtenteCodiceEnte(ModiErogazioniApiHelper.getInformazioniUtenteCodiceEnte(p));
        sicurezzaMessaggioRichiesta.setInformazioniUtenteUserid(ModiErogazioniApiHelper.getInformazioniUtenteUserid(p));
        sicurezzaMessaggioRichiesta.setInformazioniUtenteIndirizzoIp(ModiErogazioniApiHelper.getInformazioniUtenteIndirizzoIp(p));
        FruizioneModIRichiestaInformazioniUtenteAudit audit = ModiErogazioniApiHelper.getInformazioniUtenteAudit(p, schemaAudit);
        if (audit != null) {
            sicurezzaMessaggioRichiesta.setAudit(audit);
        }
        richiesta.setSicurezzaMessaggio(sicurezzaMessaggioRichiesta);
        String id = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityOauthId", false);
        String kid = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityOauthKid", false);
        if (id != null && StringUtils.isNotEmpty((CharSequence)id) || kid != null && StringUtils.isNotEmpty((CharSequence)kid)) {
            BaseFruizioneModIOAuth oauth = new BaseFruizioneModIOAuth();
            oauth.setIdentificativo(id);
            oauth.setKid(kid);
            richiesta.setOauth(oauth);
        }
        modi.setRichiesta(richiesta);
        FruizioneModISoapRispostaSicurezzaMessaggio sicurezzaMessaggioRisposta = new FruizioneModISoapRispostaSicurezzaMessaggio();
        FruizioneModISoapRisposta risposta = new FruizioneModISoapRisposta();
        String truststoreMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreMode", true);
        if (truststoreMode.equals("default")) {
            truststore = new ModITrustStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
            sicurezzaMessaggioRisposta.setTruststore((OneOfFruizioneModISoapRispostaSicurezzaMessaggioTruststore)((Object)truststore));
        } else {
            truststore = new ModITrustStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
            ((BaseTrustStore)((Object)truststore)).setTruststoreCrl(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreCRLs", true));
            ((BaseTrustStore)((Object)truststore)).setTruststoreOcspPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreOCSP", false));
            ModITruststoreEnum tipo = null;
            String truststoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreType", true);
            if (HSMUtils.isKeystoreHSM((String)truststoreTipoString)) {
                tipo = ModITruststoreEnum.PKCS11;
                ((ModITrustStore)((Object)truststore)).setPcks11Tipo(truststoreTipoString);
            } else if (ModiErogazioniApiHelper.isModITrustStore(truststoreTipoString)) {
                tipo = ModITruststoreEnum.PDND;
                ((ModITrustStore)((Object)truststore)).setPdndTipo(truststoreTipoString);
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS)) {
                tipo = ModITruststoreEnum.JKS;
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK)) {
                tipo = ModITruststoreEnum.JWK;
            }
            ((ModITrustStore)((Object)truststore)).setTruststoreTipo(tipo);
            ((BaseTrustStore)((Object)truststore)).setTruststorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePath", true));
            ((BaseTrustStore)((Object)truststore)).setTruststorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePassword", true));
            sicurezzaMessaggioRisposta.setTruststore((OneOfFruizioneModISoapRispostaSicurezzaMessaggioTruststore)((Object)truststore));
        }
        String iatMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseIatMode", false);
        if (StringUtils.isNotEmpty((CharSequence)iatMode) && "ridefinisci".equals(iatMode)) {
            sicurezzaMessaggioRisposta.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageResponseIatTtl", false));
        }
        sicurezzaMessaggioRisposta.setVerificaWsaTo(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageResponseAud", (verificaWsaTo = ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageResponseAud", false)) != null && verificaWsaTo != false));
        if (sicurezzaMessaggioRisposta.isVerificaWsaTo() != null && sicurezzaMessaggioRisposta.isVerificaWsaTo().booleanValue()) {
            sicurezzaMessaggioRisposta.setAudienceAtteso(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseAudExpected", false));
        }
        risposta.setSicurezzaMessaggio(sicurezzaMessaggioRisposta);
        modi.setRisposta(risposta);
        return modi;
    }

    private static FruizioneModIRest getFruizioneModIRest(Map<String, AbstractProperty<?>> p, String schemaAudit) throws CoreException {
        Boolean verificaAudience;
        String iatMode;
        String keystoreMode;
        FruizioneModIRest modi = new FruizioneModIRest();
        modi.setProtocollo(TipoConfigurazioneFruizioneEnum.REST);
        FruizioneModIRestRichiesta richiesta = new FruizioneModIRestRichiesta();
        FruizioneModIRestRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = new FruizioneModIRestRichiestaSicurezzaMessaggio();
        ModISicurezzaMessaggioRestAlgoritmoFirma algo = null;
        String algoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestRequestAlg", true);
        if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES256)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.ES256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES384)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.ES384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES512)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.ES512;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS256)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.RS256;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS384)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.RS384;
        } else if (algoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS512)) {
            algo = ModISicurezzaMessaggioRestAlgoritmoFirma.RS512;
        }
        sicurezzaMessaggioRichiesta.setAlgoritmo(algo);
        String headersString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageHttpHeaders", false);
        if (headersString != null) {
            ArrayList<String> headers = new ArrayList<String>();
            String[] headersplit = headersString.split(",");
            if (headersplit != null && headersplit.length > 0) {
                headers.addAll(Arrays.asList(headersplit));
            }
            sicurezzaMessaggioRichiesta.setHeaderHttpFirmare(headers);
        }
        sicurezzaMessaggioRichiesta.setRiferimentoX509(ModiErogazioniApiHelper.getX509(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestRequestX509Cert", true)));
        sicurezzaMessaggioRichiesta.setCertificateChain(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageRestRequestX509CertUseCertificateChain", true));
        sicurezzaMessaggioRichiesta.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageRequestExp", true));
        sicurezzaMessaggioRichiesta.setAudience(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestAud", false));
        String pString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestClaims", false);
        if (pString != null) {
            ArrayList<String> proprieta = new ArrayList<String>();
            String[] psplit = pString.split("\n");
            if (psplit != null && psplit.length > 0) {
                proprieta.addAll(Arrays.asList(psplit));
            }
            sicurezzaMessaggioRichiesta.setClaims(proprieta);
        }
        if ("fruizione".equals(keystoreMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreFruizioneMode", false))) {
            String modeKeystore = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreCertMode", false);
            if (modeKeystore != null && StringUtils.isNotEmpty((CharSequence)modeKeystore) && modeKeystore.equals("default")) {
                ks = new ModIKeyStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
                sicurezzaMessaggioRichiesta.setKeystore((OneOfFruizioneModIRestRichiestaSicurezzaMessaggioKeystore)((Object)ks));
            } else {
                ks = ModiErogazioniApiHelper.readKeystoreRidefinito(p);
                sicurezzaMessaggioRichiesta.setKeystore((OneOfFruizioneModIRestRichiestaSicurezzaMessaggioKeystore)((Object)ks));
            }
        } else if ("token".equals(keystoreMode)) {
            sicurezzaMessaggioRichiesta.setKeystoreTokenPolicy(true);
        }
        sicurezzaMessaggioRichiesta.setInformazioniUtenteCodiceEnte(ModiErogazioniApiHelper.getInformazioniUtenteCodiceEnte(p));
        sicurezzaMessaggioRichiesta.setInformazioniUtenteUserid(ModiErogazioniApiHelper.getInformazioniUtenteUserid(p));
        sicurezzaMessaggioRichiesta.setInformazioniUtenteIndirizzoIp(ModiErogazioniApiHelper.getInformazioniUtenteIndirizzoIp(p));
        FruizioneModIRichiestaInformazioniUtenteAudit audit = ModiErogazioniApiHelper.getInformazioniUtenteAudit(p, schemaAudit);
        if (audit != null) {
            sicurezzaMessaggioRichiesta.setAudit(audit);
        }
        String idJtiRichiesta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestJti", false);
        String audienceRichiesta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestIntegrityAudMode", false);
        String claimsAuthRichiesta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestClaimsAuth", false);
        String claimsModiRichiesta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestClaimsModi", false);
        if (StringUtils.isNotEmpty((CharSequence)idJtiRichiesta) || StringUtils.isNotEmpty((CharSequence)audienceRichiesta) || StringUtils.isNotEmpty((CharSequence)claimsAuthRichiesta) || StringUtils.isNotEmpty((CharSequence)claimsModiRichiesta)) {
            String[] psplit;
            ArrayList<String> proprieta;
            FruizioneModIRestRichiestaSicurezzaMessaggioContemporaneita richiestaContemporaneita = new FruizioneModIRestRichiestaSicurezzaMessaggioContemporaneita();
            if (StringUtils.isNotEmpty((CharSequence)idJtiRichiesta)) {
                if ("same".equals(idJtiRichiesta)) {
                    richiestaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
                } else if ("different".equals(idJtiRichiesta)) {
                    richiestaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT);
                }
            }
            if (richiestaContemporaneita.getIdentificativo() == null) {
                richiestaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
            }
            if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)richiestaContemporaneita.getIdentificativo())) {
                String idJtiAsIdMessaggio = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestJtiIdMsg", false);
                if (StringUtils.isNotEmpty((CharSequence)idJtiAsIdMessaggio)) {
                    if ("auth".equals(idJtiAsIdMessaggio)) {
                        richiestaContemporaneita.setUsaComeIdMessaggio(ModISicurezzaMessaggioRestTokenChoiseEnum.BEARER);
                    } else if ("modi".equals(idJtiAsIdMessaggio)) {
                        richiestaContemporaneita.setUsaComeIdMessaggio(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
                    }
                }
                if (richiestaContemporaneita.getUsaComeIdMessaggio() == null) {
                    richiestaContemporaneita.setUsaComeIdMessaggio(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)audienceRichiesta)) {
                if ("same".equals(audienceRichiesta)) {
                    richiestaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
                } else if ("different".equals(audienceRichiesta)) {
                    richiestaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT);
                }
            }
            if (richiestaContemporaneita.getAudience() == null) {
                richiestaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
            }
            if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)richiestaContemporaneita.getAudience())) {
                String audienceAtteso = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestIntegrityAud", false);
                richiestaContemporaneita.setAudienceAtteso(audienceAtteso);
            }
            if (claimsAuthRichiesta != null) {
                proprieta = new ArrayList<String>();
                psplit = claimsAuthRichiesta.split("\n");
                if (psplit != null && psplit.length > 0) {
                    proprieta.addAll(Arrays.asList(psplit));
                }
                richiestaContemporaneita.setClaimsBearer(proprieta);
            }
            if (claimsModiRichiesta != null) {
                proprieta = new ArrayList();
                psplit = claimsModiRichiesta.split("\n");
                if (psplit != null && psplit.length > 0) {
                    proprieta.addAll(Arrays.asList(psplit));
                }
                richiestaContemporaneita.setClaimsAgid(proprieta);
            }
            sicurezzaMessaggioRichiesta.setContemporaneita(richiestaContemporaneita);
        }
        richiesta.setSicurezzaMessaggio(sicurezzaMessaggioRichiesta);
        String id = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityOauthId", false);
        String kid = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityOauthKid", false);
        if (id != null && StringUtils.isNotEmpty((CharSequence)id) || kid != null && StringUtils.isNotEmpty((CharSequence)kid)) {
            BaseFruizioneModIOAuth oauth = new BaseFruizioneModIOAuth();
            oauth.setIdentificativo(id);
            oauth.setKid(kid);
            richiesta.setOauth(oauth);
        }
        modi.setRichiesta(richiesta);
        FruizioneModIRestRisposta risposta = new FruizioneModIRestRisposta();
        FruizioneModIRestRispostaSicurezzaMessaggio sicurezzaMessaggioRisposta = new FruizioneModIRestRispostaSicurezzaMessaggio();
        if (ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestResponseX509CertAsReq", true).equals("true")) {
            sicurezzaMessaggioRisposta.setRiferimentoX509(ModISicurezzaMessaggioRestRiferimentoX509Risposta.RICHIESTA);
        } else {
            sicurezzaMessaggioRisposta.setRiferimentoX509(ModISicurezzaMessaggioRestRiferimentoX509Risposta.RIDEFINITO);
            sicurezzaMessaggioRisposta.setRiferimentoX509Risposta(ModiErogazioniApiHelper.getX509(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestResponseX509Cert", true)));
        }
        String truststoreMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreMode", true);
        if (truststoreMode.equals("default")) {
            truststore = new ModITrustStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
            sicurezzaMessaggioRisposta.setTruststore((OneOfFruizioneModIRestRispostaSicurezzaMessaggioTruststore)((Object)truststore));
        } else {
            truststore = new ModITrustStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
            ((BaseTrustStore)((Object)truststore)).setTruststoreCrl(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreCRLs", true));
            ((BaseTrustStore)((Object)truststore)).setTruststoreOcspPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreOCSP", false));
            ModITruststoreEnum tipo = null;
            String truststoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststoreType", true);
            if (HSMUtils.isKeystoreHSM((String)truststoreTipoString)) {
                tipo = ModITruststoreEnum.PKCS11;
                ((ModITrustStore)((Object)truststore)).setPcks11Tipo(truststoreTipoString);
            } else if (ModiErogazioniApiHelper.isModITrustStore(truststoreTipoString)) {
                tipo = ModITruststoreEnum.PDND;
                ((ModITrustStore)((Object)truststore)).setPdndTipo(truststoreTipoString);
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS)) {
                tipo = ModITruststoreEnum.JKS;
            } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK)) {
                tipo = ModITruststoreEnum.JWK;
            }
            ((ModITrustStore)((Object)truststore)).setTruststoreTipo(tipo);
            ((BaseTrustStore)((Object)truststore)).setTruststorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePath", true));
            ((BaseTrustStore)((Object)truststore)).setTruststorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaTruststorePassword", true));
            sicurezzaMessaggioRisposta.setTruststore((OneOfFruizioneModIRestRispostaSicurezzaMessaggioTruststore)((Object)truststore));
        }
        String truststoreSSLMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreMode", false);
        if (truststoreSSLMode != null) {
            if (truststoreSSLMode.equals("default")) {
                truststore = new ModITrustStoreDefault().modalita(StatoDefaultRidefinitoEnum.DEFAULT);
                sicurezzaMessaggioRisposta.setTruststoreSsl((OneOfFruizioneModIRestRispostaSicurezzaMessaggioTruststoreSsl)((Object)truststore));
            } else {
                truststore = new ModITrustStoreRidefinito().modalita(StatoDefaultRidefinitoEnum.RIDEFINITO);
                ((BaseTrustStore)((Object)truststore)).setTruststoreCrl(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreCRLs", true));
                ((BaseTrustStore)((Object)truststore)).setTruststoreOcspPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreOCSP", false));
                ModITruststoreEnum tipo = null;
                String truststoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststoreType", true);
                if (HSMUtils.isKeystoreHSM((String)truststoreTipoString)) {
                    tipo = ModITruststoreEnum.PKCS11;
                    ((ModITrustStore)((Object)truststore)).setPcks11Tipo(truststoreTipoString);
                } else if (truststoreTipoString.equals(ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SSL_TRUSTSTORE_TYPE_VALUE_JKS)) {
                    tipo = ModITruststoreEnum.JKS;
                }
                ((ModITrustStore)((Object)truststore)).setTruststoreTipo(tipo);
                ((BaseTrustStore)((Object)truststore)).setTruststorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststorePath", true));
                ((BaseTrustStore)((Object)truststore)).setTruststorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaSslTruststorePassword", true));
                sicurezzaMessaggioRisposta.setTruststoreSsl((OneOfFruizioneModIRestRispostaSicurezzaMessaggioTruststoreSsl)((Object)truststore));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(iatMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseIatMode", false))) && "ridefinisci".equals(iatMode)) {
            sicurezzaMessaggioRisposta.setTimeToLive(ProtocolPropertiesHelper.getIntegerProperty(p, "modipaSecurityMessageResponseIatTtl", false));
        }
        sicurezzaMessaggioRisposta.setVerificaAudience(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageResponseAud", (verificaAudience = ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageResponseAud", false)) != null && verificaAudience != false));
        if (sicurezzaMessaggioRisposta.isVerificaAudience() != null && sicurezzaMessaggioRisposta.isVerificaAudience().booleanValue()) {
            sicurezzaMessaggioRisposta.setAudienceAtteso(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseAudExpected", false));
        }
        String idJtiRisposta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseDuplicateJti", false);
        String audienceRisposta = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseIntegrityAudMode", false);
        if (StringUtils.isNotEmpty((CharSequence)idJtiRisposta) || StringUtils.isNotEmpty((CharSequence)audienceRisposta)) {
            FruizioneModIRestRispostaSicurezzaMessaggioContemporaneita rispostaContemporaneita = new FruizioneModIRestRispostaSicurezzaMessaggioContemporaneita();
            if (StringUtils.isNotEmpty((CharSequence)idJtiRisposta)) {
                if ("auth".equals(idJtiRisposta)) {
                    rispostaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestTokenChoiseEnum.BEARER);
                } else if ("modi".equals(idJtiRisposta)) {
                    rispostaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
                }
            }
            if (rispostaContemporaneita.getIdentificativo() == null) {
                rispostaContemporaneita.setIdentificativo(ModISicurezzaMessaggioRestTokenChoiseEnum.AGID);
            }
            if (StringUtils.isNotEmpty((CharSequence)audienceRisposta)) {
                if ("same".equals(audienceRisposta)) {
                    rispostaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
                } else if ("different".equals(audienceRisposta)) {
                    rispostaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT);
                }
            }
            if (rispostaContemporaneita.getAudience() == null) {
                rispostaContemporaneita.setAudience(ModISicurezzaMessaggioRestSameDifferentEnum.SAME);
            }
            if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)rispostaContemporaneita.getAudience())) {
                String audienceAtteso = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseIntegrityAud", false);
                rispostaContemporaneita.setAudienceAtteso(audienceAtteso);
            }
            sicurezzaMessaggioRisposta.setContemporaneita(rispostaContemporaneita);
        }
        risposta.setSicurezzaMessaggio(sicurezzaMessaggioRisposta);
        modi.setRisposta(risposta);
        return modi;
    }

    private static boolean isModITrustStoreSafe(String truststoreTipoString) {
        try {
            return ModiErogazioniApiHelper.isModITrustStore(truststoreTipoString);
        }
        catch (Exception e) {
            if (Startup.getLog() != null) {
                Startup.getLog().error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    private static boolean isModITrustStore(String truststoreTipoString) throws CoreException {
        try {
            List remoteStoreConfig = ModIUtils.getRemoteStoreConfig();
            if (remoteStoreConfig != null && !remoteStoreConfig.isEmpty()) {
                for (RemoteStoreConfig rsc : remoteStoreConfig) {
                    if (!truststoreTipoString.equals(rsc.getStoreName())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    private static FruizioneModIRichiestaInformazioneUtente getInformazioniUtenteCodiceEnte(Map<String, AbstractProperty<?>> p) throws CoreException {
        return ModiErogazioniApiHelper.getInformazioniUtente(p, "modipaSecurityMessageCorniceSicurezzaCodiceEnteMode", "modipaSecurityMessageCorniceSicurezzaCodiceEnte");
    }

    private static FruizioneModIRichiestaInformazioneUtente getInformazioniUtenteUserid(Map<String, AbstractProperty<?>> p) throws CoreException {
        return ModiErogazioniApiHelper.getInformazioniUtente(p, "modipaSecurityMessageCorniceSicurezzaUserMode", "modipaSecurityMessageCorniceSicurezzaUser");
    }

    private static FruizioneModIRichiestaInformazioneUtente getInformazioniUtenteIndirizzoIp(Map<String, AbstractProperty<?>> p) throws CoreException {
        return ModiErogazioniApiHelper.getInformazioniUtente(p, "modipaSecurityMessageCorniceSicurezzaIPUserMode", "modipaSecurityMessageCorniceSicurezzaIPUser");
    }

    private static FruizioneModIRichiestaInformazioneUtente getInformazioniUtente(Map<String, AbstractProperty<?>> p, String mod, String value) throws CoreException {
        String modalitaString = ProtocolPropertiesHelper.getStringProperty(p, mod, false);
        if (modalitaString == null) {
            return null;
        }
        FruizioneModIRichiestaInformazioneUtente u = new FruizioneModIRichiestaInformazioneUtente();
        StatoDefaultRidefinitoEnum modalita = modalitaString.equals("default") ? StatoDefaultRidefinitoEnum.DEFAULT : StatoDefaultRidefinitoEnum.RIDEFINITO;
        u.setModalita(modalita);
        if (modalita.equals((Object)StatoDefaultRidefinitoEnum.RIDEFINITO)) {
            String valueString = ProtocolPropertiesHelper.getStringProperty(p, value, false);
            u.setValore(valueString);
        }
        return u;
    }

    private static BaseModIRichiestaInformazioniUtenteAudit getInformazioniUtenteAudit(Map<String, AbstractProperty<?>> p, boolean fruizione) throws CoreException {
        BaseModIRichiestaInformazioniUtenteAudit infoAudit = null;
        String auditMode = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestAuditAudMode", false);
        if (auditMode != null && StringUtils.isNotEmpty((CharSequence)auditMode)) {
            ModISicurezzaMessaggioRestSameDifferentEnum aud = null;
            String audCustom = null;
            if (auditMode.equals("same")) {
                aud = ModISicurezzaMessaggioRestSameDifferentEnum.SAME;
            } else if (auditMode.equals("different")) {
                aud = ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT;
                audCustom = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRequestAuditAud", false);
            }
            if (aud != null) {
                infoAudit = fruizione ? new FruizioneModIRichiestaInformazioniUtenteAudit() : new BaseModIRichiestaInformazioniUtenteAudit();
                infoAudit.setAudience(aud);
                infoAudit.setAudienceAtteso(audCustom);
            }
        }
        return infoAudit;
    }

    private static List<String> getInformazioniAuditRequired(String schemaAudit) {
        return ModiErogazioniApiHelper.getInformazioniAudit(schemaAudit, true);
    }

    private static List<String> getInformazioniAudit(String schemaAudit) {
        return ModiErogazioniApiHelper.getInformazioniAudit(schemaAudit, false);
    }

    private static List<String> getInformazioniAudit(String schemaAudit, boolean required) {
        ModIAuditConfig modIAuditConfig;
        ArrayList<String> infoRequired = new ArrayList<String>();
        if (schemaAudit != null && (modIAuditConfig = ModiErogazioniApiHelper.getModIAuditConfig(schemaAudit)) != null && modIAuditConfig.getClaims() != null && !modIAuditConfig.getClaims().isEmpty()) {
            for (ModIAuditClaimConfig claim : modIAuditConfig.getClaims()) {
                if (required && !claim.isRequired()) continue;
                infoRequired.add(claim.getNome());
            }
        }
        return infoRequired;
    }

    private static FruizioneModIRichiestaInformazioniUtenteAudit getInformazioniUtenteAudit(Map<String, AbstractProperty<?>> p, String schemaAudit) throws CoreException {
        ModIAuditConfig modIAuditConfig;
        BaseModIRichiestaInformazioniUtenteAudit infoAuditBase = ModiErogazioniApiHelper.getInformazioniUtenteAudit(p, true);
        FruizioneModIRichiestaInformazioniUtenteAudit infoAudit = null;
        if (infoAuditBase instanceof FruizioneModIRichiestaInformazioniUtenteAudit) {
            infoAudit = (FruizioneModIRichiestaInformazioniUtenteAudit)infoAuditBase;
        }
        if (schemaAudit != null && (modIAuditConfig = ModiErogazioniApiHelper.getModIAuditConfig(schemaAudit)) != null && modIAuditConfig.getClaims() != null && !modIAuditConfig.getClaims().isEmpty()) {
            infoAudit = ModiErogazioniApiHelper.getInformazioniUtenteAudit(p, modIAuditConfig.getClaims(), infoAudit);
        }
        return infoAudit;
    }

    private static ModIAuditConfig getModIAuditConfig(String schemaAudit) {
        List l = null;
        try {
            l = ModIProperties.getInstance().getAuditConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModIAuditConfig modIAuditConfig = null;
        if (l != null && !l.isEmpty()) {
            for (ModIAuditConfig modIAuditConfigCheck : l) {
                if (!schemaAudit.equals(modIAuditConfigCheck.getNome())) continue;
                modIAuditConfig = modIAuditConfigCheck;
                break;
            }
        }
        return modIAuditConfig;
    }

    private static FruizioneModIRichiestaInformazioniUtenteAudit getInformazioniUtenteAudit(Map<String, AbstractProperty<?>> p, List<ModIAuditClaimConfig> list, FruizioneModIRichiestaInformazioniUtenteAudit infoAudit) throws CoreException {
        if (list != null && !list.isEmpty()) {
            for (ModIAuditClaimConfig modIAuditClaimConfig : list) {
                FruizioneModIRichiestaInformazioneUtenteAudit info = ModiErogazioniApiHelper.getInformazioneUtenteAudit(p, modIAuditClaimConfig.getNome());
                if (info == null) continue;
                if (infoAudit == null) {
                    infoAudit = new FruizioneModIRichiestaInformazioniUtenteAudit();
                }
                if (infoAudit.getInformazioni() == null) {
                    infoAudit.setInformazioni(new ArrayList<FruizioneModIRichiestaInformazioneUtenteAudit>());
                }
                infoAudit.addInformazioniItem(info);
            }
        }
        return infoAudit;
    }

    private static FruizioneModIRichiestaInformazioneUtenteAudit getInformazioneUtenteAudit(Map<String, AbstractProperty<?>> p, String nome) throws CoreException {
        String mod = "modipaSecurityMessageCorniceSicurezzaSchemaMode" + nome;
        String value = "modipaSecurityMessageCorniceSicurezzaSchemaValue" + nome;
        String modalitaString = ProtocolPropertiesHelper.getStringProperty(p, mod, false);
        if (modalitaString == null) {
            return null;
        }
        FruizioneModIRichiestaInformazioneUtenteAudit u = new FruizioneModIRichiestaInformazioneUtenteAudit();
        u.setNome(nome);
        StatoDefaultRidefinitoEnum modalita = modalitaString.equals("default") ? StatoDefaultRidefinitoEnum.DEFAULT : StatoDefaultRidefinitoEnum.RIDEFINITO;
        u.setModalita(modalita);
        if (modalita.equals((Object)StatoDefaultRidefinitoEnum.RIDEFINITO)) {
            String valueString = ProtocolPropertiesHelper.getStringProperty(p, value, false);
            u.setValore(valueString);
        }
        return u;
    }

    private static List<ModISicurezzaMessaggioRestRiferimentoX509> getX509(String x509String) {
        String[] split = x509String.split(",");
        ArrayList<ModISicurezzaMessaggioRestRiferimentoX509> lst = new ArrayList<ModISicurezzaMessaggioRestRiferimentoX509>();
        for (String x : split) {
            lst.add(ModISicurezzaMessaggioRestRiferimentoX509.fromValue(x));
        }
        return lst;
    }

    public static ProtocolProperties getProtocolProperties(Erogazione body, AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, ErogazioniEnv env, boolean required) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        return ModiErogazioniApiHelper.getModiProtocolProperties(aspc, asps, body.getModi(), ModiErogazioniApiHelper.getErogazioneConf(asps, env), required);
    }

    public static ProtocolProperties getProtocolProperties(Fruizione body, AccordoServizioParteSpecifica asps, ErogazioniEnv env, boolean required) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        return ModiErogazioniApiHelper.getModiProtocolProperties(body.getModi(), ModiErogazioniApiHelper.getFruizioneConf(asps, env), required);
    }

    public static ProtocolProperties updateModiProtocolProperties(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, ProfiloEnum profilo, OneOfErogazioneModIModi modi, ErogazioniEnv env) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        if (profilo == null || !profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(OPERAZIONE_UTILIZZABILE_SOLO_CON_MODI);
        }
        ErogazioneConf erogazioneConf = ModiErogazioniApiHelper.getErogazioneConf(asps, env);
        return ModiErogazioniApiHelper.getModiProtocolProperties(aspc, asps, modi, erogazioneConf);
    }

    public static ProtocolProperties updateModiProtocolProperties(AccordoServizioParteSpecifica asps, ProfiloEnum profilo, OneOfFruizioneModIModi modi, ErogazioniEnv env) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        if (profilo == null || !profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(OPERAZIONE_UTILIZZABILE_SOLO_CON_MODI);
        }
        FruizioneConf fruizioneConf = ModiErogazioniApiHelper.getFruizioneConf(asps, env);
        return ModiErogazioniApiHelper.getModiProtocolProperties(modi, fruizioneConf);
    }

    private static ProtocolProperties getModiProtocolProperties(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, OneOfErogazioneModIModi modi, ErogazioneConf erogazioneConf) {
        if (modi == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(SPECIFICARE_CONFIGURAZIONE_MODI);
        }
        ProtocolProperties p = new ProtocolProperties();
        if (erogazioneConf.protocollo.equals((Object)TipoApiEnum.SOAP)) {
            ModiErogazioniApiHelper.getSOAPProperties(aspc, asps, (ErogazioneModISoap)modi, p, erogazioneConf);
        } else if (erogazioneConf.protocollo.equals((Object)TipoApiEnum.REST)) {
            ModiErogazioniApiHelper.getRESTProperties(aspc, asps, (ErogazioneModIRest)modi, p, erogazioneConf);
        }
        return p;
    }

    private static ProtocolProperties getModiProtocolProperties(OneOfFruizioneModIModi modi, FruizioneConf fruizioneConf) {
        if (modi == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(SPECIFICARE_CONFIGURAZIONE_MODI);
        }
        ProtocolProperties p = new ProtocolProperties();
        if (TipoConfigurazioneFruizioneEnum.OAUTH.equals((Object)modi.getProtocollo())) {
            ModiErogazioniApiHelper.getOAUTHProperties((FruizioneModIOAuth)modi, p, fruizioneConf);
        } else if (fruizioneConf.protocollo.equals((Object)TipoApiEnum.SOAP)) {
            ModiErogazioniApiHelper.getSOAPProperties((FruizioneModISoap)modi, p, fruizioneConf);
        } else if (fruizioneConf.protocollo.equals((Object)TipoApiEnum.REST)) {
            ModiErogazioniApiHelper.getRESTProperties((FruizioneModIRest)modi, p, fruizioneConf);
        }
        return p;
    }

    private static ProtocolProperties getModiProtocolProperties(OneOfFruizioneModi modi, FruizioneConf fruizioneConf, boolean modiRequired) {
        if (modi == null) {
            if (modiRequired) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(SPECIFICARE_CONFIGURAZIONE_MODI);
            }
            return null;
        }
        ProtocolProperties p = new ProtocolProperties();
        if (TipoConfigurazioneFruizioneEnum.OAUTH.equals((Object)modi.getProtocollo())) {
            ModiErogazioniApiHelper.getOAUTHProperties((FruizioneModIOAuth)modi, p, fruizioneConf);
        } else if (fruizioneConf.protocollo.equals((Object)TipoApiEnum.SOAP)) {
            ModiErogazioniApiHelper.getSOAPProperties((FruizioneModISoap)modi, p, fruizioneConf);
        } else if (fruizioneConf.protocollo.equals((Object)TipoApiEnum.REST)) {
            ModiErogazioniApiHelper.getRESTProperties((FruizioneModIRest)modi, p, fruizioneConf);
        }
        return p;
    }

    private static ProtocolProperties getModiProtocolProperties(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, OneOfErogazioneModi modi, ErogazioneConf erogazioneConf, boolean modiRequired) {
        if (modi == null) {
            if (modiRequired) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(SPECIFICARE_CONFIGURAZIONE_MODI);
            }
            return null;
        }
        ProtocolProperties p = new ProtocolProperties();
        if (erogazioneConf.protocollo.equals((Object)TipoApiEnum.SOAP)) {
            ModiErogazioniApiHelper.getSOAPProperties(aspc, asps, (ErogazioneModISoap)modi, p, erogazioneConf);
        } else if (erogazioneConf.protocollo.equals((Object)TipoApiEnum.REST)) {
            ModiErogazioniApiHelper.getRESTProperties(aspc, asps, (ErogazioneModIRest)modi, p, erogazioneConf);
        }
        return p;
    }

    private static void fillErogazioneRESTRichiestaProperties(ErogazioneModIRest modi, ProtocolProperties p, ErogazioneConf erogazioneConf) {
        String tipo;
        ModITrustStoreRidefinito truststoreRidefinito;
        ErogazioneModIRestRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = modi.getRichiesta().getSicurezzaMessaggio();
        p.addProperty("modipaSecurityMessageRestRequestX509Cert", ModiErogazioniApiHelper.getX509(sicurezzaMessaggioRichiesta.getRiferimentoX509()));
        if (sicurezzaMessaggioRichiesta.getTruststore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
            p.addProperty("modipaTruststoreMode", "default");
            p.addProperty("modipaTruststoreCRLs", "");
            p.addProperty("modipaTruststoreOCSP", "");
            p.addProperty("modipaTruststorePassword", "");
            p.addProperty("modipaTruststorePath", "");
            p.addProperty("modipaTruststoreType", "");
        } else {
            truststoreRidefinito = (ModITrustStoreRidefinito)sicurezzaMessaggioRichiesta.getTruststore();
            p.addProperty("modipaTruststoreMode", "ridefinisci");
            p.addProperty("modipaTruststoreCRLs", truststoreRidefinito.getTruststoreCrl());
            if (truststoreRidefinito.getTruststoreOcspPolicy() != null) {
                p.addProperty("modipaTruststoreOCSP", truststoreRidefinito.getTruststoreOcspPolicy());
            }
            p.addProperty("modipaTruststorePassword", truststoreRidefinito.getTruststorePassword());
            p.addProperty("modipaTruststorePath", truststoreRidefinito.getTruststorePath());
            tipo = null;
            switch (truststoreRidefinito.getTruststoreTipo()) {
                case JKS: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS;
                    break;
                }
                case JWK: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK;
                    break;
                }
                case PKCS11: {
                    tipo = truststoreRidefinito.getPcks11Tipo();
                    if (tipo != null) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PKCS11_NON_INDICATO);
                }
                case PDND: {
                    tipo = truststoreRidefinito.getPdndTipo();
                    if (tipo == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_NON_INDICATO);
                    }
                    if (ModiErogazioniApiHelper.isModITrustStoreSafe(tipo)) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_SCONOSCIUTO_PREFIX + tipo);
                }
                default: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_SCONOSCIUTO_PREFIX + String.valueOf((Object)truststoreRidefinito.getTruststoreTipo()));
                }
            }
            p.addProperty("modipaTruststoreType", tipo);
        }
        if (sicurezzaMessaggioRichiesta.getTruststoreSsl() != null) {
            if (sicurezzaMessaggioRichiesta.getTruststoreSsl().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
                p.addProperty("modipaSslTruststoreMode", "default");
                p.addProperty("modipaSslTruststoreCRLs", "");
                p.addProperty("modipaSslTruststoreOCSP", "");
                p.addProperty("modipaSslTruststorePassword", "");
                p.addProperty("modipaSslTruststorePath", "");
                p.addProperty("modipaSslTruststoreType", "");
            } else {
                truststoreRidefinito = (ModITrustStoreRidefinito)sicurezzaMessaggioRichiesta.getTruststoreSsl();
                p.addProperty("modipaSslTruststoreMode", "ridefinisci");
                p.addProperty("modipaSslTruststoreCRLs", truststoreRidefinito.getTruststoreCrl());
                if (truststoreRidefinito.getTruststoreOcspPolicy() != null) {
                    p.addProperty("modipaSslTruststoreOCSP", truststoreRidefinito.getTruststoreOcspPolicy());
                }
                p.addProperty("modipaSslTruststorePassword", truststoreRidefinito.getTruststorePassword());
                p.addProperty("modipaSslTruststorePath", truststoreRidefinito.getTruststorePath());
                tipo = null;
                switch (truststoreRidefinito.getTruststoreTipo()) {
                    case JKS: {
                        tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SSL_TRUSTSTORE_TYPE_VALUE_JKS;
                        break;
                    }
                    case JWK: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_JWK_NON_SUPPORTATO_SSL);
                    }
                    case PKCS11: {
                        tipo = truststoreRidefinito.getPcks11Tipo();
                        if (tipo != null) break;
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PKCS11_NON_INDICATO);
                    }
                    case PDND: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_NON_SUPPORTATO_SSL);
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_SCONOSCIUTO_PREFIX + String.valueOf((Object)truststoreRidefinito.getTruststoreTipo()));
                    }
                }
                p.addProperty("modipaSslTruststoreType", tipo);
            }
        }
        if (sicurezzaMessaggioRichiesta.getTimeToLive() != null && sicurezzaMessaggioRichiesta.getTimeToLive() > 0) {
            p.addProperty("modipaSecurityMessageRequestIatMode", "ridefinisci");
            p.addProperty("modipaSecurityMessageRequestIatTtl", sicurezzaMessaggioRichiesta.getTimeToLive().intValue());
        } else {
            p.addProperty("modipaSecurityMessageRequestIatMode", "default");
        }
        if (sicurezzaMessaggioRichiesta.getAudience() != null) {
            p.addProperty("modipaSecurityMessageRequestAud", sicurezzaMessaggioRichiesta.getAudience());
        } else {
            p.addProperty("modipaSecurityMessageRequestAud", "");
        }
        if (sicurezzaMessaggioRichiesta.getContemporaneita() != null) {
            if (!erogazioneConf.sicurezzaMessaggioHeaderDuplicatiAbilitato) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'API implementata non risulta configurata per gestire la contemporaneit\u00e0 dei token AGID che servirebbe alle opzioni indicate per la richiesta");
            }
            if (sicurezzaMessaggioRichiesta.getContemporaneita().getIdentificativo() != null) {
                switch (sicurezzaMessaggioRichiesta.getContemporaneita().getIdentificativo()) {
                    case AGID: {
                        p.addProperty("modipaSecurityMessageRequestDuplicateJti", "modi");
                        break;
                    }
                    case BEARER: {
                        p.addProperty("modipaSecurityMessageRequestDuplicateJti", "auth");
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("(richiesta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'identificativo sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getIdentificativo()));
                    }
                }
            }
            if (sicurezzaMessaggioRichiesta.getContemporaneita().getAudience() != null) {
                switch (sicurezzaMessaggioRichiesta.getContemporaneita().getAudience()) {
                    case SAME: {
                        p.addProperty("modipaSecurityMessageRequestIntegrityAudMode", "same");
                        break;
                    }
                    case DIFFERENT: {
                        p.addProperty("modipaSecurityMessageRequestIntegrityAudMode", "different");
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("(richiesta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'audience sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getAudience()));
                    }
                }
                if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getAudience()) && sicurezzaMessaggioRichiesta.getContemporaneita().getAudienceAtteso() != null) {
                    p.addProperty("modipaSecurityMessageRequestIntegrityAud", sicurezzaMessaggioRichiesta.getContemporaneita().getAudienceAtteso());
                }
            }
        }
        if (sicurezzaMessaggioRichiesta.getAudit() != null && sicurezzaMessaggioRichiesta.getAudit().getAudience() != null) {
            switch (sicurezzaMessaggioRichiesta.getAudit().getAudience()) {
                case SAME: {
                    p.addProperty("modipaSecurityMessageRequestAuditAudMode", "same");
                    break;
                }
                case DIFFERENT: {
                    p.addProperty("modipaSecurityMessageRequestAuditAudMode", "different");
                    if (sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso() == null || StringUtils.isEmpty((CharSequence)sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Audience di audit non definito");
                    }
                    p.addProperty("modipaSecurityMessageRequestAuditAud", sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso());
                    break;
                }
                default: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Modalit\u00e0 di gestione dell'audience di audit sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getAudit().getAudience()));
                }
            }
        }
    }

    private static void fillErogazioneRESTRispostaProperties(ErogazioneModIRest modi, ProtocolProperties p, ErogazioneConf erogazioneConf) {
        ErogazioneModIRestRispostaSicurezzaMessaggio sicurezzaMessaggioRisposta = modi.getRisposta().getSicurezzaMessaggio();
        String algo = null;
        if (sicurezzaMessaggioRisposta.getAlgoritmo() != null) {
            switch (sicurezzaMessaggioRisposta.getAlgoritmo()) {
                case ES256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES256;
                    break;
                }
                case ES384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES384;
                    break;
                }
                case ES512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES512;
                    break;
                }
                case RS256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS256;
                    break;
                }
                case RS384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS384;
                    break;
                }
                case RS512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS512;
                    break;
                }
            }
        } else {
            algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS256;
        }
        p.addProperty("modipaSecurityMessageRestResponseAlg", algo);
        if (sicurezzaMessaggioRisposta.getHeaderHttpFirmare() != null) {
            httpHeaders = String.join((CharSequence)",", sicurezzaMessaggioRisposta.getHeaderHttpFirmare());
            p.addProperty("modipaSecurityMessageHttpHeaders", httpHeaders);
        } else {
            try {
                httpHeaders = ModIProperties.getInstance().getRestSecurityTokenSignedHeadersAsString();
                p.addProperty("modipaSecurityMessageHttpHeaders", httpHeaders);
            }
            catch (Exception e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Recupero header http da firmare per default fallito: " + e.getMessage());
            }
        }
        if (sicurezzaMessaggioRisposta.getRiferimentoX509() == null || sicurezzaMessaggioRisposta.getRiferimentoX509().equals((Object)ModISicurezzaMessaggioRestRiferimentoX509Risposta.RICHIESTA)) {
            p.addProperty("modipaSecurityMessageRestResponseX509CertAsReq", "true");
        } else {
            p.addProperty("modipaSecurityMessageRestResponseX509CertAsReq", "false");
            p.addProperty("modipaSecurityMessageRestResponseX509Cert", ModiErogazioniApiHelper.getX509(sicurezzaMessaggioRisposta.getRiferimentoX509Risposta()));
        }
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageRestResponseX509CertUseCertificateChain", (Boolean)(sicurezzaMessaggioRisposta.isCertificateChain() != null && sicurezzaMessaggioRisposta.isCertificateChain() != false ? 1 : 0)));
        if (sicurezzaMessaggioRisposta.getUrl() != null) {
            if (!modi.getRichiesta().getSicurezzaMessaggio().getRiferimentoX509().contains((Object)ModISicurezzaMessaggioRestRiferimentoX509.X5U)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile settare URL X5U con riferimento x509 " + String.valueOf(modi.getRichiesta().getSicurezzaMessaggio().getRiferimentoX509()));
            }
            p.addProperty("modipaSecurityMessageRestResponseX509Url", sicurezzaMessaggioRisposta.getUrl());
        } else if (modi.getRichiesta().getSicurezzaMessaggio().getRiferimentoX509().contains((Object)ModISicurezzaMessaggioRestRiferimentoX509.X5U)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare URL X5U con riferimento x509 " + String.valueOf(modi.getRichiesta().getSicurezzaMessaggio().getRiferimentoX509()));
        }
        if (sicurezzaMessaggioRisposta.getTimeToLive() != null) {
            p.addProperty("modipaSecurityMessageResponseExp", sicurezzaMessaggioRisposta.getTimeToLive().intValue());
        }
        if (sicurezzaMessaggioRisposta.getClaims() != null && !sicurezzaMessaggioRisposta.getClaims().isEmpty()) {
            p.addProperty("modipaSecurityMessageResponseClaims", String.join((CharSequence)"\n", sicurezzaMessaggioRisposta.getClaims()));
        }
        if (sicurezzaMessaggioRisposta.getKeystore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
            p.addProperty("modipaKeystoreCertMode", "default");
            p.addProperty("modipaKeystoreMode", "archive");
            p.addProperty("modipaKeystoreType", ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS);
            p.addProperty("modipaKeyAlias", "");
            p.addProperty("modipaKeyPassword", "");
            p.addProperty("modipaKeystorePassword", "");
            p.addProperty("modipaKeystorePath", "");
            p.addProperty("modipaKeystoreByokPolicy", "");
        } else {
            p.addProperty("modipaKeystoreCertMode", "ridefinisci");
            ModIKeyStoreRidefinito keystoreRidefinito = (ModIKeyStoreRidefinito)sicurezzaMessaggioRisposta.getKeystore();
            if (keystoreRidefinito.getDatiKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.HSM)) {
                ModIKeyStoreHSM hsmKeystore = (ModIKeyStoreHSM)keystoreRidefinito.getDatiKeystore();
                p.addProperty("modipaKeystoreMode", "hsm");
                p.addProperty("modipaKeystoreType", hsmKeystore.getPcks11Tipo());
                p.addProperty("modipaKeyAlias", hsmKeystore.getKeyAlias());
            } else if (keystoreRidefinito.getDatiKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.FILESYSTEM)) {
                ModIKeyStoreFile fsKeystore = (ModIKeyStoreFile)keystoreRidefinito.getDatiKeystore();
                p.addProperty("modipaKeystoreMode", "path");
                String tipo = null;
                switch (fsKeystore.getKeystoreTipo()) {
                    case JKS: {
                        tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                        break;
                    }
                    case PKCS12: {
                        tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                        break;
                    }
                    case JWK: {
                        tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK;
                        break;
                    }
                    case KEYS: {
                        tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR;
                        break;
                    }
                }
                p.addProperty("modipaKeystoreType", tipo);
                p.addProperty("modipaKeyAlias", fsKeystore.getKeyAlias());
                p.addProperty("modipaKeyPassword", fsKeystore.getKeyPassword());
                p.addProperty("modipaKeystorePassword", fsKeystore.getKeystorePassword());
                p.addProperty("modipaKeystorePath", fsKeystore.getKeystorePath());
                if (fsKeystore.getPublicKeyPath() != null && StringUtils.isNotEmpty((CharSequence)fsKeystore.getPublicKeyPath())) {
                    p.addProperty("modipaKeystorePathPublicKey", fsKeystore.getPublicKeyPath());
                }
                p.addProperty("modipaKeystoreByokPolicy", fsKeystore.getKeystoreByokPolicy());
            } else {
                ModIKeyStoreArchive archiveKeystore = (ModIKeyStoreArchive)keystoreRidefinito.getDatiKeystore();
                p.addProperty("modipaKeystoreMode", "archive");
                String tipo = null;
                String filename = null;
                switch (archiveKeystore.getKeystoreTipo()) {
                    case JKS: {
                        tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                        filename = "Keystore.jks";
                        break;
                    }
                    case PKCS12: {
                        tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                        filename = "Keystore.p12";
                        break;
                    }
                }
                p.addProperty("modipaKeystoreType", tipo);
                p.addProperty("modipaKeyAlias", archiveKeystore.getKeyAlias());
                p.addProperty("modipaKeyPassword", archiveKeystore.getKeyPassword());
                p.addProperty("modipaKeystorePassword", archiveKeystore.getKeystorePassword());
                p.addProperty("modipaKeystoreArchive", archiveKeystore.getKeystoreArchivio(), filename, filename);
            }
        }
        if (sicurezzaMessaggioRisposta.getContemporaneita() != null) {
            if (!erogazioneConf.sicurezzaMessaggioHeaderDuplicatiAbilitato) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'API implementata non risulta configurata per gestire la contemporaneit\u00e0 dei token AGID che servirebbe alle opzioni indicate per la risposta");
            }
            if (sicurezzaMessaggioRisposta.getContemporaneita().getIdentificativo() != null) {
                switch (sicurezzaMessaggioRisposta.getContemporaneita().getIdentificativo()) {
                    case SAME: {
                        p.addProperty("modipaSecurityMessageResponseJti", "same");
                        break;
                    }
                    case DIFFERENT: {
                        p.addProperty("modipaSecurityMessageResponseJti", "different");
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("(risposta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'identificativo sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRisposta.getContemporaneita().getIdentificativo()));
                    }
                }
                if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)sicurezzaMessaggioRisposta.getContemporaneita().getIdentificativo()) && sicurezzaMessaggioRisposta.getContemporaneita().getUsaComeIdMessaggio() != null) {
                    switch (sicurezzaMessaggioRisposta.getContemporaneita().getUsaComeIdMessaggio()) {
                        case AGID: {
                            p.addProperty("modipaSecurityMessageResponseJtiIdMsg", "modi");
                            break;
                        }
                        case BEARER: {
                            p.addProperty("modipaSecurityMessageResponseJtiIdMsg", "auth");
                            break;
                        }
                        default: {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("(risposta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'identificativo da usare come filtro duplicati sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRisposta.getContemporaneita().getUsaComeIdMessaggio()));
                        }
                    }
                }
            }
            if (sicurezzaMessaggioRisposta.getContemporaneita().getClaimsBearer() != null && !sicurezzaMessaggioRisposta.getContemporaneita().getClaimsBearer().isEmpty()) {
                p.addProperty("modipaSecurityMessageResponseClaimsAuth", String.join((CharSequence)"\n", sicurezzaMessaggioRisposta.getContemporaneita().getClaimsBearer()));
            }
            if (sicurezzaMessaggioRisposta.getContemporaneita().getClaimsAgid() != null && !sicurezzaMessaggioRisposta.getContemporaneita().getClaimsAgid().isEmpty()) {
                p.addProperty("modipaSecurityMessageResponseClaimsModi", String.join((CharSequence)"\n", sicurezzaMessaggioRisposta.getContemporaneita().getClaimsAgid()));
            }
        }
    }

    private static void getRESTProperties(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, ErogazioneModIRest modi, ProtocolProperties p, ErogazioneConf erogazioneConf) {
        if (!erogazioneConf.sicurezzaMessaggioAPIAbilitata) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(IMPOSSIBILE_ABILITARE_SICUREZZA);
        }
        if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)aspc, (String)asps.getPortType())) {
            if (modi == null || modi.getRichiesta() == null || modi.getRisposta() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(SICUREZZA_MESSAGGIO_NON_PRESENTE);
            }
            ModiErogazioniApiHelper.fillErogazioneRESTRichiestaProperties(modi, p, erogazioneConf);
            ModiErogazioniApiHelper.fillErogazioneRESTRispostaProperties(modi, p, erogazioneConf);
        } else if (modi != null && (modi.getRichiesta() != null || modi.getRisposta() != null)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(SICUREZZA_MESSAGGIO_NON_NECESSARIA);
        }
        if (modi != null) {
            ModiErogazioniApiHelper.fillErogazioneModIInfoGenerali(p, modi.getInformazioniGenerali());
        }
    }

    private static void getRESTProperties(FruizioneModIRest modi, ProtocolProperties p, FruizioneConf fruizioneConf) {
        String tipo;
        ModITrustStoreRidefinito truststoreRidefinito;
        FruizioneModIRestRispostaSicurezzaMessaggio sicurezzaMessaggioRisposta;
        if (!fruizioneConf.sicurezzaMessaggioAPIAbilitata) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(IMPOSSIBILE_ABILITARE_SICUREZZA);
        }
        FruizioneModIRestRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = modi.getRichiesta().getSicurezzaMessaggio();
        String algo = null;
        if (sicurezzaMessaggioRichiesta.getAlgoritmo() != null) {
            switch (sicurezzaMessaggioRichiesta.getAlgoritmo()) {
                case ES256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES256;
                    break;
                }
                case ES384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES384;
                    break;
                }
                case ES512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_ES512;
                    break;
                }
                case RS256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS256;
                    break;
                }
                case RS384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS384;
                    break;
                }
                case RS512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS512;
                    break;
                }
            }
        } else {
            algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_RS256;
        }
        p.addProperty("modipaSecurityMessageRestRequestAlg", algo);
        if (sicurezzaMessaggioRichiesta.getHeaderHttpFirmare() != null) {
            httpHeaders = String.join((CharSequence)",", sicurezzaMessaggioRichiesta.getHeaderHttpFirmare());
            p.addProperty("modipaSecurityMessageHttpHeaders", httpHeaders);
        } else {
            try {
                httpHeaders = ModIProperties.getInstance().getRestSecurityTokenSignedHeadersAsString();
                p.addProperty("modipaSecurityMessageHttpHeaders", httpHeaders);
            }
            catch (Exception e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Recupero header http da firmare per default fallito: " + e.getMessage());
            }
        }
        p.addProperty("modipaSecurityMessageRestRequestX509Cert", ModiErogazioniApiHelper.getX509(sicurezzaMessaggioRichiesta.getRiferimentoX509()));
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageRestRequestX509CertUseCertificateChain", (Boolean)(sicurezzaMessaggioRichiesta.isCertificateChain() != null && sicurezzaMessaggioRichiesta.isCertificateChain() != false ? 1 : 0)));
        if (sicurezzaMessaggioRichiesta.getTimeToLive() != null) {
            p.addProperty("modipaSecurityMessageRequestExp", sicurezzaMessaggioRichiesta.getTimeToLive().intValue());
        }
        if (sicurezzaMessaggioRichiesta.getAudience() != null) {
            p.addProperty("modipaSecurityMessageRequestAud", sicurezzaMessaggioRichiesta.getAudience());
        } else {
            p.addProperty("modipaSecurityMessageRequestAud", "");
        }
        if (sicurezzaMessaggioRichiesta.getClaims() != null && !sicurezzaMessaggioRichiesta.getClaims().isEmpty()) {
            p.addProperty("modipaSecurityMessageRequestClaims", String.join((CharSequence)"\n", sicurezzaMessaggioRichiesta.getClaims()));
        }
        if (sicurezzaMessaggioRichiesta.getKeystore() != null) {
            p.addProperty("modipaKeystoreFruizioneMode", "fruizione");
            if (sicurezzaMessaggioRichiesta.getKeystore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
                ModiErogazioniApiHelper.setKeystoreDefaultProperties(p);
            } else {
                ModIKeyStoreRidefinito keystoreRidefinito = (ModIKeyStoreRidefinito)sicurezzaMessaggioRichiesta.getKeystore();
                ModiErogazioniApiHelper.setKeystoreRidefinitoProperties(p, keystoreRidefinito);
            }
        } else if (sicurezzaMessaggioRichiesta.isKeystoreTokenPolicy() != null && sicurezzaMessaggioRichiesta.isKeystoreTokenPolicy().booleanValue()) {
            p.addProperty("modipaKeystoreFruizioneMode", "token");
        } else {
            p.addProperty("modipaKeystoreFruizioneMode", "applicativo");
        }
        ModiErogazioniApiHelper.addInformazioniUtente(sicurezzaMessaggioRichiesta.getInformazioniUtenteCodiceEnte(), p, fruizioneConf, "modipaSecurityMessageCorniceSicurezzaCodiceEnteMode", "modipaSecurityMessageCorniceSicurezzaCodiceEnte");
        ModiErogazioniApiHelper.addInformazioniUtente(sicurezzaMessaggioRichiesta.getInformazioniUtenteUserid(), p, fruizioneConf, "modipaSecurityMessageCorniceSicurezzaUserMode", "modipaSecurityMessageCorniceSicurezzaUser");
        ModiErogazioniApiHelper.addInformazioniUtente(sicurezzaMessaggioRichiesta.getInformazioniUtenteIndirizzoIp(), p, fruizioneConf, "modipaSecurityMessageCorniceSicurezzaIPUserMode", "modipaSecurityMessageCorniceSicurezzaIPUser");
        List<String> infoAuditRequired = ModiErogazioniApiHelper.getInformazioniAuditRequired(fruizioneConf.schemaAudit);
        if (sicurezzaMessaggioRichiesta.getAudit() != null) {
            if (sicurezzaMessaggioRichiesta.getAudit().getAudience() != null) {
                switch (sicurezzaMessaggioRichiesta.getAudit().getAudience()) {
                    case SAME: {
                        p.addProperty("modipaSecurityMessageRequestAuditAudMode", "same");
                        break;
                    }
                    case DIFFERENT: {
                        p.addProperty("modipaSecurityMessageRequestAuditAudMode", "different");
                        if (sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso() == null || StringUtils.isEmpty((CharSequence)sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso())) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Audience di audit non definito");
                        }
                        p.addProperty("modipaSecurityMessageRequestAuditAud", sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso());
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Modalit\u00e0 di gestione dell'audience di audit sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getAudit().getAudience()));
                    }
                }
            }
            if (sicurezzaMessaggioRichiesta.getAudit().getInformazioni() != null && !sicurezzaMessaggioRichiesta.getAudit().getInformazioni().isEmpty()) {
                List<String> claimsDefiniti = ModiErogazioniApiHelper.getInformazioniAudit(fruizioneConf.schemaAudit);
                for (FruizioneModIRichiestaInformazioneUtenteAudit info : sicurezzaMessaggioRichiesta.getAudit().getInformazioni()) {
                    if (info == null) continue;
                    ModiErogazioniApiHelper.addInformazioniUtente(info, p, fruizioneConf, claimsDefiniti);
                    infoAuditRequired.remove(info.getNome());
                }
            }
        }
        if (!infoAuditRequired.isEmpty()) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'audit definito nella API richiede la definizione delle seguenti informazioni: " + String.valueOf(infoAuditRequired));
        }
        if (sicurezzaMessaggioRichiesta.getContemporaneita() != null) {
            if (!fruizioneConf.sicurezzaMessaggioHeaderDuplicatiAbilitato) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'API implementata non risulta configurata per gestire la contemporaneit\u00e0 dei token AGID che servirebbe alle opzioni indicate per la richiesta");
            }
            if (sicurezzaMessaggioRichiesta.getContemporaneita().getIdentificativo() != null) {
                switch (sicurezzaMessaggioRichiesta.getContemporaneita().getIdentificativo()) {
                    case SAME: {
                        p.addProperty("modipaSecurityMessageRequestJti", "same");
                        break;
                    }
                    case DIFFERENT: {
                        p.addProperty("modipaSecurityMessageRequestJti", "different");
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("(richiesta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'identificativo sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getIdentificativo()));
                    }
                }
                if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getIdentificativo()) && sicurezzaMessaggioRichiesta.getContemporaneita().getUsaComeIdMessaggio() != null) {
                    switch (sicurezzaMessaggioRichiesta.getContemporaneita().getUsaComeIdMessaggio()) {
                        case AGID: {
                            p.addProperty("modipaSecurityMessageRequestJtiIdMsg", "modi");
                            break;
                        }
                        case BEARER: {
                            p.addProperty("modipaSecurityMessageRequestJtiIdMsg", "auth");
                            break;
                        }
                        default: {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("(richiesta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'identificativo come filtro duplicati sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getUsaComeIdMessaggio()));
                        }
                    }
                }
            }
            if (sicurezzaMessaggioRichiesta.getContemporaneita().getAudience() != null) {
                switch (sicurezzaMessaggioRichiesta.getContemporaneita().getAudience()) {
                    case SAME: {
                        p.addProperty("modipaSecurityMessageRequestIntegrityAudMode", "same");
                        break;
                    }
                    case DIFFERENT: {
                        p.addProperty("modipaSecurityMessageRequestIntegrityAudMode", "different");
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("(richiesta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'audience sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getAudience()));
                    }
                }
                if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)sicurezzaMessaggioRichiesta.getContemporaneita().getAudience()) && sicurezzaMessaggioRichiesta.getContemporaneita().getAudienceAtteso() != null) {
                    p.addProperty("modipaSecurityMessageRequestIntegrityAud", sicurezzaMessaggioRichiesta.getContemporaneita().getAudienceAtteso());
                }
            }
            if (sicurezzaMessaggioRichiesta.getContemporaneita().getClaimsBearer() != null && !sicurezzaMessaggioRichiesta.getContemporaneita().getClaimsBearer().isEmpty()) {
                p.addProperty("modipaSecurityMessageRequestClaimsAuth", String.join((CharSequence)"\n", sicurezzaMessaggioRichiesta.getContemporaneita().getClaimsBearer()));
            }
            if (sicurezzaMessaggioRichiesta.getContemporaneita().getClaimsAgid() != null && !sicurezzaMessaggioRichiesta.getContemporaneita().getClaimsAgid().isEmpty()) {
                p.addProperty("modipaSecurityMessageRequestClaimsModi", String.join((CharSequence)"\n", sicurezzaMessaggioRichiesta.getContemporaneita().getClaimsAgid()));
            }
        }
        if (modi.getRichiesta().getOauth() != null) {
            if (modi.getRichiesta().getOauth().getIdentificativo() != null && StringUtils.isNotEmpty((CharSequence)modi.getRichiesta().getOauth().getIdentificativo())) {
                p.addProperty("modipaSecurityOauthId", modi.getRichiesta().getOauth().getIdentificativo());
            }
            if (modi.getRichiesta().getOauth().getKid() != null && StringUtils.isNotEmpty((CharSequence)modi.getRichiesta().getOauth().getKid())) {
                p.addProperty("modipaSecurityOauthKid", modi.getRichiesta().getOauth().getKid());
            }
        }
        if ((sicurezzaMessaggioRisposta = modi.getRisposta().getSicurezzaMessaggio()).getRiferimentoX509() == null || sicurezzaMessaggioRisposta.getRiferimentoX509().equals((Object)ModISicurezzaMessaggioRestRiferimentoX509Risposta.RICHIESTA)) {
            p.addProperty("modipaSecurityMessageRestResponseX509CertAsReq", "true");
        } else {
            p.addProperty("modipaSecurityMessageRestResponseX509CertAsReq", "false");
            p.addProperty("modipaSecurityMessageRestResponseX509Cert", ModiErogazioniApiHelper.getX509(sicurezzaMessaggioRisposta.getRiferimentoX509Risposta()));
        }
        if (sicurezzaMessaggioRisposta.getTruststore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
            p.addProperty("modipaTruststoreMode", "default");
            p.addProperty("modipaTruststoreCRLs", "");
            p.addProperty("modipaTruststoreOCSP", "");
            p.addProperty("modipaTruststorePassword", "");
            p.addProperty("modipaTruststorePath", "");
            p.addProperty("modipaTruststoreType", "");
        } else {
            truststoreRidefinito = (ModITrustStoreRidefinito)sicurezzaMessaggioRisposta.getTruststore();
            p.addProperty("modipaTruststoreMode", "ridefinisci");
            p.addProperty("modipaTruststoreCRLs", truststoreRidefinito.getTruststoreCrl());
            if (truststoreRidefinito.getTruststoreOcspPolicy() != null) {
                p.addProperty("modipaTruststoreOCSP", truststoreRidefinito.getTruststoreOcspPolicy());
            }
            p.addProperty("modipaTruststorePassword", truststoreRidefinito.getTruststorePassword());
            p.addProperty("modipaTruststorePath", truststoreRidefinito.getTruststorePath());
            tipo = null;
            switch (truststoreRidefinito.getTruststoreTipo()) {
                case JKS: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS;
                    break;
                }
                case JWK: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK;
                    break;
                }
                case PKCS11: {
                    tipo = truststoreRidefinito.getPcks11Tipo();
                    if (tipo != null) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PKCS11_NON_INDICATO);
                }
                case PDND: {
                    tipo = truststoreRidefinito.getPdndTipo();
                    if (tipo == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_NON_INDICATO);
                    }
                    if (ModiErogazioniApiHelper.isModITrustStoreSafe(tipo)) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_SCONOSCIUTO_PREFIX + tipo);
                }
                default: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_SCONOSCIUTO_PREFIX + String.valueOf((Object)truststoreRidefinito.getTruststoreTipo()));
                }
            }
            p.addProperty("modipaTruststoreType", tipo);
        }
        if (sicurezzaMessaggioRisposta.getTruststoreSsl() != null) {
            if (sicurezzaMessaggioRisposta.getTruststoreSsl().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
                p.addProperty("modipaSslTruststoreMode", "default");
                p.addProperty("modipaSslTruststoreCRLs", "");
                p.addProperty("modipaSslTruststoreOCSP", "");
                p.addProperty("modipaSslTruststorePassword", "");
                p.addProperty("modipaSslTruststorePath", "");
                p.addProperty("modipaSslTruststoreType", "");
            } else {
                truststoreRidefinito = (ModITrustStoreRidefinito)sicurezzaMessaggioRisposta.getTruststoreSsl();
                p.addProperty("modipaSslTruststoreMode", "ridefinisci");
                p.addProperty("modipaSslTruststoreCRLs", truststoreRidefinito.getTruststoreCrl());
                if (truststoreRidefinito.getTruststoreOcspPolicy() != null) {
                    p.addProperty("modipaSslTruststoreOCSP", truststoreRidefinito.getTruststoreOcspPolicy());
                }
                p.addProperty("modipaSslTruststorePassword", truststoreRidefinito.getTruststorePassword());
                p.addProperty("modipaSslTruststorePath", truststoreRidefinito.getTruststorePath());
                tipo = null;
                switch (truststoreRidefinito.getTruststoreTipo()) {
                    case JKS: {
                        tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SSL_TRUSTSTORE_TYPE_VALUE_JKS;
                        break;
                    }
                    case JWK: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_JWK_NON_SUPPORTATO_SSL);
                    }
                    case PKCS11: {
                        tipo = truststoreRidefinito.getPcks11Tipo();
                        if (tipo != null) break;
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PKCS11_NON_INDICATO);
                    }
                    case PDND: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_NON_SUPPORTATO_SSL);
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_SCONOSCIUTO_PREFIX + String.valueOf((Object)truststoreRidefinito.getTruststoreTipo()));
                    }
                }
                p.addProperty("modipaSslTruststoreType", tipo);
            }
        }
        if (sicurezzaMessaggioRisposta.getTimeToLive() != null && sicurezzaMessaggioRisposta.getTimeToLive() > 0) {
            p.addProperty("modipaSecurityMessageResponseIatMode", "ridefinisci");
            p.addProperty("modipaSecurityMessageResponseIatTtl", sicurezzaMessaggioRisposta.getTimeToLive().intValue());
        } else {
            p.addProperty("modipaSecurityMessageResponseIatMode", "default");
        }
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageResponseAud", (Boolean)(sicurezzaMessaggioRisposta.isVerificaAudience() != null && sicurezzaMessaggioRisposta.isVerificaAudience() != false ? 1 : 0)));
        if (sicurezzaMessaggioRisposta.isVerificaAudience() != null && sicurezzaMessaggioRisposta.isVerificaAudience().booleanValue() && sicurezzaMessaggioRisposta.getAudienceAtteso() != null) {
            p.addProperty("modipaSecurityMessageResponseAudExpected", sicurezzaMessaggioRisposta.getAudienceAtteso());
        }
        if (sicurezzaMessaggioRisposta.getContemporaneita() != null) {
            if (!fruizioneConf.sicurezzaMessaggioHeaderDuplicatiAbilitato) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'API implementata non risulta configurata per gestire la contemporaneit\u00e0 dei token AGID che servirebbe alle opzioni indicate per la risposta");
            }
            if (sicurezzaMessaggioRisposta.getContemporaneita().getIdentificativo() != null) {
                switch (sicurezzaMessaggioRisposta.getContemporaneita().getIdentificativo()) {
                    case AGID: {
                        p.addProperty("modipaSecurityMessageResponseDuplicateJti", "modi");
                        break;
                    }
                    case BEARER: {
                        p.addProperty("modipaSecurityMessageResponseDuplicateJti", "auth");
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("(risposta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'identificativo sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRisposta.getContemporaneita().getIdentificativo()));
                    }
                }
            }
            if (sicurezzaMessaggioRisposta.getContemporaneita().getAudience() != null) {
                switch (sicurezzaMessaggioRisposta.getContemporaneita().getAudience()) {
                    case SAME: {
                        p.addProperty("modipaSecurityMessageResponseIntegrityAudMode", "same");
                        break;
                    }
                    case DIFFERENT: {
                        p.addProperty("modipaSecurityMessageResponseIntegrityAudMode", "different");
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("(risposta - contemporaneit\u00e0 dei token AGID) Modalit\u00e0 di gestione dell'audience sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRisposta.getContemporaneita().getAudience()));
                    }
                }
                if (ModISicurezzaMessaggioRestSameDifferentEnum.DIFFERENT.equals((Object)sicurezzaMessaggioRisposta.getContemporaneita().getAudience()) && sicurezzaMessaggioRisposta.getContemporaneita().getAudienceAtteso() != null) {
                    p.addProperty("modipaSecurityMessageResponseIntegrityAud", sicurezzaMessaggioRisposta.getContemporaneita().getAudienceAtteso());
                }
            }
        }
    }

    private static void addInformazioniUtente(FruizioneModIRichiestaInformazioneUtente informazioniUtenteField, ProtocolProperties p, FruizioneConf fruizioneConf, String modalitaString, String valueString) {
        if (informazioniUtenteField != null) {
            if (fruizioneConf.informazioniUtenteAbilitato) {
                if (informazioniUtenteField.getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
                    p.addProperty(modalitaString, "default");
                    p.addProperty(valueString, "");
                } else {
                    p.addProperty(modalitaString, "ridefinisci");
                    p.addProperty(valueString, informazioniUtenteField.getValore());
                }
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile settare info utente");
            }
        }
    }

    private static void addInformazioniUtente(FruizioneModIRichiestaInformazioneUtenteAudit informazioniUtenteField, ProtocolProperties p, FruizioneConf fruizioneConf, List<String> claimsDefiniti) {
        if (informazioniUtenteField != null) {
            if (fruizioneConf.informazioniUtenteAbilitato) {
                String nome = informazioniUtenteField.getNome();
                boolean find = claimsDefiniti.contains(nome);
                if (!find) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile settare info audit '" + nome + "': non risulta esistere una informazione con il nome indicato");
                }
                if (informazioniUtenteField.getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
                    p.addProperty("modipaSecurityMessageCorniceSicurezzaSchemaMode" + nome, "default");
                    p.addProperty("modipaSecurityMessageCorniceSicurezzaSchemaValue" + nome, "");
                } else {
                    p.addProperty("modipaSecurityMessageCorniceSicurezzaSchemaMode" + nome, "ridefinisci");
                    p.addProperty("modipaSecurityMessageCorniceSicurezzaSchemaValue" + nome, informazioniUtenteField.getValore());
                }
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile settare info audit");
            }
        }
    }

    private static String getX509(List<ModISicurezzaMessaggioRestRiferimentoX509> rif) {
        ArrayList<String> sX509 = new ArrayList<String>();
        if (rif.contains((Object)ModISicurezzaMessaggioRestRiferimentoX509.X5C)) {
            sX509.add("x5c");
        }
        if (rif.contains((Object)ModISicurezzaMessaggioRestRiferimentoX509.X5T_256)) {
            sX509.add("x5t");
        }
        if (rif.contains((Object)ModISicurezzaMessaggioRestRiferimentoX509.X5U)) {
            sX509.add("x5u");
        }
        return String.join((CharSequence)",", sX509);
    }

    private static void fillErogazioneSOAPRichiestaProperties(ErogazioneModISoap modi, ProtocolProperties p, ErogazioneConf erogazioneConf) {
        ErogazioneModISoapRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = modi.getRichiesta().getSicurezzaMessaggio();
        if (sicurezzaMessaggioRichiesta.getTruststore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
            p.addProperty("modipaTruststoreMode", "default");
            p.addProperty("modipaTruststoreCRLs", "");
            p.addProperty("modipaTruststoreOCSP", "");
            p.addProperty("modipaTruststorePassword", "");
            p.addProperty("modipaTruststorePath", "");
            p.addProperty("modipaTruststoreType", "");
        } else {
            ModITrustStoreRidefinito truststoreRidefinito = (ModITrustStoreRidefinito)sicurezzaMessaggioRichiesta.getTruststore();
            p.addProperty("modipaTruststoreMode", "ridefinisci");
            p.addProperty("modipaTruststoreCRLs", truststoreRidefinito.getTruststoreCrl());
            if (truststoreRidefinito.getTruststoreOcspPolicy() != null) {
                p.addProperty("modipaTruststoreOCSP", truststoreRidefinito.getTruststoreOcspPolicy());
            }
            p.addProperty("modipaTruststorePassword", truststoreRidefinito.getTruststorePassword());
            p.addProperty("modipaTruststorePath", truststoreRidefinito.getTruststorePath());
            String tipo = null;
            switch (truststoreRidefinito.getTruststoreTipo()) {
                case JKS: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS;
                    break;
                }
                case JWK: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK;
                    break;
                }
                case PKCS11: {
                    tipo = truststoreRidefinito.getPcks11Tipo();
                    if (tipo != null) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PKCS11_NON_INDICATO);
                }
                case PDND: {
                    tipo = truststoreRidefinito.getPdndTipo();
                    if (tipo == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_NON_INDICATO);
                    }
                    if (ModiErogazioniApiHelper.isModITrustStoreSafe(tipo)) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_SCONOSCIUTO_PREFIX + tipo);
                }
                default: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_SCONOSCIUTO_PREFIX + String.valueOf((Object)truststoreRidefinito.getTruststoreTipo()));
                }
            }
            p.addProperty("modipaTruststoreType", tipo);
        }
        if (sicurezzaMessaggioRichiesta.getTimeToLive() != null && sicurezzaMessaggioRichiesta.getTimeToLive() > 0) {
            p.addProperty("modipaSecurityMessageRequestIatMode", "ridefinisci");
            p.addProperty("modipaSecurityMessageRequestIatTtl", sicurezzaMessaggioRichiesta.getTimeToLive().intValue());
        } else {
            p.addProperty("modipaSecurityMessageRequestIatMode", "default");
        }
        if (sicurezzaMessaggioRichiesta.getWsaTo() != null) {
            p.addProperty("modipaSecurityMessageRequestAud", sicurezzaMessaggioRichiesta.getWsaTo());
        } else {
            p.addProperty("modipaSecurityMessageRequestAud", "");
        }
        if (sicurezzaMessaggioRichiesta.getAudit() != null && sicurezzaMessaggioRichiesta.getAudit().getAudience() != null) {
            switch (sicurezzaMessaggioRichiesta.getAudit().getAudience()) {
                case SAME: {
                    p.addProperty("modipaSecurityMessageRequestAuditAudMode", "same");
                    break;
                }
                case DIFFERENT: {
                    p.addProperty("modipaSecurityMessageRequestAuditAudMode", "different");
                    if (sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso() == null || StringUtils.isEmpty((CharSequence)sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Audience di audit non definito");
                    }
                    p.addProperty("modipaSecurityMessageRequestAuditAud", sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso());
                    break;
                }
                default: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Modalit\u00e0 di gestione dell'audience di audit sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getAudit().getAudience()));
                }
            }
        }
    }

    private static void fillErogazioneSOAPRispostaProperties(ErogazioneModISoap modi, ProtocolProperties p, ErogazioneConf erogazioneConf) {
        ErogazioneModISoapRispostaSicurezzaMessaggio sicurezzaMessaggioRisposta = modi.getRisposta().getSicurezzaMessaggio();
        String algo = null;
        if (sicurezzaMessaggioRisposta.getAlgoritmo() != null) {
            switch (sicurezzaMessaggioRisposta.getAlgoritmo()) {
                case DSA_SHA_256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_DSA_SHA_256;
                    break;
                }
                case ECDSA_SHA_256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_256;
                    break;
                }
                case ECDSA_SHA_384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_384;
                    break;
                }
                case ECDSA_SHA_512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_512;
                    break;
                }
                case RSA_SHA_256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_256;
                    break;
                }
                case RSA_SHA_384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_384;
                    break;
                }
                case RSA_SHA_512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_512;
                    break;
                }
            }
        } else {
            algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_256;
        }
        p.addProperty("modipaSecurityMessageSoapResponseAlg", algo);
        String canonic = null;
        if (sicurezzaMessaggioRisposta.getFormaCanonicaXml() != null) {
            switch (sicurezzaMessaggioRisposta.getFormaCanonicaXml()) {
                case CANONICAL_XML_10: {
                    canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_10;
                    break;
                }
                case CANONICAL_XML_11: {
                    canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_11;
                    break;
                }
                case EXCLUSIVE_CANONICAL_XML_10: {
                    canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_EXCLUSIVE_C14N_10;
                    break;
                }
            }
        } else {
            canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_EXCLUSIVE_C14N_10;
        }
        p.addProperty("modipaSecurityMessageSoapResponseCanonicalizationAlg", canonic);
        if (sicurezzaMessaggioRisposta.getHeaderSoapFirmare() != null) {
            String soapHeaders = String.join((CharSequence)"\n", sicurezzaMessaggioRisposta.getHeaderSoapFirmare());
            p.addProperty("modipaSecurityMessageSoapHeaders", soapHeaders);
        }
        String rif509 = null;
        if (sicurezzaMessaggioRisposta.getRiferimentoX509() != null) {
            switch (sicurezzaMessaggioRisposta.getRiferimentoX509()) {
                case BINARY_SECURITY_TOKEN: {
                    rif509 = "DirectReference";
                    break;
                }
                case ISSUER_SERIAL_SECURITY_TOKEN_REFERENCE: {
                    rif509 = "IssuerSerial";
                    break;
                }
                case SKI_KEY_IDENTIFIER: {
                    rif509 = "SKIKeyIdentifier";
                    break;
                }
                case THUMBPRINT_KEY_IDENTIFIER: {
                    rif509 = "Thumbprint";
                    break;
                }
                case X509_KEY_IDENTIFIER: {
                    rif509 = "X509KeyIdentifier";
                    break;
                }
            }
        } else {
            rif509 = "DirectReference";
        }
        p.addProperty("modipaSecurityMessageSoapResponseX509Cert", rif509);
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageSoapResponseX509CertIncludeSignatureToken", (Boolean)(sicurezzaMessaggioRisposta.isIncludiSignatureToken() != null && sicurezzaMessaggioRisposta.isIncludiSignatureToken() != false ? 1 : 0)));
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageSoapResponseX509CertUseCertificateChain", (Boolean)(sicurezzaMessaggioRisposta.isCertificateChain() != null && sicurezzaMessaggioRisposta.isCertificateChain() != false ? 1 : 0)));
        if (sicurezzaMessaggioRisposta.getTimeToLive() != null) {
            p.addProperty("modipaSecurityMessageResponseExp", sicurezzaMessaggioRisposta.getTimeToLive().intValue());
        } else {
            p.addProperty("modipaSecurityMessageResponseExp", 300);
        }
        if (sicurezzaMessaggioRisposta.getKeystore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
            ModiErogazioniApiHelper.setKeystoreDefaultProperties(p);
        } else {
            ModIKeyStoreRidefinito keystoreRidefinito = (ModIKeyStoreRidefinito)sicurezzaMessaggioRisposta.getKeystore();
            ModiErogazioniApiHelper.setKeystoreRidefinitoProperties(p, keystoreRidefinito);
        }
    }

    private static void getSOAPProperties(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, ErogazioneModISoap modi, ProtocolProperties p, ErogazioneConf erogazioneConf) {
        if (!erogazioneConf.sicurezzaMessaggioAPIAbilitata) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(IMPOSSIBILE_ABILITARE_SICUREZZA);
        }
        if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)aspc, (String)asps.getPortType())) {
            if (modi == null || modi.getRichiesta() == null || modi.getRisposta() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(SICUREZZA_MESSAGGIO_NON_PRESENTE);
            }
            ModiErogazioniApiHelper.fillErogazioneSOAPRichiestaProperties(modi, p, erogazioneConf);
            ModiErogazioniApiHelper.fillErogazioneSOAPRispostaProperties(modi, p, erogazioneConf);
        } else if (modi != null && (modi.getRichiesta() != null || modi.getRisposta() != null)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(SICUREZZA_MESSAGGIO_NON_NECESSARIA);
        }
        if (modi != null) {
            ModiErogazioniApiHelper.fillErogazioneModIInfoGenerali(p, modi.getInformazioniGenerali());
        }
    }

    private static void setKeystoreDefaultProperties(ProtocolProperties p) {
        p.addProperty("modipaKeystoreCertMode", "default");
        p.addProperty("modipaKeystoreMode", "archive");
        p.addProperty("modipaKeystoreType", ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS);
        p.addProperty("modipaKeyAlias", "");
        p.addProperty("modipaKeyPassword", "");
        p.addProperty("modipaKeystorePassword", "");
        p.addProperty("modipaKeystorePath", "");
        p.addProperty("modipaKeystoreByokPolicy", "");
    }

    private static void setKeystoreRidefinitoProperties(ProtocolProperties p, ModIKeyStoreRidefinito keystoreRidefinito) {
        p.addProperty("modipaKeystoreCertMode", "ridefinisci");
        if (keystoreRidefinito.getDatiKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.HSM)) {
            ModIKeyStoreHSM hsmKeystore = (ModIKeyStoreHSM)keystoreRidefinito.getDatiKeystore();
            p.addProperty("modipaKeystoreMode", "hsm");
            p.addProperty("modipaKeystoreType", hsmKeystore.getPcks11Tipo());
            p.addProperty("modipaKeyAlias", hsmKeystore.getKeyAlias());
        } else if (keystoreRidefinito.getDatiKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.FILESYSTEM)) {
            ModIKeyStoreFile fsKeystore = (ModIKeyStoreFile)keystoreRidefinito.getDatiKeystore();
            p.addProperty("modipaKeystoreMode", "path");
            String tipo = null;
            switch (fsKeystore.getKeystoreTipo()) {
                case JKS: {
                    tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                    break;
                }
                case PKCS12: {
                    tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                    break;
                }
                case JWK: {
                    tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK;
                    break;
                }
                case KEYS: {
                    tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR;
                    break;
                }
            }
            p.addProperty("modipaKeystoreType", tipo);
            p.addProperty("modipaKeyAlias", fsKeystore.getKeyAlias());
            p.addProperty("modipaKeyPassword", fsKeystore.getKeyPassword());
            p.addProperty("modipaKeystorePassword", fsKeystore.getKeystorePassword());
            p.addProperty("modipaKeystorePath", fsKeystore.getKeystorePath());
            if (fsKeystore.getPublicKeyPath() != null && StringUtils.isNotEmpty((CharSequence)fsKeystore.getPublicKeyPath())) {
                p.addProperty("modipaKeystorePathPublicKey", fsKeystore.getPublicKeyPath());
            }
            p.addProperty("modipaKeystoreByokPolicy", fsKeystore.getKeystoreByokPolicy());
        } else {
            ModIKeyStoreArchive archiveKeystore = (ModIKeyStoreArchive)keystoreRidefinito.getDatiKeystore();
            p.addProperty("modipaKeystoreMode", "archive");
            String tipo = null;
            String filename = null;
            switch (archiveKeystore.getKeystoreTipo()) {
                case JKS: {
                    tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                    filename = "Keystore.jks";
                    break;
                }
                case PKCS12: {
                    tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                    filename = "Keystore.p12";
                    break;
                }
            }
            p.addProperty("modipaKeystoreType", tipo);
            p.addProperty("modipaKeyAlias", archiveKeystore.getKeyAlias());
            p.addProperty("modipaKeyPassword", archiveKeystore.getKeyPassword());
            p.addProperty("modipaKeystorePassword", archiveKeystore.getKeystorePassword());
            p.addProperty("modipaKeystoreArchive", archiveKeystore.getKeystoreArchivio(), filename, filename);
        }
    }

    private static void getOAUTHProperties(FruizioneModIOAuth modi, ProtocolProperties p, FruizioneConf fruizioneConf) {
        if (fruizioneConf != null) {
            // empty if block
        }
        if (modi != null) {
            if (modi.getIdentificativo() != null && StringUtils.isNotEmpty((CharSequence)modi.getIdentificativo())) {
                p.addProperty("modipaSecurityOauthId", modi.getIdentificativo());
            }
            if (modi.getKid() != null && StringUtils.isNotEmpty((CharSequence)modi.getKid())) {
                p.addProperty("modipaSecurityOauthKid", modi.getKid());
            }
            if (modi.getKeystore() != null) {
                if (modi.getKeystore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
                    ModiErogazioniApiHelper.setKeystoreDefaultProperties(p);
                } else {
                    ModIKeyStoreRidefinito keystoreRidefinito = (ModIKeyStoreRidefinito)modi.getKeystore();
                    ModiErogazioniApiHelper.setKeystoreRidefinitoProperties(p, keystoreRidefinito);
                }
            }
        }
    }

    private static void getSOAPProperties(FruizioneModISoap modi, ProtocolProperties p, FruizioneConf fruizioneConf) {
        FruizioneModISoapRispostaSicurezzaMessaggio sicurezzaMessaggioRisposta;
        if (!fruizioneConf.sicurezzaMessaggioAPIAbilitata) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(IMPOSSIBILE_ABILITARE_SICUREZZA);
        }
        FruizioneModISoapRichiestaSicurezzaMessaggio sicurezzaMessaggioRichiesta = modi.getRichiesta().getSicurezzaMessaggio();
        String algo = null;
        if (sicurezzaMessaggioRichiesta.getAlgoritmo() != null) {
            switch (sicurezzaMessaggioRichiesta.getAlgoritmo()) {
                case DSA_SHA_256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_DSA_SHA_256;
                    break;
                }
                case ECDSA_SHA_256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_256;
                    break;
                }
                case ECDSA_SHA_384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_384;
                    break;
                }
                case ECDSA_SHA_512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_512;
                    break;
                }
                case RSA_SHA_256: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_256;
                    break;
                }
                case RSA_SHA_384: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_384;
                    break;
                }
                case RSA_SHA_512: {
                    algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_RSA_SHA_512;
                    break;
                }
            }
        } else {
            algo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_ECDSA_SHA_256;
        }
        p.addProperty("modipaSecurityMessageSoapRequestAlg", algo);
        String canonic = null;
        if (sicurezzaMessaggioRichiesta.getFormaCanonicaXml() != null) {
            switch (sicurezzaMessaggioRichiesta.getFormaCanonicaXml()) {
                case CANONICAL_XML_10: {
                    canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_10;
                    break;
                }
                case CANONICAL_XML_11: {
                    canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_INCLUSIVE_C14N_11;
                    break;
                }
                case EXCLUSIVE_CANONICAL_XML_10: {
                    canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_EXCLUSIVE_C14N_10;
                    break;
                }
            }
        } else {
            canonic = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_EXCLUSIVE_C14N_10;
        }
        p.addProperty("modipaSecurityMessageSoapRequestCanonicalizationAlg", canonic);
        if (sicurezzaMessaggioRichiesta.getHeaderSoapFirmare() != null) {
            String soapHeaders = String.join((CharSequence)"\n", sicurezzaMessaggioRichiesta.getHeaderSoapFirmare());
            p.addProperty("modipaSecurityMessageSoapHeaders", soapHeaders);
        }
        String rif509 = null;
        if (sicurezzaMessaggioRichiesta.getRiferimentoX509() != null) {
            switch (sicurezzaMessaggioRichiesta.getRiferimentoX509()) {
                case BINARY_SECURITY_TOKEN: {
                    rif509 = "DirectReference";
                    break;
                }
                case ISSUER_SERIAL_SECURITY_TOKEN_REFERENCE: {
                    rif509 = "IssuerSerial";
                    break;
                }
                case SKI_KEY_IDENTIFIER: {
                    rif509 = "SKIKeyIdentifier";
                    break;
                }
                case THUMBPRINT_KEY_IDENTIFIER: {
                    rif509 = "Thumbprint";
                    break;
                }
                case X509_KEY_IDENTIFIER: {
                    rif509 = "X509KeyIdentifier";
                    break;
                }
            }
        } else {
            rif509 = "DirectReference";
        }
        p.addProperty("modipaSecurityMessageSoapRequestX509Cert", rif509);
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageSoapRequestX509CertIncludeSignatureToken", (Boolean)(sicurezzaMessaggioRichiesta.isIncludiSignatureToken() != null && sicurezzaMessaggioRichiesta.isIncludiSignatureToken() != false ? 1 : 0)));
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageSoapRequestX509CertUseCertificateChain", (Boolean)(sicurezzaMessaggioRichiesta.isCertificateChain() != null && sicurezzaMessaggioRichiesta.isCertificateChain() != false ? 1 : 0)));
        if (sicurezzaMessaggioRichiesta.getTimeToLive() != null) {
            p.addProperty("modipaSecurityMessageRequestExp", sicurezzaMessaggioRichiesta.getTimeToLive().intValue());
        }
        if (sicurezzaMessaggioRichiesta.getWsaTo() != null) {
            p.addProperty("modipaSecurityMessageRequestAud", sicurezzaMessaggioRichiesta.getWsaTo());
        } else {
            p.addProperty("modipaSecurityMessageRequestAud", "");
        }
        if (sicurezzaMessaggioRichiesta.getKeystore() != null) {
            p.addProperty("modipaKeystoreFruizioneMode", "fruizione");
            if (sicurezzaMessaggioRichiesta.getKeystore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
                ModiErogazioniApiHelper.setKeystoreDefaultProperties(p);
            } else {
                ModIKeyStoreRidefinito keystoreRidefinito = (ModIKeyStoreRidefinito)sicurezzaMessaggioRichiesta.getKeystore();
                ModiErogazioniApiHelper.setKeystoreRidefinitoProperties(p, keystoreRidefinito);
            }
        } else if (sicurezzaMessaggioRichiesta.isKeystoreTokenPolicy() != null && sicurezzaMessaggioRichiesta.isKeystoreTokenPolicy().booleanValue()) {
            p.addProperty("modipaKeystoreFruizioneMode", "token");
        } else {
            p.addProperty("modipaKeystoreFruizioneMode", "applicativo");
        }
        ModiErogazioniApiHelper.addInformazioniUtente(sicurezzaMessaggioRichiesta.getInformazioniUtenteCodiceEnte(), p, fruizioneConf, "modipaSecurityMessageCorniceSicurezzaCodiceEnteMode", "modipaSecurityMessageCorniceSicurezzaCodiceEnte");
        ModiErogazioniApiHelper.addInformazioniUtente(sicurezzaMessaggioRichiesta.getInformazioniUtenteUserid(), p, fruizioneConf, "modipaSecurityMessageCorniceSicurezzaUserMode", "modipaSecurityMessageCorniceSicurezzaUser");
        ModiErogazioniApiHelper.addInformazioniUtente(sicurezzaMessaggioRichiesta.getInformazioniUtenteIndirizzoIp(), p, fruizioneConf, "modipaSecurityMessageCorniceSicurezzaIPUserMode", "modipaSecurityMessageCorniceSicurezzaIPUser");
        List<String> infoAuditRequired = ModiErogazioniApiHelper.getInformazioniAuditRequired(fruizioneConf.schemaAudit);
        if (sicurezzaMessaggioRichiesta.getAudit() != null) {
            if (sicurezzaMessaggioRichiesta.getAudit().getAudience() != null) {
                switch (sicurezzaMessaggioRichiesta.getAudit().getAudience()) {
                    case SAME: {
                        p.addProperty("modipaSecurityMessageRequestAuditAudMode", "same");
                        break;
                    }
                    case DIFFERENT: {
                        p.addProperty("modipaSecurityMessageRequestAuditAudMode", "different");
                        if (sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso() == null || StringUtils.isEmpty((CharSequence)sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso())) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Audience di audit non definito");
                        }
                        p.addProperty("modipaSecurityMessageRequestAuditAud", sicurezzaMessaggioRichiesta.getAudit().getAudienceAtteso());
                        break;
                    }
                    default: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Modalit\u00e0 di gestione dell'audience di audit sconosciuta: " + String.valueOf((Object)sicurezzaMessaggioRichiesta.getAudit().getAudience()));
                    }
                }
            }
            if (sicurezzaMessaggioRichiesta.getAudit().getInformazioni() != null && !sicurezzaMessaggioRichiesta.getAudit().getInformazioni().isEmpty()) {
                List<String> claimsDefiniti = ModiErogazioniApiHelper.getInformazioniAudit(fruizioneConf.schemaAudit);
                for (FruizioneModIRichiestaInformazioneUtenteAudit info : sicurezzaMessaggioRichiesta.getAudit().getInformazioni()) {
                    if (info == null) continue;
                    ModiErogazioniApiHelper.addInformazioniUtente(info, p, fruizioneConf, claimsDefiniti);
                    infoAuditRequired.remove(info.getNome());
                }
            }
        }
        if (!infoAuditRequired.isEmpty()) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'audit definito nella API richiede la definizione delle seguenti informazioni: " + String.valueOf(infoAuditRequired));
        }
        if (modi.getRichiesta().getOauth() != null) {
            if (modi.getRichiesta().getOauth().getIdentificativo() != null && StringUtils.isNotEmpty((CharSequence)modi.getRichiesta().getOauth().getIdentificativo())) {
                p.addProperty("modipaSecurityOauthId", modi.getRichiesta().getOauth().getIdentificativo());
            }
            if (modi.getRichiesta().getOauth().getKid() != null && StringUtils.isNotEmpty((CharSequence)modi.getRichiesta().getOauth().getKid())) {
                p.addProperty("modipaSecurityOauthKid", modi.getRichiesta().getOauth().getKid());
            }
        }
        if ((sicurezzaMessaggioRisposta = modi.getRisposta().getSicurezzaMessaggio()).getTruststore().getModalita().equals((Object)StatoDefaultRidefinitoEnum.DEFAULT)) {
            p.addProperty("modipaTruststoreMode", "default");
            p.addProperty("modipaTruststoreType", ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS);
            p.addProperty("modipaTruststorePassword", "");
            p.addProperty("modipaTruststorePath", "");
        } else {
            p.addProperty("modipaTruststoreMode", "ridefinisci");
            ModITrustStoreRidefinito truststoreRidefinito = (ModITrustStoreRidefinito)sicurezzaMessaggioRisposta.getTruststore();
            String tipo = null;
            switch (truststoreRidefinito.getTruststoreTipo()) {
                case JKS: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JKS;
                    break;
                }
                case JWK: {
                    tipo = ModICostanti.MODIPA_PROFILO_SICUREZZA_MESSAGGIO_CERTIFICATI_TRUSTSTORE_TYPE_VALUE_JWK;
                    break;
                }
                case PKCS11: {
                    tipo = truststoreRidefinito.getPcks11Tipo();
                    if (tipo != null) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PKCS11_NON_INDICATO);
                }
                case PDND: {
                    tipo = truststoreRidefinito.getPdndTipo();
                    if (tipo == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_NON_INDICATO);
                    }
                    if (ModiErogazioniApiHelper.isModITrustStoreSafe(tipo)) break;
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_PDND_SCONOSCIUTO_PREFIX + tipo);
                }
                default: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(TIPO_TRUSTSTORE_SCONOSCIUTO_PREFIX + String.valueOf((Object)truststoreRidefinito.getTruststoreTipo()));
                }
            }
            p.addProperty("modipaTruststoreType", tipo);
            p.addProperty("modipaTruststorePassword", truststoreRidefinito.getTruststorePassword());
            p.addProperty("modipaTruststorePath", truststoreRidefinito.getTruststorePath());
            p.addProperty("modipaTruststoreCRLs", truststoreRidefinito.getTruststoreCrl());
            if (truststoreRidefinito.getTruststoreOcspPolicy() != null) {
                p.addProperty("modipaTruststoreOCSP", truststoreRidefinito.getTruststoreOcspPolicy());
            }
        }
        if (sicurezzaMessaggioRisposta.getTimeToLive() != null && sicurezzaMessaggioRisposta.getTimeToLive() > 0) {
            p.addProperty("modipaSecurityMessageResponseIatMode", "ridefinisci");
            p.addProperty("modipaSecurityMessageResponseIatTtl", sicurezzaMessaggioRisposta.getTimeToLive().intValue());
        } else {
            p.addProperty("modipaSecurityMessageResponseIatMode", "default");
        }
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageResponseAud", (Boolean)(sicurezzaMessaggioRisposta.isVerificaWsaTo() != null && sicurezzaMessaggioRisposta.isVerificaWsaTo() != false ? 1 : 0)));
        if (sicurezzaMessaggioRisposta.isVerificaWsaTo() != null && sicurezzaMessaggioRisposta.isVerificaWsaTo().booleanValue() && sicurezzaMessaggioRisposta.getAudienceAtteso() != null) {
            p.addProperty("modipaSecurityMessageResponseAudExpected", sicurezzaMessaggioRisposta.getAudienceAtteso());
        }
    }

    private static void fillErogazioneModIInfoGenerali(ProtocolProperties p, ErogazioneModIInfoGenerali informazioniGenerali) {
        if (informazioniGenerali != null) {
            if (informazioniGenerali.getServiceId() != null) {
                p.addProperty("modipaInfoGenEserviceId", informazioniGenerali.getServiceId());
            }
            if (informazioniGenerali.getDescriptorId() != null && !informazioniGenerali.getDescriptorId().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String descriptorId : informazioniGenerali.getDescriptorId()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(descriptorId);
                }
                p.addProperty("modipaInfoGenDescriptorId", sb.toString());
            }
            ModiErogazioniApiHelper.fillErogazioneModIInfoGeneraliSignalHub(p, informazioniGenerali);
        }
    }

    private static void fillErogazioneModIInfoGeneraliSignalHub(ProtocolProperties p, ErogazioneModIInfoGenerali informazioniGenerali) {
        if (informazioniGenerali.getSignalHub() != null) {
            p.addProperty("modipaInfoGenSignalHub", true);
            ErogazioneModISignalHub signalHubConf = informazioniGenerali.getSignalHub();
            p.addProperty("modipaInfoGenSignalHubAlg", signalHubConf.getAlgoritmo());
            p.addProperty("modipaInfoGenSignalHubOp", signalHubConf.getRisorsa());
            if (signalHubConf.getRuolo() != null) {
                p.addProperty("modipaInfoGenSignalHubPulisherRole", signalHubConf.getRuolo());
            }
            if (signalHubConf.getApplicativo() != null) {
                p.addProperty("modipaInfoGenSignalHubPulisherSA", signalHubConf.getApplicativo());
            }
            p.addProperty("modipaInfoGenSignalHubSeedLifetime", signalHubConf.getGiorniRotazione().intValue());
            p.addProperty("modipaInfoGenSignalHubSeedSize", signalHubConf.getDimensioneSeme().intValue());
        }
    }

    private static ErogazioneModIInfoGenerali getErogazioneModIInfoGenerali(Map<String, AbstractProperty<?>> p) throws CoreException {
        Boolean signalHubEnabled;
        ErogazioneModIInfoGenerali infoGenerali = new ErogazioneModIInfoGenerali();
        boolean add = false;
        if (ModiErogazioniApiHelper.fillErogazioneModIInfoGeneraliServiceId(infoGenerali, p)) {
            add = true;
        }
        if (ModiErogazioniApiHelper.fillErogazioneModIInfoGeneraliDescriptorId(infoGenerali, p)) {
            add = true;
        }
        if ((signalHubEnabled = ProtocolPropertiesHelper.getBooleanProperty(p, "modipaInfoGenSignalHub", false, true)) != null && signalHubEnabled.booleanValue()) {
            add = true;
            ModiErogazioniApiHelper.fillErogazioneModIInfoGeneraliSignalHub(infoGenerali, p);
        }
        return add ? infoGenerali : null;
    }

    private static boolean fillErogazioneModIInfoGeneraliServiceId(ErogazioneModIInfoGenerali infoGenerali, Map<String, AbstractProperty<?>> p) throws CoreException {
        boolean add = false;
        String eServiceId = ProtocolPropertiesHelper.getStringProperty(p, "modipaInfoGenEserviceId", false);
        if (eServiceId != null) {
            infoGenerali.setServiceId(eServiceId);
            add = true;
        }
        return add;
    }

    private static boolean fillErogazioneModIInfoGeneraliDescriptorId(ErogazioneModIInfoGenerali infoGenerali, Map<String, AbstractProperty<?>> p) throws CoreException {
        boolean add = false;
        String descriptorId = ProtocolPropertiesHelper.getStringProperty(p, "modipaInfoGenDescriptorId", false);
        if (descriptorId != null) {
            if (descriptorId.contains(",")) {
                String[] tmp = descriptorId.split(",");
                add = ModiErogazioniApiHelper.fillErogazioneModIInfoGeneraliDescriptorId(infoGenerali, tmp);
            } else {
                infoGenerali.addDescriptorIdItem(descriptorId);
                add = true;
            }
        }
        return add;
    }

    private static boolean fillErogazioneModIInfoGeneraliDescriptorId(ErogazioneModIInfoGenerali infoGenerali, String[] tmp) {
        boolean add = false;
        if (tmp != null && tmp.length > 0) {
            for (String s : tmp) {
                if (infoGenerali.getDescriptorId() == null) {
                    infoGenerali.setDescriptorId(new ArrayList<String>());
                }
                infoGenerali.addDescriptorIdItem(s);
                add = true;
            }
        }
        return add;
    }

    private static void fillErogazioneModIInfoGeneraliSignalHub(ErogazioneModIInfoGenerali infoGenerali, Map<String, AbstractProperty<?>> p) throws CoreException {
        String digestAlgorithm = ProtocolPropertiesHelper.getStringProperty(p, "modipaInfoGenSignalHubAlg", false);
        String operation = ProtocolPropertiesHelper.getStringProperty(p, "modipaInfoGenSignalHubOp", false);
        String role = ProtocolPropertiesHelper.getStringProperty(p, "modipaInfoGenSignalHubPulisherRole", false);
        String saName = ProtocolPropertiesHelper.getStringProperty(p, "modipaInfoGenSignalHubPulisherSA", false);
        Integer seedLifetime = ProtocolPropertiesHelper.getIntegerProperty(p, "modipaInfoGenSignalHubSeedLifetime", false);
        Integer seedSize = ProtocolPropertiesHelper.getIntegerProperty(p, "modipaInfoGenSignalHubSeedSize", false);
        ErogazioneModISignalHub signalHubConf = new ErogazioneModISignalHub();
        signalHubConf.algoritmo(digestAlgorithm).applicativo(saName).dimensioneSeme(seedSize).risorsa(operation).ruolo(role).giorniRotazione(seedLifetime);
        infoGenerali.setSignalHub(signalHubConf);
    }

    class ErogazioneConf {
        TipoApiEnum protocollo;
        boolean sicurezzaMessaggioAPIAbilitata;
        boolean sicurezzaMessaggioHeaderDuplicatiAbilitato;

        ErogazioneConf(ModiErogazioniApiHelper this$0) {
        }
    }

    class FruizioneConf
    extends ErogazioneConf {
        boolean informazioniUtenteAbilitato;
        String schemaAudit;

        FruizioneConf(ModiErogazioniApiHelper this$0) {
            super(this$0);
        }
    }
}

