/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni.configurazione;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServiziApplicativi;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetti;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneToken;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.constants.ValidazioneContenutiApplicativiTipo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.rs.server.api.ErogazioniConfigurazioneApi;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.configurazione.ErogazioniConfEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKey;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKeyConfig;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKeyPosizione;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneBasic;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneCustom;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneHttps;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazionePrincipal;
import org.openspcoop2.core.config.rs.server.model.ApiCanale;
import org.openspcoop2.core.config.rs.server.model.ApiImplStato;
import org.openspcoop2.core.config.rs.server.model.CachingRisposta;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneApiCanale;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneCanaleEnum;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAttributeAuthority;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazioneToken;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuoli;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuolo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScope;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScopes;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneSoggetti;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneSoggetto;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneView;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiErogazioneAutorizzazioneApplicativi;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiErogazioneAutorizzazioneApplicativo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiGestioneToken;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiIdentificazioneAttributi;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiestaEnum;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiestaItem;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRispostaEnum;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRispostaItem;
import org.openspcoop2.core.config.rs.server.model.ElencoProprieta;
import org.openspcoop2.core.config.rs.server.model.GestioneCors;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.ListaRateLimitingPolicy;
import org.openspcoop2.core.config.rs.server.model.OneOfControlloAccessiAutenticazioneAutenticazione;
import org.openspcoop2.core.config.rs.server.model.ProprietaOpzioneCifratura;
import org.openspcoop2.core.config.rs.server.model.RateLimitingCriteriMetricaEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazioneUpdate;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazioneView;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyItem;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneDiagnosticiConfigurazione;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneMessaggi;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazione;
import org.openspcoop2.core.config.rs.server.model.StatoFunzionalitaConWarningEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazioneEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazionePrincipalToken;
import org.openspcoop2.core.config.rs.server.model.Validazione;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.ApiKeyState;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleUtilities;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class ErogazioniConfigurazioneApiServiceImpl
extends BaseImpl
implements ErogazioniConfigurazioneApi {
    public ErogazioniConfigurazioneApiServiceImpl() {
        super(LoggerFactory.getLogger(ErogazioniConfigurazioneApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void addErogazioneControlloAccessiAutorizzazioneApplicativi(ControlloAccessiErogazioneAutorizzazioneApplicativo body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            boolean isProfiloModi = env.isProfiloModi();
            boolean tokenAbilitato = pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null;
            boolean modiSicurezzaMessaggio = false;
            if (isProfiloModi) {
                boolean enabled;
                AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                AccordoServizioParteComune aspc = Helper.getAccordoFull(idAccordo.getNome(), idAccordo.getVersione(), idAccordo.getSoggettoReferente(), env.apcCore);
                modiSicurezzaMessaggio = env.isSicurezzaMessaggioRiferimentoX509Required(aspc, aspc.getPortType().toString());
                boolean bl = enabled = pa.getServiziApplicativiAutorizzati() != null && pa.sizeServizioApplicativoList() > 0;
                if (!enabled) {
                    boolean bl2 = enabled = pa.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneApplicativi());
                }
                if (!enabled) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione messaggio per richiedente non \u00e8 abilitata");
                }
            } else if (!TipoAutorizzazione.isAuthenticationRequired((String)pa.getAutorizzazione())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione trasporto per richiedente non \u00e8 abilitata");
            }
            IdSoggetto idSoggettoProprietarioSA = (IdSoggetto)env.idSoggetto.clone();
            if (StringUtils.isNotEmpty((CharSequence)body.getSoggetto())) {
                idSoggettoProprietarioSA.setNome(body.getSoggetto());
                try {
                    idSoggettoProprietarioSA.setId(Long.valueOf(env.soggettiCore.getIdSoggetto(body.getSoggetto(), env.tipo_soggetto)));
                }
                catch (Exception idAccordo) {
                    // empty catch block
                }
            }
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(idSoggettoProprietarioSA.toIDSoggetto());
            idSA.setNome(body.getApplicativo());
            ServizioApplicativo sa = (ServizioApplicativo)BaseHelper.supplyOrNonValida(() -> env.saCore.getServizioApplicativo(idSA), (String)("Servizio Applicativo " + idSA.toString()));
            org.openspcoop2.core.config.constants.CredenzialeTipo tipoAutenticazione = null;
            boolean check = true;
            boolean bothSslAndToken = false;
            if (isProfiloModi) {
                if (!tokenAbilitato && !modiSicurezzaMessaggio) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 possibile registrare alcun applicativo: non \u00e8 stata riscontrato alcun criterio di sicurezza (messaggio o token)");
                }
                bothSslAndToken = tokenAbilitato && modiSicurezzaMessaggio;
                boolean dominioInterno = env.isDominioInterno(idSA.getIdSoggettoProprietario());
                if (dominioInterno) {
                    boolean sicurezzaMessaggio = false;
                    boolean sicurezzaToken = false;
                    if (sa.sizeProtocolPropertyList() > 0) {
                        for (ProtocolProperty pp : sa.getProtocolPropertyList()) {
                            if ("modipaSecurityMessage".equals(pp.getName())) {
                                sicurezzaMessaggio = pp.getBooleanValue() != null && pp.getBooleanValue() != false;
                                continue;
                            }
                            if (!"modipaSecurityToken".equals(pp.getName())) continue;
                            sicurezzaToken = pp.getBooleanValue() != null && pp.getBooleanValue() != false;
                        }
                    }
                    check = false;
                    if (bothSslAndToken) {
                        if (!sicurezzaToken) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza token richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                        }
                        if (!sicurezzaMessaggio) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza messaggio richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                        }
                    } else if (tokenAbilitato) {
                        if (!sicurezzaToken) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza token richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                        }
                    } else if (!sicurezzaMessaggio) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza messaggio richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                    }
                } else {
                    tipoAutenticazione = tokenAbilitato ? org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN : org.openspcoop2.core.config.constants.CredenzialeTipo.SSL;
                }
            } else {
                tipoAutenticazione = org.openspcoop2.core.config.constants.CredenzialeTipo.toEnumConstant((String)pa.getAutenticazione());
                if (tipoAutenticazione == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non risulta abilitato un tipo di autenticazione trasporto nell'erogazione selezionata");
                }
            }
            if (check) {
                Boolean appId = null;
                if (org.openspcoop2.core.config.constants.CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione)) {
                    ApiKeyState apiKeyState = new ApiKeyState(env.paCore.getParametroAutenticazione(pa.getAutenticazione(), pa.getProprietaAutenticazioneList()));
                    appId = apiKeyState.appIdSelected;
                }
                List saCompatibili = env.saCore.soggettiServizioApplicativoList(idSoggettoProprietarioSA.toIDSoggetto(), env.userLogin, tipoAutenticazione, appId, "client", bothSslAndToken, pa.getGestioneToken() != null ? pa.getGestioneToken().getPolicy() : null);
                if (env.protocolFactory.createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni() && !BaseHelper.findFirst((Iterable)saCompatibili, s -> s.getId().equals(sa.getId())).isPresent()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il tipo di credenziali dell'Applicativo non sono compatibili con l'autenticazione impostata nell'erogazione selezionata");
                }
            }
            if (pa.getServiziApplicativiAutorizzati() == null) {
                pa.setServiziApplicativiAutorizzati(new PortaApplicativaAutorizzazioneServiziApplicativi());
            }
            if (BaseHelper.findFirst((Iterable)pa.getServiziApplicativiAutorizzati().getServizioApplicativoList(), s -> sa.getNome().equals(s.getNome()) && sa.getTipoSoggettoProprietario().equals(s.getTipoSoggettoProprietario()) && sa.getNomeSoggettoProprietario().equals(s.getNomeSoggettoProprietario())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Servizio Applicativo gi\u00e0 associato");
            }
            env.requestWrapper.overrideParameter("id", pa.getId().toString());
            env.requestWrapper.overrideParameter("soggt", idSoggettoProprietarioSA.getId().toString());
            env.requestWrapper.overrideParameter("saAuthz", sa.getId().toString());
            if (!env.paHelper.porteAppServizioApplicativoAutorizzatiCheckData(TipoOperazione.ADD)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            PortaApplicativaAutorizzazioneServizioApplicativo paSaAutorizzato = new PortaApplicativaAutorizzazioneServizioApplicativo();
            paSaAutorizzato.setNome(sa.getNome());
            paSaAutorizzato.setTipoSoggettoProprietario(idSoggettoProprietarioSA.getTipo());
            paSaAutorizzato.setNomeSoggettoProprietario(idSoggettoProprietarioSA.getNome());
            pa.getServiziApplicativiAutorizzati().addServizioApplicativo(paSaAutorizzato);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneControlloAccessiAutorizzazioneSoggetti(ControlloAccessiAutorizzazioneSoggetto body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            boolean isProfiloModi = env.isProfiloModi();
            if (!TipoAutorizzazione.isAuthenticationRequired((String)pa.getAutorizzazione())) {
                if (isProfiloModi) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione canale per richiedente non \u00e8 abilitata");
                }
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione trasporto per richiedente non \u00e8 abilitata");
            }
            IDSoggetto daAutenticareID = new IDSoggetto(env.tipo_soggetto, body.getSoggetto());
            Soggetto daAutenticare = (Soggetto)BaseHelper.supplyOrNonValida(() -> env.soggettiCore.getSoggetto(daAutenticareID), (String)("Soggetto " + body.getSoggetto() + " da autenticare"));
            CredenzialeTipo tipoAutenticazione = CredenzialeTipo.toEnumConstant((String)pa.getAutenticazione());
            if (tipoAutenticazione == null) {
                if (!env.protocolFactory.createProtocolConfiguration().isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazioni()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non risulta abilitato un tipo di autenticazione trasporto nell'erogazione selezionata");
                }
            } else {
                Boolean appId = null;
                if (CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione)) {
                    ApiKeyState apiKeyState = new ApiKeyState(env.paCore.getParametroAutenticazione(pa.getAutenticazione(), pa.getProprietaAutenticazioneList()));
                    appId = apiKeyState.appIdSelected;
                }
                List tipiSoggettiGestitiProtocollo = env.soggettiCore.getTipiSoggettiGestitiProtocollo(env.tipo_protocollo);
                List soggettiCompatibili = env.soggettiCore.getSoggettiFromTipoAutenticazione(tipiSoggettiGestitiProtocollo, null, tipoAutenticazione, appId, null);
                if (env.protocolFactory.createProtocolConfiguration().isSupportoAutenticazioneSoggetti() && !BaseHelper.findFirst((Iterable)soggettiCompatibili, s -> daAutenticare.getTipo().equals(s.getTipo()) && daAutenticare.getNome().equals(s.getNome())).isPresent()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il tipo di credenziali del Soggetto non sono compatibili con l'autenticazione impostata nell'erogazione selezionata");
                }
            }
            if (pa.getSoggetti() == null) {
                pa.setSoggetti(new PortaApplicativaAutorizzazioneSoggetti());
            }
            if (BaseHelper.findFirst((Iterable)pa.getSoggetti().getSoggettoList(), sogg -> new IDSoggetto(sogg.getTipo(), sogg.getNome()).equals((Object)daAutenticareID)).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Soggetto da autorizzare gi\u00e0 presente");
            }
            env.requestWrapper.overrideParameter("id", pa.getId().toString());
            env.requestWrapper.overrideParameter("soggt", daAutenticare.getId().toString());
            if (!env.paHelper.porteAppSoggettoCheckData(TipoOperazione.ADD)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            PortaApplicativaAutorizzazioneSoggetto paSoggetto = new PortaApplicativaAutorizzazioneSoggetto();
            paSoggetto.setTipo(daAutenticare.getTipo());
            paSoggetto.setNome(daAutenticare.getNome());
            pa.getSoggetti().addSoggetto(paSoggetto);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneControlloAccessiAutorizzazioneApplicativiToken(ControlloAccessiErogazioneAutorizzazioneApplicativo body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            boolean isProfiloModi = env.isProfiloModi();
            boolean tokenAbilitato = pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null;
            boolean modiSicurezzaMessaggio = false;
            if (isProfiloModi) {
                boolean enabled;
                AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                AccordoServizioParteComune aspc = Helper.getAccordoFull(idAccordo.getNome(), idAccordo.getVersione(), idAccordo.getSoggettoReferente(), env.apcCore);
                modiSicurezzaMessaggio = env.isSicurezzaMessaggioRiferimentoX509Required(aspc, aspc.getPortType().toString());
                boolean bl = enabled = pa.getServiziApplicativiAutorizzati() != null && pa.sizeServizioApplicativoList() > 0;
                if (!enabled) {
                    boolean bl2 = enabled = pa.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneApplicativi());
                }
                if (!enabled) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione messaggio per richiedente non \u00e8 abilitata");
                }
            } else {
                if (pa.getGestioneToken() == null || pa.getGestioneToken().getPolicy() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione token per richiedente non \u00e8 utilizzabile, non risulta abilitata una token policy di validazione");
                }
                if (pa.getAutorizzazioneToken() == null || !StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione token per richiedente non \u00e8 abilitata");
                }
            }
            String tokenPolicy = pa.getGestioneToken() != null ? pa.getGestioneToken().getPolicy() : null;
            IdSoggetto idSoggettoProprietarioSA = (IdSoggetto)env.idSoggetto.clone();
            if (StringUtils.isNotEmpty((CharSequence)body.getSoggetto())) {
                idSoggettoProprietarioSA.setNome(body.getSoggetto());
                try {
                    idSoggettoProprietarioSA.setId(Long.valueOf(env.soggettiCore.getIdSoggetto(body.getSoggetto(), env.tipo_soggetto)));
                }
                catch (Exception aspc) {
                    // empty catch block
                }
            }
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(idSoggettoProprietarioSA.toIDSoggetto());
            idSA.setNome(body.getApplicativo());
            ServizioApplicativo sa = (ServizioApplicativo)BaseHelper.supplyOrNonValida(() -> env.saCore.getServizioApplicativo(idSA), (String)("Servizio Applicativo " + idSA.toString()));
            org.openspcoop2.core.config.constants.CredenzialeTipo tipoAutenticazione = null;
            boolean check = true;
            boolean bothSslAndToken = false;
            if (isProfiloModi) {
                if (!tokenAbilitato && !modiSicurezzaMessaggio) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 possibile registrare alcun applicativo: non \u00e8 stata riscontrato alcun criterio di sicurezza (messaggio o token)");
                }
                bothSslAndToken = tokenAbilitato && modiSicurezzaMessaggio;
                boolean dominioInterno = env.isDominioInterno(idSA.getIdSoggettoProprietario());
                if (dominioInterno) {
                    boolean sicurezzaMessaggio = false;
                    boolean sicurezzaToken = false;
                    if (sa.sizeProtocolPropertyList() > 0) {
                        for (ProtocolProperty pp : sa.getProtocolPropertyList()) {
                            if ("modipaSecurityMessage".equals(pp.getName())) {
                                sicurezzaMessaggio = pp.getBooleanValue() != null && pp.getBooleanValue() != false;
                                continue;
                            }
                            if (!"modipaSecurityToken".equals(pp.getName())) continue;
                            sicurezzaToken = pp.getBooleanValue() != null && pp.getBooleanValue() != false;
                        }
                    }
                    check = false;
                    if (bothSslAndToken) {
                        if (!sicurezzaToken) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza token richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                        }
                        if (!sicurezzaMessaggio) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza messaggio richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                        }
                    } else if (tokenAbilitato) {
                        if (!sicurezzaToken) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza token richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                        }
                    } else if (!sicurezzaMessaggio) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'applicativo, di dominio interno, indicato non possiede una configurazione per la sicurezza messaggio richiesta per essere autorizzati ad invocare l'erogazione con profilo ModI indicata");
                    }
                } else {
                    tipoAutenticazione = tokenAbilitato ? org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN : org.openspcoop2.core.config.constants.CredenzialeTipo.SSL;
                }
            } else {
                tipoAutenticazione = org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN;
            }
            if (check) {
                Boolean appId = null;
                List saCompatibili = env.saCore.soggettiServizioApplicativoList(idSoggettoProprietarioSA.toIDSoggetto(), env.userLogin, tipoAutenticazione, appId, "client", bothSslAndToken, tokenPolicy);
                if (env.protocolFactory.createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni() && !BaseHelper.findFirst((Iterable)saCompatibili, s -> s.getId().equals(sa.getId())).isPresent()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il tipo di credenziali dell'Applicativo non sono compatibili con l'autenticazione impostata nell'erogazione selezionata");
                }
            }
            if (isProfiloModi) {
                if (pa.getServiziApplicativiAutorizzati() == null) {
                    pa.setServiziApplicativiAutorizzati(new PortaApplicativaAutorizzazioneServiziApplicativi());
                }
            } else {
                if (pa.getAutorizzazioneToken() == null) {
                    pa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
                }
                if (pa.getAutorizzazioneToken().getServiziApplicativi() == null) {
                    pa.getAutorizzazioneToken().setServiziApplicativi(new PortaApplicativaAutorizzazioneServiziApplicativi());
                }
            }
            List lSA = null;
            lSA = isProfiloModi ? pa.getServiziApplicativiAutorizzati().getServizioApplicativoList() : pa.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList();
            if (BaseHelper.findFirst((Iterable)lSA, s -> sa.getNome().equals(s.getNome()) && sa.getTipoSoggettoProprietario().equals(s.getTipoSoggettoProprietario()) && sa.getNomeSoggettoProprietario().equals(s.getNomeSoggettoProprietario())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Servizio Applicativo gi\u00e0 associato");
            }
            env.requestWrapper.overrideParameter("id", pa.getId().toString());
            env.requestWrapper.overrideParameter("soggt", idSoggettoProprietarioSA.getId().toString());
            env.requestWrapper.overrideParameter("saAuthz", sa.getId().toString());
            if (!env.paHelper.porteAppServizioApplicativoAutorizzatiCheckData(TipoOperazione.ADD)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            PortaApplicativaAutorizzazioneServizioApplicativo paSaAutorizzato = new PortaApplicativaAutorizzazioneServizioApplicativo();
            paSaAutorizzato.setNome(sa.getNome());
            paSaAutorizzato.setTipoSoggettoProprietario(idSoggettoProprietarioSA.getTipo());
            paSaAutorizzato.setNomeSoggettoProprietario(idSoggettoProprietarioSA.getNome());
            if (isProfiloModi) {
                pa.getServiziApplicativiAutorizzati().addServizioApplicativo(paSaAutorizzato);
            } else {
                pa.getAutorizzazioneToken().getServiziApplicativi().addServizioApplicativo(paSaAutorizzato);
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneControlloAccessiAutorizzazioneRuoli(ControlloAccessiAutorizzazioneRuolo body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            boolean isProfiloModi = env.isProfiloModi();
            if (!TipoAutorizzazione.isRolesRequired((String)pa.getAutorizzazione())) {
                if (isProfiloModi) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione canale per ruoli non \u00e8 abilitata per il gruppo scelto");
                }
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione trasporto per ruoli non \u00e8 abilitata per il gruppo scelto");
            }
            RuoliCore ruoliCore = new RuoliCore(env.stationCore);
            BaseHelper.supplyOrNonValida(() -> ruoliCore.getRuolo(body.getRuolo()), (String)("Ruolo " + body.getRuolo()));
            if (pa.getRuoli() == null) {
                pa.setRuoli(new AutorizzazioneRuoli());
            }
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.PORTA_APPLICATIVA);
            filtroRuoli.setTipologia(RuoloTipologia.QUALSIASI);
            if (TipoAutorizzazione.isInternalRolesRequired((String)pa.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            } else if (TipoAutorizzazione.isExternalRolesRequired((String)pa.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.ESTERNO);
            }
            List ruoliAmmessi = env.stationCore.getAllRuoli(filtroRuoli);
            if (!ruoliAmmessi.contains(body.getRuolo())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il ruolo " + body.getRuolo() + "non \u00e8 tra i ruoli ammissibili per il gruppo");
            }
            List ruoliPresenti = pa.getRuoli().getRuoloList().stream().map(r -> r.getNome()).collect(Collectors.toList());
            if (BaseHelper.findFirst(ruoliPresenti, r -> r.equals(body.getRuolo())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Il ruolo " + body.getRuolo() + " \u00e8 gi\u00e0 associato al gruppo scelto");
            }
            if (!env.paHelper.ruoloCheckData(TipoOperazione.ADD, body.getRuolo(), ruoliPresenti)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(body.getRuolo());
            pa.getRuoli().addRuolo(ruolo);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneControlloAccessiAutorizzazioneRuoliToken(ControlloAccessiAutorizzazioneRuolo body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            boolean isProfiloModi = env.isProfiloModi();
            if (pa.getAutorizzazioneToken() == null || !StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                if (isProfiloModi) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione messaggio per ruoli non \u00e8 abilitata");
                }
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione token per ruoli non \u00e8 abilitata");
            }
            RuoliCore ruoliCore = new RuoliCore(env.stationCore);
            BaseHelper.supplyOrNonValida(() -> ruoliCore.getRuolo(body.getRuolo()), (String)("Ruolo " + body.getRuolo()));
            if (pa.getAutorizzazioneToken() == null) {
                pa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
            }
            if (pa.getAutorizzazioneToken().getRuoli() == null) {
                pa.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
            }
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.PORTA_APPLICATIVA);
            filtroRuoli.setTipologia(RuoloTipologia.QUALSIASI);
            if (TipoAutorizzazione.isInternalRolesRequired((String)pa.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            } else if (TipoAutorizzazione.isExternalRolesRequired((String)pa.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.ESTERNO);
            }
            List ruoliAmmessi = env.stationCore.getAllRuoli(filtroRuoli);
            if (!ruoliAmmessi.contains(body.getRuolo())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il ruolo " + body.getRuolo() + "non \u00e8 tra i ruoli ammissibili per il gruppo");
            }
            List ruoliPresenti = pa.getAutorizzazioneToken().getRuoli().getRuoloList().stream().map(r -> r.getNome()).collect(Collectors.toList());
            if (BaseHelper.findFirst(ruoliPresenti, r -> r.equals(body.getRuolo())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Il ruolo " + body.getRuolo() + " \u00e8 gi\u00e0 associato al gruppo scelto");
            }
            if (!env.paHelper.ruoloCheckData(TipoOperazione.ADD, body.getRuolo(), ruoliPresenti)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(body.getRuolo());
            pa.getAutorizzazioneToken().getRuoli().addRuolo(ruolo);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneProprieta(ProprietaOpzioneCifratura body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            if (env.paCore == null) {
                throw new CoreException("PaCore not initialized");
            }
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (body.getNome().indexOf(" ") != -1 || body.getValore().indexOf(" ") != -1) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non inserire spazi nei campi di testo");
            }
            if (pa.getProprietaList() != null && !pa.getProprietaList().isEmpty()) {
                for (Proprieta p : pa.getProprietaList()) {
                    if (!p.getNome().equals(body.getNome())) continue;
                    throw FaultCode.CONFLITTO.toException("Propriet\u00e0 " + body.getNome() + " gi\u00e0 assegnata alla configurazione");
                }
            }
            Proprieta p = new Proprieta();
            p.setNome(body.getNome());
            if (env.paCore != null && env.paCore.getDriverBYOKUtilities() != null && body.isEncrypted() != null && body.isEncrypted().booleanValue()) {
                p.setValore(env.paCore.getDriverBYOKUtilities().wrap(body.getValore()));
            } else {
                if (body.getValore().length() > 255) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il valore della propriet\u00e0 non deve superare i 255 caratteri");
                }
                p.setValore(body.getValore());
            }
            pa.addProprieta(p);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneControlloAccessiAutorizzazioneScope(ControlloAccessiAutorizzazioneScope body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (pa.getScope() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione per scope non \u00e8 abilitata");
            }
            FiltroRicercaScope filtroScope = new FiltroRicercaScope();
            filtroScope.setContesto(ScopeContesto.PORTA_APPLICATIVA);
            filtroScope.setTipologia("");
            List scopeAmmessi = env.stationCore.getAllScope(filtroScope);
            List scopePresenti = pa.getScope().getScopeList().stream().map(Scope::getNome).collect(Collectors.toList());
            if (!scopeAmmessi.contains(body.getScope())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Scope " + body.getScope() + " non presente fra gli scope ammissibili.");
            }
            if (scopePresenti.contains(body.getScope())) {
                throw FaultCode.CONFLITTO.toException("Scope " + body.getScope() + " gi\u00e0 assegnato al gruppo");
            }
            if (!env.paHelper.scopeCheckData(TipoOperazione.ADD, body.getScope(), scopePresenti)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            Scope scope = new Scope();
            scope.setNome(body.getScope());
            pa.getScope().addScope(scope);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneRateLimitingPolicy(RateLimitingPolicyErogazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo Servizio Parte Specifica");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            AttivazionePolicy policy = new AttivazionePolicy();
            policy.setFiltro(new AttivazionePolicyFiltro());
            policy.setGroupBy(new AttivazionePolicyRaggruppamento());
            RuoloPolicy ruoloPorta = RuoloPolicy.APPLICATIVA;
            String nomePorta = pa.getNome();
            String modalita = ErogazioniApiHelper.getDataElementModalita(body.getConfigurazione().getIdentificazione());
            String idPolicy = ErogazioniApiHelper.getIdPolicy(body, env.confCore, env.confHelper);
            if (idPolicy == null) {
                switch (body.getConfigurazione().getIdentificazione()) {
                    case POLICY: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Policy Utente non trovata");
                    }
                    case CRITERI: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Policy Built-In non trovata che rispettano i criteri forniti");
                    }
                }
            }
            policy.setIdPolicy(idPolicy);
            InfoPolicy infoPolicy = env.confCore.getInfoPolicy(policy.getIdPolicy());
            String serialId = env.confCore.getNextPolicyInstanceSerialId(infoPolicy.getIdPolicy());
            policy.setIdActivePolicy(ControlloTrafficoDriverUtils.buildIdActivePolicy((String)infoPolicy.getIdPolicy(), (String)serialId));
            ErogazioniApiHelper.override(infoPolicy.getTipoRisorsa(), body, env.protocolFactory.getProtocol(), env.idSoggetto.toIDSoggetto(), env.requestWrapper);
            String errorAttivazione = env.confHelper.readDatiAttivazionePolicyFromHttpParameters(policy, false, TipoOperazione.ADD, infoPolicy);
            if (!StringUtils.isEmpty((CharSequence)errorAttivazione)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)errorAttivazione));
            }
            policy.getFiltro().setEnabled(true);
            policy.getFiltro().setProtocollo(env.tipo_protocollo);
            policy.getFiltro().setRuoloPorta(ruoloPorta);
            policy.getFiltro().setNomePorta(nomePorta);
            StringBuilder existsMessage = new StringBuilder();
            if (ConfigurazioneUtilities.alreadyExists((TipoOperazione)TipoOperazione.ADD, (ConfigurazioneCore)env.confCore, (ConfigurazioneHelper)env.confHelper, (AttivazionePolicy)policy, (InfoPolicy)infoPolicy, (RuoloPolicy)ruoloPorta, (String)nomePorta, (ServiceBinding)env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), (StringBuilder)existsMessage, (String)"<br/>", (String)modalita)) {
                throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)existsMessage.toString()));
            }
            ErogazioniApiHelper.attivazionePolicyCheckData(TipoOperazione.ADD, pa, policy, infoPolicy, env, env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), modalita);
            ConfigurazioneUtilities.updatePosizioneAttivazionePolicy((ConfigurazioneCore)env.confCore, (InfoPolicy)infoPolicy, (AttivazionePolicy)policy, (RuoloPolicy)ruoloPorta, (String)nomePorta);
            env.confCore.performCreateOperation(env.userLogin, false, new Object[]{policy});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneTracciamentoCorrelazioneApplicativaRichiesta(CorrelazioneApplicativaRichiesta body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            Long idPorta = pa.getId();
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo Servizio Parte Specifica");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            StringBuilder existsMessage = new StringBuilder();
            if (ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRichiesta((PorteApplicativeCore)env.paCore, (long)idPorta, (String)body.getElemento(), (long)0L, (StringBuilder)existsMessage)) {
                throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)existsMessage.toString()));
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRichiestaCheckData(TipoOperazione.ADD, env.requestWrapper, (ConsoleHelper)env.paHelper, false, body, idPorta, null, serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            CorrelazioneApplicativa ca = pa.getCorrelazioneApplicativa();
            if (ca == null) {
                ca = new CorrelazioneApplicativa();
            }
            ca.addElemento(ErogazioniApiHelper.convert(body));
            pa.setCorrelazioneApplicativa(ca);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addErogazioneTracciamentoCorrelazioneApplicativaRisposta(org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            Long idPorta = pa.getId();
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo Servizio Parte Specifica");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            StringBuilder existsMessage = new StringBuilder();
            if (ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRisposta((PorteApplicativeCore)env.paCore, (long)idPorta, (String)body.getElemento(), (long)0L, (StringBuilder)existsMessage)) {
                throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)existsMessage.toString()));
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRispostaCheckData(TipoOperazione.ADD, env.requestWrapper, (ConsoleHelper)env.pdHelper, false, body, idPorta, null, serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            if (pa.getCorrelazioneApplicativaRisposta() == null) {
                pa.setCorrelazioneApplicativaRisposta(new CorrelazioneApplicativaRisposta());
            }
            pa.getCorrelazioneApplicativaRisposta().addElemento(ErogazioniApiHelper.convert(body));
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneControlloAccessiAutorizzazioneApplicativi(String nome, Integer versione, String applicativoAutorizzato, ProfiloEnum profilo, String soggetto, String soggettoApplicativo, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (pa.getServiziApplicativiAutorizzati() == null) {
                pa.setServiziApplicativiAutorizzati(new PortaApplicativaAutorizzazioneServiziApplicativi());
            }
            IdSoggetto idSoggettoProprietarioSA = (IdSoggetto)env.idSoggetto.clone();
            if (StringUtils.isNotEmpty((CharSequence)soggettoApplicativo)) {
                idSoggettoProprietarioSA.setNome(soggettoApplicativo);
            }
            PortaApplicativaAutorizzazioneServizioApplicativo to_remove = (PortaApplicativaAutorizzazioneServizioApplicativo)BaseHelper.findAndRemoveFirst((Iterable)pa.getServiziApplicativiAutorizzati().getServizioApplicativoList(), sa -> sa.getNome().equals(applicativoAutorizzato) && idSoggettoProprietarioSA.getNome().equals(sa.getNomeSoggettoProprietario()) && idSoggettoProprietarioSA.getTipo().equals(sa.getTipoSoggettoProprietario()));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Applicativo " + applicativoAutorizzato + " (soggetto: " + idSoggettoProprietarioSA.getNome() + ") \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneControlloAccessiAutorizzazioneSoggetti(String nome, Integer versione, String soggettoAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (pa.getSoggetti() == null) {
                pa.setSoggetti(new PortaApplicativaAutorizzazioneSoggetti());
            }
            PortaApplicativaAutorizzazioneSoggetto to_remove = (PortaApplicativaAutorizzazioneSoggetto)BaseHelper.findAndRemoveFirst((Iterable)pa.getSoggetti().getSoggettoList(), sogg -> sogg.getNome().equals(soggettoAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Soggetto " + soggettoAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneControlloAccessiAutorizzazioneApplicativiToken(String nome, Integer versione, String applicativoAutorizzato, ProfiloEnum profilo, String soggetto, String soggettoApplicativo, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            boolean isProfiloModi = env.isProfiloModi();
            if (isProfiloModi) {
                if (pa.getServiziApplicativiAutorizzati() == null) {
                    pa.setServiziApplicativiAutorizzati(new PortaApplicativaAutorizzazioneServiziApplicativi());
                }
            } else {
                if (pa.getAutorizzazioneToken() == null) {
                    pa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
                }
                if (pa.getAutorizzazioneToken().getServiziApplicativi() == null) {
                    pa.getAutorizzazioneToken().setServiziApplicativi(new PortaApplicativaAutorizzazioneServiziApplicativi());
                }
            }
            IdSoggetto idSoggettoProprietarioSA = (IdSoggetto)env.idSoggetto.clone();
            if (StringUtils.isNotEmpty((CharSequence)soggettoApplicativo)) {
                idSoggettoProprietarioSA.setNome(soggettoApplicativo);
            }
            List lSA = null;
            lSA = isProfiloModi ? pa.getServiziApplicativiAutorizzati().getServizioApplicativoList() : pa.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList();
            PortaApplicativaAutorizzazioneServizioApplicativo to_remove = (PortaApplicativaAutorizzazioneServizioApplicativo)BaseHelper.findAndRemoveFirst((Iterable)lSA, sa -> sa.getNome().equals(applicativoAutorizzato) && idSoggettoProprietarioSA.getNome().equals(sa.getNomeSoggettoProprietario()) && idSoggettoProprietarioSA.getTipo().equals(sa.getTipoSoggettoProprietario()));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Applicativo " + applicativoAutorizzato + " (soggetto: " + idSoggettoProprietarioSA.getNome() + ") \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneControlloAccessiAutorizzazioneRuoli(String nome, Integer versione, String ruoloAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (pa.getRuoli() == null) {
                pa.setRuoli(new AutorizzazioneRuoli());
            }
            Ruolo to_remove = (Ruolo)BaseHelper.findAndRemoveFirst((Iterable)pa.getRuoli().getRuoloList(), r -> r.getNome().equals(ruoloAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Ruolo " + ruoloAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneControlloAccessiAutorizzazioneRuoliToken(String nome, Integer versione, String ruoloAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (pa.getAutorizzazioneToken() == null) {
                pa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
            }
            if (pa.getAutorizzazioneToken().getRuoli() == null) {
                pa.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
            }
            Ruolo to_remove = (Ruolo)BaseHelper.findAndRemoveFirst((Iterable)pa.getAutorizzazioneToken().getRuoli().getRuoloList(), r -> r.getNome().equals(ruoloAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Ruolo " + ruoloAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneProprietaConfigurazione(String nome, Integer versione, String proprieta, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            Proprieta to_remove = null;
            if (pa.getProprietaList() != null && !pa.getProprietaList().isEmpty()) {
                to_remove = (Proprieta)BaseHelper.findAndRemoveFirst((Iterable)pa.getProprietaList(), p -> p.getNome().equals(proprieta));
            }
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna propriet\u00e0 \u00e8 presente nella configurazione con nome '" + proprieta + "'");
            }
            if (to_remove != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneControlloAccessiAutorizzazioneScope(String nome, Integer versione, String scopeAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (pa.getScope() == null) {
                pa.setScope(new AutorizzazioneScope());
            }
            Scope to_remove = (Scope)BaseHelper.findAndRemoveFirst((Iterable)pa.getScope().getScopeList(), s -> s.getNome().equals(scopeAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuno Scope " + scopeAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneRateLimitingPolicy(String nome, Integer versione, String idPolicy, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            List policies = env.confCore.attivazionePolicyList(null, RuoloPolicy.APPLICATIVA, pa.getNome());
            AttivazionePolicy policy = BaseHelper.findFirst((Iterable)policies, p -> PolicyUtilities.getNomeActivePolicy((String)p.getAlias(), (String)p.getIdActivePolicy()).equals(idPolicy)).orElse(null);
            if (policy != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                ArrayList policyRimosse = new ArrayList();
                ConfigurazioneUtilities.deleteAttivazionePolicy(new ArrayList<AttivazionePolicy>(Arrays.asList(policy)), (ConfigurazioneHelper)env.confHelper, (ConfigurazioneCore)env.confCore, (String)env.userLogin, (StringBuilder)inUsoMessage, (String)"<br/>", policyRimosse);
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting con id " + idPolicy);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneTracciamentoCorrelazioneApplicativaRichiesta(String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            CorrelazioneApplicativa correlazioneApplicativa = pa.getCorrelazioneApplicativa();
            String searchElemento = elemento.equals("*") ? "" : elemento;
            CorrelazioneApplicativaElemento to_del = (CorrelazioneApplicativaElemento)BaseHelper.evalnull(() -> (CorrelazioneApplicativaElemento)BaseHelper.findAndRemoveFirst((Iterable)correlazioneApplicativa.getElementoList(), e -> (e.getNome() == null ? "" : e.getNome()).equals(searchElemento)));
            if (to_del != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Correlazione applicativa per l'elemento " + elemento + " non trovata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneTracciamentoCorrelazioneApplicativaRisposta(String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            CorrelazioneApplicativaRisposta correlazioneApplicativa = pa.getCorrelazioneApplicativaRisposta();
            String searchElemento = elemento.equals("*") ? "" : elemento;
            CorrelazioneApplicativaRispostaElemento to_del = (CorrelazioneApplicativaRispostaElemento)BaseHelper.evalnull(() -> (CorrelazioneApplicativaRispostaElemento)BaseHelper.findAndRemoveFirst((Iterable)correlazioneApplicativa.getElementoList(), e -> (e.getNome() == null ? "" : e.getNome()).equals(searchElemento)));
            if (to_del != null) {
                env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Correlazione applicativa per l'elemento " + elemento + " non trovata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public byte[] downloadErogazioneControlloAccessiAutorizzazioneXacmlPolicy(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (pa.getXacmlPolicy() == null) {
                throw FaultCode.NOT_FOUND.toException("Xacml policy non assegnata al gruppo scelto");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return (byte[])BaseHelper.evalnull(() -> pa.getXacmlPolicy().getBytes());
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaRateLimitingPolicy findAllErogazioneRateLimitingPolicies(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio, String q, Integer limit, Integer offset, RateLimitingCriteriMetricaEnum metrica) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (metrica != null) {
                String risorsa = ErogazioniApiHelper.getDataElementModalitaRisorsa(metrica);
                ricerca.addFilter(idLista, "filtroTipoRisorsaPolicy", risorsa);
            }
            List policies = env.confCore.attivazionePolicyList(ricerca, RuoloPolicy.APPLICATIVA, pa.getNome());
            if (env.findall_404 && policies.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting associata");
            }
            ListaRateLimitingPolicy ret = (ListaRateLimitingPolicy)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaRateLimitingPolicy.class);
            policies.forEach(p -> {
                RateLimitingPolicyItem item = new RateLimitingPolicyItem();
                item.setNome(PolicyUtilities.getNomeActivePolicy((String)p.getAlias(), (String)p.getIdActivePolicy()));
                ret.addItemsItem(item);
            });
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaCorrelazioneApplicativaRichiesta findAllErogazioneTracciamentoCorrelazioneApplicativaRichiesta(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            int idLista = Liste.PORTE_APPLICATIVE_CORRELAZIONE_APPLICATIVA;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            List lista = env.paCore.porteApplicativeCorrelazioneApplicativaList((long)pa.getId().intValue(), (ISearch)ricerca);
            if (env.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna regola di correlazione applicativa associata");
            }
            ListaCorrelazioneApplicativaRichiesta ret = (ListaCorrelazioneApplicativaRichiesta)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaCorrelazioneApplicativaRichiesta.class);
            lista.forEach(c -> {
                CorrelazioneApplicativaRichiestaItem item = new CorrelazioneApplicativaRichiestaItem();
                item.setElemento(StringUtils.isEmpty((CharSequence)c.getNome()) ? "*" : c.getNome());
                item.setIdentificazioneTipo(CorrelazioneApplicativaRichiestaEnum.valueOf(c.getIdentificazione().name()));
                ret.addItemsItem(item);
            });
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaCorrelazioneApplicativaRisposta findAllErogazioneTracciamentoCorrelazioneApplicativaRisposta(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            int idLista = Liste.PORTE_APPLICATIVE_CORRELAZIONE_APPLICATIVA_RISPOSTA;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            List lista = env.paCore.porteApplicativeCorrelazioneApplicativaRispostaList((long)pa.getId().intValue(), (ISearch)ricerca);
            if (env.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna regola di correlazione applicativa della risposta associata");
            }
            ListaCorrelazioneApplicativaRisposta ret = (ListaCorrelazioneApplicativaRisposta)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaCorrelazioneApplicativaRisposta.class);
            lista.forEach(c -> {
                CorrelazioneApplicativaRispostaItem item = new CorrelazioneApplicativaRispostaItem();
                item.setElemento(StringUtils.isEmpty((CharSequence)c.getNome()) ? "*" : c.getNome());
                item.setIdentificazioneTipo(CorrelazioneApplicativaRispostaEnum.valueOf(c.getIdentificazione().name()));
                ret.addItemsItem(item);
            });
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public CachingRisposta getErogazioneCachingRisposta(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            CachingRisposta ret = ErogazioniApiHelper.buildCachingRisposta(pa.getResponseCaching());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiCanale getErogazioneCanale(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPADefault(idAsps, env.apsCore), (String)"Gruppo default per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ApiCanale canale = ErogazioniApiHelper.toApiCanale(env, pa, apc, true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return canale;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutenticazione getErogazioneControlloAccessiAutenticazione(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            OneOfControlloAccessiAutenticazioneAutenticazione autRet = null;
            TipoAutenticazioneEnum tipoAutenticazione = null;
            tipoAutenticazione = TipoAutenticazione.toEnumConstant((String)pa.getAutenticazione()) == null ? TipoAutenticazioneEnum.CUSTOM : Enums.dualizeMap(Enums.tipoAutenticazioneFromRest).get(TipoAutenticazione.toEnumConstant((String)pa.getAutenticazione()));
            ControlloAccessiAutenticazioneToken token = BaseHelper.evalnull(() -> pa.getGestioneToken().getAutenticazione()) != null ? ErogazioniApiHelper.fromGestioneTokenAutenticazione(pa.getGestioneToken().getAutenticazione()) : null;
            switch (tipoAutenticazione) {
                case HTTP_BASIC: {
                    APIImplAutenticazioneBasic authnBasic = new APIImplAutenticazioneBasic();
                    authnBasic.setTipo(tipoAutenticazione);
                    authnBasic.setOpzionale(Helper.statoFunzionalitaConfToBool(pa.getAutenticazioneOpzionale()));
                    autRet = authnBasic;
                    Optional<Proprieta> prop = pa.getProprietaAutenticazioneList().stream().filter(p -> "cleanAuthorizationHeader".equals(p.getNome())).findAny();
                    if (prop.isPresent() && prop.get().getValore().equals("true")) {
                        authnBasic.setForward(false);
                        break;
                    }
                    authnBasic.setForward(true);
                    break;
                }
                case HTTPS: {
                    APIImplAutenticazioneHttps authnHttps = new APIImplAutenticazioneHttps();
                    authnHttps.setTipo(tipoAutenticazione);
                    authnHttps.setOpzionale(Helper.statoFunzionalitaConfToBool(pa.getAutenticazioneOpzionale()));
                    autRet = authnHttps;
                    break;
                }
                case PRINCIPAL: {
                    Optional<Proprieta> prop;
                    APIImplAutenticazionePrincipal authnPrincipal = new APIImplAutenticazionePrincipal();
                    authnPrincipal.setTipo(tipoAutenticazione);
                    authnPrincipal.setOpzionale(Helper.statoFunzionalitaConfToBool(pa.getAutenticazioneOpzionale()));
                    autRet = authnPrincipal;
                    TipoAutenticazionePrincipal tipoAuthnPrincipal = pa.getProprietaAutenticazioneList().stream().filter(p -> "tipoAutenticazione".equals(p.getNome())).map(p -> TipoAutenticazionePrincipal.toEnumConstant((String)p.getValore())).findAny().orElse(TipoAutenticazionePrincipal.CONTAINER);
                    authnPrincipal.setTipoPrincipal(Enums.dualizeMap(Enums.tipoAutenticazionePrincipalFromRest).get(tipoAuthnPrincipal));
                    switch (authnPrincipal.getTipoPrincipal()) {
                        case CONTAINER: 
                        case IP_ADDRESS: 
                        case IP_ADDRESS_FORWARDED_FOR: {
                            break;
                        }
                        case HEADER_BASED: {
                            prop = pa.getProprietaAutenticazioneList().stream().filter(p -> "nome".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            authnPrincipal.setNome(prop.get().getValore());
                            break;
                        }
                        case FORM_BASED: {
                            prop = pa.getProprietaAutenticazioneList().stream().filter(p -> "nome".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            authnPrincipal.setNome(prop.get().getValore());
                            break;
                        }
                        case URL_BASED: {
                            prop = pa.getProprietaAutenticazioneList().stream().filter(p -> "pattern".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            authnPrincipal.setPattern(prop.get().getValore());
                            break;
                        }
                        case TOKEN: {
                            prop = pa.getProprietaAutenticazioneList().stream().filter(p -> "claim".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            if ("subject".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.SUBJECT);
                                break;
                            }
                            if ("clientId".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.CLIENTID);
                                break;
                            }
                            if ("username".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.USERNAME);
                                break;
                            }
                            if ("eMail".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.EMAIL);
                                break;
                            }
                            if (!"custom".equals(prop.get().getValore())) break;
                            authnPrincipal.setToken(TipoAutenticazionePrincipalToken.CUSTOM);
                            Optional<Proprieta> propName = pa.getProprietaAutenticazioneList().stream().filter(p -> "nome".equals(p.getNome())).findAny();
                            if (!propName.isPresent()) break;
                            authnPrincipal.setNome(propName.get().getValore());
                            break;
                        }
                    }
                    prop = pa.getProprietaAutenticazioneList().stream().filter(p -> "cleanPrincipal".equals(p.getNome())).findAny();
                    if (prop.isPresent() && "true".equals(prop.get().getValore())) {
                        authnPrincipal.setForward(false);
                        break;
                    }
                    authnPrincipal.setForward(true);
                    break;
                }
                case API_KEY: {
                    String valoreP;
                    String nomeP;
                    APIImplAutenticazioneApiKey authnApiKey = new APIImplAutenticazioneApiKey();
                    authnApiKey.setTipo(tipoAutenticazione);
                    authnApiKey.setOpzionale(Helper.statoFunzionalitaConfToBool(pa.getAutenticazioneOpzionale()));
                    autRet = authnApiKey;
                    if (pa.getProprietaAutenticazioneList() == null || pa.sizeProprietaAutenticazioneList() <= 0) break;
                    APIImplAutenticazioneApiKeyPosizione posizione = null;
                    APIImplAutenticazioneApiKeyConfig apiKeyNomi = null;
                    APIImplAutenticazioneApiKeyConfig appIdNomi = null;
                    boolean useOasNames = false;
                    for (Proprieta proprieta : pa.getProprietaAutenticazioneList()) {
                        boolean clean;
                        nomeP = proprieta.getNome();
                        valoreP = proprieta.getValore();
                        if ("appId".equals(nomeP)) {
                            authnApiKey.setAppId("true".equals(valoreP));
                            continue;
                        }
                        if ("queryParameter".equals(nomeP)) {
                            if (posizione == null) {
                                posizione = new APIImplAutenticazioneApiKeyPosizione();
                            }
                            posizione.setQueryParameter("true".equals(valoreP));
                            continue;
                        }
                        if ("header".equals(nomeP)) {
                            if (posizione == null) {
                                posizione = new APIImplAutenticazioneApiKeyPosizione();
                            }
                            posizione.setHeader("true".equals(valoreP));
                            continue;
                        }
                        if ("cookie".equals(nomeP)) {
                            if (posizione == null) {
                                posizione = new APIImplAutenticazioneApiKeyPosizione();
                            }
                            posizione.setCookie("true".equals(valoreP));
                            continue;
                        }
                        if ("useOAS3Names".equals(nomeP)) {
                            useOasNames = "true".equals(valoreP);
                            continue;
                        }
                        if ("cleanApiKey".equals(nomeP)) {
                            clean = "true".equals(valoreP);
                            authnApiKey.setApiKeyForward(!clean);
                            continue;
                        }
                        if (!"cleanAppId".equals(nomeP)) continue;
                        clean = "true".equals(valoreP);
                        authnApiKey.setAppIdForward(!clean);
                    }
                    if (!useOasNames) {
                        for (Proprieta proprieta : pa.getProprietaAutenticazioneList()) {
                            nomeP = proprieta.getNome();
                            valoreP = proprieta.getValore();
                            if ("queryParameterApiKey".equals(nomeP)) {
                                if (apiKeyNomi == null) {
                                    apiKeyNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                apiKeyNomi.setQueryParameter(valoreP);
                                continue;
                            }
                            if ("headerApiKey".equals(nomeP)) {
                                if (apiKeyNomi == null) {
                                    apiKeyNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                apiKeyNomi.setHeader(valoreP);
                                continue;
                            }
                            if ("cookieApiKey".equals(nomeP)) {
                                if (apiKeyNomi == null) {
                                    apiKeyNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                apiKeyNomi.setCookie(valoreP);
                                continue;
                            }
                            if ("queryParameterAppId".equals(nomeP)) {
                                if (appIdNomi == null) {
                                    appIdNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                appIdNomi.setQueryParameter(valoreP);
                                continue;
                            }
                            if ("headerAppId".equals(nomeP)) {
                                if (appIdNomi == null) {
                                    appIdNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                appIdNomi.setHeader(valoreP);
                                continue;
                            }
                            if (!"cookieAppId".equals(nomeP)) continue;
                            if (appIdNomi == null) {
                                appIdNomi = new APIImplAutenticazioneApiKeyConfig();
                            }
                            appIdNomi.setCookie(valoreP);
                        }
                    }
                    authnApiKey.setPosizione(posizione);
                    authnApiKey.setApiKeyNomi(apiKeyNomi);
                    authnApiKey.setAppIdNomi(appIdNomi);
                    break;
                }
                case CUSTOM: {
                    APIImplAutenticazioneCustom authnCustom = new APIImplAutenticazioneCustom();
                    authnCustom.setTipo(tipoAutenticazione);
                    authnCustom.setOpzionale(Helper.statoFunzionalitaConfToBool(pa.getAutenticazioneOpzionale()));
                    autRet = authnCustom;
                    authnCustom.setNome(pa.getAutenticazione());
                    break;
                }
            }
            ControlloAccessiAutenticazione ret = new ControlloAccessiAutenticazione();
            ret.setAutenticazione(autRet);
            ret.setToken(token);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneView getErogazioneControlloAccessiAutorizzazione(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiAutorizzazioneView ret = ErogazioniApiHelper.controlloAccessiAutorizzazioneFromPA(pa);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiErogazioneAutorizzazioneApplicativi getErogazioneControlloAccessiAutorizzazioneApplicativi(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiErogazioneAutorizzazioneApplicativi ret = new ControlloAccessiErogazioneAutorizzazioneApplicativi();
            int idLista = Liste.PORTE_APPLICATIVE_SERVIZIO_APPLICATIVO_AUTORIZZATO;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata("", -1, 0, idLista);
            List lista = env.paCore.porteAppServiziApplicativiAutorizzatiList(pa.getId().longValue(), (ISearch)ricerca);
            if (lista != null && !lista.isEmpty()) {
                for (PortaApplicativaAutorizzazioneServizioApplicativo portaApplicativaAutorizzazioneServizioApplicativo : lista) {
                    ControlloAccessiErogazioneAutorizzazioneApplicativo applicativiItem = new ControlloAccessiErogazioneAutorizzazioneApplicativo();
                    applicativiItem.setApplicativo(portaApplicativaAutorizzazioneServizioApplicativo.getNome());
                    applicativiItem.setSoggetto(portaApplicativaAutorizzazioneServizioApplicativo.getNomeSoggettoProprietario());
                    ret.addApplicativiItem(applicativiItem);
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneSoggetti getErogazioneControlloAccessiAutorizzazioneSoggetti(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiAutorizzazioneSoggetti ret = new ControlloAccessiAutorizzazioneSoggetti();
            List soggetti = (List)BaseHelper.evalnull(() -> pa.getSoggetti().getSoggettoList().stream().map(s -> s.getNome()).collect(Collectors.toList()));
            ret.setSoggetti(soggetti);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiErogazioneAutorizzazioneApplicativi getErogazioneControlloAccessiAutorizzazioneApplicativiToken(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            List lista;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiErogazioneAutorizzazioneApplicativi ret = new ControlloAccessiErogazioneAutorizzazioneApplicativi();
            boolean isProfiloModi = env.isProfiloModi();
            int idLista = isProfiloModi ? Liste.PORTE_APPLICATIVE_SERVIZIO_APPLICATIVO_AUTORIZZATO : Liste.PORTE_APPLICATIVE_TOKEN_SERVIZIO_APPLICATIVO;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata("", -1, 0, idLista);
            List list = lista = isProfiloModi ? env.paCore.porteAppServiziApplicativiAutorizzatiList(pa.getId().longValue(), (ISearch)ricerca) : env.paCore.porteAppServiziApplicativiAutorizzatiTokenList(pa.getId().longValue(), (ISearch)ricerca);
            if (lista != null && !lista.isEmpty()) {
                for (PortaApplicativaAutorizzazioneServizioApplicativo portaApplicativaAutorizzazioneServizioApplicativo : lista) {
                    ControlloAccessiErogazioneAutorizzazioneApplicativo applicativiItem = new ControlloAccessiErogazioneAutorizzazioneApplicativo();
                    applicativiItem.setApplicativo(portaApplicativaAutorizzazioneServizioApplicativo.getNome());
                    applicativiItem.setSoggetto(portaApplicativaAutorizzazioneServizioApplicativo.getNomeSoggettoProprietario());
                    ret.addApplicativiItem(applicativiItem);
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneRuoli getErogazioneControlloAccessiAutorizzazioneRuoli(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiAutorizzazioneRuoli ret = new ControlloAccessiAutorizzazioneRuoli();
            if (pa.getRuoli() != null && pa.getRuoli().sizeRuoloList() > 0) {
                ret.setRuoli((List)BaseHelper.evalnull(() -> pa.getRuoli().getRuoloList().stream().map(Ruolo::getNome).collect(Collectors.toList())));
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneRuoli getErogazioneControlloAccessiAutorizzazioneRuoliToken(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiAutorizzazioneRuoli ret = new ControlloAccessiAutorizzazioneRuoli();
            if (pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getRuoli() != null && pa.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                ret.setRuoli((List)BaseHelper.evalnull(() -> pa.getAutorizzazioneToken().getRuoli().getRuoloList().stream().map(Ruolo::getNome).collect(Collectors.toList())));
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneScopes getErogazioneControlloAccessiAutorizzazioneScope(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiAutorizzazioneScopes ret = new ControlloAccessiAutorizzazioneScopes();
            ret.setScope((List)BaseHelper.evalnull(() -> pa.getScope().getScopeList().stream().map(Scope::getNome).collect(Collectors.toList())));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiGestioneToken getErogazioneControlloAccessiGestioneToken(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiGestioneToken ret = new ControlloAccessiGestioneToken();
            GestioneToken paToken = pa.getGestioneToken();
            ret.setAbilitato(paToken != null);
            if (paToken != null) {
                ret.setIntrospection(StatoFunzionalitaConWarningEnum.fromValue(paToken.getIntrospection().getValue()));
                ret.setPolicy(paToken.getPolicy());
                ret.setTokenForward(Helper.statoFunzionalitaConfToBool(paToken.getForward()));
                ret.setTokenOpzionale(Helper.statoFunzionalitaConfToBool(paToken.getTokenOpzionale()));
                ret.setUserInfo(StatoFunzionalitaConWarningEnum.fromValue(paToken.getUserInfo().getValue()));
                ret.setValidazioneJwt(StatoFunzionalitaConWarningEnum.fromValue(paToken.getValidazione().getValue()));
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiIdentificazioneAttributi getErogazioneControlloAccessiIdentificazioneAttributi(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ControlloAccessiIdentificazioneAttributi ret = new ControlloAccessiIdentificazioneAttributi();
            if (pa.sizeAttributeAuthorityList() > 0) {
                ret.setAbilitato(true);
                ret.setAttributeAuthority(new ArrayList<ControlloAccessiAttributeAuthority>());
                for (AttributeAuthority aa : pa.getAttributeAuthorityList()) {
                    ControlloAccessiAttributeAuthority attributeAuthorityItem = new ControlloAccessiAttributeAuthority();
                    attributeAuthorityItem.setNome(aa.getNome());
                    if (aa.sizeAttributoList() > 0) {
                        attributeAuthorityItem.setAttributi(new ArrayList<String>());
                        for (String attributeName : aa.getAttributoList()) {
                            attributeAuthorityItem.addAttributiItem(attributeName);
                        }
                    }
                    ret.addAttributeAuthorityItem(attributeAuthorityItem);
                }
            } else {
                ret.setAbilitato(false);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ElencoProprieta getErogazioneElencoProprieta(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPADefault(idAsps, env.apsCore), (String)"Gruppo default per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            ElencoProprieta ret = new ElencoProprieta();
            ret.setProprieta(new ArrayList<ProprietaOpzioneCifratura>());
            if (pa.getProprietaList() != null && !pa.getProprietaList().isEmpty()) {
                for (Proprieta p : pa.getProprietaList()) {
                    ProprietaOpzioneCifratura retP = new ProprietaOpzioneCifratura();
                    retP.setNome(p.getNome());
                    retP.setValore(p.getValore());
                    retP.setEncrypted(BYOKUtilities.isWrappedValue((String)p.getValore()));
                    ret.addProprietaItem(retP);
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ProprietaOpzioneCifratura getErogazioneProprieta(String nome, Integer versione, String proprieta, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            Optional op;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPADefault(idAsps, env.apsCore), (String)"Gruppo default per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            Proprieta toGet = null;
            if (pa.getProprietaList() != null && !pa.getProprietaList().isEmpty() && (op = BaseHelper.findFirst((Iterable)pa.getProprietaList(), p -> p.getNome().equals(proprieta))).isPresent()) {
                toGet = (Proprieta)op.get();
            }
            ProprietaOpzioneCifratura ret = null;
            if (toGet == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna propriet\u00e0 \u00e8 presente nella configurazione con nome '" + proprieta + "'");
            }
            ret = new ProprietaOpzioneCifratura();
            ret.setNome(toGet.getNome());
            ret.setValore(toGet.getValore());
            ret.setEncrypted(BYOKUtilities.isWrappedValue((String)toGet.getValore()));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public GestioneCors getErogazioneGestioneCORS(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPADefault(idAsps, env.apsCore), (String)"Gruppo default per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            CorsConfigurazione paConf = pa.getGestioneCors();
            GestioneCors ret = ErogazioniApiHelper.convert(paConf);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RateLimitingPolicyErogazioneView getErogazioneRateLimitingPolicy(String nome, Integer versione, String idPolicy, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            AttivazionePolicy policy = (AttivazionePolicy)BaseHelper.supplyOrNotFound(() -> env.confCore.getAttivazionePolicy(idPolicy, RuoloPolicy.APPLICATIVA, pa.getNome()), (String)("Rate Limiting Policy con nome " + idPolicy));
            if (policy == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting con nome " + idPolicy);
            }
            InfoPolicy infoPolicy = env.confCore.getInfoPolicy(policy.getIdPolicy());
            RateLimitingPolicyErogazioneView ret = ErogazioniApiHelper.convert(policy, infoPolicy, new RateLimitingPolicyErogazioneView());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RegistrazioneDiagnosticiConfigurazione getErogazioneRegistrazioneDiagnostici(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            RegistrazioneDiagnosticiConfigurazione ret = ErogazioniApiHelper.fromDiagnosticiConfigurazione(pa.getTracciamento());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RegistrazioneMessaggi getErogazioneRegistrazioneMessaggi(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            RegistrazioneMessaggi ret = ErogazioniApiHelper.fromDumpConfigurazione(pa.getDump());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RegistrazioneTransazioniConfigurazione getErogazioneRegistrazioneTransazioni(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            RegistrazioneTransazioniConfigurazione ret = ErogazioniApiHelper.fromTransazioniConfigurazione(pa.getTracciamento(), env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplStato getErogazioneStato(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ApiImplStato ret = new ApiImplStato();
            ret.setAbilitato(Helper.statoFunzionalitaConfToBool(pa.getStato()));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public CorrelazioneApplicativaRichiesta getErogazioneTracciamentoCorrelazioneApplicativaRichiesta(String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            String searchElemento = elemento.equals("*") ? "" : elemento;
            List lista = (List)BaseHelper.evalnull(() -> pa.getCorrelazioneApplicativa().getElementoList());
            Optional el = BaseHelper.findFirst((Iterable)lista, c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento));
            if (!el.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("CorrelazioneApplicativaRichiesta per l'elemento " + elemento + " non presente");
            }
            CorrelazioneApplicativaRichiesta ret = ErogazioniApiHelper.convert((CorrelazioneApplicativaElemento)el.get());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta getErogazioneTracciamentoCorrelazioneApplicativaRisposta(String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            String searchElemento = elemento.equals("*") ? "" : elemento;
            List lista = (List)BaseHelper.evalnull(() -> pa.getCorrelazioneApplicativaRisposta().getElementoList());
            Optional el = BaseHelper.findFirst((Iterable)lista, c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento));
            if (!el.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("CorrelazioneApplicativaRisposta per l'elemento " + elemento + " non presente");
            }
            org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta ret = ErogazioniApiHelper.convert((CorrelazioneApplicativaRispostaElemento)el.get());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public Validazione getErogazioneValidazione(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            Validazione ret = ErogazioniApiHelper.fromValidazioneContenutiApplicativi(pa.getValidazioneContenutiApplicativi());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneCachingRisposta(CachingRisposta body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.isMaxResponseSize().booleanValue() && body.getMaxResponseSizeKb() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Devi specificare il campo MaxResponseSizeKb");
            }
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (!env.paHelper.checkDataConfigurazioneResponseCachingPorta(TipoOperazione.OTHER, true, body.getStato().toString())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ResponseCachingConfigurazione newConfigurazione = ErogazioniApiHelper.buildResponseCachingConfigurazione(body, env.paHelper);
            pa.setResponseCaching(newConfigurazione);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneCanale(ConfigurazioneApiCanale body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPADefault(idAsps, env.apsCore), (String)"Gruppo default per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            if (ConfigurazioneCanaleEnum.RIDEFINITO.equals((Object)body.getConfigurazione())) {
                if (body.getCanale() == null || "".equals(body.getCanale())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un canale");
                }
                if (!env.canali.contains(body.getCanale())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il canale fornito '" + body.getCanale() + "' non \u00e8 presente nel registro");
                }
                pa.setCanale(body.getCanale());
            } else {
                pa.setCanale(null);
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneControlloAccessiAutenticazione(ControlloAccessiAutenticazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa newPa = env.paCore.getPortaApplicativa(env.idPa);
            PortaApplicativa oldPa = env.paCore.getPortaApplicativa(env.idPa);
            ErogazioniApiHelper.fillPortaApplicativa(env, body, newPa);
            if (!ErogazioniApiHelper.controlloAccessiCheckPA(env, oldPa, newPa)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{newPa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneControlloAccessiAutorizzazione(ControlloAccessiAutorizzazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            PortaApplicativa newPa = env.paCore.getPortaApplicativa(env.idPa);
            ErogazioniApiHelper.fillPortaApplicativa(body, newPa);
            if (!ErogazioniApiHelper.controlloAccessiCheckPA(env, pa, newPa)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{newPa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneControlloAccessiGestioneToken(ControlloAccessiGestioneToken body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa oldPa = env.paCore.getPortaApplicativa(env.idPa);
            PortaApplicativa newPa = env.paCore.getPortaApplicativa(env.idPa);
            if (body.isAbilitato().booleanValue()) {
                GestioneToken gTok = newPa.getGestioneToken() != null ? newPa.getGestioneToken() : new GestioneToken();
                ErogazioniApiHelper.fillGestioneToken(gTok, body);
                newPa.setGestioneToken(gTok);
            } else {
                newPa.setGestioneToken(null);
            }
            if (!ErogazioniApiHelper.controlloAccessiCheckPA(env, oldPa, newPa)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{newPa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneProprieta(ProprietaOpzioneCifratura body, String nome, Integer versione, String proprieta, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            if (env.paCore == null) {
                throw new CoreException("PaCore not initialized");
            }
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (body.getNome().indexOf(" ") != -1 || body.getValore().indexOf(" ") != -1) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non inserire spazi nei campi di testo");
            }
            if (!proprieta.equals(body.getNome()) && pa.getProprietaList() != null && !pa.getProprietaList().isEmpty()) {
                for (Proprieta p : pa.getProprietaList()) {
                    if (!p.getNome().equals(body.getNome())) continue;
                    throw FaultCode.CONFLITTO.toException("Propriet\u00e0 " + body.getNome() + " gi\u00e0 assegnata alla configurazione");
                }
            }
            boolean found = false;
            if (pa.getProprietaList() != null && !pa.getProprietaList().isEmpty()) {
                for (Proprieta p : pa.getProprietaList()) {
                    if (!p.getNome().equals(proprieta)) continue;
                    p.setNome(body.getNome());
                    if (env.paCore != null && env.paCore.getDriverBYOKUtilities() != null && body.isEncrypted() != null && body.isEncrypted().booleanValue()) {
                        p.setValore(env.paCore.getDriverBYOKUtilities().wrap(body.getValore()));
                    } else {
                        if (body.getValore().length() > 255) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il valore della propriet\u00e0 non deve superare i 255 caratteri");
                        }
                        p.setValore(body.getValore());
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw FaultCode.NOT_FOUND.toException("Propriet\u00e0 " + body.getNome() + " non presente nella configurazione");
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneControlloIdentificazioneAttributi(ControlloAccessiIdentificazioneAttributi body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa oldPa = env.paCore.getPortaApplicativa(env.idPa);
            PortaApplicativa newPa = env.paCore.getPortaApplicativa(env.idPa);
            if (body.isAbilitato().booleanValue() && body.getAttributeAuthority() != null && !body.getAttributeAuthority().isEmpty()) {
                if (newPa.getAttributeAuthorityList() == null) {
                    newPa.setAttributeAuthorityList(new ArrayList());
                } else {
                    newPa.getAttributeAuthorityList().clear();
                }
                for (ControlloAccessiAttributeAuthority controlloAccessiAttributeAuthority : body.getAttributeAuthority()) {
                    GenericProperties gp = null;
                    try {
                        gp = env.confCore.getGenericProperties(controlloAccessiAttributeAuthority.getNome(), "attributeAuthority", false);
                    }
                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                        // empty catch block
                    }
                    if (gp == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("AttributeAuthority '" + controlloAccessiAttributeAuthority.getNome() + "' non esistente");
                    }
                    AttributeAuthority aa = new AttributeAuthority();
                    aa.setNome(controlloAccessiAttributeAuthority.getNome());
                    if (controlloAccessiAttributeAuthority.getAttributi() != null && !controlloAccessiAttributeAuthority.getAttributi().isEmpty()) {
                        aa.setAttributoList(controlloAccessiAttributeAuthority.getAttributi());
                    }
                    newPa.addAttributeAuthority(aa);
                }
            } else if (newPa.getAttributeAuthorityList() != null) {
                newPa.getAttributeAuthorityList().clear();
            } else {
                newPa.setAttributeAuthorityList(new ArrayList());
            }
            if (!ErogazioniApiHelper.controlloAccessiCheckPA(env, oldPa, newPa)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{newPa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneGestioneCORS(GestioneCors body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPADefault(idAsps, env.apsCore), (String)"Gruppo default per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            CorsConfigurazione oldConf = pa.getGestioneCors();
            if (body.isRidefinito().booleanValue()) {
                pa.setGestioneCors(ErogazioniApiHelper.buildCorsConfigurazione(body, env, oldConf));
            } else {
                pa.setGestioneCors(null);
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneRateLimitingPolicy(RateLimitingPolicyErogazioneUpdate body, String nome, Integer versione, String idPolicy, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo Servizio Parte Specifica");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            AttivazionePolicy policy = (AttivazionePolicy)BaseHelper.supplyOrNotFound(() -> env.confCore.getAttivazionePolicy(idPolicy, RuoloPolicy.APPLICATIVA, pa.getNome()), (String)("Rate Limiting Policy con nome " + idPolicy));
            if (policy == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting con nome " + idPolicy);
            }
            InfoPolicy infoPolicy = env.confCore.getInfoPolicy(policy.getIdPolicy());
            ErogazioniApiHelper.override(infoPolicy.getTipoRisorsa(), body, env.protocolFactory.getProtocol(), env.idSoggetto.toIDSoggetto(), env.requestWrapper);
            String errorAttivazione = env.confHelper.readDatiAttivazionePolicyFromHttpParameters(policy, false, TipoOperazione.CHANGE, infoPolicy);
            if (!StringUtils.isEmpty((CharSequence)errorAttivazione)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)errorAttivazione));
            }
            String modalita = ErogazioniApiHelper.getDataElementModalita(infoPolicy.isBuiltIn());
            ErogazioniApiHelper.attivazionePolicyCheckData(TipoOperazione.CHANGE, pa, policy, infoPolicy, env, env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), modalita);
            env.confCore.performUpdateOperation(env.userLogin, false, new Object[]{policy});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneRegistrazioneDiagnostici(RegistrazioneDiagnosticiConfigurazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ErogazioniApiHelper.updateTracciamento(body, pa, (ErogazioniEnv)env);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneRegistrazioneMessaggi(RegistrazioneMessaggi body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            if (body.isRidefinito().booleanValue()) {
                pa.setDump(ErogazioniApiHelper.buildDumpConfigurazione(body, true, env));
            } else {
                pa.setDump(null);
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneRegistrazioneTransazioni(RegistrazioneTransazioniConfigurazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            ErogazioniApiHelper.updateTracciamento(body, (Object)pa, (ErogazioniEnv)env);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneStato(ApiImplStato body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            IDPortaApplicativa oldIDPortaApplicativaForUpdate = new IDPortaApplicativa();
            oldIDPortaApplicativaForUpdate.setNome(pa.getNome());
            pa.setOldIDPortaApplicativaForUpdate(oldIDPortaApplicativaForUpdate);
            pa.setStato(Helper.boolToStatoFunzionalitaConf(body.isAbilitato()));
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneTracciamentoCorrelazioneApplicativaRichiesta(CorrelazioneApplicativaRichiesta body, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            List correlazioni;
            CorrelazioneApplicativaElemento oldElem;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            String searchElemento = elemento.equals("*") ? "" : elemento;
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            Long idPorta = pa.getId();
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo Servizio Parte Specifica");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            if (pa.getCorrelazioneApplicativa() == null) {
                pa.setCorrelazioneApplicativa(new CorrelazioneApplicativa());
            }
            if ((oldElem = (CorrelazioneApplicativaElemento)BaseHelper.findAndRemoveFirst((Iterable)(correlazioni = pa.getCorrelazioneApplicativa().getElementoList()), c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento))) == null) {
                throw FaultCode.NOT_FOUND.toException("Correlazione Applicativa Richiesta per l'elemento " + elemento + " non trovata ");
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRichiestaCheckData(TipoOperazione.CHANGE, env.requestWrapper, (ConsoleHelper)env.pdHelper, false, body, idPorta, oldElem.getId(), serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            correlazioni.add(ErogazioniApiHelper.convert(body));
            pa.getCorrelazioneApplicativa().setElementoList(correlazioni);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneTracciamentoCorrelazioneApplicativaRisposta(org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta body, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            List correlazioni;
            CorrelazioneApplicativaRispostaElemento oldElem;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            String searchElemento = elemento.equals("*") ? "" : elemento;
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            Long idPorta = pa.getId();
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo Servizio Parte Specifica");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            if (pa.getCorrelazioneApplicativaRisposta() == null) {
                pa.setCorrelazioneApplicativaRisposta(new CorrelazioneApplicativaRisposta());
            }
            if ((oldElem = (CorrelazioneApplicativaRispostaElemento)BaseHelper.findAndRemoveFirst((Iterable)(correlazioni = pa.getCorrelazioneApplicativaRisposta().getElementoList()), c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento))) == null) {
                throw FaultCode.NOT_FOUND.toException("Correlazione Applicativa Risposta per l'elemento " + elemento + " non trovata ");
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRispostaCheckData(TipoOperazione.CHANGE, env.requestWrapper, (ConsoleHelper)env.pdHelper, false, body, idPorta, oldElem.getId(), serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            correlazioni.add(ErogazioniApiHelper.convert(body));
            pa.getCorrelazioneApplicativaRisposta().setElementoList(correlazioni);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneValidazione(Validazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniConfEnv env = new ErogazioniConfEnv(context.getServletRequest(), profilo, soggetto, context, nome, versione, gruppo, tipoServizio);
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.idPa);
            String stato = (String)BaseHelper.evalnull(() -> body.getStato().toString());
            String tipoValidazione = (String)BaseHelper.evalnull(() -> body.getTipo().toString());
            env.requestWrapper.overrideParameter("xsd", stato);
            if (!env.paHelper.validazioneContenutiCheck(TipoOperazione.OTHER, false)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ValidazioneContenutiApplicativi vx = new ValidazioneContenutiApplicativi();
            vx.setAcceptMtomMessage((StatoFunzionalita)BaseHelper.evalnull(() -> pa.getValidazioneContenutiApplicativi().getAcceptMtomMessage()));
            vx.setStato(StatoFunzionalitaConWarning.toEnumConstant((String)stato));
            vx.setTipo(ValidazioneContenutiApplicativiTipo.toEnumConstant((String)tipoValidazione));
            pa.setValidazioneContenutiApplicativi(vx);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

