/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.ruoli;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.rs.server.api.RuoliApi;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.ruoli.RuoliApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.ruoli.RuoliEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.ContestoEnum;
import org.openspcoop2.core.config.rs.server.model.FonteEnum;
import org.openspcoop2.core.config.rs.server.model.ListaRuoli;
import org.openspcoop2.core.config.rs.server.model.Ruolo;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliHelper;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliUtilities;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class RuoliApiServiceImpl
extends BaseImpl
implements RuoliApi {
    public RuoliApiServiceImpl() {
        super(LoggerFactory.getLogger(RuoliApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void createRuolo(Ruolo body) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            Ruolo ruolo = body;
            RuoliEnv env = new RuoliEnv(context.getServletRequest(), context);
            RuoliApiHelper.overrideRuoloParams(ruolo, env.requestWrapper);
            org.openspcoop2.core.registry.Ruolo regRuolo = null;
            try {
                regRuolo = RuoliApiHelper.apiRuoloToRuoloRegistro(ruolo, env.userLogin);
            }
            catch (Exception e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(e.getMessage());
            }
            if (env.ruoliCore.existsRuolo(ruolo.getNome())) {
                throw FaultCode.CONFLITTO.toException("Un ruolo con nome '" + ruolo.getNome() + "' risulta gi\u00e0 stato registrato");
            }
            if (!env.ruoliHelper.ruoloCheckData(TipoOperazione.ADD, null)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            env.ruoliCore.performCreateOperation(env.userLogin, false, new Object[]{regRuolo});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteRuolo(String nome) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            String userLogin = context.getAuthentication().getName();
            RuoliEnv rEnv = new RuoliEnv(context.getServletRequest(), context);
            org.openspcoop2.core.registry.Ruolo regRuolo = (org.openspcoop2.core.registry.Ruolo)BaseHelper.evalnull(() -> rEnv.ruoliCore.getRuolo(nome));
            if (regRuolo != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                RuoliUtilities.deleteRuolo((org.openspcoop2.core.registry.Ruolo)regRuolo, (String)userLogin, (RuoliCore)rEnv.ruoliCore, (RuoliHelper)rEnv.ruoliHelper, (StringBuilder)inUsoMessage, (String)System.lineSeparator());
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)inUsoMessage.toString()));
                }
            }
            if (rEnv.delete_404 && regRuolo == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun ruolo corrisponde al nome indicato");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaRuoli findAllRuoli(String q, Integer limit, Integer offset, FonteEnum fonte, ContestoEnum contesto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            RuoliEnv rEnv = new RuoliEnv(context.getServletRequest(), context);
            int idLista = Liste.RUOLI;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista);
            if (fonte != null) {
                ricerca.addFilter(idLista, "filtroRuoloTipologia", Enums.apiFonteToRegistroTipologia(fonte).toString());
            }
            if (contesto != null) {
                ricerca.addFilter(idLista, "filtroRuoloContesto", Enums.apiContestoToRegistroContesto(contesto).toString());
            }
            List lista = new ArrayList();
            try {
                lista = rEnv.ruoliCore.ruoliList(null, (ISearch)ricerca);
            }
            catch (Exception e) {
                throw FaultCode.NOT_FOUND.toException(e.getMessage());
            }
            if (rEnv.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessun ruolo corrisponde ai criteri di ricerca specificati");
            }
            ListaRuoli ret = (ListaRuoli)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaRuoli.class);
            lista.forEach(regRuolo -> ret.addItemsItem(RuoliApiHelper.ruoloApiToRuoloItem(RuoliApiHelper.ruoloRegistroToApiRuolo(regRuolo))));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public Ruolo getRuolo(String nome) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            RuoliEnv rEnv = new RuoliEnv(context.getServletRequest(), context);
            org.openspcoop2.core.registry.Ruolo regRuolo = null;
            try {
                regRuolo = rEnv.ruoliCore.getRuolo(nome);
            }
            catch (DriverConfigurazioneException driverConfigurazioneException) {
                // empty catch block
            }
            if (regRuolo == null) {
                throw FaultCode.NOT_FOUND.toException("Non esiste nessun ruolo con nome " + nome);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return RuoliApiHelper.ruoloRegistroToApiRuolo(regRuolo);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateRuolo(Ruolo body, String nome) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            RuoliEnv rEnv = new RuoliEnv(context.getServletRequest(), context);
            RuoliApiHelper.overrideRuoloParams(body, rEnv.requestWrapper);
            org.openspcoop2.core.registry.Ruolo oldRuolo = null;
            try {
                oldRuolo = rEnv.ruoliCore.getRuolo(nome);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oldRuolo == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun ruolo da aggiornare corrisponde al nome: " + nome);
            }
            org.openspcoop2.core.registry.Ruolo ruoloNEW = RuoliApiHelper.apiRuoloToRuoloRegistro(body, rEnv.userLogin);
            ruoloNEW.setOldIDRuoloForUpdate(new IDRuolo(oldRuolo.getNome()));
            if (!rEnv.ruoliHelper.ruoloCheckData(TipoOperazione.CHANGE, oldRuolo)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)rEnv.pd.getMessage()));
            }
            ArrayList<org.openspcoop2.core.registry.Ruolo> listOggettiDaAggiornare = new ArrayList<org.openspcoop2.core.registry.Ruolo>();
            listOggettiDaAggiornare.add(ruoloNEW);
            if (!oldRuolo.getNome().equals(ruoloNEW.getNome())) {
                IDRuolo oldIdRuolo = ruoloNEW.getOldIDRuoloForUpdate();
                oldIdRuolo.setNome(nome);
                RuoliUtilities.findOggettiDaAggiornare((IDRuolo)oldIdRuolo, (org.openspcoop2.core.registry.Ruolo)ruoloNEW, (RuoliCore)rEnv.ruoliCore, listOggettiDaAggiornare);
            }
            rEnv.ruoliCore.performUpdateOperation(rEnv.userLogin, false, listOggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

