/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.openspcoop2.core.config.rs.server.model.BaseCredenziali;
import org.openspcoop2.core.config.rs.server.model.ModIApplicativoEsterno;
import org.openspcoop2.core.config.rs.server.model.ModIApplicativoInterno;
import org.openspcoop2.core.config.rs.server.model.OneOfApplicativoModi;
import org.openspcoop2.core.config.rs.server.model.Proprieta4000OpzioneCifratura;

public class Applicativo
extends BaseCredenziali {
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="")
    private String nome = null;
    @Schema(example="descrizione dell'applicativo", description="")
    private String descrizione = null;
    @Schema(example="[\"ruolo1\",\"ruolo2\"]", description="")
    private List<String> ruoli = null;
    @Schema(description="")
    private List<Proprieta4000OpzioneCifratura> proprieta = null;
    @Schema(description="")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="dominio", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ModIApplicativoInterno.class, name="interno"), @JsonSubTypes.Type(value=ModIApplicativoEsterno.class, name="esterno")})
    private OneOfApplicativoModi modi = null;

    @JsonProperty(value="nome")
    @NotNull
    @Valid
    @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$")
    @Size(max=255)
    public @NotNull @Valid @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Applicativo nome(String nome) {
        this.nome = nome;
        return this;
    }

    @JsonProperty(value="descrizione")
    @Valid
    @Size(max=4000)
    public @Valid @Size(max=4000) String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public Applicativo descrizione(String descrizione) {
        this.descrizione = descrizione;
        return this;
    }

    @JsonProperty(value="ruoli")
    @Valid
    public List<String> getRuoli() {
        return this.ruoli;
    }

    public void setRuoli(List<String> ruoli) {
        this.ruoli = ruoli;
    }

    public Applicativo ruoli(List<String> ruoli) {
        this.ruoli = ruoli;
        return this;
    }

    public Applicativo addRuoliItem(String ruoliItem) {
        this.ruoli.add(ruoliItem);
        return this;
    }

    @JsonProperty(value="proprieta")
    @Valid
    public List<Proprieta4000OpzioneCifratura> getProprieta() {
        return this.proprieta;
    }

    public void setProprieta(List<Proprieta4000OpzioneCifratura> proprieta) {
        this.proprieta = proprieta;
    }

    public Applicativo proprieta(List<Proprieta4000OpzioneCifratura> proprieta) {
        this.proprieta = proprieta;
        return this;
    }

    public Applicativo addProprietaItem(Proprieta4000OpzioneCifratura proprietaItem) {
        this.proprieta.add(proprietaItem);
        return this;
    }

    @JsonProperty(value="modi")
    @Valid
    public OneOfApplicativoModi getModi() {
        return this.modi;
    }

    public void setModi(OneOfApplicativoModi modi) {
        this.modi = modi;
    }

    public Applicativo modi(OneOfApplicativoModi modi) {
        this.modi = modi;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Applicativo {\n");
        sb.append("    ").append(Applicativo.toIndentedString(super.toString())).append("\n");
        sb.append("    nome: ").append(Applicativo.toIndentedString(this.nome)).append("\n");
        sb.append("    descrizione: ").append(Applicativo.toIndentedString(this.descrizione)).append("\n");
        sb.append("    ruoli: ").append(Applicativo.toIndentedString(this.ruoli)).append("\n");
        sb.append("    proprieta: ").append(Applicativo.toIndentedString(this.proprieta)).append("\n");
        sb.append("    modi: ").append(Applicativo.toIndentedString(this.modi)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

