/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.builder;

import backend.ecodex.org._1_1.LargePayloadType;
import backend.ecodex.org._1_1.SubmitRequest;
import backend.ecodex.org._1_1.utils.serializer.JaxbSerializer;
import eu.domibus.configuration.Attachment;
import eu.domibus.configuration.Payload;
import eu.domibus.configuration.PayloadProfile;
import eu.domibus.configuration.PayloadProfiles;
import eu.domibus.configuration.Properties;
import eu.domibus.configuration.PropertyRef;
import eu.domibus.configuration.PropertySet;
import eu.domibus.configuration.PropertyValueHeader;
import eu.domibus.configuration.PropertyValueUrl;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.CollaborationInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.From;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.MessageProperties;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Messaging;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartProperties;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyId;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PayloadInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Service;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.To;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2RestMimeMultipartMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.rest.BinaryContent;
import org.openspcoop2.message.rest.MultipartContent;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.protocol.as4.AS4RawContent;
import org.openspcoop2.protocol.as4.builder.AS4BuilderUtils;
import org.openspcoop2.protocol.as4.pmode.TranslatorPayloadProfilesDefault;
import org.openspcoop2.protocol.as4.pmode.TranslatorPropertiesDefault;
import org.openspcoop2.protocol.as4.utils.AS4PropertiesUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.dch.InputStreamDataSource;
import org.openspcoop2.utils.dch.MailcapActivationReader;
import org.openspcoop2.utils.mime.MimeMultipart;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AS4Imbustamento {
    public ProtocolMessage buildASMessage(OpenSPCoop2Message msg, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, IRegistryReader registryReader, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        try {
            OpenSPCoop2MessageFactory messageFactory = msg != null ? msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            ProtocolMessage protocolMessage = new ProtocolMessage();
            OpenSPCoop2SoapMessage as4Message = null;
            MessageRole messageRole = MessageRole.REQUEST;
            if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio)) {
                messageRole = MessageRole.RESPONSE;
            }
            IDSoggetto idSoggettoMittente = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            Soggetto soggettoMittente = registryReader.getSoggetto(idSoggettoMittente);
            IDSoggetto idSoggettoDestinatario = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            Soggetto soggettoDestinatario = registryReader.getSoggetto(idSoggettoDestinatario);
            IDSoggetto idSoggettoErogatore = null;
            idSoggettoErogatore = RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) ? idSoggettoDestinatario : idSoggettoMittente;
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), idSoggettoErogatore, busta.getVersioneServizio().intValue());
            AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio);
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            AccordoServizioParteComune aspc = registryReader.getAccordoServizioParteComune(idAccordo);
            TranslatorPayloadProfilesDefault tPayloadProfiles = TranslatorPayloadProfilesDefault.getTranslator();
            TranslatorPropertiesDefault tProperties = TranslatorPropertiesDefault.getTranslator();
            String azione = busta.getAzione();
            String nomePortType = asps.getPortType();
            String actionProperty = AS4BuilderUtils.readPropertyInfoAction(aspc, nomePortType, azione);
            String payloadProfile = AS4BuilderUtils.readPropertyPayloadProfile(aspc, nomePortType, azione);
            String propertySet = AS4BuilderUtils.readPropertyPropertySet(aspc, nomePortType, azione);
            if (actionProperty == null) {
                throw new ProtocolException("Action '" + azione + "' not found");
            }
            if (payloadProfile == null) {
                payloadProfile = tPayloadProfiles.getListPayloadProfileDefault().get(0).getName();
            }
            if (propertySet == null) {
                propertySet = tProperties.getListPropertySetDefault().get(0).getName();
            }
            PayloadProfiles pps = AS4BuilderUtils.readPayloadProfiles(tPayloadProfiles, aspc, idAccordo, true);
            ArrayList<Payload> payloadConfig = new ArrayList<Payload>();
            boolean foundP = false;
            for (PayloadProfile p : pps.getPayloadProfileList()) {
                if (!p.getName().equals(payloadProfile)) continue;
                for (Attachment a : p.getAttachmentList()) {
                    boolean found = false;
                    for (Payload payload : pps.getPayloadList()) {
                        if (!payload.getName().equals(a.getName())) continue;
                        payloadConfig.add(payload);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new ProtocolException("Action '" + azione + "' (payload profile '" + payloadProfile + "') with payload '" + a.getName() + "' unknown");
                }
                foundP = true;
                break;
            }
            if (!foundP) {
                throw new ProtocolException("Action '" + azione + "' with payload profile '" + payloadProfile + "' unknown");
            }
            Properties properties = AS4BuilderUtils.readProperties(tProperties, aspc, idAccordo, true);
            ArrayList<eu.domibus.configuration.Property> propertyConfig = new ArrayList<eu.domibus.configuration.Property>();
            foundP = false;
            for (PropertySet p : properties.getPropertySetList()) {
                if (!p.getName().equals(propertySet)) continue;
                for (PropertyRef a : p.getPropertyRefList()) {
                    boolean found = false;
                    for (eu.domibus.configuration.Property property : properties.getPropertyList()) {
                        if (!property.getName().equals(a.getProperty())) continue;
                        propertyConfig.add(property);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new ProtocolException("Action '" + azione + "' (propertySet '" + propertySet + "') with property '" + a.getProperty() + "' unknown");
                }
                foundP = true;
                break;
            }
            if (!foundP) {
                throw new ProtocolException("Action '" + azione + "' with propertySet '" + propertySet + "' unknown");
            }
            HashMap<String, String> mapIdPartInfoToIdAttach = new HashMap<String, String>();
            Messaging ebmsV3_0Messagging = this.buildEbmsV3_0Messagging(ruoloMessaggio, busta, soggettoMittente, soggettoDestinatario, aspc, actionProperty, asps.getPortType(), msg.getServiceBinding());
            this.addMessageProperties(ebmsV3_0Messagging, busta, msg, propertyConfig);
            PayloadInfo payloadInfo = new PayloadInfo();
            ebmsV3_0Messagging.getUserMessage(0).setPayloadInfo(payloadInfo);
            SubmitRequest submitRequest = new SubmitRequest();
            if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                OpenSPCoop2SoapMessage soapMessage = msg.castAsSoap();
                if (MessageType.SOAP_12.equals((Object)msg.getMessageType())) {
                    as4Message = soapMessage;
                } else {
                    as4Message = messageFactory.createEmptyMessage(MessageType.SOAP_12, messageRole).castAsSoap();
                    msg.copyResourcesTo((OpenSPCoop2Message)as4Message);
                    this.fillSoap12fromSoap11(as4Message, soapMessage);
                }
                this.mapAS4InfoFromSoapMessage(as4Message, soapMessage, payloadInfo, submitRequest, mapIdPartInfoToIdAttach, payloadConfig, payloadProfile, protocolFactory.getLogger());
            } else {
                OpenSPCoop2RestMessage restMessage = msg.castAsRest();
                as4Message = messageFactory.createEmptyMessage(MessageType.SOAP_12, messageRole).castAsSoap();
                msg.copyResourcesTo((OpenSPCoop2Message)as4Message);
                this.mapAS4InfoFromRestMessage(as4Message, restMessage, payloadInfo, submitRequest, mapIdPartInfoToIdAttach, payloadConfig, payloadProfile, protocolFactory.getLogger());
            }
            as4Message.setSoapAction("");
            org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.utils.serializer.JaxbSerializer as4Serializer = new org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.utils.serializer.JaxbSerializer();
            byte[] as4Header = as4Serializer.toByteArray(ebmsV3_0Messagging);
            SOAPElement soapElementAs4Header = as4Message.createSOAPElement(as4Header);
            SOAPHeader hdr = as4Message.getSOAPHeader();
            if (hdr == null) {
                hdr = as4Message.getSOAPPart().getEnvelope().addHeader();
            }
            hdr.addChildElement(soapElementAs4Header);
            JaxbSerializer ecodexSerializer = new JaxbSerializer();
            byte[] as4Body = ecodexSerializer.toByteArray(submitRequest);
            SOAPElement soapElementAs4Body = as4Message.createSOAPElement(as4Body);
            List childAs4Body = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)soapElementAs4Body);
            for (SOAPElement payloadInfoAs4Body : childAs4Body) {
                String value = payloadInfoAs4Body.getAttribute("payloadId");
                if (!mapIdPartInfoToIdAttach.containsKey(value)) {
                    throw new Exception("Attachment with payloadInfo id [" + value + "] not found");
                }
                String attachmentId = (String)mapIdPartInfoToIdAttach.get(value);
                boolean xop = false;
                if (xop) {
                    Element xomReference = payloadInfoAs4Body.getOwnerDocument().createElementNS("http://www.w3.org/2004/08/xop/include", "xop:Include");
                    xomReference.setAttribute("href", attachmentId);
                    payloadInfoAs4Body.appendChild((Node)xomReference);
                    continue;
                }
                Element cidReference = payloadInfoAs4Body.getOwnerDocument().createElement("value");
                cidReference.setTextContent(attachmentId);
                payloadInfoAs4Body.appendChild((Node)cidReference);
            }
            as4Message.getSOAPBody().removeContents();
            as4Message.getSOAPBody().addChildElement(soapElementAs4Body);
            protocolMessage.setBustaRawContent((BustaRawContent)new AS4RawContent((SOAPElement)as4Message.getSOAPPart().getEnvelope()));
            protocolMessage.setMessage((OpenSPCoop2Message)as4Message);
            return protocolMessage;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private Messaging buildEbmsV3_0Messagging(RuoloMessaggio ruoloMessaggio, Busta busta, Soggetto soggettoMittente, Soggetto soggettoDestinatario, AccordoServizioParteComune aspc, String actionProperty, String nomePortType, ServiceBinding serviceBinding) throws RegistryNotFound, ProtocolException, DriverRegistroServiziException {
        Messaging ebmsV3_0Messagging = new Messaging();
        UserMessage userMessage = new UserMessage();
        ebmsV3_0Messagging.addUserMessage(userMessage);
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageId(busta.getID());
        messageInfo.setTimestamp(busta.getOraRegistrazione());
        if (busta.getRiferimentoMessaggio() != null) {
            messageInfo.setRefToMessageId(busta.getRiferimentoMessaggio());
        }
        userMessage.setMessageInfo(messageInfo);
        PartyInfo partyInfo = new PartyInfo();
        userMessage.setPartyInfo(partyInfo);
        From from = new From();
        PartyId partyIdFrom = new PartyId();
        partyIdFrom.setBase(AS4PropertiesUtils.getRequiredStringValue(soggettoMittente.getProtocolPropertyList(), "ebmsUserMessagePartyId"));
        partyIdFrom.setType(AS4PropertiesUtils.getRequiredStringValue(soggettoMittente.getProtocolPropertyList(), "ebmsUserMessagePartyIdTypeValue"));
        from.addPartyId(partyIdFrom);
        if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
            from.setRole("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/initiator");
        } else {
            from.setRole("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/responder");
        }
        partyInfo.setFrom(from);
        busta.addProperty("ebmsUserMessageFromPartyId", partyIdFrom.getBase());
        busta.addProperty("ebmsUserMessageFromPartyIdType", partyIdFrom.getType());
        To destinatario = new To();
        PartyId partyIdTo = new PartyId();
        partyIdTo.setBase(AS4PropertiesUtils.getRequiredStringValue(soggettoDestinatario.getProtocolPropertyList(), "ebmsUserMessagePartyId"));
        partyIdTo.setType(AS4PropertiesUtils.getRequiredStringValue(soggettoDestinatario.getProtocolPropertyList(), "ebmsUserMessagePartyIdTypeValue"));
        destinatario.addPartyId(partyIdTo);
        if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
            destinatario.setRole("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/responder");
        } else {
            destinatario.setRole("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/initiator");
        }
        partyInfo.setTo(destinatario);
        busta.addProperty("ebmsUserMessageToPartyId", partyIdTo.getBase());
        busta.addProperty("ebmsUserMessageToPartyIdType", partyIdTo.getType());
        CollaborationInfo collaborationInfo = new CollaborationInfo();
        userMessage.setCollaborationInfo(collaborationInfo);
        Service service = new Service();
        service.setBase(AS4PropertiesUtils.getRequiredStringValue(aspc.getProtocolPropertyList(), "ebmsUserMessageCollaborationInfoService"));
        service.setType(AS4PropertiesUtils.getOptionalStringValue(aspc.getProtocolPropertyList(), "ebmsUserMessageCollaborationInfoServiceType"));
        collaborationInfo.setService(service);
        busta.addProperty("ebmsUserMessageCollaborationInfoService", service.getBase());
        busta.addProperty("ebmsUserMessageCollaborationInfoServiceType", service.getType());
        collaborationInfo.setAction(actionProperty);
        busta.addProperty("ebmsUserMessageCollaborationInfoAction", actionProperty);
        if (busta.getCollaborazione() != null) {
            collaborationInfo.setConversationId(busta.getCollaborazione());
        }
        return ebmsV3_0Messagging;
    }

    private void addMessageProperties(Messaging ebmsV3_0Messagging, Busta busta, OpenSPCoop2Message message, List<eu.domibus.configuration.Property> propertyConfig) throws Exception {
        UserMessage userMessage = ebmsV3_0Messagging.getUserMessage(0);
        TransportRequestContext transport = message.getTransportRequestContext();
        if (transport == null) {
            throw new Exception("TransportRequestContext undefined");
        }
        MessageProperties messageProperties = null;
        if (propertyConfig != null && propertyConfig.size() > 0) {
            for (eu.domibus.configuration.Property property : propertyConfig) {
                if (property.getValue() == null) {
                    throw new Exception("Found property '" + property.getName() + "' without value configuration");
                }
                PropertyValueHeader hdr = property.getValue().getHeader();
                PropertyValueUrl url = property.getValue().getUrl();
                if (hdr == null && url == null) {
                    throw new Exception("Found property '" + property.getName() + "' without value configuration (both url and header undefined)");
                }
                String value = null;
                StringBuilder bfErrore = new StringBuilder();
                if (hdr != null) {
                    value = transport.getHeaderFirstValue(hdr.getName());
                    if (value == null) {
                        bfErrore.append("Header http '" + hdr.getName() + "' not found");
                    } else if (hdr.getPattern() != null) {
                        try {
                            String newValue = RegularExpressionEngine.getStringMatchPattern((String)value, (String)hdr.getPattern());
                            if (newValue != null) {
                                value = newValue;
                            }
                        }
                        catch (RegExpNotFoundException newValue) {
                        }
                        catch (Exception e) {
                            bfErrore.append("\n\t");
                            bfErrore.append("(Header http '" + hdr.getName() + "' value '" + value + "') Valuate regularExpr '" + hdr.getPattern() + "' error: " + e.getMessage());
                        }
                    }
                }
                if (url != null) {
                    String urlInvocazionePD = transport.getUrlInvocazione_formBased();
                    try {
                        String newValue = RegularExpressionEngine.getStringMatchPattern((String)urlInvocazionePD, (String)url.getPattern());
                        if (newValue != null) {
                            value = newValue;
                        }
                    }
                    catch (RegExpNotFoundException newValue) {
                    }
                    catch (Exception e) {
                        bfErrore.append("\n\t");
                        bfErrore.append("- (URL '" + urlInvocazionePD + "') Valuate regularExpr '" + url.getPattern() + "' error: " + e.getMessage());
                    }
                }
                if (property.isRequired() && value == null) {
                    throw new Exception("It's not possible to extract a value from the request context for required property '" + property.getName() + "'. " + bfErrore.toString());
                }
                if (value == null) continue;
                if (messageProperties == null) {
                    messageProperties = new MessageProperties();
                    userMessage.setMessageProperties(messageProperties);
                }
                Property propertyOriginalSender = new Property();
                propertyOriginalSender.setName(property.getKey());
                propertyOriginalSender.setBase(value);
                messageProperties.addProperty(propertyOriginalSender);
                busta.addProperty("ebmsUserMessageProperty_" + property.getKey(), value);
            }
        }
    }

    private void fillSoap12fromSoap11(OpenSPCoop2SoapMessage soapMessage12, OpenSPCoop2SoapMessage soapMessage11) throws Exception {
        List listNodeSoapBody;
        List listNodeSoapHeader;
        if (soapMessage11.getSOAPHeader() != null && (listNodeSoapHeader = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)soapMessage11.getSOAPHeader())) != null && listNodeSoapHeader.size() > 0) {
            Object hdr = soapMessage12.getSOAPHeader();
            if (hdr == null) {
                hdr = soapMessage12.getSOAPPart().getEnvelope().addHeader();
            }
            for (SOAPElement soapElement : listNodeSoapHeader) {
                hdr.addChildElement(soapElement);
            }
        }
        if ((listNodeSoapBody = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)soapMessage11.getSOAPBody())) != null && listNodeSoapBody.size() > 0) {
            for (SOAPElement soapElement : listNodeSoapBody) {
                soapMessage12.getSOAPBody().addChildElement(soapElement);
            }
        }
        if (soapMessage11.countAttachments() > 0) {
            Iterator iter = soapMessage11.getAttachments();
            while (iter.hasNext()) {
                AttachmentPart p = (AttachmentPart)iter.next();
                soapMessage12.addAttachmentPart(p);
            }
        }
    }

    private void mapAS4InfoFromSoapMessage(OpenSPCoop2SoapMessage as4Message, OpenSPCoop2SoapMessage soapMessage, PayloadInfo payloadInfo, SubmitRequest submitRequest, Map<String, String> mapIdPartInfoToIdAttach, List<Payload> payloadConfig, String payloadProfile, Logger log) throws Exception {
        ArrayList<PartInfo> _listPartInfoUserMessage = null;
        ArrayList<LargePayloadType> _listPayload = null;
        ArrayList<AttachmentPart> _listAP = null;
        boolean reOrderAttachments = false;
        int countAttach = as4Message.countAttachments();
        if (countAttach > 0) {
            _listPartInfoUserMessage = new ArrayList<PartInfo>();
            _listPayload = new ArrayList<LargePayloadType>();
            if (reOrderAttachments) {
                _listAP = new ArrayList<AttachmentPart>();
            }
            Iterator iter = as4Message.getAttachments();
            int index = 1;
            while (iter.hasNext()) {
                AttachmentPart p = (AttachmentPart)iter.next();
                if (payloadConfig.size() < index + 1) {
                    throw new ProtocolException("Attachment-" + index + " non previsto in payload profile '" + payloadProfile + "'");
                }
                Payload payload = payloadConfig.get(index);
                String contentID = p.getContentId();
                if (contentID == null) {
                    throw new ProtocolException("Attachment without ContentID");
                }
                if (contentID.startsWith("<")) {
                    contentID = contentID.substring(1);
                }
                if (contentID.endsWith(">")) {
                    contentID = contentID.substring(0, contentID.length() - 1);
                }
                String partInfoCid = payload.getCid();
                String cid = "cid:" + contentID;
                mapIdPartInfoToIdAttach.put(partInfoCid, cid);
                String contentType = p.getContentType();
                if (contentType == null) {
                    throw new ProtocolException("Attachment without ContentType");
                }
                String contentTypeUtilizzato = payload.getMimeType();
                if (contentTypeUtilizzato == null) {
                    contentTypeUtilizzato = ContentTypeUtilities.readBaseTypeFromContentType((String)contentType);
                }
                PartInfo pInfo = new PartInfo();
                pInfo.setHref(partInfoCid);
                PartProperties partProperties = new PartProperties();
                Property property = new Property();
                property.setName("MimeType");
                property.setBase(contentTypeUtilizzato);
                partProperties.addProperty(property);
                pInfo.setPartProperties(partProperties);
                _listPartInfoUserMessage.add(pInfo);
                LargePayloadType pBodyInfo = new LargePayloadType();
                pBodyInfo.setPayloadId(partInfoCid);
                pBodyInfo.setContentType(contentTypeUtilizzato);
                _listPayload.add(pBodyInfo);
                if (reOrderAttachments) {
                    _listAP.add(p);
                }
                ++index;
            }
            if (reOrderAttachments) {
                as4Message.removeAllAttachments();
            }
        }
        int attachRequired = 0;
        for (int i = 1; i < payloadConfig.size(); ++i) {
            Payload payload = payloadConfig.get(i);
            if (!payload.isRequired()) continue;
            ++attachRequired;
        }
        if (countAttach < attachRequired) {
            throw new ProtocolException("Il payload profile '" + payloadProfile + "' richiede la presenza obbligatoria di " + attachRequired + " attachments mentre ne sono stati riscontrati " + countAttach + ".");
        }
        if (payloadConfig.size() < 1) {
            throw new ProtocolException("Payload profile '" + payloadProfile + "' non definisce alcun payload?");
        }
        Payload payload = payloadConfig.get(0);
        PartInfo _PartInfoUserMessageBody = null;
        LargePayloadType _PayloadBody = null;
        AttachmentPart apBody = null;
        byte[] xml = as4Message.getAsByte((Node)soapMessage.getSOAPPart().getEnvelope(), true);
        if (xml != null && xml.length > 0) {
            String ctBase;
            String contentTypeUtilizzato = payload.getMimeType();
            if (contentTypeUtilizzato == null) {
                contentTypeUtilizzato = MessageType.SOAP_11.equals((Object)as4Message.getMessageType()) ? "text/xml" : "application/soap+xml";
            }
            if ("text/xml".equals(ctBase = ContentTypeUtilities.readBaseTypeFromContentType((String)contentTypeUtilizzato))) {
                if (MailcapActivationReader.existsDataContentHandler((String)"text/xml")) {
                    apBody = as4Message.createAttachmentPart();
                    as4Message.updateAttachmentPart(apBody, xml, contentTypeUtilizzato);
                } else {
                    isSource = new InputStreamDataSource("eDeliveryPayload", contentTypeUtilizzato, xml);
                    apBody = as4Message.createAttachmentPart(new DataHandler((DataSource)isSource));
                }
            } else {
                isSource = new InputStreamDataSource("eDeliveryPayload", contentTypeUtilizzato, xml);
                apBody = as4Message.createAttachmentPart(new DataHandler((DataSource)isSource));
            }
            String contentID = as4Message.createContentID("http://www.openspcoop2.org/protocol/as4");
            apBody.setContentId(contentID);
            String contentIDforHRef = contentID;
            if (contentIDforHRef.startsWith("<")) {
                contentIDforHRef = contentIDforHRef.substring(1);
            }
            if (contentIDforHRef.endsWith(">")) {
                contentIDforHRef = contentIDforHRef.substring(0, contentIDforHRef.length() - 1);
            }
            String partInfoCid = payload.getCid();
            String cid = "cid:" + contentIDforHRef;
            mapIdPartInfoToIdAttach.put(partInfoCid, cid);
            PartInfo pInfo = new PartInfo();
            pInfo.setHref(partInfoCid);
            PartProperties partProperties = new PartProperties();
            Property property = new Property();
            property.setName("MimeType");
            property.setBase(contentTypeUtilizzato);
            partProperties.addProperty(property);
            pInfo.setPartProperties(partProperties);
            _PartInfoUserMessageBody = pInfo;
            LargePayloadType pBodyInfo = new LargePayloadType();
            pBodyInfo.setPayloadId(partInfoCid);
            pBodyInfo.setContentType(contentTypeUtilizzato);
            _PayloadBody = pBodyInfo;
        }
        if (_PartInfoUserMessageBody != null) {
            payloadInfo.addPartInfo(_PartInfoUserMessageBody);
            submitRequest.addPayload(_PayloadBody);
            as4Message.addAttachmentPart(apBody);
        }
        if (_listPartInfoUserMessage != null && _listPartInfoUserMessage.size() > 0) {
            payloadInfo.getPartInfoList().addAll(_listPartInfoUserMessage);
            submitRequest.getPayloadList().addAll(_listPayload);
            if (reOrderAttachments && _listAP != null && _listAP.size() > 0) {
                for (AttachmentPart ap : _listAP) {
                    as4Message.addAttachmentPart(ap);
                }
            }
        }
    }

    private void mapAS4InfoFromRestMessage(OpenSPCoop2SoapMessage as4Message, OpenSPCoop2RestMessage<?> restMessage, PayloadInfo payloadInfo, SubmitRequest submitRequest, Map<String, String> mapIdPartInfoToIdAttach, List<Payload> payloadConfig, String payloadProfile, Logger log) throws Exception {
        if (!restMessage.hasContent()) {
            throw new Exception("Messaggio non contiene dati da inoltrare");
        }
        int countAttach = 0;
        if (MessageType.MIME_MULTIPART.equals((Object)restMessage.getMessageType())) {
            MimeMultipart mimeMultipart;
            OpenSPCoop2RestMimeMultipartMessage msgMime = restMessage.castAsRestMimeMultipart();
            MimeMultipart mimeMultipart2 = mimeMultipart = msgMime.getContent() != null ? ((MultipartContent)msgMime.getContent()).getMimeMultipart() : null;
            if (mimeMultipart != null) {
                countAttach = mimeMultipart.countBodyParts();
                int index = 1;
                for (int i = 0; i < countAttach; ++i) {
                    BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                    if (payloadConfig.size() < i + 1) {
                        throw new ProtocolException("Attachment-" + index + " non previsto in payload profile '" + payloadProfile + "'");
                    }
                    Payload payload = payloadConfig.get(i);
                    String contentID = mimeMultipart.getContentID(bodyPart);
                    if (contentID == null) {
                        throw new ProtocolException("BodyPart without ContentID");
                    }
                    String contentIDforHRef = contentID;
                    if (contentIDforHRef.startsWith("<")) {
                        contentIDforHRef = contentIDforHRef.substring(1);
                    }
                    if (contentIDforHRef.endsWith(">")) {
                        contentIDforHRef = contentIDforHRef.substring(0, contentIDforHRef.length() - 1);
                    }
                    String partInfoCid = payload.getCid();
                    String cid = "cid:" + contentIDforHRef;
                    mapIdPartInfoToIdAttach.put(partInfoCid, cid);
                    String contentType = bodyPart.getContentType();
                    if (contentType == null) {
                        throw new ProtocolException("BodyPart without ContentType");
                    }
                    String contentTypeUtilizzato = payload.getMimeType();
                    if (contentTypeUtilizzato == null) {
                        contentTypeUtilizzato = ContentTypeUtilities.readBaseTypeFromContentType((String)contentType);
                    }
                    AttachmentPart ap = as4Message.createAttachmentPart(bodyPart.getDataHandler());
                    ap.setContentId(contentID);
                    as4Message.addAttachmentPart(ap);
                    PartInfo pInfo = new PartInfo();
                    pInfo.setHref(partInfoCid);
                    PartProperties partProperties = new PartProperties();
                    Property property = new Property();
                    property.setName("MimeType");
                    property.setBase(contentTypeUtilizzato);
                    partProperties.addProperty(property);
                    pInfo.setPartProperties(partProperties);
                    payloadInfo.addPartInfo(pInfo);
                    LargePayloadType pBodyInfo = new LargePayloadType();
                    pBodyInfo.setPayloadId(partInfoCid);
                    pBodyInfo.setContentType(contentTypeUtilizzato);
                    submitRequest.addPayload(pBodyInfo);
                    ++index;
                }
            }
        } else {
            if (payloadConfig.size() < 1) {
                throw new ProtocolException("Payload profile '" + payloadProfile + "' non definisce alcun payload?");
            }
            Payload payload = payloadConfig.get(0);
            AttachmentPart ap = null;
            String contentType = restMessage.getContentType();
            String contentTypeUtilizzato = payload.getMimeType();
            if (contentTypeUtilizzato == null) {
                contentTypeUtilizzato = ContentTypeUtilities.readBaseTypeFromContentType((String)contentType);
            }
            if (MessageType.XML.equals((Object)restMessage.getMessageType())) {
                String ctBase = ContentTypeUtilities.readBaseTypeFromContentType((String)contentTypeUtilizzato);
                byte[] xml = restMessage.getAsByte((Node)restMessage.castAsRestXml().getContent(), true);
                if ("text/xml".equals(ctBase)) {
                    if (MailcapActivationReader.existsDataContentHandler((String)"text/xml")) {
                        ap = as4Message.createAttachmentPart();
                        as4Message.updateAttachmentPart(ap, xml, contentTypeUtilizzato);
                    } else {
                        isSource = new InputStreamDataSource("eDeliveryPayload", contentTypeUtilizzato, xml);
                        ap = as4Message.createAttachmentPart(new DataHandler((DataSource)isSource));
                    }
                } else {
                    isSource = new InputStreamDataSource("eDeliveryPayload", contentTypeUtilizzato, xml);
                    ap = as4Message.createAttachmentPart(new DataHandler((DataSource)isSource));
                }
            } else if (MessageType.JSON.equals((Object)restMessage.getMessageType())) {
                ap = as4Message.createAttachmentPart();
                ap.setContent(restMessage.castAsRestJson().getContent(), contentTypeUtilizzato);
            } else {
                InputStreamDataSource isSource = new InputStreamDataSource("eDeliveryPayload", contentTypeUtilizzato, ((BinaryContent)restMessage.castAsRestBinary().getContent()).getContent());
                ap = as4Message.createAttachmentPart(new DataHandler((DataSource)isSource));
            }
            String contentID = as4Message.createContentID("http://www.openspcoop2.org/protocol/as4");
            if (contentID.startsWith("<")) {
                contentID = contentID.substring(1);
            }
            if (contentID.endsWith(">")) {
                contentID = contentID.substring(0, contentID.length() - 1);
            }
            String partInfoCid = payload.getCid();
            String cid = "cid:" + contentID;
            mapIdPartInfoToIdAttach.put(partInfoCid, cid);
            ap.setContentId(contentID);
            as4Message.addAttachmentPart(ap);
            PartInfo pInfo = new PartInfo();
            pInfo.setHref(partInfoCid);
            PartProperties partProperties = new PartProperties();
            Property property = new Property();
            property.setName("MimeType");
            property.setBase(contentTypeUtilizzato);
            partProperties.addProperty(property);
            pInfo.setPartProperties(partProperties);
            payloadInfo.addPartInfo(pInfo);
            LargePayloadType pBodyInfo = new LargePayloadType();
            pBodyInfo.setPayloadId(partInfoCid);
            pBodyInfo.setContentType(contentTypeUtilizzato);
            submitRequest.addPayload(pBodyInfo);
        }
        int attachRequired = 0;
        for (int i = 1; i < payloadConfig.size(); ++i) {
            Payload payload = payloadConfig.get(i);
            if (!payload.isRequired()) continue;
            ++attachRequired;
        }
        if (attachRequired > 0) {
            int attachTrovati = 0;
            if (countAttach > 1) {
                attachTrovati = countAttach - 1;
            }
            if (attachTrovati < attachRequired) {
                throw new ProtocolException("Il payload profile '" + payloadProfile + "' richiede la presenza obbligatoria di " + attachRequired + " attachments mentre ne sono stati riscontrati " + attachTrovati + ".");
            }
        }
    }
}

