/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.config;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.protocol.as4.config.AS4InstanceProperties;
import org.openspcoop2.protocol.as4.properties.SecurityPolicyXSDValidator;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.slf4j.Logger;

public class AS4Properties {
    private Logger log = null;
    private static AS4Properties as4Properties = null;
    private AS4InstanceProperties reader;
    private Boolean generateIDasUUID = null;
    private Boolean isRiferimentoIDRichiesta_PD_Required = null;
    private Boolean isRiferimentoIDRichiesta_PD_RequiredRead = null;
    private Boolean isRiferimentoIDRichiesta_PA_Required = null;
    private Boolean isRiferimentoIDRichiesta_PA_RequiredRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = null;
    private byte[] payloadProfilesDefaultPayloads;
    private Boolean payloadProfilesDefaultPayloadsRead;
    private byte[] payloadProfilesDefaultPayloadProfiles;
    private Boolean payloadProfilesDefaultPayloadProfilesRead;
    private byte[] propertiesDefaultProperty;
    private Boolean propertiesDefaultPropertyRead;
    private byte[] propertiesDefaultPropertySet;
    private Boolean propertiesDefaultPropertySetRead;
    private File securityPoliciesFolder;
    private String securityPolicyDefault;
    private File pModeTranslatorPayloadProfilesFolder;
    private File pModeTranslatorPropertiesFolder;
    private Boolean isDomibusGatewayRegistry = null;
    private Boolean isDomibusGatewayRegistryRead = null;
    private String domibusGatewayRegistrySoggettoDefault;
    private List<String> domibusGatewayRegistrySoggettoCustom_Read = new ArrayList<String>();
    private HashMap<String, String> domibusGatewayRegistrySoggettoCustom = new HashMap();
    private List<String> domibusGatewayRegistrySoggettoCustomList = new ArrayList<String>();
    private String domibusGatewayConfigDefaultUrl;
    private Boolean isDomibusGatewayConfigDefaultHttpsEnabled = null;
    private Boolean isDomibusGatewayConfigDefaultHttpsEnabledRead = null;
    private Properties domibusGatewayConfigDefaultHttpsProperties;
    private List<String> domibusGatewayConfigCustomUrl_Read = new ArrayList<String>();
    private HashMap<String, String> domibusGatewayConfigCustomUrl = new HashMap();
    private List<String> domibusGatewayConfigCustomHttsEnabled_Read = new ArrayList<String>();
    private HashMap<String, Boolean> domibusGatewayConfigCustomHttpsEnabled = new HashMap();
    private List<String> domibusGatewayConfigCustomHttsProperties_Read = new ArrayList<String>();
    private HashMap<String, Properties> domibusGatewayConfigCustomHttpsProperties = new HashMap();
    private Boolean domibusGatewayJMS_debug = null;
    private Boolean domibusGatewayJMS_debugRead = null;
    private Integer domibusGatewayJMS_threadsPoolSize;
    private Integer domibusGatewayJMS_threadCheckIntervalMs;
    private Properties domibusGatewayJMS_jndiContext = null;
    private String domibusGatewayJMS_connectionFactory;
    private Boolean domibusGatewayJMS_username_read;
    private String domibusGatewayJMS_username;
    private Boolean domibusGatewayJMS_password_read;
    private String domibusGatewayJMS_password;
    private String domibusGatewayJMS_queueReceiver;
    private String domibusGatewayJMS_queueSender;
    private Boolean domibusGatewayJMS_AckProviderUrl_read;
    private String domibusGatewayJMS_AckProviderUrl;
    private Properties domibusGatewayJMS_jndiContextForAck = null;
    private Boolean isAckTraceEnabled = null;
    private Boolean ackTraceDatasource_read;
    private String ackTraceDatasource;
    private Boolean ackTraceTipoDatabase_read;
    private String ackTraceTipoDatabase;
    private Properties ackTraceDatasource_jndiContext = null;
    private Boolean ackDomibusDatasource_read;
    private String ackDomibusDatasource;
    private Boolean ackDomibusTipoDatabase_read;
    private String ackDomibusTipoDatabase;
    private Properties ackDomibusDatasource_jndiContext = null;
    private Boolean useConfigStaticInstance = null;
    private Boolean useErroreApplicativoStaticInstance = null;
    private Boolean useEsitoStaticInstance = null;
    private BasicStaticInstanceConfig staticInstanceConfig = null;

    private AS4Properties(String confDir, Logger log) throws ProtocolException {
        if (confDir != null) {
            // empty if block
        }
        this.log = log != null ? log : LoggerWrapperFactory.getLogger((String)"AS4Properties");
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = AS4Properties.class.getResourceAsStream("/as4.properties");
            if (properties == null) {
                throw new ProtocolException("File '/as4.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura del file 'as4.properties': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException("AS4Properties initialize error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            this.reader = new AS4InstanceProperties(propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log) throws ProtocolException {
        if (as4Properties == null) {
            as4Properties = new AS4Properties(confDir, log);
        }
    }

    public static AS4Properties getInstance() throws ProtocolException {
        if (as4Properties == null) {
            Class<AS4Properties> clazz = AS4Properties.class;
            synchronized (AS4Properties.class) {
                throw new ProtocolException("AS4Properties not initialized (use init method in factory)");
            }
        }
        return as4Properties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            this.generateIDasUUID();
            this.isRiferimentoIDRichiesta_PD_Required();
            this.isRiferimentoIDRichiesta_PA_Required();
            this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
            this.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
            this.getPayloadProfilesDefaultPayloads();
            this.getPayloadProfilesDefaultPayloadProfiles();
            this.getPropertiesDefault();
            this.getPropertiesSetDefault();
            File f = this.getSecurityPoliciesFolder();
            File[] list = f.listFiles();
            if (list == null || list.length <= 0) {
                throw new Exception("Almeno una security policy deve essere definita all'interno del file '" + f.getAbsolutePath() + "'");
            }
            for (File file : list) {
                try {
                    AbstractValidatoreXSD validator = SecurityPolicyXSDValidator.getXSDValidator(this.log);
                    validator.valida(file);
                }
                catch (Exception e) {
                    throw new Exception("SecurityPolicy '" + file.getAbsolutePath() + "' contiene un formato non corretto: " + e.getMessage(), e);
                }
            }
            String secPolicyDefault = this.getSecurityPolicyDefault();
            if (secPolicyDefault != null) {
                boolean find = false;
                for (File file : list) {
                    String fileWithoutExt;
                    int lastIndexOf = file.getName().lastIndexOf(".");
                    String string = fileWithoutExt = lastIndexOf > 0 ? file.getName().substring(0, lastIndexOf) : file.getName();
                    if (!fileWithoutExt.equals(secPolicyDefault)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("SecurityPolicy indicata come default '" + secPolicyDefault + "' non esiste tra le policy registrate nella directory '" + f.getAbsolutePath() + "'");
                }
            }
            this.getPModeTranslatorPayloadProfilesFolder();
            this.getPModeTranslatorPropertiesFolder();
            if (this.isDomibusGatewayRegistry().booleanValue()) {
                this.getDomibusGatewayRegistrySoggettoDefault();
            } else {
                this.getDomibusGatewayConfigDefaultUrl();
                boolean https = this.isDomibusGatewayConfigDefaultHttpsEnabled();
                if (https) {
                    this.getDomibusGatewayConfigDefaultHttpsProperties();
                }
            }
            this.isDomibusGatewayJMS_debug();
            this.getDomibusGatewayJMS_threadsPoolSize();
            this.getDomibusGatewayJMS_threadCheckIntervalMs();
            this.getDomibusGatewayJMS_jndiContext();
            this.getDomibusGatewayJMS_connectionFactory();
            this.getDomibusGatewayJMS_username();
            this.getDomibusGatewayJMS_password();
            this.getDomibusGatewayJMS_queueReceiver();
            this.getDomibusGatewayJMS_queueSender();
            this.getDomibusGatewayJMS_jndiContextForAck();
            if (this.isAckTraceEnabled().booleanValue()) {
                if (this.getAckTraceDatasource() == null) {
                    throw new Exception("Datasource non definito per il tracing delle notifiche di ack");
                }
                this.getAckTraceDatasource_jndiContext();
                this.getAckTraceTipoDatabase();
                if (this.getAckDomibusDatasource() == null) {
                    throw new Exception("Datasource non definito per il tracing delle notifiche di ack");
                }
                this.getAckDomibusDatasource_jndiContext();
                this.getAckDomibusTipoDatabase();
            }
            this.useConfigStaticInstance();
            this.useErroreApplicativoStaticInstance();
            this.useEsitoStaticInstance();
            this.getStaticInstanceConfig();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' del protocollo as4, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, (Throwable)e);
        }
    }

    public Boolean generateIDasUUID() {
        if (this.generateIDasUUID == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.as4.id.uuid";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.generateIDasUUID = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.generateIDasUUID = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.generateIDasUUID = defaultValue;
            }
        }
        return this.generateIDasUUID;
    }

    public Boolean isRiferimentoIDRichiesta_PD_Required() {
        if (this.isRiferimentoIDRichiesta_PD_RequiredRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.pd.riferimentoIdRichiesta.required");
                if (value != null) {
                    value = value.trim();
                    this.isRiferimentoIDRichiesta_PD_Required = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pd.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true'");
                    this.isRiferimentoIDRichiesta_PD_Required = true;
                }
                this.isRiferimentoIDRichiesta_PD_RequiredRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pd.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true', errore:" + e.getMessage());
                this.isRiferimentoIDRichiesta_PD_Required = true;
                this.isRiferimentoIDRichiesta_PD_RequiredRead = true;
            }
        }
        return this.isRiferimentoIDRichiesta_PD_Required;
    }

    public Boolean isRiferimentoIDRichiesta_PA_Required() {
        if (this.isRiferimentoIDRichiesta_PA_RequiredRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.pa.riferimentoIdRichiesta.required");
                if (value != null) {
                    value = value.trim();
                    this.isRiferimentoIDRichiesta_PA_Required = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pa.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true'");
                    this.isRiferimentoIDRichiesta_PA_Required = true;
                }
                this.isRiferimentoIDRichiesta_PA_RequiredRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pa.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true', errore:" + e.getMessage());
                this.isRiferimentoIDRichiesta_PA_Required = true;
                this.isRiferimentoIDRichiesta_PA_RequiredRead = true;
            }
        }
        return this.isRiferimentoIDRichiesta_PA_Required;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.erroreApplicativo.faultApplicativo.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.erroreApplicativo.faultPdD.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultPdD;
    }

    private File getDirectory(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            FileSystemUtilities.mkdirParentDirectory((File)file);
            if (!file.mkdir()) {
                throw new Exception("Directory [" + fileName + "] non esiste e creazione non riuscita");
            }
        }
        if (!file.isDirectory()) {
            throw new Exception("File [" + fileName + "] non e' una directory");
        }
        if (!file.canRead()) {
            throw new Exception("Directory [" + fileName + "] non puo' essere letto");
        }
        return file;
    }

    private File getFile(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("File [" + fileName + "] non esiste");
        }
        if (!file.isFile()) {
            throw new Exception("File [" + fileName + "] non e' un semplice file");
        }
        if (!file.canRead()) {
            throw new Exception("File [" + fileName + "] non puo' essere letto");
        }
        return file;
    }

    public byte[] getPayloadProfilesDefaultPayloads() throws ProtocolException {
        if (this.payloadProfilesDefaultPayloadsRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.payloadProfiles.defaultPayloads");
                if (value != null) {
                    value = value.trim();
                    File f = this.getFile(value);
                    this.payloadProfilesDefaultPayloads = FileSystemUtilities.readBytesFromFile((File)f);
                }
                this.payloadProfilesDefaultPayloadsRead = true;
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.payloadProfiles.defaultPayloads', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.payloadProfilesDefaultPayloads;
    }

    public byte[] getPayloadProfilesDefaultPayloadProfiles() throws ProtocolException {
        if (this.payloadProfilesDefaultPayloadProfilesRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.payloadProfiles.defaultPayloadProfiles");
                if (value != null) {
                    value = value.trim();
                    File f = this.getFile(value);
                    this.payloadProfilesDefaultPayloadProfiles = FileSystemUtilities.readBytesFromFile((File)f);
                }
                this.payloadProfilesDefaultPayloadProfilesRead = true;
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.payloadProfiles.defaultPayloadProfiles', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.payloadProfilesDefaultPayloadProfiles;
    }

    public byte[] getPropertiesDefault() throws ProtocolException {
        if (this.propertiesDefaultPropertyRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.properties.defaultProperty");
                if (value != null) {
                    value = value.trim();
                    File f = this.getFile(value);
                    this.propertiesDefaultProperty = FileSystemUtilities.readBytesFromFile((File)f);
                }
                this.propertiesDefaultPropertyRead = true;
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.properties.defaultProperty', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.propertiesDefaultProperty;
    }

    public byte[] getPropertiesSetDefault() throws ProtocolException {
        if (this.propertiesDefaultPropertySetRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.properties.defaultPropertySet");
                if (value != null) {
                    value = value.trim();
                    File f = this.getFile(value);
                    this.propertiesDefaultPropertySet = FileSystemUtilities.readBytesFromFile((File)f);
                }
                this.propertiesDefaultPropertySetRead = true;
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.properties.defaultPropertySet', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.propertiesDefaultPropertySet;
    }

    public File getSecurityPoliciesFolder() throws ProtocolException {
        if (this.securityPoliciesFolder == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.securityPolicies.folder");
                if (value == null) {
                    throw new Exception("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.securityPolicies.folder' non impostata");
                }
                value = value.trim();
                this.securityPoliciesFolder = this.getDirectory(value);
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.securityPolicies.folder', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.securityPoliciesFolder;
    }

    public String getSecurityPolicyDefault() throws ProtocolException {
        if (this.securityPolicyDefault == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.securityPolicies.default");
                if (value != null) {
                    this.securityPolicyDefault = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.securityPolicies.default', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.securityPolicyDefault;
    }

    public File getPModeTranslatorPayloadProfilesFolder() throws ProtocolException {
        if (this.pModeTranslatorPayloadProfilesFolder == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.pmode.pModeTranslatorPayloadProfilesFolder");
                if (value == null) {
                    throw new Exception("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pmode.pModeTranslatorPayloadProfilesFolder' non impostata");
                }
                value = value.trim();
                this.pModeTranslatorPayloadProfilesFolder = this.getDirectory(value);
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pmode.pModeTranslatorPayloadProfilesFolder', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.pModeTranslatorPayloadProfilesFolder;
    }

    public File getPModeTranslatorPropertiesFolder() throws ProtocolException {
        if (this.pModeTranslatorPropertiesFolder == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.pmode.pModeTranslatorPropertiesFolder");
                if (value == null) {
                    throw new Exception("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pmode.pModeTranslatorPropertiesFolder' non impostata");
                }
                value = value.trim();
                this.pModeTranslatorPropertiesFolder = this.getDirectory(value);
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.pmode.pModeTranslatorPropertiesFolder', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.pModeTranslatorPropertiesFolder;
    }

    public Boolean isDomibusGatewayRegistry() throws ProtocolException {
        if (this.isDomibusGatewayRegistryRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.registry");
                if (value != null) {
                    value = value.trim();
                    this.isDomibusGatewayRegistry = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' non impostata");
                }
                this.isDomibusGatewayRegistryRead = true;
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.registry' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isDomibusGatewayRegistryRead = true;
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.isDomibusGatewayRegistry;
    }

    public String getDomibusGatewayRegistrySoggettoDefault() throws ProtocolException {
        if (this.domibusGatewayRegistrySoggettoDefault == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.registry.soggetto.default");
                if (value == null) {
                    throw new Exception("Proprieta' non impostata");
                }
                this.domibusGatewayRegistrySoggettoDefault = value = value.trim();
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.registry.soggetto.default', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayRegistrySoggettoDefault;
    }

    public String getDomibusGatewayRegistrySoggettoCustom(String nome) throws ProtocolException {
        if (!this.domibusGatewayRegistrySoggettoCustom_Read.contains(nome)) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.registry.soggetto." + nome);
                if (value != null) {
                    value = value.trim();
                    this.domibusGatewayRegistrySoggettoCustom.put(nome, value);
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.registry.soggetto." + nome + "', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.domibusGatewayRegistrySoggettoCustom_Read.add(nome);
            }
        }
        return this.domibusGatewayRegistrySoggettoCustom.get(nome);
    }

    public List<String> getDomibusGatewayRegistrySoggettoCustomList() throws ProtocolException {
        if (this.domibusGatewayRegistrySoggettoCustomList == null) {
            try {
                Properties p = this.reader.readPropertiesConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.registry.soggetto.");
                this.domibusGatewayRegistrySoggettoCustomList = new ArrayList<String>();
                Enumeration<Object> keys = p.keys();
                while (keys.hasMoreElements()) {
                    Object object = keys.nextElement();
                    if (!(object instanceof String)) continue;
                    String key = (String)object;
                    String value = p.getProperty(key);
                    this.domibusGatewayRegistrySoggettoCustomList.add(value);
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.registry.soggetto.*', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayRegistrySoggettoCustomList;
    }

    public String getDomibusGatewayConfigDefaultUrl() throws ProtocolException {
        if (this.domibusGatewayConfigDefaultUrl == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.config.default.url");
                if (value == null) {
                    throw new Exception("Proprieta' non impostata");
                }
                this.domibusGatewayConfigDefaultUrl = value = value.trim();
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.config.default.url', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayConfigDefaultUrl;
    }

    public Boolean isDomibusGatewayConfigDefaultHttpsEnabled() {
        if (this.isDomibusGatewayConfigDefaultHttpsEnabledRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.config.default.https.enabled");
                if (value != null) {
                    value = value.trim();
                    this.isDomibusGatewayConfigDefaultHttpsEnabled = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.config.default.https.enabled' non impostata, viene utilizzato il default=false");
                    this.isDomibusGatewayConfigDefaultHttpsEnabled = false;
                }
                this.isDomibusGatewayConfigDefaultHttpsEnabledRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.config.default.https.enabled' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isDomibusGatewayConfigDefaultHttpsEnabled = false;
                this.isDomibusGatewayConfigDefaultHttpsEnabledRead = true;
            }
        }
        return this.isDomibusGatewayConfigDefaultHttpsEnabled;
    }

    public Properties getDomibusGatewayConfigDefaultHttpsProperties() throws ProtocolException {
        if (this.domibusGatewayConfigDefaultHttpsProperties == null) {
            try {
                Properties p = this.reader.readPropertiesConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.config.default.https.property.");
                if (p == null || p.size() <= 0) {
                    throw new Exception("Proprieta' non impostate");
                }
                this.domibusGatewayConfigDefaultHttpsProperties = p;
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.config.default.https.property.*', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayConfigDefaultHttpsProperties;
    }

    public String getDomibusGatewayConfigCustomUrl(String nome) throws ProtocolException {
        if (!this.domibusGatewayConfigCustomUrl_Read.contains(nome)) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.config." + nome + ".url");
                if (value != null) {
                    value = value.trim();
                    this.domibusGatewayConfigCustomUrl.put(nome, value);
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.config." + nome + ".url', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.domibusGatewayConfigCustomUrl_Read.add(nome);
            }
        }
        return this.domibusGatewayConfigCustomUrl.get(nome);
    }

    public Boolean isDomibusGatewayConfigCustomHttpsEnabled(String nome) throws ProtocolException {
        if (!this.domibusGatewayConfigCustomHttsEnabled_Read.contains(nome)) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.config." + nome + ".https.enabled");
                if (value != null) {
                    value = value.trim();
                    this.domibusGatewayConfigCustomHttpsEnabled.put(nome, Boolean.parseBoolean(value));
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.config." + nome + ".https.enabled' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.domibusGatewayConfigCustomHttsEnabled_Read.add(nome);
            }
        }
        return this.domibusGatewayConfigCustomHttpsEnabled.get(nome);
    }

    public Properties getDomibusGatewayConfigCustomHttpsProperties(String nome) throws ProtocolException {
        if (!this.domibusGatewayConfigCustomHttsProperties_Read.contains(nome)) {
            try {
                Properties p = this.reader.readPropertiesConvertEnvProperties("org.openspcoop2.protocol.as4.domibusGateway.config." + nome + ".https.property.");
                if (p != null && p.size() > 0) {
                    this.domibusGatewayConfigCustomHttpsProperties.put(nome, p);
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusGateway.config." + nome + ".https.property.*', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.domibusGatewayConfigCustomHttsProperties_Read.add(nome);
            }
        }
        return this.domibusGatewayConfigCustomHttpsProperties.get(nome);
    }

    public Boolean isDomibusGatewayJMS_debug() {
        if (this.domibusGatewayJMS_debugRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.debug");
                if (value != null) {
                    value = value.trim();
                    this.domibusGatewayJMS_debug = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.debug' non impostata, viene utilizzato il default=false");
                    this.domibusGatewayJMS_debug = false;
                }
                this.domibusGatewayJMS_debugRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.debug' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isDomibusGatewayConfigDefaultHttpsEnabled = false;
                this.domibusGatewayJMS_debug = false;
            }
        }
        return this.domibusGatewayJMS_debug;
    }

    public Integer getDomibusGatewayJMS_threadsPoolSize() throws ProtocolException {
        if (this.domibusGatewayJMS_threadsPoolSize == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.threadsPool.size");
                if (value == null) {
                    throw new Exception("Proprieta' non impostata");
                }
                value = value.trim();
                this.domibusGatewayJMS_threadsPoolSize = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.threadsPool.size', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayJMS_threadsPoolSize;
    }

    public Integer getDomibusGatewayJMS_threadCheckIntervalMs() throws ProtocolException {
        if (this.domibusGatewayJMS_threadCheckIntervalMs == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.thread.checkIntervalMs");
                if (value == null) {
                    throw new Exception("Proprieta' non impostata");
                }
                value = value.trim();
                this.domibusGatewayJMS_threadCheckIntervalMs = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.thread.checkIntervalMs', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayJMS_threadCheckIntervalMs;
    }

    public Properties getDomibusGatewayJMS_jndiContext() throws ProtocolException {
        if (this.domibusGatewayJMS_jndiContext == null) {
            try {
                this.domibusGatewayJMS_jndiContext = this.reader.readPropertiesConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.jndi.");
                if (this.domibusGatewayJMS_jndiContext == null || this.domibusGatewayJMS_jndiContext.size() < 0) {
                    this.domibusGatewayJMS_jndiContext = new Properties();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.jndi.*', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayJMS_jndiContext;
    }

    public String getDomibusGatewayJMS_connectionFactory() throws ProtocolException {
        if (this.domibusGatewayJMS_connectionFactory == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.connectionFactory");
                if (value == null) {
                    throw new Exception("Proprieta' non impostata");
                }
                this.domibusGatewayJMS_connectionFactory = value = value.trim();
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.connectionFactory', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayJMS_connectionFactory;
    }

    public String getDomibusGatewayJMS_username() throws ProtocolException {
        if (this.domibusGatewayJMS_username_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.username");
                if (value != null) {
                    this.domibusGatewayJMS_username = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.username', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.domibusGatewayJMS_username_read = true;
            }
        }
        return this.domibusGatewayJMS_username;
    }

    public String getDomibusGatewayJMS_password() throws ProtocolException {
        if (this.domibusGatewayJMS_password_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.password");
                if (value != null) {
                    this.domibusGatewayJMS_password = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.password', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.domibusGatewayJMS_password_read = true;
            }
        }
        return this.domibusGatewayJMS_password;
    }

    public String getDomibusGatewayJMS_queueReceiver() throws ProtocolException {
        if (this.domibusGatewayJMS_queueReceiver == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.queue.receiver");
                if (value == null) {
                    throw new Exception("Proprieta' non impostata");
                }
                this.domibusGatewayJMS_queueReceiver = value = value.trim();
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.queue.receiver', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayJMS_queueReceiver;
    }

    public String getDomibusGatewayJMS_queueSender() throws ProtocolException {
        if (this.domibusGatewayJMS_queueSender == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.queue.sender");
                if (value == null) {
                    throw new Exception("Proprieta' non impostata");
                }
                this.domibusGatewayJMS_queueSender = value = value.trim();
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.queue.sender', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.domibusGatewayJMS_queueSender;
    }

    private String getDomibusGatewayJMS_AckProviderUrl() throws ProtocolException {
        if (this.domibusGatewayJMS_AckProviderUrl_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.domibusJms.queue.sender.provider.url");
                if (value != null) {
                    this.domibusGatewayJMS_AckProviderUrl = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.domibusJms.queue.sender.provider.url', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.domibusGatewayJMS_AckProviderUrl_read = true;
            }
        }
        return this.domibusGatewayJMS_AckProviderUrl;
    }

    public Properties getDomibusGatewayJMS_jndiContextForAck() throws ProtocolException {
        if (this.domibusGatewayJMS_jndiContextForAck == null) {
            if (this.getDomibusGatewayJMS_AckProviderUrl() != null) {
                this.domibusGatewayJMS_jndiContextForAck = new Properties();
                Properties p = this.getDomibusGatewayJMS_jndiContext();
                Enumeration<Object> keys = p.keys();
                while (keys.hasMoreElements()) {
                    String key;
                    Object object = keys.nextElement();
                    if (!(object instanceof String) || "java.naming.provider.url".equalsIgnoreCase(key = (String)object)) continue;
                    this.domibusGatewayJMS_jndiContextForAck.put(key, p.get(key));
                }
                this.domibusGatewayJMS_jndiContextForAck.put("java.naming.provider.url", this.getDomibusGatewayJMS_AckProviderUrl());
            } else {
                this.domibusGatewayJMS_jndiContextForAck = this.getDomibusGatewayJMS_jndiContext();
            }
        }
        return this.domibusGatewayJMS_jndiContextForAck;
    }

    public Boolean isAckTraceEnabled() {
        if (this.isAckTraceEnabled == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.ack.trace.enabled");
                if (value != null) {
                    value = value.trim();
                    this.isAckTraceEnabled = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.trace.enabled' non impostata, viene utilizzato il default=true");
                    this.isAckTraceEnabled = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.trace.enabled' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isAckTraceEnabled = true;
            }
        }
        return this.isAckTraceEnabled;
    }

    public String getAckTraceDatasource() throws ProtocolException {
        if (this.ackTraceDatasource_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.ack.trace.dataSource");
                if (value != null) {
                    this.ackTraceDatasource = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.trace.dataSource', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.ackTraceDatasource_read = true;
            }
        }
        return this.ackTraceDatasource;
    }

    public String getAckTraceTipoDatabase() throws ProtocolException {
        if (this.ackTraceTipoDatabase_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.ack.trace.tipoDatabase");
                if (value != null) {
                    this.ackTraceTipoDatabase = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.trace.tipoDatabase', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.ackTraceTipoDatabase_read = true;
            }
        }
        return this.ackTraceTipoDatabase;
    }

    public Properties getAckTraceDatasource_jndiContext() throws ProtocolException {
        if (this.ackTraceDatasource_jndiContext == null) {
            try {
                this.ackTraceDatasource_jndiContext = this.reader.readPropertiesConvertEnvProperties("org.openspcoop2.protocol.as4.ack.trace.dataSource.property.");
                if (this.ackTraceDatasource_jndiContext == null || this.ackTraceDatasource_jndiContext.size() < 0) {
                    this.ackTraceDatasource_jndiContext = new Properties();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.trace.dataSource.property.*', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.ackTraceDatasource_jndiContext;
    }

    public String getAckDomibusDatasource() throws ProtocolException {
        if (this.ackDomibusDatasource_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.ack.domibus.dataSource");
                if (value != null) {
                    this.ackDomibusDatasource = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.domibus.dataSource', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.ackDomibusDatasource_read = true;
            }
        }
        return this.ackDomibusDatasource;
    }

    public String getAckDomibusTipoDatabase() throws ProtocolException {
        if (this.ackDomibusTipoDatabase_read == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.as4.ack.domibus.tipoDatabase");
                if (value != null) {
                    this.ackDomibusTipoDatabase = value = value.trim();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.domibus.tipoDatabase', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
            finally {
                this.ackDomibusTipoDatabase_read = true;
            }
        }
        return this.ackDomibusTipoDatabase;
    }

    public Properties getAckDomibusDatasource_jndiContext() throws ProtocolException {
        if (this.ackDomibusDatasource_jndiContext == null) {
            try {
                this.ackDomibusDatasource_jndiContext = this.reader.readPropertiesConvertEnvProperties("org.openspcoop2.protocol.as4.ack.domibus.dataSource.property.");
                if (this.ackDomibusDatasource_jndiContext == null || this.ackDomibusDatasource_jndiContext.size() < 0) {
                    this.ackDomibusDatasource_jndiContext = new Properties();
                }
            }
            catch (Exception e) {
                this.log.error("Proprieta' di openspcoop 'org.openspcoop2.protocol.as4.ack.domibus.dataSource.property.*', errore:" + e.getMessage());
                throw new ProtocolException((Throwable)e);
            }
        }
        return this.ackDomibusDatasource_jndiContext;
    }

    private Boolean useConfigStaticInstance() {
        if (this.useConfigStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.as4.factory.config.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useConfigStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useConfigStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useConfigStaticInstance = defaultValue;
            }
        }
        return this.useConfigStaticInstance;
    }

    private Boolean useErroreApplicativoStaticInstance() {
        if (this.useErroreApplicativoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.as4.factory.erroreApplicativo.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useErroreApplicativoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useErroreApplicativoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useErroreApplicativoStaticInstance = defaultValue;
            }
        }
        return this.useErroreApplicativoStaticInstance;
    }

    private Boolean useEsitoStaticInstance() {
        if (this.useEsitoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.as4.factory.esito.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useEsitoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useEsitoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useEsitoStaticInstance = defaultValue;
            }
        }
        return this.useEsitoStaticInstance;
    }

    public BasicStaticInstanceConfig getStaticInstanceConfig() {
        if (this.staticInstanceConfig == null) {
            this.staticInstanceConfig = new BasicStaticInstanceConfig();
            if (this.useConfigStaticInstance() != null) {
                this.staticInstanceConfig.setStaticConfig(this.useConfigStaticInstance().booleanValue());
            }
            if (this.useErroreApplicativoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticErrorBuilder(this.useErroreApplicativoStaticInstance().booleanValue());
            }
            if (this.useEsitoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticEsitoBuilder(this.useEsitoStaticInstance().booleanValue());
            }
        }
        return this.staticInstanceConfig;
    }
}

