/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.config;

import backend.ecodex.org._1_1.SubmitResponse;
import backend.ecodex.org._1_1.utils.ProjectInfo;
import backend.ecodex.org._1_1.utils.serializer.JaxbDeserializer;
import jakarta.xml.ws.BindingProvider;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.stub.backend_ecodex.v1_1.BackendInterface;
import org.openspcoop2.protocol.as4.stub.backend_ecodex.v1_1.BackendService11;
import org.openspcoop2.protocol.as4.stub.backend_ecodex.v1_1.MessageStatus;
import org.openspcoop2.protocol.as4.stub.backend_ecodex.v1_1.StatusRequest;
import org.openspcoop2.protocol.basic.config.BasicManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class AS4ProtocolManager
extends BasicManager {
    protected AS4Properties as4Properties = null;
    protected Logger logger = this.getProtocolFactory().getLogger();

    public AS4ProtocolManager(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
        this.as4Properties = AS4Properties.getInstance();
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultApplicativo() {
        return this.as4Properties.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultPdD() {
        return this.as4Properties.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
    }

    public OpenSPCoop2Message updateOpenSPCoop2MessageResponse(OpenSPCoop2Message msg, Busta busta, NotifierInputStreamParams notifierInputStreamParams, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext, IRegistryReader registryReader, boolean integration) throws ProtocolException {
        try {
            if (busta != null && msg != null && ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                List list;
                OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
                OpenSPCoop2MessageFactory messageFactory = msg.getFactory();
                if (soapMsg.getSOAPBody() != null && !soapMsg.getSOAPBody().hasFault() && (list = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)soapMsg.getSOAPBody(), (boolean)false)).size() == 1) {
                    Node n = (Node)list.get(0);
                    if (ProjectInfo.getInstance().getProjectNamespace().equals(n.getNamespaceURI()) && "submitResponse".equals(n.getLocalName())) {
                        JaxbDeserializer deserializer = new JaxbDeserializer();
                        byte[] b = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory).toByteArray(n);
                        SubmitResponse submitResponse = deserializer.readSubmitResponse(b);
                        String responseId = submitResponse.getMessageIDList().get(0);
                        busta.addProperty("ebmsUserMessageId", responseId);
                        Connettore connettore = this.protocolFactory.createProtocolVersionManager(this.protocolFactory.createProtocolConfiguration().getVersioneDefault()).getStaticRoute(new IDSoggetto(busta.getTipoMittente(), busta.getMittente()), IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario()), busta.getVersioneServizio().intValue()), registryReader);
                        String url = null;
                        for (Property p : connettore.getPropertyList()) {
                            if (!"location".equals(p.getNome())) continue;
                            url = p.getValore();
                            break;
                        }
                        BackendInterface domibusPort = null;
                        BackendService11 domibusService = null;
                        domibusService = new BackendService11(new URI(url + "?wsdl").toURL());
                        domibusPort = domibusService.getBACKENDPORT();
                        BindingProvider imProviderMessageBox = (BindingProvider)domibusPort;
                        imProviderMessageBox.getRequestContext().put("jakarta.xml.ws.service.endpoint.address", url);
                        StatusRequest statusReq = new StatusRequest();
                        statusReq.setMessageID(responseId);
                        MessageStatus stat = domibusPort.getStatus(statusReq);
                        int index = 10;
                        while (stat == null && index < 10) {
                            Utilities.sleep((long)1000L);
                            stat = domibusPort.getStatus(statusReq);
                        }
                        if (stat == null) {
                            ProtocolException pe = new ProtocolException("Fallito recupero da Domibus dello stato del messaggio spedito con id '" + responseId + "'");
                            pe.setForceTrace(true);
                            throw pe;
                        }
                        if (MessageStatus.SEND_IN_PROGRESS.equals((Object)stat)) {
                            this.log.debug("Stato del messaggio con id '" + responseId + "' risulta in spedizione");
                            busta.addProperty("ebmsUserMessageSendStatus", stat.name());
                        } else if (MessageStatus.SEND_ENQUEUED.equals((Object)stat)) {
                            this.log.debug("Stato del messaggio con id '" + responseId + "' risulta salvato su domibus, in attesa di essere spedito");
                            busta.addProperty("ebmsUserMessageSendStatus", stat.name());
                        } else if (MessageStatus.ACKNOWLEDGED.equals((Object)stat) || MessageStatus.ACKNOWLEDGED_WITH_WARNING.equals((Object)stat)) {
                            this.log.debug("Stato del messaggio con id '" + responseId + "': " + String.valueOf(stat));
                            busta.addProperty("ebmsUserMessageSendStatus", stat.name());
                        } else {
                            this.log.error("Stato del messaggio con id '" + responseId + "': " + String.valueOf(stat));
                            busta.addProperty("ebmsUserMessageSendStatus", stat.name());
                            ProtocolException pe = new ProtocolException("Domibus non \u00e8 riuscito a gestire la spedizione del messaggio con id '" + responseId + "'; stato ritornato: " + String.valueOf(stat));
                            pe.setForceTrace(true);
                            throw pe;
                        }
                        return null;
                    }
                }
            }
            return super.updateOpenSPCoop2MessageResponse(msg, busta, notifierInputStreamParams, transportRequestContext, transportResponseContext, registryReader, integration);
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isStaticRoute() throws ProtocolException {
        return true;
    }

    public Connettore getStaticRoute(IDSoggetto idSoggettoMittente, IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException {
        try {
            boolean registry = this.as4Properties.isDomibusGatewayRegistry();
            if (registry) {
                String tipo = this.protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault();
                IDSoggetto idSoggettoGateway = null;
                String nome = this.as4Properties.getDomibusGatewayRegistrySoggettoCustom(idSoggettoMittente.getNome());
                idSoggettoGateway = nome != null && !"".equals(nome) ? new IDSoggetto(tipo, nome) : new IDSoggetto(tipo, this.as4Properties.getDomibusGatewayRegistrySoggettoDefault());
                Soggetto s = null;
                try {
                    s = registryReader.getSoggetto(idSoggettoGateway);
                    if (s == null) {
                        throw new RegistryNotFound();
                    }
                }
                catch (RegistryNotFound notFound) {
                    throw new Exception("Soggetto Gateway [" + String.valueOf(idSoggettoGateway) + "], indicato nella configurazione, non risulta esistere nel registro", notFound);
                }
                if (s.getConnettore() == null || TipiConnettore.DISABILITATO.getNome().equals(s.getConnettore().getTipo())) {
                    throw new Exception("Soggetto Gateway [" + String.valueOf(idSoggettoGateway) + "], indicato nella configurazione, non contiene la definizione di un connettore");
                }
                return s.getConnettore();
            }
            String url = this.as4Properties.getDomibusGatewayConfigCustomUrl(idSoggettoMittente.getNome());
            if (url == null || "".equals(url)) {
                url = this.as4Properties.getDomibusGatewayConfigDefaultUrl();
            }
            String tipoConnettore = TipiConnettore.HTTP.getNome();
            Properties pConnettore = null;
            Boolean https = this.as4Properties.isDomibusGatewayConfigCustomHttpsEnabled(idSoggettoMittente.getNome());
            if (https == null) {
                https = this.as4Properties.isDomibusGatewayConfigDefaultHttpsEnabled();
            }
            if (https.booleanValue()) {
                tipoConnettore = TipiConnettore.HTTPS.getNome();
                pConnettore = this.as4Properties.getDomibusGatewayConfigCustomHttpsProperties(idSoggettoMittente.getNome());
                if (pConnettore == null || pConnettore.size() <= 0) {
                    pConnettore = this.as4Properties.getDomibusGatewayConfigDefaultHttpsProperties();
                }
            }
            Connettore c = new Connettore();
            c.setNome("DomibusGateway");
            c.setTipo(tipoConnettore);
            Property pUrl = new Property();
            pUrl.setNome("location");
            pUrl.setValore(url);
            c.getPropertyList().add(pUrl);
            if (pConnettore != null && pConnettore.size() > 0) {
                Enumeration<Object> names = pConnettore.keys();
                while (names.hasMoreElements()) {
                    Object object = names.nextElement();
                    if (!(object instanceof String)) continue;
                    String key = (String)object;
                    String value = pConnettore.getProperty(key);
                    Property p = new Property();
                    p.setNome(key);
                    p.setValore(value);
                    c.getPropertyList().add(p);
                }
            }
            return c;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

