/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode;

import freemarker.template.Template;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.protocol.as4.pmode.PModeRegistryReader;
import org.openspcoop2.protocol.as4.pmode.beans.APC;
import org.openspcoop2.protocol.as4.pmode.beans.API;
import org.openspcoop2.protocol.as4.pmode.beans.APS;
import org.openspcoop2.protocol.as4.pmode.beans.PayloadProfiles;
import org.openspcoop2.protocol.as4.pmode.beans.Properties;
import org.openspcoop2.protocol.as4.pmode.beans.Soggetto;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.resources.TemplateUtils;

public class Translator {
    private Template template;
    private PModeRegistryReader reader;

    public Translator(PModeRegistryReader pmodeRegistryReader) throws ProtocolException {
        try {
            this.template = TemplateUtils.getTemplate((String)"/org/openspcoop2/protocol/as4/pmode", (String)"pmode-template.ftl");
            this.reader = pmodeRegistryReader;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkInitDriver() throws ProtocolException {
        if (this.reader == null) {
            throw new ProtocolException("Translator initialized without IRegistryReader. Use different constructor");
        }
    }

    public void translate(OutputStream out) throws Exception {
        this.translate(out, this.reader.getNomeSoggettoOperativo());
    }

    public void translate(OutputStream out, String nomeSoggetto) throws Exception {
        OutputStreamWriter oow = new OutputStreamWriter(out);
        this.translate(oow, nomeSoggetto);
        oow.flush();
        oow.close();
    }

    public void translate(Writer out) throws Exception {
        this.translate(out, this.reader.getNomeSoggettoOperativo());
    }

    public void translate(Writer out, String nomeSoggetto) throws Exception {
        try {
            Object nomeSoggettoOperativo;
            Map<String, Object> map = this.buildMap();
            List soggetti = (List)map.get("soggetti");
            for (Soggetto soggetto : soggetti) {
                if (!nomeSoggetto.equals(soggetto.getBase().getNome())) continue;
                map.put("soggettoOperativo", soggetto.getEbmsUserMessagePartyCN());
                break;
            }
            if ((nomeSoggettoOperativo = map.get("soggettoOperativo")) == null) {
                throw new Exception("Soggetto Operativo 'PartyCN' non trovato per soggetto [" + nomeSoggetto + "]");
            }
            this.template.process(map, out);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Object> buildMap() throws Exception {
        this.checkInitDriver();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policies", this.reader.findAllPolicies());
        List<APC> apcList = this.reader.findAllAPC();
        map.put("apcList", apcList);
        PayloadProfiles findPayloadProfile = this.reader.findPayloadProfile(apcList);
        map.put("payloadProfiles", findPayloadProfile);
        Properties findProperties = this.reader.findProperties(apcList);
        map.put("properties", findProperties);
        Map<IDAccordo, API> accordi = this.reader.findAllAccordi(findPayloadProfile, findProperties);
        map.put("apis", accordi);
        List<Soggetto> soggetti = this.reader.findAllSoggetti(accordi);
        for (Soggetto soggetto : soggetti) {
            List<APS> listAPS = soggetto.getAps();
            for (APS aps : listAPS) {
                aps.initCNFruitori(soggetti);
                aps.initCNFruitori(soggetti, this.reader.findSoggettoAutorizzati(aps.getBase()));
                aps.checkCNFruitori();
            }
        }
        map.put("soggetti", soggetti);
        map.put("partyIdTypes", this.reader.findAllPartyIdTypes(soggetti));
        return map;
    }
}

