/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.services;

import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSession;
import java.util.Properties;
import javax.naming.InitialContext;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.services.BaseConnettoreUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.threads.IRunnableInstance;
import org.openspcoop2.utils.threads.RunnableLogger;
import org.openspcoop2.utils.transport.jms.ExceptionListenerJMS;

public abstract class AbstractRicezioneConnector
implements IRunnableInstance {
    private boolean ricezioneNotifiche;
    protected RunnableLogger log;
    protected AS4Properties asProperties;
    private QueueReceiver receiver = null;
    private Queue queue = null;
    private QueueConnectionFactory qcf = null;
    private QueueConnection qc = null;
    private QueueSession qs = null;
    private ExceptionListenerJMS exceptionListenerJMS = new ExceptionListenerJMS();
    private boolean riconnessioneConErrore = false;

    public AbstractRicezioneConnector(RunnableLogger runnableLog, AS4Properties asProperties, boolean ricezioneNotifiche) throws Exception {
        this.log = runnableLog;
        this.asProperties = asProperties;
        this.ricezioneNotifiche = ricezioneNotifiche;
        try {
            this.initJMS();
        }
        catch (Exception er) {
            this.log.error(": Re-Inizializzazione Receiver non effettuata:" + er.toString());
            this.riconnessioneConErrore = true;
        }
    }

    protected abstract void check(Message var1) throws Exception;

    public void check() throws UtilsException {
        try {
            if (this.riconnessioneConErrore) {
                throw new JMSException("RiconnessioneJMS non riuscita...");
            }
            if (this.exceptionListenerJMS.isConnessioneCorrotta()) {
                this.log.error("ExceptionJMSListener ha rilevato una connessione jms corrotta", (Throwable)this.exceptionListenerJMS.getException());
                throw new JMSException("ExceptionJMSListener ha rilevato una connessione jms corrotta: " + this.exceptionListenerJMS.getException().getMessage());
            }
            Message received = this.receiver.receive(1L);
            if (received == null) {
                this.log.debug("Non sono presenti messaggi in coda");
                return;
            }
            if (this.asProperties.isDomibusGatewayJMS_debug().booleanValue()) {
                BaseConnettoreUtils utils = new BaseConnettoreUtils(this.log);
                utils.debug(received);
            }
            this.check(received);
            this.qs.commit();
        }
        catch (JMSException e) {
            try {
                this.qs.rollback();
            }
            catch (Exception utils) {
                // empty catch block
            }
            this.log.error("Riscontrato errore JMS durante la gestione di una richiesta: " + e.toString(), (Throwable)e);
            try {
                Utilities.sleep((long)5000L);
                this.log.debug(": Re-Inizializzazione Receiver ...");
                this.closeJMS();
                if (this.exceptionListenerJMS.isConnessioneCorrotta()) {
                    this.exceptionListenerJMS.setConnessioneCorrotta(false);
                    this.exceptionListenerJMS.setException(null);
                }
                this.initJMS();
                this.log.debug(": Re-Inizializzazione Receiver effettuata.");
                this.riconnessioneConErrore = false;
            }
            catch (Exception er) {
                this.log.error(": Re-Inizializzazione Receiver non effettuata:" + er.toString());
                this.riconnessioneConErrore = true;
            }
        }
        catch (Exception e) {
            try {
                this.qs.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error("Riscontrato errore durante la gestione di una richiesta: " + e.toString(), (Throwable)e);
        }
    }

    private void initJMS() throws Exception {
        Properties pJNDI = null;
        pJNDI = this.ricezioneNotifiche ? this.asProperties.getDomibusGatewayJMS_jndiContextForAck() : this.asProperties.getDomibusGatewayJMS_jndiContext();
        String username = this.asProperties.getDomibusGatewayJMS_username();
        String password = this.asProperties.getDomibusGatewayJMS_password();
        if (username != null && password != null) {
            this.log.debug("Set autenticazione [" + username + "][" + password + "]");
            pJNDI.put("java.naming.security.principal", username);
            pJNDI.put("java.naming.security.credentials", password);
        }
        InitialContext ctx = new InitialContext(pJNDI);
        this.qcf = (QueueConnectionFactory)ctx.lookup(this.asProperties.getDomibusGatewayJMS_connectionFactory());
        this.qc = username != null ? this.qcf.createQueueConnection(username, password) : this.qcf.createQueueConnection();
        this.qc.setExceptionListener((ExceptionListener)this.exceptionListenerJMS);
        this.queue = null;
        String nomeQueue = null;
        nomeQueue = this.ricezioneNotifiche ? this.asProperties.getDomibusGatewayJMS_queueSender() : this.asProperties.getDomibusGatewayJMS_queueReceiver();
        this.queue = (Queue)ctx.lookup(nomeQueue);
        this.qs = this.qc.createQueueSession(true, -1);
        this.receiver = this.qs.createReceiver(this.queue);
        this.qc.start();
    }

    private void closeJMS() throws Exception {
        try {
            this.receiver.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.qs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.qc.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.qc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

