

-- GovWay Tracce

CREATE SEQUENCE seq_msgdiagnostici start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE msgdiagnostici
(
	gdo TIMESTAMP NOT NULL,
	pdd_codice VARCHAR(255) NOT NULL,
	pdd_tipo_soggetto VARCHAR(255) NOT NULL,
	pdd_nome_soggetto VARCHAR(255) NOT NULL,
	idfunzione VARCHAR(255) NOT NULL,
	severita INT NOT NULL,
	messaggio TEXT NOT NULL,
	-- Eventuale id della richiesta in gestione (informazione non definita dalla specifica)
	idmessaggio VARCHAR(255),
	-- Eventuale id della risposta correlata alla richiesta (informazione non definita dalla specifica)
	idmessaggio_risposta VARCHAR(255),
	-- Codice del diagnostico emesso
	codice VARCHAR(255) NOT NULL,
	-- Protocollo (puo' non essere presente per i diagnostici di 'servizio' della porta)
	protocollo VARCHAR(255),
	id_transazione VARCHAR(255) NOT NULL,
	applicativo VARCHAR(2000),
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_msgdiagnostici') NOT NULL,
	-- check constraints
	CONSTRAINT chk_msgdiagnostici_1 CHECK (severita IN (0,1,2,3,4,5,6,7)),
	-- fk/pk keys constraints
	CONSTRAINT pk_msgdiagnostici PRIMARY KEY (id)
);

-- index
CREATE INDEX MSG_DIAG_TRANS ON msgdiagnostici (id_transazione);
CREATE INDEX MSG_DIAG_ID ON msgdiagnostici (idmessaggio);
CREATE INDEX MSG_DIAG_GDO ON msgdiagnostici (gdo DESC);




-- govway
		  		
CREATE SEQUENCE seq_tracce start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE tracce
(
	gdo TIMESTAMP NOT NULL,
	gdo_int BIGINT NOT NULL,
	pdd_codice VARCHAR(255) NOT NULL,
	pdd_tipo_soggetto VARCHAR(255) NOT NULL,
	pdd_nome_soggetto VARCHAR(255) NOT NULL,
	pdd_ruolo VARCHAR(255) NOT NULL,
	tipo_messaggio VARCHAR(255) NOT NULL,
	esito_elaborazione VARCHAR(255) NOT NULL,
	dettaglio_esito_elaborazione TEXT,
	mittente VARCHAR(255),
	tipo_mittente VARCHAR(255),
	idporta_mittente VARCHAR(255),
	indirizzo_mittente VARCHAR(255),
	destinatario VARCHAR(255),
	tipo_destinatario VARCHAR(255),
	idporta_destinatario VARCHAR(255),
	indirizzo_destinatario VARCHAR(255),
	profilo_collaborazione VARCHAR(255),
	profilo_collaborazione_meta VARCHAR(255),
	servizio_correlato VARCHAR(255),
	tipo_servizio_correlato VARCHAR(255),
	versione_servizio_correlato INT,
	collaborazione VARCHAR(255),
	versione_servizio INT,
	servizio VARCHAR(255),
	tipo_servizio VARCHAR(255),
	azione VARCHAR(255),
	id_messaggio VARCHAR(255),
	ora_registrazione TIMESTAMP,
	tipo_ora_reg VARCHAR(255),
	tipo_ora_reg_meta VARCHAR(255),
	rif_messaggio VARCHAR(255),
	scadenza TIMESTAMP,
	inoltro VARCHAR(255),
	inoltro_meta VARCHAR(255),
	conferma_ricezione INT,
	sequenza INT,
	-- Dati di integrazione
	location VARCHAR(255),
	correlazione_applicativa VARCHAR(255),
	correlazione_risposta VARCHAR(255),
	sa_fruitore VARCHAR(255),
	sa_erogatore VARCHAR(255),
	-- Protocollo
	protocollo VARCHAR(255) NOT NULL,
	-- Testsuite
	is_arrived INT DEFAULT 0,
	soap_element TEXT,
	digest TEXT,
	id_transazione VARCHAR(255) NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_tracce') NOT NULL,
	-- check constraints
	CONSTRAINT chk_tracce_1 CHECK (pdd_ruolo IN ('delegata','applicativa','integrationManager','router')),
	CONSTRAINT chk_tracce_2 CHECK (tipo_messaggio IN ('Richiesta','Risposta')),
	CONSTRAINT chk_tracce_3 CHECK (esito_elaborazione IN ('INVIATO','RICEVUTO','ERRORE')),
	-- fk/pk keys constraints
	CONSTRAINT pk_tracce PRIMARY KEY (id)
);

-- index
CREATE INDEX TRACCE_TRANS ON tracce (id_transazione,tipo_messaggio);
CREATE INDEX TRACCE_SEARCH_ID ON tracce (id_messaggio,pdd_codice);
CREATE INDEX TRACCE_SEARCH_RIF ON tracce (rif_messaggio,pdd_codice);
CREATE INDEX TRACCE_SEARCH_ID_SOGGETTO ON tracce (id_messaggio,pdd_tipo_soggetto,pdd_nome_soggetto);
CREATE INDEX TRACCE_SEARCH_RIF_SOGGETTO ON tracce (rif_messaggio,pdd_tipo_soggetto,pdd_nome_soggetto);
CREATE INDEX TRACCE_SEARCH_ID_APPL ON tracce (correlazione_applicativa);
CREATE INDEX TRACCE_SEARCH_ID_APPL_RISP ON tracce (correlazione_risposta);
CREATE INDEX TRACCE_SEARCH_GDO ON tracce (gdo DESC);



CREATE SEQUENCE seq_tracce_riscontri start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE tracce_riscontri
(
	idtraccia BIGINT NOT NULL,
	riscontro VARCHAR(255),
	ricevuta TEXT,
	ora_registrazione TIMESTAMP,
	tipo_ora_reg VARCHAR(255),
	tipo_ora_reg_meta VARCHAR(255),
	-- Data di registrazione
	gdo TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_tracce_riscontri') NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_tracce_riscontri_1 FOREIGN KEY (idtraccia) REFERENCES tracce(id) ON DELETE CASCADE,
	CONSTRAINT pk_tracce_riscontri PRIMARY KEY (id)
);

-- index
CREATE INDEX TRACCE_RIS ON tracce_riscontri (idtraccia);



CREATE SEQUENCE seq_tracce_trasmissioni start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE tracce_trasmissioni
(
	idtraccia BIGINT NOT NULL,
	origine VARCHAR(255),
	tipo_origine VARCHAR(255),
	indirizzo_origine VARCHAR(255),
	idporta_origine VARCHAR(255),
	destinazione VARCHAR(255),
	tipo_destinazione VARCHAR(255),
	indirizzo_destinazione VARCHAR(255),
	idporta_destinazione VARCHAR(255),
	ora_registrazione TIMESTAMP,
	tipo_ora_reg VARCHAR(255),
	tipo_ora_reg_meta VARCHAR(255),
	-- Data di registrazione
	gdo TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_tracce_trasmissioni') NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_tracce_trasmissioni_1 FOREIGN KEY (idtraccia) REFERENCES tracce(id) ON DELETE CASCADE,
	CONSTRAINT pk_tracce_trasmissioni PRIMARY KEY (id)
);

-- index
CREATE INDEX TRACCE_TR ON tracce_trasmissioni (idtraccia);



CREATE SEQUENCE seq_tracce_eccezioni start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE tracce_eccezioni
(
	idtraccia BIGINT NOT NULL,
	contesto_codifica VARCHAR(255),
	contesto_codifica_meta VARCHAR(255),
	codice_eccezione VARCHAR(255),
	codice_eccezione_meta INT,
	subcodice_eccezione_meta INT,
	rilevanza VARCHAR(255),
	rilevanza_meta VARCHAR(255),
	posizione TEXT,
	-- Data di registrazione
	gdo TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_tracce_eccezioni') NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_tracce_eccezioni_1 FOREIGN KEY (idtraccia) REFERENCES tracce(id) ON DELETE CASCADE,
	CONSTRAINT pk_tracce_eccezioni PRIMARY KEY (id)
);

-- index
CREATE INDEX TRACCE_ECC ON tracce_eccezioni (idtraccia);



CREATE SEQUENCE seq_tracce_allegati start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE tracce_allegati
(
	idtraccia BIGINT NOT NULL,
	content_id VARCHAR(255),
	content_location VARCHAR(255),
	content_type VARCHAR(255),
	digest TEXT,
	-- Data di registrazione
	gdo TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_tracce_allegati') NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_tracce_allegati_1 FOREIGN KEY (idtraccia) REFERENCES tracce(id) ON DELETE CASCADE,
	CONSTRAINT pk_tracce_allegati PRIMARY KEY (id)
);

-- index
CREATE INDEX TRACCE_ALLEGATI_INDEX ON tracce_allegati (idtraccia);



CREATE SEQUENCE seq_tracce_ext_protocol_info start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE tracce_ext_protocol_info
(
	idtraccia BIGINT NOT NULL,
	name VARCHAR(255) NOT NULL,
	value VARCHAR(2800),
	ext_value TEXT,
	-- Data di registrazione
	gdo TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_tracce_ext_protocol_info') NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_tracce_ext_protocol_info_1 FOREIGN KEY (idtraccia) REFERENCES tracce(id) ON DELETE CASCADE,
	CONSTRAINT pk_tracce_ext_protocol_info PRIMARY KEY (id)
);

-- index
CREATE INDEX TRACCE_EXT_INFO ON tracce_ext_protocol_info (idtraccia);
CREATE INDEX TRACCE_EXT_SEARCH ON tracce_ext_protocol_info (name,value);




-- govway
		  		
-- IDENTIFICATIVO MITTENTE

CREATE SEQUENCE seq_credenziale_mittente start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 NO CYCLE;

CREATE TABLE credenziale_mittente
(
	tipo VARCHAR(20) NOT NULL,
	credenziale VARCHAR(2900) NOT NULL,
	ora_registrazione TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	ref_credenziale BIGINT,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_credenziale_mittente') NOT NULL,
	-- unique constraints
	CONSTRAINT unique_credenziale_mittente_1 UNIQUE (tipo,credenziale),
	-- fk/pk keys constraints
	CONSTRAINT pk_credenziale_mittente PRIMARY KEY (id)
);

-- index
CREATE INDEX CREDENZIALE_ORAREG ON credenziale_mittente (ora_registrazione);
CREATE INDEX CREDENZIALE_INTERNAL_REF ON credenziale_mittente (ref_credenziale);



-- TRANSAZIONI

CREATE TABLE transazioni
(
	-- Identificativo di transazione
	id VARCHAR(36) NOT NULL,
	-- Stato della Transazione
	stato VARCHAR(100),
	-- Ruolo della transazione
	-- sconosciuto (-1)
	-- invocazioneOneway (1)
	-- invocazioneSincrona (2)
	-- invocazioneAsincronaSimmetrica (3)
	-- rispostaAsincronaSimmetrica (4)
	-- invocazioneAsincronaAsimmetrica (5)
	-- richiestaStatoAsincronaAsimmetrica (6)
	-- integrationManager (7)
	ruolo_transazione INT NOT NULL,
	-- Esito della Transazione
	esito INT,
	esito_sincrono INT,
	consegne_multiple INT,
	esito_contesto VARCHAR(20),
	-- Protocollo utilizzato per la transazione
	protocollo VARCHAR(20) NOT NULL,
	-- Informazioni Http
	tipo_richiesta VARCHAR(10),
	codice_risposta_ingresso VARCHAR(10),
	codice_risposta_uscita VARCHAR(10),
	-- Tempi di latenza
	data_accettazione_richiesta TIMESTAMP,
	data_ingresso_richiesta TIMESTAMP,
	data_ingresso_richiesta_stream TIMESTAMP,
	data_uscita_richiesta TIMESTAMP,
	data_uscita_richiesta_stream TIMESTAMP,
	data_accettazione_risposta TIMESTAMP,
	data_ingresso_risposta TIMESTAMP,
	data_ingresso_risposta_stream TIMESTAMP,
	data_uscita_risposta TIMESTAMP,
	data_uscita_risposta_stream TIMESTAMP,
	-- Dimensione messaggi gestiti
	richiesta_ingresso_bytes BIGINT,
	-- Dimensione messaggi gestiti
	richiesta_uscita_bytes BIGINT,
	-- Dimensione messaggi gestiti
	risposta_ingresso_bytes BIGINT,
	-- Dimensione messaggi gestiti
	risposta_uscita_bytes BIGINT,
	-- Dati Porta di Dominio
	pdd_codice VARCHAR(110),
	pdd_tipo_soggetto VARCHAR(20),
	pdd_nome_soggetto VARCHAR(80),
	pdd_ruolo VARCHAR(20),
	-- Eventuali FAULT
	fault_integrazione TEXT,
	formato_fault_integrazione VARCHAR(20),
	fault_cooperazione TEXT,
	formato_fault_cooperazione VARCHAR(20),
	-- Soggetto Fruitore
	tipo_soggetto_fruitore VARCHAR(20),
	nome_soggetto_fruitore VARCHAR(80),
	idporta_soggetto_fruitore VARCHAR(110),
	indirizzo_soggetto_fruitore VARCHAR(255),
	-- Soggetto Erogatore
	tipo_soggetto_erogatore VARCHAR(20),
	nome_soggetto_erogatore VARCHAR(80),
	idporta_soggetto_erogatore VARCHAR(110),
	indirizzo_soggetto_erogatore VARCHAR(110),
	-- Identificativi Messaggi
	id_messaggio_richiesta VARCHAR(255),
	id_messaggio_risposta VARCHAR(255),
	data_id_msg_richiesta TIMESTAMP,
	data_id_msg_risposta TIMESTAMP,
	-- Altre informazioni di protocollo
	profilo_collaborazione_op2 VARCHAR(255),
	profilo_collaborazione_prot VARCHAR(255),
	id_collaborazione VARCHAR(255),
	uri_accordo_servizio VARCHAR(1000),
	tipo_servizio VARCHAR(20),
	nome_servizio VARCHAR(255),
	versione_servizio INT,
	azione VARCHAR(255),
	-- Identificativo asincrono se utilizzato come riferimento messaggio nella richiesta (2 fase asincrona)
	-- e altre informazioni utilizzate nei profili asincroni
	id_asincrono VARCHAR(255),
	tipo_servizio_correlato VARCHAR(20),
	nome_servizio_correlato VARCHAR(255),
	-- Header Protocollo richiesta/risposta
	header_protocollo_richiesta TEXT,
	digest_richiesta TEXT,
	prot_ext_info_richiesta TEXT,
	header_protocollo_risposta TEXT,
	digest_risposta TEXT,
	prot_ext_info_risposta TEXT,
	-- Tracciatura e Diagnostica emessa dalla PdD
	traccia_richiesta TEXT,
	traccia_risposta TEXT,
	diagnostici TEXT,
	diagnostici_list_1 VARCHAR(255),
	diagnostici_list_2 TEXT,
	diagnostici_list_ext TEXT,
	diagnostici_ext TEXT,
	error_log TEXT,
	warning_log TEXT,
	-- informazioni di integrazione
	id_correlazione_applicativa VARCHAR(255),
	id_correlazione_risposta VARCHAR(255),
	servizio_applicativo_fruitore VARCHAR(255),
	servizio_applicativo_erogatore VARCHAR(2000),
	operazione_im VARCHAR(255),
	location_richiesta VARCHAR(255),
	location_risposta VARCHAR(255),
	nome_porta VARCHAR(2000),
	credenziali TEXT,
	location_connettore TEXT,
	url_invocazione TEXT,
	trasporto_mittente VARCHAR(20),
	token_issuer VARCHAR(20),
	token_client_id VARCHAR(20),
	token_subject VARCHAR(20),
	token_username VARCHAR(20),
	token_mail VARCHAR(20),
	token_info TEXT,
	token_purpose_id VARCHAR(50),
	token_id VARCHAR(50),
	tempi_elaborazione VARCHAR(4000),
	-- filtro duplicati (0=originale,-1=duplicata,N=quanti duplicati esistono)
	duplicati_richiesta INT DEFAULT 0,
	duplicati_risposta INT DEFAULT 0,
	-- Cluster ID
	cluster_id VARCHAR(100),
	-- Indirizzo IP client letto dal socket
	socket_client_address VARCHAR(255),
	-- Indirizzo IP client letto dall'header di trasporto
	transport_client_address VARCHAR(255),
	-- Indirizzo IP client
	client_address VARCHAR(20),
	-- Eventi emessi durante la gestione della transazione
	eventi_gestione VARCHAR(20),
	-- Tipologia di API
	tipo_api INT,
	-- API implementata
	uri_api VARCHAR(20),
	-- Gruppi a cui appartiene l'api invocata
	gruppi VARCHAR(20),
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_transazioni_1 CHECK (pdd_ruolo IN ('delegata','applicativa','router','integrationManager')),
	-- fk/pk keys constraints
	CONSTRAINT pk_transazioni PRIMARY KEY (id)
);

-- index
CREATE INDEX INDEX_TR_ENTRY ON transazioni (data_ingresso_richiesta DESC,esito,esito_contesto,pdd_ruolo,pdd_codice,tipo_soggetto_erogatore,nome_soggetto_erogatore,tipo_servizio,nome_servizio);
-- CREATE INDEX INDEX_TR_MEDIUM ON transazioni (data_ingresso_richiesta DESC,esito,esito_contesto,pdd_ruolo,pdd_codice,tipo_soggetto_erogatore,nome_soggetto_erogatore,tipo_servizio,nome_servizio,azione,tipo_soggetto_fruitore,nome_soggetto_fruitore,servizio_applicativo_fruitore,trasporto_mittente,token_issuer,token_client_id,token_subject,token_username,token_mail,stato,client_address,gruppi,uri_api);
-- CREATE INDEX INDEX_TR_FULL ON transazioni (data_ingresso_richiesta DESC,esito,esito_contesto,pdd_ruolo,pdd_codice,tipo_soggetto_erogatore,nome_soggetto_erogatore,tipo_servizio,nome_servizio,versione_servizio,azione,tipo_soggetto_fruitore,nome_soggetto_fruitore,servizio_applicativo_fruitore,trasporto_mittente,token_issuer,token_client_id,token_subject,token_username,token_mail,id_correlazione_applicativa,id_correlazione_risposta,protocollo,client_address,gruppi,uri_api,eventi_gestione,cluster_id);
-- CREATE INDEX INDEX_TR_SEARCH ON transazioni (data_ingresso_richiesta DESC,esito,esito_contesto,pdd_ruolo,pdd_codice,tipo_soggetto_erogatore,nome_soggetto_erogatore,tipo_servizio,nome_servizio,versione_servizio,azione,tipo_soggetto_fruitore,nome_soggetto_fruitore,servizio_applicativo_fruitore,trasporto_mittente,token_issuer,token_client_id,token_subject,token_username,token_mail,id_correlazione_applicativa,id_correlazione_risposta,protocollo,client_address,gruppi,uri_api,eventi_gestione,cluster_id,id,data_uscita_richiesta,data_ingresso_risposta,data_uscita_risposta);
-- CREATE INDEX INDEX_TR_STATS ON transazioni (data_ingresso_richiesta,pdd_ruolo,pdd_codice,tipo_soggetto_fruitore,nome_soggetto_fruitore,tipo_soggetto_erogatore,nome_soggetto_erogatore,tipo_servizio,nome_servizio,versione_servizio,azione,servizio_applicativo_fruitore,trasporto_mittente,token_issuer,token_client_id,token_subject,token_username,token_mail,esito,esito_contesto,client_address,gruppi,uri_api,cluster_id,data_uscita_richiesta,data_ingresso_risposta,data_uscita_risposta,richiesta_ingresso_bytes,richiesta_uscita_bytes,risposta_ingresso_bytes,risposta_uscita_bytes);
CREATE INDEX INDEX_TR_PDND_STATS ON transazioni (data_ingresso_richiesta,pdd_codice,token_purpose_id,token_id,eventi_gestione,pdd_ruolo);
CREATE INDEX INDEX_TR_FILTROD_REQ ON transazioni (id_messaggio_richiesta,pdd_ruolo);
CREATE INDEX INDEX_TR_FILTROD_RES ON transazioni (id_messaggio_risposta,pdd_ruolo);
CREATE INDEX INDEX_TR_FILTROD_REQ_2 ON transazioni (data_id_msg_richiesta,id_messaggio_richiesta);
CREATE INDEX INDEX_TR_FILTROD_RES_2 ON transazioni (data_id_msg_risposta,id_messaggio_risposta);
CREATE INDEX INDEX_TR_COLLABORAZIONE ON transazioni (id_collaborazione);
CREATE INDEX INDEX_TR_RIF_RICHIESTA ON transazioni (id_asincrono);
CREATE INDEX INDEX_TR_CORRELAZIONE_REQ ON transazioni (id_correlazione_applicativa);
CREATE INDEX INDEX_TR_CORRELAZIONE_RES ON transazioni (id_correlazione_risposta);
CREATE INDEX INDEX_TR_PURPOSE_ID ON transazioni (token_purpose_id);
CREATE INDEX INDEX_TR_TOKEN_ID ON transazioni (token_id);

CREATE SEQUENCE seq_transazioni_sa start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE transazioni_sa
(
	id_transazione VARCHAR(255) NOT NULL,
	servizio_applicativo_erogatore VARCHAR(2000) NOT NULL,
	connettore_nome VARCHAR(255),
	data_registrazione TIMESTAMP NOT NULL,
	-- Esito della Consegna
	consegna_terminata BOOLEAN DEFAULT false,
	data_messaggio_scaduto TIMESTAMP,
	dettaglio_esito INT,
	-- Consegna ad un Backend Applicativo
	consegna_trasparente BOOLEAN DEFAULT false,
	-- Consegna via Integration Manager
	consegna_im BOOLEAN DEFAULT false,
	-- Identificativo del messaggio
	identificativo_messaggio VARCHAR(255),
	-- Date
	data_accettazione_richiesta TIMESTAMP,
	data_uscita_richiesta TIMESTAMP,
	data_uscita_richiesta_stream TIMESTAMP,
	data_accettazione_risposta TIMESTAMP,
	data_ingresso_risposta TIMESTAMP,
	data_ingresso_risposta_stream TIMESTAMP,
	-- Dimensione messaggi gestiti
	richiesta_uscita_bytes BIGINT,
	risposta_ingresso_bytes BIGINT,
	location_connettore TEXT,
	codice_risposta VARCHAR(10),
	-- Eventuale FAULT
	fault TEXT,
	formato_fault VARCHAR(20),
	-- Tentativi di Consegna
	data_primo_tentativo TIMESTAMP,
	numero_tentativi INT DEFAULT 0,
	-- Cluster ID
	cluster_id_in_coda VARCHAR(100),
	cluster_id_consegna VARCHAR(100),
	-- Informazioni relative all'ultimo tentativo di consegna fallito
	data_ultimo_errore TIMESTAMP,
	dettaglio_esito_ultimo_errore INT,
	codice_risposta_ultimo_errore VARCHAR(10),
	ultimo_errore TEXT,
	location_ultimo_errore TEXT,
	cluster_id_ultimo_errore VARCHAR(100),
	fault_ultimo_errore TEXT,
	formato_fault_ultimo_errore VARCHAR(20),
	-- Date relative alla gestione via IntegrationManager
	data_primo_prelievo_im TIMESTAMP,
	data_prelievo_im TIMESTAMP,
	numero_prelievi_im INT DEFAULT 0,
	data_eliminazione_im TIMESTAMP,
	cluster_id_prelievo_im VARCHAR(100),
	cluster_id_eliminazione_im VARCHAR(100),
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_transazioni_sa') NOT NULL,
	-- unique constraints
	CONSTRAINT unique_transazioni_sa_1 UNIQUE (id_transazione,servizio_applicativo_erogatore),
	-- fk/pk keys constraints
	CONSTRAINT pk_transazioni_sa PRIMARY KEY (id)
);

-- index
CREATE INDEX index_transazioni_sa_1 ON transazioni_sa (id_transazione);
-- CREATE INDEX INDEX_TRSA_IN_QUEUE ON transazioni_sa (data_registrazione DESC,servizio_applicativo_erogatore,connettore_nome,consegna_terminata,dettaglio_esito,consegna_trasparente,consegna_im,numero_tentativi,codice_risposta,data_uscita_richiesta,data_ingresso_risposta,numero_prelievi_im,data_eliminazione_im);
-- CREATE INDEX INDEX_TRSA_SEND ON transazioni_sa (data_uscita_richiesta DESC,servizio_applicativo_erogatore,connettore_nome,data_ingresso_risposta,consegna_terminata,dettaglio_esito,consegna_trasparente,consegna_im,numero_tentativi,codice_risposta,data_registrazione);



CREATE SEQUENCE seq_transazioni_info start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE transazioni_info
(
	tipo VARCHAR(255) NOT NULL,
	data TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_transazioni_info') NOT NULL,
	-- unique constraints
	CONSTRAINT unique_transazioni_info_1 UNIQUE (tipo),
	-- fk/pk keys constraints
	CONSTRAINT pk_transazioni_info PRIMARY KEY (id)
);




CREATE SEQUENCE seq_transazioni_export start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE transazioni_export
(
	-- Intervallo utilizzato dall'esportazione
	intervallo_inizio TIMESTAMP NOT NULL,
	intervallo_fine TIMESTAMP NOT NULL,
	-- Eventuale nome del file/dir dello zip esportato
	nome VARCHAR(255),
	-- Stato procedura Esportazione
	export_state VARCHAR(255) NOT NULL,
	export_error TEXT,
	export_time_start TIMESTAMP NOT NULL,
	export_time_end TIMESTAMP,
	-- Stato procedura Eliminazione
	delete_state VARCHAR(255) NOT NULL,
	delete_error TEXT,
	delete_time_start TIMESTAMP,
	delete_time_end TIMESTAMP,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_transazioni_export') NOT NULL,
	-- check constraints
	CONSTRAINT chk_transazioni_export_1 CHECK (export_state IN ('executing','completed','error')),
	CONSTRAINT chk_transazioni_export_2 CHECK (delete_state IN ('undefined','executing','completed','error')),
	-- unique constraints
	CONSTRAINT unique_transazioni_export_1 UNIQUE (intervallo_inizio,intervallo_fine),
	-- fk/pk keys constraints
	CONSTRAINT pk_transazioni_export PRIMARY KEY (id)
);




CREATE SEQUENCE seq_transazioni_esiti start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE transazioni_esiti
(
	-- Codice numerico dell'esito della transazione
	govway_status INT NOT NULL,
	-- Identificativo dell'esito della transazione
	govway_status_key VARCHAR(255) NOT NULL,
	-- Frase dell'errore che identifica l'esito della transazione
	govway_status_detail VARCHAR(255) NOT NULL,
	-- Descrizione dell'esito della transazione
	govway_status_description VARCHAR(255) NOT NULL,
	-- Codice numerico della classe di esiti a cui appartiene la transazione
	govway_status_class INT NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_transazioni_esiti') NOT NULL,
	-- unique constraints
	CONSTRAINT uniq_tr_esiti_1 UNIQUE (govway_status),
	CONSTRAINT uniq_tr_esiti_2 UNIQUE (govway_status_key),
	-- fk/pk keys constraints
	CONSTRAINT pk_transazioni_esiti PRIMARY KEY (id)
);




CREATE SEQUENCE seq_transazioni_classe_esiti start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE transazioni_classe_esiti
(
	-- Codice numerico della classe di appartenenza di un esito della transazione
	govway_status INT NOT NULL,
	-- Descrizione della classe di un esito
	govway_status_detail VARCHAR(255) NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_transazioni_classe_esiti') NOT NULL,
	-- unique constraints
	CONSTRAINT uniq_tr_classe_esiti_1 UNIQUE (govway_status),
	-- fk/pk keys constraints
	CONSTRAINT pk_transazioni_classe_esiti PRIMARY KEY (id)
);




-- DUMP - DATI

CREATE SEQUENCE seq_dump_messaggi start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE dump_messaggi
(
	id_transazione VARCHAR(255) NOT NULL,
	protocollo VARCHAR(20) NOT NULL,
	servizio_applicativo_erogatore VARCHAR(2000),
	data_consegna_erogatore TIMESTAMP,
	tipo_messaggio VARCHAR(255) NOT NULL,
	formato_messaggio VARCHAR(20),
	content_type VARCHAR(255),
	content_length BIGINT,
	multipart_content_type VARCHAR(255),
	multipart_content_id VARCHAR(255),
	multipart_content_location VARCHAR(255),
	body BYTEA,
	dump_timestamp TIMESTAMP NOT NULL,
	post_process_header TEXT,
	post_process_filename VARCHAR(255),
	post_process_content BYTEA,
	post_process_config_id VARCHAR(2000),
	post_process_timestamp TIMESTAMP,
	post_processed INT DEFAULT 1,
	multipart_header_ext TEXT,
	header_ext TEXT,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_dump_messaggi') NOT NULL,
	-- check constraints
	CONSTRAINT chk_dump_messaggi_1 CHECK (tipo_messaggio IN ('RichiestaIngresso','RichiestaUscita','RispostaIngresso','RispostaUscita','RichiestaIngressoDumpBinario','RichiestaUscitaDumpBinario','RispostaIngressoDumpBinario','RispostaUscitaDumpBinario','IntegrationManager')),
	-- fk/pk keys constraints
	CONSTRAINT pk_dump_messaggi PRIMARY KEY (id)
);

-- index
CREATE INDEX index_dump_messaggi_1 ON dump_messaggi (id_transazione);
CREATE INDEX index_dump_messaggi_2 ON dump_messaggi (post_processed,post_process_timestamp);
CREATE INDEX index_dump_messaggi_3 ON dump_messaggi (post_process_config_id);



CREATE SEQUENCE seq_dump_multipart_header start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE dump_multipart_header
(
	nome VARCHAR(255) NOT NULL,
	valore TEXT,
	dump_timestamp TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_dump_multipart_header') NOT NULL,
	id_messaggio BIGINT NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_dump_multipart_header_1 FOREIGN KEY (id_messaggio) REFERENCES dump_messaggi(id),
	CONSTRAINT pk_dump_multipart_header PRIMARY KEY (id)
);

-- index
CREATE INDEX index_dump_multipart_header_1 ON dump_multipart_header (id_messaggio);



CREATE SEQUENCE seq_dump_header_trasporto start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE dump_header_trasporto
(
	nome VARCHAR(255) NOT NULL,
	valore TEXT,
	dump_timestamp TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_dump_header_trasporto') NOT NULL,
	id_messaggio BIGINT NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_dump_header_trasporto_1 FOREIGN KEY (id_messaggio) REFERENCES dump_messaggi(id),
	CONSTRAINT pk_dump_header_trasporto PRIMARY KEY (id)
);

-- index
CREATE INDEX index_dump_header_trasporto_1 ON dump_header_trasporto (id_messaggio);



CREATE SEQUENCE seq_dump_allegati start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE dump_allegati
(
	content_type VARCHAR(255),
	content_id VARCHAR(255),
	content_location VARCHAR(255),
	allegato BYTEA,
	dump_timestamp TIMESTAMP NOT NULL,
	header_ext TEXT,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_dump_allegati') NOT NULL,
	id_messaggio BIGINT NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_dump_allegati_1 FOREIGN KEY (id_messaggio) REFERENCES dump_messaggi(id),
	CONSTRAINT pk_dump_allegati PRIMARY KEY (id)
);

-- index
CREATE INDEX index_dump_allegati_1 ON dump_allegati (id_messaggio);



CREATE SEQUENCE seq_dump_header_allegato start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE dump_header_allegato
(
	nome VARCHAR(255) NOT NULL,
	valore TEXT,
	dump_timestamp TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_dump_header_allegato') NOT NULL,
	id_allegato BIGINT NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_dump_header_allegato_1 FOREIGN KEY (id_allegato) REFERENCES dump_allegati(id),
	CONSTRAINT pk_dump_header_allegato PRIMARY KEY (id)
);

-- index
CREATE INDEX index_dump_header_allegato_1 ON dump_header_allegato (id_allegato);



CREATE SEQUENCE seq_dump_contenuti start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 CYCLE;

CREATE TABLE dump_contenuti
(
	nome VARCHAR(255) NOT NULL,
	valore VARCHAR(4000) NOT NULL,
	valore_as_bytes BYTEA,
	dump_timestamp TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_dump_contenuti') NOT NULL,
	id_messaggio BIGINT NOT NULL,
	-- unique constraints
	CONSTRAINT unique_dump_contenuti_1 UNIQUE (id,nome),
	-- fk/pk keys constraints
	CONSTRAINT fk_dump_contenuti_1 FOREIGN KEY (id_messaggio) REFERENCES dump_messaggi(id),
	CONSTRAINT pk_dump_contenuti PRIMARY KEY (id)
);

-- index
CREATE INDEX index_dump_contenuti_1 ON dump_contenuti (id_messaggio);




-- govway
		  		
-- PLUGINS PER GLI EVENTI

CREATE SEQUENCE seq_notifiche_eventi start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1 NO CYCLE;

CREATE TABLE notifiche_eventi
(
	tipo VARCHAR(100) NOT NULL,
	codice VARCHAR(100) NOT NULL,
	severita INT NOT NULL,
	ora_registrazione TIMESTAMP NOT NULL,
	descrizione VARCHAR(255),
	id_transazione VARCHAR(255),
	id_configurazione VARCHAR(255),
	configurazione TEXT,
	cluster_id VARCHAR(100),
	-- fk/pk columns
	id BIGINT DEFAULT nextval('seq_notifiche_eventi') NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT pk_notifiche_eventi PRIMARY KEY (id)
);

-- index
CREATE INDEX INDEX_EVENTI ON notifiche_eventi (ora_registrazione DESC,severita,tipo,codice,id_configurazione,cluster_id);




-- govway
		  		
-- classe esiti
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 1 , 'Completata con Successo' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 2 , 'Fault Applicativo' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 3 , 'Richiesta Scartata' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 4 , 'Errore di Consegna' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 5 , 'Autorizzazione Negata' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 6 , 'Policy Controllo Traffico Violate' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 7 , 'Errori Servizio IntegrationManager/MessageBox' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 8 , 'Errori Processamento Richiesta' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 9 , 'Errori Processamento Risposta' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 10 , 'Errore Generico' );
INSERT INTO transazioni_classe_esiti (govway_status, govway_status_detail) VALUES ( 11 , 'Errore Client Indisponibile' );

-- esiti
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 0 , 'OK' , 'Ok' , 'Transazione gestita con successo' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 1 , 'ERRORE_PROTOCOLLO' , 'Errore di Protocollo' , 'Transazione fallita a causa di un errore avvenuto durante la gestione del Profilo di Interoperabilità' , 10 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 2 , 'ERRORE_APPLICATIVO' , 'Fault Applicativo' , 'La risposta applicativa contiene un Fault Applicativo' , 2 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 3 , 'ERRORE_CONNESSIONE_CLIENT_NON_DISPONIBILE' , 'Connessione Client Interrotta' , 'La connessione del Client che ha scaturito la richiesta non è più disponibile' , 11 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 4 , 'ERRORE_PROCESSAMENTO_PDD_4XX' , 'Richiesta Malformata' , 'Errore causato da informazioni errate fornite dal client' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 5 , 'ERRORE_PROCESSAMENTO_PDD_5XX' , 'Errore Generico' , 'Errore causato da risorse non disponibili o problemi interni del gateway' , 10 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 6 , 'AUTENTICAZIONE_FALLITA' , 'Autenticazione Fallita [I.M.]' , 'Autenticazione fallita (servizio di MessageBox dell''Integration Manager)' , 7 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 7 , 'AUTORIZZAZIONE_FALLITA' , 'Autorizzazione Fallita [I.M.]' , 'Autorizzazione fallita (servizio di MessageBox dell''Integration Manager)' , 7 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 8 , 'MESSAGGI_NON_PRESENTI' , 'Messaggi non presenti [I.M.]' , 'Messaggi non presenti (servizio di MessageBox dell''Integration Manager)' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 9 , 'MESSAGGIO_NON_TROVATO' , 'Messaggio non trovato [I.M.]' , 'Messaggio non trovato (servizio di MessageBox dell''Integration Manager)' , 7 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 10 , 'ERRORE_INVOCAZIONE' , 'Errore di Connessione' , 'Messaggio non inoltrabile al destinatario a causa di problemi di connessione ' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 11 , 'ERRORE_SERVER' , 'Fault senza Informazioni Protocollo' , 'SOAP Fault ritornato dall''Erogatore senza essere contenuto in un messaggio previsto dal Profilo di Interoperabilità' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 12 , 'OK_PRESENZA_ANOMALIE' , 'Ok (Presenza Anomalie)' , 'Transazione gestito con successo (sono stati emessi dei diagnostici che hanno rilevato delle anomalie)' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 13 , 'CONTENUTO_RICHIESTA_NON_RICONOSCIUTO' , 'Contenuto Richiesta Malformato' , 'Il contenuto della richiesta non è processabile dal Gateway' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 14 , 'CONTENUTO_RISPOSTA_NON_RICONOSCIUTO' , 'Contenuto Risposta Malformato' , 'Il contenuto della risposta non è processabile dal Gateway' , 9 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 15 , 'ERRORE_TOKEN' , 'Gestione Token Fallita' , 'Sono emersi degli errori durante la gestione/validazione del token' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 16 , 'ERRORE_AUTENTICAZIONE' , 'Autenticazione Fallita' , 'L''autenticazione del richiedente non è stata effettuata con successo' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 17 , 'ERRORE_AUTORIZZAZIONE' , 'Autorizzazione Negata' , 'La richiesta non è stata autorizzata' , 5 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 18 , 'CONTROLLO_TRAFFICO_POLICY_VIOLATA' , 'Violazione Rate Limiting' , 'Rilevata una violazione di una Policy di Rate Limiting' , 6 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 19 , 'CONTROLLO_TRAFFICO_POLICY_VIOLATA_WARNING_ONLY' , 'Violazione Rate Limiting WarningOnly' , 'Rilevata una violazione di una Policy di Rate Limiting (configurata in WarningOnly)' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 20 , 'CONTROLLO_TRAFFICO_MAX_THREADS' , 'Superamento Limite Richieste' , 'Rilevato il superamento del numero massimo di richieste simultanee consentite sul gateway' , 6 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 21 , 'CONTROLLO_TRAFFICO_MAX_THREADS_WARNING_ONLY' , 'Superamento Limite Richieste WarningOnly' , 'Superamento numero massimo di richieste simultanee consentite sul gateway (controllo configurato in WarningOnly)' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 22 , 'ERRORE_SICUREZZA_MESSAGGIO_RICHIESTA' , 'Sicurezza Messaggio Richiesta Fallita' , 'La gestione della sicurezza messaggio sulla richiesta non è stata completata con successo' , 8 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 23 , 'ERRORE_SICUREZZA_MESSAGGIO_RISPOSTA' , 'Sicurezza Messaggio Risposta Fallita' , 'La gestione della sicurezza messaggio sulla risposta non è stata completata con successo' , 9 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 24 , 'ERRORE_ALLEGATI_MESSAGGIO_RICHIESTA' , 'Gestione Allegati Richiesta Fallita' , 'La gestione degli allegati sulla richiesta non è stata completata con successo' , 8 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 25 , 'ERRORE_ALLEGATI_MESSAGGIO_RISPOSTA' , 'Gestione Allegati Risposta Fallita' , 'La gestione degli allegati sulla risposta non è stata completata con successo' , 9 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 26 , 'ERRORE_CORRELAZIONE_APPLICATIVA_RICHIESTA' , 'Correlazione Applicativa Richiesta Fallita' , 'La gestione della correlazione applicativa sulla richiesta non è stata completata con successo' , 8 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 27 , 'ERRORE_CORRELAZIONE_APPLICATIVA_RISPOSTA' , 'Correlazione Applicativa Risposta Fallita' , 'La gestione della correlazione applicativa sulla risposta non è stata completata con successo' , 9 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 28 , 'HTTP_3xx' , 'Risposta HTTP 3xx' , 'La risposta applicativa contiene un codice di trasporto 3xx' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 29 , 'HTTP_4xx' , 'Risposta HTTP 4xx' , 'La risposta applicativa contiene un codice di trasporto 4xx' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 30 , 'HTTP_5xx' , 'Risposta HTTP 5xx' , 'La risposta applicativa contiene un codice di trasporto 5xx' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 31 , 'ERRORE_VALIDAZIONE_RICHIESTA' , 'Validazione Richiesta Fallita' , 'La validazione della richiesta non è stata completata con successo' , 8 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 32 , 'ERRORE_VALIDAZIONE_RISPOSTA' , 'Validazione Risposta Fallita' , 'La validazione della risposta non è stata completata con successo' , 9 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 33 , 'ERRORE_SOSPENSIONE' , 'API Sospesa' , 'L''API invocata risulta sospesa' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 34 , 'CORS_PREFLIGHT_REQUEST_VIA_GATEWAY' , 'CORS Preflight Gestione Gateway' , 'Richiesta OPTIONS CORS Preflight Request gestita dal Gateway' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 35 , 'CORS_PREFLIGHT_REQUEST_TRASPARENTE' , 'CORS Preflight Gestione Applicativa' , 'Richiesta OPTIONS CORS Preflight Request gestita dall''applicativo' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 36 , 'ERRORE_TRASFORMAZIONE_RICHIESTA' , 'Trasformazione Richiesta Fallita' , 'La trasformazione della richiesta non è stata completata con successo' , 8 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 37 , 'ERRORE_TRASFORMAZIONE_RISPOSTA' , 'Trasformazione Risposta Fallita' , 'La trasformazione della risposta non è stata completata con successo' , 9 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 38 , 'CONSEGNA_MULTIPLA' , 'Consegna Asincrona in Coda' , 'Tutte le consegne verso i connettori associati all''API sono ancora in attesa di essere consegnate' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 39 , 'CONSEGNA_MULTIPLA_COMPLETATA' , 'Consegna Asincrona Completata' , 'La richiesta pervenuta è stata inoltrata correttamente a tutti i connettori associati all''API' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 40 , 'CONSEGNA_MULTIPLA_FALLITA' , 'Consegna Asincrona Fallita' , 'La richiesta pervenuta è stata inoltrata a tutti i connettori associati all''API; in alcuni casi la consegna non è andata a buon fine' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 41 , 'TOKEN_NON_PRESENTE' , 'Token non Presente' , 'La richiesta non presenta un token' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 42 , 'ERRORE_AUTENTICAZIONE_TOKEN' , 'Autenticazione Token Fallita' , 'Nel token ricevuto non sono presenti dei claim richiesti per l''accesso all''API invocata' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 43 , 'API_NON_INDIVIDUATA' , 'API non Individuata' , 'La richiesta non permette di individuare una API registrata sul Gateway' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 44 , 'OPERAZIONE_NON_INDIVIDUATA' , 'Operazione non Individuata' , 'La richiesta non indirizza un''operazione esistente sull''API invocata' , 3 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 45 , 'RICHIESTA_DUPLICATA' , 'Richiesta già elaborata' , 'La richiesta risulta essere già stata elaborata' , 8 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 46 , 'RISPOSTA_DUPLICATA' , 'Risposta già elaborata' , 'La risposta risulta essere già stata elaborata' , 9 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 47 , 'MESSAGE_BOX' , 'Disponibile in MessageBox' , 'Messaggio gestibile tramite servizio IntegrationManager' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 48 , 'CONSEGNA_MULTIPLA_IN_CORSO' , 'Consegna Asincrona in Corso' , 'Alcune consegne verso i connettori associati all''API risultano ancora non completate' , 1 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 49 , 'ERRORE_RESPONSE_TIMEOUT' , 'Read Timeout' , 'Risposta non ricevuta entro il timeout specificato' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 50 , 'ERRORE_REQUEST_TIMEOUT' , 'Request Read Timeout' , 'Richiesta non ricevuta entro il timeout specificato' , 11 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 51 , 'ERRORE_CONNECTION_TIMEOUT' , 'Connection Timeout' , 'Connessione non stabilita entro il timeout specificato.' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 52 , 'ERRORE_NEGOZIAZIONE_TOKEN' , 'Negoziazione Token Fallita' , 'Sono emersi degli errori durante la negoziazione del token' , 4 );
INSERT INTO transazioni_esiti (govway_status, govway_status_key, govway_status_detail, govway_status_description, govway_status_class) VALUES ( 53 , 'ERRORE_TRACCIAMENTO' , 'Tracciamento Fallito' , 'Sono emersi degli errori durante il tracciamento' , 10 );


-- govway
			  		
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('FileSystemTraceRecovery');


-- govway
			  		




