/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.openspcoop2.web.monitor.core.listener.IEFilter;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.openspcoop2.web.monitor.core.utils.ContentAuthorizationManager;
import org.slf4j.Logger;

public class BrowserFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static Map<BrowserInfo.BrowserFamily, Double> mappaAbilitazioneVistaTransazioniCustom;
    private FilterConfig filterConfig = null;

    private static synchronized void loadMappaBrowser() {
        if (mappaAbilitazioneVistaTransazioniCustom == null) {
            mappaAbilitazioneVistaTransazioniCustom = new EnumMap<BrowserInfo.BrowserFamily, Double>(BrowserInfo.BrowserFamily.class);
        }
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.CHROME, 29.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.FIREFOX, 28.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.IE, 11.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.OPERA, 12.1);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.SAFARI, 9.0);
    }

    public static boolean abilitaVisualizzazioneTransazioniCustom(BrowserInfo browserInfo) {
        Double versione;
        boolean abilita = false;
        if (mappaAbilitazioneVistaTransazioniCustom == null) {
            BrowserFilter.loadMappaBrowser();
        }
        if (browserInfo != null && (versione = mappaAbilitazioneVistaTransazioniCustom.get((Object)browserInfo.getBrowserFamily())) != null && browserInfo.getVersion() != null && browserInfo.getVersion() >= versione) {
            abilita = true;
        }
        return abilita;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            try {
                log.debug("Decodifica Browser da Header UserAgent [{}]", (Object)userAgent);
                String urlRichiesta = request.getServletPath();
                log.debug("Richiesta Risorsa [{}]", (Object)urlRichiesta);
                BrowserInfo browserInfo = BrowserInfo.getBrowserInfo(userAgent);
                String browsername = browserInfo.getBrowserName();
                Double browserversion = browserInfo.getVersion();
                log.debug("Browser Riconosciuto: Name [{}] Version [{}].", (Object)browsername, (Object)browserversion);
                if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.IE)) {
                    response.setHeader("X-UA-Compatible", "IE=edge");
                    String accept = request.getHeader("Accept");
                    if ("text/css".equals(accept)) {
                        chain.doFilter((ServletRequest)new IEFilter.IE9HttpServletRequestWrapper(new IEFilter(), request), (ServletResponse)response);
                    }
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.FIREFOX)) {
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.add("/a4j/");
                    if (ContentAuthorizationManager.getInstance().contains(urlRichiesta, lst)) {
                        log.debug("Applico Fix per le risorse A4j in firefox.");
                        chain.doFilter((ServletRequest)new HttpServletRequestWrapper(this, request){

                            public String getRequestURI() {
                                try {
                                    return URLDecoder.decode(super.getRequestURI(), "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    throw new IllegalStateException("Cannot decode request URI.", e);
                                }
                            }
                        }, (ServletResponse)response);
                    } else {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    }
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (Exception e) {
                log.debug("Browser non riconosciuto.");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: BrowserFilter");
        this.filterConfig = null;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
    }
}

