/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import javax.faces.application.ViewExpiredException;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.security.InputSanitizerProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityWrappedHttpServletRequest;
import org.openspcoop2.web.lib.mvc.security.SecurityWrappedHttpServletResponse;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class HeadersFilter
implements Filter {
    private static final String IL_PARAMETRO_0_CONTIENE_UN_VALORE_NON_VALIDO_1 = "Il parametro [{0}] contiene un valore non valido [{1}].";
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private FilterConfig filterConfig = null;
    private String cspHeaderValue;
    private String xContentTypeOptionsHeaderValue = null;
    private String xXssProtectionHeaderValue = null;
    private String xFrameOptionsHeaderValue = null;
    private String jQueryVersion = null;
    private String jQueryUiVersion = null;
    private static final String MSG_AUTH_ERRORE = "Autorizzazione negata.";
    public static final String JSP_ERRORE = "/commons/pages/welcome.jsf";
    public static final String JSP_LOGIN = "/public/login.jsf";
    public static final String MSG_ERRORE_KEY = "acclimHF";
    public static final String ACCLIM_KEY = "acclimflagHF";

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.jQueryVersion = this.filterConfig.getInitParameter("jquery_version");
        this.jQueryUiVersion = this.filterConfig.getInitParameter("jquery-ui_version");
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(log);
            this.cspHeaderValue = pddMonitorProperties.getCspHeaderValue();
            this.xContentTypeOptionsHeaderValue = pddMonitorProperties.getXContentTypeOptionsHeaderValue();
            this.xFrameOptionsHeaderValue = pddMonitorProperties.getXFrameOptionsHeaderValue();
            this.xXssProtectionHeaderValue = pddMonitorProperties.getXXssProtectionHeaderValue();
            Properties consoleSecurityConfiguration = pddMonitorProperties.getConsoleSecurityConfiguration();
            SecurityProperties.init((Properties)consoleSecurityConfiguration, (Logger)log);
            Properties consoleInputSanitizerConfiguration = pddMonitorProperties.getConsoleInputSanitizerConfiguration();
            InputSanitizerProperties.init((Properties)consoleInputSanitizerConfiguration, (Logger)log);
            Validatore.init((SecurityProperties)SecurityProperties.getInstance(), (InputSanitizerProperties)InputSanitizerProperties.getInstance(), (Logger)log);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        request.setAttribute("__jquery_version__", (Object)this.jQueryVersion);
        request.setAttribute("__jquery_ui_version__", (Object)this.jQueryUiVersion);
        SecurityWrappedHttpServletRequest seqReq = new SecurityWrappedHttpServletRequest(request, log);
        HttpSession session = seqReq.getSession();
        SecurityWrappedHttpServletResponse seqRes = new SecurityWrappedHttpServletResponse(response, log);
        String urlRichiesta = request.getServletPath();
        boolean utenteLoggato = Utility.isUtenteLoggato(session);
        Utility.setLoginBeanErrorMessage(session, HeadersFilter.class.getName(), null, null);
        try {
            seqReq.setAttribute("__jquery_version__", (Object)this.jQueryVersion);
            this.gestioneContentSecurityPolicy((HttpServletRequest)seqReq, (HttpServletResponse)seqRes);
            this.gestioneXContentTypeOptions((HttpServletResponse)seqRes);
            HeadersFilter.gestioneCacheControl((HttpServletRequest)seqReq, (HttpServletResponse)seqRes, log);
            this.validazioneSintatticaParametri(seqReq);
            if (urlRichiesta.indexOf("/pages/welcome.jsf") != -1) {
                boolean used;
                boolean bl = used = session.getAttribute(ACCLIM_KEY) != null && (Boolean)session.getAttribute(ACCLIM_KEY) != false;
                if (used) {
                    Utility.setLoginBeanErrorMessage(session, HeadersFilter.class.getName(), MSG_AUTH_ERRORE, HttpStatus.BAD_REQUEST.value());
                    session.setAttribute(ACCLIM_KEY, (Object)false);
                } else {
                    session.setAttribute(ACCLIM_KEY, (Object)false);
                    session.setAttribute(MSG_ERRORE_KEY, null);
                }
            }
            chain.doFilter((ServletRequest)seqReq, (ServletResponse)seqRes);
        }
        catch (ValidationException e) {
            log.error("Errore di validazione dei parametri: " + e.getMessage() + ", redirect verso pagina di errore: " + request.getContextPath() + JSP_ERRORE, (Throwable)e);
            if (utenteLoggato) {
                session.setAttribute(MSG_ERRORE_KEY, (Object)MSG_AUTH_ERRORE);
                session.setAttribute(ACCLIM_KEY, (Object)true);
                response.sendRedirect(request.getContextPath() + JSP_ERRORE);
            } else {
                response.sendRedirect(request.getContextPath() + JSP_LOGIN);
            }
        }
        catch (ServletException e) {
            Throwable rootCause = e.getRootCause();
            if (rootCause != null) {
                if (rootCause instanceof ViewExpiredException) {
                    Utility.setLoginBeanErrorMessage(session, HeadersFilter.class.getName(), null, HttpStatus.BAD_REQUEST.value());
                    log.debug("Rilevata ViewExpiredException: [{}]", (Object)rootCause.getMessage());
                    String redirPageUrl = request.getContextPath() + "/public/timeoutPage.jsf";
                    response.sendRedirect(redirPageUrl);
                }
                if (rootCause instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)rootCause;
                    throw runtimeException;
                }
                throw e;
            }
            throw e;
        }
    }

    private void validazioneSintatticaParametri(SecurityWrappedHttpServletRequest seqReq) throws ValidationException {
        Path fileName;
        String requestUri = Objects.requireNonNullElse(seqReq.getRequestURI(), "");
        Path path = Paths.get(requestUri, new String[0]);
        String lastPathSegment = requestUri;
        if (path != null && (fileName = path.getFileName()) != null) {
            lastPathSegment = fileName.toString();
        }
        Enumeration paramNames = seqReq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String parameterValueFiltrato = seqReq.getParameter(paramName);
            String parameterValueOriginale = Validatore.getInstance().getParametroOriginale((HttpServletRequest)seqReq, paramName);
            if (!ServletUtils.checkParametro((HttpServletRequest)seqReq, (String)paramName)) {
                throw new ValidationException(MessageFormat.format(IL_PARAMETRO_0_CONTIENE_UN_VALORE_NON_VALIDO_1, paramName, parameterValueOriginale));
            }
            if (paramName.equals("_csrf") && !ServletUtils.checkCsrfParameter((HttpServletRequest)seqReq, (String)paramName)) {
                throw new ValidationException(MessageFormat.format(IL_PARAMETRO_0_CONTIENE_UN_VALORE_NON_VALIDO_1, paramName, parameterValueOriginale));
            }
            log.trace("Verifica attacco Path traversal per il parametro [{}], valore [{}], lastpath [{}]", new Object[]{paramName, parameterValueFiltrato, lastPathSegment});
            if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato) || !lastPathSegment.equals(parameterValueFiltrato) && !("\\" + lastPathSegment).equals(parameterValueFiltrato) && !("/" + lastPathSegment).equals(parameterValueFiltrato)) continue;
            throw new ValidationException(MessageFormat.format(IL_PARAMETRO_0_CONTIENE_UN_VALORE_NON_VALIDO_1, paramName, parameterValueOriginale));
        }
    }

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: HeadersFilter");
        this.filterConfig = null;
    }

    private void gestioneContentSecurityPolicy(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        String nonceValue = HeadersFilter.leggiNonceValue(session);
        if (nonceValue == null) {
            String crsfCheck = request.getParameter("_crsfCheck");
            nonceValue = crsfCheck == null ? UUID.randomUUID().toString().replace("-", "") : crsfCheck;
            HeadersFilter.salvaNonceValueInSessione(session, nonceValue);
        }
        request.setAttribute("_csp_random_nonce", (Object)nonceValue);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.cspHeaderValue})) {
            response.setHeader("Content-Security-Policy", MessageFormat.format(this.cspHeaderValue, nonceValue, nonceValue));
        }
    }

    private static void gestioneCacheControl(HttpServletRequest request, HttpServletResponse response, Logger log) {
        String[] staticResourceDirs;
        String requestUri = request.getRequestURI();
        if (requestUri != null && ServletUtils.isStaticResource((String)requestUri, (String[])(staticResourceDirs = new String[]{"a4j", "resources", "images", "css", "fonts", "scripts"}))) {
            log.debug("Impostazione header Cache-Control per risorsa statica: {}", (Object)requestUri);
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
    }

    public static String leggiNonceValue(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute("_csp_random_nonce");
    }

    public static void salvaNonceValueInSessione(HttpSession session, String nonceValue) {
        if (session == null) {
            return;
        }
        session.setAttribute("_csp_random_nonce", (Object)nonceValue);
    }

    private void gestioneXContentTypeOptions(HttpServletResponse response) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.xFrameOptionsHeaderValue})) {
            response.setHeader("X-Frame-Options", this.xFrameOptionsHeaderValue);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.xXssProtectionHeaderValue})) {
            response.setHeader("X-XSS-Protection", this.xXssProtectionHeaderValue);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.xContentTypeOptionsHeaderValue})) {
            response.setHeader("X-Content-Type-Options", this.xContentTypeOptionsHeaderValue);
        }
    }
}

