/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.faces.application.ViewExpiredException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.credential.IPrincipalReader;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderException;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderFactory;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderType;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.SessionUtils;
import org.slf4j.Logger;

public class PrincipalFilter
implements Filter {
    public static final String REDIRECT_ERRORE_DEFAULT = "/public/error.jsf?principalShowForm=true";
    public static final String PRINCIPAL_ERROR_MSG = "principalErrorMsg";
    private Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String loginPage = "public/login.jsf";
    private String timeoutPage = "public/timeoutPage.jsf";
    private List<String> excludedPages = null;
    public static final String LOGIN_APPLICATION = "login.application";
    public static final String LOGIN_TIPO = "login.tipo";
    public static final String LOGIN_PROPR_PREFIX = "login.props.";
    private boolean loginApplication = true;
    private IPrincipalReader principalReader = null;
    private String loginUtenteNonAutorizzatoRedirectUrl = null;
    private String loginUtenteNonValidoRedirectUrl = null;
    private String loginErroreInternoRedirectUrl = null;
    private String loginSessioneScadutaRedirectUrl = null;
    private boolean loginOAuth2Enabled = false;

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.excludedPages = new ArrayList<String>();
        this.excludedPages.add("public");
        try {
            this.loginApplication = PddMonitorProperties.getInstance(this.log).isLoginApplication();
        }
        catch (UtilsException e) {
            this.loginApplication = true;
        }
        try {
            this.loginOAuth2Enabled = PddMonitorProperties.getInstance(this.log).isLoginOAuth2Enabled();
        }
        catch (UtilsException e) {
            // empty catch block
        }
        try {
            if (!this.loginApplication || this.loginOAuth2Enabled) {
                String loginTipo = PddMonitorProperties.getInstance(this.log).getLoginTipo();
                if (StringUtils.isEmpty((CharSequence)loginTipo)) {
                    loginTipo = PrincipalReaderType.PRINCIPAL.getValue();
                }
                this.principalReader = PrincipalReaderFactory.getReader((Logger)this.log, (String)loginTipo);
                Properties prop = PddMonitorProperties.getInstance(this.log).getLoginProperties();
                this.principalReader.init(new Object[]{prop});
                this.loginUtenteNonAutorizzatoRedirectUrl = PddMonitorProperties.getInstance(this.log).getLoginUtenteNonAutorizzatoRedirectUrl();
                this.loginUtenteNonValidoRedirectUrl = PddMonitorProperties.getInstance(this.log).getLoginUtenteNonValidoRedirectUrl();
                this.loginErroreInternoRedirectUrl = PddMonitorProperties.getInstance(this.log).getLoginErroreInternoRedirectUrl();
                this.loginSessioneScadutaRedirectUrl = PddMonitorProperties.getInstance(this.log).getLoginSessioneScadutaRedirectUrl();
            }
        }
        catch (PrincipalReaderException e) {
            PrincipalFilter.logError(this.log, "Impossibile caricare il principal reader: " + e.getMessage(), e);
            throw new ServletException((Throwable)e);
        }
        catch (UtilsException e) {
            PrincipalFilter.logError(this.log, "Impossibile leggere la configurazione della console: " + e.getMessage(), e);
            throw new ServletException((Throwable)e);
        }
        this.log.debug("Usa il principal per il controllo autorizzazione utente [{}]", (Object)(!this.loginApplication ? 1 : 0));
        this.excludedPages.add("a4j");
        this.excludedPages.add("images");
        this.excludedPages.add("css");
        this.excludedPages.add("scripts");
        this.excludedPages.add("fonts");
        this.excludedPages.add("/report/statistica");
        this.excludedPages.add("/report/configurazione");
        this.excludedPages.add("/oauth2/callback");
        this.excludedPages.add("/oauth2/user");
        this.excludedPages.add("/check");
    }

    private boolean isUtilizzaGestioneUtenzeApplication() {
        return this.loginApplication || this.loginOAuth2Enabled;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (this.isUtilizzaGestioneUtenzeApplication()) {
                if (this.isSessionControlRequiredForThisResource(httpServletRequest) && SessionUtils.isSessionInvalid(httpServletRequest)) {
                    HttpSession sessione = httpServletRequest.getSession(false);
                    Object userInfoObj = sessione.getAttribute("oauth2UserInfo");
                    if (userInfoObj == null) {
                        String redirPageUrl = httpServletRequest.getContextPath() + "/";
                        redirPageUrl = redirPageUrl + this.getRedirPage(httpServletRequest);
                        httpServletResponse.sendRedirect(redirPageUrl);
                        return;
                    }
                    String username = null;
                    try {
                        username = this.principalReader.getPrincipal(httpServletRequest);
                    }
                    catch (PrincipalReaderException e) {
                        this.log.error("Errore durante la lettura del principal: " + e.getMessage(), (Throwable)e);
                    }
                    this.log.debug("Username trovato: [{}]", (Object)username);
                    Object redirPageUrl = null;
                    if (username != null) {
                        redirPageUrl = httpServletRequest.getContextPath() + "/oauth2/user";
                    } else {
                        httpServletRequest.setAttribute("oauth2ErrorCode", (Object)401);
                        httpServletRequest.setAttribute("oauth2ErrorDetail", (Object)"Accesso OAuth2 negato");
                        redirPageUrl = StringUtils.isNotEmpty((CharSequence)this.loginUtenteNonAutorizzatoRedirectUrl) ? this.loginUtenteNonAutorizzatoRedirectUrl : httpServletRequest.getContextPath() + REDIRECT_ERRORE_DEFAULT;
                    }
                    httpServletResponse.sendRedirect((String)redirPageUrl);
                    return;
                }
            } else if (this.isSessionControlRequiredForThisResource(httpServletRequest)) {
                HttpSession sessione = httpServletRequest.getSession();
                LoginBean lb = (LoginBean)sessione.getAttribute("loginBean");
                this.log.debug("LoginBean trovato in sessione [{}]", (Object)(lb != null ? 1 : 0));
                if (lb == null) {
                    try {
                        FacesContext currentInstance = FacesContext.getCurrentInstance();
                        this.log.debug("FacesContext not null [{}]", (Object)(currentInstance != null ? 1 : 0));
                        if (currentInstance != null) {
                            ExternalContext ec = currentInstance.getExternalContext();
                            this.log.debug("ExternalContext not null [{}]", (Object)(ec != null ? 1 : 0));
                            if (ec != null) {
                                lb = (LoginBean)ec.getSessionMap().get("loginBean");
                                this.log.debug("LoginBean trovato in nella SessionMap JSF [{}]", (Object)(lb != null ? 1 : 0));
                            }
                        }
                    }
                    catch (Exception e) {
                        lb = null;
                    }
                }
                this.log.debug("Controllo Locale in corso ...");
                Locale loc = null;
                try {
                    if (FacesContext.getCurrentInstance() != null && FacesContext.getCurrentInstance().getViewRoot() != null) {
                        loc = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                    }
                    if (loc == null) {
                        loc = Locale.getDefault();
                    }
                }
                catch (Exception e) {
                    this.log.debug("Errore durante controllo Locale: " + e.getMessage(), (Throwable)e);
                    loc = Locale.getDefault();
                }
                this.log.debug("Locale trovato Valore[{}]", (Object)loc);
                if (lb == null) {
                    Locale localeRequest = request.getLocale();
                    this.log.debug("Locale trovato nella Request[{}]", (Object)localeRequest);
                    lb = new LoginBean(true);
                    lb.setLoggedIn(false);
                }
                this.log.debug("Login Bean Utente Loggato: [{}]", (Object)lb.isLoggedIn());
                if (!lb.isLoggedIn()) {
                    String username = null;
                    try {
                        username = this.principalReader.getPrincipal(httpServletRequest);
                    }
                    catch (PrincipalReaderException e) {
                        this.log.error("Errore durante la lettura del principal: " + e.getMessage(), (Throwable)e);
                    }
                    this.log.debug("Username trovato: [{}]", (Object)username);
                    if (username != null) {
                        lb.setApplicationLogin(false);
                        lb.setUsername(username);
                        String loginResult = lb.login();
                        if (loginResult.equals("login")) {
                            this.log.debug("Utente non autorizzato: {}", (Object)lb.getLoginErrorMessage());
                            lb.logout();
                            Object redirPageUrl = StringUtils.isNotEmpty((CharSequence)this.loginUtenteNonAutorizzatoRedirectUrl) ? this.loginUtenteNonAutorizzatoRedirectUrl : httpServletRequest.getContextPath() + REDIRECT_ERRORE_DEFAULT;
                            sessione.setAttribute(PRINCIPAL_ERROR_MSG, (Object)lb.getLoginErrorMessage());
                            httpServletResponse.sendRedirect((String)redirPageUrl);
                            return;
                        }
                        if (loginResult.equals("loginError")) {
                            this.log.debug("Errore durante il login: {}", (Object)lb.getLoginErrorMessage());
                            lb.logout();
                            Object redirPageUrl = StringUtils.isNotEmpty((CharSequence)this.loginErroreInternoRedirectUrl) ? this.loginErroreInternoRedirectUrl : httpServletRequest.getContextPath() + REDIRECT_ERRORE_DEFAULT;
                            sessione.setAttribute(PRINCIPAL_ERROR_MSG, (Object)lb.getLoginErrorMessage());
                            httpServletResponse.sendRedirect((String)redirPageUrl);
                            return;
                        }
                        if (loginResult.equals("loginUserInvalid")) {
                            this.log.debug("Errore durante il caricamento informazioni utente: {}", (Object)lb.getLoginErrorMessage());
                            lb.logout();
                            Object redirPageUrl = StringUtils.isNotEmpty((CharSequence)this.loginUtenteNonValidoRedirectUrl) ? this.loginUtenteNonValidoRedirectUrl : httpServletRequest.getContextPath() + REDIRECT_ERRORE_DEFAULT;
                            sessione.setAttribute(PRINCIPAL_ERROR_MSG, (Object)lb.getLoginErrorMessage());
                            httpServletResponse.sendRedirect((String)redirPageUrl);
                            return;
                        }
                        sessione = ServletUtils.sessionFixation((Logger)this.log, (HttpServletRequest)httpServletRequest, (HttpSession)sessione);
                        this.log.debug("Utente autorizzato");
                        sessione.setAttribute("loginBean", (Object)lb);
                        String redirPageUrl = httpServletRequest.getContextPath() + "/index.jsp";
                        httpServletResponse.sendRedirect(redirPageUrl);
                        return;
                    }
                    sessione.setAttribute("loginBean", null);
                    Object redirPageUrl = StringUtils.isNotEmpty((CharSequence)this.loginUtenteNonAutorizzatoRedirectUrl) ? this.loginUtenteNonAutorizzatoRedirectUrl : httpServletRequest.getContextPath() + "/pages/welcome.jsf";
                    this.log.debug("Username NULL redirect [{}]", redirPageUrl);
                    sessione.setAttribute(PRINCIPAL_ERROR_MSG, (Object)"Impossibile autenticare l'utente");
                    httpServletResponse.sendRedirect((String)redirPageUrl);
                    return;
                }
                this.log.debug("Login Bean Utente Loggato controllo validita' sessione...");
                boolean isSessionInvalid = SessionUtils.isSessionInvalid(httpServletRequest);
                if (isSessionInvalid) {
                    this.log.debug("Login Bean Utente Loggato controllo validita' sessione [invalida]");
                    lb.logout();
                    Object redirPageUrl = StringUtils.isNotEmpty((CharSequence)this.loginSessioneScadutaRedirectUrl) ? this.loginSessioneScadutaRedirectUrl : httpServletRequest.getContextPath() + "/index.jsp";
                    httpServletResponse.sendRedirect((String)redirPageUrl);
                    return;
                }
            }
        }
        try {
            filterChain.doFilter(request, response);
        }
        catch (ServletException e) {
            Throwable rootCause = e.getRootCause();
            if (rootCause != null) {
                if (rootCause instanceof ViewExpiredException) {
                    this.log.debug("Rilevata ViewExpiredException: [{}]", (Object)rootCause.getMessage());
                    if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                        String redirPageUrl = httpServletRequest.getContextPath() + "/public/timeoutPage.jsf";
                        httpServletResponse.sendRedirect(redirPageUrl);
                        return;
                    }
                    throw (ViewExpiredException)rootCause;
                }
                if (rootCause instanceof RuntimeException) {
                    throw (RuntimeException)rootCause;
                }
                throw e;
            }
            throw e;
        }
    }

    private boolean isSessionControlRequiredForThisResource(HttpServletRequest httpServletRequest) {
        String requestPath = httpServletRequest.getRequestURI();
        boolean controlRequired = true;
        if (!this.excludedPages.isEmpty()) {
            for (String page : this.excludedPages) {
                if (!Strings.CS.contains((CharSequence)requestPath, (CharSequence)page)) continue;
                controlRequired = false;
                break;
            }
        }
        return controlRequired;
    }

    private String getRedirPage(HttpServletRequest req) {
        String ctx = req.getContextPath();
        String reqUri = req.getRequestURI();
        String reqPage = Strings.CS.remove(reqUri, ctx);
        String res = "";
        res = "".equals(reqPage) || "/".equals(reqPage) || Strings.CS.contains((CharSequence)reqPage, (CharSequence)this.loginPage) ? this.loginPage : this.timeoutPage;
        return res;
    }

    public static void logError(Logger log, String message, Throwable t) {
        log.error(message, t);
    }
}

