/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.listener;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.Strings;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.utils.SessionUtils;
import org.slf4j.Logger;

public class SessionTimeoutFilter
implements Filter {
    private static Logger log = LoggerWrapperFactory.getLogger(SessionTimeoutFilter.class);
    private String loginPage = "pages/login.jsf";
    private String timeoutPage = "pages/timeoutPage.jsf";

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (this.isSessionControlRequiredForThisResource(httpServletRequest) && SessionUtils.isSessionInvalid(httpServletRequest)) {
                String redirPageUrl = httpServletRequest.getContextPath() + "/";
                redirPageUrl = redirPageUrl + this.getRedirPage(httpServletRequest);
                log.info("session is invalid! redirecting to page : {}", (Object)redirPageUrl);
                httpServletResponse.sendRedirect(redirPageUrl);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    private boolean isSessionControlRequiredForThisResource(HttpServletRequest httpServletRequest) {
        String requestPath = httpServletRequest.getRequestURI();
        boolean controlRequired = false;
        controlRequired = !Strings.CS.contains((CharSequence)requestPath, (CharSequence)this.timeoutPage) && !Strings.CS.contains((CharSequence)requestPath, (CharSequence)this.loginPage);
        return controlRequired;
    }

    private String getRedirPage(HttpServletRequest req) {
        String ctx = req.getContextPath();
        String reqUri = req.getRequestURI();
        String reqPage = Strings.CS.remove(reqUri, ctx);
        String res = "";
        res = "".equals(reqPage) || "/".equals(reqPage) || Strings.CS.contains((CharSequence)reqPage, (CharSequence)this.loginPage) ? this.loginPage : this.timeoutPage;
        return res;
    }
}

