/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.exporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.bean.SelectItem;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.transazioni.exporter.ColonnaExport;
import org.slf4j.Logger;

public class ColonnaExportManager {
    private static ColonnaExportManager instance = null;
    private Map<String, ColonnaExport> mapColonne = new HashMap<String, ColonnaExport>();
    private List<String> colonneNonSelezionabiliDallUtente = new ArrayList<String>();
    private List<String> ordineInserimentoColonne = new ArrayList<String>();
    private List<String> ordineInserimentoColonneCustomView = new ArrayList<String>();

    private static synchronized void init() {
        if (instance == null) {
            instance = new ColonnaExportManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColonnaExportManager getInstance() {
        if (instance != null) return instance;
        Class<ColonnaExportManager> clazz = ColonnaExportManager.class;
        synchronized (ColonnaExportManager.class) {
            ColonnaExportManager.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ColonnaExportManager() {
        boolean SHOW_IN_CUSTOM_VIEW = true;
        this._addColonna("colIdTransazione", "Id Transazione", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colProtocollo", "Profilo", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colEsito", "Esito", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colEsitoContesto", "Contesto", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTipoRichiesta", "Metodo HTTP", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIDCluster", "ID Cluster", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colEventi", "Eventi", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colStato", "Stato", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colPddRuolo", "Tipologia", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colPdd", "Dominio (ID)", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colSoggetto", "Dominio (Soggetto)", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataAccettazioneRich", "Data Accettazione Richiesta", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataIngRich", "Data Ingresso Richiesta in Ricezione", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataIngRichStream", "Data Ingresso Richiesta Acquisita", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataUscitaRich", "Data Uscita Richiesta in Spedizione", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataUscitaRichStream", "Data Uscita Richiesta Consegnata", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataAccettazioneRisposta", "Data Accettazione Risposta", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataInRisposta", "Data Ingresso Risposta in Ricezione", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataInRispostaStream", "Data Ingresso Risposta Acquisita", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataOutRisposta", "Data Uscita Risposta Consegnata", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataOutRispostaStream", "Data Uscita Risposta in Spedizione", !SHOW_IN_CUSTOM_VIEW);
        boolean latenzaPorta = true;
        try {
            latenzaPorta = PddMonitorProperties.getInstance((Logger)LoggerWrapperFactory.getLogger(ColonnaExportManager.class)).isTransazioniLatenzaPortaEnabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (latenzaPorta) {
            this._addColonna("colLatenzaPorta", "Latenza Gateway", SHOW_IN_CUSTOM_VIEW);
        }
        this._addColonna("colLatenzaServizio", "Tempo Risposta Servizio", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colLatenzaTotale", "Latenza Totale", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colCodiceRispostaIngresso", "Codice Risposta Ingresso", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colCodiceRispostaUscita", "Codice Risposta Uscita", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colRichIngrBytes", "Dimensione Ingresso Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colRichOutBytes", "Dimensione Uscita Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colRispIngrBytes", "Dimensione Ingresso Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colRispOutBytes", "Dimensione Uscita Riposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colFruitore", "Fruitore (Soggetto)", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIdFruitore", "Fruitore (Dominio)", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIndirizzoSoggettoFruitore", "Indirizzo Fruitore", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colErogatore", "Erogatore (Soggetto)", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIdErogatore", "Erogatore (Dominio)", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIndirizzoSoggettoErogatore", "Indirizzo Erogatore", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIDMessaggioRichiesta", "ID Messaggio Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIDMessaggioRisposta", "ID Messaggio Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataIDMsgRichiesta", "Data ID Messaggio Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDataIDMsgRisposta", "Data ID Messaggio Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colRuoloTransazione", "Ruolo Transazione", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colProfCollaborazioneOp2", "Profilo Collaborazione Op2", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colProfColl", "Profilo Collaborazione", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIDCollaborazione", "ID Conversazione", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colUriAccordoServizio", "Uri API", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTipoApi", "Tipo API", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTags", "Tags", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colServ", "API", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colAzione", "Azione", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIDApplicativo", "ID Applicativo Richiesta", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIDApplicativoRisp", "ID Applicativo Risposta", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colServizioApplicativo", "Applicativo", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colServizioApplicativoErogatore", "Applicativo Erogatore", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colServizioApplicativoFruitore", "Applicativo Fruitore", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colFaultIntegrazione", "Fault Integrazione", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colFaultCooperazione", "Fault Cooperazione", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIdAsincrono", "Id Asincrono", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colServizioCorrelato", "Servizio Correlato", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colHeaderProtocolloRichiesta", "Header Protocollo Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDigestRichiesta", "Digest Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colProtocolloExtInfoRichiesta", "Protocollo Ext Info Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colHeaderProtocolloRisposta", "Header Protocollo Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDigestRisposta", "Digest Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colProtocolloExtInfoRisposta", "Protocollo Ext Info Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colOperazioneIm", "Operazione Integration Manager", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colLocationRichiesta", "Location Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colLocationRisposta", "Location Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colNomePorta", "Nome Porta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colCredenziali", "Credenziali", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colLocationConnettore", "Location Connettore", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colUrlInvocazione", "Url Invocazione", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDuplicatiRichiesta", "Duplicati Richiesta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDuplicatiRisposta", "Duplicati Risposta", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colIndirizzoClient", "Indirizzo Client", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colXForwardedFor", "X-Forwarded-For", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colRichiedente", "Richiedente", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colDettaglioErrore", "Dettaglio", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTokenIssuer", "Token Issuer", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTokenSubject", "Token Subject", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTokenClientId", "Token ClientId", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTokenUsername", "Token Username", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTokenEMail", "Token eMail", !SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTokenClientApplication", "Token Applicativo Client", SHOW_IN_CUSTOM_VIEW);
        this._addColonna("colTokenClientOrganization", "Token Applicativo Client (Soggetto)", SHOW_IN_CUSTOM_VIEW);
    }

    private void _addColonna(String key, String label, boolean showInCustomView) {
        this.addColonna(key, label, false);
        if (showInCustomView) {
            this.ordineInserimentoColonneCustomView.add(key);
        }
    }

    public void addColonna(String key, String label) {
        this.addColonna(key, label, false);
    }

    public void addColonna(String key, ColonnaExport value) {
        this.addColonna(key, value, false);
    }

    public void addColonna(String key, String label, boolean escludi) {
        this.mapColonne.put(key, new ColonnaExport(key, label, false));
        this.ordineInserimentoColonne.add(key);
        if (escludi) {
            this.colonneNonSelezionabiliDallUtente.add(key);
        }
    }

    public void addColonna(String key, String label, boolean visibile, boolean escludi) {
        this.mapColonne.put(key, new ColonnaExport(key, label, visibile));
        this.ordineInserimentoColonne.add(key);
        if (escludi) {
            this.colonneNonSelezionabiliDallUtente.add(key);
        }
    }

    public void addColonna(String key, ColonnaExport value, boolean escludi) {
        this.mapColonne.put(key, value);
        this.ordineInserimentoColonne.add(key);
        if (escludi) {
            this.colonneNonSelezionabiliDallUtente.add(key);
        }
    }

    public List<SelectItem> getColonne() {
        ArrayList<SelectItem> colonne = new ArrayList<SelectItem>();
        for (String key : this.ordineInserimentoColonne) {
            if (this.colonneNonSelezionabiliDallUtente.contains(key)) continue;
            colonne.add(new SelectItem(key, this.mapColonne.get(key).getLabel()));
        }
        return colonne;
    }

    public List<String> getKeysColonneTracce() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("colTracciaRichiesta");
        lst.add("colTracciaRisposta");
        return lst;
    }

    public List<String> getKeysColonneDiagnostici() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("colDiagnostici");
        return lst;
    }

    public List<String> getKeysColonne() {
        ArrayList<String> lst = new ArrayList<String>();
        for (String string : this.ordineInserimentoColonne) {
            if (this.colonneNonSelezionabiliDallUtente.contains(string)) continue;
            lst.add(string);
        }
        return lst;
    }

    public List<String> getKeysColonneCustomView() {
        ArrayList<String> lst = new ArrayList<String>();
        for (String string : this.ordineInserimentoColonneCustomView) {
            lst.add(string);
        }
        return lst;
    }

    public boolean containsColonna(String key) {
        return this.mapColonne.containsKey(key);
    }

    public ColonnaExport getColonna(String key) {
        if (this.containsColonna(key)) {
            return this.mapColonne.get(key);
        }
        return null;
    }
}

