/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openspcoop2.core.transazioni.TransazioneExport;
import org.openspcoop2.core.transazioni.constants.DeleteState;
import org.openspcoop2.core.transazioni.constants.ExportState;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticSerializer;
import org.openspcoop2.protocol.basic.tracciamento.TracciaSerializer;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiException;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Printer;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.converter.DurataConverter;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.report.Templates;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.core.manifest.RuoloType;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniExportService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.ColonnaExport;
import org.openspcoop2.web.monitor.transazioni.exporter.ColonnaExportManager;
import org.openspcoop2.web.monitor.transazioni.exporter.ExportException;
import org.openspcoop2.web.monitor.transazioni.exporter.ExporterCsvProperties;
import org.openspcoop2.web.monitor.transazioni.exporter.IExporter;
import org.slf4j.Logger;

public class SingleCsvFileExporter
implements IExporter {
    private static final String ERRORE_EXPORT = "Si \u00e8 verificato un errore durante l'esportazione della transazione con id:";
    private static final String ERRORE_EXPORT_FILE = "Errore durante esportazione su file";
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private boolean exportTracce = false;
    private boolean exportTracceUseProtocolSerialization = false;
    private boolean exportDiagnostici = false;
    private boolean exportDiagnosticiUseProtocolSerialization = false;
    private boolean exportContenuti = false;
    private boolean enableHeaderInfo = false;
    private boolean mimeThrowExceptionIfNotFound = false;
    private boolean abilitaMarcamentoTemporale = false;
    private String formato = null;
    private List<String> colonneSelezionate = null;
    private boolean useCount = true;
    private boolean dataUscitaRispostaValorizzataDopoSpedizioneRisposta = false;
    private ITransazioniService transazioniService;
    private ITracciaDriver tracciamentoService;
    private IDiagnosticDriver diagnosticiService;
    private ITransazioniExportService transazioniExporterService;
    private String fileName = null;
    private OutputStream outStream = null;
    private SimpleDateFormat sdfDataTransazioni = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSXXX");

    private static void logDebug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    private static void logInfo(String msg) {
        if (log != null) {
            log.info(msg);
        }
    }

    private static void logError(String msg, Exception e) {
        if (log != null) {
            log.error(msg, (Throwable)e);
        }
    }

    private String formatDate(Date date) {
        String s = this.sdfDataTransazioni.format(date);
        return s.replace(" ", "T");
    }

    private SingleCsvFileExporter(ExporterCsvProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) throws Exception {
        this.enableHeaderInfo = properties.isEnableHeaderInfo();
        this.exportTracce = properties.isExportTracce();
        this.exportTracceUseProtocolSerialization = properties.isExportTracceUseProtocolSerialization();
        this.exportDiagnostici = properties.isExportDiagnostici();
        this.exportDiagnosticiUseProtocolSerialization = properties.isExportDiagnosticiUseProtocolSerialization();
        this.exportContenuti = properties.isExportContenuti();
        this.mimeThrowExceptionIfNotFound = properties.isMimeThrowExceptionIfNotFound();
        this.abilitaMarcamentoTemporale = properties.isAbilitaMarcamentoTemporaleEsportazione();
        this.formato = properties.getFormato();
        this.colonneSelezionate = properties.getColonneSelezionate();
        this.useCount = properties.isUseCount();
        PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
        this.dataUscitaRispostaValorizzataDopoSpedizioneRisposta = govwayMonitorProperties.isDataUscitaRispostaUseDateAfterResponseSent();
        this.tracciamentoService = tracciamentoService;
        this.transazioniService = transazioniService;
        this.diagnosticiService = diagnosticiService;
        this.transazioniExporterService = transazioniExport;
        SingleCsvFileExporter.logInfo("Single File Exporter inizializzato:");
        SingleCsvFileExporter.logInfo("\t -esportazione Tracce abilitata (useProtocolSerialization:" + this.exportTracceUseProtocolSerialization + "): " + this.exportTracce);
        SingleCsvFileExporter.logInfo("\t -esportazione Diagnostici abilitata (exportDiagnosticiUseProtocolSerialization:" + this.exportDiagnosticiUseProtocolSerialization + "): " + this.exportDiagnostici);
        SingleCsvFileExporter.logInfo("\t -esportazione Contenuti abilitata: " + this.exportContenuti);
        SingleCsvFileExporter.logInfo("\t -enable header info abilitato: " + this.enableHeaderInfo);
        SingleCsvFileExporter.logInfo("\t -formato scelto: " + this.formato);
        SingleCsvFileExporter.logInfo("\t -usa count: " + this.useCount);
        if (!this.useCount) {
            SingleCsvFileExporter.logInfo("\t -numero massimo elementi esportati: " + Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES);
        }
        SingleCsvFileExporter.logInfo("\t -MimeType handling (mime.throwExceptionIfMappingNotFound):" + this.mimeThrowExceptionIfNotFound);
    }

    public SingleCsvFileExporter(OutputStream outStream, ExporterCsvProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) throws Exception {
        this(properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport);
        this.outStream = outStream;
    }

    public SingleCsvFileExporter(File destFile, ExporterCsvProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) throws Exception {
        this(properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport);
        this.outStream = new FileOutputStream(destFile);
        this.fileName = destFile.getName();
        SingleCsvFileExporter.logInfo("\n\t -Esportazione su file:" + destFile.getAbsolutePath());
    }

    public SingleCsvFileExporter(String pathToFile, ExporterCsvProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) throws Exception {
        this(new File(pathToFile), properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport);
    }

    private void popolaDataSourceExport(List<List<String>> datasource, List<TransazioneBean> transazioni) throws ExportException {
        for (TransazioneBean t : transazioni) {
            datasource.add(this.getLine(t));
        }
    }

    private void scriviDiagnostici(TransazioneBean t, List<String> oneLine) throws ExportException {
        if (this.exportDiagnostici) {
            try {
                FiltroRicercaDiagnosticiConPaginazione filter = new FiltroRicercaDiagnosticiConPaginazione();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("id_transazione", t.getIdTransazione());
                filter.setProperties(properties);
                List list = this.diagnosticiService.getMessaggiDiagnostici(filter);
                StringBuilder sbDiagnostici = new StringBuilder();
                Object tail = null;
                for (int j = 0; j < list.size(); ++j) {
                    Object head;
                    XMLRootElement xmlRootElement;
                    MsgDiagnostico msg = (MsgDiagnostico)list.get(j);
                    String newLine = j > 0 ? "\n\n" : "";
                    IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(msg.getProtocollo());
                    Object diagnosticoBuilder = null;
                    diagnosticoBuilder = this.exportDiagnosticiUseProtocolSerialization ? pf.createDiagnosticSerializer() : new DiagnosticSerializer(pf);
                    if (j == 0 && (xmlRootElement = diagnosticoBuilder.getXMLRootElement()) != null && (head = xmlRootElement.getAsStringStartTag()) != null && !"".equals(head)) {
                        head = (String)head + "\n\n";
                        sbDiagnostici.append((String)head);
                        tail = xmlRootElement.getAsStringEndTag();
                        if (tail != null && !"".equals(tail)) {
                            tail = "\n\n" + (String)tail;
                        }
                    }
                    diagnosticoBuilder.setOmitXmlDeclaration(true);
                    String msgDiagnostico = diagnosticoBuilder.toString(msg, TipoSerializzazione.DEFAULT);
                    sbDiagnostici.append(newLine).append(msgDiagnostico);
                }
                if (tail != null && !"".equals(tail)) {
                    sbDiagnostici.append((String)tail);
                }
                oneLine.add(sbDiagnostici.toString());
            }
            catch (DriverMsgDiagnosticiException e) {
                String msg = ERRORE_EXPORT + t.getIdTransazione();
                msg = msg + " Non sono riuscito a creare il file diagnostici.xml (" + e.getMessage() + ")";
                throw new ExportException(msg, e);
            }
            catch (DriverMsgDiagnosticiNotFoundException e) {
                oneLine.add("");
            }
            catch (ProtocolException e) {
                String msg = ERRORE_EXPORT + t.getIdTransazione();
                msg = msg + " Non sono riuscito a creare il file diagnostici.xml (" + e.getMessage() + ")";
                throw new ExportException(msg, e);
            }
        }
    }

    private void scriviTraccia(TransazioneBean t, List<String> oneLine, boolean isRisposta) throws ExportException {
        if (this.exportTracce) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("id_transazione", t.getIdTransazione());
            Traccia tracciaRichiesta = null;
            Traccia tracciaRisposta = null;
            ArrayList<Traccia> tracce = new ArrayList<Traccia>();
            try {
                if (!isRisposta) {
                    tracciaRichiesta = this.tracciamentoService.getTraccia(RuoloMessaggio.RICHIESTA, properties);
                    tracce.add(tracciaRichiesta);
                }
            }
            catch (DriverTracciamentoException e) {
                String msg = ERRORE_EXPORT + t.getIdTransazione();
                msg = msg + " Non sono riuscito a recuperare la traccia di richiesta (" + e.getMessage() + ")";
                throw new ExportException(msg, e);
            }
            catch (DriverTracciamentoNotFoundException e) {
                // empty catch block
            }
            try {
                if (isRisposta) {
                    tracciaRisposta = this.tracciamentoService.getTraccia(RuoloMessaggio.RISPOSTA, properties);
                    tracce.add(tracciaRisposta);
                }
            }
            catch (DriverTracciamentoException e) {
                String msg = ERRORE_EXPORT + t.getIdTransazione();
                msg = msg + " Non sono riuscito a recuperare la traccia di risposta (" + e.getMessage() + ")";
                throw new ExportException(msg, e);
            }
            catch (DriverTracciamentoNotFoundException e) {
                // empty catch block
            }
            if (!tracce.isEmpty()) {
                try {
                    for (int j = 0; j < tracce.size(); ++j) {
                        Traccia tr = (Traccia)tracce.get(j);
                        IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tr.getProtocollo());
                        Object tracciaBuilder = null;
                        tracciaBuilder = this.exportTracceUseProtocolSerialization ? pf.createTracciaSerializer() : new TracciaSerializer(pf);
                        try {
                            tracciaBuilder.setOmitXmlDeclaration(true);
                            String traccia = tracciaBuilder.toString(tr, TipoSerializzazione.DEFAULT);
                            oneLine.add(traccia);
                            continue;
                        }
                        catch (ProtocolException e) {
                            String idTransazione = t.getIdTransazione();
                            String tipoTraccia = tr.getTipoMessaggio().getTipo();
                            String bustaAsString = tr.getBustaAsString();
                            String messaggioErrore = e.getMessage();
                            StringBuilder sb = new StringBuilder(0);
                            sb.append("Impossibile leggere il contenuto della traccia:").append("\n");
                            sb.append("ID Transazione: ").append(idTransazione).append("\n");
                            sb.append("Tipo Traccia: ").append(tipoTraccia).append("\n");
                            sb.append("Busta: \n").append(bustaAsString).append("\n\n");
                            sb.append("Errore: \n").append(messaggioErrore).append("\n");
                            oneLine.add(sb.toString());
                        }
                    }
                }
                catch (ProtocolException e) {
                    String msg = ERRORE_EXPORT + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a creare il file tracce.xml (" + e.getMessage() + ")";
                    throw new ExportException(msg, e);
                }
            } else {
                oneLine.add("");
            }
        }
    }

    private List<String> getLine(TransazioneBean t) throws ExportException {
        ArrayList<String> oneLine = new ArrayList<String>();
        try {
            EsitoUtils esitoUtils = new EsitoUtils(log, t.getProtocollo());
            for (String keyColonna : this.colonneSelezionate) {
                if (keyColonna.equals("colAzione")) {
                    if (!t.getPddRuolo().equals((Object)PddRuolo.INTEGRATION_MANAGER)) {
                        if (StringUtils.isNotEmpty((CharSequence)t.getAzione())) {
                            oneLine.add(t.getAzione());
                            continue;
                        }
                        oneLine.add("");
                        continue;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)t.getOperazioneIm())) {
                        oneLine.add("[IM] " + t.getOperazioneIm());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIDCluster")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getClusterId())) {
                        oneLine.add(t.getClusterId());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colCredenziali")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getCredenziali())) {
                        oneLine.add(t.getCredenziali());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataIDMsgRichiesta")) {
                    if (t.getDataIdMsgRichiesta() != null) {
                        oneLine.add(this.formatDate(t.getDataIdMsgRichiesta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataIDMsgRisposta")) {
                    if (t.getDataIdMsgRisposta() != null) {
                        oneLine.add(this.formatDate(t.getDataIdMsgRisposta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataAccettazioneRich")) {
                    if (t.getDataAccettazioneRichiesta() != null) {
                        oneLine.add(this.formatDate(t.getDataAccettazioneRichiesta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataIngRich")) {
                    if (t.getDataIngressoRichiesta() != null) {
                        oneLine.add(this.formatDate(t.getDataIngressoRichiesta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataIngRichStream")) {
                    if (t.getDataIngressoRichiestaStream() != null) {
                        oneLine.add(this.formatDate(t.getDataIngressoRichiestaStream()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataAccettazioneRisposta")) {
                    if (t.getDataAccettazioneRisposta() != null) {
                        oneLine.add(this.formatDate(t.getDataAccettazioneRisposta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataInRisposta")) {
                    if (t.getDataIngressoRisposta() != null) {
                        oneLine.add(this.formatDate(t.getDataIngressoRisposta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataInRispostaStream")) {
                    if (t.getDataIngressoRispostaStream() != null) {
                        oneLine.add(this.formatDate(t.getDataIngressoRispostaStream()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataUscitaRich")) {
                    if (t.getDataUscitaRichiesta() != null) {
                        oneLine.add(this.formatDate(t.getDataUscitaRichiesta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataUscitaRichStream")) {
                    if (t.getDataUscitaRichiestaStream() != null) {
                        oneLine.add(this.formatDate(t.getDataUscitaRichiestaStream()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataOutRisposta")) {
                    if (this.dataUscitaRispostaValorizzataDopoSpedizioneRisposta) {
                        if (t.getDataUscitaRispostaStream() != null) {
                            oneLine.add(this.formatDate(t.getDataUscitaRispostaStream()));
                            continue;
                        }
                        oneLine.add("");
                        continue;
                    }
                    if (t.getDataUscitaRisposta() != null) {
                        oneLine.add(this.formatDate(t.getDataUscitaRisposta()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDataOutRispostaStream")) {
                    if (this.dataUscitaRispostaValorizzataDopoSpedizioneRisposta) {
                        if (t.getDataUscitaRisposta() != null) {
                            oneLine.add(this.formatDate(t.getDataUscitaRisposta()));
                            continue;
                        }
                        oneLine.add("");
                        continue;
                    }
                    if (t.getDataUscitaRispostaStream() != null) {
                        oneLine.add(this.formatDate(t.getDataUscitaRispostaStream()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDiagnostici")) {
                    if (this.exportDiagnostici) {
                        this.scriviDiagnostici(t, oneLine);
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDigestRichiesta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getDigestRichiesta())) {
                        oneLine.add(t.getDigestRichiesta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDigestRisposta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getDigestRisposta())) {
                        oneLine.add(t.getDigestRisposta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDuplicatiRichiesta")) {
                    if (t.getDuplicatiRichiesta() >= 0) {
                        oneLine.add("" + t.getDuplicatiRichiesta());
                        continue;
                    }
                    oneLine.add("Duplicata");
                    continue;
                }
                if (keyColonna.equals("colDuplicatiRisposta")) {
                    if (t.getDuplicatiRisposta() >= 0) {
                        oneLine.add("" + t.getDuplicatiRisposta());
                        continue;
                    }
                    oneLine.add("Duplicata");
                    continue;
                }
                if (keyColonna.equals("colEsito")) {
                    oneLine.add(esitoUtils.getEsitoLabelFromValue((Object)t.getEsito(), false));
                    continue;
                }
                if (keyColonna.equals("colEsitoContesto")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getEsitoContesto())) {
                        oneLine.add(esitoUtils.getEsitoContestoLabelFromValue((Object)t.getEsitoContesto()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colEventi")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getEventiGestione())) {
                        oneLine.add(t.getEventiGestione());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colFaultCooperazione")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getFaultCooperazione())) {
                        oneLine.add(t.getFaultCooperazionePretty());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colFaultIntegrazione")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getFaultIntegrazione())) {
                        oneLine.add(t.getFaultIntegrazionePretty());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colHeaderProtocolloRichiesta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getHeaderProtocolloRichiesta())) {
                        oneLine.add(t.getHeaderProtocolloRichiesta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colHeaderProtocolloRisposta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getHeaderProtocolloRisposta())) {
                        oneLine.add(t.getHeaderProtocolloRisposta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIdAsincrono")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdAsincrono())) {
                        oneLine.add(t.getIdAsincrono());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIDCollaborazione")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdCollaborazione())) {
                        oneLine.add(t.getIdCollaborazione());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIDApplicativo")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdCorrelazioneApplicativa())) {
                        oneLine.add(t.getIdCorrelazioneApplicativa());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIDApplicativoRisp")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdCorrelazioneApplicativaRisposta())) {
                        oneLine.add(t.getIdCorrelazioneApplicativaRisposta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIDMessaggioRichiesta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdMessaggioRichiesta())) {
                        oneLine.add(t.getIdMessaggioRichiesta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIDMessaggioRisposta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdMessaggioRisposta())) {
                        oneLine.add(t.getIdMessaggioRisposta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIdErogatore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdportaSoggettoErogatore())) {
                        oneLine.add(t.getIdportaSoggettoErogatore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIdFruitore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdportaSoggettoFruitore())) {
                        oneLine.add(t.getIdportaSoggettoFruitore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIdTransazione")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIdTransazione())) {
                        oneLine.add(t.getIdTransazione());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIndirizzoSoggettoErogatore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIndirizzoSoggettoErogatore())) {
                        oneLine.add(t.getIndirizzoSoggettoErogatore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIndirizzoSoggettoFruitore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getIndirizzoSoggettoFruitore())) {
                        oneLine.add(t.getIndirizzoSoggettoFruitore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colLatenzaPorta")) {
                    if (t.getLatenzaPorta() != null) {
                        long v = t.getLatenzaPorta();
                        if (v >= 0L) {
                            oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)t.getLatenzaPorta(), (boolean)true));
                            continue;
                        }
                        oneLine.add("N.D.");
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colLatenzaServizio")) {
                    if (t.getLatenzaServizio() != null) {
                        long v = t.getLatenzaServizio();
                        if (v >= 0L) {
                            oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)t.getLatenzaServizio(), (boolean)true));
                            continue;
                        }
                        oneLine.add("N.D.");
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colLatenzaTotale")) {
                    if (t.getLatenzaTotale() != null) {
                        long v = t.getLatenzaTotale();
                        if (v >= 0L) {
                            oneLine.add(DurataConverter.convertSystemTimeIntoString_millisecondi((long)t.getLatenzaTotale(), (boolean)true));
                            continue;
                        }
                        oneLine.add("N.D.");
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colLocationConnettore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getLocationConnettore())) {
                        oneLine.add(t.getLocationConnettore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colLocationRichiesta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getLocationRichiesta())) {
                        oneLine.add(t.getLocationRichiesta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colLocationRisposta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getLocationRisposta())) {
                        oneLine.add(t.getLocationRisposta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colNomePorta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getNomePorta())) {
                        oneLine.add(t.getNomePorta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colOperazioneIm")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getOperazioneIm())) {
                        oneLine.add(t.getOperazioneIm());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colPdd")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getPddCodice())) {
                        oneLine.add(t.getPddCodice());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colPddRuolo")) {
                    if (t.getPddRuolo() != null) {
                        switch (t.getPddRuolo()) {
                            case APPLICATIVA: {
                                oneLine.add("Erogazione");
                                break;
                            }
                            case DELEGATA: {
                                oneLine.add("Fruizione");
                                break;
                            }
                            case INTEGRATION_MANAGER: {
                                oneLine.add("I.M.");
                                break;
                            }
                            case ROUTER: {
                                oneLine.add("Router");
                            }
                        }
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colSoggetto")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getPddNomeSoggetto())) {
                        oneLine.add(t.getSoggettoPdd());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colProfCollaborazioneOp2")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getProfiloCollaborazioneOp2())) {
                        oneLine.add(t.getProfiloCollaborazioneOp2());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colProfColl")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getProfiloCollaborazioneProt())) {
                        oneLine.add(t.getProfiloCollaborazioneProt());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colProtocollo")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getProtocollo())) {
                        oneLine.add(t.getProtocolloLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colProtocolloExtInfoRichiesta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getProtocolloExtInfoRichiesta())) {
                        oneLine.add(t.getProtocolloExtInfoRichiesta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colProtocolloExtInfoRisposta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getProtocolloExtInfoRisposta())) {
                        oneLine.add(t.getProtocolloExtInfoRisposta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colRichIngrBytes")) {
                    if (t.getRichiestaIngressoBytes() != null) {
                        oneLine.add(Utility.fileSizeConverter((Number)t.getRichiestaIngressoBytes()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colRichOutBytes")) {
                    if (t.getRichiestaUscitaBytes() != null) {
                        oneLine.add(Utility.fileSizeConverter((Number)t.getRichiestaUscitaBytes()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colRispIngrBytes")) {
                    if (t.getRispostaIngressoBytes() != null) {
                        oneLine.add(Utility.fileSizeConverter((Number)t.getRispostaIngressoBytes()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colRispOutBytes")) {
                    if (t.getRispostaUscitaBytes() != null) {
                        oneLine.add(Utility.fileSizeConverter((Number)t.getRispostaUscitaBytes()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colRuoloTransazione")) {
                    if (t.getRuoloTransazione() == -1) {
                        oneLine.add(RuoloType.SCONOSCIUTO.toString());
                        continue;
                    }
                    if (t.getRuoloTransazione() == 1) {
                        oneLine.add(RuoloType.INVOCAZIONE_ONEWAY.toString());
                        continue;
                    }
                    if (t.getRuoloTransazione() == 2) {
                        oneLine.add(RuoloType.INVOCAZIONE_SINCRONA.toString());
                        continue;
                    }
                    if (t.getRuoloTransazione() == 3) {
                        oneLine.add(RuoloType.INVOCAZIONE_ASINCRONA_SIMMETRICA.toString());
                        continue;
                    }
                    if (t.getRuoloTransazione() == 4) {
                        oneLine.add(RuoloType.RISPOSTA_ASINCRONA_SIMMETRICA.toString());
                        continue;
                    }
                    if (t.getRuoloTransazione() == 5) {
                        oneLine.add(RuoloType.INVOCAZIONE_ASINCRONA_ASIMMETRICA.toString());
                        continue;
                    }
                    if (t.getRuoloTransazione() == 6) {
                        oneLine.add(RuoloType.RICHIESTA_STATO_ASINCRONA_ASIMMETRICA.toString());
                        continue;
                    }
                    if (t.getRuoloTransazione() == 7) {
                        oneLine.add(RuoloType.INTEGRATION_MANAGER.toString());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colServ")) {
                    if (t.getPddRuolo().equals((Object)PddRuolo.INTEGRATION_MANAGER)) {
                        if (StringUtils.isNotEmpty((CharSequence)t.getServizioApplicativoErogatore())) {
                            oneLine.add(t.getServizioApplicativoErogatore());
                            continue;
                        }
                        oneLine.add("");
                        continue;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)t.getNomeServizio())) {
                        oneLine.add(NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)t.getProtocollo(), (String)t.getTipoServizio(), (String)t.getNomeServizio(), (Integer)t.getVersioneServizio()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colServizioApplicativo")) {
                    if (t.getPddRuolo().equals((Object)PddRuolo.DELEGATA)) {
                        if (StringUtils.isNotEmpty((CharSequence)t.getServizioApplicativoFruitore())) {
                            oneLine.add(t.getServizioApplicativoFruitore());
                            continue;
                        }
                        oneLine.add("");
                        continue;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)t.getServizioApplicativoErogatore())) {
                        oneLine.add(t.getServizioApplicativoErogatore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colServizioApplicativoErogatore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getServizioApplicativoErogatore())) {
                        oneLine.add(t.getServizioApplicativoErogatore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colServizioApplicativoFruitore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getServizioApplicativoFruitore())) {
                        oneLine.add(t.getServizioApplicativoFruitore());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colServizioCorrelato")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getNomeServizioCorrelato())) {
                        oneLine.add(t.getTipoServizioCorrelato() + "/" + t.getNomeServizioCorrelato());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colErogatore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getNomeSoggettoErogatore())) {
                        oneLine.add(NamingUtils.getLabelSoggetto((String)t.getProtocollo(), (String)t.getTipoSoggettoErogatore(), (String)t.getNomeSoggettoErogatore()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colFruitore")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getNomeSoggettoFruitore())) {
                        oneLine.add(NamingUtils.getLabelSoggetto((String)t.getProtocollo(), (String)t.getTipoSoggettoFruitore(), (String)t.getNomeSoggettoFruitore()));
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colStato")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getStato())) {
                        oneLine.add(t.getStato());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTracciaRichiesta")) {
                    if (this.exportTracce) {
                        this.scriviTraccia(t, oneLine, false);
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTracciaRisposta")) {
                    if (this.exportTracce) {
                        this.scriviTraccia(t, oneLine, true);
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colUriAccordoServizio")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getUriAccordoServizio())) {
                        oneLine.add(t.getUriAccordoServizio());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTipoApi")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTipoApiLabel())) {
                        oneLine.add(t.getTipoApiLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTags")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getGruppi())) {
                        oneLine.add(t.getGruppi());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colUrlInvocazione")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getUrlInvocazione())) {
                        oneLine.add(t.getUrlInvocazione());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colIndirizzoClient")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getSocketClientAddress())) {
                        oneLine.add(t.getSocketClientAddress());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colXForwardedFor")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTransportClientAddress())) {
                        oneLine.add(t.getTransportClientAddress());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTipoRichiesta")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTipoRichiesta())) {
                        oneLine.add(t.getTipoRichiesta());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colCodiceRispostaIngresso")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getCodiceRispostaIngresso())) {
                        oneLine.add(t.getCodiceRispostaIngresso());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colCodiceRispostaUscita")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getCodiceRispostaUscita())) {
                        oneLine.add(t.getCodiceRispostaUscita());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colRichiedente")) {
                    String richiedente = t.getRichiedente();
                    if (StringUtils.isNotEmpty((CharSequence)richiedente)) {
                        oneLine.add(richiedente);
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colDettaglioErrore")) {
                    String dettaglio = t.getDettaglioErrore();
                    if (StringUtils.isNotEmpty((CharSequence)dettaglio)) {
                        oneLine.add(dettaglio);
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTokenIssuer")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTokenIssuerLabel())) {
                        oneLine.add(t.getTokenIssuerLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTokenSubject")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTokenSubjectLabel())) {
                        oneLine.add(t.getTokenSubjectLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTokenClientId")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTokenClientIdLabel())) {
                        oneLine.add(t.getTokenClientIdLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTokenUsername")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTokenUsernameLabel())) {
                        oneLine.add(t.getTokenUsernameLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTokenEMail")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTokenMailLabel())) {
                        oneLine.add(t.getTokenMailLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTokenClientApplication")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTokenClientNameLabel())) {
                        oneLine.add(t.getTokenClientNameLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                if (keyColonna.equals("colTokenClientOrganization")) {
                    if (StringUtils.isNotEmpty((CharSequence)t.getTokenClientOrganizationNameLabel())) {
                        oneLine.add(t.getTokenClientOrganizationNameLabel());
                        continue;
                    }
                    oneLine.add("");
                    continue;
                }
                throw new ExportException("Colonna [" + keyColonna + "] non definita.");
            }
        }
        catch (ExportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExportException("Errore durante la creazione della entry per la transazione ID [" + t.getIdTransazione() + "].", e);
        }
        return oneLine;
    }

    public void export(List<String> idtransazioni) throws ExportException {
        Date startTime = Calendar.getInstance().getTime();
        TransazioneExport te = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
            SingleCsvFileExporter.logDebug("Avvio esportazione ...");
            log.debug("Inizio esportazione alle: {}", (Object)time.format(startTime));
            ArrayList<TransazioneBean> transazioni = new ArrayList<TransazioneBean>();
            for (String id : idtransazioni) {
                transazioni.add(this.transazioniService.findByIdTransazione(id));
            }
            if (this.abilitaMarcamentoTemporale) {
                te = this.transazioniExporterService.getByIntervallo(((TransazioniSearchForm)this.transazioniService.getSearch()).getDataInizio(), ((TransazioniSearchForm)this.transazioniService.getSearch()).getDataFine());
                te.setExportState(ExportState.EXECUTING);
                te.setExportTimeStart(startTime);
                te.setDeleteState(DeleteState.UNDEFINED);
                if (this.fileName != null) {
                    te.setNome(this.fileName);
                }
                this.transazioniExporterService.store(te);
            }
            ArrayList<List<String>> dataSourceTransazioni = new ArrayList<List<String>>();
            this.popolaDataSourceExport(dataSourceTransazioni, transazioni);
            if (this.formato.equals("CSV")) {
                this.esportaCsv(this.outStream, dataSourceTransazioni, this.colonneSelezionate);
            } else if (this.formato.equals("XLS")) {
                this.esportaXls(this.outStream, dataSourceTransazioni, this.colonneSelezionate);
            } else {
                throw new ExportException("Formato export [" + this.formato + "] non valido.");
            }
            Date dataFine = Calendar.getInstance().getTime();
            if (this.abilitaMarcamentoTemporale && te != null) {
                te.setExportState(ExportState.COMPLETED);
                te.setExportTimeEnd(dataFine);
                this.transazioniExporterService.store(te);
            }
            SingleCsvFileExporter.logDebug("Fine esportazione alle:" + formatter.format(Calendar.getInstance().getTime()));
            SingleCsvFileExporter.logDebug("Esportazione completata.");
        }
        catch (ExportException e) {
            SingleCsvFileExporter.logError(ERRORE_EXPORT_FILE, e);
            if (this.abilitaMarcamentoTemporale && te != null) {
                try {
                    te.setExportState(ExportState.ERROR);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    te.setExportError(sw.toString());
                    this.transazioniExporterService.store(te);
                }
                catch (Exception ex) {
                    SingleCsvFileExporter.logError("Errore durante il marcamento temporale.", ex);
                }
            }
            throw e;
        }
        catch (Exception e) {
            SingleCsvFileExporter.logError(ERRORE_EXPORT_FILE, e);
            throw new ExportException(ERRORE_EXPORT_FILE, e);
        }
    }

    public void export() throws ExportException {
        Date startTime = Calendar.getInstance().getTime();
        TransazioneExport te = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            int start = 0;
            int limit = 100;
            SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
            SingleCsvFileExporter.logDebug("Avvio esportazione ...");
            SingleCsvFileExporter.logDebug("Inizio esportazione alle:" + time.format(startTime));
            if (this.abilitaMarcamentoTemporale) {
                te = this.transazioniExporterService.getByIntervallo(((TransazioniSearchForm)this.transazioniService.getSearch()).getDataInizio(), ((TransazioniSearchForm)this.transazioniService.getSearch()).getDataFine());
                te.setExportState(ExportState.EXECUTING);
                te.setExportTimeStart(startTime);
                te.setDeleteState(DeleteState.UNDEFINED);
                if (this.fileName != null) {
                    te.setNome(this.fileName);
                }
                this.transazioniExporterService.store(te);
            }
            ArrayList<List<String>> dataSourceTransazioni = new ArrayList<List<String>>();
            List transazioni = this.transazioniService.findAll(start, limit);
            int totale = transazioni.size();
            boolean stopExport = false;
            while (!transazioni.isEmpty() && !stopExport) {
                int residui;
                this.popolaDataSourceExport(dataSourceTransazioni, transazioni);
                start += limit;
                if (!this.useCount && (residui = Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES - totale) > 0 && limit >= residui) {
                    limit = residui;
                }
                transazioni = this.transazioniService.findAll(start, limit);
                if (this.useCount || (totale += transazioni.size()) < Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES) continue;
                stopExport = true;
                this.popolaDataSourceExport(dataSourceTransazioni, transazioni);
            }
            if (this.formato.equals("CSV")) {
                this.esportaCsv(this.outStream, dataSourceTransazioni, this.colonneSelezionate);
            } else if (this.formato.equals("XLS")) {
                this.esportaXls(this.outStream, dataSourceTransazioni, this.colonneSelezionate);
            } else {
                throw new ExportException("Formato export [" + this.formato + "] non valido.");
            }
            Date dataFine = Calendar.getInstance().getTime();
            if (this.abilitaMarcamentoTemporale) {
                te.setExportState(ExportState.COMPLETED);
                te.setExportTimeEnd(dataFine);
                this.transazioniExporterService.store(te);
            }
            SingleCsvFileExporter.logDebug("Fine esportazione alle:" + formatter.format(dataFine));
            SingleCsvFileExporter.logDebug("Esportazione completata.");
        }
        catch (ExportException e) {
            SingleCsvFileExporter.logError(ERRORE_EXPORT_FILE, e);
            if (this.abilitaMarcamentoTemporale) {
                try {
                    te.setExportState(ExportState.ERROR);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    te.setExportError(sw.toString());
                    this.transazioniExporterService.store(te);
                }
                catch (Exception ex) {
                    SingleCsvFileExporter.logError("Errore durante il marcamento temporale.", ex);
                }
            }
            throw e;
        }
        catch (Exception e) {
            SingleCsvFileExporter.logError(ERRORE_EXPORT_FILE, e);
            throw new ExportException(ERRORE_EXPORT_FILE, e);
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isAbilitaMarcamentoTemporale() {
        return this.abilitaMarcamentoTemporale;
    }

    public void esportaXls(OutputStream outputStream, List<List<String>> dati, List<String> colonneSelezionate) throws IOException {
        ArrayList<String> labelColonna = new ArrayList<String>();
        for (String keyColonna : colonneSelezionate) {
            ColonnaExport defColonna = ColonnaExportManager.getInstance().getColonna(keyColonna);
            String label = defColonna != null ? defColonna.getLabel() : keyColonna;
            labelColonna.add(label);
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Templates.writeDataIntoXls(dati, labelColonna, (XSSFWorkbook)workbook);
            workbook.write(outputStream);
        }
    }

    public void esportaCsv(OutputStream outputStream, List<List<String>> dati, List<String> colonneSelezionate) throws UtilsException {
        ArrayList<String> labelColonna = new ArrayList<String>();
        for (String keyColonna : colonneSelezionate) {
            ColonnaExport defColonna = ColonnaExportManager.getInstance().getColonna(keyColonna);
            String label = defColonna != null ? defColonna.getLabel() : keyColonna;
            labelColonna.add(label);
        }
        Printer printer = Templates.getPrinter((OutputStream)outputStream);
        Templates.writeDataIntoCsv(dati, labelColonna, (Printer)printer);
        printer.close();
    }
}

