/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.credenziali.engine.GestoreCredenzialiEngine;
import org.openspcoop2.pdd.core.token.TipoInformazioni;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.core.UtilityTransazioni;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.SingleFileExporter;
import org.openspcoop2.web.monitor.transazioni.mbean.DiagnosticiBean;
import org.openspcoop2.web.monitor.transazioni.mbean.TracciaBean;
import org.slf4j.Logger;

public class DettagliBean
extends PdDBaseBean<Transazione, String, IService<TransazioneBean, Long>> {
    private static final String PROPERTY_ID_TRANSAZIONE = "id_transazione";
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String idTransazione;
    private String idEgov;
    private String identificativoPorta;
    private volatile boolean isRisposta;
    private transient ITracciaDriver driver;
    private transient ITransazioniService transazioniService;
    private volatile boolean visualizzaIdCluster = false;
    private boolean clusterDinamico = false;
    private String selectedTab = null;
    private DiagnosticiBean diagnosticiBean;
    private TracciaBean tracciaRichiesta;
    private TracciaBean tracciaRisposta;
    private TransazioneBean dettaglio;
    private TransazioneBean originale;
    private static Boolean enableHeaderInfo = null;
    private static boolean headersAsProperties = true;
    private static boolean contenutiAsProperties = false;
    private transient IProtocolFactory<?> protocolFactory;
    private volatile boolean showFaultCooperazione = false;
    private volatile boolean showFaultIntegrazione = false;
    private volatile boolean visualizzaDataAccettazione = false;
    private Boolean hasDumpRichiestaIngresso = null;
    private Boolean hasDumpRichiestaUscita = null;
    private Boolean hasDumpRispostaIngresso = null;
    private Boolean hasDumpRispostaUscita = null;
    private Boolean hasDumpBinarioRichiestaIngresso = null;
    private Boolean hasDumpBinarioRichiestaUscita = null;
    private Boolean hasDumpBinarioRispostaIngresso = null;
    private Boolean hasDumpBinarioRispostaUscita = null;
    private Boolean hasHeaderTrasportoRichiestaIngresso = null;
    private Boolean hasHeaderTrasportoRichiestaUscita = null;
    private Boolean hasHeaderTrasportoRispostaIngresso = null;
    private Boolean hasHeaderTrasportoRispostaUscita = null;
    private Boolean hasHeaderTrasportoBinarioRichiestaIngresso = null;
    private Boolean hasHeaderTrasportoBinarioRichiestaUscita = null;
    private Boolean hasHeaderTrasportoBinarioRispostaIngresso = null;
    private Boolean hasHeaderTrasportoBinarioRispostaUscita = null;
    private Boolean hasDumpBinarioMultipartRichiestaIngresso = null;
    private Boolean hasDumpBinarioMultipartRichiestaUscita = null;
    private Boolean hasDumpBinarioMultipartRispostaIngresso = null;
    private Boolean hasDumpBinarioMultipartRispostaUscita = null;
    private volatile boolean dataUscitaRispostaValorizzataDopoSpedizioneRisposta = false;
    private TipoMessaggio exportContenuto;
    private Integer multipartThreshold = null;
    private Boolean exportContenutiMultipart;
    private TipoInformazioni ti = null;

    public String getExportContenuto() {
        if (this.exportContenuto == null) {
            return null;
        }
        return this.exportContenuto.toString();
    }

    public void setExportContenuto(String exportContenuto) {
        if (exportContenuto != null) {
            this.exportContenuto = (TipoMessaggio)TipoMessaggio.toEnumConstantFromString((String)exportContenuto);
        }
    }

    public DettagliBean() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            List govwayMonitorare = govwayMonitorProperties.getListaPdDMonitorate_StatusPdD();
            this.setVisualizzaIdCluster(govwayMonitorare != null && govwayMonitorare.size() > 1);
            this.clusterDinamico = govwayMonitorProperties.isClusterDinamico();
            this.driver = govwayMonitorProperties.getDriverTracciamento();
            this.visualizzaDataAccettazione = govwayMonitorProperties.isAttivoTransazioniDataAccettazione();
            this.multipartThreshold = govwayMonitorProperties.getTransazioniDettaglioAnalisiMultipartThreshold();
            this.dataUscitaRispostaValorizzataDopoSpedizioneRisposta = govwayMonitorProperties.isDataUscitaRispostaUseDateAfterResponseSent();
        }
        catch (Exception e) {
            log.error("Inizializzazione driverTracciamento fallita.....", (Throwable)e);
        }
    }

    public void setTransazioniService(ITransazioniService transazioniService) {
        this.transazioniService = transazioniService;
    }

    public Transazione getTransazioneOriginaleRichiesta() {
        if (this.originale != null) {
            return this.originale;
        }
        if (this.dettaglio != null && this.dettaglio.getDuplicatiRichiesta() == -1) {
            this.originale = this.transazioniService.findTransazioneOriginale(this.idTransazione, this.dettaglio.getIdMessaggioRichiesta(), false);
        }
        return this.originale;
    }

    public Transazione getTransazioneOriginaleRisposta() {
        if (this.originale != null) {
            return this.originale;
        }
        if (this.dettaglio != null && this.dettaglio.getDuplicatiRisposta() == -1) {
            this.originale = this.transazioniService.findTransazioneOriginale(this.idTransazione, this.dettaglio.getIdMessaggioRisposta(), true);
        }
        return this.originale;
    }

    public String saveDiagnostici() {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            sessione.setAttribute("idTransazioniOriginali", (Object)this.dettaglio.getIdTransazione());
            sessione.setAttribute("isAllOriginale", (Object)false);
            response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/diagnosticiexporter?isAll=false&ids=" + this.dettaglio.getIdTransazione());
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione dei diagnostici.");
        }
        return null;
    }

    public String saveTracce() {
        try {
            String newLine;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(PROPERTY_ID_TRANSAZIONE, this.dettaglio.getIdTransazione());
            Traccia tracciaRichiesta = null;
            Traccia tracciaRisposta = null;
            ArrayList<Traccia> tracce = new ArrayList<Traccia>();
            if (!this.isRisposta) {
                try {
                    tracciaRichiesta = this.driver.getTraccia(RuoloMessaggio.RICHIESTA, properties);
                    tracce.add(tracciaRichiesta);
                }
                catch (DriverTracciamentoException driverTracciamentoException) {
                }
                catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {}
            } else {
                try {
                    tracciaRisposta = this.driver.getTraccia(RuoloMessaggio.RISPOSTA, properties);
                    tracce.add(tracciaRisposta);
                }
                catch (DriverTracciamentoException driverTracciamentoException) {
                }
                catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {
                    // empty catch block
                }
            }
            if (tracce.size() == 0) {
                MessageUtils.addWarnMsg((String)"Nessuna traccia trovata.");
                return null;
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String fileName = null;
            fileName = this.isRisposta ? "TracciaRisposta.zip" : "TracciaRichiesta.zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            response.setStatus(200);
            response.flushBuffer();
            byte[] buf = new byte[1024];
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            InputStream in = null;
            ArrayList<String> errori = new ArrayList<String>(0);
            if (tracce.size() > 0) {
                zip.putNextEntry(new ZipEntry(this.dettaglio.getIdTransazione() + " (" + tracce.size() + " entries).xml"));
                if (enableHeaderInfo.booleanValue()) {
                    zip.write(UtilityTransazioni.getHeaderTransazione(this.dettaglio).getBytes());
                }
                for (int j = 0; j < tracce.size(); ++j) {
                    Traccia tr = (Traccia)tracce.get(j);
                    newLine = j > 0 ? "\n\n" : "";
                    IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tr.getProtocollo());
                    ITracciaSerializer tracciaBuilder = pf.createTracciaSerializer();
                    try {
                        int len;
                        tracciaBuilder.setOmitXmlDeclaration(true);
                        String traccia = tracciaBuilder.toString(tr, TipoSerializzazione.DEFAULT);
                        in = new ByteArrayInputStream((newLine + traccia).getBytes());
                        while ((len = in.read(buf)) > 0) {
                            zip.write(buf, 0, len);
                        }
                        continue;
                    }
                    catch (ProtocolException e) {
                        String idTransazione = this.dettaglio.getIdTransazione();
                        String tipoTraccia = tr.getTipoMessaggio().getTipo();
                        String bustaAsString = tr.getBustaAsString();
                        String messaggioErrore = e.getMessage();
                        StringBuilder sb = new StringBuilder(0);
                        sb.append("ID Transazione: ").append(idTransazione).append("\n");
                        sb.append("Tipo Traccia: ").append(tipoTraccia).append("\n");
                        sb.append("Busta: \n").append(bustaAsString).append("\n\n");
                        sb.append("Errore: \n").append(messaggioErrore).append("\n");
                        errori.add(sb.toString());
                    }
                }
                zip.closeEntry();
                zip.flush();
                if (in != null) {
                    in.close();
                }
            }
            if (errori.size() > 0) {
                zip.putNextEntry(new ZipEntry(this.dettaglio.getIdTransazione() + " (" + errori.size() + " entries).xml.error"));
                for (int i = 0; i < errori.size(); ++i) {
                    int len;
                    String errore = (String)errori.get(i);
                    newLine = i > 0 ? "\n\n" : "";
                    in = new ByteArrayInputStream((newLine + errore).getBytes());
                    while ((len = in.read(buf)) > 0) {
                        zip.write(buf, 0, len);
                    }
                }
                zip.closeEntry();
                zip.flush();
                if (in != null) {
                    in.close();
                }
            }
            zip.flush();
            zip.close();
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione delle tracce.");
        }
        return null;
    }

    public void showOriginaleSelected(ActionEvent ae) {
        this.dettaglio = null;
    }

    public void showDuplicatoSelected(ActionEvent ae) {
        this.dettaglio = null;
    }

    public String getTipologiaConProtocollo() throws Exception {
        if (this.dettaglio == null) {
            return "n.d.";
        }
        if (this.dettaglio.getPddRuolo() == null) {
            return "n.d.";
        }
        String ruolo = null;
        switch (this.dettaglio.getPddRuolo()) {
            case DELEGATA: {
                ruolo = "Fruizione";
                break;
            }
            case APPLICATIVA: {
                ruolo = "Erogazione";
                break;
            }
            case INTEGRATION_MANAGER: {
                ruolo = "MessageBox";
                break;
            }
            case ROUTER: {
                ruolo = "Router";
            }
        }
        if (this.dettaglio.getProtocollo() != null) {
            return ruolo + " (" + this.dettaglio.getProtocolloLabel() + ")";
        }
        return ruolo;
    }

    public TransazioneBean getDettaglio() {
        if (this.dettaglio != null) {
            return this.dettaglio;
        }
        try {
            this.dettaglio = this.transazioniService.findByIdTransazione(this.idTransazione);
            if (this.dettaglio != null && this.protocolFactory == null && this.getTraccia() != null) {
                try {
                    this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.getTraccia().getProtocollo());
                }
                catch (ProtocolException e) {
                    log.error("Errore durante la creazione della Factory", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.dettaglio;
    }

    public boolean isExistsTracciaRichiesta() {
        if (this.getDettaglio() != null && this.getDettaglio().getIdMessaggioRichiesta() != null && !"".equals(this.getDettaglio().getIdMessaggioRichiesta()) && !PddRuolo.INTEGRATION_MANAGER.equals((Object)this.getDettaglio().getPddRuolo())) {
            this.isRisposta = false;
            return this.getTraccia() != null;
        }
        return false;
    }

    public boolean isExistsTracciaRisposta() {
        if (this.getDettaglio() != null && this.getDettaglio().getIdMessaggioRisposta() != null && !"".equals(this.getDettaglio().getIdMessaggioRisposta()) && !PddRuolo.INTEGRATION_MANAGER.equals((Object)this.getDettaglio().getPddRuolo())) {
            this.isRisposta = true;
            return this.getTraccia() != null;
        }
        return false;
    }

    public Traccia getTraccia() {
        if (!this.isRisposta) {
            if (this.tracciaRichiesta != null) {
                return this.tracciaRichiesta;
            }
        } else if (this.tracciaRisposta != null) {
            return this.tracciaRisposta;
        }
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(PROPERTY_ID_TRANSAZIONE, this.idTransazione);
            boolean notNull = false;
            ServiceBinding tipoApi = null;
            if (this.getDettaglio() != null) {
                if (TipoAPI.REST.getValoreAsInt() == this.getDettaglio().getTipoApi()) {
                    tipoApi = ServiceBinding.REST;
                } else if (TipoAPI.SOAP.getValoreAsInt() == this.getDettaglio().getTipoApi()) {
                    tipoApi = ServiceBinding.SOAP;
                }
            }
            if ((notNull = this.readTraccia(properties, tipoApi)) && this.protocolFactory == null) {
                try {
                    this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.getTraccia().getProtocollo());
                }
                catch (ProtocolException e) {
                    log.error("Errore durante la creazione della Factory", (Throwable)e);
                }
            }
        }
        catch (DriverTracciamentoNotFoundException properties) {
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (!this.isRisposta) {
            return this.tracciaRichiesta;
        }
        return this.tracciaRisposta;
    }

    private boolean readTraccia(Map<String, String> properties, ServiceBinding tipoApi) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        boolean notNull;
        if (((TransazioniSearchForm)this.transazioniService.getSearch()).isRicercaArchivioZip()) {
            if (!this.isRisposta) {
                this.tracciaRichiesta = ((TransazioniSearchForm)this.transazioniService.getSearch()).getArchivioZipManager().getMapTransazioni().get(properties.get(PROPERTY_ID_TRANSAZIONE)).getTraccia(RuoloMessaggio.RICHIESTA);
                notNull = this.tracciaRichiesta != null;
            } else {
                this.tracciaRisposta = ((TransazioniSearchForm)this.transazioniService.getSearch()).getArchivioZipManager().getMapTransazioni().get(properties.get(PROPERTY_ID_TRANSAZIONE)).getTraccia(RuoloMessaggio.RISPOSTA);
                notNull = this.tracciaRisposta != null;
            }
        } else if (!this.isRisposta) {
            this.tracciaRichiesta = new TracciaBean(this.driver.getTraccia(RuoloMessaggio.RICHIESTA, properties), tipoApi);
            notNull = this.tracciaRichiesta != null;
        } else {
            this.tracciaRisposta = new TracciaBean(this.driver.getTraccia(RuoloMessaggio.RISPOSTA, properties), tipoApi);
            notNull = this.tracciaRisposta != null;
        }
        return notNull;
    }

    public boolean getHasDumpRichiestaIngresso() {
        if (this.hasDumpRichiestaIngresso == null) {
            this.hasDumpRichiestaIngresso = this.getHasDump(TipoMessaggio.RICHIESTA_INGRESSO);
        }
        return this.hasDumpRichiestaIngresso;
    }

    public boolean getHasDumpRichiestaUscita() {
        if (this.hasDumpRichiestaUscita == null) {
            this.hasDumpRichiestaUscita = this.getHasDump(TipoMessaggio.RICHIESTA_USCITA);
        }
        return this.hasDumpRichiestaUscita;
    }

    public boolean getHasDumpRispostaIngresso() {
        if (this.hasDumpRispostaIngresso == null) {
            this.hasDumpRispostaIngresso = this.getHasDump(TipoMessaggio.RISPOSTA_INGRESSO);
        }
        return this.hasDumpRispostaIngresso;
    }

    public boolean getHasDumpRispostaUscita() {
        if (this.hasDumpRispostaUscita == null) {
            this.hasDumpRispostaUscita = this.getHasDump(TipoMessaggio.RISPOSTA_USCITA);
        }
        return this.hasDumpRispostaUscita;
    }

    public boolean getHasDumpBinarioRichiestaIngresso() {
        if (this.hasDumpBinarioRichiestaIngresso == null) {
            this.hasDumpBinarioRichiestaIngresso = this.getHasDump(TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO);
        }
        return this.hasDumpBinarioRichiestaIngresso;
    }

    public boolean getHasDumpBinarioRichiestaUscita() {
        if (this.hasDumpBinarioRichiestaUscita == null) {
            this.hasDumpBinarioRichiestaUscita = this.getHasDump(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
        }
        return this.hasDumpBinarioRichiestaUscita;
    }

    public boolean getHasDumpBinarioRispostaIngresso() {
        if (this.hasDumpBinarioRispostaIngresso == null) {
            this.hasDumpBinarioRispostaIngresso = this.getHasDump(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
        }
        return this.hasDumpBinarioRispostaIngresso;
    }

    public boolean getHasDumpBinarioRispostaUscita() {
        if (this.hasDumpBinarioRispostaUscita == null) {
            this.hasDumpBinarioRispostaUscita = this.getHasDump(TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO);
        }
        return this.hasDumpBinarioRispostaUscita;
    }

    private boolean getHasDump(TipoMessaggio tipo) {
        return this.transazioniService.hasInfoDumpAvailable(this.idTransazione, null, null, tipo);
    }

    public boolean getHasHeaderTrasportoRichiestaIngresso() {
        if (this.hasHeaderTrasportoRichiestaIngresso == null) {
            this.hasHeaderTrasportoRichiestaIngresso = this.getHasHeaderTrasporto(TipoMessaggio.RICHIESTA_INGRESSO);
        }
        return this.hasHeaderTrasportoRichiestaIngresso;
    }

    public boolean getHasHeaderTrasportoRichiestaUscita() {
        if (this.hasHeaderTrasportoRichiestaUscita == null) {
            this.hasHeaderTrasportoRichiestaUscita = this.getHasHeaderTrasporto(TipoMessaggio.RICHIESTA_USCITA);
        }
        return this.hasHeaderTrasportoRichiestaUscita;
    }

    public boolean getHasHeaderTrasportoRispostaIngresso() {
        if (this.hasHeaderTrasportoRispostaIngresso == null) {
            this.hasHeaderTrasportoRispostaIngresso = this.getHasHeaderTrasporto(TipoMessaggio.RISPOSTA_INGRESSO);
        }
        return this.hasHeaderTrasportoRispostaIngresso;
    }

    public boolean getHasHeaderTrasportoRispostaUscita() {
        if (this.hasHeaderTrasportoRispostaUscita == null) {
            this.hasHeaderTrasportoRispostaUscita = this.getHasHeaderTrasporto(TipoMessaggio.RISPOSTA_USCITA);
        }
        return this.hasHeaderTrasportoRispostaUscita;
    }

    public boolean getHasHeaderTrasportoBinarioRichiestaIngresso() {
        if (this.hasHeaderTrasportoBinarioRichiestaIngresso == null) {
            this.hasHeaderTrasportoBinarioRichiestaIngresso = this.getHasHeaderTrasporto(TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO);
        }
        return this.hasHeaderTrasportoBinarioRichiestaIngresso;
    }

    public boolean getHasHeaderTrasportoBinarioRichiestaUscita() {
        if (this.hasHeaderTrasportoBinarioRichiestaUscita == null) {
            this.hasHeaderTrasportoBinarioRichiestaUscita = this.getHasHeaderTrasporto(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
        }
        return this.hasHeaderTrasportoBinarioRichiestaUscita;
    }

    public boolean getHasHeaderTrasportoBinarioRispostaIngresso() {
        if (this.hasHeaderTrasportoBinarioRispostaIngresso == null) {
            this.hasHeaderTrasportoBinarioRispostaIngresso = this.getHasHeaderTrasporto(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
        }
        return this.hasHeaderTrasportoBinarioRispostaIngresso;
    }

    public boolean getHasHeaderTrasportoBinarioRispostaUscita() {
        if (this.hasHeaderTrasportoBinarioRispostaUscita == null) {
            this.hasHeaderTrasportoBinarioRispostaUscita = this.getHasHeaderTrasporto(TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO);
        }
        return this.hasHeaderTrasportoBinarioRispostaUscita;
    }

    public Boolean getHasDumpBinarioMultipartRichiestaIngresso() {
        if (this.hasDumpBinarioMultipartRichiestaIngresso == null) {
            String contentType = this.getContentType(TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO);
            Long contentLength = this.getContentLength(TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO);
            this.hasDumpBinarioMultipartRichiestaIngresso = DettagliBean.isVisualizzaContenutiMultipartButton(TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO, contentType, contentLength, this.multipartThreshold, log);
        }
        return this.hasDumpBinarioMultipartRichiestaIngresso;
    }

    public Boolean getHasDumpBinarioMultipartRichiestaUscita() {
        if (this.hasDumpBinarioMultipartRichiestaUscita == null) {
            String contentType = this.getContentType(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
            Long contentLength = this.getContentLength(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
            this.hasDumpBinarioMultipartRichiestaUscita = DettagliBean.isVisualizzaContenutiMultipartButton(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, contentType, contentLength, this.multipartThreshold, log);
        }
        return this.hasDumpBinarioMultipartRichiestaUscita;
    }

    public Boolean getHasDumpBinarioMultipartRispostaIngresso() {
        if (this.hasDumpBinarioMultipartRispostaIngresso == null) {
            String contentType = this.getContentType(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
            Long contentLength = this.getContentLength(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
            this.hasDumpBinarioMultipartRispostaIngresso = DettagliBean.isVisualizzaContenutiMultipartButton(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO, contentType, contentLength, this.multipartThreshold, log);
        }
        return this.hasDumpBinarioMultipartRispostaIngresso;
    }

    public Boolean getHasDumpBinarioMultipartRispostaUscita() {
        if (this.hasDumpBinarioMultipartRispostaUscita == null) {
            String contentType = this.getContentType(TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO);
            Long contentLength = this.getContentLength(TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO);
            this.hasDumpBinarioMultipartRispostaUscita = DettagliBean.isVisualizzaContenutiMultipartButton(TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO, contentType, contentLength, this.multipartThreshold, log);
        }
        return this.hasDumpBinarioMultipartRispostaUscita;
    }

    private boolean getHasHeaderTrasporto(TipoMessaggio tipo) {
        return this.transazioniService.hasInfoHeaderTrasportoAvailable(this.idTransazione, null, null, tipo);
    }

    private String getContentType(TipoMessaggio tipo) {
        return this.transazioniService.getContentTypeMessaggio(this.idTransazione, null, null, tipo);
    }

    private Long getContentLength(TipoMessaggio tipo) {
        return this.transazioniService.getContentLengthMessaggio(this.idTransazione, null, null, tipo);
    }

    public static boolean isVisualizzaContenutiMultipartButton(TipoMessaggio tipoMessaggio, String contentType, Long contentLength, Integer multipartThreshold, Logger log) {
        if (contentType == null) {
            return false;
        }
        switch (tipoMessaggio) {
            case RICHIESTA_INGRESSO_DUMP_BINARIO: 
            case RICHIESTA_USCITA_DUMP_BINARIO: 
            case RISPOSTA_INGRESSO_DUMP_BINARIO: 
            case RISPOSTA_USCITA_DUMP_BINARIO: {
                try {
                    if (ContentTypeUtilities.isMultipartContentType((String)contentType)) {
                        return contentLength != null && multipartThreshold != null && contentLength.intValue() < multipartThreshold;
                    }
                }
                catch (Throwable e) {
                    log.error("Errore nel check multipart: " + e.getMessage(), e);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public void visualizzaRichiestaListener(ActionEvent ae) {
        this.dettaglio = null;
    }

    public void visualizzaRispostaListener(ActionEvent ae) {
        this.dettaglio = null;
    }

    public void tracciaListener(ActionEvent ae) {
        this.tracciaRichiesta = null;
        this.tracciaRisposta = null;
    }

    public void setTraccia(Traccia traccia) {
        ServiceBinding tipoApi = null;
        if (this.getDettaglio() != null) {
            if (TipoAPI.REST.getValoreAsInt() == this.getDettaglio().getTipoApi()) {
                tipoApi = ServiceBinding.REST;
            } else if (TipoAPI.SOAP.getValoreAsInt() == this.getDettaglio().getTipoApi()) {
                tipoApi = ServiceBinding.SOAP;
            }
        }
        TracciaBean tr = new TracciaBean(traccia, tipoApi);
        if (!this.isRisposta) {
            this.tracciaRichiesta = tr;
        } else {
            this.tracciaRisposta = tr;
        }
        if (tr != null && this.protocolFactory == null) {
            try {
                this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.getTraccia().getProtocollo());
            }
            catch (ProtocolException e) {
                log.error("Errore durante la creazione della Factory", (Throwable)e);
            }
        }
    }

    public String getIdEgov() {
        return this.idEgov;
    }

    public void setIdEgov(String idEgov) {
        this.idEgov = idEgov;
    }

    public boolean getIsRisposta() {
        return this.isRisposta;
    }

    public void setIsRisposta(boolean isRisposta) {
        this.isRisposta = isRisposta;
    }

    public String getIdentificativoPorta() {
        return this.identificativoPorta;
    }

    public void setIdentificativoPorta(String identificativoPorta) {
        this.identificativoPorta = identificativoPorta;
    }

    public String getIdTransazione() {
        return this.idTransazione;
    }

    public void setIdTransazione(String idTransazione) {
        this.idTransazione = idTransazione;
    }

    public boolean getShowFaultCooperazione() {
        return this.showFaultCooperazione;
    }

    public void setShowFaultCooperazione(boolean showFaultCooperazione) {
        this.showFaultCooperazione = showFaultCooperazione;
        this.showFaultIntegrazione = false;
    }

    public boolean getShowFaultIntegrazione() {
        return this.showFaultIntegrazione;
    }

    public void setShowFaultIntegrazione(boolean showFaultIntegrazione) {
        this.showFaultIntegrazione = showFaultIntegrazione;
        this.showFaultCooperazione = false;
    }

    public void setDettaglio(TransazioneBean dettaglio) {
        this.dettaglio = dettaglio;
        if (this.dettaglio != null && this.protocolFactory == null) {
            try {
                this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.getTraccia().getProtocollo());
            }
            catch (ProtocolException e) {
                log.error("Errore durante la creazione della Factory", (Throwable)e);
            }
        }
    }

    public String getPrettyEnvelop() {
        String toRet = null;
        TracciaBean tr = null;
        tr = !this.isRisposta ? this.tracciaRichiesta : this.tracciaRisposta;
        if (tr != null && tr.getBustaAsString() != null) {
            toRet = Utils.prettifyXml((String)tr.getBustaAsString());
        }
        if (toRet == null && tr != null) {
            toRet = tr.getBustaAsString() != null ? tr.getBustaAsString() : "";
        }
        return toRet;
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public boolean isVisualizzaDataAccettazione() {
        return this.visualizzaDataAccettazione;
    }

    public void setVisualizzaDataAccettazione(boolean visualizzaDataAccettazione) {
        this.visualizzaDataAccettazione = visualizzaDataAccettazione;
    }

    public boolean isDataUscitaRispostaValorizzataDopoSpedizioneRisposta() {
        return this.dataUscitaRispostaValorizzataDopoSpedizioneRisposta;
    }

    public void setDataUscitaRispostaValorizzataDopoSpedizioneRisposta(boolean isDataUscitaRispostaValorizzataDopoSpedizioneRisposta) {
        this.dataUscitaRispostaValorizzataDopoSpedizioneRisposta = isDataUscitaRispostaValorizzataDopoSpedizioneRisposta;
    }

    public String getTextCredenziali() {
        if (StringUtils.isNotEmpty((CharSequence)this.dettaglio.getCredenziali())) {
            String cr = this.dettaglio.getCredenziali();
            if (GestoreCredenzialiEngine.containsPrefixGatewayCredenziali((String)cr)) {
                return GestoreCredenzialiEngine.erasePrefixGatewayCredenziali((String)cr);
            }
            return cr;
        }
        return null;
    }

    public boolean isVisualizzaTextAreaCredenziali() {
        if (StringUtils.isNotEmpty((CharSequence)this.dettaglio.getCredenziali())) {
            if (this.dettaglio.getCredenziali().length() > 150) {
                return true;
            }
            if (this.dettaglio.getCredenziali().contains("\n")) {
                return true;
            }
        }
        return false;
    }

    public void setVisualizzaTextAreaCredenziali(boolean visualizzaTextAreaCredenziali) {
    }

    public boolean isVisualizzaTextAreaUrlInvocazione() {
        return StringUtils.isNotEmpty((CharSequence)this.dettaglio.getUrlInvocazione()) && this.dettaglio.getUrlInvocazione().length() > 150;
    }

    public void setVisualizzaTextAreaUrlInvocazione(boolean visualizzaTextAreaUrlInvocazione) {
    }

    public boolean isVisualizzaTextAreaConnettore() {
        return StringUtils.isNotEmpty((CharSequence)this.dettaglio.getLocationConnettore()) && this.dettaglio.getLocationConnettore().length() > 150;
    }

    public void setVisualizzaTextAreaConnettore(boolean visualizzaTextAreaConnettore) {
    }

    public boolean isVisualizzaTextAreaTrasportoMittente() {
        return StringUtils.isNotEmpty((CharSequence)this.dettaglio.getTrasportoMittenteLabel()) && this.dettaglio.getTrasportoMittenteLabel().length() > 150;
    }

    public void setVisualizzaTextAreaTrasportoMittente(boolean visualizzaTextAreaTrasportoMittente) {
    }

    public boolean isVisualizzaTextAreaLocationConnettore() {
        return StringUtils.isNotEmpty((CharSequence)this.dettaglio.getLocationConnettore()) && (this.dettaglio.getLocationConnettore().length() > 150 || this.dettaglio.getLocationConnettore().startsWith("govway://responseCaching"));
    }

    public void setVisualizzaTextAreaLocationConnettore(boolean visualizzaTextAreaLocationConnettore) {
    }

    public boolean isVisualizzaTokenInfo() {
        boolean visualizzaMessaggio = true;
        String f = this.dettaglio.getTokenInfo();
        if (f == null) {
            return false;
        }
        StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
        String errore = Utils.getTestoVisualizzabile((byte[])f.getBytes(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)false);
        if (errore != null) {
            return false;
        }
        return visualizzaMessaggio;
    }

    public String getPrettyTokenInfo() {
        String f = this.dettaglio.getTokenInfo();
        String toRet = null;
        if (f != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])f.getBytes(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)true);
            if (errore != null) {
                return "";
            }
            JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
            try {
                toRet = jsonUtils.toString(jsonUtils.getAsNode(f));
            }
            catch (UtilsException utilsException) {
                // empty catch block
            }
        }
        if (toRet == null) {
            toRet = f != null ? f : "";
        }
        return toRet;
    }

    private synchronized void initTipoInformazioni() {
        if (this.ti == null && this.dettaglio.getTokenInfo() != null && StringUtils.isNotEmpty((CharSequence)this.dettaglio.getTokenInfo())) {
            try {
                JsonNode j = JSONUtils.getInstance().getAsNode(this.dettaglio.getTokenInfo().getBytes());
                String type = j.get("type").textValue();
                this.ti = TipoInformazioni.valueOf((String)type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private TipoInformazioni getTipoInformazioni() {
        if (this.ti == null) {
            this.initTipoInformazioni();
        }
        return this.ti;
    }

    public boolean isValidatedToken() {
        if (this.dettaglio.getTokenIssuer() != null && StringUtils.isNotEmpty((CharSequence)this.dettaglio.getTokenIssuer())) {
            return true;
        }
        if (this.dettaglio.getTokenSubject() != null && StringUtils.isNotEmpty((CharSequence)this.dettaglio.getTokenSubject())) {
            return true;
        }
        if (this.dettaglio.getTokenUsername() != null && StringUtils.isNotEmpty((CharSequence)this.dettaglio.getTokenUsername())) {
            return true;
        }
        if (this.dettaglio.getTokenClientId() != null && StringUtils.isNotEmpty((CharSequence)this.dettaglio.getTokenClientId())) {
            return true;
        }
        if (this.dettaglio.getTokenMail() != null && StringUtils.isNotEmpty((CharSequence)this.dettaglio.getTokenMail())) {
            return true;
        }
        if (this.getTipoInformazioni() != null) {
            try {
                return TipoInformazioni.validated_token.equals((Object)this.getTipoInformazioni());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isRetrievedToken() {
        if (this.getTipoInformazioni() != null) {
            try {
                return TipoInformazioni.retrieved_token.equals((Object)this.getTipoInformazioni());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isAttributeInfo() {
        if (this.getTipoInformazioni() != null) {
            try {
                return TipoInformazioni.attribute_authority.equals((Object)this.getTipoInformazioni());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public String downloadTokenInfo() {
        log.debug("downloading TokenInfo: " + this.dettaglio.getId());
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            int read = 0;
            byte[] bytes = new byte[1024];
            String contentType = "application/json";
            response.setContentType(contentType);
            Object fileName = "tokenInfo";
            String ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType);
            fileName = (String)fileName + "." + ext;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)contentType);
            ByteArrayInputStream bis = null;
            ServletOutputStream os = null;
            String toRet = this.dettaglio.getTokenInfo();
            JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
            try {
                toRet = jsonUtils.toString(jsonUtils.getAsNode(this.dettaglio.getTokenInfo()));
            }
            catch (UtilsException utilsException) {
                // empty catch block
            }
            byte[] contenutoBody = toRet.getBytes();
            bis = new ByteArrayInputStream(contenutoBody);
            os = response.getOutputStream();
            while ((read = bis.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download del token info");
        }
        return null;
    }

    public void initExportListener(ActionEvent ae) {
        this.exportContenutiMultipart = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportContenuti() {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String dirPath = null;
            Object fileName = SingleFileExporter.getDirName(this.exportContenuto);
            fileName = (String)fileName + ".zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            response.setStatus(200);
            response.flushBuffer();
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            if (this.exportContenutiMultipart != null && this.exportContenutiMultipart.booleanValue()) {
                try {
                    SingleFileExporter.exportContenutiMultipart(log, this.dettaglio, zip, dirPath, this.transazioniService, this.exportContenuto, headersAsProperties, contenutiAsProperties);
                }
                finally {
                    this.exportContenutiMultipart = null;
                }
            } else {
                SingleFileExporter.exportContenuti(log, this.dettaglio, zip, dirPath, false, this.transazioniService, this.exportContenuto, headersAsProperties, contenutiAsProperties);
            }
            zip.flush();
            zip.close();
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione dei contenuti.");
        }
        return null;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public DiagnosticiBean getDiagnosticiBean() {
        this.diagnosticiBean = new DiagnosticiBean();
        this.diagnosticiBean.setIdEgov(this.idEgov);
        this.diagnosticiBean.setIdentificativoPorta(this.identificativoPorta);
        this.diagnosticiBean.setIdTransazione(this.idTransazione);
        this.diagnosticiBean.setUsaInformazioniArchivio(((TransazioniSearchForm)this.transazioniService.getSearch()).isRicercaArchivioZip());
        TransazioneBean trBean = this.getDettaglio();
        if (trBean != null) {
            this.diagnosticiBean.setProtocollo(trBean.getProtocollo());
            this.diagnosticiBean.setNomeServizioApplicativo(null);
            try {
                List<MsgDiagnostico> diagnostici;
                EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)trBean.getProtocollo());
                EsitoTransazioneName esitoTransactionName = esitiProperties.getEsitoTransazioneName(Integer.valueOf(trBean.getEsito()));
                if (EsitoTransazioneName.isConsegnaMultipla((EsitoTransazioneName)esitoTransactionName)) {
                    this.diagnosticiBean.setForceNomeServizioApplicativoNull(true);
                    if (((TransazioniSearchForm)this.transazioniService.getSearch()).isRicercaArchivioZip()) {
                        this.diagnosticiBean.setTransazioniApplicativoServer(((TransazioniSearchForm)this.transazioniService.getSearch()).getArchivioZipManager().getMapTransazioni().get(this.idTransazione).getConsegne().values().stream().map(c -> c.getTransazioneApplicativoServerBean()).collect(Collectors.toList()));
                    }
                } else {
                    this.diagnosticiBean.setForceNomeServizioApplicativoNull(false);
                }
                if (((TransazioniSearchForm)this.transazioniService.getSearch()).isRicercaArchivioZip() && (diagnostici = ((TransazioniSearchForm)this.transazioniService.getSearch()).getArchivioZipManager().getMapTransazioni().get(this.idTransazione).getDiagnostici()) != null && !diagnostici.isEmpty()) {
                    this.diagnosticiBean.getDiagnostici().addAll(diagnostici);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.diagnosticiBean;
    }

    public void setDiagnosticiBean(DiagnosticiBean diagnosticiBean) {
        this.diagnosticiBean = diagnosticiBean;
    }

    public boolean isVisualizzaIdCluster() {
        return this.visualizzaIdCluster;
    }

    public void setVisualizzaIdCluster(boolean visualizzaIdCluster) {
        this.visualizzaIdCluster = visualizzaIdCluster;
    }

    public boolean isClusterDinamico() {
        return this.clusterDinamico;
    }

    public Boolean getExportContenutiMultipart() {
        return this.exportContenutiMultipart;
    }

    public void setExportContenutiMultipart(Boolean exportContenutiMultipart) {
        this.exportContenutiMultipart = exportContenutiMultipart;
    }

    public boolean isVisualizzaLinkEsporta() {
        return ((TransazioniSearchForm)this.transazioniService.getSearch()).isShowButtonEsporta();
    }

    static {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            enableHeaderInfo = govwayMonitorProperties.isAttivoTransazioniExportHeader();
            headersAsProperties = govwayMonitorProperties.isAttivoTransazioniExportHeaderAsProperties();
            contenutiAsProperties = govwayMonitorProperties.isAttivoTransazioniExportContenutiAsProperties();
        }
        catch (Exception e) {
            log.error("Inizializzazione servlet fallita, setto enableHeaderInfo=false", (Throwable)e);
        }
    }
}

