/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCDumpMessaggioStream;
import org.openspcoop2.core.transazioni.utils.DumpUtils;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.openspcoop2.web.monitor.transazioni.bean.DumpContenutoBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.mbean.DettagliBean;
import org.openspcoop2.web.monitor.transazioni.mbean.DumpAllegatoBean;
import org.slf4j.Logger;

public class DettagliDump
extends PdDBaseBean<Transazione, String, ITransazioniService> {
    private static final long serialVersionUID = 1L;
    private transient Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String idTransazione;
    private String servizioApplicativoErogatore;
    private String protocollo = null;
    private TipoMessaggio tipoMessaggio;
    private Date dataConsegnaErogatore = null;
    private Date ultimaConsegna = null;
    private DumpMessaggio dumpMessaggio;
    private DumpAllegato selectedAttachment;
    private Integer multipartThreshold = null;
    private Boolean exportContenutiMultipart;
    private boolean base64Decode;

    public DettagliDump() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)this.log);
            this.multipartThreshold = govwayMonitorProperties.getTransazioniDettaglioAnalisiMultipartThreshold();
        }
        catch (Exception e) {
            this.log.error("Inizializzazione DettagliDump fallita.....", (Throwable)e);
        }
    }

    public void setBase64Decode(boolean base64Decode) {
        this.base64Decode = base64Decode;
    }

    public void setSelectedAttachment(DumpAllegato selectedAttachment) {
        this.selectedAttachment = selectedAttachment;
    }

    public String getIdTransazione() {
        return this.idTransazione;
    }

    public void setIdTransazione(String idTransazione) {
        this.idTransazione = idTransazione;
    }

    public String getServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public void setServizioApplicativoErogatore(String servizioApplicativoErogatore) {
        this.servizioApplicativoErogatore = servizioApplicativoErogatore;
    }

    public Date getDataConsegnaErogatore() {
        return this.dataConsegnaErogatore;
    }

    public void setDataConsegnaErogatore(Date dataConsegnaErogatore) {
        this.dataConsegnaErogatore = dataConsegnaErogatore;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public boolean isVisualizzaMessaggio() {
        boolean visualizzaMessaggio = true;
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            if (this.dumpMessaggio.getBody() == null) {
                return false;
            }
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])this.dumpMessaggio.getBody(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)false, (int)DumpUtils.getThreshold_readInMemory());
            if (errore != null) {
                return false;
            }
        } else if (this.dumpMessaggio != null && this.dumpMessaggio.getContentLength() != null && this.dumpMessaggio.getContentLength() > 0L) {
            return false;
        }
        return visualizzaMessaggio;
    }

    public String getPrettyEnvelop() {
        String toRet = null;
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])this.dumpMessaggio.getBody(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)true, (int)DumpUtils.getThreshold_readInMemory());
            if (errore != null) {
                return "";
            }
            MessageType messageType = null;
            if (StringUtils.isNotEmpty((CharSequence)this.dumpMessaggio.getFormatoMessaggio())) {
                messageType = MessageType.valueOf((String)this.dumpMessaggio.getFormatoMessaggio());
            }
            if (messageType == null) {
                toRet = this._getPrettyUnknownType();
            } else {
                switch (messageType) {
                    case JSON: {
                        JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                        try {
                            toRet = jsonUtils.toString(jsonUtils.getAsNode(this.dumpMessaggio.getBody()));
                        }
                        catch (UtilsException utilsException) {}
                        break;
                    }
                    case SOAP_11: 
                    case SOAP_12: {
                        String charset = null;
                        if (this.dumpMessaggio.getMultipartContentType() != null) {
                            String contentType = this.dumpMessaggio.getMultipartContentType();
                            try {
                                charset = ContentTypeUtilities.readCharsetFromContentType((String)contentType);
                            }
                            catch (Throwable throwable) {}
                        } else {
                            String contentType = this.dumpMessaggio.getContentType();
                            boolean multipart = false;
                            try {
                                multipart = ContentTypeUtilities.isMultipartType((String)contentType);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (multipart) break;
                            try {
                                charset = ContentTypeUtilities.readCharsetFromContentType((String)contentType);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        toRet = Utils.prettifyXml((byte[])this.dumpMessaggio.getBody(), (String)charset);
                        break;
                    }
                    case XML: {
                        String charset = null;
                        if (this.dumpMessaggio.getContentType() != null) {
                            try {
                                charset = ContentTypeUtilities.readCharsetFromContentType((String)this.dumpMessaggio.getContentType());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        toRet = Utils.prettifyXml((byte[])this.dumpMessaggio.getBody(), charset);
                        break;
                    }
                    case BINARY: 
                    case MIME_MULTIPART: {
                        toRet = this._getPrettyUnknownType();
                    }
                }
            }
        }
        if (toRet == null || "".equals(toRet)) {
            toRet = this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null ? new String(this.dumpMessaggio.getBody()) : "";
        }
        return toRet;
    }

    private String _getPrettyUnknownType() {
        String toRet = null;
        try {
            String ext;
            String contentType = this.dumpMessaggio.getContentType();
            if (ContentTypeUtilities.isMultipartRelated((String)contentType)) {
                contentType = ContentTypeUtilities.getInternalMultipartContentType((String)contentType);
            }
            if ("json".equals(ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType)) || contentType.contains("json")) {
                JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                try {
                    toRet = jsonUtils.toString(jsonUtils.getAsNode(this.dumpMessaggio.getBody()));
                }
                catch (UtilsException utilsException) {}
            } else if ("xml".equals(ext) || contentType.contains("xml")) {
                toRet = Utils.prettifyXml((byte[])this.dumpMessaggio.getBody());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return toRet;
    }

    public String getBrush() {
        String toRet = null;
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            MessageType messageType = null;
            if (StringUtils.isNotEmpty((CharSequence)this.dumpMessaggio.getFormatoMessaggio())) {
                messageType = MessageType.valueOf((String)this.dumpMessaggio.getFormatoMessaggio());
            }
            if (messageType == null) {
                toRet = this._getBrushUnknownType();
            } else {
                switch (messageType) {
                    case JSON: {
                        toRet = "json";
                        break;
                    }
                    default: {
                        toRet = "xml";
                        break;
                    }
                    case BINARY: 
                    case MIME_MULTIPART: {
                        toRet = this._getBrushUnknownType();
                    }
                }
            }
        }
        return toRet != null ? toRet : "xml";
    }

    private String _getBrushUnknownType() {
        String toRet = null;
        try {
            String ext;
            String contentType = this.dumpMessaggio.getContentType();
            if (ContentTypeUtilities.isMultipartRelated((String)contentType)) {
                contentType = ContentTypeUtilities.getInternalMultipartContentType((String)contentType);
            }
            toRet = "json".equals(ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType)) || contentType.contains("json") ? "json" : "xml";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            toRet = "xml";
        }
        return toRet;
    }

    public String getErroreVisualizzaMessaggio() {
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])this.dumpMessaggio.getBody(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)false, (int)DumpUtils.getThreshold_readInMemory());
            return errore;
        }
        if (this.dumpMessaggio != null && this.dumpMessaggio.getContentLength() != null && this.dumpMessaggio.getContentLength() > 0L) {
            String errore = Utilities.getErrorMessagePrintableTextMaxLength((int)this.dumpMessaggio.getContentLength().intValue(), (int)DumpUtils.getThreshold_readInMemory());
            return errore;
        }
        return null;
    }

    public DumpMessaggio getDumpMessaggio() {
        if (this.dumpMessaggio != null) {
            return this.dumpMessaggio;
        }
        try {
            this.dumpMessaggio = this.ultimaConsegna == null ? ((ITransazioniService)this.service).getDumpMessaggio(this.idTransazione, this.servizioApplicativoErogatore, this.dataConsegnaErogatore, this.tipoMessaggio) : ((ITransazioniService)this.service).getDumpMessaggio(this.idTransazione, this.servizioApplicativoErogatore, this.ultimaConsegna, this.tipoMessaggio);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return this.dumpMessaggio;
    }

    public List<DumpAllegato> getAllegati() {
        if (this.getDumpMessaggio() == null) {
            return null;
        }
        List<DumpAllegato> list = ((ITransazioniService)this.service).getAllegatiMessaggio(this.dumpMessaggio.getIdTransazione(), this.dumpMessaggio.getServizioApplicativoErogatore(), this.dumpMessaggio.getDataConsegnaErogatore(), this.dumpMessaggio.getTipoMessaggio(), this.dumpMessaggio.getId());
        if (list.size() > 0) {
            ArrayList<DumpAllegato> newL = new ArrayList<DumpAllegato>();
            for (DumpAllegato dumpAllegato : list) {
                newL.add(new DumpAllegatoBean(dumpAllegato));
            }
            return newL;
        }
        return null;
    }

    public List<DumpHeaderTrasporto> getHeadersTrasporto() {
        if (this.getDumpMessaggio() == null) {
            return null;
        }
        List<DumpHeaderTrasporto> list = ((ITransazioniService)this.service).getHeaderTrasporto(this.dumpMessaggio.getIdTransazione(), this.dumpMessaggio.getServizioApplicativoErogatore(), this.dumpMessaggio.getDataConsegnaErogatore(), this.dumpMessaggio.getTipoMessaggio(), this.dumpMessaggio.getId());
        return list.size() > 0 ? list : null;
    }

    public List<DumpContenuto> getContenuti() {
        if (this.getDumpMessaggio() == null) {
            return null;
        }
        List<DumpContenuto> list = ((ITransazioniService)this.service).getContenutiSpecifici(this.dumpMessaggio.getIdTransazione(), this.dumpMessaggio.getServizioApplicativoErogatore(), this.dumpMessaggio.getDataConsegnaErogatore(), this.dumpMessaggio.getTipoMessaggio(), this.dumpMessaggio.getId());
        if (list.size() > 0) {
            ArrayList<DumpContenuto> listNew = new ArrayList<DumpContenuto>();
            for (DumpContenuto dumpContenuto : list) {
                listNew.add(new DumpContenutoBean(dumpContenuto));
            }
            return listNew;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadMessaggio() {
        this.log.debug("downloading messaggio: " + this.dumpMessaggio.getId());
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            response.setContentType(this.dumpMessaggio.getContentType());
            Object fileName = "messaggio";
            String ext = "bin";
            String contentType = this.dumpMessaggio.getContentType();
            try {
                if (contentType != null) {
                    // empty if block
                }
                ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType);
            }
            catch (Exception e) {
                ext = "bin";
            }
            fileName = (String)fileName + "." + ext;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)contentType);
            JDBCDumpMessaggioStream dumpStream = null;
            InputStream is = null;
            ServletOutputStream os = null;
            try {
                if (this.dumpMessaggio.getBody() != null) {
                    byte[] contenutoBody = this.dumpMessaggio.getBody();
                    is = new ByteArrayInputStream(contenutoBody);
                } else {
                    try {
                        dumpStream = this.ultimaConsegna == null ? ((ITransazioniService)this.service).getContentInputStream(this.idTransazione, this.servizioApplicativoErogatore, this.dataConsegnaErogatore, this.tipoMessaggio) : ((ITransazioniService)this.service).getContentInputStream(this.idTransazione, this.servizioApplicativoErogatore, this.ultimaConsegna, this.tipoMessaggio);
                        is = dumpStream.getIs();
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
                os = response.getOutputStream();
                CopyStream.copy((InputStream)is, (OutputStream)os);
                os.flush();
                os.close();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (dumpStream != null) {
                        dumpStream.closeJdbcResources();
                    }
                }
                catch (Exception exception) {}
            }
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download del messaggio.");
        }
        return null;
    }

    public String download() {
        this.log.debug("downloading allegato: " + this.selectedAttachment.getId());
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            int read = 0;
            byte[] bytes = new byte[1024];
            response.setContentType(this.selectedAttachment.getContentType());
            Object fileName = "allegato";
            String ext = MimeTypeUtils.fileExtensionForMIMEType((String)this.selectedAttachment.getContentType());
            fileName = (String)fileName + "." + ext;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)this.selectedAttachment.getContentType());
            ByteArrayInputStream bis = null;
            ServletOutputStream os = null;
            byte[] contenutoAllegato = this.selectedAttachment.getAllegato();
            if (this.base64Decode) {
                contenutoAllegato = ((DumpAllegatoBean)this.selectedAttachment).decodeBase64();
            }
            bis = new ByteArrayInputStream(contenutoAllegato);
            os = response.getOutputStream();
            while ((read = bis.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download dell'allegato.");
        }
        return null;
    }

    public String downloadAll() {
        this.log.debug("downloading all attachments");
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            byte[] bytes = new byte[1024];
            String fileName = this.dumpMessaggio.getIdTransazione() + "-Attachments.zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            List<DumpAllegato> allegatiCore = ((ITransazioniService)this.service).getAllegatiMessaggio(this.dumpMessaggio.getIdTransazione(), this.dumpMessaggio.getServizioApplicativoErogatore(), this.dumpMessaggio.getDataConsegnaErogatore(), this.dumpMessaggio.getTipoMessaggio(), this.dumpMessaggio.getId());
            ArrayList<DumpAllegatoBean> allegati = new ArrayList<DumpAllegatoBean>();
            for (DumpAllegato dumpAllegato : allegatiCore) {
                allegati.add(new DumpAllegatoBean(dumpAllegato));
            }
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            ByteArrayInputStream in = null;
            int index = 1;
            for (DumpAllegato dumpAllegato : allegati) {
                int len;
                String allegatofileName = "allegato_" + index;
                String allegatoExt = MimeTypeUtils.fileExtensionForMIMEType((String)dumpAllegato.getContentType());
                allegatofileName = allegatofileName + "." + allegatoExt;
                zip.putNextEntry(new ZipEntry(allegatofileName));
                byte[] contenutoAllegato = dumpAllegato.getAllegato();
                in = new ByteArrayInputStream(contenutoAllegato);
                while ((len = in.read(bytes)) > 0) {
                    zip.write(bytes, 0, len);
                }
                zip.closeEntry();
                ((InputStream)in).close();
                try {
                    DumpAllegatoBean da = (DumpAllegatoBean)dumpAllegato;
                    if (da.isBase64()) {
                        contenutoAllegato = da.decodeBase64();
                        allegatofileName = "allegato_" + index + ".decodeBase64";
                        allegatofileName = allegatofileName + "." + allegatoExt;
                        zip.putNextEntry(new ZipEntry(allegatofileName));
                        in = new ByteArrayInputStream(contenutoAllegato);
                        while ((len = in.read(bytes)) > 0) {
                            zip.write(bytes, 0, len);
                        }
                        zip.closeEntry();
                        ((InputStream)in).close();
                    }
                }
                catch (Throwable e) {
                    this.log.error(e.getMessage(), e);
                }
                ++index;
            }
            zip.flush();
            zip.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download dell'allegato.");
        }
        return null;
    }

    public void setTipoMessaggio(String value) {
        if (value != null) {
            this.tipoMessaggio = (TipoMessaggio)TipoMessaggio.toEnumConstantFromString((String)value);
        }
    }

    public String getTipoMessaggio() {
        if (this.tipoMessaggio == null) {
            return null;
        }
        return this.tipoMessaggio.toString();
    }

    public TipoMessaggio getTipoMessaggioEnum() {
        return this.tipoMessaggio;
    }

    public void setTipoMessaggioEnum(TipoMessaggio tipoMessaggio) {
        this.tipoMessaggio = tipoMessaggio;
    }

    public String getTitoloPagina() {
        if (this.tipoMessaggio != null) {
            switch (this.tipoMessaggio) {
                case RICHIESTA_INGRESSO: {
                    return "Messaggio di Richiesta - Contenuti Ingresso";
                }
                case RICHIESTA_USCITA: {
                    return "Messaggio di Richiesta - Contenuti Uscita";
                }
                case RISPOSTA_INGRESSO: {
                    return "Messaggio di Risposta - Contenuti Ingresso";
                }
                case RISPOSTA_USCITA: {
                    return "Messaggio di Risposta - Contenuti Uscita";
                }
                case RICHIESTA_INGRESSO_DUMP_BINARIO: {
                    return "Messaggio di Richiesta - Dati Ingresso";
                }
                case RICHIESTA_USCITA_DUMP_BINARIO: {
                    return "Messaggio di Richiesta - Dati Uscita";
                }
                case RISPOSTA_INGRESSO_DUMP_BINARIO: {
                    return "Messaggio di Risposta - Dati Ingresso";
                }
                case RISPOSTA_USCITA_DUMP_BINARIO: {
                    return "Messaggio di Risposta - Dati Uscita";
                }
            }
            return "Contenuti Messaggio";
        }
        return "Contenuti Messaggio";
    }

    public Date getUltimaConsegna() {
        return this.ultimaConsegna;
    }

    public void setUltimaConsegna(Date ultimaConsegna) {
        this.ultimaConsegna = ultimaConsegna;
    }

    public boolean isVisualizzaContenutiMultipartButton() {
        if (this.dumpMessaggio != null && this.dumpMessaggio.getContentLength() != null && this.dumpMessaggio.getContentLength() > 0L) {
            String contentType = this.dumpMessaggio.getContentType();
            return DettagliBean.isVisualizzaContenutiMultipartButton(this.tipoMessaggio, contentType, this.dumpMessaggio.getContentLength(), this.multipartThreshold, this.log);
        }
        return false;
    }

    public void setVisualizzaContenutiMultipartButton(boolean visualizzaContenutiMultipartButton) {
    }

    public Boolean getExportContenutiMultipart() {
        return this.exportContenutiMultipart;
    }

    public void setExportContenutiMultipart(Boolean exportContenutiMultipart) {
        this.exportContenutiMultipart = exportContenutiMultipart;
    }

    public boolean isVisualizzaLinkEsporta() {
        return ((TransazioniSearchForm)((ITransazioniService)this.service).getSearch()).isShowButtonEsporta();
    }
}

