/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.AbstractCoreSearchForm;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.ExporterProperties;
import org.openspcoop2.web.monitor.transazioni.exporter.SingleFileExporter;
import org.openspcoop2.web.monitor.transazioni.servlet.DiagnosticiExporter;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TransazioniExporter
extends HttpServlet {
    private static final long serialVersionUID = 1272767433184676700L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static Boolean enableHeaderInfo = false;
    private static Boolean enableConsegneInfo = false;
    private static Boolean mimeThrowExceptionIfNotFound = false;
    private static boolean headersAsProperties = true;
    private static boolean contenutiAsProperties = false;
    private static ITracciaDriver tracciamentoService = null;
    private static IDiagnosticDriver diagnosticiService = null;

    public static void setEnableHeaderInfo(Boolean enableHeaderInfo) {
        TransazioniExporter.enableHeaderInfo = enableHeaderInfo;
    }

    public static void setEnableConsegneInfo(Boolean enableConsegneInfo) {
        TransazioniExporter.enableConsegneInfo = enableConsegneInfo;
    }

    public static void setMimeThrowExceptionIfNotFound(Boolean mimeThrowExceptionIfNotFound) {
        TransazioniExporter.mimeThrowExceptionIfNotFound = mimeThrowExceptionIfNotFound;
    }

    public static void setHeadersAsProperties(boolean headersAsProperties) {
        TransazioniExporter.headersAsProperties = headersAsProperties;
    }

    public static void setContenutiAsProperties(boolean contenutiAsProperties) {
        TransazioniExporter.contenutiAsProperties = contenutiAsProperties;
    }

    public static void setTracciamentoService(ITracciaDriver tracciamentoService) {
        TransazioniExporter.tracciamentoService = tracciamentoService;
    }

    public static void setDiagnosticiService(IDiagnosticDriver diagnosticiService) {
        TransazioniExporter.diagnosticiService = diagnosticiService;
    }

    public void init() throws ServletException {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            TransazioniExporter.setEnableHeaderInfo(govwayMonitorProperties.isAttivoTransazioniExportHeader());
            TransazioniExporter.setEnableConsegneInfo(govwayMonitorProperties.isAttivoTransazioniExportConsegneMultiple());
            TransazioniExporter.setMimeThrowExceptionIfNotFound(govwayMonitorProperties.isTransazioniDownloadThrowExceptionMimeTypeNotFound());
            TransazioniExporter.setHeadersAsProperties(govwayMonitorProperties.isAttivoTransazioniExportHeaderAsProperties());
            TransazioniExporter.setContenutiAsProperties(govwayMonitorProperties.isAttivoTransazioniExportContenutiAsProperties());
            TransazioniExporter.setTracciamentoService(govwayMonitorProperties.getDriverTracciamento());
            TransazioniExporter.setDiagnosticiService(govwayMonitorProperties.getDriverMsgDiagnostici());
        }
        catch (Exception e) {
            log.error("Inizializzazione servlet fallita, setto enableHeaderInfo=false", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            boolean exportConsentito;
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Context is null");
            }
            ITransazioniService service = (ITransazioniService)context.getBean("transazioniService");
            TransazioniSearchForm sfInSession = (TransazioniSearchForm)context.getBean("searchFormTransazioni");
            TransazioniSearchForm searchForm = (TransazioniSearchForm)sfInSession.clone();
            User utente = null;
            String modalita = null;
            LoginBean lbInSession = (LoginBean)context.getBean("loginBean");
            if (lbInSession != null && lbInSession.isLoggedIn()) {
                utente = lbInSession.getUtente();
                modalita = lbInSession.getModalita();
            }
            searchForm.setUser(utente);
            searchForm.setModalita(modalita);
            searchForm.saveProtocollo();
            service.setSearch((AbstractCoreSearchForm)searchForm);
            HttpServletResponse response = resp;
            String isAllString = req.getParameter("isAll");
            Boolean isAll = Boolean.parseBoolean(isAllString);
            String idtransazioni = req.getParameter("ids");
            String[] ids = StringUtils.split((String)idtransazioni, (String)",");
            String exporter = req.getParameter("exporter");
            String[] ex = StringUtils.split((String)exporter, (String)",");
            boolean exportTracce = false;
            boolean exportDiagnostici = false;
            boolean exportContenuti = false;
            if (ex != null) {
                for (String val : ex) {
                    if ("tracce".equals(val)) {
                        exportTracce = true;
                    }
                    if ("diagnostici".equals(val)) {
                        exportDiagnostici = true;
                    }
                    if (!"contenuti".equals(val)) continue;
                    exportContenuti = true;
                }
            }
            HttpSession sessione = req.getSession();
            Boolean isAllFromSession = (Boolean)sessione.getAttribute("isAllOriginale");
            String idTransazioniFromSession = (String)sessione.getAttribute("idTransazioniOriginali");
            String exporterFromSession = (String)sessione.getAttribute("exporterOriginali");
            sessione.removeAttribute("isAllOriginale");
            sessione.removeAttribute("idTransazioniOriginali");
            sessione.removeAttribute("exporterOriginali");
            String[] idsFromSession = StringUtils.split((String)idTransazioniFromSession, (String)",");
            String[] exFromSession = StringUtils.split((String)exporterFromSession, (String)",");
            boolean bl = exportConsentito = DiagnosticiExporter.checkParametri(isAll, ids, isAllFromSession, idsFromSession) && TransazioniExporter.checkTipiExport(ex, exFromSession);
            if (!exportConsentito) {
                String msgErrore = "L'utente non dispone dei permessi necessari per effettuare l'export delle transazioni.";
                String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msgErrore;
                response.sendRedirect(redirectUrl);
                return;
            }
            String fileName = "Transazioni.zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            response.setStatus(200);
            response.flushBuffer();
            Utility.setLoginMBean((LoginBean)((LoginBean)context.getBean("loginBean")));
            ExporterProperties prop = new ExporterProperties();
            prop.setEnableHeaderInfo(enableHeaderInfo);
            prop.setEnableConsegneInfo(enableConsegneInfo);
            prop.setExportContenuti(exportContenuti);
            prop.setExportDiagnostici(exportDiagnostici);
            prop.setExportTracce(exportTracce);
            prop.setMimeThrowExceptionIfNotFound(mimeThrowExceptionIfNotFound);
            prop.setHeadersAsProperties(headersAsProperties);
            prop.setContenutiAsProperties(contenutiAsProperties);
            prop.setUseCount(searchForm.isUseCount());
            SingleFileExporter sfe = new SingleFileExporter((OutputStream)response.getOutputStream(), prop, service, tracciamentoService, diagnosticiService, null);
            if (isAll != null && isAll.booleanValue()) {
                sfe.export();
            } else {
                ArrayList<String> idTransazioni = new ArrayList<String>();
                if (ids.length > 0) {
                    idTransazioni.addAll(Arrays.asList(ids));
                }
                sfe.export(idTransazioni);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            Utility.setLoginMBean(null);
        }
    }

    public static boolean checkTipiExport(String[] ex, String[] exFromSession) {
        boolean exportTracce = false;
        boolean exportDiagnostici = false;
        boolean exportContenuti = false;
        if (ex != null) {
            for (String val : ex) {
                if ("tracce".equals(val)) {
                    exportTracce = true;
                }
                if ("diagnostici".equals(val)) {
                    exportDiagnostici = true;
                }
                if (!"contenuti".equals(val)) continue;
                exportContenuti = true;
            }
        }
        boolean exportTracceFromSession = false;
        boolean exportDiagnosticiFromSession = false;
        boolean exportContenutiFromSession = false;
        if (exFromSession != null) {
            for (String val : exFromSession) {
                if ("tracce".equals(val)) {
                    exportTracceFromSession = true;
                }
                if ("diagnostici".equals(val)) {
                    exportDiagnosticiFromSession = true;
                }
                if (!"contenuti".equals(val)) continue;
                exportContenutiFromSession = true;
            }
        }
        if (exportContenuti != exportContenutiFromSession) {
            return false;
        }
        if (exportDiagnostici != exportDiagnosticiFromSession) {
            return false;
        }
        return exportTracce == exportTracceFromSession;
    }
}

