/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_serviziApplicativi {
    protected static boolean isServizioApplicativoInUso(Connection con, String tipoDB, IDServizioApplicativo idServizioApplicativo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean isRegistroServiziLocale, boolean normalizeObjectIds, boolean verificaRuoli) throws UtilsException {
        boolean bl;
        if (isRegistroServiziLocale) {
            // empty if block
        }
        String nomeMetodo = "isServizioApplicativoInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        try {
            ResultPorta resultPorta;
            String nome;
            boolean isInUso = false;
            long idServizioApplicativoLong = DBUtils.getIdServizioApplicativo((String)idServizioApplicativo.getNome(), (String)idServizioApplicativo.getIdSoggettoProprietario().getTipo(), (String)idServizioApplicativo.getIdSoggettoProprietario().getNome(), (Connection)con, (String)tipoDB);
            if (idServizioApplicativoLong <= 0L) {
                throw new UtilsException("Servizio Applicativo con id [" + String.valueOf(idServizioApplicativo) + "] non trovato");
            }
            List<String> autorizzazionePDMappingList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING);
            List<String> autorizzazionePDList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE);
            List<String> autorizzazionePAMappingList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING_PA);
            List<String> autorizzazionePAList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_PA);
            List<String> autorizzazionePAMappingModiList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING_PA_MODI);
            List<String> autorizzazionePAModiList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_PA_MODI);
            List<String> autorizzazioneTokenPDMappingList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_MAPPING_PD);
            List<String> autorizzazioneTokenPDList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_PD);
            List<String> autorizzazioneTokenPAMappingList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_MAPPING_PA);
            List<String> autorizzazioneTokenPAList = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_PA);
            List<String> ruoliPDMappingList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_MAPPING);
            List<String> ruoliPDList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI);
            List<String> ruoliPAMappingList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_MAPPING_PA);
            List<String> ruoliPAList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_PA);
            List<String> ruoliTokenPDMappingList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PD);
            List<String> ruoliTokenPDList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PD);
            List<String> ruoliTokenPAMappingList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA);
            List<String> ruoliTokenPAList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PA);
            List<String> ruoliTokenPAMappingModiList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA_MODI);
            List<String> ruoliTokenPAModiList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PA_MODI);
            List<String> porteApplicativeList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE);
            List<String> porteApplicativeMappingList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> ctList = whereIsInUso.get(ErrorsHandlerCostant.CONTROLLO_TRAFFICO);
            List<String> allarmeList = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI);
            List<String> trasformazionePDMappingList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PD);
            List<String> trasformazionePDList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_PD);
            List<String> trasformazionePAMappingList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PA);
            List<String> trasformazionePAList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_PA);
            List<String> modiSignalHubList = whereIsInUso.get(ErrorsHandlerCostant.IS_RIFERITA_MODI_SIGNAL_HUB);
            if (autorizzazionePDMappingList == null) {
                autorizzazionePDMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING, autorizzazionePDMappingList);
            }
            if (autorizzazionePDList == null) {
                autorizzazionePDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE, autorizzazionePDList);
            }
            if (autorizzazionePAMappingList == null) {
                autorizzazionePAMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING_PA, autorizzazionePAMappingList);
            }
            if (autorizzazionePAList == null) {
                autorizzazionePAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_PA, autorizzazionePAList);
            }
            if (autorizzazionePAMappingModiList == null) {
                autorizzazionePAMappingModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING_PA_MODI, autorizzazionePAMappingModiList);
            }
            if (autorizzazionePAModiList == null) {
                autorizzazionePAModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_PA_MODI, autorizzazionePAModiList);
            }
            if (autorizzazioneTokenPDMappingList == null) {
                autorizzazioneTokenPDMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_MAPPING_PD, autorizzazioneTokenPDMappingList);
            }
            if (autorizzazioneTokenPDList == null) {
                autorizzazioneTokenPDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_PD, autorizzazioneTokenPDList);
            }
            if (autorizzazioneTokenPAMappingList == null) {
                autorizzazioneTokenPAMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_MAPPING_PA, autorizzazioneTokenPAMappingList);
            }
            if (autorizzazioneTokenPAList == null) {
                autorizzazioneTokenPAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_TOKEN_PA, autorizzazioneTokenPAList);
            }
            if (ruoliPDMappingList == null) {
                ruoliPDMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_MAPPING, ruoliPDMappingList);
            }
            if (ruoliPDList == null) {
                ruoliPDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI, ruoliPDList);
            }
            if (ruoliPAMappingList == null) {
                ruoliPAMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_MAPPING_PA, ruoliPAMappingList);
            }
            if (ruoliPAList == null) {
                ruoliPAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_PA, ruoliPAList);
            }
            if (ruoliTokenPDMappingList == null) {
                ruoliTokenPDMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PD, ruoliPDMappingList);
            }
            if (ruoliTokenPDList == null) {
                ruoliTokenPDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PD, ruoliTokenPDList);
            }
            if (ruoliTokenPAMappingList == null) {
                ruoliTokenPAMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA, ruoliTokenPAMappingList);
            }
            if (ruoliTokenPAList == null) {
                ruoliTokenPAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PA, ruoliTokenPAList);
            }
            if (ruoliTokenPAMappingModiList == null) {
                ruoliTokenPAMappingModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA_MODI, ruoliTokenPAMappingModiList);
            }
            if (ruoliTokenPAModiList == null) {
                ruoliTokenPAModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PA_MODI, ruoliTokenPAModiList);
            }
            if (porteApplicativeList == null) {
                porteApplicativeList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, porteApplicativeList);
            }
            if (porteApplicativeMappingList == null) {
                porteApplicativeMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, porteApplicativeMappingList);
            }
            if (ctList == null) {
                ctList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONTROLLO_TRAFFICO, ctList);
            }
            if (allarmeList == null) {
                allarmeList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.ALLARMI, allarmeList);
            }
            if (trasformazionePDMappingList == null) {
                trasformazionePDMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PD, trasformazionePDMappingList);
            }
            if (trasformazionePDList == null) {
                trasformazionePDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_PD, trasformazionePDList);
            }
            if (trasformazionePAMappingList == null) {
                trasformazionePAMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PA, trasformazionePAMappingList);
            }
            if (trasformazionePAList == null) {
                trasformazionePAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_PA, trasformazionePAList);
            }
            if (modiSignalHubList == null) {
                modiSignalHubList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_RIFERITA_MODI_SIGNAL_HUB, modiSignalHubList);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_delegate_sa");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("porte_delegate_sa.id_porta=porte_delegate.id");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioApplicativoLong);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nome = risultato.getString("nome_porta");
                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    autorizzazionePDMappingList.add(resultPorta.label);
                } else {
                    autorizzazionePDList.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("pd_token_sa");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("pd_token_sa.id_porta=porte_delegate.id");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioApplicativoLong);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nome = risultato.getString("nome_porta");
                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    autorizzazioneTokenPDMappingList.add(resultPorta.label);
                } else {
                    autorizzazioneTokenPDList.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative_sa_auth");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("porte_applicative_sa_auth.id_porta=porte_applicative.id");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioApplicativoLong);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nome = risultato.getString("nome_porta");
                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    if (resultPorta.erogazioneModi) {
                        autorizzazionePAMappingModiList.add(resultPorta.label);
                    } else {
                        autorizzazionePAMappingList.add(resultPorta.label);
                    }
                } else if (resultPorta.erogazioneModi) {
                    autorizzazionePAModiList.add(resultPorta.label);
                } else {
                    autorizzazionePAList.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("pa_token_sa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("pa_token_sa.id_porta=porte_applicative.id");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioApplicativoLong);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nome = risultato.getString("nome_porta");
                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    autorizzazioneTokenPAMappingList.add(resultPorta.label);
                } else {
                    autorizzazioneTokenPAList.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            if (verificaRuoli) {
                ArrayList<String> listRuoliSA = new ArrayList<String>();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectField("ruolo");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("sa_ruoli.id_servizio_applicativo=servizi_applicativi.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idServizioApplicativoLong);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String ruolo = risultato.getString("ruolo");
                    listRuoliSA.add(ruolo);
                }
                risultato.close();
                stmt.close();
                if (!listRuoliSA.isEmpty()) {
                    boolean isInUsoRuoliToken;
                    DBOggettiInUsoUtils_serviziApplicativi.checkServizioApplicativoRuoloInUsoInPorteDelegate(con, tipoDB, normalizeObjectIds, "pd_ruoli", listRuoliSA, ruoliPDMappingList, ruoliPDList);
                    DBOggettiInUsoUtils_serviziApplicativi.checkServizioApplicativoRuoloInUsoInPorteDelegate(con, tipoDB, normalizeObjectIds, "pd_token_ruoli", listRuoliSA, ruoliTokenPDMappingList, ruoliTokenPDList);
                    boolean isInUsoRuoli = DBOggettiInUsoUtils_serviziApplicativi.checkServizioApplicativoRuoloInUsoInPorteApplicative(con, tipoDB, normalizeObjectIds, "pa_ruoli", listRuoliSA, ruoliPAMappingList, ruoliPAList, ruoliPAMappingList, ruoliPAList);
                    if (isInUsoRuoli) {
                        isInUso = true;
                    }
                    if (isInUsoRuoliToken = DBOggettiInUsoUtils_serviziApplicativi.checkServizioApplicativoRuoloInUsoInPorteApplicative(con, tipoDB, normalizeObjectIds, "pa_token_ruoli", listRuoliSA, ruoliTokenPAMappingList, ruoliTokenPAList, ruoliTokenPAMappingModiList, ruoliTokenPAModiList)) {
                        isInUso = true;
                    }
                }
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative_sa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_porta=porte_applicative.id");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioApplicativoLong);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nome = risultato.getString("nome_porta");
                ResultPorta resultPorta2 = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                if (resultPorta2.mapping) {
                    porteApplicativeMappingList.add(resultPorta2.label);
                } else {
                    porteApplicativeList.add(resultPorta2.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            int max = 2;
            if (!CostantiDB.isAllarmiEnabled()) {
                max = 1;
            }
            for (int i = 0; i < max; ++i) {
                String tabella = "ct_active_policy";
                String identificativo_column = "active_policy_id";
                String alias_column = "policy_alias";
                List<String> list = ctList;
                String oggetto = "Policy";
                boolean allarmi = false;
                if (i == 1) {
                    tabella = "allarmi";
                    identificativo_column = "nome";
                    alias_column = "alias";
                    list = allarmeList;
                    oggetto = "Allarme";
                    allarmi = true;
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addSelectField(identificativo_column);
                sqlQueryObject.addSelectField(alias_column);
                sqlQueryObject.addSelectField("filtro_ruolo");
                sqlQueryObject.addSelectField("filtro_porta");
                sqlQueryObject.setANDLogicOperator(false);
                sqlQueryObject.addWhereCondition(true, new String[]{tabella + ".filtro_tipo_fruitore = ?", tabella + ".filtro_nome_fruitore = ?", tabella + ".filtro_sa_fruitore = ?"});
                if (!allarmi) {
                    sqlQueryObject.addWhereCondition(true, new String[]{tabella + ".filtro_tipo_erogatore = ?", tabella + ".filtro_nome_erogatore = ?", tabella + ".filtro_sa_erogatore = ?"});
                }
                sqlQueryObject.addOrderBy("filtro_ruolo");
                sqlQueryObject.addOrderBy("filtro_porta");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                stmt.setString(index++, idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                stmt.setString(index++, idServizioApplicativo.getIdSoggettoProprietario().getNome());
                stmt.setString(index++, idServizioApplicativo.getNome());
                if (!allarmi) {
                    stmt.setString(index++, idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                    stmt.setString(index++, idServizioApplicativo.getIdSoggettoProprietario().getNome());
                    stmt.setString(index++, idServizioApplicativo.getNome());
                }
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String alias = risultato.getString(alias_column);
                    if (alias == null || "".equals(alias)) {
                        alias = risultato.getString(identificativo_column);
                    }
                    String nomePorta = risultato.getString("filtro_porta");
                    String filtro_ruolo = risultato.getString("filtro_ruolo");
                    if (nomePorta != null) {
                        String tipo = null;
                        String label = null;
                        if ("delegata".equals(filtro_ruolo)) {
                            try {
                                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    label = "Fruizione di Servizio " + resultPorta.label;
                                }
                            }
                            catch (Exception e) {
                                tipo = "Outbound";
                            }
                        } else if ("applicativa".equals(filtro_ruolo)) {
                            try {
                                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    label = "Erogazione di Servizio " + resultPorta.label;
                                }
                            }
                            catch (Exception e) {
                                tipo = "Inbound";
                            }
                        } else {
                            tipo = filtro_ruolo;
                        }
                        if (label == null) {
                            list.add(oggetto + " '" + alias + "' attiva nella porta '" + tipo + "' '" + nomePorta + "' ");
                        } else {
                            list.add(oggetto + " '" + alias + "' attiva nella " + label);
                        }
                    } else {
                        list.add(oggetto + " '" + alias + "'");
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("pd_transform_sa");
            sqlQueryObject.addFromTable("pd_transform");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("pd_transform.id_porta=porte_delegate.id");
            sqlQueryObject.addWhereCondition("pd_transform_sa.id_trasformazione=pd_transform.id");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioApplicativoLong);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nome2 = risultato.getString("nome_porta");
                ResultPorta resultPorta3 = DBOggettiInUsoUtils.formatPortaDelegata(nome2, tipoDB, con, normalizeObjectIds);
                if (resultPorta3.mapping) {
                    trasformazionePDMappingList.add(resultPorta3.label);
                } else {
                    trasformazionePDList.add(resultPorta3.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("pa_transform_sa");
            sqlQueryObject.addFromTable("pa_transform");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("pa_transform.id_porta=porte_applicative.id");
            sqlQueryObject.addWhereCondition("pa_transform_sa.id_trasformazione=pa_transform.id");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioApplicativoLong);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nome3 = risultato.getString("nome_porta");
                ResultPorta resultPorta4 = DBOggettiInUsoUtils.formatPortaApplicativa(nome3, tipoDB, con, normalizeObjectIds);
                if (resultPorta4.mapping) {
                    trasformazionePAMappingList.add(resultPorta4.label);
                } else {
                    trasformazionePAList.add(resultPorta4.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            if ("modipa".equals(idServizioApplicativo.getIdSoggettoProprietario().getTipo())) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("protocol_properties");
                sqlQueryObject.addSelectAliasField("servizi", "tipo_servizio", "tipoServizio");
                sqlQueryObject.addSelectAliasField("servizi", "nome_servizio", "nomeServizio");
                sqlQueryObject.addSelectAliasField("servizi", "versione_servizio", "versioneServizio");
                sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggetto");
                sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("servizi.id = protocol_properties.id_proprietario");
                sqlQueryObject.addWhereCondition("protocol_properties.tipo_proprietario=?");
                sqlQueryObject.addWhereCondition("protocol_properties.name=?");
                sqlQueryObject.addWhereCondition("protocol_properties.value_string=?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                stmt.setString(index++, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA.name());
                stmt.setString(index++, "modipaInfoGenSignalHubPulisherSA");
                stmt.setString(index++, idServizioApplicativo.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    IDServizio idS = IDServizioFactory.getInstance().getIDServizioFromValues(risultato.getString("tipoServizio"), risultato.getString("nomeServizio"), risultato.getString("tipoSoggetto"), risultato.getString("nomeSoggetto"), risultato.getInt("versioneServizio"));
                    IDPortaApplicativa idPA = DBMappingUtils.getIDPortaApplicativaAssociataDefault((IDServizio)idS, (Connection)con, (String)tipoDB);
                    if (idPA != null) {
                        ResultPorta resultPorta5 = DBOggettiInUsoUtils.formatPortaApplicativa(idPA.getNome(), tipoDB, con, normalizeObjectIds);
                        modiSignalHubList.add(resultPorta5.label);
                    } else {
                        modiSignalHubList.add(idS.toString());
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato2, stmt2);
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(risultato2, stmt2);
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkServizioApplicativoRuoloInUsoInPorteDelegate(Connection con, String tipoDB, boolean normalizeObjectIds, String nomeTabella, List<String> listRuoliSA, List<String> ruoliPDmappingList, List<String> ruoliPDlist) throws Exception {
        boolean isInUso = false;
        Statement stmt = null;
        ResultSet risultato = null;
        try {
            Object resultPorta;
            ArrayList<String> distinctPorteDelegate = new ArrayList<String>();
            ArrayList<String> verificaPorteDelegateAll = new ArrayList<String>();
            for (String ruolo : listRuoliSA) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("ruoli_match");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=porte_delegate.id");
                sqlQueryObject.addWhereCondition(nomeTabella + ".ruolo=?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, ruolo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String nome = risultato.getString("nome_porta");
                    String ruoloMatch = risultato.getString("ruoli_match");
                    if (RuoloTipoMatch.ANY.getValue().equals(ruoloMatch)) {
                        if (distinctPorteDelegate.contains(nome)) continue;
                        distinctPorteDelegate.add(nome);
                        resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                        if (((ResultPorta)resultPorta).mapping) {
                            ruoliPDmappingList.add(((ResultPorta)resultPorta).label);
                        } else {
                            ruoliPDlist.add(((ResultPorta)resultPorta).label);
                        }
                        isInUso = true;
                        continue;
                    }
                    if (verificaPorteDelegateAll.contains(nome)) continue;
                    verificaPorteDelegateAll.add(nome);
                }
                risultato.close();
                stmt.close();
            }
            if (!verificaPorteDelegateAll.isEmpty()) {
                for (String nome : verificaPorteDelegateAll) {
                    ArrayList<String> listRuoliPorta = new ArrayList<String>();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("porte_delegate");
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addSelectField("ruolo");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_porta=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=porte_delegate.id");
                    String queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setString(1, nome);
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        String ruolo = risultato.getString("ruolo");
                        listRuoliPorta.add(ruolo);
                    }
                    risultato.close();
                    stmt.close();
                    if (listRuoliPorta.isEmpty()) continue;
                    boolean match = true;
                    for (String ruoloPorta : listRuoliPorta) {
                        if (listRuoliSA.contains(ruoloPorta)) continue;
                        match = false;
                        break;
                    }
                    if (!match || distinctPorteDelegate.contains(nome)) continue;
                    distinctPorteDelegate.add(nome);
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (((ResultPorta)resultPorta).mapping) {
                        ruoliPDmappingList.add(((ResultPorta)resultPorta).label);
                    } else {
                        ruoliPDlist.add(((ResultPorta)resultPorta).label);
                    }
                    isInUso = true;
                }
            }
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return isInUso;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkServizioApplicativoRuoloInUsoInPorteApplicative(Connection con, String tipoDB, boolean normalizeObjectIds, String nomeTabella, List<String> listRuoliSA, List<String> ruoliPAmappingList, List<String> ruoliPAlist, List<String> ruoliPAmappingModiList, List<String> ruoliPAmodiList) throws Exception {
        boolean isInUso = false;
        Statement stmt = null;
        ResultSet risultato = null;
        try {
            Object resultPorta;
            ArrayList<String> distinctPorteApplicative = new ArrayList<String>();
            ArrayList<String> verificaPorteApplicativeAll = new ArrayList<String>();
            for (String ruolo : listRuoliSA) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("ruoli_match");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=porte_applicative.id");
                sqlQueryObject.addWhereCondition(nomeTabella + ".ruolo=?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, ruolo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String nome = risultato.getString("nome_porta");
                    String ruoloMatch = risultato.getString("ruoli_match");
                    if (RuoloTipoMatch.ANY.getValue().equals(ruoloMatch)) {
                        if (distinctPorteApplicative.contains(nome)) continue;
                        distinctPorteApplicative.add(nome);
                        resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                        if (((ResultPorta)resultPorta).mapping) {
                            if (((ResultPorta)resultPorta).erogazioneModi) {
                                ruoliPAmappingModiList.add(((ResultPorta)resultPorta).label);
                            } else {
                                ruoliPAmappingList.add(((ResultPorta)resultPorta).label);
                            }
                        } else if (((ResultPorta)resultPorta).erogazioneModi) {
                            ruoliPAmodiList.add(((ResultPorta)resultPorta).label);
                        } else {
                            ruoliPAlist.add(((ResultPorta)resultPorta).label);
                        }
                        isInUso = true;
                        continue;
                    }
                    if (verificaPorteApplicativeAll.contains(nome)) continue;
                    verificaPorteApplicativeAll.add(nome);
                }
                risultato.close();
                stmt.close();
            }
            if (!verificaPorteApplicativeAll.isEmpty()) {
                for (String nome : verificaPorteApplicativeAll) {
                    ArrayList<String> listRuoliPorta = new ArrayList<String>();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addSelectField("ruolo");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addWhereCondition("porte_applicative.nome_porta=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=porte_applicative.id");
                    String queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setString(1, nome);
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        String ruolo = risultato.getString("ruolo");
                        listRuoliPorta.add(ruolo);
                    }
                    risultato.close();
                    stmt.close();
                    if (listRuoliPorta.isEmpty()) continue;
                    boolean match = true;
                    for (String ruoloPorta : listRuoliPorta) {
                        if (listRuoliSA.contains(ruoloPorta)) continue;
                        match = false;
                        break;
                    }
                    if (!match || distinctPorteApplicative.contains(nome)) continue;
                    distinctPorteApplicative.add(nome);
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (((ResultPorta)resultPorta).mapping) {
                        if (((ResultPorta)resultPorta).erogazioneModi) {
                            ruoliPAmappingModiList.add(((ResultPorta)resultPorta).label);
                        } else {
                            ruoliPAmappingList.add(((ResultPorta)resultPorta).label);
                        }
                    } else if (((ResultPorta)resultPorta).erogazioneModi) {
                        ruoliPAmodiList.add(((ResultPorta)resultPorta).label);
                    } else {
                        ruoliPAlist.add(((ResultPorta)resultPorta).label);
                    }
                    isInUso = true;
                }
            }
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return isInUso;
    }

    protected static String toString(IDServizioApplicativo idServizioApplicativo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        StringBuilder bf = new StringBuilder();
        if (normalizeObjectIds) {
            try {
                String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                String labelSA = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + idServizioApplicativo.getNome() + DBOggettiInUsoUtils.getSubjectSuffix(protocollo, idServizioApplicativo.getIdSoggettoProprietario());
                bf.append(labelSA);
            }
            catch (Exception e) {
                bf.append(idServizioApplicativo.getIdSoggettoProprietario().toString() + "_" + idServizioApplicativo.getNome());
            }
        } else {
            bf.append(idServizioApplicativo.getIdSoggettoProprietario().toString() + "_" + idServizioApplicativo.getNome());
        }
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        StringBuilder msgBuilder = new StringBuilder("Applicativo '" + bf.toString() + "' non eliminabile perch&egrave; :" + separator);
        if (!prefix) {
            msgBuilder = new StringBuilder("");
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block33: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && !messages.isEmpty()) {
                msgBuilder.append(separatorCategorie);
            }
            switch (key) {
                case AUTORIZZAZIONE_MAPPING: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nel Controllo degli Accessi (Autorizzazione Trasporto - Richiedenti Autorizzati) delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nelle Porte Outbound (Controllo degli Accessi - Autorizzazione Trasporto -  Richiedenti Autorizzati): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nel Controllo degli Accessi (Autorizzazione Trasporto - Richiedenti Autorizzati) delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Controllo degli Accessi - Autorizzazione Trasporto - Richiedenti Autorizzati): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_MAPPING_PA_MODI: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nel Controllo degli Accessi (Autorizzazione Messaggio - Richiedenti Autorizzati) delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_PA_MODI: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Controllo degli Accessi - Autorizzazione Messaggio - Richiedenti Autorizzati): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_TOKEN_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nel Controllo degli Accessi (Autorizzazione Token - Richiedenti Autorizzati) delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_TOKEN_PD: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nelle Porte Outbound (Controllo degli Accessi - Autorizzazione Token - Richiedenti Autorizzati): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_TOKEN_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nel Controllo degli Accessi (Autorizzazione Token - Richiedenti Autorizzati) delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case AUTORIZZAZIONE_TOKEN_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Controllo degli Accessi - Autorizzazione Token - Richiedenti Autorizzati): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_MAPPING: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Trasporto per Ruoli indicata nel Controllo degli Accessi delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Trasporto per Ruoli indicata nel Controllo degli Accessi delle Porte Outbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Trasporto per Ruoli indicata nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Trasporto per Ruoli indicata nel Controllo degli Accessi delle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_TOKEN_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Token per Ruoli indicata nel Controllo degli Accessi delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_TOKEN_PD: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Token per Ruoli indicata nel Controllo degli Accessi delle Porte Outbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_TOKEN_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Token per Ruoli indicata nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_TOKEN_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Token per Ruoli indicata nel Controllo degli Accessi delle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_TOKEN_MAPPING_PA_MODI: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Messaggio per Ruoli indicata nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case RUOLI_TOKEN_PA_MODI: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("compatibile con l'Autorizzazione Messaggio per Ruoli indicata nel Controllo degli Accessi delle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato come applicativo server nei connettori delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case IN_USO_IN_PORTE_APPLICATIVE: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("in uso in Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case CONTROLLO_TRAFFICO: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato in policy di Rate Limiting: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case ALLARMI: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato in Allarmi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case TRASFORMAZIONE_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nel criterio di applicabilit\u00e0 della Trasformazione (Applicativi) per le Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case TRASFORMAZIONE_PD: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nelle Porte Outbound (Criterio di applicabilit\u00e0 della Trasformazione - Applicativi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case TRASFORMAZIONE_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nel criterio di applicabilit\u00e0 della Trasformazione (Applicativi) per le Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case TRASFORMAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Criterio di applicabilit\u00e0 della Trasformazione - Applicativi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
                case IS_RIFERITA_MODI_SIGNAL_HUB: {
                    if (messages == null || messages.isEmpty()) continue block33;
                    msgBuilder.append("riferito nella configurazione 'SignalHub' dell'erogazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block33;
                }
            }
            msgBuilder.append("utilizzato in oggetto non codificato (" + String.valueOf(key) + ")" + separator);
        }
        return msgBuilder.toString();
    }
}

