/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.builder;

import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import jakarta.xml.soap.SOAPElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.builder.BustaBuilder;
import org.openspcoop2.protocol.sdi.SDIBustaRawContent;
import org.openspcoop2.protocol.sdi.builder.SDIImbustamento;
import org.openspcoop2.protocol.sdi.builder.SDISbustamento;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;

public class SDIBustaBuilder
extends BustaBuilder<SOAPElement> {
    protected SDIProperties sdiProperties;
    private SDIImbustamento sdiImbustamento;
    private SDISbustamento sdiSbustamento;

    public SDIBustaBuilder(IProtocolFactory<SOAPElement> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.sdiProperties = SDIProperties.getInstance(this.log);
        this.sdiImbustamento = new SDIImbustamento(this);
        this.sdiSbustamento = new SDISbustamento(this);
    }

    public ProtocolMessage imbustamento(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        if (FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO.equals((Object)faseImbustamento)) {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setPhaseUnsupported(true);
            return protocolMessage;
        }
        ProtocolMessage protocolMessage = super.imbustamento(msg, context, busta, bustaRichiesta, ruoloMessaggio, proprietaManifestAttachments, faseImbustamento);
        if (!busta.getTipoDestinatario().equals(this.sdiProperties.getTipoSoggettoSDI())) {
            throw new ProtocolException("TipoDestinatario[" + busta.getTipoDestinatario() + "] differente da quello atteso per il Sistema di Interscambio [" + this.sdiProperties.getTipoSoggettoSDI() + "]");
        }
        if (!busta.getDestinatario().equals(this.sdiProperties.getNomeSoggettoSDI())) {
            boolean whiteList = false;
            if (busta.getDestinatario() != null && this.sdiProperties.getSoggettiWhiteList().contains(busta.getDestinatario())) {
                this.log.debug("Destinatario [" + busta.getDestinatario() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                throw new ProtocolException("NomeDestinatario[" + busta.getDestinatario() + "] differente da quello atteso per il Sistema di Interscambio [" + this.sdiProperties.getNomeSoggettoSDI() + "]");
            }
        }
        SOAPElement element = null;
        if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
            if ("SdIRiceviFile".equals(busta.getServizio()) && "RiceviFile".equals(busta.getAzione())) {
                element = this.sdiImbustamento.creaRichiesta_ServizioSdIRiceviFile_AzioneRiceviFile(this.protocolFactory, this.state, busta, msg, context);
            } else if ("SdIRiceviNotifica".equals(busta.getServizio()) && "NotificaEsito".equals(busta.getAzione())) {
                element = this.sdiImbustamento.creaRichiesta_ServizioSdIRiceviNotifica_AzioneNotificaEsito(this.protocolFactory, this.state, busta, msg, this.sdiProperties.isEnableGenerazioneMessaggiCompatibilitaNamespaceSenzaGov(), this.sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov(), context);
            } else {
                boolean whiteList = false;
                if (busta.getServizio() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getServizio()) && busta.getAzione() != null && this.sdiProperties.getAzioniWhiteList().contains(busta.getAzione())) {
                    this.log.debug("Servizio [" + busta.getServizio() + "] e Azione [" + busta.getAzione() + "] in white list");
                    whiteList = true;
                }
                if (!whiteList) {
                    throw new ProtocolException("Servizio[" + busta.getServizio() + "] e Azione[" + busta.getAzione() + "] non gestite dal protocollo durante la fase di richiesta");
                }
            }
        } else {
            if (busta.sizeListaEccezioni() > 0) {
                boolean ignoraEccezioniNonGravi = this.protocolFactory.createProtocolManager().isIgnoraEccezioniNonGravi();
                if (ignoraEccezioniNonGravi) {
                    if (busta.containsEccezioniGravi()) {
                        this.enrichFault(msg, busta, ignoraEccezioniNonGravi, this.sdiProperties.isPortaApplicativaBustaErrore_personalizzaElementiFault(), this.sdiProperties.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo());
                    }
                } else {
                    this.enrichFault(msg, busta, ignoraEccezioniNonGravi, this.sdiProperties.isPortaApplicativaBustaErrore_personalizzaElementiFault(), this.sdiProperties.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo());
                }
            }
            try {
                OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
                if (soapMsg.getSOAPBody() != null && soapMsg.getSOAPBody().hasFault()) {
                    return null;
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if ("RicezioneFatture".equals(busta.getServizio()) && "RiceviFatture".equals(busta.getAzione())) {
                element = this.sdiImbustamento.creaRisposta_ServizioRicezioneFatture_AzioneRiceviFatture(this.protocolFactory, this.state, busta, msg);
            } else {
                boolean whiteList = false;
                if (busta.getServizio() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getServizio()) && busta.getAzione() != null && this.sdiProperties.getAzioniWhiteList().contains(busta.getAzione())) {
                    this.log.debug("Servizio [" + busta.getServizio() + "] e Azione [" + busta.getAzione() + "] in white list");
                    whiteList = true;
                }
                if (!whiteList) {
                    throw new ProtocolException("Servizio[" + busta.getServizio() + "] e Azione[" + busta.getAzione() + "] non gestite dal protocollo durante la fase di risposta");
                }
            }
        }
        if (element != null) {
            protocolMessage.setBustaRawContent((BustaRawContent)new SDIBustaRawContent(element));
        }
        return protocolMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtocolMessage sbustamento(OpenSPCoop2Message msg, Context context, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseSbustamento faseSbustamento, ServiceBinding integrationServiceBinding, ServiceBindingConfiguration serviceBindingConfiguration) throws ProtocolException {
        try {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setMessage(msg);
            if (FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RICHIESTA.equals((Object)faseSbustamento) || FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RISPOSTA.equals((Object)faseSbustamento)) return protocolMessage;
            SOAPElement se = null;
            if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
                if ("TrasmissioneFatture".equals(busta.getServizio())) {
                    if ("RicevutaConsegna".equals(busta.getAzione())) {
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi.RC, busta, msg);
                    } else if ("NotificaMancataConsegna".equals(busta.getAzione())) {
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi.MC, busta, msg);
                    } else if ("NotificaScarto".equals(busta.getAzione())) {
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi.NS, busta, msg);
                    } else if ("NotificaEsito".equals(busta.getAzione())) {
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi.NE, busta, msg);
                    } else if ("NotificaDecorrenzaTermini".equals(busta.getAzione())) {
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi.DT, busta, msg);
                    } else {
                        if (!"AttestazioneTrasmissioneFattura".equals(busta.getAzione())) throw new ProtocolException("Servizio[" + busta.getServizio() + "] con Azione[" + busta.getAzione() + "] non gestita dal protocollo durante la fase di richiesta");
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi.AT, busta, msg);
                    }
                } else if ("RicezioneFatture".equals(busta.getServizio())) {
                    if ("RiceviFatture".equals(busta.getAzione())) {
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioRicezioneFatture_AzioneRiceviFatture(busta, msg);
                    } else {
                        if (!"NotificaDecorrenzaTermini".equals(busta.getAzione())) throw new ProtocolException("Servizio[" + busta.getServizio() + "] con Azione[" + busta.getAzione() + "] non gestita dal protocollo durante la fase di richiesta");
                        se = this.sdiSbustamento.sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi.DT, busta, msg);
                    }
                } else {
                    boolean whiteList = false;
                    if (busta.getServizio() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getServizio()) && busta.getAzione() != null && this.sdiProperties.getAzioniWhiteList().contains(busta.getAzione())) {
                        this.log.debug("Servizio [" + busta.getServizio() + "] e Azione [" + busta.getAzione() + "] in white list");
                        whiteList = true;
                    }
                    if (!whiteList) {
                        throw new ProtocolException("Servizio[" + busta.getServizio() + "] non gestite dal protocollo durante la fase di richiesta");
                    }
                }
            } else if ("SdIRiceviFile".equals(busta.getServizio()) && "RiceviFile".equals(busta.getAzione())) {
                se = this.sdiSbustamento.sbustamentoRisposta_ServizioSdIRiceviFile_AzioneRiceviFile(busta, msg);
            } else if ("SdIRiceviNotifica".equals(busta.getServizio()) && "NotificaEsito".equals(busta.getAzione())) {
                se = this.sdiSbustamento.sbustamentoRisposta_ServizioSdIRiceviNotifica_AzioneNotificaEsito(busta, msg, context);
            } else {
                boolean whiteList = false;
                if (busta.getServizio() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getServizio()) && busta.getAzione() != null && this.sdiProperties.getAzioniWhiteList().contains(busta.getAzione())) {
                    this.log.debug("Servizio [" + busta.getServizio() + "] e Azione [" + busta.getAzione() + "] in white list");
                    whiteList = true;
                }
                if (!whiteList) {
                    throw new ProtocolException("Servizio[" + busta.getServizio() + "] e Azione[" + busta.getAzione() + "] non gestite dal protocollo durante la fase di risposta");
                }
            }
            if (se != null) {
                protocolMessage.setBustaRawContent((BustaRawContent)new SDIBustaRawContent(se));
            }
            protocolMessage.setMessage(msg);
            return protocolMessage;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

