/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.utils;

import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRiceviNotifica;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRicezioneFatture;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioTrasmissioneFatture;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreNomeFile;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.utils.IDSerialGenerator;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorType;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDIUtils {
    public static SOAPElement readHeader(OpenSPCoop2SoapMessage msg) throws ProtocolException {
        List xomReference = null;
        try {
            OpenSPCoop2MessageFactory messageFactory = msg.getFactory();
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null || !soapBody.hasChildNodes()) {
                return null;
            }
            if (soapBody.hasFault()) {
                return null;
            }
            Object element = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)soapBody);
            if ("fileSdIConMetadati".equals(element.getLocalName()) && SDICostantiServizioRicezioneFatture.RICEZIONE_SERVIZIO_RICEZIONE_FATTURE_NAMESPACE.equals(element.getNamespaceURI())) {
                xomReference = msg.mtomFastUnpackagingForXSDConformance();
                element = (Element)element.cloneNode(true);
                childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)element, (boolean)false);
                for (i = 0; i < childs.size(); ++i) {
                    Node child = (Node)childs.get(i);
                    if ("File".equals(child.getLocalName())) {
                        child.setTextContent("ContenutoBase64");
                        continue;
                    }
                    if (!"Metadati".equals(child.getLocalName())) continue;
                    child.setTextContent("ContenutoBase64");
                }
            } else if ("fileSdI".equals(element.getLocalName()) && SDICostantiServizioRicezioneFatture.RICEZIONE_SERVIZIO_RICEZIONE_FATTURE_NAMESPACE.equals(element.getNamespaceURI())) {
                xomReference = msg.mtomFastUnpackagingForXSDConformance();
                element = (Element)element.cloneNode(true);
                childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)element, (boolean)false);
                for (i = 0; i < childs.size(); ++i) {
                    Node child = (Node)childs.get(i);
                    if (!"File".equals(child.getLocalName())) continue;
                    child.setTextContent("ContenutoBase64");
                }
            } else if ("fileSdI".equals(element.getLocalName()) && SDICostantiServizioRiceviNotifica.SDI_SERVIZIO_RICEVI_NOTIFICA_NAMESPACE.equals(element.getNamespaceURI())) {
                xomReference = msg.mtomFastUnpackagingForXSDConformance();
                element = (Element)element.cloneNode(true);
                childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)element, (boolean)false);
                for (i = 0; i < childs.size(); ++i) {
                    Node child = (Node)childs.get(i);
                    if (!"File".equals(child.getLocalName())) continue;
                    child.setTextContent("ContenutoBase64");
                }
            } else if ("rispostaSdINotificaEsito".equals(element.getLocalName()) && SDICostantiServizioRiceviNotifica.SDI_SERVIZIO_RICEVI_NOTIFICA_NAMESPACE.equals(element.getNamespaceURI())) {
                xomReference = msg.mtomFastUnpackagingForXSDConformance();
                element = (Element)element.cloneNode(true);
                childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)element, (boolean)false);
                for (i = 0; i < childs.size(); ++i) {
                    Node child = (Node)childs.get(i);
                    if (!"ScartoEsito".equals(child.getLocalName())) continue;
                    List childsScarto = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)child, (boolean)false);
                    for (int j = 0; j < childsScarto.size(); ++j) {
                        Node childScarto = (Node)childsScarto.get(j);
                        if (!"File".equals(childScarto.getLocalName())) continue;
                        childScarto.setTextContent("ContenutoBase64");
                    }
                }
            } else if (SDICostantiServizioTrasmissioneFatture.TRASMISSIONE_SERVIZIO_TRASMISSIONE_FATTURE_NAMESPACE.equals(element.getNamespaceURI())) {
                xomReference = msg.mtomFastUnpackagingForXSDConformance();
                element = (Element)element.cloneNode(true);
                childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)element, (boolean)false);
                for (i = 0; i < childs.size(); ++i) {
                    Node child = (Node)childs.get(i);
                    if (!"File".equals(child.getLocalName())) continue;
                    child.setTextContent("ContenutoBase64");
                }
            }
            SOAPElement se = SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)messageFactory, (MessageType)msg.getMessageType()).createElement((Element)element);
            try {
                msg.mtomRestoreAfterXSDConformance(xomReference);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            return se;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getNomeFileMessaggi(IProtocolFactory<?> factory, IState state, String nomeFileFattura, TipiMessaggi tipo) throws ProtocolException {
        ConfigurazionePdD config = factory.getConfigurazionePdD();
        IDSerialGenerator serialGenerator = new IDSerialGenerator(config.getLog(), state, config.getTipoDatabase());
        IDSerialGeneratorParameter serialGeneratorParameter = new IDSerialGeneratorParameter(factory.getProtocol());
        serialGeneratorParameter.setSerializableTimeWaitMs(config.getAttesaAttivaJDBC());
        serialGeneratorParameter.setSerializableNextIntervalTimeMs(config.getCheckIntervalJDBC());
        serialGeneratorParameter.setTipo(IDSerialGeneratorType.ALFANUMERICO);
        serialGeneratorParameter.setWrap(false);
        serialGeneratorParameter.setSize(Integer.valueOf(3));
        serialGeneratorParameter.setInformazioneAssociataAlProgressivo(SDIValidatoreNomeFile.getNomeFileFatturaSenzaEstensione(nomeFileFattura));
        String ext = ".xml";
        return SDIValidatoreNomeFile.getNomeFileFatturaPerMessaggi(nomeFileFattura) + "_" + tipo.name() + "_" + serialGenerator.buildID(serialGeneratorParameter) + ext;
    }

    public static String getNomeFileFattura(IProtocolFactory<?> factory, IState state, String idPaeseTrasmittente, String idCodiceTrasmittente, String formatoInvio) throws ProtocolException {
        if (idPaeseTrasmittente == null) {
            throw new ProtocolException("IdPaeseTrasmittente non fornito (richiesto per la creazione del nome di file)");
        }
        if (idCodiceTrasmittente == null) {
            throw new ProtocolException("IdCodiceTrasmittente non fornito (richiesto per la creazione del nome di file)");
        }
        String idPaeseIdCodice = idPaeseTrasmittente + idCodiceTrasmittente;
        ConfigurazionePdD config = factory.getConfigurazionePdD();
        IDSerialGenerator serialGenerator = new IDSerialGenerator(config.getLog(), state, config.getTipoDatabase());
        IDSerialGeneratorParameter serialGeneratorParameter = new IDSerialGeneratorParameter(factory.getProtocol());
        serialGeneratorParameter.setSerializableTimeWaitMs(config.getAttesaAttivaJDBC());
        serialGeneratorParameter.setSerializableNextIntervalTimeMs(config.getCheckIntervalJDBC());
        serialGeneratorParameter.setTipo(IDSerialGeneratorType.ALFANUMERICO);
        serialGeneratorParameter.setWrap(false);
        serialGeneratorParameter.setSize(Integer.valueOf(5));
        serialGeneratorParameter.setInformazioneAssociataAlProgressivo(idPaeseIdCodice);
        String ext = ".xml";
        if ("ZIP".equals(formatoInvio)) {
            ext = ".zip";
        } else if ("P7M".equals(formatoInvio)) {
            ext = ".xml.p7m";
        }
        return idPaeseIdCodice + "_" + serialGenerator.buildID(serialGeneratorParameter) + ext;
    }

    public static List<byte[]> splitLotto(byte[] lotto) throws Exception {
        Node n;
        int i;
        ArrayList<byte[]> risultato = new ArrayList<byte[]>();
        XMLUtils xmlUtils = XMLUtils.getInstance();
        XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
        Element lottoElement = null;
        DynamicNamespaceContext dnc = null;
        try {
            lottoElement = xmlUtils.newElement(lotto);
            dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace((Node)lottoElement);
        }
        catch (Exception e) {
            throw new Exception("Lettura lotto di fattura non riuscita: " + e.getMessage(), e);
        }
        NodeList nl = null;
        try {
            nl = (NodeList)xpathEngine.getMatchPattern(lottoElement, dnc, "//FatturaElettronicaBody", XPathReturnType.NODESET);
        }
        catch (XPathNotFoundException notFound) {
            throw new Exception("La fattura non contiene alcun body?: " + notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new Exception("Estrazione body dal lotto di fattura non riuscita: " + e.getMessage(), e);
        }
        if (nl == null) {
            throw new Exception("La fattura non contiene alcun body? (null)");
        }
        if (nl.getLength() < 1) {
            throw new Exception("La fattura non contiene alcun body? (size): " + nl.getLength());
        }
        if (nl.getLength() == 1) {
            risultato.add(lotto);
            return risultato;
        }
        ArrayList<Node> listBody = new ArrayList<Node>();
        try {
            for (i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                listBody.add(n);
                lottoElement.removeChild(n);
            }
        }
        catch (Exception e) {
            throw new Exception("Elaborazione lotto di fattura (step1) non riuscita: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < listBody.size(); ++i) {
                n = (Node)listBody.get(i);
                lottoElement.appendChild(n);
                risultato.add(xmlUtils.toByteArray(lottoElement));
                lottoElement.removeChild(n);
            }
        }
        catch (Exception e) {
            throw new Exception("Elaborazione lotto di fattura (step2-" + i + ") non riuscita: " + e.getMessage(), e);
        }
        return risultato;
    }
}

