/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.jsf.ValidatorConfig;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.validator.Validator;

public class ValidateHandler
extends MetaTagHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private String validatorId;

    public ValidateHandler(TagConfig config) {
        super(config);
    }

    public ValidateHandler(ValidatorConfig config) {
        this((TagConfig)config);
        this.validatorId = config.getValidatorId();
    }

    @Override
    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent == null || !(parent instanceof EditableValueHolder)) {
            throw new TagException(this.tag, "Parent not an instance of EditableValueHolder: " + parent);
        }
        if (parent.getParent() == null) {
            EditableValueHolder evh = (EditableValueHolder)((Object)parent);
            ValueExpression ve = null;
            Validator v = null;
            if (this.binding != null) {
                ve = this.binding.getValueExpression(ctx, Validator.class);
                v = (Validator)ve.getValue((ELContext)ctx);
            }
            if (v == null) {
                v = this.createValidator(ctx);
                if (ve != null) {
                    ve.setValue((ELContext)ctx, (Object)v);
                }
            }
            if (v == null) {
                throw new TagException(this.tag, "No Validator was created");
            }
            this.setAttributes(ctx, v);
            evh.addValidator(v);
        }
    }

    protected Validator createValidator(FaceletContext ctx) {
        if (this.validatorId == null) {
            throw new TagException(this.tag, "Default behavior invoked of requiring a validator-id passed in the constructor, must override ValidateHandler(ValidatorConfig)");
        }
        return ctx.getFacesContext().getApplication().createValidator(this.validatorId);
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type) {
        return super.createMetaRuleset(type).ignore("binding");
    }
}

