/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.util.Util;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

class ApplicationMap
extends BaseContextMap {
    private final ServletContext servletContext;

    ApplicationMap(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void clear() {
        Enumeration e = this.servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            this.servletContext.removeAttribute((String)e.nextElement());
        }
    }

    @Override
    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.servletContext.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object get(Object key) {
        Util.notNull("key", key);
        return this.servletContext.getAttribute(key.toString());
    }

    @Override
    public Object put(Object key, Object value) {
        Util.notNull("key", key);
        Object result = this.servletContext.getAttribute(key.toString());
        this.servletContext.setAttribute(key.toString(), value);
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        Object result = this.servletContext.getAttribute(keyString);
        this.servletContext.removeAttribute(keyString);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.servletContext.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof ApplicationMap && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * this.servletContext.hashCode();
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += ((Object)i.next()).hashCode();
        }
        return hashCode;
    }

    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this, this.servletContext.getAttributeNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this, this.servletContext.getAttributeNames());
    }

    protected Iterator<Object> getValueIterator() {
        return new BaseContextMap.ValueIterator(this, this.servletContext.getAttributeNames());
    }
}

