/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessagesRenderer
extends HtmlBasicRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.MESSAGESMESSAGES);

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        UIMessages messages = (UIMessages)component;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = null;
        if (clientId == null && messages.isGlobalOnly()) {
            clientId = "";
        }
        Iterator<FacesMessage> messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            return;
        }
        String layout = (String)component.getAttributes().get("layout");
        boolean showSummary = messages.isShowSummary();
        boolean showDetail = messages.isShowDetail();
        String styleClass = (String)component.getAttributes().get("styleClass");
        String style = (String)component.getAttributes().get("style");
        boolean wroteTable = false;
        if (style != null) {
            String cssClassName = RenderKitUtils.getCssId(context, component);
            RenderKitUtils.writeStyle(writer, context, component, cssClassName, style);
            styleClass = RenderKitUtils.concatStyleClasses(styleClass, cssClassName);
        }
        if (layout != null && layout.equals("table")) {
            writer.startElement("table", component);
            wroteTable = true;
        } else {
            writer.startElement("ul", component);
        }
        this.writeIdAttributeIfNecessary(context, writer, component);
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component, ATTRIBUTES);
        int i = 0;
        while (messageIter.hasNext()) {
            Object val;
            FacesMessage curMessage = messageIter.next();
            String severityStyle = null;
            String severityStyleClass = null;
            String summary = curMessage.getSummary();
            summary = null != summary ? summary : "";
            String detail = curMessage.getDetail();
            String string = detail = null != detail ? detail : summary;
            if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severityStyle = (String)component.getAttributes().get("infoStyle");
                severityStyleClass = (String)component.getAttributes().get("infoClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severityStyle = (String)component.getAttributes().get("warnStyle");
                severityStyleClass = (String)component.getAttributes().get("warnClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severityStyle = (String)component.getAttributes().get("errorStyle");
                severityStyleClass = (String)component.getAttributes().get("errorClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severityStyle = (String)component.getAttributes().get("fatalStyle");
                severityStyleClass = (String)component.getAttributes().get("fatalClass");
            }
            if (severityStyle != null) {
                String cssClassName = RenderKitUtils.getCssId(context, component).concat("-msg-" + i);
                RenderKitUtils.writeStyle(writer, context, component, cssClassName, severityStyle);
                severityStyleClass = RenderKitUtils.concatStyleClasses(severityStyleClass, cssClassName);
            }
            if (wroteTable) {
                writer.startElement("tr", component);
            } else {
                writer.startElement("li", component);
            }
            if (severityStyleClass != null) {
                styleClass = severityStyleClass;
                writer.writeAttribute("class", styleClass, "styleClass");
            }
            if (wroteTable) {
                writer.startElement("td", component);
            }
            boolean isTooltip = (val = component.getAttributes().get("tooltip")) != null && Boolean.valueOf(val.toString()) != false;
            boolean wroteTooltip = false;
            if (showSummary && showDetail && isTooltip) {
                writer.startElement("span", component);
                String title = (String)component.getAttributes().get("title");
                if (title == null || title.length() == 0) {
                    writer.writeAttribute("title", summary, "title");
                }
                writer.flush();
                writer.writeText("\t", component, null);
                wroteTooltip = true;
            }
            if (!wroteTooltip && showSummary) {
                writer.writeText("\t", component, null);
                writer.writeText(summary, component, null);
                writer.writeText(" ", component, null);
            }
            if (showDetail) {
                writer.writeText(detail, component, null);
            }
            if (wroteTooltip) {
                writer.endElement("span");
            }
            if (wroteTable) {
                writer.endElement("td");
                writer.endElement("tr");
            } else {
                writer.endElement("li");
            }
            ++i;
        }
        if (wroteTable) {
            writer.endElement("table");
        } else {
            writer.endElement("ul");
        }
    }
}

