/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class TableRenderer
extends BaseTableRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.DATATABLE);

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        ResponseWriter writer = context.getResponseWriter();
        this.renderTableStart(context, component, writer, ATTRIBUTES);
        this.renderCaption(context, data, writer);
        this.renderHeader(context, component, writer);
        this.renderFooter(context, component, writer);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        UIData data = (UIData)component;
        ResponseWriter writer = context.getResponseWriter();
        int processed = 0;
        int rowIndex = data.getFirst() - 1;
        int rows = data.getRows();
        this.renderTableBodyStart(context, component, writer);
        while (rows <= 0 || ++processed <= rows) {
            data.setRowIndex(++rowIndex);
            if (!data.isRowAvailable()) break;
            this.renderRowStart(context, component, writer);
            this.renderRow(context, component, null, writer);
            this.renderRowEnd(context, component, writer);
        }
        this.renderTableBodyEnd(context, component, writer);
        data.setRowIndex(-1);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        this.clearMetaInfo(context, component);
        ((UIData)component).setRowIndex(-1);
        this.renderTableEnd(context, component, context.getResponseWriter());
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void renderFooter(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, table);
        UIComponent footer = this.getFacet(table, "footer");
        String footerClass = (String)table.getAttributes().get("footerClass");
        if (footer != null || info.hasFooterFacets) {
            writer.startElement("tfoot", table);
            writer.writeText("\n", table, null);
        }
        if (info.hasFooterFacets) {
            writer.startElement("tr", table);
            writer.writeText("\n", table, null);
            for (UIColumn column : info.columns) {
                String columnFooterClass = (String)column.getAttributes().get("footerClass");
                writer.startElement("td", column);
                if (columnFooterClass != null) {
                    writer.writeAttribute("class", columnFooterClass, "columnFooterClass");
                } else if (footerClass != null) {
                    writer.writeAttribute("class", footerClass, "footerClass");
                }
                UIComponent facet = this.getFacet(column, "footer");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("td");
                writer.writeText("\n", table, null);
            }
            this.renderRowEnd(context, table, writer);
        }
        if (footer != null) {
            writer.startElement("tr", footer);
            writer.startElement("td", footer);
            if (footerClass != null) {
                writer.writeAttribute("class", footerClass, "footerClass");
            }
            writer.writeAttribute("colspan", String.valueOf(info.columns.size()), null);
            this.encodeRecursive(context, footer);
            writer.endElement("td");
            this.renderRowEnd(context, table, writer);
        }
        if (footer != null || info.hasFooterFacets) {
            writer.endElement("tfoot");
            writer.writeText("\n", table, null);
        }
    }

    @Override
    protected void renderHeader(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, table);
        UIComponent header = this.getFacet(table, "header");
        String headerClass = (String)table.getAttributes().get("headerClass");
        if (header != null || info.hasHeaderFacets) {
            writer.startElement("thead", table);
            writer.writeText("\n", table, null);
        }
        if (header != null) {
            writer.startElement("tr", header);
            writer.startElement("th", header);
            if (headerClass != null) {
                writer.writeAttribute("class", headerClass, "headerClass");
            }
            writer.writeAttribute("colspan", String.valueOf(info.columns.size()), null);
            writer.writeAttribute("scope", "colgroup", null);
            this.encodeRecursive(context, header);
            writer.endElement("th");
            this.renderRowEnd(context, table, writer);
        }
        if (info.hasHeaderFacets) {
            writer.startElement("tr", table);
            writer.writeText("\n", table, null);
            for (UIColumn column : info.columns) {
                String columnHeaderClass = (String)column.getAttributes().get("headerClass");
                writer.startElement("th", column);
                if (columnHeaderClass != null) {
                    writer.writeAttribute("class", columnHeaderClass, "columnHeaderClass");
                } else if (headerClass != null) {
                    writer.writeAttribute("class", headerClass, "headerClass");
                }
                writer.writeAttribute("scope", "col", null);
                UIComponent facet = this.getFacet(column, "header");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("th");
                writer.writeText("\n", table, null);
            }
            this.renderRowEnd(context, table, writer);
        }
        if (header != null || info.hasHeaderFacets) {
            writer.endElement("thead");
            writer.writeText("\n", table, null);
        }
    }

    @Override
    protected void renderRow(FacesContext context, UIComponent table, UIComponent child, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(context, table);
        info.newRow();
        for (UIColumn column : info.columns) {
            writer.startElement("td", column);
            String columnClass = info.getCurrentColumnClass();
            if (columnClass != null) {
                writer.writeAttribute("class", columnClass, "columnClasses");
            }
            Iterator<UIComponent> gkids = this.getChildren(column);
            while (gkids.hasNext()) {
                this.encodeRecursive(context, gkids.next());
            }
            writer.endElement("td");
            writer.writeText("\n", table, null);
        }
    }
}

