/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import jakarta.el.ValueExpression;
import jakarta.servlet.ServletContext;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;

public class Util {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String RENDERKIT_LOGGER = ".renderkit";
    public static final String TAGLIB_LOGGER = ".taglib";
    public static final String APPLICATION_LOGGER = ".application";
    public static final String CONTEXT_LOGGER = ".context";
    public static final String CONFIG_LOGGER = ".config";
    public static final String LIFECYCLE_LOGGER = ".lifecycle";
    public static final String TIMING_LOGGER = ".timing";
    private static final String unitTestModeEnabled = "com.sun.faces.unitTestModeEnabled";
    private static final String coreTLVEnabled = "com.sun.faces.coreTLVEnabled";
    private static final String htmlTLVEnabled = "com.sun.faces.htmlTLVEnabled";
    private static final String patternCacheKey = "com.sun.faces.patternCache";
    private static ThreadLocal<Map<String, Object>> nonFacesContextApplicationMap;

    private Util() {
        throw new IllegalStateException();
    }

    private static void setNonFacesContextApplicationMap(Map<String, Object> instance) {
        Util.lazilyInitializeNonFacesContextApplicationMap();
        if (null == instance) {
            nonFacesContextApplicationMap.remove();
        } else {
            nonFacesContextApplicationMap.set(instance);
        }
    }

    private static void lazilyInitializeNonFacesContextApplicationMap() {
        if (null == nonFacesContextApplicationMap) {
            nonFacesContextApplicationMap = new ThreadLocal<Map<String, Object>>(){

                @Override
                protected Map<String, Object> initialValue() {
                    return null;
                }
            };
        }
    }

    private static Map<String, Object> getNonFacesContextApplicationMap() {
        Util.lazilyInitializeNonFacesContextApplicationMap();
        return nonFacesContextApplicationMap.get();
    }

    private static Map<String, Object> getApplicationMap() {
        ExternalContext externalContext;
        Map<String, Object> result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context && null != (externalContext = context.getExternalContext())) {
            result = externalContext.getApplicationMap();
        }
        if (null == result && null == (result = Util.getNonFacesContextApplicationMap())) {
            result = new HashMap<String, Object>();
            Util.setNonFacesContextApplicationMap(result);
        }
        return result;
    }

    private static Map<String, Pattern> getPatternCache() {
        Map<String, Object> appMap = Util.getApplicationMap();
        LRUMap result = (LRUMap)appMap.get(patternCacheKey);
        if (null == result) {
            result = new LRUMap(15);
            appMap.put(patternCacheKey, result);
        }
        return result;
    }

    private static Map<String, Pattern> getPatternCache(ServletContext sc) {
        LRUMap result = (LRUMap)sc.getAttribute(patternCacheKey);
        if (null == result) {
            result = new LRUMap(15);
            sc.setAttribute(patternCacheKey, result);
        }
        return result;
    }

    public static boolean isPortletRequest(FacesContext context) {
        return context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase") != null;
    }

    public static Object getListenerInstance(ValueExpression type, ValueExpression binding) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Object instance = null;
        if (faces == null) {
            return null;
        }
        if (binding != null) {
            instance = binding.getValue(faces.getELContext());
        }
        if (instance == null && type != null) {
            try {
                instance = ReflectionUtils.newInstance((String)type.getValue(faces.getELContext()));
            }
            catch (Exception e) {
                throw new AbortProcessingException(e.getMessage(), e);
            }
            if (binding != null) {
                binding.setValue(faces.getELContext(), instance);
            }
        }
        return instance;
    }

    public static void setUnitTestModeEnabled(boolean enabled) {
        Map<String, Object> appMap = Util.getApplicationMap();
        appMap.put(unitTestModeEnabled, enabled);
    }

    public static boolean isUnitTestModeEnabled() {
        Boolean result = false;
        Map<String, Object> appMap = Util.getApplicationMap();
        result = (Boolean)appMap.get(unitTestModeEnabled);
        return null == result ? false : result;
    }

    public static void setCoreTLVActive(boolean active) {
        Map<String, Object> appMap = Util.getApplicationMap();
        appMap.put(coreTLVEnabled, active);
    }

    public static boolean isCoreTLVActive() {
        Boolean result = true;
        Map<String, Object> appMap = Util.getApplicationMap();
        result = (Boolean)appMap.get(coreTLVEnabled);
        return null == result ? true : result;
    }

    public static void setHtmlTLVActive(boolean active) {
        Map<String, Object> appMap = Util.getApplicationMap();
        appMap.put(htmlTLVEnabled, active);
    }

    public static boolean isHtmlTLVActive() {
        Boolean result = true;
        Map<String, Object> appMap = Util.getApplicationMap();
        result = (Boolean)appMap.get(htmlTLVEnabled);
        return null == result ? true : result;
    }

    public static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Util.getCurrentLoader(fallbackClass);
        if (name.charAt(0) == '[') {
            return Class.forName(name, true, loader);
        }
        return loader.loadClass(name);
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    public static void notNull(String varname, Object var) {
        if (var == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", varname));
        }
    }

    public static Locale getLocaleFromContextOrSystem(FacesContext context) {
        UIViewRoot root;
        Locale temp;
        Locale result = temp = Locale.getDefault();
        if (null != context && null != (root = context.getViewRoot()) && null == (result = root.getLocale())) {
            result = temp;
        }
        return result;
    }

    public static Converter getConverterForClass(Class converterClass, FacesContext context) {
        if (converterClass == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Converter getConverterForIdentifer(String converterId, FacesContext context) {
        if (converterId == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StateManager getStateManager(FacesContext context) throws FacesException {
        return context.getApplication().getStateManager();
    }

    public static ViewHandler getViewHandler(FacesContext context) throws FacesException {
        Application application = context.getApplication();
        assert (application != null);
        ViewHandler viewHandler = application.getViewHandler();
        assert (viewHandler != null);
        return viewHandler;
    }

    public static boolean componentIsDisabled(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled")));
    }

    public static boolean componentIsDisabledOrReadonly(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled"))) != false || Boolean.valueOf(String.valueOf(component.getAttributes().get("readonly"))) != false;
    }

    public static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        String lang = null;
        String country = null;
        String variant = null;
        char[] seps = new char[]{'-', '_'};
        int i = 0;
        int j = 0;
        int inputLength = localeStr.length();
        if (inputLength >= 2 && (i = Util.indexOfSet(localeStr, seps, 0)) == -1) {
            if (inputLength != 2) {
                throw new IllegalArgumentException("Illegal locale String: " + localeStr);
            }
            lang = localeStr.toLowerCase();
        }
        if (i != -1) {
            lang = localeStr.substring(0, i);
            if (inputLength >= 5 && (j = Util.indexOfSet(localeStr, seps, i + 1)) == -1) {
                if (inputLength != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                country = localeStr.substring(i + 1);
            }
            if (j != -1) {
                country = localeStr.substring(i + 1, j);
                if (inputLength >= 8) {
                    variant = localeStr.substring(j + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
            }
        }
        if (variant != null && country != null && lang != null) {
            result = new Locale(lang, country, variant);
        } else if (lang != null && country != null) {
            result = new Locale(lang, country);
        } else if (lang != null) {
            result = new Locale(lang, "");
        }
        return result;
    }

    public static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (str.charAt(i) != set[j]) continue;
                result = i;
                break;
            }
            if (result != -1) break;
        }
        return result;
    }

    public static void parameterNonNull(Object param) throws FacesException {
        if (null == param) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "param"));
        }
    }

    public static void parameterNonEmpty(String param) throws FacesException {
        if (null == param || 0 == param.length()) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EMPTY_PARAMETER", new Object[0]));
        }
    }

    public static String getStackTraceString(Throwable e) {
        if (null == e) {
            return "";
        }
        StackTraceElement[] stacks = e.getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stacks.length; ++i) {
            sb.append(stacks[i].toString()).append('\n');
        }
        return sb.toString();
    }

    public static String getContentTypeFromResponse(Object response) {
        String result = null;
        if (null != response) {
            try {
                Object obj;
                Method method = ReflectionUtils.lookupMethod(response.getClass(), "getContentType", RIConstants.EMPTY_CLASS_ARGS);
                if (null != method && null != (obj = method.invoke(response, RIConstants.EMPTY_METH_ARGS))) {
                    result = obj.toString();
                }
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
        return result;
    }

    public static boolean prefixViewTraversal(FacesContext context, UIComponent root, TreeTraversalCallback action) throws FacesException {
        boolean keepGoing = action.takeActionOnNode(context, root);
        if (keepGoing) {
            Iterator<UIComponent> kids = root.getFacetsAndChildren();
            while (kids.hasNext() && keepGoing) {
                keepGoing = Util.prefixViewTraversal(context, kids.next(), action);
            }
        }
        return keepGoing;
    }

    public static FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    public static synchronized String[] split(String toSplit, String regex) {
        Map<String, Pattern> patternCache = Util.getPatternCache();
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static synchronized String[] split(ServletContext sc, String toSplit, String regex) {
        Map<String, Pattern> patternCache = Util.getPatternCache(sc);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static String getFacesMapping(FacesContext context) {
        String pathInfo;
        String servletPath;
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        Map<String, Object> stateMap = RequestStateManager.getStateMap(context);
        String mapping = (String)stateMap.get("com.sun.faces.INVOCATION_PATH");
        if (mapping == null && (mapping = Util.getMappingForRequest(servletPath = extContext.getRequestServletPath(), pathInfo = extContext.getRequestPathInfo())) == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{servletPath});
        }
        if (mapping != null) {
            stateMap.put("com.sun.faces.INVOCATION_PATH", mapping);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + mapping);
        }
        return mapping;
    }

    private static String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath " + servletPath);
            LOGGER.log(Level.FINE, "pathInfo " + pathInfo);
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    public static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    public static interface TreeTraversalCallback {
        public boolean takeActionOnNode(FacesContext var1, UIComponent var2) throws FacesException;
    }
}

