/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.function.BiConsumer;

public abstract class AbstractCPMessageTask<P>
extends AbstractMessageTask<P>
implements BiConsumer<Object, Throwable> {
    protected AbstractCPMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected void query(CPGroupId groupId, RaftOp op, QueryPolicy policy) {
        RaftInvocationManager invocationManager = this.getInvocationManager();
        InternalCompletableFuture future = invocationManager.query(groupId, op, policy, false);
        future.whenCompleteAsync((BiConsumer)this, ConcurrencyUtil.CALLER_RUNS);
    }

    protected void invoke(CPGroupId groupId, RaftOp op) {
        RaftInvocationManager invocationManager = this.getInvocationManager();
        InternalCompletableFuture future = invocationManager.invoke(groupId, op, false);
        future.whenCompleteAsync((BiConsumer)this, ConcurrencyUtil.CALLER_RUNS);
    }

    private RaftInvocationManager getInvocationManager() {
        RaftService service = (RaftService)this.nodeEngine.getService("hz:core:raft");
        return service.getInvocationManager();
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.sendResponse(response);
        } else {
            this.handleProcessingFailure(throwable);
        }
    }
}

