/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.internal.ascii.CommandParser;
import com.hazelcast.internal.ascii.TextCommand;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.memcache.ErrorCommand;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.nio.ascii.TextDecoder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;

abstract class HttpCommandParser<HC extends HttpCommand>
implements CommandParser {
    HttpCommandParser() {
    }

    @Override
    public final TextCommand parser(TextDecoder decoder, String cmd, int space) {
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken();
        if (!st.hasMoreTokens()) {
            return new ErrorCommand(TextCommandConstants.TextCommandType.ERROR_CLIENT);
        }
        String uri = st.nextToken();
        try {
            String urlDecodedUri = URLDecoder.decode(uri, "UTF-8");
            return this.createHttpCommand(decoder, urlDecodedUri);
        }
        catch (UnsupportedEncodingException e) {
            return new ErrorCommand(TextCommandConstants.TextCommandType.ERROR_SERVER, "UTF-8 encoding is not supported by JVM!");
        }
    }

    abstract HC createHttpCommand(TextDecoder var1, String var2);
}

