/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.Dialog;
import org.openspcoop2.web.lib.mvc.GeneralLink;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageDataException;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class PageData
implements Serializable {
    private static final long serialVersionUID = 1L;
    String pageDescription = "";
    String search = "auto";
    String searchDescription = "";
    boolean searchNote = false;
    String searchLabel = "Ricerca";
    int searchNumEntries = -1;
    String mode = "";
    String message = "";
    String messageType = MessageType.ERROR.toString();
    String messageTitle = "";
    List<GeneralLink> titlelist = new ArrayList<GeneralLink>();
    List<?> dati = new ArrayList();
    List<?> menu = new ArrayList();
    List<?> areaBottoni = new ArrayList();
    Map<String, String> hidden = new HashMap<String, String>();
    String page = "";
    String op = "";
    String[] labels;
    String[][] bottoni = null;
    boolean inserisciBottoni = true;
    boolean addButton = true;
    boolean removeButton = true;
    boolean select = true;
    List<DataElement> filterNames = null;
    List<DataElement> filterValues = null;
    int pageSize = 20;
    int index = 0;
    int numEntries = 0;
    boolean mostraLinkHome = false;
    List<String> linkHomeLabels = null;
    String customListViewName = null;
    String labelBottoneInvia = "Salva";
    String labelBottoneFiltra = "Filtra";
    String labelBottoneRipulsci = "Ripulisci";
    String labelBottoneCustom = null;
    String funzioneBottoneCustom = null;
    private boolean showAjaxStatusBottoneInvia = true;
    private boolean showAjaxStatusBottoneFiltra = true;
    private boolean showAjaxStatusBottoneRipulisci = true;
    private List<DataElement> comandiAzioneBarraTitoloDettaglioElemento = new ArrayList<DataElement>();
    private List<String> idsDaVisualizzareSelezionati;
    private boolean nascondiButtonRowLogin;
    Dialog dialog = null;
    boolean postBackResult = false;
    boolean includiMenuLateraleSx = true;
    private boolean paginazione = true;
    private boolean inserisciSearch = true;

    public PageData() {
        this.setInserisciSearch(true);
        this.idsDaVisualizzareSelezionati = new ArrayList<String>();
        this.nascondiButtonRowLogin = false;
    }

    public void setPageDescription(String s) {
        this.pageDescription = s;
    }

    public String getPageDescription() {
        return this.pageDescription;
    }

    public int getSearchNumEntries() {
        return this.searchNumEntries;
    }

    public void setSearchNumEntries(int searchNumEntries) {
        this.searchNumEntries = searchNumEntries;
    }

    public String getSearchLabel() {
        return this.searchLabel;
    }

    public void setSearchLabel(String searchLabel) {
        this.searchLabel = searchLabel;
    }

    public boolean isSearchNote() {
        return this.searchNote;
    }

    public void setSearchNote(boolean searchNote) {
        this.searchNote = searchNote;
    }

    public void setSearch(String s) {
        this.search = s;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearchDescription(String s) {
        this.searchDescription = s;
    }

    public String getSearchDescription() {
        if (this.searchDescription != null && !this.searchDescription.equals("")) {
            int idx1 = this.searchDescription.indexOf("'");
            int idx2 = this.searchDescription.lastIndexOf("'");
            if (idx1 > -1 && idx2 > -1) {
                String s = this.searchDescription.substring(0, idx2);
                return s.substring(idx1 + 1);
            }
        }
        return this.searchDescription;
    }

    public void setMode(String s) {
        this.mode = s;
    }

    public void disableEditMode() {
        this.mode = "view-noeditbutton";
    }

    public void disableOnlyButton() {
        this.mode = "view-nobutton";
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isDisableEditMode() {
        return "view-noeditbutton".equals(this.mode);
    }

    public void setMessage(String s) {
        this.setMessage(s, MessageType.ERROR);
    }

    public void setMessage(String s, MessageType type) {
        this.setMessage(s, null, type);
    }

    public void setMessage(String s, String title, MessageType type) {
        this.message = s;
        this.messageType = type.toString();
        this.messageTitle = title;
        if (this.messageTitle == null) {
            switch (type) {
                case CONFIRM: {
                    this.messageTitle = "Conferma Operazione";
                    break;
                }
                case ERROR: {
                    this.messageTitle = "Messaggio di Errore";
                    break;
                }
                case WARN: {
                    this.messageTitle = "Attenzione";
                    break;
                }
                case INFO: {
                    this.messageTitle = "Messaggio Informativo";
                    break;
                }
                case INFO_SINTETICO: 
                case ERROR_SINTETICO: 
                case WARN_SINTETICO: {
                    this.messageTitle = this.message;
                    break;
                }
                case DIALOG: {
                    this.messageTitle = "Finestra di Dialogo";
                }
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageTitle() {
        return this.messageTitle;
    }

    public void setPage(String s) {
        this.page = s;
    }

    public String getPage() {
        return this.page;
    }

    public void setOp(String s) {
        this.op = s;
    }

    public String getOp() {
        return this.op;
    }

    public void setTitleList(List<GeneralLink> v) {
        this.titlelist = v;
    }

    public List<GeneralLink> getTitleList() {
        return this.titlelist;
    }

    public void setDati(List<?> v) {
        this.dati = v;
    }

    public List<?> getDati() {
        return this.dati;
    }

    public void setMenu(List<?> v) {
        this.menu = v;
    }

    public List<?> getMenu() {
        return this.menu;
    }

    public void setAreaBottoni(List<?> v) {
        this.areaBottoni = v;
    }

    public List<?> getAreaBottoni() {
        return this.areaBottoni;
    }

    public void setHidden(Map<String, String> v) {
        this.hidden = v;
    }

    public Map<String, String> getHidden() {
        return this.hidden;
    }

    public void addHidden(String name, String value) {
        this.hidden.put(name, value);
    }

    public String getHidden(String name) {
        return this.hidden.get(name);
    }

    public void clearHidden() {
        this.hidden.clear();
    }

    public void setLabels(String[] s) {
        if (s != null && s.length > 0) {
            this.labels = new String[s.length];
            for (int i = 0; i < s.length; ++i) {
                this.labels[i] = DataElement.getEscapedValue(s[i]);
            }
        } else {
            this.labels = s;
        }
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setBottoni(String[][] s) {
        this.bottoni = s;
    }

    public String[][] getBottoni() {
        return this.bottoni;
    }

    public void setInserisciBottoni(boolean b) {
        this.inserisciBottoni = b;
    }

    public boolean getInserisciBottoni() {
        return this.inserisciBottoni;
    }

    public void setAddButton(boolean b) {
        this.addButton = b;
    }

    public boolean getAddButton() {
        return this.addButton;
    }

    public void setSelect(boolean b) {
        this.select = b;
    }

    public boolean getSelect() {
        return this.select;
    }

    public void setRemoveButton(boolean b) {
        this.removeButton = b;
    }

    public boolean getRemoveButton() {
        return this.removeButton;
    }

    public static String getParametroFilterName(int position) {
        return "filterName_" + position;
    }

    public static String getParametroFilterValue(int position) {
        return "filterValue_" + position;
    }

    public void addFilter(String name, String label, String valueSelected, String[] values, String[] labels, boolean postBack, int size) throws PageDataException {
        this.addFilter(name, label, valueSelected, values, labels, postBack, size, false);
    }

    public void addFilter(String name, String label, String valueSelected, String[] values, String[] labels, boolean postBack, int size, boolean disabilitaFiltroRisultati) throws PageDataException {
        if (this.filterNames == null) {
            this.filterNames = new ArrayList<DataElement>();
            this.filterValues = new ArrayList<DataElement>();
        }
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName(PageData.getParametroFilterName(this.filterNames.size()));
        if (name == null) {
            throw new PageDataException("Name not found");
        }
        deName.setValue(name);
        this.filterNames.add(deName);
        DataElement deValue = new DataElement();
        deValue.setType(DataElementType.SELECT);
        deValue.setName(PageData.getParametroFilterValue(this.filterValues.size()));
        if (label == null) {
            throw new PageDataException("Label not found");
        }
        deValue.setLabel(label);
        deValue.setSelected(valueSelected);
        deValue.setValue(valueSelected);
        if (values == null || values.length <= 0) {
            throw new PageDataException("Values not found");
        }
        deValue.setValues(values);
        deValue.setLabels(labels);
        deValue.setSize(size);
        deValue.setPostBack(postBack);
        if (disabilitaFiltroRisultati) {
            deValue.disabilitaFiltroOpzioniSelect();
        }
        this.filterValues.add(deValue);
    }

    public void addTextFilter(String name, String label, String value, int size) throws PageDataException {
        this.addTextFilter(name, label, value, size, false);
    }

    public void addTextFilter(String name, String label, String value, int size, boolean noedit) throws PageDataException {
        if (this.filterNames == null) {
            this.filterNames = new ArrayList<DataElement>();
            this.filterValues = new ArrayList<DataElement>();
        }
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName(PageData.getParametroFilterName(this.filterNames.size()));
        if (name == null) {
            throw new PageDataException("Name not found");
        }
        deName.setValue(name);
        this.filterNames.add(deName);
        DataElement deValue = new DataElement();
        deValue.setType(noedit ? DataElementType.TEXT : DataElementType.TEXT_EDIT);
        deValue.setName(PageData.getParametroFilterValue(this.filterValues.size()));
        if (label == null) {
            throw new PageDataException("Label not found");
        }
        deValue.setLabel(label);
        deValue.setValue(value);
        deValue.setSize(size);
        this.filterValues.add(deValue);
    }

    public void addTextAreaFilter(String name, String label, String value, int size, Integer rows, Integer cols) throws PageDataException {
        if (this.filterNames == null) {
            this.filterNames = new ArrayList<DataElement>();
            this.filterValues = new ArrayList<DataElement>();
        }
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName(PageData.getParametroFilterName(this.filterNames.size()));
        if (name == null) {
            throw new PageDataException("Name not found");
        }
        deName.setValue(name);
        this.filterNames.add(deName);
        DataElement deValue = new DataElement();
        deValue.setType(DataElementType.TEXT_AREA);
        deValue.setName(PageData.getParametroFilterValue(this.filterValues.size()));
        if (label == null) {
            throw new PageDataException("Label not found");
        }
        deValue.setLabel(label);
        deValue.setValue(value);
        deValue.setSize(size);
        if (rows != null) {
            deValue.setRows(rows);
        }
        if (cols != null) {
            deValue.setCols(cols);
        }
        this.filterValues.add(deValue);
    }

    public void addNumberFilter(String name, String label, String value, int size, Integer min, Integer max) throws PageDataException {
        if (this.filterNames == null) {
            this.filterNames = new ArrayList<DataElement>();
            this.filterValues = new ArrayList<DataElement>();
        }
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName(PageData.getParametroFilterName(this.filterNames.size()));
        if (name == null) {
            throw new PageDataException("Name not found");
        }
        deName.setValue(name);
        this.filterNames.add(deName);
        DataElement deValue = new DataElement();
        deValue.setType(DataElementType.NUMBER);
        deValue.setName(PageData.getParametroFilterValue(this.filterValues.size()));
        if (label == null) {
            throw new PageDataException("Label not found");
        }
        deValue.setLabel(label);
        deValue.setValue(value);
        deValue.setSize(size);
        deValue.setMinValue(min);
        deValue.setMaxValue(max);
        this.filterValues.add(deValue);
    }

    public void addCheckboxFilter(String name, String label, String value, int size) throws PageDataException {
        if (this.filterNames == null) {
            this.filterNames = new ArrayList<DataElement>();
            this.filterValues = new ArrayList<DataElement>();
        }
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName(PageData.getParametroFilterName(this.filterNames.size()));
        if (name == null) {
            throw new PageDataException("Name not found");
        }
        deName.setValue(name);
        this.filterNames.add(deName);
        DataElement deValue = new DataElement();
        deValue.setType(DataElementType.CHECKBOX);
        deValue.setName(PageData.getParametroFilterValue(this.filterValues.size()));
        if (label == null) {
            throw new PageDataException("Label not found");
        }
        deValue.setLabel(label);
        deValue.setValue(value);
        deValue.setSelected(value);
        deValue.setSize(size);
        this.filterValues.add(deValue);
    }

    public void addSubtitleFilter(String name, String label, boolean visualizzaSottosezioneAperta) throws PageDataException {
        if (this.filterNames == null) {
            this.filterNames = new ArrayList<DataElement>();
            this.filterValues = new ArrayList<DataElement>();
        }
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName(PageData.getParametroFilterName(this.filterNames.size()));
        if (name == null) {
            throw new PageDataException("Name not found");
        }
        deName.setValue(name);
        this.filterNames.add(deName);
        DataElement deValue = new DataElement();
        deValue.setType(DataElementType.SUBTITLE);
        deValue.setName(PageData.getParametroFilterValue(this.filterValues.size()));
        if (label == null) {
            throw new PageDataException("Label not found");
        }
        deValue.setLabel(label);
        deValue.setStatoAperturaSezioni(visualizzaSottosezioneAperta ? DataElement.STATO_APERTURA_SEZIONI.APERTO : DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
        this.filterValues.add(deValue);
    }

    public void impostaAperturaSubtitle(String name, Boolean visualizzaSottosezioneAperta, String postbackElementName) throws PageDataException {
        if (name == null) {
            throw new PageDataException("Param name is null");
        }
        if (this.filterNames != null) {
            int idxSubtitle = -1;
            for (int i = 0; i < this.filterNames.size(); ++i) {
                if (!name.equals(this.filterNames.get(i).getValue())) continue;
                idxSubtitle = i;
                break;
            }
            if (visualizzaSottosezioneAperta == null && idxSubtitle > -1) {
                DataElement de;
                int i;
                ArrayList<DataElement> filterValuesToCheck = new ArrayList<DataElement>();
                for (i = idxSubtitle + 1; i < this.filterNames.size() && !(de = this.filterValues.get(i)).getType().equals("subtitle"); ++i) {
                    filterValuesToCheck.add(de);
                }
                visualizzaSottosezioneAperta = this.hasAlmostOneFilterDefined(filterValuesToCheck);
                if (postbackElementName != null) {
                    for (i = 0; i < filterValuesToCheck.size(); ++i) {
                        if (!((DataElement)filterValuesToCheck.get(i)).getName().equals(postbackElementName)) continue;
                        visualizzaSottosezioneAperta = true;
                        break;
                    }
                }
            }
            if (visualizzaSottosezioneAperta != null) {
                this.updateSubtitleFilter(name, visualizzaSottosezioneAperta);
            }
        }
    }

    public void updateSubtitleFilter(String name, boolean visualizzaSottosezioneAperta) {
        if (this.filterNames != null) {
            for (int i = 0; i < this.filterNames.size(); ++i) {
                if (!name.equals(this.filterNames.get(i).getValue())) continue;
                this.filterValues.get(i).setStatoAperturaSezioni(visualizzaSottosezioneAperta ? DataElement.STATO_APERTURA_SEZIONI.APERTO : DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
                break;
            }
        }
    }

    public void addHiddenFilter(String name, String value, int size) throws PageDataException {
        if (this.filterNames == null) {
            this.filterNames = new ArrayList<DataElement>();
            this.filterValues = new ArrayList<DataElement>();
        }
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName(PageData.getParametroFilterName(this.filterNames.size()));
        if (name == null) {
            throw new PageDataException("Name not found");
        }
        deName.setValue(name);
        this.filterNames.add(deName);
        DataElement deValue = new DataElement();
        deValue.setType(DataElementType.HIDDEN);
        deValue.setName(PageData.getParametroFilterValue(this.filterValues.size()));
        deValue.setLabel(deValue.getName());
        deValue.setValue(value);
        deValue.setSize(size);
        this.filterValues.add(deValue);
    }

    public void updateFilter(String name, String value) {
        if (this.filterNames != null) {
            for (int i = 0; i < this.filterNames.size(); ++i) {
                if (!name.equals(this.filterNames.get(i).getValue())) continue;
                this.filterValues.get(i).setValue(value);
                break;
            }
        }
    }

    public void removeFilter(String name) {
        if (this.filterNames != null) {
            for (int i = 0; i < this.filterNames.size(); ++i) {
                if (!name.equals(this.filterNames.get(i).getValue())) continue;
                this.filterNames.remove(i);
                this.filterValues.remove(i);
                break;
            }
        }
    }

    @Deprecated
    public void setFilterNames(List<DataElement> filterNames) {
        this.filterNames = filterNames;
    }

    public List<DataElement> getFilterNames() {
        return this.filterNames;
    }

    @Deprecated
    public void setFilterValues(List<DataElement> filterValues) {
        this.filterValues = filterValues;
    }

    public List<DataElement> getFilterValues() {
        return this.filterValues;
    }

    public boolean hasAlmostOneFilterDefined() {
        return this.hasAlmostOneFilterDefined(this.filterValues);
    }

    private boolean hasAlmostOneFilterDefined(List<DataElement> filterValuesToCheck) {
        if (filterValuesToCheck != null) {
            for (DataElement de : filterValuesToCheck) {
                if (de.getType().equals("hidden") || de.getValue() == null || "".equals(de.value) || "clientORserver".equals(de.value)) continue;
                return true;
            }
        }
        return false;
    }

    public void setPageSize(int i) {
        this.pageSize = i;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public void setNumEntries(int i) {
        this.numEntries = i;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public boolean isPageBodyEmpty() {
        if (!this.dati.isEmpty()) {
            int nonHidden = 0;
            for (int i = 0; i < this.dati.size(); ++i) {
                Object o = this.dati.get(i);
                if (o instanceof DataElement) {
                    DataElement de = (DataElement)o;
                    if (de.getType().equals(DataElementType.HIDDEN.toString())) continue;
                    ++nonHidden;
                    continue;
                }
                if (!(o instanceof List)) continue;
                List v = (List)o;
                for (int j = 0; j < v.size(); ++j) {
                    DataElement de;
                    Object o02 = v.get(j);
                    if (!(o02 instanceof DataElement) || (de = (DataElement)o02).getType().equals(DataElementType.HIDDEN.toString())) continue;
                    ++nonHidden;
                }
            }
            return nonHidden == 0;
        }
        if (this.mode.equals("view")) {
            return false;
        }
        return this.mode.equals("view-noeditbutton") || this.mode.equals("view-nobutton");
    }

    public boolean isMostraLinkHome() {
        return this.mostraLinkHome;
    }

    public void setMostraLinkHome(boolean mostraLinkHome) {
        this.mostraLinkHome = mostraLinkHome;
    }

    public List<String> getLinkHomeLabels() {
        return this.linkHomeLabels;
    }

    public void setLinkHomeLabels(String pre, String labelLink, String post) {
        this.linkHomeLabels = new ArrayList<String>();
        this.linkHomeLabels.add(StringUtils.isNotBlank((CharSequence)pre) ? pre : "");
        this.linkHomeLabels.add(StringUtils.isNotBlank((CharSequence)labelLink) ? labelLink : "home");
        this.linkHomeLabels.add(StringUtils.isNotBlank((CharSequence)post) ? post : "");
    }

    public List<String> getDefaultLinkHomeLabels() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Torna alla ");
        l.add("home");
        l.add(".");
        return l;
    }

    public String getCustomListViewName() {
        return this.customListViewName;
    }

    public void setCustomListViewName(String customListViewName) {
        this.customListViewName = customListViewName;
    }

    public String getLabelBottoneInvia() {
        return this.labelBottoneInvia;
    }

    public void setLabelBottoneInvia(String labelBottoneInvia) {
        this.labelBottoneInvia = labelBottoneInvia;
    }

    public String getLabelBottoneFiltra() {
        return this.labelBottoneFiltra;
    }

    public void setLabelBottoneFiltra(String labelBottoneFiltra) {
        this.labelBottoneFiltra = labelBottoneFiltra;
    }

    public String getLabelBottoneRipulsci() {
        return this.labelBottoneRipulsci;
    }

    public void setLabelBottoneRipulsci(String labelBottoneRipulsci) {
        this.labelBottoneRipulsci = labelBottoneRipulsci;
    }

    public String getLabelBottoneCustom() {
        return this.labelBottoneCustom;
    }

    public void setLabelBottoneCustom(String labelBottoneCustom) {
        this.labelBottoneCustom = labelBottoneCustom;
    }

    public String getFunzioneBottoneCustom() {
        return this.funzioneBottoneCustom;
    }

    public void setFunzioneBottoneCustom(String funzioneBottoneCustom) {
        this.funzioneBottoneCustom = funzioneBottoneCustom;
    }

    public void setFunzioneBottoneCustomDefault(String nomeButton) {
        this.funzioneBottoneCustom = "customAction(document.form,'" + nomeButton + "');";
    }

    public boolean isShowAjaxStatusBottoneInvia() {
        return this.showAjaxStatusBottoneInvia;
    }

    public void setShowAjaxStatusBottoneInvia(boolean showAjaxStatusBottoneInvia) {
        this.showAjaxStatusBottoneInvia = showAjaxStatusBottoneInvia;
    }

    public void setDisabilitaAjaxStatusBottoneInvia() {
        this.showAjaxStatusBottoneInvia = false;
    }

    public boolean isShowAjaxStatusBottoneFiltra() {
        return this.showAjaxStatusBottoneFiltra;
    }

    public void setShowAjaxStatusBottoneFiltra(boolean showAjaxStatusBottoneFiltra) {
        this.showAjaxStatusBottoneFiltra = showAjaxStatusBottoneFiltra;
    }

    public void setDisabilitaAjaxStatusBottoneFiltra() {
        this.showAjaxStatusBottoneFiltra = false;
    }

    public boolean isShowAjaxStatusBottoneRipulisci() {
        return this.showAjaxStatusBottoneRipulisci;
    }

    public void setShowAjaxStatusBottoneRipulisci(boolean showAjaxStatusBottoneRipulisci) {
        this.showAjaxStatusBottoneRipulisci = showAjaxStatusBottoneRipulisci;
    }

    public void setDisabilitaAjaxStatusBottoneRipulisci() {
        this.showAjaxStatusBottoneRipulisci = false;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog dialog) {
        this.messageType = MessageType.DIALOG.toString();
        this.dialog = dialog;
        if (this.dialog != null) {
            this.message = this.dialog.getTitolo();
            this.messageTitle = this.dialog.getTitolo();
        }
    }

    public boolean isPostBackResult() {
        return this.postBackResult;
    }

    public void setPostBackResult(boolean postBackResult) {
        this.postBackResult = postBackResult;
    }

    public boolean isIncludiMenuLateraleSx() {
        return this.includiMenuLateraleSx;
    }

    public void setIncludiMenuLateraleSx(boolean includiMenuLateraleSx) {
        this.includiMenuLateraleSx = includiMenuLateraleSx;
    }

    public DataElement convertiSearchInTextFilterMetadata() {
        DataElement deName = new DataElement();
        deName.setType(DataElementType.HIDDEN);
        deName.setName("__fake__search__");
        deName.setValue("search");
        return deName;
    }

    public DataElement convertiSearchInTextFilter() {
        String searchDescriptionCheck = this.getSearchDescription();
        String searchLabelName = this.getSearchLabel();
        boolean searchNoteCheck = this.isSearchNote();
        DataElement deValue = new DataElement();
        deValue.setType(DataElementType.TEXT_EDIT);
        deValue.setName("search");
        deValue.setLabel(searchLabelName);
        deValue.setValue(searchDescriptionCheck);
        deValue.setSize(Costanti.SEARCH_PARAMETER_DEFAULT_SIZE);
        if (searchNoteCheck && !searchDescriptionCheck.equals("")) {
            deValue.setNote(MessageFormat.format("Attenzione! &Egrave; attualmente impostato il filtro di ricerca con la stringa ''${0}''", searchDescriptionCheck));
        }
        return deValue;
    }

    public boolean isPaginazione() {
        return this.paginazione;
    }

    public void setPaginazione(boolean paginazione) {
        this.paginazione = paginazione;
    }

    public List<DataElement> getComandiAzioneBarraTitoloDettaglioElemento() {
        return this.comandiAzioneBarraTitoloDettaglioElemento;
    }

    public void addComandoResetCacheElementoButton(String servletName, List<Parameter> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        parameters.add(new Parameter("postBackElementName", "rmElFromCache"));
        parameters.add(new Parameter("isPostback", "true"));
        parameters.add(new Parameter("edit-mode", "in_progress_postback"));
        this.addAzioneBarraTitoloDettaglioElemento(this.getComandiAzioneBarraTitoloDettaglioElemento(), DataElementType.IMAGE, "Rimuovi dalla cache", "&#xE863;", servletName, parameters);
    }

    public void addComandoVerificaCertificatiElementoButton(String servletName, List<Parameter> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        parameters.add(new Parameter("isPostback", "true"));
        parameters.add(new Parameter("edit-mode", "in_progress_postback"));
        this.addAzioneBarraTitoloDettaglioElemento(this.getComandiAzioneBarraTitoloDettaglioElemento(), DataElementType.IMAGE, "Verifica certificati", "&#xEA17;", servletName, parameters);
    }

    public void addComandoVerificaConnettivitaElementoButton(String servletName, List<Parameter> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        parameters.add(new Parameter("isPostback", "true"));
        parameters.add(new Parameter("edit-mode", "in_progress_postback"));
        this.addAzioneBarraTitoloDettaglioElemento(this.getComandiAzioneBarraTitoloDettaglioElemento(), DataElementType.IMAGE, "Verifica connettivit\u00e0", "&#xE8BE;", servletName, parameters);
    }

    public void addComandoElementoCheUtilizzaServizioCondivisoButton(String iconaButton, String tooltipButton, String titoloModale, String bodyModale, String servletName, List<Parameter> parameters, String inUsoType) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        ServletUtils.addAjaxButton(this.getComandiAzioneBarraTitoloDettaglioElemento(), DataElementType.IMAGE, iconaButton, tooltipButton, titoloModale, bodyModale, true, servletName, parameters, inUsoType);
    }

    public void addComandoVisualizzaRuntimeElementoButton(String servletName, List<Parameter> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        parameters.add(new Parameter("isPostback", "true"));
        parameters.add(new Parameter("edit-mode", "in_progress_postback"));
        this.addAzioneBarraTitoloDettaglioElemento(this.getComandiAzioneBarraTitoloDettaglioElemento(), DataElementType.IMAGE, "Visualizza runtime", "&#xE880;", servletName, parameters);
    }

    public void addComandoInUsoElementoButton(String servletName, String titolo, String id, String inUsoType, String tooltip, String icon, String headerRiga1, Boolean resizable, Boolean draggable) {
        ServletUtils.addInUsoButton(servletName, this.getComandiAzioneBarraTitoloDettaglioElemento(), DataElementType.IMAGE, titolo, id, inUsoType, tooltip, icon, headerRiga1, resizable, draggable, true);
    }

    public void addComandoAggiornaRicercaButton(String servletName, List<Parameter> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        parameters.add(new Parameter("postBackElementName", "aggiornaRicerca"));
        parameters.add(new Parameter("isPostback", "true"));
        parameters.add(new Parameter("edit-mode", "in_progress_postback"));
        this.addAzioneBarraTitoloDettaglioElemento(this.getComandiAzioneBarraTitoloDettaglioElemento(), DataElementType.IMAGE, "Aggiorna Ricerca", "&#xE863;", servletName, parameters, false);
    }

    private void addAzioneBarraTitoloDettaglioElemento(List<DataElement> e, DataElementType deType, String tooltip, String icon, String servletName, List<Parameter> parameters) {
        this.addAzioneBarraTitoloDettaglioElemento(e, deType, tooltip, icon, servletName, parameters, true);
    }

    private void addAzioneBarraTitoloDettaglioElemento(List<DataElement> e, DataElementType deType, String tooltip, String icon, String servletName, List<Parameter> parameters, boolean contextMenu) {
        DataElement de = new DataElement();
        de.setType(deType);
        de.setToolTip(tooltip);
        if (parameters != null && !parameters.isEmpty()) {
            de.setUrl(servletName, parameters.toArray(new Parameter[parameters.size()]));
        } else {
            de.setUrl(servletName);
        }
        de.setIcon(icon);
        de.setContextMenu(contextMenu);
        e.add(de);
    }

    public boolean isInserisciSearch() {
        return this.inserisciSearch;
    }

    public void nascondiTextFilterAutomatico() {
        this.setInserisciSearch(false);
    }

    public void setInserisciSearch(boolean inserisciSearch) {
        this.inserisciSearch = inserisciSearch;
    }

    public List<String> getIdsDaVisualizzareSelezionati() {
        return this.idsDaVisualizzareSelezionati;
    }

    public void setIdsDaVisualizzareSelezionati(List<String> idsDaVisualizzareSelezionati) {
        this.idsDaVisualizzareSelezionati = idsDaVisualizzareSelezionati;
    }

    public void setNascondiButtonRowLogin(boolean nascondiButtonRowLogin) {
        this.nascondiButtonRowLogin = nascondiButtonRowLogin;
    }

    public boolean isNascondiButtonRowLogin() {
        return this.nascondiButtonRowLogin;
    }
}

