/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementConfirm;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.Dialog;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.GeneralLink;
import org.openspcoop2.web.lib.mvc.ListElement;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.mvc.properties.beans.ConfigBean;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class ServletUtils {
    private ServletUtils() {
    }

    public static ActionForward getStrutsForwardError(Logger log, Throwable e, PageData pd, HttpServletRequest request, HttpSession session, GeneralData gd, ActionMapping mapping, String objectName, ForwardParams forwardType) {
        return ServletUtils.getStrutsForwardError(log, e, pd, request, session, gd, mapping, objectName, forwardType, "Il sistema &egrave; momentaneamente indisponibile.");
    }

    public static ActionForward getStrutsForwardError(Logger log, Throwable e, PageData pd, HttpServletRequest request, HttpSession session, GeneralData gd, ActionMapping mapping, String objectName, ForwardParams forwardType, String message) {
        if (e != null) {
            log.error("SistemaNonDisponibile: " + e.getMessage(), e);
        } else {
            log.error("SistemaNonDisponibile");
        }
        pd.disableEditMode();
        pd.setMessage(message);
        pd.setMostraLinkHome(true);
        ServletUtils.setErrorStatusCodeInRequestAttribute(request, ServletUtils.getErrorStatusCodeFromException(e));
        ServletUtils.setGeneralAndPageDataIntoSession(request, session, gd, pd);
        return ServletUtils.getStrutsForwardGeneralError(mapping, objectName, forwardType);
    }

    public static HttpStatus getErrorStatusCodeFromException(Throwable t) {
        Throwable validationEx;
        if (Utilities.existsInnerException((Throwable)t, ValidationException.class) && (validationEx = Utilities.getInnerInstanceException((Throwable)t, ValidationException.class, (boolean)true)) != null) {
            return HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.SERVICE_UNAVAILABLE;
    }

    private static String getStrutsForwardName(String objectName, ForwardParams forwardParams) {
        Object forward = objectName;
        if (TipoOperazione.ADD.equals((Object)forwardParams.getTipoOperazione())) {
            forward = (String)forward + "Add";
        } else if (TipoOperazione.CHANGE.equals((Object)forwardParams.getTipoOperazione())) {
            forward = (String)forward + "Change";
        } else if (TipoOperazione.DEL.equals((Object)forwardParams.getTipoOperazione())) {
            forward = (String)forward + "Del";
        } else if (TipoOperazione.LIST.equals((Object)forwardParams.getTipoOperazione())) {
            forward = (String)forward + "List";
        } else if (TipoOperazione.OTHER.equals((Object)forwardParams.getTipoOperazione())) {
            forward = (String)forward + forwardParams.getOtherContext();
        }
        return forward;
    }

    public static ActionForward getStrutsForwardEditModeInProgress(ActionMapping mapping, String objectName, ForwardParams forwardParams) {
        return mapping.findForward(ServletUtils.getStrutsForwardName(objectName, forwardParams) + "Form");
    }

    public static ActionForward getStrutsForwardEditModeConfirm(ActionMapping mapping, String objectName, ForwardParams forwardParams) {
        return mapping.findForward(ServletUtils.getStrutsForwardName(objectName, forwardParams) + "ConfirmForm");
    }

    public static ActionForward getStrutsForwardEditModeFinished(ActionMapping mapping, String objectName, ForwardParams forwardParams) {
        return mapping.findForward(ServletUtils.getStrutsForwardName(objectName, forwardParams) + "Ok");
    }

    public static ActionForward getStrutsForwardEditModeCheckError(ActionMapping mapping, String objectName, ForwardParams forwardParams) {
        return mapping.findForward(ServletUtils.getStrutsForwardName(objectName, forwardParams) + "CheckError");
    }

    public static ActionForward getStrutsForwardGeneralError(ActionMapping mapping, String objectName, ForwardParams forwardParams) {
        if (forwardParams != null) {
            // empty if block
        }
        return mapping.findForward(objectName + "Error");
    }

    public static ActionForward getStrutsForward(ActionMapping mapping, String objectName, ForwardParams forwardParams) {
        return mapping.findForward(ServletUtils.getStrutsForwardName(objectName, forwardParams));
    }

    public static ActionForward getStrutsForward(ActionMapping mapping, String objectName, ForwardParams forwardParams, String suffix) {
        return mapping.findForward(ServletUtils.getStrutsForwardName(objectName, forwardParams) + suffix);
    }

    public static String boolToCheckBoxStatus(Boolean value) {
        if (value == null) {
            value = false;
        }
        return value != false ? "yes" : "no";
    }

    public static boolean isCheckBoxEnabled(String value) {
        return "yes".equals(value) || "true".equalsIgnoreCase(value) || "abilitato".equalsIgnoreCase(value);
    }

    public static void setCheckBox(DataElement de, String checkBoxValue) {
        if (ServletUtils.isCheckBoxEnabled(checkBoxValue)) {
            de.setSelected("yes");
        } else {
            de.setSelected("no");
        }
    }

    public static void setCheckBox(DataElement de, boolean checkBoxValue) {
        if (checkBoxValue) {
            de.setSelected("yes");
        } else {
            de.setSelected("no");
        }
    }

    public static DataElement getDataElementForEditModeInProgress() {
        return Costanti.DATA_ELEMENT_HIDDENT_EDIT_MODE_IN_PROGRESS;
    }

    public static DataElement getDataElementForEditModeFinished() {
        return Costanti.DATA_ELEMENT_HIDDENT_EDIT_MODE_END;
    }

    public static Parameter getParameterForEditModeFinished() {
        return Costanti.PARAMETER_EDIT_MODE_END;
    }

    public static boolean isEditModeInProgress(String editMode) {
        return !"end".equals(editMode);
    }

    public static boolean isEditModeFinished(String editMode) {
        return !"end".equals(editMode);
    }

    public static boolean isSearchDone(IConsoleHelper consoleHelper) {
        try {
            String v = consoleHelper.getParameter("_searchDone");
            return "true".equals(v);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Parameter getParameterAggiungi() {
        return new Parameter("Aggiungi", null);
    }

    public static void setPageDataTitleServletFirst(PageData pd, String t1Label, String t1Url) {
        ServletUtils.setPageDataTitle(pd, new Parameter(t1Label, t1Url));
    }

    public static void setPageDataTitleServletAdd(PageData pd, String t1Label, String t1Url) {
        ServletUtils.setPageDataTitle(pd, new Parameter(t1Label, t1Url), new Parameter("Aggiungi", null));
    }

    public static void setPageDataTitleServletChange(PageData pd, String t1Label, String t1Url, String t2Label) {
        ServletUtils.setPageDataTitle(pd, new Parameter(t1Label, t1Url), new Parameter(t2Label, null));
    }

    public static void setPageDataTitle(PageData pd, List<Parameter> listaParametri) {
        ServletUtils.setPageDataTitle(pd, listaParametri.toArray(new Parameter[listaParametri.size()]));
    }

    public static void setPageDataTitle(PageData pd, Parameter ... param) {
        ServletUtils.setPageDataTitle(pd, false, param);
    }

    public static void appendPageDataTitle(PageData pd, Parameter ... param) {
        ServletUtils.setPageDataTitle(pd, true, param);
    }

    private static void setPageDataTitle(PageData pd, boolean append, Parameter ... param) {
        List<GeneralLink> titlelist = null;
        titlelist = !append ? new ArrayList<GeneralLink>() : pd.getTitleList();
        for (int i = 0; i < param.length; ++i) {
            GeneralLink tl = new GeneralLink();
            if (param[i].getName() != null) {
                tl.setLabel(param[i].getName());
            }
            if (param[i].getValue() != null) {
                tl.setUrl(param[i].getValue());
            }
            titlelist.add(tl);
        }
        pd.setTitleList(titlelist);
    }

    public static void disableEditMode(PageData pd) {
        pd.disableEditMode();
    }

    public static void enabledPageDataSearch(PageData pd, String soggetto, String search) {
        pd.setSearch("on");
        pd.setSearchDescription(soggetto + " contenenti la stringa '" + search + "'");
    }

    public static void disabledPageDataSearch(PageData pd) {
        pd.setSearch("off");
    }

    public static void setDataElementVisualizzaLabel(DataElement de) {
        ServletUtils.setDataElementVisualizzaLabel(de, null);
    }

    public static void setDataElementVisualizzaLabel(DataElement de, Long count) {
        if (count != null) {
            de.setValue("visualizza(" + count + ")");
        } else {
            de.setValue("visualizza");
        }
    }

    public static void setDataElementVisualizzaCustomLabel(DataElement de, String customLabel) {
        ServletUtils.setDataElementVisualizzaCustomLabel(de, customLabel, null);
    }

    public static void setDataElementVisualizzaCustomLabel(DataElement de, String customLabel, Long count) {
        if (count != null) {
            de.setValue("visualizza " + customLabel + " (" + count + ")");
        } else {
            de.setValue("visualizza " + customLabel);
        }
    }

    public static void setDataElementCustomLabel(DataElement de, String customLabel) {
        ServletUtils.setDataElementCustomLabel(de, customLabel, null, null);
    }

    public static void setDataElementCustomLabel(DataElement de, String customLabel, Long count) {
        ServletUtils.setDataElementCustomLabel(de, customLabel, count, null);
    }

    public static void setDataElementCustomLabel(DataElement de, String customLabel, String msg) {
        ServletUtils.setDataElementCustomLabel(de, customLabel, null, msg);
    }

    public static void setDataElementCustomLabel(DataElement de, String customLabel, Long count, String msg) {
        if (count != null) {
            de.setValue(customLabel + " (" + count + ")");
        } else if (msg != null) {
            de.setValue(customLabel + " (" + msg + ")");
        } else {
            de.setValue(customLabel);
        }
    }

    public static String getTabIdFromRequestAttribute(HttpServletRequest request) {
        Object idTabObj = request.getAttribute("__tabKey__");
        if (idTabObj != null) {
            return (String)idTabObj;
        }
        return null;
    }

    public static void addListElementIntoSession(HttpServletRequest request, HttpSession session, String objectName, List<Parameter> parameters) {
        Parameter[] parameter = parameters != null ? parameters.toArray(new Parameter[parameters.size()]) : null;
        ServletUtils.addListElementIntoSession(request, session, objectName, parameter);
    }

    public static void addListElementIntoSession(HttpServletRequest request, HttpSession session, String objectName, Parameter ... parameter) {
        ListElement listElement = new ListElement();
        listElement.setOggetto(objectName);
        if (parameter != null && parameter.length > 0) {
            for (int i = 0; i < parameter.length; ++i) {
                if (parameter[i].getValue() == null) {
                    listElement.addParameter(parameter[i].getName(), "");
                    continue;
                }
                listElement.addParameter(parameter[i].getName(), parameter[i].getValue());
            }
        }
        ServletUtils.setObjectIntoSession(request, session, listElement, "_tabKey_ListElement");
    }

    public static void setGeneralAndPageDataIntoSession(HttpServletRequest request, HttpSession session, GeneralData gd, PageData pd) {
        ServletUtils.setObjectIntoSession(request, session, gd, "_tabKey_GeneralData");
        ServletUtils.setObjectIntoSession(request, session, pd, "_tabKey_PageData");
    }

    public static PageData getPageDataFromSession(HttpServletRequest request, HttpSession session) {
        return ServletUtils.getObjectFromSession(request, session, PageData.class, "_tabKey_PageData");
    }

    public static boolean existsSearchObjectFromSession(HttpServletRequest request, HttpSession session) {
        return ServletUtils.getObjectFromSession(request, session, ISearch.class, "_tabKey_Ricerca") != null;
    }

    public static ISearch getSearchObjectFromSession(HttpServletRequest request, HttpSession session, Class<?> searchImpl) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ISearch ricerca = ServletUtils.getObjectFromSession(request, session, ISearch.class, "_tabKey_Ricerca");
        if (ricerca == null) {
            ricerca = (ISearch)ClassLoaderUtilities.newInstance(searchImpl);
        }
        return ricerca;
    }

    public static void setSearchObjectIntoSession(HttpServletRequest request, HttpSession session, ISearch ricerca) {
        ServletUtils.setObjectIntoSession(request, session, ricerca, "_tabKey_Ricerca");
    }

    public static void removeSearchObjectFromSession(HttpServletRequest request, HttpSession session) {
        ServletUtils.removeObjectFromSession(request, session, ISearch.class, "_tabKey_Ricerca");
    }

    public static String getSearchFromSession(ISearch ricerca, int idLista) {
        return "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
    }

    private static String getKeyRisultatiRicerca(int idLista) {
        return "_tabKey_RisultatiLista_" + idLista;
    }

    public static void setRisultatiRicercaIntoSession(HttpServletRequest request, HttpSession session, int idLista, List<?> risultatiRicerca) {
        ServletUtils.setObjectIntoSession(request, session, risultatiRicerca, ServletUtils.getKeyRisultatiRicerca(idLista));
    }

    public static <T> List<T> getRisultatiRicercaFromSession(HttpServletRequest request, HttpSession session, int idLista, Class<T> classType) {
        if (classType != null) {
            // empty if block
        }
        return ServletUtils.getObjectFromSession(request, session, List.class, ServletUtils.getKeyRisultatiRicerca(idLista));
    }

    public static List<?> removeRisultatiRicercaFromSession(HttpServletRequest request, HttpSession session, int idLista) {
        List<?> returnNull = null;
        List o = ServletUtils.removeObjectFromSession(request, session, List.class, ServletUtils.getKeyRisultatiRicerca(idLista));
        if (o != null) {
            return o;
        }
        return returnNull;
    }

    public static String getUserLoginFromSession(HttpSession session) {
        return (String)session.getAttribute("Login");
    }

    public static void setUserLoginIntoSession(HttpSession session, String userLogin) {
        session.setAttribute("Login", (Object)userLogin);
    }

    public static void removeUserLoginFromSession(HttpSession session) {
        session.removeAttribute("Login");
    }

    public static User getUserFromSession(HttpServletRequest request, HttpSession session) {
        return ServletUtils.getObjectFromSession(request, session, User.class, "_tabKey_User");
    }

    public static void setUserIntoSession(HttpServletRequest request, HttpSession session, User user) {
        ServletUtils.setObjectIntoSession(request, session, user, "_tabKey_User");
    }

    public static void removeUserFromSession(HttpServletRequest request, HttpSession session) {
        ServletUtils.removeObjectFromSession(request, session, "_tabKey_User");
    }

    public static Boolean getContaListeFromSession(HttpSession session) {
        return (Boolean)session.getAttribute("contaListe");
    }

    public static void setContaListeIntoSession(HttpSession session, Boolean contaListe) {
        session.setAttribute("contaListe", (Object)contaListe);
    }

    public static void removeContaListeFromSession(HttpSession session) {
        session.removeAttribute("contaListe");
    }

    public static Boolean getConfigurazioniPersonalizzateFromSession(HttpSession session) {
        return (Boolean)session.getAttribute("ConfigurazioniPersonalizzate");
    }

    public static BooleanNullable getBooleanAttributeFromSession(String attributeName, HttpSession session, HttpServletRequest request) {
        return ServletUtils.getBooleanAttributeFromSession(attributeName, session, request, null);
    }

    public static BooleanNullable getBooleanAttributeFromSession(String attributeName, HttpSession session, HttpServletRequest request, Boolean defaultValue) {
        Boolean obj = ServletUtils.getObjectFromSession(request, session, Boolean.class, attributeName);
        if (obj == null) {
            if (defaultValue == null) {
                return BooleanNullable.NULL();
            }
            return defaultValue != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
        }
        return obj != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
    }

    public static void setObjectIntoSession(HttpServletRequest request, HttpSession session, Object obj, String objectName) {
        if (objectName.startsWith("_tabKey_")) {
            String tabId = (String)request.getAttribute("__tabKey__");
            Map sessionMap = (ConcurrentHashMap)session.getAttribute("_tabKeysMap_");
            if (sessionMap == null) {
                sessionMap = new ConcurrentHashMap();
            }
            Map mapTabId = null;
            if (sessionMap.containsKey(tabId)) {
                mapTabId = (Map)sessionMap.get(tabId);
            } else {
                String prevTabId = request.getParameter("__prevTabKey__");
                prevTabId = Validatore.getInstance().validatePrevTabId(prevTabId);
                ServletUtils.copiaAttributiSessioneTab(session, prevTabId, tabId);
                sessionMap = (Map)session.getAttribute("_tabKeysMap_");
                mapTabId = (Map)sessionMap.get(tabId);
            }
            mapTabId.put(objectName, obj);
            session.setAttribute("_tabKeysMap_", sessionMap);
            return;
        }
        session.setAttribute(objectName, obj);
    }

    public static void removeObjectFromSession(HttpServletRequest request, HttpSession session, String objectName) {
        ServletUtils.removeObjectFromSession(request, session, null, objectName, false);
    }

    public static <T> T getObjectFromSession(HttpServletRequest request, HttpSession session, Class<T> objectClass, String objectName) {
        Object obj;
        if (objectName.startsWith("_tabKey_")) {
            String tabId = (String)request.getAttribute("__tabKey__");
            Map sessionMap = (ConcurrentHashMap)session.getAttribute("_tabKeysMap_");
            if (sessionMap == null) {
                sessionMap = new ConcurrentHashMap();
            }
            Map mapTabId = null;
            if (sessionMap.containsKey(tabId)) {
                mapTabId = (Map)sessionMap.get(tabId);
            } else {
                String prevTabId = request.getParameter("__prevTabKey__");
                prevTabId = Validatore.getInstance().validatePrevTabId(prevTabId);
                ServletUtils.copiaAttributiSessioneTab(session, prevTabId, tabId);
                sessionMap = (Map)session.getAttribute("_tabKeysMap_");
                mapTabId = (Map)sessionMap.get(tabId);
            }
            if (mapTabId.containsKey(objectName)) {
                return objectClass.cast(mapTabId.get(objectName));
            }
        }
        if ((obj = session.getAttribute(objectName)) == null) {
            return null;
        }
        return objectClass.cast(obj);
    }

    public static Object getObjectFromSession(HttpServletRequest request, HttpSession session, String objectName) {
        if (objectName.startsWith("_tabKey_")) {
            String tabId = (String)request.getAttribute("__tabKey__");
            Map sessionMap = (ConcurrentHashMap)session.getAttribute("_tabKeysMap_");
            if (sessionMap == null) {
                sessionMap = new ConcurrentHashMap();
            }
            Map mapTabId = null;
            if (sessionMap.containsKey(tabId)) {
                mapTabId = (Map)sessionMap.get(tabId);
            } else {
                String prevTabId = request.getParameter("__prevTabKey__");
                prevTabId = Validatore.getInstance().validatePrevTabId(prevTabId);
                ServletUtils.copiaAttributiSessioneTab(session, prevTabId, tabId);
                sessionMap = (Map)session.getAttribute("_tabKeysMap_");
                mapTabId = (Map)sessionMap.get(tabId);
            }
            if (mapTabId.containsKey(objectName)) {
                return mapTabId.get(objectName);
            }
        }
        return session.getAttribute(objectName);
    }

    public static String getStringAttributeFromSession(String attributeName, HttpSession session, HttpServletRequest request) {
        return ServletUtils.getObjectFromSession(request, session, String.class, attributeName);
    }

    public static Integer getIntegerAttributeFromSession(String attributeName, HttpSession session, HttpServletRequest request) {
        return ServletUtils.getObjectFromSession(request, session, Integer.class, attributeName);
    }

    public static void copiaAttributiSessioneTab(HttpSession session, String idSessioneTabSrc, String idSessioneTabDest) {
        ConcurrentHashMap<String, HashMap<String, Object>> sessionMap = (ConcurrentHashMap<String, HashMap<String, Object>>)session.getAttribute("_tabKeysMap_");
        if (sessionMap == null) {
            sessionMap = new ConcurrentHashMap<String, HashMap<String, Object>>();
        }
        Map<String, String> mapDest = null;
        if (StringUtils.isNotBlank((CharSequence)idSessioneTabSrc) && sessionMap.containsKey(idSessioneTabSrc)) {
            Map mapSrc = (Map)sessionMap.get(idSessioneTabSrc);
            mapDest = (HashMap<String, Object>)SerializationUtils.clone((Serializable)((HashMap)mapSrc));
        } else {
            Date date = new Date(0L);
            String idSessionTab = null;
            ArrayList<String> keys = new ArrayList<String>();
            for (String mapTabKey : sessionMap.keySet()) {
                keys.add(mapTabKey);
            }
            for (String idSessioneTmp : keys) {
                Map mapTmp = (Map)sessionMap.get(idSessioneTmp);
                Date dTmp = (Date)mapTmp.get("_tabKey_creation_date");
                if (!dTmp.after(date)) continue;
                date = dTmp;
                idSessionTab = idSessioneTmp;
            }
            if (idSessionTab != null) {
                Map mapSrc = (Map)sessionMap.get(idSessionTab);
                if (idSessioneTabSrc != null && idSessioneTabDest != null) {
                    mapDest = new HashMap();
                    if (mapSrc.containsKey("_tabKey_User")) {
                        mapDest.put("_tabKey_User", (String)mapSrc.get("_tabKey_User"));
                    }
                    if (mapSrc.containsKey("_tabKey_PageData")) {
                        mapDest.put("_tabKey_PageData", (String)mapSrc.get("_tabKey_PageData"));
                    }
                    if (mapSrc.containsKey("_tabKey_GeneralData")) {
                        mapDest.put("_tabKey_GeneralData", (String)mapSrc.get("_tabKey_GeneralData"));
                    }
                    mapDest.put("_tabKey_refresh_tabId", idSessioneTabDest);
                } else {
                    mapDest = (Map)((Object)SerializationUtils.clone((Serializable)((HashMap)mapSrc)));
                }
            } else {
                mapDest = new HashMap<String, Object>();
                mapDest.put("_tabKey_creation_tabId", idSessioneTabDest);
            }
        }
        mapDest.put("_tabKey_creation_date", (String)((Object)new Date()));
        mapDest.put("_tabKey_csrf", ServletUtils.generaTokenCSRF(idSessioneTabDest));
        sessionMap.put(idSessioneTabDest, (HashMap<String, Object>)mapDest);
        session.setAttribute("_tabKeysMap_", sessionMap);
    }

    public static <T> T removeObjectFromSession(HttpServletRequest request, HttpSession session, Class<T> objectClass, String objectName) {
        return ServletUtils.removeObjectFromSession(request, session, objectClass, objectName, true);
    }

    private static <T> T removeObjectFromSession(HttpServletRequest request, HttpSession session, Class<T> objectClass, String objectName, boolean returnValue) {
        Object obj;
        if (objectName.startsWith("_tabKey_")) {
            String tabId = (String)request.getAttribute("__tabKey__");
            ConcurrentHashMap sessionMap = (ConcurrentHashMap)session.getAttribute("_tabKeysMap_");
            if (sessionMap == null) {
                sessionMap = new ConcurrentHashMap();
            }
            ArrayList<String> keys = new ArrayList<String>();
            for (String mapTabKey : sessionMap.keySet()) {
                keys.add(mapTabKey);
            }
            Object obj2 = null;
            for (String mapTabKey : keys) {
                Map mapTabId = (Map)sessionMap.get(mapTabKey);
                if (tabId.equals(mapTabKey)) {
                    obj2 = mapTabId.remove(objectName);
                    continue;
                }
                mapTabId.remove(objectName);
            }
            if (obj2 != null && returnValue) {
                return objectClass.cast(obj2);
            }
        }
        if ((obj = session.getAttribute(objectName)) != null) {
            session.removeAttribute(objectName);
            if (returnValue) {
                return objectClass.cast(obj);
            }
        }
        return null;
    }

    public static String getParametersAsString(boolean createFirstParameter, Parameter ... parameter) {
        StringBuilder sb = new StringBuilder();
        if (parameter != null && parameter.length > 0) {
            if (createFirstParameter) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            for (int i = 0; i < parameter.length; ++i) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(parameter[i].toString());
            }
        }
        return sb.toString();
    }

    public static void removeCookieFromResponse(String cookieName, HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(cookieName)) continue;
                String contextPath = request.getContextPath();
                cookies[i].setPath(contextPath);
                cookies[i].setMaxAge(0);
                cookies[i].setValue("NO_DATA");
                cookies[i].setVersion(0);
                response.addCookie(cookies[i]);
                break;
            }
        }
    }

    public static void saveConfigurazioneBeanIntoSession(HttpServletRequest request, HttpSession session, ConfigBean configurazioneBean, String objectName) {
        ServletUtils.setObjectIntoSession(request, session, configurazioneBean, "oldConfProp_" + objectName);
    }

    public static void removeConfigurazioneBeanFromSession(HttpServletRequest request, HttpSession session, String objectName) {
        ServletUtils.removeObjectFromSession(request, session, "oldConfProp_" + objectName);
    }

    public static ConfigBean readConfigurazioneBeanFromSession(HttpServletRequest request, HttpSession session, String objectName) {
        return ServletUtils.getObjectFromSession(request, session, ConfigBean.class, "oldConfProp_" + objectName);
    }

    public static void addInUsoButton(String servletName, List<DataElement> e, DataElementType deType, String titolo, String id, String inUsoType, String tooltip, String icon, String headerRiga1, Boolean resizable, Boolean draggable, boolean contextMenu) {
        DataElement de = new DataElement();
        de.setType(deType);
        de.setToolTip(tooltip);
        de.setWidthPx(15);
        de.setContextMenu(contextMenu);
        Dialog deDialog = new Dialog();
        deDialog.setIcona(icon);
        deDialog.setTitolo(titolo);
        deDialog.setHeaderRiga1(headerRiga1);
        if (resizable != null) {
            deDialog.setResizable(resizable);
        }
        if (draggable != null) {
            deDialog.setDraggable(draggable);
        }
        deDialog.setWidth("800px");
        Dialog.BodyElement bodyElementURL = new Dialog().new Dialog.BodyElement();
        bodyElementURL.setType(DataElementType.HIDDEN);
        bodyElementURL.setName("url");
        Parameter pIdOggetto = new Parameter("idOggetto", id);
        Parameter pTipoOggetto = new Parameter("tipoOggetto", inUsoType);
        Parameter pTipoRisposta = new Parameter("tipoRisposta", "text");
        bodyElementURL.setUrl(servletName, pIdOggetto, pTipoOggetto, pTipoRisposta);
        deDialog.setUrlElement(bodyElementURL);
        Dialog.BodyElement bodyElement = new Dialog().new Dialog.BodyElement();
        bodyElement.setType(DataElementType.TEXT_AREA);
        bodyElement.setLabel("");
        bodyElement.setValue("");
        bodyElement.setRows(15);
        if (resizable != null) {
            bodyElement.setResizable(resizable);
        }
        deDialog.addBodyElement(bodyElement);
        de.setDialog(deDialog);
        e.add(de);
    }

    public static void addAjaxButton(List<DataElement> e, DataElementType deType, String icon, String tooltip, String titolo, String body, boolean contextMenu, String servletName, List<Parameter> parameters, String inUsoType) {
        DataElement de = new DataElement();
        de.setType(deType);
        de.setIcon(icon);
        de.setToolTip(tooltip);
        de.setWidthPx(15);
        de.setContextMenu(contextMenu);
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        parameters.add(new Parameter("tipoOggetto", inUsoType));
        parameters.add(new Parameter("tipoRisposta", "text"));
        de.setUrl(servletName, parameters.toArray(new Parameter[parameters.size()]));
        DataElementConfirm confirm = new DataElementConfirm();
        confirm.setTitolo(titolo);
        confirm.setBody(body);
        de.setConfirm(confirm);
        e.add(de);
    }

    public static void generaESalvaTokenCSRF(HttpServletRequest request, HttpSession session) {
        String uuId = UUID.randomUUID().toString();
        String nuovoToken = ServletUtils.generaTokenCSRF(uuId);
        ServletUtils.setObjectIntoSession(request, session, nuovoToken, "_tabKey_csrf");
    }

    public static String generaTokenCSRF(String sessionTabID) {
        return sessionTabID + "_" + System.currentTimeMillis();
    }

    public static String leggiTokenCSRF(HttpServletRequest request, HttpSession session) {
        return ServletUtils.getObjectFromSession(request, session, String.class, "_tabKey_csrf");
    }

    public static boolean verificaTokenCSRF(String tokenToCheck, HttpServletRequest request, HttpSession session, Integer validitaTokenCsrf) {
        String csfrTokenFromSession = ServletUtils.leggiTokenCSRF(request, session);
        return ServletUtils.verificaTokenCSRF(tokenToCheck, csfrTokenFromSession, validitaTokenCsrf);
    }

    public static boolean verificaTokenCSRF(String tokenToCheck, String csfrTokenFromSession, Integer validitaTokenCsrf) {
        if (tokenToCheck == null) {
            return false;
        }
        if (!ServletUtils.verificaSintassiTokenCsrf(tokenToCheck)) {
            return false;
        }
        if (!tokenToCheck.equals(csfrTokenFromSession)) {
            return false;
        }
        if (validitaTokenCsrf != null) {
            long rif;
            String[] split = tokenToCheck.split("_");
            String millisSToCheck = split[1];
            long sogliaMS = validitaTokenCsrf.longValue() * 1000L;
            long now = System.currentTimeMillis();
            return now < (rif = sogliaMS + Long.parseLong(millisSToCheck));
        }
        return true;
    }

    public static boolean checkCsrfParameter(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        return ServletUtils.verificaSintassiTokenCsrf(parameterValueFiltrato);
    }

    private static boolean verificaSintassiTokenCsrf(String token) {
        String[] split = token.split("_");
        if (split == null || split.length != 2) {
            return false;
        }
        try {
            UUID.fromString(split[0]);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return false;
        }
        try {
            Long.parseLong(split[1]);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return false;
        }
        return true;
    }

    public static boolean checkTabKeyParameter(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        try {
            UUID.fromString(parameterValueFiltrato);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return false;
        }
        return true;
    }

    public static boolean checkIntegerParameter(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        try {
            Integer.parseInt(parameterValueFiltrato);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean checkLongParameter(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        try {
            Long.parseLong(parameterValueFiltrato);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean checkBooleanParameter(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        return "yes".equals(parameterValueFiltrato) || "no".equals(parameterValueFiltrato) || "abilitato".equals(parameterValueFiltrato) || "disabilitato".equals(parameterValueFiltrato) || "true".equals(parameterValueFiltrato) || "false".equals(parameterValueFiltrato);
    }

    public static boolean checkParametro(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        return !StringUtils.isEmpty((CharSequence)parameterValueFiltrato);
    }

    public static boolean checkParametroResetSearch(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        return "yes".equals(parameterValueFiltrato) || "no".equals(parameterValueFiltrato);
    }

    public static boolean checkParametroAzione(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        return "salva".equals(parameterValueFiltrato) || "removeEntries".equals(parameterValueFiltrato) || "conferma".equals(parameterValueFiltrato) || "annulla".equals(parameterValueFiltrato);
    }

    public static boolean checkParametroEditMode(HttpServletRequest request, String parameterToCheck) {
        String parameterValueFiltrato = request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        return "in_progress_postback".equals(parameterValueFiltrato) || "in_progress".equals(parameterValueFiltrato) || "end".equals(parameterValueFiltrato);
    }

    public static boolean validaParametroResourcePath(HttpServletRequest request, String parameterToCheck) {
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        try {
            Validatore.getInstance().validate("Il valore del parametro [" + parameterToCheck + "]:[" + parameterValueOriginale + "]", parameterValueOriginale, null, true, false, "HTTPParameterValueTextArea");
        }
        catch (ValidationException e) {
            return false;
        }
        return true;
    }

    public static boolean usaValidazioneTextArea(HttpServletRequest request, String parameterToCheck) {
        String parametroIdentificativi = Validatore.getInstance().getParametroOriginale(request, "__ta__");
        if (parametroIdentificativi != null) {
            try {
                Validatore.getInstance().validate("Il valore del parametro [__ta__]:[" + parametroIdentificativi + "]", parametroIdentificativi, false, "IdTextArea");
            }
            catch (ValidationException e) {
                return false;
            }
            String[] ids = parametroIdentificativi.split(",");
            if (ids != null && ids.length > 0) {
                List<String> asList = Arrays.asList(ids);
                return asList.contains(parameterToCheck);
            }
        } else if (parameterToCheck.startsWith("azCombo") || parameterToCheck.startsWith("descrizioneRicerca")) {
            return true;
        }
        return false;
    }

    public static String getIdentificativiTextArea(List<?> dati) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dati.size(); ++i) {
            Object deName;
            DataElement de = (DataElement)dati.get(i);
            Object object = deName = !de.getName().equals("") ? de.getName() : "de_name_" + i;
            if (!de.getType().equals("textarea") && !de.getType().equals("textarea-noedit")) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)deName);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static String getIdentificativiTextAreaFiltriRicerca(List<DataElement> filterValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filterValues.size(); ++i) {
            DataElement filtro = filterValues.get(i);
            String filterName = filtro.getName();
            if (!filtro.getType().equals("textarea") && !filtro.getType().equals("textarea-noedit")) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(filterName);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static String getJsonPair(String key, String val) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(key).append("\"").append(":");
        if (val != null) {
            sb.append("\"").append(val).append("\"");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public static String getJson(String ... pairs) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(pairs[i]);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public static void setErrorStatusCodeInRequestAttribute(HttpServletRequest request, HttpStatus httpStatus) {
        request.setAttribute("__setErrorCode__", (Object)httpStatus);
    }

    public static String normalizeId(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[:/@]", "_");
    }

    public static String buildInternalRedirectUrl(HttpServletRequest request, String destination) {
        boolean isStandardPort;
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        boolean bl = isStandardPort = "http".equals(scheme) && serverPort == 80 || "https".equals(scheme) && serverPort == 443;
        if (!isStandardPort) {
            url.append(":").append(serverPort);
        }
        if (destination.startsWith("/")) {
            url.append(contextPath).append(destination);
        } else {
            url.append(contextPath).append("/").append(destination);
        }
        return url.toString();
    }

    public static boolean isUtenteLoggatoConOAuth2(HttpSession session) {
        return session.getAttribute("oauthIdToken") != null;
    }

    public static HttpSession sessionFixation(Logger log, HttpServletRequest request, HttpSession session) {
        log.debug("Session Fixation Protection");
        log.debug("Old session id: {}", (Object)session.getId());
        String changeSessionId = request.changeSessionId();
        log.debug("New session id: {}", (Object)changeSessionId);
        HttpSession newSession = request.getSession(true);
        log.debug("New session id check: {}", (Object)(newSession != null ? newSession.getId() : "null"));
        log.debug("Session Fixation Protection - END");
        return newSession;
    }

    public static boolean isStaticResource(String uri, String[] paths) {
        if (uri == null || paths == null) {
            return false;
        }
        for (String path : paths) {
            if (path == null || uri.indexOf("/" + path) == -1) continue;
            return true;
        }
        return false;
    }

    public static String escapeHTMLAttribute(String value) {
        if (value == null || value.trim().isEmpty()) {
            return "";
        }
        Object sanitized = value;
        sanitized = ((String)sanitized).replaceAll("<[^>]+>", "");
        sanitized = ((String)sanitized).replaceAll("#{1,6}\\s+", "");
        sanitized = ((String)sanitized).replaceAll("[*_]{1,2}([^*_]+)[*_]{1,2}", "$1");
        sanitized = ((String)sanitized).replaceAll("\\[([^\\]]+)\\]\\([^)]+\\)", "$1");
        sanitized = ((String)sanitized).replace("&quot;", "\"");
        sanitized = ((String)sanitized).replace("&lt;", "<");
        sanitized = ((String)sanitized).replace("&gt;", ">");
        sanitized = ((String)sanitized).replace("&amp;", "&");
        sanitized = ((String)sanitized).replace("&nbsp;", " ");
        sanitized = ((String)sanitized).replace("\\-", "-");
        sanitized = ((String)sanitized).replace("\\>", ">");
        sanitized = ((String)sanitized).replaceAll("\\s+", " ");
        if (((String)(sanitized = ((String)sanitized).trim())).length() > 250) {
            sanitized = ((String)sanitized).substring(0, 247) + "...";
        }
        sanitized = StringEscapeUtils.escapeHtml4((String)sanitized);
        sanitized = ((String)sanitized).replace("&amp;#10;", "&#10;");
        return sanitized;
    }
}

