/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.properties.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_genericPropertiesDriver;
import org.openspcoop2.core.mvc.properties.Collection;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.Properties;
import org.openspcoop2.core.mvc.properties.Section;
import org.openspcoop2.core.mvc.properties.Subsection;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.IProvider;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.web.lib.mvc.properties.beans.ConfigBean;
import org.openspcoop2.web.lib.mvc.properties.beans.ItemBean;
import org.openspcoop2.web.lib.mvc.properties.beans.SectionBean;
import org.openspcoop2.web.lib.mvc.properties.beans.SubsectionBean;
import org.openspcoop2.web.lib.mvc.properties.exception.ValidationException;
import org.openspcoop2.web.lib.mvc.properties.utils.ValidationEngine;

public class ReadPropertiesUtilities {
    private ReadPropertiesUtilities() {
    }

    public static List<String> getListaNomiProperties(Config config) {
        ArrayList<String> lista = new ArrayList<String>();
        Properties properties = config.getProperties();
        if (properties != null) {
            List collectionList = properties.getCollectionList();
            for (Collection collection : collectionList) {
                lista.add(collection.getName());
            }
        }
        return lista;
    }

    public static ConfigBean leggiConfigurazione(Config config, Map<String, java.util.Properties> propertiesMap, ExternalResources externalResources) throws ValidationException, CoreException, ProviderException {
        IProvider provider = null;
        if (StringUtils.isNotEmpty((CharSequence)config.getProvider())) {
            try {
                provider = (IProvider)ClassLoaderUtilities.newInstance((String)config.getProvider());
            }
            catch (Exception e) {
                throw new CoreException("Errore durante l'istanziazione del provider [" + config.getProvider() + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        ConfigBean configurazione = new ConfigBean(provider);
        configurazione.setId(config.getId());
        ValidationEngine.validateConfig(config, externalResources);
        configurazione.getListaNomiProperties().addAll(ReadPropertiesUtilities.getListaNomiProperties(config));
        List sectionList = config.getSectionList();
        for (int i = 0; i < sectionList.size(); ++i) {
            Section section = (Section)sectionList.get(i);
            ReadPropertiesUtilities.addSectionBean(configurazione, section, "s" + i, propertiesMap, externalResources);
        }
        return configurazione;
    }

    public static void addSectionBean(ConfigBean configurazione, Section section, String sectionIdx, Map<String, java.util.Properties> propertiesMap, ExternalResources externalResources) throws ValidationException, ProviderException {
        SectionBean sectionBean = new SectionBean(section, sectionIdx, configurazione.getProvider());
        configurazione.addItem(sectionBean);
        if (section.getItemList() != null) {
            for (Item item : section.getItemList()) {
                ReadPropertiesUtilities.addItemBean(configurazione, item, propertiesMap, externalResources);
            }
        }
        if (section.getSubsectionList() != null) {
            for (int i = 0; i < section.getSubsectionList().size(); ++i) {
                Subsection subSection = (Subsection)section.getSubsectionList().get(i);
                ReadPropertiesUtilities.addSubsectionBean(configurazione, subSection, sectionIdx + "_ss" + i, propertiesMap, externalResources);
            }
        }
    }

    public static void addSubsectionBean(ConfigBean configurazione, Subsection subSection, String subsectionIdx, Map<String, java.util.Properties> propertiesMap, ExternalResources externalResources) throws ValidationException, ProviderException {
        SubsectionBean subsectionBean = new SubsectionBean(subSection, subsectionIdx, configurazione.getProvider());
        configurazione.addItem(subsectionBean);
        if (subSection.getItemList() != null) {
            for (Item item : subSection.getItemList()) {
                ReadPropertiesUtilities.addItemBean(configurazione, item, propertiesMap, externalResources);
            }
        }
    }

    public static void addItemBean(ConfigBean configurazione, Item item, Map<String, java.util.Properties> propertiesMap, ExternalResources externalResources) throws ProviderException, ValidationException {
        if (item == null) {
            throw new ProviderException("Item undefined");
        }
        if (configurazione == null) {
            throw new ProviderException("Config undefined");
        }
        if ((ItemType.LOCK.equals((Object)item.getType()) || ItemType.LOCK_HIDDEN.equals((Object)item.getType())) && configurazione.getId() != null && item.getProperty() != null && item.getProperty().getName() != null) {
            DriverConfigurazioneDB_genericPropertiesDriver.addConfidentialProperty((String)configurazione.getId(), (String)item.getProperty().getName());
        }
        ItemBean itemBean = new ItemBean(item, item.getName(), configurazione.getProvider());
        String name = item.getProperty() != null ? item.getProperty().getName() : item.getName();
        String collectionName = item.getProperty().getProperties();
        if (collectionName == null) {
            collectionName = "___defaultMap";
        }
        String propertyValue = ReadPropertiesUtilities.getPropertyValue(propertiesMap, name, collectionName);
        ReadPropertiesUtilities.addItemBean(item, propertiesMap, externalResources, propertyValue, name, itemBean, collectionName);
        configurazione.addItem(itemBean);
    }

    private static void addItemBean(Item item, Map<String, java.util.Properties> propertiesMap, ExternalResources externalResources, String propertyValue, String name, ItemBean itemBean, String collectionName) throws ProviderException {
        String propertiesKeysValues;
        if (item.getProperty() != null && item.getProperty().isAppend() && (propertiesKeysValues = ReadPropertiesUtilities.getPropertyValue(propertiesMap, "___" + name, collectionName)) != null && propertyValue != null) {
            String[] chiaviSalvate = propertiesKeysValues.split("_@@_");
            String[] propertyValueSplit = propertyValue.split(item.getProperty().getAppendSeparator());
            String propertyValueTmp = null;
            for (int j = 0; j < chiaviSalvate.length; ++j) {
                String key = chiaviSalvate[j];
                if (!key.equals(item.getName())) continue;
                propertyValueTmp = propertyValueSplit[j];
                break;
            }
            propertyValue = propertyValueTmp;
        }
        itemBean.init(propertyValue, externalResources);
    }

    public static String getPropertyValue(Map<String, java.util.Properties> propertiesMap, String key, String collectionName) {
        if (propertiesMap == null) {
            return null;
        }
        if (!propertiesMap.containsKey(collectionName)) {
            return null;
        }
        java.util.Properties p = propertiesMap.get(collectionName);
        return p.getProperty(key);
    }
}

