/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Safelist;
import org.openspcoop2.web.lib.mvc.security.InputSanitizerProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityWrappedHttpServletRequest;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;
import org.slf4j.Logger;

public class Validatore {
    private static Logger log;
    private SecurityProperties sc;
    private InputSanitizerProperties isp;
    private static Validatore instance;
    private Safelist safelist;

    public static synchronized void init(SecurityProperties sc, InputSanitizerProperties isp, Logger log) {
        if (Validatore.log == null) {
            Validatore.log = log;
        }
        if (instance == null) {
            instance = new Validatore(sc, isp);
        }
    }

    public static synchronized Validatore getInstance() {
        return instance;
    }

    private Validatore(SecurityProperties sc, InputSanitizerProperties isp) {
        this.sc = sc;
        this.isp = isp;
        this.safelist = this.isp.getSafelist();
    }

    public String validate(String oggetto, String valore, boolean nullable, String ... pattern) throws ValidationException {
        return this.validate(oggetto, valore, nullable, true, pattern);
    }

    public String validate(String oggetto, String valore, boolean nullable, boolean checkSqlInjection, String ... pattern) throws ValidationException {
        return this.validate(oggetto, valore, (Integer)0, null, nullable, checkSqlInjection, pattern);
    }

    public String validate(String oggetto, String valore, Integer maxLength, boolean nullable, String ... pattern) throws ValidationException {
        return this.validate(oggetto, valore, maxLength, nullable, true, pattern);
    }

    public String validate(String oggetto, String valore, Integer maxLength, boolean nullable, boolean checkSqlInjection, String ... pattern) throws ValidationException {
        return this.validate(oggetto, valore, (Integer)0, maxLength, nullable, checkSqlInjection, pattern);
    }

    public String validate(String oggetto, String valore, Integer minLength, Integer maxLength, boolean nullable, boolean checkSqlInjection, String ... pattern) throws ValidationException {
        ArrayList<Pattern> patternsToCheck = new ArrayList<Pattern>();
        for (int i = 0; i < pattern.length; ++i) {
            String pt = pattern[i];
            Pattern p = this.sc.getValidationPattern(pt);
            if (p == null) {
                throw new ValidationException("Non e' stata trovato un pattern di validazione per il tipo [" + StringUtils.join((Object[])pattern, (String)",") + "].");
            }
            patternsToCheck.add(p);
        }
        this.checkEmpty(oggetto, valore, nullable);
        this.checkLength(oggetto, valore, minLength, maxLength);
        this.checkPatterns(oggetto, valore, patternsToCheck);
        if (checkSqlInjection) {
            this.checkSqlInjection(oggetto, valore, this.sc.getValidationPattern("SQLInjection"));
        }
        return valore;
    }

    public String validateTabId(String idTab) {
        return this.validateTabId("IdTab", idTab);
    }

    public String validatePrevTabId(String idTab) {
        return this.validateTabId("PrevIdTab", idTab);
    }

    private String validateTabId(String oggetto, String idTab) {
        if (idTab != null) {
            try {
                return this.validate(oggetto, idTab, (Integer)36, false, true, "IDTab");
            }
            catch (ValidationException e) {
                log.warn("Valore [" + idTab + "] ricevuto per il parametro [" + oggetto + "] non valido: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String checkEmpty(String oggetto, String valore, boolean nullable) throws ValidationException {
        if (nullable) {
            return valore;
        }
        if (!StringUtils.isEmpty((CharSequence)valore)) {
            return valore;
        }
        throw new ValidationException(oggetto + " non puo' essere vuoto o null.");
    }

    private String checkLength(String oggetto, String valore, Integer minLength, Integer maxLength) throws ValidationException {
        if (minLength != null && valore.length() < minLength) {
            throw new ValidationException(oggetto + " non rispetta la lunghezza minima prevista di " + minLength + " caratteri.");
        }
        if (maxLength != null && valore.length() > maxLength) {
            throw new ValidationException(oggetto + " non rispetta la lunghezza massima prevista di " + maxLength + " caratteri.");
        }
        return valore;
    }

    private String checkPatterns(String oggetto, String valore, List<Pattern> patternsToCheck) throws ValidationException {
        for (Pattern p : patternsToCheck) {
            if (p.matcher(valore).matches()) continue;
            throw new ValidationException(oggetto + " non rispetta il pattern di validazione previsto [" + p.pattern() + "].");
        }
        return valore;
    }

    private String checkSqlInjection(String oggetto, String valore, Pattern pattern) throws ValidationException {
        if (pattern.matcher(valore).find()) {
            throw new ValidationException(oggetto + " non rispetta il pattern di validazione previsto [" + pattern.pattern() + "].");
        }
        return valore;
    }

    public boolean verificaEsistenzaParametroOriginale(HttpServletRequest request, String parametro) {
        return this.getParametroOriginale(request, parametro) != null;
    }

    public String getParametroOriginale(HttpServletRequest request, String parametro) {
        if (request instanceof SecurityWrappedHttpServletRequest) {
            SecurityWrappedHttpServletRequest secReq = (SecurityWrappedHttpServletRequest)request;
            return secReq.getOriginalParameter(parametro);
        }
        return request.getParameter(parametro);
    }

    public String getParametroSanificato(String originalValue, boolean usaValidazioneTextArea) {
        if (originalValue == null) {
            return null;
        }
        String valueToClean = originalValue.replace("&", "&amp;");
        Document.OutputSettings os = new Document.OutputSettings().prettyPrint(false);
        if (usaValidazioneTextArea) {
            return originalValue;
        }
        return Entities.unescape((String)Jsoup.parse((String)Jsoup.clean((String)valueToClean, (String)"", (Safelist)this.safelist, (Document.OutputSettings)os)).body().html());
    }
}

