/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.jboss.logging.Logger;

public class ByteUtil {
    public static final String NON_ASCII_STRING = "@@@@@";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final String prefix = "^\\s*(\\d+)\\s*";
    private static final String suffix = "(b)?\\s*$";
    private static final Pattern ONE = Pattern.compile("^\\s*(\\d+)\\s*(b)?\\s*$", 2);
    private static final Pattern KILO = Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2);
    private static final Pattern MEGA = Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2);
    private static final Pattern GIGA = Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2);

    public static void debugFrame(Logger logger2, String message, ByteBuf byteIn) {
        if (logger2.isTraceEnabled()) {
            int location = byteIn.readerIndex();
            byte[] frame = new byte[byteIn.writerIndex()];
            byteIn.readBytes(frame);
            try {
                logger2.trace((Object)(message + "\n" + ByteUtil.formatGroup(ByteUtil.bytesToHex(frame), 8, 16)));
            }
            catch (Exception e) {
                logger2.warn((Object)e.getMessage(), (Throwable)e);
            }
            byteIn.readerIndex(location);
        }
    }

    public static String formatGroup(String str, int groupSize, int lineBreak) {
        StringBuffer buffer = new StringBuffer();
        int line = 1;
        buffer.append("/*  1 */ \"");
        for (int i = 0; i < str.length(); i += groupSize) {
            buffer.append(str.substring(i, i + Math.min(str.length() - i, groupSize)));
            if ((i + groupSize) % lineBreak == 0) {
                buffer.append("\" +\n/* ");
                if (++line < 10) {
                    buffer.append(" ");
                }
                buffer.append(Integer.toString(line) + " */ \"");
                continue;
            }
            if ((i + groupSize) % groupSize != 0 || str.length() - i <= groupSize) continue;
            buffer.append("\" + \"");
        }
        buffer.append("\";");
        return buffer.toString();
    }

    public static String maxString(String value, int size) {
        if (value.length() < size) {
            return value;
        }
        return value.substring(0, size / 2) + " ... " + value.substring(value.length() - size / 2);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String bytesToHex(byte[] bytes, int groupSize) {
        char[] hexChars = new char[bytes.length * 2 + ByteUtil.numberOfGroups(bytes, groupSize)];
        int outPos = 0;
        for (int j = 0; j < bytes.length; ++j) {
            if (j > 0 && j % groupSize == 0) {
                hexChars[outPos++] = 32;
            }
            int v = bytes[j] & 0xFF;
            hexChars[outPos++] = hexArray[v >>> 4];
            hexChars[outPos++] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String toSimpleString(byte[] bytes) {
        SimpleString simpleString = new SimpleString(bytes);
        String value = simpleString.toString();
        for (char c : value.toCharArray()) {
            if (c >= ' ' && c <= '\u007f') continue;
            return NON_ASCII_STRING;
        }
        return value;
    }

    private static int numberOfGroups(byte[] bytes, int groupSize) {
        int groups = bytes.length / groupSize;
        if (bytes.length % groupSize == 0) {
            --groups;
        }
        return groups;
    }

    public static byte[] longToBytes(long x) {
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.heapBuffer(8, 8);
        buffer.writeLong(x);
        return buffer.array();
    }

    public static byte[] hexToBytes(String hexStr) {
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hexStr.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String readLine(ActiveMQBuffer buffer) {
        StringBuilder sb = new StringBuilder("");
        char c = buffer.readChar();
        while (c != '\n') {
            sb.append(c);
            c = buffer.readChar();
        }
        return sb.toString();
    }

    public static byte[] getActiveArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            System.arraycopy(array, buffer.arrayOffset() + buffer.position(), ret, 0, ret.length);
        } else {
            buffer.slice().get(ret);
        }
        return ret;
    }

    public static long convertTextBytes(String text) {
        try {
            Matcher m = ONE.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1));
            }
            m = KILO.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1)) * 1024L;
            }
            m = MEGA.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1)) * 1024L * 1024L;
            }
            m = GIGA.matcher(text);
            if (m.matches()) {
                return Long.parseLong(m.group(1)) * 1024L * 1024L * 1024L;
            }
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            throw ActiveMQUtilBundle.BUNDLE.failedToParseLong(text);
        }
    }
}

