/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.config;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ajax4jsf.config.FilterMapping;
import org.ajax4jsf.config.ParsingException;
import org.ajax4jsf.config.ServletBean;
import org.ajax4jsf.config.ServletMapping;
import org.ajax4jsf.config.WebappHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WebXMLParser {
    public static final String WEB_XML = "/WEB-INF/web.xml";
    private String _facesFilterPrefix = null;
    private String _facesFilterSuffix = null;
    private String _facesServletPrefix = null;
    private String _facesServletSuffix = null;
    private List<String> facesServletMappings;
    private List<String> filterMappings;
    static final String FACES_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";

    public void init(InputStream webXml, String filterName) throws ParsingException {
        try {
            String asSuffix;
            String asPrefix;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            WebappHandler webappHandler = new WebappHandler(reader);
            reader.setContentHandler(webappHandler);
            reader.setEntityResolver(webappHandler);
            reader.setErrorHandler(webappHandler);
            reader.setDTDHandler(webappHandler);
            reader.parse(new InputSource(webXml));
            for (ServletBean servlet : webappHandler.getServlets()) {
                if (!FACES_SERVLET_CLASS.equals(servlet.getClassName())) continue;
                this.facesServletMappings = new ArrayList<String>();
                for (ServletMapping mapping : webappHandler.getServletMappings()) {
                    if (!servlet.getName().equals(mapping.getServletName())) continue;
                    this.facesServletMappings.add(mapping.getUrlPattern());
                    asPrefix = this.getAsPrefix(mapping.getUrlPattern());
                    if (null != asPrefix) {
                        this._facesServletPrefix = asPrefix;
                    }
                    if (null == (asSuffix = this.getAsSuffix(mapping.getUrlPattern()))) continue;
                    this._facesServletSuffix = asSuffix;
                }
            }
            this.filterMappings = new ArrayList<String>();
            for (FilterMapping mapping : webappHandler.getFilterMappings()) {
                if (!mapping.getFilterName().equals(filterName)) continue;
                if (null != mapping.getUrlPattern() && !"".equals(mapping.getUrlPattern())) {
                    String asSuffix2;
                    this.filterMappings.add(mapping.getUrlPattern());
                    String asPrefix2 = this.getAsPrefix(mapping.getUrlPattern());
                    if (null != asPrefix2) {
                        this._facesFilterPrefix = asPrefix2;
                    }
                    if (null == (asSuffix2 = this.getAsSuffix(mapping.getUrlPattern()))) continue;
                    this._facesFilterSuffix = asSuffix2;
                    continue;
                }
                if (null == mapping.getServletName() || "".equals(mapping.getServletName())) continue;
                for (ServletMapping servletMapping : webappHandler.getServletMappings()) {
                    if (!mapping.getServletName().equals(servletMapping.getServletName())) continue;
                    this.filterMappings.add(servletMapping.getUrlPattern());
                    asPrefix = this.getAsPrefix(servletMapping.getUrlPattern());
                    if (null != asPrefix) {
                        this._facesFilterPrefix = asPrefix;
                    }
                    if (null == (asSuffix = this.getAsSuffix(servletMapping.getUrlPattern()))) continue;
                    this._facesFilterSuffix = asSuffix;
                }
            }
            if (0 == this.filterMappings.size()) {
                throw new ParsingException("No filter mapping set for a filter " + filterName);
            }
        }
        catch (IOException e) {
            throw new ParsingException("Error read web application config", e);
        }
        catch (ParserConfigurationException e) {
            throw new ParsingException("SAX Parser configuration error", e);
        }
        catch (SAXException e) {
            throw new ParsingException("Error parsing XML for the web application config", e);
        }
    }

    private String getAsSuffix(String urlPattern) {
        String suffix = null;
        if (urlPattern.startsWith("*")) {
            suffix = urlPattern.substring(1);
        }
        return suffix;
    }

    private String getAsPrefix(String urlPattern) {
        String preffix = null;
        if (urlPattern.endsWith("*")) {
            int cut = urlPattern.endsWith("/*") ? 2 : 1;
            preffix = urlPattern.substring(0, urlPattern.length() - cut);
        }
        return preffix;
    }

    public List<String> getFacesServletMappings() {
        return this.facesServletMappings;
    }

    public String getFacesFilterPrefix() {
        return this._facesFilterPrefix;
    }

    public String getFacesFilterSuffix() {
        return this._facesFilterSuffix;
    }

    public String getFacesServletPrefix() {
        return this._facesServletPrefix;
    }

    public String getFacesServletSuffix() {
        return this._facesServletSuffix;
    }

    public void init(ServletContext portletContext, String filterName) throws ServletException {
        InputStream inputStream = portletContext.getResourceAsStream(WEB_XML);
        if (null != inputStream) {
            try {
                this.init(inputStream, filterName);
            }
            catch (ParsingException e1) {
                throw new ServletException("Error parse web application config", (Throwable)e1);
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

