/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import javax.faces.FacesException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ResponseWriterContentHandler
implements ContentHandler {
    private String linkClass;
    private Node node;

    public ResponseWriterContentHandler(String linkClass) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.node = document.createElement("head");
            document.appendChild(this.node);
        }
        catch (ParserConfigurationException e) {
            throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.linkClass = linkClass;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.node.appendChild(this.node.getOwnerDocument().createTextNode(new String(ch, start, length)));
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.node = this.node.getParentNode();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        Document document = this.node.getOwnerDocument();
        Element element = document.createElement(localName);
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            element.setAttribute(atts.getLocalName(i), atts.getValue(i));
        }
        if ("link".equals(localName)) {
            element.setAttribute("class", this.linkClass);
        }
        this.node = this.node.appendChild(element);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        throw new UnsupportedOperationException();
    }

    public Node[] getNodes() {
        NodeList childNodes = this.node.getChildNodes();
        Node[] list = new Node[childNodes.getLength()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = childNodes.item(i);
        }
        return list;
    }
}

